/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collection;
import java.util.Properties;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterFeature;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.server.common.Feature;
import org.junit.jupiter.api.Assertions;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ClusterTestDefaults(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\b\u0011\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006U\u0001!\ta\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006\u000f\u0002!\t\u0001\r\u0005\u00063\u0002!\t\u0001\r\u0005\u00067\u0002!\t\u0001\r\u0005\u0006;\u0002!\t\u0001\r\u0005\u0006?\u0002!\t\u0001\r\u0005\u0006C\u0002!\t\u0001\r\u0005\u0006G\u0002!\t\u0001\r\u0005\u0006]\u0002!\t\u0001\r\u0005\u0006m\u0002!\t\u0001\r\u0005\u0006q\u0002!\t\u0001\r\u0005\u0006u\u0002!Ia\u001f\u0002\"\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003#I\taa]3sm\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feB\u0011a\u0004K\u0007\u0002?)\u0011\u0001%I\u0001\u0005i\u0016\u001cHO\u0003\u0002#G\u000511m\\7n_:T!a\u0005\u0013\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0005\u0003S}\u0011qb\u00117vgR,'/\u00138ti\u0006t7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051r\u0003CA\u0017\u0001\u001b\u0005\u0001\u0002\"\u0002\u000f\u0003\u0001\u0004i\u0012A\u0011;fgR\u001cuN\\:v[\u0016\u0014xI]8va\"+\u0017M\u001d;cK\u0006$\u0018j]%oC\u000e\u001cWm]:jE2,w\u000b[3o\t&\u001c\u0018M\u00197fI\nK8\u000b^1uS\u000e\u001cuN\u001c4jOR\t\u0011\u0007\u0005\u0002\u0018e%\u00111\u0007\u0007\u0002\u0005+:LG\u000f\u000b\u0003\u0004kmb\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d \u0003\r\t\u0007/[\u0005\u0003u]\u00121b\u00117vgR,'\u000fV3ti\u0006\u00012/\u001a:wKJ\u0004&o\u001c9feRLWm\u001d\u0017\u0002{-*a(\u0011\"E\u000bB\u0011agP\u0005\u0003\u0001^\u0012Qc\u00117vgR,'oQ8oM&<\u0007K]8qKJ$\u00180A\u0002lKf\f\u0013aQ\u0001&OJ|W\u000f\u001d\u0018d_>\u0014H-\u001b8bi>\u0014hF]3cC2\fgnY3/aJ|Go\\2pYN\fQA^1mk\u0016\f\u0013AR\u0001\bG2\f7o]5d\u0003\u0005#Xm\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f\u001d%fCJ$(-Z1u\u0013NLe.Y2dKN\u001c\u0018N\u00197f/\",gNR3biV\u0014XM\u00127bO:{G/\u00128bE2,G\r\u000b\u0003\u0005k%S\u0015\u0001\u00034fCR,(/Z:-\u0003-[S\u0001T(Q/b\u0003\"AN'\n\u00059;$AD\"mkN$XM\u001d$fCR,(/Z\u0001\bM\u0016\fG/\u001e:fI\u0005\t\u0016B\u0001*T\u000359%kT+Q?Z+%kU%P\u001d*\u0011A+V\u0001\b\r\u0016\fG/\u001e:f\u0015\t\u0011cK\u0003\u0002\u0012G\u00059a/\u001a:tS>t7$\u0001\u0001\u0002\rR,7\u000f^\"p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;Jg\u0006\u001b7-Z:tS\ndWm\u00165f]:+wo\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:Jg\u0016s\u0017M\u00197fI\"\u0012Q!N\u00010i\u0016\u001cHoQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r^,ji\"\u0014VmZ;mCJ,\u0005\u0010\u001d:fgNLwN\u001c\u0015\u0003\rU\na\u0007^3ti\u000e{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR<\u0016\u000e\u001e5J]Z\fG.\u001b3SK\u001e,H.\u0019:FqB\u0014Xm]:j_:D#aB\u001b\u0002_Q,7\u000f^\"p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;XSRDW)\u001c9usN+(m]2sSB$\u0018n\u001c8)\u0005!)\u0014\u0001\u0014;fgR\u0014VM[8j]&twm\u0015;bi&\u001cW*Z7cKJ<U\r^:BgNLwM\\7f]R\u001c()Y2l/\",gNT3x\u000fJ|W\u000f]\"p_J$\u0017N\\1u_JL5/\u00128bE2,G\r\u000b\u0002\nk\u0005\u0001F/Z:u'R\fG/[2NK6\u0014WM\u001d*f[>4X\rZ!gi\u0016\u00148+Z:tS>tG+[7f_V$X\t\u001f9jef<\u0006.\u001a8OK^<%o\\;q\u0007>|'\u000fZ5oCR|'/S:F]\u0006\u0014G.\u001a3)\t))4(\u001a\u0017\u0003M.\\SAP!h\t&\f\u0013\u0001[\u0001\"OJ|W\u000f\u001d\u0018d_:\u001cX/\\3s]M,7o]5p]:\"\u0018.\\3pkRtSn]\u0011\u0002U\u0006!Q\u0007\r\u00192W\u0015q\u0014\t\u001c#jC\u0005i\u0017!J4s_V\u0004hfY8ogVlWM\u001d\u0018nS:t3/Z:tS>tg\u0006^5nK>,HOL7t\u0003A\"Xm\u001d;Va\u0012\fG/Z\"p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;D_:4\u0017nZ*vG\u000e,7o\u001d4vY\"\"1\"N\u001eqY\u0005\t8&\u0002 Be\u0012#\u0018%A:\u0002I\u001d\u0014x.\u001e9/G>t7/^7fe:BW-\u0019:uE\u0016\fGOL5oi\u0016\u0014h/\u00197/[N\f\u0013!^\u0001\u0005kA\u0002\u0004'A\"uKN$8i\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fGOR1jYV\u0014X-\u00134NK6\u0014WM]%e\u001b&\u001c8/\u001b8h\r>\u0014h+\u001a:tS>t7/\u00112pm\u0016\u0004\u0004F\u0001\u00076\u00039\"Xm\u001d;NK6\u0014WM]%e\u000f\u0016tWM]1uK\u0012|enU3sm\u0016\u0014x\u000b[3o\u0003BLg+\u001a:tS>t\u0017j\u001d\u0019)\u00055)\u0014!E2p]:,7\r^!oIJ+7-Z5wKR\u0019A0!\u0002\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018%\u0001\u0005sKF,Xm\u001d;t\u0013\r\t\u0019A \u0002\u001f\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+7\u000f]8og\u0016Dq!a\u0002\u000f\u0001\u0004\tI!A\u0004sKF,Xm\u001d;\u0011\u0007u\fY!C\u0002\u0002\u000ey\u0014QdQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e*fcV,7\u000f\u001e\u0015\u000b\u0001\u0005E\u0011qCA\rw\u0005\u0015\u0002c\u0001\u001c\u0002\u0014%\u0019\u0011QC\u001c\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:\u0002\u000bQL\b/Z:-\u0005\u0005mAEAA\u000f\u0013\u0011\ty\"!\t\u0002\u000b-\u0013\u0016I\u0012+\u000b\u0007\u0005\rr'\u0001\u0003UsB,G\u0006BA\u0014\u0003cYsAP!\u0002*\u0011\u000bi#\t\u0002\u0002,\u0005arN\u001a4tKR\u001ch\u0006^8qS\u000etc.^7/a\u0006\u0014H/\u001b;j_:\u001c\u0018EAA\u0018\u0003\u0005\t4f\u0002 B\u0003g!\u0015QF\u0011\u0003\u0003k\t\u0001e\u001c4gg\u0016$8O\f;pa&\u001cgF]3qY&\u001c\u0017\r^5p]:2\u0017m\u0019;pe\u0002")
public class ConsumerGroupHeartbeatRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic")})
    public void testConsumerGroupHeartbeatIsInaccessibleWhenDisabledByStaticConfig() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code()), (Object)consumerGroupHeartbeatResponse.data());
    }

    @ClusterTest(features={@ClusterFeature(feature=Feature.GROUP_VERSION, version=0)})
    public void testConsumerGroupHeartbeatIsInaccessibleWhenFeatureFlagNotEnabled() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code()), (Object)consumerGroupHeartbeatResponse.data());
    }

    /*
     * Unable to fully structure code
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled() {
        admin = this.cluster.admin();
        try {
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            var17_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var7_3 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((var18_6 = this.connectAndReceive(var17_2)).data().errorCode() == Errors.NONE.code())) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + var18_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var18_6.data().memberId());
            Assertions.assertEquals((int)1, (int)var18_6.data().memberEpoch());
            Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)var18_6.data().assignment());
            topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            var17_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(var18_6.data().memberId()).setMemberEpoch(var18_6.data().memberEpoch())).build();
            expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
            var18_6 = null;
            var13_9 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var18_6 = this.connectAndReceive(var17_2)).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v0 = var18_6.data().assignment();
                if (!(v0 != null ? v0.equals(expectedAssignment) == false : expectedAssignment != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not get partitions assigned. Last response " + var18_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)2, (int)var18_6.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var18_6.data().assignment());
            var17_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(var18_6.data().memberId()).setMemberEpoch(-1)).build();
            var18_6 = this.connectAndReceive(var17_2);
            Assertions.assertEquals((int)-1, (int)var18_6.data().memberEpoch());
        }
        finally {
            admin.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatWithRegularExpression() {
        admin = this.cluster.admin();
        try {
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            var22_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicRegex("foo*").setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var6_3 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((var23_6 = this.connectAndReceive(var22_2)).data().errorCode() == Errors.NONE.code())) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + var23_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var23_6.data().memberId());
            Assertions.assertEquals((int)1, (int)var23_6.data().memberEpoch());
            Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)var23_6.data().assignment());
            topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            var22_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(var23_6.data().memberId()).setMemberEpoch(var23_6.data().memberEpoch())).build();
            var24_8 = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
            var23_6 = null;
            var12_9 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var23_6 = this.connectAndReceive(var22_2)).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v0 = var23_6.data().assignment();
                if (!(v0 != null ? v0.equals(var24_8) == false : var24_8 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not get partitions assigned. Last response " + var23_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)2, (int)var23_6.data().memberEpoch());
            Assertions.assertEquals((Object)var24_8, (Object)var23_6.data().assignment());
            admin.deleteTopics((TopicCollection)TopicCollection.ofTopicIds((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicId, (List)Nil$.MODULE$)).asJava())).all().get();
            var22_2 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(var23_6.data().memberId()).setMemberEpoch(var23_6.data().memberEpoch())).build();
            var24_8 = new ConsumerGroupHeartbeatResponseData.Assignment();
            var23_6 = null;
            var18_12 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var23_6 = this.connectAndReceive(var22_2)).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v2 = var23_6.data().assignment();
                if (!(v2 != null ? v2.equals(var24_8) == false : var24_8 != null)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (v3) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not get partitions revoked. Last response " + var23_6 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)2, (int)var23_6.data().memberEpoch());
            Assertions.assertEquals((Object)var24_8, (Object)var23_6.data().assignment());
        }
        finally {
            admin.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatWithInvalidRegularExpression() {
        try (Admin admin = this.cluster.admin();){
            ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicRegex("[").setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest)).data().errorCode() == Errors.INVALID_REGULAR_EXPRESSION.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Did not receive the expected error. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((short)Errors.INVALID_REGULAR_EXPRESSION.code(), (short)consumerGroupHeartbeatResponse.data().errorCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatWithEmptySubscription() {
        try (Admin admin = this.cluster.admin();){
            ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicRegex("").setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest)).data().errorCode() == Errors.NONE.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Did not receive the expected successful response. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            consumerGroupHeartbeatResponse = null;
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest)).data().errorCode() == Errors.NONE.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)("Did not receive the expected successful response. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @ClusterTest
    public void testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled() {
        admin = this.cluster.admin();
        try {
            instanceId = "instanceId";
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            var19_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var9_4 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((var20_7 = this.connectAndReceive(var19_3)).data().errorCode() == Errors.NONE.code())) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Static member could not join the group successfully. Last response " + var20_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var20_7.data().memberId());
            Assertions.assertEquals((int)1, (int)var20_7.data().memberEpoch());
            Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)var20_7.data().assignment());
            topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            var19_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(var20_7.data().memberId()).setMemberEpoch(var20_7.data().memberEpoch())).build();
            expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
            var20_7 = null;
            var15_10 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var20_7 = this.connectAndReceive(var19_3)).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v0 = var20_7.data().assignment();
                if (!(v0 != null ? v0.equals(expectedAssignment) == false : expectedAssignment != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Static member could not get partitions assigned. Last response " + var20_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var20_7.data().memberId());
            Assertions.assertEquals((int)2, (int)var20_7.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var20_7.data().assignment());
            oldMemberId = var20_7.data().memberId();
            var19_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(var20_7.data().memberId()).setMemberEpoch(-2)).build();
            var20_7 = this.connectAndReceive(var19_3);
            Assertions.assertEquals((int)-2, (int)var20_7.data().memberEpoch());
            var19_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var20_7 = this.connectAndReceive(var19_3);
            Assertions.assertNotNull((Object)var20_7.data().memberId());
            Assertions.assertEquals((int)2, (int)var20_7.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var20_7.data().assignment());
            Assertions.assertNotEquals((Object)oldMemberId, (Object)var20_7.data().memberId());
        }
        finally {
            admin.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.session.timeout.ms", value="5001"), @ClusterConfigProperty(key="group.consumer.min.session.timeout.ms", value="5001")})
    public void testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled() {
        admin = this.cluster.admin();
        try {
            instanceId = "instanceId";
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            var24_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var8_4 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((var25_7 = this.connectAndReceive(var24_3)).data().errorCode() == Errors.NONE.code())) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + var25_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)var25_7.data().memberId());
            Assertions.assertEquals((int)1, (int)var25_7.data().memberEpoch());
            Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)var25_7.data().assignment());
            topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            var24_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(var25_7.data().memberId()).setMemberEpoch(var25_7.data().memberEpoch())).build();
            expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
            var25_7 = null;
            var14_10 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var25_7 = this.connectAndReceive(var24_3)).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v0 = var25_7.data().assignment();
                if (!(v0 != null ? v0.equals(expectedAssignment) == false : expectedAssignment != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (v1) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not get partitions assigned. Last response " + var25_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)2, (int)var25_7.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var25_7.data().assignment());
            var24_3 = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            var25_7 = this.connectAndReceive(var24_3);
            Assertions.assertEquals((short)Errors.UNRELEASED_INSTANCE_ID.code(), (short)var25_7.data().errorCode());
            var20_13 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if ((var25_7 = this.connectAndReceive(var24_3)).data().errorCode() != Errors.NONE.code()) ** GOTO lbl-1000
                v2 = var25_7.data().assignment();
                if (!(v2 != null ? v2.equals(expectedAssignment) == false : expectedAssignment != null)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (v3) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not re-join the group successfully. Last response " + var25_7 + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((int)4, (int)var25_7.data().memberEpoch());
            Assertions.assertEquals((Object)expectedAssignment, (Object)var25_7.data().assignment());
        }
        finally {
            admin.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.heartbeat.interval.ms", value="5000")})
    public void testUpdateConsumerGroupHeartbeatConfigSuccessful() {
        try (Admin admin = this.cluster.admin();){
            ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
            int newHeartbeatIntervalMs = 10000;
            String instanceId = "instanceId";
            String consumerGroupId = "grp";
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId(consumerGroupId).setMemberId(Uuid.randomUuid().toString()).setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest)).data().errorCode() == Errors.NONE.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)("Could not join the group successfully. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertNotNull((Object)consumerGroupHeartbeatResponse.data().memberId());
            Assertions.assertEquals((int)1, (int)consumerGroupHeartbeatResponse.data().memberEpoch());
            Assertions.assertEquals((int)5000, (int)consumerGroupHeartbeatResponse.data().heartbeatIntervalMs());
            ConfigResource resource = new ConfigResource(ConfigResource.Type.GROUP, consumerGroupId);
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("consumer.heartbeat.interval.ms", Integer.toString(newHeartbeatIntervalMs)), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId(consumerGroupId).setInstanceId(instanceId).setMemberId(consumerGroupHeartbeatResponse.data().memberId()).setMemberEpoch(consumerGroupHeartbeatResponse.data().memberEpoch())).build();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!((consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest)).data().errorCode() == Errors.NONE.code() && newHeartbeatIntervalMs == consumerGroupHeartbeatResponse.data().heartbeatIntervalMs())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)("Dynamic update consumer group config failed. Last response " + consumerGroupHeartbeatResponse + "."));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testConsumerGroupHeartbeatFailureIfMemberIdMissingForVersionsAbove0() {
        try (Admin admin = this.cluster.admin();){
            TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
            ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!(this.connectAndReceive(consumerGroupHeartbeatRequest).data().errorCode() == Errors.INVALID_REQUEST.code())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Should fail due to invalid member id.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testMemberIdGeneratedOnServerWhenApiVersionIs0() {
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse;
        Admin admin = this.cluster.admin();
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokers().values()).asScala().toSeq(), (Seq<ControllerServer>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllers().values()).asScala().toSeq());
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava())).build((short)0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest)).data().errorCode() == Errors.NONE.code())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Could not join the group successfully. Last response " + consumerGroupHeartbeatResponse + "."));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String memberId = consumerGroupHeartbeatResponse.data().memberId();
        Assertions.assertNotNull((Object)memberId);
        Assertions.assertFalse((boolean)memberId.isEmpty());
        admin.close();
    }

    private ConsumerGroupHeartbeatResponse connectAndReceive(ConsumerGroupHeartbeatRequest request) {
        return (ConsumerGroupHeartbeatResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ObjectRef consumerGroupHeartbeatRequest$1) {
        consumerGroupHeartbeatResponse$1.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$1.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$1) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ObjectRef consumerGroupHeartbeatRequest$1, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$1) {
        consumerGroupHeartbeatResponse$1.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$1.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$1) : expectedAssignment$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$1) {
        return "Could not get partitions assigned. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithRegularExpression$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2) {
        consumerGroupHeartbeatResponse$2.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithRegularExpression$2(ObjectRef consumerGroupHeartbeatResponse$2) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithRegularExpression$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2, ObjectRef expectedAssignment$2) {
        consumerGroupHeartbeatResponse$2.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().assignment();
            ConsumerGroupHeartbeatResponseData.Assignment assignment2 = (ConsumerGroupHeartbeatResponseData.Assignment)expectedAssignment$2.elem;
            if (!(assignment != null ? !assignment.equals(assignment2) : assignment2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithRegularExpression$4(ObjectRef consumerGroupHeartbeatResponse$2) {
        return "Could not get partitions assigned. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithRegularExpression$5(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2, ObjectRef expectedAssignment$2) {
        consumerGroupHeartbeatResponse$2.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().assignment();
            ConsumerGroupHeartbeatResponseData.Assignment assignment2 = (ConsumerGroupHeartbeatResponseData.Assignment)expectedAssignment$2.elem;
            if (!(assignment != null ? !assignment.equals(assignment2) : assignment2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithRegularExpression$6(ObjectRef consumerGroupHeartbeatResponse$2) {
        return "Could not get partitions revoked. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithInvalidRegularExpression$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$3, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$3) {
        consumerGroupHeartbeatResponse$3.elem = $this.connectAndReceive(consumerGroupHeartbeatRequest$3);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().errorCode() == Errors.INVALID_REGULAR_EXPRESSION.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithInvalidRegularExpression$2(ObjectRef consumerGroupHeartbeatResponse$3) {
        return "Did not receive the expected error. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithEmptySubscription$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$4, ObjectRef consumerGroupHeartbeatRequest$4) {
        consumerGroupHeartbeatResponse$4.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$4.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$4.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithEmptySubscription$2(ObjectRef consumerGroupHeartbeatResponse$4) {
        return "Did not receive the expected successful response. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$4.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatWithEmptySubscription$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$4, ObjectRef consumerGroupHeartbeatRequest$4) {
        consumerGroupHeartbeatResponse$4.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$4.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$4.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatWithEmptySubscription$4(ObjectRef consumerGroupHeartbeatResponse$4) {
        return "Did not receive the expected successful response. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$4.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$5, ObjectRef consumerGroupHeartbeatRequest$5) {
        consumerGroupHeartbeatResponse$5.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$5.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$5) {
        return "Static member could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$5, ObjectRef consumerGroupHeartbeatRequest$5, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$3) {
        consumerGroupHeartbeatResponse$5.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$5.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$3) : expectedAssignment$3 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$5) {
        return "Static member could not get partitions assigned. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$5.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$6, ObjectRef consumerGroupHeartbeatRequest$6) {
        consumerGroupHeartbeatResponse$6.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$6.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$6) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$6, ObjectRef consumerGroupHeartbeatRequest$6, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$4) {
        consumerGroupHeartbeatResponse$6.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$6.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$4) : expectedAssignment$4 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$6) {
        return "Could not get partitions assigned. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$5(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$6, ObjectRef consumerGroupHeartbeatRequest$6, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$4) {
        consumerGroupHeartbeatResponse$6.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$6.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$4) : expectedAssignment$4 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$6(ObjectRef consumerGroupHeartbeatResponse$6) {
        return "Could not re-join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$6.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateConsumerGroupHeartbeatConfigSuccessful$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$7, ObjectRef consumerGroupHeartbeatRequest$7) {
        consumerGroupHeartbeatResponse$7.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$7.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testUpdateConsumerGroupHeartbeatConfigSuccessful$2(ObjectRef consumerGroupHeartbeatResponse$7) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateConsumerGroupHeartbeatConfigSuccessful$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$7, ObjectRef consumerGroupHeartbeatRequest$7, int newHeartbeatIntervalMs$1) {
        consumerGroupHeartbeatResponse$7.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$7.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem).data().errorCode() == Errors.NONE.code() && newHeartbeatIntervalMs$1 == ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem).data().heartbeatIntervalMs();
    }

    public static final /* synthetic */ String $anonfun$testUpdateConsumerGroupHeartbeatConfigSuccessful$4(ObjectRef consumerGroupHeartbeatResponse$7) {
        return "Dynamic update consumer group config failed. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$7.elem + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatFailureIfMemberIdMissingForVersionsAbove0$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$8, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$8) {
        consumerGroupHeartbeatResponse$8.elem = $this.connectAndReceive(consumerGroupHeartbeatRequest$8);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$8.elem).data().errorCode() == Errors.INVALID_REQUEST.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatFailureIfMemberIdMissingForVersionsAbove0$2() {
        return "Should fail due to invalid member id.";
    }

    public static final /* synthetic */ boolean $anonfun$testMemberIdGeneratedOnServerWhenApiVersionIs0$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$9, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$9) {
        consumerGroupHeartbeatResponse$9.elem = $this.connectAndReceive(consumerGroupHeartbeatRequest$9);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$9.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testMemberIdGeneratedOnServerWhenApiVersionIs0$2(ObjectRef consumerGroupHeartbeatResponse$9) {
        return "Could not join the group successfully. Last response " + (ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$9.elem + ".";
    }

    public ConsumerGroupHeartbeatRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

