/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AbstractCreateTopicsRequestTest;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005i3Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)!\t\u0001C\u0001\u0007\")\u0001\n\u0001C\u0001\u0013\")a\n\u0001C\u0001\u001f\")A\u000b\u0001C\u0001+\n92I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0013)\taa]3sm\u0016\u0014(\"A\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011\u0001C\u0005\u0003#!\u0011q$\u00112tiJ\f7\r^\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0003\u0005\u0002\u0010\u0001\u0005iB/Z:u-\u0006d\u0017\u000eZ\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$8\u000f\u0006\u0002\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t!QK\\5u\u0011\u0015q\"\u00011\u0001 \u0003\u0019\tXo\u001c:v[B\u0011\u0001e\n\b\u0003C\u0015\u0002\"AI\r\u000e\u0003\rR!\u0001\n\u0007\u0002\rq\u0012xn\u001c;?\u0013\t1\u0013$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014\u001aQ\t\u00111\u0006\u0005\u0002-k5\tQF\u0003\u0002/_\u00051\u0001/\u0019:b[NT!\u0001M\u0019\u0002\u000f),\b/\u001b;fe*\u0011!gM\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002i\u0005\u0019qN]4\n\u0005Yj#!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"\"!\u0001\u000f @!\tID(D\u0001;\u0015\tYT&\u0001\u0005qe>4\u0018\u000eZ3s\u0013\ti$HA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0002\u0001\u0006\n\u0011)A\u0003le\u00064G/A\u000fuKN$XI\u001d:pe\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;t)\t9B\tC\u0003\u001f\u0007\u0001\u0007q\u0004\u000b\u0002\u0004W!\"1\u0001\u000f HY\u0005\u0001\u0015a\b;fgRLeN^1mS\u0012\u001c%/Z1uKR{\u0007/[2t%\u0016\fX/Z:ugR\u0011qC\u0013\u0005\u0006=\u0011\u0001\ra\b\u0015\u0003\t-BC\u0001\u0002\u001d?\u001b2\n\u0001)A\u0010uKN$8I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiZ+'o]5p]N$\"a\u0006)\t\u000by)\u0001\u0019A\u0010)\u0005\u0015Y\u0003\u0006B\u00039}Mc\u0013\u0001Q\u0001\u001fi\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\rV8qS\u000e$\"a\u0006,\t\u000by1\u0001\u0019A\u0010)\u0005\u0019Y\u0003\u0006\u0002\u00049}ec\u0013\u0001\u0011")
public class CreateTopicsRequestTest
extends AbstractCreateTopicsRequestTest {
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testValidCreateTopicsRequests(String quorum) {
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic1", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        Integer x$2 = Predef$.MODULE$.int2Integer(3);
        Integer x$3 = this.topicReq$default$2();
        Map<String, String> x$4 = this.topicReq$default$4();
        Map<Object, scala.collection.immutable.Seq<Object>> x$5 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic2", x$3, x$2, x$4, x$5), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic3", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        Map x$7 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$8 = this.topicReq$default$2();
        Integer x$9 = this.topicReq$default$3();
        Map<String, String> x$10 = this.topicReq$default$4();
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic4", x$8, x$9, x$10, (Map<Object, scala.collection.immutable.Seq<Object>>)x$7), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        Map x$12 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Map x$13 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}));
        Integer x$14 = this.topicReq$default$2();
        Integer x$15 = this.topicReq$default$3();
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic5", x$14, x$15, (Map<String, String>)x$13, (Map<Object, scala.collection.immutable.Seq<Object>>)x$12), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        Map x$17 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Integer x$18 = this.topicReq$default$2();
        Integer x$19 = this.topicReq$default$3();
        Map<String, String> x$20 = this.topicReq$default$4();
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic6", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("topic7", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("topic8", x$18, x$19, x$20, (Map<Object, scala.collection.immutable.Seq<Object>>)x$17), (List)Nil$.MODULE$))), this.topicsReq$default$2(), this.topicsReq$default$3()));
        Map x$22 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Integer x$23 = this.topicReq$default$2();
        Integer x$24 = this.topicReq$default$3();
        Map<String, String> x$25 = this.topicReq$default$4();
        .colon.colon x$26 = new .colon.colon((Object)this.topicReq("topic9", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("topic10", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("topic11", x$23, x$24, x$25, (Map<Object, scala.collection.immutable.Seq<Object>>)x$22), (List)Nil$.MODULE$)));
        Integer x$28 = this.topicsReq$default$2();
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)x$26, x$28, true));
        Integer x$30 = Predef$.MODULE$.int2Integer(-1);
        Integer x$31 = Predef$.MODULE$.int2Integer(-1);
        Map<String, String> x$32 = this.topicReq$default$4();
        Map<Object, scala.collection.immutable.Seq<Object>> x$33 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic12", x$31, x$30, x$32, x$33), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        Integer x$35 = Predef$.MODULE$.int2Integer(2);
        Integer x$36 = Predef$.MODULE$.int2Integer(-1);
        Map<String, String> x$37 = this.topicReq$default$4();
        Map<Object, scala.collection.immutable.Seq<Object>> x$38 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic13", x$36, x$35, x$37, x$38), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        Integer x$40 = Predef$.MODULE$.int2Integer(-1);
        Integer x$41 = Predef$.MODULE$.int2Integer(2);
        Map<String, String> x$42 = this.topicReq$default$4();
        Map<Object, scala.collection.immutable.Seq<Object>> x$43 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic14", x$41, x$40, x$42, x$43), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testErrorCreateTopicsRequests(String quorum) {
        String existingTopic = "existing-topic";
        this.createTopic(existingTopic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(existingTopic, this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, (Option<String>)new Some((Object)"Topic 'existing-topic' already exists.")))}))), this.validateErrorCreateTopicsRequests$default$3());
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-partitions", Predef$.MODULE$.int2Integer(-2), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2()))}))), false);
        Integer x$2 = Predef$.MODULE$.int2Integer(this.brokerCount() + 1);
        Integer x$3 = this.topicReq$default$2();
        Map<String, String> x$4 = this.topicReq$default$4();
        Map<Object, scala.collection.immutable.Seq<Object>> x$5 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-replication", x$3, x$2, x$4, x$5), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2()))}))), false);
        Map x$7 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"not.a.property"), (Object)"error")}));
        Integer x$8 = this.topicReq$default$2();
        Integer x$9 = this.topicReq$default$3();
        Map<Object, scala.collection.immutable.Seq<Object>> x$10 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-config", x$8, x$9, (Map<String, String>)x$7, x$10), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        Map x$12 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.format.version"), (Object)"invalid-value")}));
        Integer x$13 = this.topicReq$default$2();
        Integer x$14 = this.topicReq$default$3();
        Map<Object, scala.collection.immutable.Seq<Object>> x$15 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-config-value", x$13, x$14, (Map<String, String>)x$12, x$15), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config-value"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        Map x$17 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$18 = this.topicReq$default$2();
        Integer x$19 = this.topicReq$default$3();
        Map<String, String> x$20 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-assignment", x$18, x$19, x$20, (Map<Object, scala.collection.immutable.Seq<Object>>)x$17), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2()))}))), false);
        Integer x$22 = Predef$.MODULE$.int2Integer(this.brokerCount() + 1);
        Integer x$23 = this.topicReq$default$2();
        Map<String, String> x$24 = this.topicReq$default$4();
        Map<Object, scala.collection.immutable.Seq<Object>> x$25 = this.topicReq$default$5();
        Map x$27 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$28 = this.topicReq$default$2();
        Integer x$29 = this.topicReq$default$3();
        Map<String, String> x$30 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(existingTopic, this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("partial-partitions", Predef$.MODULE$.int2Integer(-2), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("partial-replication", x$23, x$22, x$24, x$25), (List)new .colon.colon((Object)this.topicReq("partial-assignment", x$28, x$29, x$30, (Map<Object, scala.collection.immutable.Seq<Object>>)x$27), (List)new .colon.colon((Object)this.topicReq("partial-none", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$))))), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-none"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false);
        this.validateTopicExists("partial-none");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testInvalidCreateTopicsRequests(String quorum) {
        Integer x$2 = Predef$.MODULE$.int2Integer(10);
        Integer x$3 = Predef$.MODULE$.int2Integer(3);
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        Map<String, String> x$5 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("bad-args-topic", x$2, x$3, x$5, (Map<Object, scala.collection.immutable.Seq<Object>>)x$4), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        Integer x$7 = Predef$.MODULE$.int2Integer(10);
        Integer x$8 = Predef$.MODULE$.int2Integer(3);
        Map x$9 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        Map<String, String> x$10 = this.topicReq$default$4();
        .colon.colon x$11 = new .colon.colon((Object)this.topicReq("bad-args-topic", x$7, x$8, x$10, (Map<Object, scala.collection.immutable.Seq<Object>>)x$9), (List)Nil$.MODULE$);
        Integer x$13 = this.topicsReq$default$2();
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)x$11, x$13, true), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTopicsRequestVersions(String quorum) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.CREATE_TOPICS.oldestVersion()), (int)ApiKeys.CREATE_TOPICS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            String topic = "topic_" + version;
            CreateTopicsRequestData data = new CreateTopicsRequestData();
            data.setTimeoutMs(10000);
            data.setValidateOnly(false);
            data.setTopics(new CreateTopicsRequestData.CreatableTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topicReq(topic, Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))), this.topicReq$default$5()), (List)Nil$.MODULE$)).asJava().iterator()));
            CreateTopicsRequest request = new CreateTopicsRequest.Builder(data).build((short)version);
            CreateTopicsResponseData.CreatableTopicResult topicResponse = this.sendCreateTopicRequest(request, this.adminSocketServer()).data().topics().find(topic);
            Assertions.assertNotNull((Object)topicResponse);
            Assertions.assertEquals((Object)topic, (Object)topicResponse.name());
            Assertions.assertEquals((short)Errors.NONE.code(), (short)topicResponse.errorCode());
            if (version >= 5) {
                Assertions.assertEquals((int)1, (int)topicResponse.numPartitions());
                Assertions.assertEquals((int)1, (int)topicResponse.replicationFactor());
                Option config = CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.configs()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CreateTopicsRequestTest.$anonfun$testCreateTopicsRequestVersions$2(x$1)));
                Assertions.assertTrue((boolean)config.isDefined());
                Assertions.assertEquals((Object)"2", (Object)((CreateTopicsResponseData.CreatableTopicConfigs)config.get()).value());
            } else {
                Assertions.assertEquals((int)-1, (int)topicResponse.numPartitions());
                Assertions.assertEquals((int)-1, (int)topicResponse.replicationFactor());
                Assertions.assertTrue((boolean)topicResponse.configs().isEmpty());
            }
            if (version >= 7) {
                Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicResponse.topicId());
                return;
            }
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicResponse.topicId());
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateClusterMetadataTopic(String quorum) {
        this.validateErrorCreateTopicsRequests(this.topicsReq((scala.collection.immutable.Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("__cluster_metadata", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"__cluster_metadata"), (Object)this.error(Errors.INVALID_REQUEST, (Option<String>)new Some((Object)"Creation of internal topic __cluster_metadata is prohibited.")))}))), this.validateErrorCreateTopicsRequests$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsRequestVersions$2(CreateTopicsResponseData.CreatableTopicConfigs x$1) {
        String string = x$1.name();
        String string2 = "min.insync.replicas";
        return string != null && string.equals(string2);
    }
}

