/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000514Aa\u0004\t\u0001+!)!\u0004\u0001C\u00017!9Q\u0004\u0001b\u0001\n\u0003r\u0002BB\u0013\u0001A\u0003%q\u0004C\u0004'\u0001\t\u0007I\u0011\t\u0010\t\r\u001d\u0002\u0001\u0015!\u0003 \u0011\u001dA\u0003A1A\u0005\u0002%BaA\r\u0001!\u0002\u0013Q\u0003bB\u001a\u0001\u0005\u0004%\tA\b\u0005\u0007i\u0001\u0001\u000b\u0011B\u0010\t\u000fU\u0002!\u0019!C\u0001m!1!\t\u0001Q\u0001\n]Bqa\u0011\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004E\u0001\u0001\u0006Ia\u000e\u0005\u0006\u000b\u0002!\tA\u0012\u0002\u001b\t\u0016\u001c8M]5cK2{w\rR5sgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003#I\taa]3sm\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011\u0001E\u0005\u00033A\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"a\u0006\u0001\u0002\u00171|w\rR5s\u0007>,h\u000e^\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t\u0019\u0011J\u001c;\u0002\u00191|w\rR5s\u0007>,h\u000e\u001e\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001\rEJ|7.\u001a:D_VtG\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0005Y\u0006twMC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\ra\u0006\u0014H/\u001b;j_:tU/\\\u0001\u000ea\u0006\u0014H/\u001b;j_:tU/\u001c\u0011\u0002\u0007Q\u0004\b'F\u00018!\tA\u0004)D\u0001:\u0015\tQ4(\u0001\u0004d_6lwN\u001c\u0006\u0003'qR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011)\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0011!\b\u000f\r\u0011\u0002\u0007Q\u0004\u0018'\u0001\u0003uaF\u0002\u0013A\u0007;fgR$Um]2sS\n,Gj\\4ESJ\u001c(+Z9vKN$HCA$K!\t\u0001\u0003*\u0003\u0002JC\t!QK\\5u\u0011\u0015Ye\u00021\u0001M\u0003\u0019\tXo\u001c:v[B\u0011Q\n\u0016\b\u0003\u001dJ\u0003\"aT\u0011\u000e\u0003AS!!\u0015\u000b\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0016%\u0001\u0004Qe\u0016$WMZ\u0005\u0003cUS!aU\u0011)\u000599\u0006C\u0001-`\u001b\u0005I&B\u0001.\\\u0003\u0019\u0001\u0018M]1ng*\u0011A,X\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqf(A\u0003kk:LG/\u0003\u0002a3\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\t9\u0011\u0007.\u001b\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003Kf\u000b\u0001\u0002\u001d:pm&$WM]\u0005\u0003O\u0012\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH&\u00016\"\u0003-\fQa\u001b:bMR\u0004")
public class DescribeLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionNum() {
        return this.partitionNum;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDescribeLogDirsRequest(String quorum) {
        String onlineDir = new File((String)((KafkaBroker)this.brokers().head()).config().logDirs().head()).getAbsolutePath();
        String offlineDir = new File((String)((IterableOps)((KafkaBroker)this.brokers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        ReplicaManager qual$1 = ((KafkaBroker)this.brokers().head()).replicaManager();
        boolean x$2 = qual$1.handleLogDirFailure$default$2();
        qual$1.handleLogDirFailure(offlineDir, x$2);
        this.createTopic(this.topic(), this.partitionNum(), 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 10, -1);
        DescribeLogDirsRequest request = (DescribeLogDirsRequest)new DescribeLogDirsRequest.Builder(new DescribeLogDirsRequestData().setTopics(null)).build();
        DescribeLogDirsResponse response = (DescribeLogDirsResponse)this.connectAndReceive((AbstractRequest)request, this.anySocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeLogDirsResponse.class));
        Assertions.assertEquals((int)this.logDirCount(), (int)response.data().results().size());
        DescribeLogDirsResponseData.DescribeLogDirsResult offlineResult = (DescribeLogDirsResponseData.DescribeLogDirsResult)CollectionConverters$.MODULE$.ListHasAsScala(response.data().results()).asScala().find((Function1 & Serializable)logDirResult -> BoxesRunTime.boxToBoolean((boolean)DescribeLogDirsRequestTest.$anonfun$testDescribeLogDirsRequest$1(offlineDir, logDirResult))).get();
        Assertions.assertEquals((short)Errors.KAFKA_STORAGE_ERROR.code(), (short)offlineResult.errorCode());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(offlineResult.topics()).asScala().map((Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)DescribeLogDirsRequestTest.$anonfun$testDescribeLogDirsRequest$2(t)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        Assertions.assertEquals((long)-1L, (long)offlineResult.totalBytes());
        Assertions.assertEquals((long)-1L, (long)offlineResult.usableBytes());
        DescribeLogDirsResponseData.DescribeLogDirsResult onlineResult = (DescribeLogDirsResponseData.DescribeLogDirsResult)CollectionConverters$.MODULE$.ListHasAsScala(response.data().results()).asScala().find((Function1 & Serializable)logDirResult -> BoxesRunTime.boxToBoolean((boolean)DescribeLogDirsRequestTest.$anonfun$testDescribeLogDirsRequest$3(onlineDir, logDirResult))).get();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)onlineResult.errorCode());
        Assertions.assertTrue((onlineResult.totalBytes() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((onlineResult.usableBytes() > 0L ? 1 : 0) != 0);
        Map onlinePartitionsMap = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(onlineResult.topics()).asScala().flatMap((Function1 & Serializable)topic -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topic.partitions()).asScala().map((Function1 & Serializable)partitionResult -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic.name(), partitionResult.partitionIndex())), partitionResult)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        DescribeLogDirsResponseData.DescribeLogDirsPartition replicaInfo0 = (DescribeLogDirsResponseData.DescribeLogDirsPartition)onlinePartitionsMap.apply((Object)this.tp0());
        DescribeLogDirsResponseData.DescribeLogDirsPartition replicaInfo1 = (DescribeLogDirsResponseData.DescribeLogDirsPartition)onlinePartitionsMap.apply((Object)this.tp1());
        LogManager qual$2 = ((KafkaBroker)this.brokers().head()).logManager();
        TopicPartition x$3 = this.tp0();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log0 = (UnifiedLog)qual$2.getLog(x$3, x$4).get();
        LogManager qual$3 = ((KafkaBroker)this.brokers().head()).logManager();
        TopicPartition x$5 = this.tp1();
        boolean x$6 = qual$3.getLog$default$2();
        UnifiedLog log1 = (UnifiedLog)qual$3.getLog(x$5, x$6).get();
        Assertions.assertEquals((long)log0.size(), (long)replicaInfo0.partitionSize());
        Assertions.assertEquals((long)log1.size(), (long)replicaInfo1.partitionSize());
        LogManager qual$4 = ((KafkaBroker)this.brokers().head()).logManager();
        TopicPartition x$7 = this.tp0();
        boolean x$8 = qual$4.getLog$default$2();
        long logEndOffset = ((UnifiedLog)qual$4.getLog(x$7, x$8).get()).logEndOffset();
        Assertions.assertTrue((logEndOffset > 0L ? 1 : 0) != 0, (String)("LogEndOffset '" + logEndOffset + "' should be > 0"));
        Assertions.assertEquals((long)((KafkaBroker)this.brokers().head()).replicaManager().getLogEndOffsetLag(this.tp0(), log0.logEndOffset(), false), (long)replicaInfo0.offsetLag());
        Assertions.assertEquals((long)((KafkaBroker)this.brokers().head()).replicaManager().getLogEndOffsetLag(this.tp1(), log1.logEndOffset(), false), (long)replicaInfo1.offsetLag());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirsRequest$1(String offlineDir$1, DescribeLogDirsResponseData.DescribeLogDirsResult logDirResult) {
        String string = logDirResult.logDir();
        return !(string != null ? !string.equals(offlineDir$1) : offlineDir$1 != null);
    }

    public static final /* synthetic */ int $anonfun$testDescribeLogDirsRequest$2(DescribeLogDirsResponseData.DescribeLogDirsTopic t) {
        return t.partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirsRequest$3(String onlineDir$1, DescribeLogDirsResponseData.DescribeLogDirsResult logDirResult) {
        String string = logDirResult.logDir();
        return !(string != null ? !string.equals(onlineDir$1) : onlineDir$1 != null);
    }

    public DescribeLogDirsRequestTest() {
        this.logDirCount = 2;
        this.brokerCount = 1;
        this.topic = "topic";
        this.partitionNum = 2;
    }
}

