/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\u0006\f\u0001AAQ!\u0006\u0001\u0005\u0002YAQ\u0001\u0007\u0001\u0005BeAQA\r\u0001\u0005\u0002MBQa\u0015\u0001\u0005\u0002QCQ!\u0017\u0001\u0005\u0002iCQa\u0018\u0001\u0005\u0002\u0001DQ!\u001a\u0001\u0005\u0002\u0019DQa\u001b\u0001\u0005\n1D\u0011\"a\u0003\u0001#\u0003%I!!\u0004\u0003O\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011aC\u0005\u0003)-\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"A\u0005\u0001\u0002\u000bM,G/\u00169\u0015\u0005i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRDQ!\t\u0002A\u0002\t\n\u0001\u0002^3ti&sgm\u001c\t\u0003G1j\u0011\u0001\n\u0006\u0003K\u0019\n1!\u00199j\u0015\t9\u0003&A\u0004kkBLG/\u001a:\u000b\u0005%R\u0013!\u00026v]&$(\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.I\tAA+Z:u\u0013:4w\u000e\u000b\u0002\u0003_A\u00111\u0005M\u0005\u0003c\u0011\u0012!BQ3g_J,W)Y2i\u0003M!Xm\u001d;EKN\u001c'/\u001b2f\u001d>$\b.\u001b8h)\tQB\u0007C\u00036\u0007\u0001\u0007a'\u0001\u0004rk>\u0014X/\u001c\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005ebR\"\u0001\u001e\u000b\u0005mz\u0011A\u0002\u001fs_>$h(\u0003\u0002>9\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\tiD\u0004\u000b\u0002\u0004\u0005B\u00111IR\u0007\u0002\t*\u0011QIJ\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005\u001d#%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"\"1!S(Q!\tQU*D\u0001L\u0015\taE)\u0001\u0005qe>4\u0018\u000eZ3s\u0013\tq5JA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0002#\u0006\n!+A\u0003le\u00064G/\u0001\u000buKN$H)Z:de&\u0014WmV5uQ:+H\u000e\u001c\u000b\u00035UCQ!\u000e\u0003A\u0002YB#\u0001\u0002\")\t\u0011Iu\n\u0017\u0017\u0002#\u0006IB/Z:u\t\u0016\u001c8M]5cK:{GoQ8oiJ|G\u000e\\3s)\u0005Q\u0002FA\u0003]!\t\u0019S,\u0003\u0002_I\t!A+Z:u\u0003e!Xm\u001d;EKN\u001c'/\u001b2f'\u0006lW-V:feR;\u0018nY3\u0015\u0005i\t\u0007\"B\u001b\u0007\u0001\u00041\u0004F\u0001\u0004CQ\u00111\u0011j\u00143-\u0003E\u000bq\u0002^3tiVs7N\\8x]V\u001bXM\u001d\u000b\u00035\u001dDQ!N\u0004A\u0002YB#a\u0002\")\t\u001dIuJ\u001b\u0017\u0002#\u000693/\u001a8e\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u)\ri\u00070 \t\u0003]Zl\u0011a\u001c\u0006\u0003aF\f\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003eN\faaY8n[>t'B\u0001\bu\u0015\t)(&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003o>\u0014A\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a\u0005\u0006s\"\u0001\rA_\u0001\be\u0016\fX/Z:u!\tq70\u0003\u0002}_\n\u0019C)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$\bb\u0002@\t!\u0003\u0005\ra`\u0001\rg>\u001c7.\u001a;TKJ4XM\u001d\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0007\u0002\u000f9,Go^8sW&!\u0011\u0011BA\u0002\u00051\u0019vnY6fiN+'O^3s\u0003E\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\"!a\u0004+\u0007}\f\tb\u000b\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!C;oG\",7m[3e\u0015\r\ti\u0002H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0011\u0003/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DescribeUserScramCredentialsRequestTest
extends BaseRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.serverConfig().setProperty("authorizer.class.name", StandardAuthorizer.class.getName());
        this.serverConfig().setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
        super.setUp(testInfo);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDescribeNothing(String quorum) {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.adminSocketServer());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDescribeWithNull(String quorum) {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(null)).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.adminSocketServer());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @Test
    public void testDescribeNotController() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        short error = this.sendDescribeUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Did not expect controller error when routed to non-controller");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDescribeSameUserTwice(String quorum) {
        String user = "user1";
        DescribeUserScramCredentialsRequestData.UserName userName = new DescribeUserScramCredentialsRequestData.UserName().setName(user);
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)userName, (List)new .colon.colon((Object)userName, (List)Nil$.MODULE$))).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.adminSocketServer());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.DUPLICATE_RESOURCE.code(), (short)result.errorCode(), (String)("Expected duplicate resource error for " + user));
        Assertions.assertEquals((Object)("Cannot describe SCRAM credentials for the same user twice in a single request: " + user), (Object)result.errorMessage());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUnknownUser(String quorum) {
        String unknownUser = "unknownUser";
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeUserScramCredentialsRequestData.UserName().setName(unknownUser), (List)Nil$.MODULE$)).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.adminSocketServer());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.RESOURCE_NOT_FOUND.code(), (short)result.errorCode(), (String)("Expected duplicate resource error for " + unknownUser));
        Assertions.assertEquals((Object)("Attempt to describe a user credential that does not exist: " + unknownUser), (Object)result.errorMessage());
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }
}

