/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.network.ConnectionQuotas;
import kafka.server.BrokerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=100L)
@ScalaSignature(bytes="\u0006\u0005\t}b\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0005B5BQ!\u000f\u0001\u0005\u0002iBQ\u0001\u001a\u0001\u0005\u0002\u0015DQA\u001b\u0001\u0005\n-Dq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002b\u0002!\t!a9\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\bb\u0002B\u0003\u0001\u0011\u0005!q\u0001\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005G\u0011q\u0003R=oC6L7mQ8oM&<7\t[1oO\u0016$Vm\u001d;\u000b\u0005uq\u0012AB:feZ,'OC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015r\u0012aC5oi\u0016<'/\u0019;j_:L!a\n\u0013\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\u000f\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012A\f\t\u0004_Q2T\"\u0001\u0019\u000b\u0005E\u0012\u0014AC2pY2,7\r^5p]*\t1'A\u0003tG\u0006d\u0017-\u0003\u00026a\t\u00191+Z9\u0011\u0005-:\u0014B\u0001\u001d\u001d\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002!Q,7\u000f^\"p]\u001aLwm\u00115b]\u001e,GCA\u001e@!\taT(D\u00013\u0013\tq$G\u0001\u0003V]&$\b\"\u0002!\u0004\u0001\u0004\t\u0015AB9v_J,X\u000e\u0005\u0002C\u0013:\u00111i\u0012\t\u0003\tJj\u0011!\u0012\u0006\u0003\r\u0002\na\u0001\u0010:p_Rt\u0014B\u0001%3\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!\u0013\u0004FA\u0002N!\tqu+D\u0001P\u0015\t\u0001\u0016+\u0001\u0004qCJ\fWn\u001d\u0006\u0003%N\u000bqA[;qSR,'O\u0003\u0002U+\u0006)!.\u001e8ji*\ta+A\u0002pe\u001eL!\u0001W(\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\u00045\u0002\f\u0007CA._\u001b\u0005a&BA/P\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA0]\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\n!-I\u0001d\u0003\u0015Y'/\u00194u\u0003q!Xm\u001d;Es:\fW.[2U_BL7mQ8oM&<7\t[1oO\u0016$\"a\u000f4\t\u000b\u0001#\u0001\u0019A!)\u0005\u0011i\u0005\u0006\u0002\u0003[A&d\u0013AY\u0001\u0016i\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0015YD._A\u0004\u0011\u0015iW\u00011\u0001o\u0003\u0019)g\u000e^5usB\u0011qn^\u0007\u0002a*\u0011\u0011O]\u0001\u0006cV|G/\u0019\u0006\u0003gR\faaY8n[>t'BA\u0010v\u0015\t1X+\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003qB\u0014\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\u0011\u0015QX\u00011\u0001|\u0003\u0011)8/\u001a:\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0003bkRD'bAA\u0001e\u0006A1/Z2ve&$\u00180C\u0002\u0002\u0006u\u0014abS1gW\u0006\u0004&/\u001b8dSB\fG\u000e\u0003\u0004\u0002\n\u0015\u0001\r!Q\u0001\tG2LWM\u001c;JI\u0006iB/Z:u\u00072LWM\u001c;JIF+x\u000e^1D_:4\u0017nZ\"iC:<W\rF\u0002<\u0003\u001fAQ\u0001\u0011\u0004A\u0002\u0005C#AB')\u000b\u0019Q\u0006-!\u0006-\u0003\t\f\u0011\u0004^3tiV\u001bXM])v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u00191(a\u0007\t\u000b\u0001;\u0001\u0019A!)\u0005\u001di\u0005&B\u0004[A\u0006\u0005B&\u00012\u00027Q,7\u000f^+tKJ\u001cE.[3oi&#\u0017+^8uC\u000eC\u0017M\\4f)\rY\u0014q\u0005\u0005\u0006\u0001\"\u0001\r!\u0011\u0015\u0003\u00115CS\u0001\u0003.a\u0003[a\u0013AY\u0001%i\u0016\u001cH\u000fR3gCVdGo\u00117jK:$\u0018\nZ)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u00191(a\r\t\u000b\u0001K\u0001\u0019A!)\u0005%i\u0005&B\u0005[A\u0006eB&\u00012\u0002AQ,7\u000f\u001e#fM\u0006,H\u000e^+tKJ\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0004w\u0005}\u0002\"\u0002!\u000b\u0001\u0004\t\u0005F\u0001\u0006NQ\u0015Q!\fYA#Y\u0005\u0011\u0017\u0001\u000b;fgR$UMZ1vYR,6/\u001a:DY&,g\u000e^%e#V|G/Y\"p]\u001aLwm\u00115b]\u001e,GcA\u001e\u0002L!)\u0001i\u0003a\u0001\u0003\"\u00121\"\u0014\u0015\u0006\u0017i\u0003\u0017\u0011\u000b\u0017\u0002E\u0006IB/Z:u\u0013B\fVo\u001c;b\u0013:LG/[1mSj\fG/[8o)\rY\u0014q\u000b\u0005\u0006\u00012\u0001\r!\u0011\u0015\u0003\u00195CS\u0001\u0004.a\u0003;b\u0013AY\u0001\u0018i\u0016\u001cH/\u00139Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2aOA2\u0011\u0015\u0001U\u00021\u0001BQ\tiQ\nK\u0003\u000e5\u0002\fI\u0007L\u0001c\u0003%!X-\u001c9U_BL7\rF\u0001B\u0003E\"Xm\u001d;D_:4\u0017nZ\"iC:<Wm\u00148O_:,\u00050[:uS:<Gk\u001c9jG^KG\u000f[!e[&t7\t\\5f]R$2aOA:\u0011\u0015\u0001u\u00021\u0001BQ\tyQ\nK\u0003\u00105\u0002\fI\bL\u0001c\u0003\u0019\"Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u0012+g-Y;miR{\u0007/[2D_:4\u0017n\u001a\u000b\u0004w\u0005}\u0004\"\u0002!\u0011\u0001\u0004\t\u0005F\u0001\tNQ\u0015\u0001\"\fYACY\u0005\u0011\u0017\u0001E:fi\n\u0013xn[3s\u0007>tg-[4t)\u0015Y\u00141RAH\u0011\u0019\ti)\u0005a\u0001\u0003\u0006A!M]8lKJLE\rC\u0004\u0002\u0012F\u0001\r!a%\u0002\u00119,wOV1mk\u0016\u00042\u0001PAK\u0013\r\t9J\r\u0002\u0005\u0019>tw-A\neK2,G/\u001a\"s_.,'oQ8oM&<7\u000fF\u0002<\u0003;Ca!!$\u0013\u0001\u0004\t\u0015AE1mi\u0016\u0014(I]8lKJ\u001cuN\u001c4jON$raOAR\u0003K\u000b9\u000b\u0003\u0004\u0002\u000eN\u0001\r!\u0011\u0005\b\u0003#\u001b\u0002\u0019AAJ\u0011\u001d\tIk\u0005a\u0001\u0003W\u000b!a\u001c9\u0011\t\u00055\u0016q\u001a\b\u0005\u0003_\u000bIM\u0004\u0003\u00022\u0006\rg\u0002BAZ\u0003\u007fsA!!.\u0002>:!\u0011qWA^\u001d\r!\u0015\u0011X\u0005\u0002-&\u0011a/V\u0005\u0003?UL1!!1u\u0003\u001d\u0019G.[3oiNLA!!2\u0002H\u0006)\u0011\rZ7j]*\u0019\u0011\u0011\u0019;\n\t\u0005-\u0017QZ\u0001\u000e\u00032$XM]\"p]\u001aLwm\u00149\u000b\t\u0005\u0015\u0017qY\u0005\u0005\u0003#\f\u0019N\u0001\u0004PaRK\b/\u001a\u0006\u0005\u0003\u0017\fi-A\u0011uKN$(I]8lKJLEmQ8oM&<7\t[1oO\u0016\fe\u000e\u001a#fY\u0016$X\rF\u0002<\u00033DQ\u0001\u0011\u000bA\u0002\u0005C#\u0001F')\u000bQQ\u0006-a8-\u0003\t\f\u0001\u0006^3ti\u0012+g-Y;mi\n\u0013xn[3s\u0013\u0012\u001cuN\u001c4jO\u000eC\u0017M\\4f\u0003:$G)\u001a7fi\u0016$2aOAs\u0011\u0015\u0001U\u00031\u0001BQ\t)R\nK\u0003\u00165\u0002\fY\u000fL\u0001c\u0003\t\"Xm\u001d;EK\u001a\fW\u000f\u001c;B]\u0012\u0014%o\\6fe&#7i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u00191(!=\t\u000b\u00013\u0002\u0019A!)\u0005Yi\u0005&\u0002\f[A\u0006]H&\u00012\u00029Q,7\u000f\u001e#z]\u0006l\u0017nY$s_V\u00048i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u00191(!@\t\u000b\u0001;\u0002\u0019A!)\u0005]i\u0005&B\f[A\n\rA&\u00012\u0002CQ,7\u000f\u001e#z]\u0006l\u0017nY*iCJ,wI]8va\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007m\u0012I\u0001C\u0003A1\u0001\u0007\u0011\t\u000b\u0002\u0019\u001b\"*\u0001D\u00171\u0003\u00101\u0012!\u0011C\u0011\u0003\u0005'\tAb\u001b:bMR\\3.\u001b99ia\na\u0005^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u0014H)\u001a4bk2$xI]8va\u000e{gNZ5h)\rY$\u0011\u0004\u0005\u0006\u0001f\u0001\r!\u0011\u0015\u000335CS!\u0007.a\u0005?a\u0013AY\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HC\u0001B\u0013!\u0011\u00119C!\u000b\u000e\u0005\u00055\u0017\u0002\u0002B\u0016\u0003\u001b\u0014Q!\u00113nS:Ds\u0001\u0001B\u0018\u0005w\u0011i\u0004\u0005\u0003\u00032\t]RB\u0001B\u001a\u0015\r\u0011)$U\u0001\u0004CBL\u0017\u0002\u0002B\u001d\u0005g\u0011q\u0001V5nK>,H/A\u0003wC2,XMH\u0001e\u0001")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties cfg = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(cfg), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testConfigChange(String quorum) {
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("flush.messages", oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var26_12 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var12_7 = null;
        Object var15_8 = null;
        Object var18_11 = null;
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", newVal.toString()), AlterConfigOp.OpType.SET);
            ConfigResource resource2 = new ConfigResource(ConfigResource.Type.BROKER, "");
            AlterConfigOp op2 = new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG, newVal.toString()), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource2), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op2, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }
        long l2 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                    Object var27_24 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDynamicTopicConfigChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var27_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var13_6 = null;
        Object var16_7 = null;
        Object var19_10 = null;
        int newSegmentSize = 2000;
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("segment.bytes", Integer.toString(newSegmentSize)), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }
        LogManager qual$2 = ((KafkaBroker)this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        long l2 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                    Object var28_26 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        Object var20_21 = null;
        Object var23_22 = null;
        Object var26_25 = null;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> TestUtils$.MODULE$.produceMessage(this.brokers(), tp.topic(), Integer.toString(i), (Long)null, 30000, 20000));
        Assertions.assertTrue((boolean)log.logSegments().stream().allMatch(x$1 -> x$1.size() > 1000), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(ClientQuotaEntity entity, KafkaPrincipal user, String clientId) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(2000.0)))));
            admin.alterClientQuotas(alterations).all().get();
            QuotaFactory.QuotaManagers quotaManagers = ((KafkaBroker)this.brokers().head()).dataPlaneRequestProcessor().quotas();
            long l = 10000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                        Object var31_13 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            Object var13_8 = null;
            Object var16_9 = null;
            Object var19_12 = null;
            double defaultProducerQuota = Long.MAX_VALUE;
            double defaultConsumerQuota = Long.MAX_VALUE;
            java.util.List<ClientQuotaAlteration> removals = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", null), new ClientQuotaAlteration.Op("consumer_byte_rate", null))));
            admin.alterClientQuotas(removals, new AlterClientQuotasOptions().validateOnly(true)).all().get();
            double upperBound_upperBound = 1000.0;
            Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)quotaManagers.produce().quota(user, clientId), (String)("User " + user + " clientId " + clientId + " must have same producer quota of 1000"));
            double upperBound_upperBound2 = 2000.0;
            Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)quotaManagers.fetch().quota(user, clientId), (String)("User " + user + " clientId " + clientId + " must have same consumer quota of 2000"));
            admin.alterClientQuotas(removals).all().get();
            long l2 = 10000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            LongRef retry_wait2 = LongRef.create((long)1L);
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                        Object var32_25 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(retry_wait2.elem);
                    retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                    continue;
                }
                break;
            }
            Object var20_20 = null;
            Object var23_21 = null;
            Object var26_24 = null;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testClientIdQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUserQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUserClientIdQuotaChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDefaultClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDefaultUserQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDefaultUserClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testIpQuotaInitialization(String quorum) {
        KafkaBroker broker = (KafkaBroker)this.brokers().head();
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
            admin.alterClientQuotas(alterations).all().get();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(broker);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var13_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testIpQuotaConfigChange(String quorum) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
            admin.alterClientQuotas(alterations).all().get();
            InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10));
            InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
            this.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<ClientQuotaAlteration> deletions1 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions1).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<ClientQuotaAlteration> deletions2 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions2).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        }
    }

    private String tempTopic() {
        return "testTopic" + TestUtils$.MODULE$.random().nextInt(1000000);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testConfigChangeOnNonExistingTopicWithAdminClient(String quorum) {
        String topic = this.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testIncrementalAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "200000"), AlterConfigOp.OpType.SET);
            TestUtils.assertFutureThrows((Future)admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all(), InvalidRequestException.class);
        }
    }

    private void setBrokerConfigs(String brokerId, long newValue) {
        this.alterBrokerConfigs(brokerId, newValue, AlterConfigOp.OpType.SET);
    }

    private void deleteBrokerConfigs(String brokerId) {
        this.alterBrokerConfigs(brokerId, 0L, AlterConfigOp.OpType.DELETE);
    }

    private void alterBrokerConfigs(String brokerId, long newValue, AlterConfigOp.OpType op) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, brokerId);
            AlterConfigOp configOp = new AlterConfigOp(new ConfigEntry("leader.replication.throttled.rate", Long.toString(newValue)), op);
            AlterConfigOp configOp2 = new AlterConfigOp(new ConfigEntry("follower.replication.throttled.rate", Long.toString(newValue)), op);
            AlterConfigOp configOp3 = new AlterConfigOp(new ConfigEntry("replica.alter.log.dirs.io.max.bytes.per.second", Long.toString(newValue)), op);
            Collection configOps = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)configOp, (List)new .colon.colon((Object)configOp2, (List)new .colon.colon((Object)configOp3, (List)Nil$.MODULE$)))).asJavaCollection();
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)configOps)}))).asJava()).all().get();
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testBrokerIdConfigChangeAndDelete(String quorum) {
        long newValue = 100000L;
        String brokerId = Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId());
        this.setBrokerConfigs(brokerId, newValue);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$1(brokerId, newValue, b);
            return BoxedUnit.UNIT;
        });
        this.deleteBrokerConfigs(brokerId);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$3(b);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDefaultBrokerIdConfigChangeAndDelete(String quorum) {
        long newValue = 100000L;
        String brokerId = "";
        this.setBrokerConfigs(brokerId, newValue);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$1(newValue, b);
            return BoxedUnit.UNIT;
        });
        this.deleteBrokerConfigs(brokerId);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$3(b);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDefaultAndBrokerIdConfigChange(String quorum) {
        long newValue = 100000L;
        String brokerId = Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId());
        this.setBrokerConfigs(brokerId, newValue);
        long newDefaultValue = 200000L;
        this.setBrokerConfigs("", newDefaultValue);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultAndBrokerIdConfigChange$1(brokerId, newValue, newDefaultValue, b);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDynamicGroupConfigChange(String quorum) {
        int newSessionTimeoutMs = 50000;
        String consumerGroupId = "group-foo";
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.GROUP, consumerGroupId);
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("consumer.session.timeout.ms", Integer.toString(newSessionTimeoutMs)), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicGroupConfigChange$1(this, consumerGroupId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var16_14 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var9_9 = null;
        Object var12_10 = null;
        Object var15_13 = null;
        GroupConfig groupConfig = (GroupConfig)((BrokerServer)this.brokerServers().head()).groupCoordinator().groupConfig(consumerGroupId).get();
        Assertions.assertEquals((int)newSessionTimeoutMs, (int)groupConfig.consumerSessionTimeoutMs());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft+kip848"})
    public void testDynamicShareGroupConfigChange(String quorum) {
        int newRecordLockDurationMs = 50000;
        String shareGroupId = "group-foo";
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.GROUP, shareGroupId);
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("share.record.lock.duration.ms", Integer.toString(newRecordLockDurationMs)), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicShareGroupConfigChange$1(this, shareGroupId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var16_14 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var9_9 = null;
        Object var12_10 = null;
        Object var15_13 = null;
        GroupConfig groupConfig = (GroupConfig)((BrokerServer)this.brokerServers().head()).groupCoordinator().groupConfig(shareGroupId).get();
        Assertions.assertEquals((int)newRecordLockDurationMs, (int)groupConfig.shareRecordLockDurationMs);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testIncrementalAlterDefaultGroupConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.GROUP, "");
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("consumer.session.timeout.ms", "200000"), AlterConfigOp.OpType.SET);
            TestUtils.assertFutureThrows((Future)admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all(), InvalidRequestException.class);
        }
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (long)((UnifiedLog)logOpt.get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (long)((UnifiedLog)qual$2.getLog((TopicPartition)tp$1, (boolean)x$4).get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (int)((UnifiedLog)logOpt.get()).config().segmentSize);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, UnifiedLog log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (int)log$1.config().segmentSize);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota, (String)("User " + user$1 + " clientId " + clientId$1 + " must have overridden producer quota of 1000"));
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota, (String)("User " + user$1 + " clientId " + clientId$1 + " must have overridden consumer quota of 2000"));
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)new Quota(defaultProducerQuota$1, true), (Object)producerQuota, (String)("User " + user$1 + " clientId " + clientId$1 + " must have reset producer quota to " + defaultProducerQuota$1));
        Assertions.assertEquals((Object)new Quota(defaultConsumerQuota$1, true), (Object)consumerQuota, (String)("User " + user$1 + " clientId " + clientId$1 + " must have reset consumer quota to " + defaultConsumerQuota$1));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(KafkaBroker broker$1) {
        ConnectionQuotas connectionQuotas = broker$1.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)("Unexpected quota for IP " + ip$1));
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota) {
        ConnectionQuotas connectionQuotas = ((KafkaBroker)this.brokers().head()).socketServer().connectionQuotas();
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var11_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$2(long value$1, KafkaBroker b$1) {
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$1(String brokerId$1, long newValue$1, KafkaBroker b) {
        String string = Integer.toString(b.config().brokerId());
        long value = !(string != null ? !string.equals(brokerId$1) : brokerId$1 != null) ? newValue$1 : Long.MAX_VALUE;
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$2(value, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var13_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$4(KafkaBroker b$2) {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().alterLogDirs().upperBound());
    }

    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$3(KafkaBroker b) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$4(b);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var8_6 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$2(long newValue$2, KafkaBroker b$3) {
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$1(long newValue$2, KafkaBroker b) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$2(newValue$2, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var10_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$4(KafkaBroker b$4) {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().alterLogDirs().upperBound());
    }

    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$3(KafkaBroker b) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$4(b);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var8_6 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultAndBrokerIdConfigChange$2(long value$2, KafkaBroker b$5) {
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDefaultAndBrokerIdConfigChange$1(String brokerId$2, long newValue$3, long newDefaultValue$1, KafkaBroker b) {
        String string = Integer.toString(b.config().brokerId());
        long value = !(string != null ? !string.equals(brokerId$2) : brokerId$2 != null) ? newValue$3 : newDefaultValue$1;
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultAndBrokerIdConfigChange$2(value, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var15_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDynamicGroupConfigChange$1(DynamicConfigChangeTest $this, String consumerGroupId$1) {
        ((KafkaBroker)$this.brokers().head()).groupCoordinator().groupMetadataTopicConfigs();
        Assertions.assertTrue((boolean)((BrokerServer)$this.brokerServers().head()).groupCoordinator().groupConfig(consumerGroupId$1).isPresent());
    }

    public static final /* synthetic */ void $anonfun$testDynamicShareGroupConfigChange$1(DynamicConfigChangeTest $this, String shareGroupId$1) {
        ((KafkaBroker)$this.brokers().head()).groupCoordinator().groupMetadataTopicConfigs();
        Assertions.assertTrue((boolean)((BrokerServer)$this.brokerServers().head()).groupCoordinator().groupConfig(shareGroupId$1).isPresent());
    }
}

