/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.GroupCoordinatorBaseRequestTest;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(types={Type.KRAFT})
@ScalaSignature(bytes="\u0006\u000554Aa\u0002\u0005\u0001\u001b!A!\u0003\u0001B\u0001B\u0003%1\u0003C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0003H\u0001\u0011\u0005Q\u0005C\u0003K\u0001\u0011\u0005Q\u0005C\u0003b\u0001\u0011%!MA\u000bMSN$xI]8vaN\u0014V-];fgR$Vm\u001d;\u000b\u0005%Q\u0011AB:feZ,'OC\u0001\f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0005\n\u0005EA!aH$s_V\u00048i\\8sI&t\u0017\r^8s\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u000691\r\\;ti\u0016\u0014\bC\u0001\u000b\u001f\u001b\u0005)\"B\u0001\f\u0018\u0003\u0011!Xm\u001d;\u000b\u0005aI\u0012AB2p[6|gN\u0003\u0002\f5)\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0013\tyRCA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011!e\t\t\u0003\u001f\u0001AQA\u0005\u0002A\u0002M\t\u0001\t^3ti2K7\u000f^$s_V\u00048oV5uQ:+woQ8ogVlWM]$s_V\u0004\bK]8u_\u000e|G.\u00118e\u001d\u0016<xI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0002MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t!QK\\5uQ\u0011\u0019Qf\r\u001b\u0011\u00059\nT\"A\u0018\u000b\u0005A*\u0012aA1qS&\u0011!g\f\u0002\f\u00072,8\u000f^3s)\u0016\u001cH/\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2\u001aQg\u0010\",\u000bYJ$\bP\u001f\u0011\u00059:\u0014B\u0001\u001d0\u0005U\u0019E.^:uKJ\u001cuN\u001c4jOB\u0013x\u000e]3sif\f1a[3zC\u0005Y\u0014\u0001H8gMN,Go\u001d\u0018u_BL7M\f8v[:\u0002\u0018M\u001d;ji&|gn]\u0001\u0006m\u0006dW/Z\u0011\u0002}\u0005\t\u0011gK\u00037s\u0001cT(I\u0001B\u0003\u0001zgMZ:fiNtCo\u001c9jG:\u0012X\r\u001d7jG\u0006$\u0018n\u001c8/M\u0006\u001cGo\u001c:,\u000bYJ4\tP#\"\u0003\u0011\u000b\u0001e\u001a:pkBt\u0013N\\5uS\u0006dgF]3cC2\fgnY3/I\u0016d\u0017-\u001f\u0018ng\u0006\na)\u0001\u00032aA\u0002\u0014\u0001\u0011;fgRd\u0015n\u001d;He>,\bo],ji\"|E\u000eZ\"p]N,X.\u001a:He>,\b\u000f\u0015:pi>\u001cw\u000e\\!oI:+wo\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:)\t\u0011i3'\u0013\u0017\u0004k}\u0012\u0015\u0001\u0011;fgRd\u0015n\u001d;He>,\bo],ji\"|E\u000eZ\"p]N,X.\u001a:He>,\b\u000f\u0015:pi>\u001cw\u000e\\!oI>cGm\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:)\r\u0015iC*T\u001aW\u0003\u0015!\u0018\u0010]3tY\tq5\u000bJ\u0001P\u0013\t\u0001\u0016+A\u0003L%\u00063EK\u0003\u0002S_\u0005!A+\u001f9fI\u0005!\u0016BA+R\u0003!\u0019ujX&S\u0003\u001a#F&B,]k}\u00125&\u0002\u001c:1rR\u0016%A-\u00029\u001d\u0014x.\u001e9/G>|'\u000fZ5oCR|'O\f8fo:*g.\u00192mK\u0006\n1,A\u0003gC2\u001cXmK\u00037suct,I\u0001_\u0003\u0015:'o\\;q]\r|wN\u001d3j]\u0006$xN\u001d\u0018sK\n\fG.\u00198dK:\u0002(o\u001c;pG>d7/I\u0001a\u0003\u001d\u0019G.Y:tS\u000e\fa\u0002^3ti2K7\u000f^$s_V\u00048\u000f\u0006\u0002'G\")AM\u0002a\u0001K\u0006qQo]3OK^\u0004&o\u001c;pG>d\u0007CA\u0014g\u0013\t9\u0007FA\u0004C_>dW-\u00198)\t\u0001IG\n\u001c\t\u0003])L!a[\u0018\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:-\u00039\u0003")
public class ListGroupsRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.initial.rebalance.delay.ms", value="1000")})
    public void testListGroupsWithNewConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testListGroups(true);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.initial.rebalance.delay.ms", value="1000")})
    public void testListGroupsWithOldConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testListGroups(false);
    }

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false"), @ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.initial.rebalance.delay.ms", value="1000")})
    public void testListGroupsWithOldConsumerGroupProtocolAndOldGroupCoordinator() {
        this.testListGroups(false);
    }

    private void testListGroups(boolean useNewProtocol) {
        if (!this.isNewGroupCoordinatorEnabled() && useNewProtocol) {
            Assertions.fail((String)"Cannot use the new protocol with the old group coordinator.");
        }
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_GROUPS.oldestVersion()), (int)ApiKeys.LIST_GROUPS.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            void var9_9;
            void var4_4;
            void var12_12;
            Tuple2<String, Object> tuple2 = this.joinDynamicConsumerGroupWithOldProtocol("grp-1", this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup1 = (String)tuple2._1();
            ListGroupsResponseData.ListedGroup response1 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-1").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.STABLE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            byte[] x$3 = this.joinDynamicConsumerGroupWithOldProtocol$default$2();
            byte[] x$4 = this.joinDynamicConsumerGroupWithOldProtocol$default$3();
            Tuple2<String, Object> tuple22 = this.joinDynamicConsumerGroupWithOldProtocol("grp-2", x$3, x$4, false);
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup2 = (String)tuple22._1();
            ListGroupsResponseData.ListedGroup response2 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-2").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.COMPLETING_REBALANCE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            Tuple2<String, Object> tuple23 = this.joinDynamicConsumerGroupWithOldProtocol("grp-3", this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
            if (tuple23 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup3 = (String)tuple23._1();
            this.leaveGroup("grp-3", (String)var12_12, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            ListGroupsResponseData.ListedGroup response3 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-3").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.EMPTY.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            String memberId1InGroup4 = null;
            ListGroupsResponseData.ListedGroup response4 = null;
            String memberId1InGroup5 = null;
            String memberId2InGroup5 = null;
            ListGroupsResponseData.ListedGroup response5 = null;
            ListGroupsResponseData.ListedGroup response6 = null;
            if (useNewProtocol) {
                memberId1InGroup4 = (String)this.joinConsumerGroup("grp-4", true)._1();
                response4 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-4").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.STABLE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
                memberId1InGroup5 = (String)this.joinConsumerGroup("grp-5", true)._1();
                memberId2InGroup5 = (String)this.joinConsumerGroup("grp-5", true)._1();
                response5 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-5").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.RECONCILING.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
                String memberId1InGroup6 = (String)this.joinConsumerGroup("grp-6", true)._1();
                this.leaveGroup("grp-6", memberId1InGroup6, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                response6 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-6").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.EMPTY.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
            }
            Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)new .colon.colon(response4, (List)new .colon.colon(response5, (List)new .colon.colon(response6, (List)Nil$.MODULE$)))))).toSet() : new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$))).toSet()), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
            if (version >= 4) {
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response1, (List)Nil$.MODULE$)) : new .colon.colon((Object)response1, (List)Nil$.MODULE$)), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.STABLE.toString(), (List)Nil$.MODULE$), (List<String>)package$.MODULE$.List().empty(), (short)version));
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response2, (List)new .colon.colon((Object)response5, (List)Nil$.MODULE$)).toSet() : new .colon.colon((Object)response2, (List)Nil$.MODULE$).toSet()), (Object)this.listGroups((List<String>)new .colon.colon((Object)ClassicGroupState.COMPLETING_REBALANCE.toString(), (List)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.RECONCILING.toString(), (List)Nil$.MODULE$)), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response1, (List)new .colon.colon((Object)response3, (List)new .colon.colon((Object)response6, (List)Nil$.MODULE$)))).toSet() : new .colon.colon((Object)response1, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$)).toSet()), (Object)this.listGroups((List<String>)new .colon.colon((Object)ClassicGroupState.STABLE.toString(), (List)new .colon.colon((Object)ClassicGroupState.EMPTY.toString(), (List)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (List)Nil$.MODULE$))), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
                Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING.toString(), (List)Nil$.MODULE$), (List<String>)package$.MODULE$.List().empty(), (short)version));
            }
            if (version >= 5) {
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)Nil$.MODULE$) : package$.MODULE$.List().empty()), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.STABLE.toString(), (List)Nil$.MODULE$), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), (short)version));
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response5, (List)new .colon.colon(response6, (List)Nil$.MODULE$))).toSet() : Predef$.MODULE$.Set().empty()), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), (short)version).toSet());
                Assertions.assertEquals((Object)new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$))).toSet(), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), (short)version).toSet());
            }
            this.leaveGroup("grp-1", (String)var4_4, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.leaveGroup("grp-2", (String)var9_9, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            if (useNewProtocol) {
                this.leaveGroup("grp-4", memberId1InGroup4, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                this.leaveGroup("grp-5", memberId1InGroup5, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                this.leaveGroup("grp-5", memberId2InGroup5, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            }
            this.deleteGroups((List<String>)(useNewProtocol ? new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)new .colon.colon((Object)"grp-3", (List)new .colon.colon((Object)"grp-4", (List)new .colon.colon((Object)"grp-5", (List)new .colon.colon((Object)"grp-6", (List)Nil$.MODULE$)))))) : new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)new .colon.colon((Object)"grp-3", (List)Nil$.MODULE$)))), (List<Errors>)(useNewProtocol ? (List)package$.MODULE$.List().fill(6, (Function0 & Serializable)() -> Errors.NONE) : (List)package$.MODULE$.List().fill(3, (Function0 & Serializable)() -> Errors.NONE)), ApiKeys.DELETE_GROUPS.latestVersion(this.isUnstableApiEnabled()));
            Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)package$.MODULE$.List().empty(), (short)version));
        });
    }

    public ListGroupsRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

