/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\tub\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011BQa\u000b\u0001\u0005R1BQA\u000f\u0001\u0005\u0002mBQ!\u0019\u0001\u0005\u0002\tDQ!\u001d\u0001\u0005\u0002IDQa\u001e\u0001\u0005\u0002aDQ! \u0001\u0005\u0002yDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002\u0004\u0002!I!!\"\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\r\u0001\u0011%!1\u0004\u0002\u000e\u0019><wJ\u001a4tKR$Vm\u001d;\u000b\u0005]A\u0012AB:feZ,'OC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\f\n\u0005}1\"a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u000f\u0001\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u00121!\u00138u\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002.aA\u0011aEL\u0005\u0003_\u001d\u0012A!\u00168ji\")\u0011g\u0001a\u0001e\u0005)\u0001O]8qgB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0005kRLGNC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$A\u0003)s_B,'\u000f^5fg\u0006iB/Z:u\u000f\u0016$xJ\u001a4tKR\u001chi\u001c:V].twn\u001e8U_BL7\r\u0006\u0002.y!)Q\b\u0002a\u0001}\u00051\u0011/^8sk6\u0004\"a\u0010$\u000f\u0005\u0001#\u0005CA!(\u001b\u0005\u0011%BA\"\u001b\u0003\u0019a$o\\8u}%\u0011QiJ\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002FO!\u0012AA\u0013\t\u0003\u0017Rk\u0011\u0001\u0014\u0006\u0003\u001b:\u000ba\u0001]1sC6\u001c(BA(Q\u0003\u001dQW\u000f]5uKJT!!\u0015*\u0002\u000b),h.\u001b;\u000b\u0003M\u000b1a\u001c:h\u0013\t)FJA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDC\u0001B,^=B\u0011\u0001lW\u0007\u00023*\u0011!\fT\u0001\taJ|g/\u001b3fe&\u0011A,\u0017\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0003}\u000b\u0013\u0001Y\u0001\u0006WJ\fg\r^\u0001!i\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0003\u001a$XM\u001d#fY\u0016$XMU3d_J$7\u000f\u0006\u0002.G\")Q(\u0002a\u0001}!2Q!\u001a5jW2\u0004\"A\n4\n\u0005\u001d<#A\u00033faJ,7-\u0019;fI\u00069Q.Z:tC\u001e,\u0017%\u00016\u0002+1K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e\u0011Wa\u0005)1/\u001b8dK\u0006\nQ.\u0001\u0001)\u0005\u0015Q\u0005\u0006B\u0003X;Bd\u0013aX\u00017i\u0016\u001cHOR3uG\"|eMZ:fi\nKH+[7fgR\fW\u000e\u001d$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9BMR,'\u000f\u0016:v]\u000e\fG/\u001a\u000b\u0003[MDQ!\u0010\u0004A\u0002yB#A\u0002&)\t\u00199VL\u001e\u0017\u0002?\u0006\u0001E/Z:u\r\u0016$8\r[(gMN,GOQ=US6,7\u000f^1na\u001a{'/T1y)&lWm\u001d;b[B<\u0016\u000e\u001e5V]>\u0014H-\u001a:fIRKW.Z:uC6\u00048\u000f\u0006\u0002.s\")Qh\u0002a\u0001}!\u0012qA\u0013\u0015\u0005\u000f]kF\u0010L\u0001`\u0003y!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK2\u000bG/Z:u)&lW\r\u0006\u0002.\u007f\")Q\b\u0003a\u0001}!\u0012\u0001B\u0013\u0015\u0006\u0011]k\u0016Q\u0001\u0017\u0002?\u00069B/Z:u\u000b6\u0004H/\u001f'pON<U\r^(gMN,Go\u001d\u000b\u0004[\u0005-\u0001\"B\u001f\n\u0001\u0004q\u0004FA\u0005KQ\u0015Iq+XA\tY\u0005y\u0016!\u000e;fgR4U\r^2i\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004hi\u001c:NCb$\u0016.\\3ti\u0006l\u0007oV5uQ\u0016k\u0007\u000f^=M_\u001e$2!LA\f\u0011\u0015i$\u00021\u0001?Q\tQ!\nK\u0003\u000b/v\u000bi\u0002L\u0001`\u0003\u0001\"Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK\u0016\u000b'\u000f\\5fgR$\u0016.\\3\u0015\u00075\n\u0019\u0003C\u0003>\u0017\u0001\u0007a\b\u000b\u0002\f\u0015\"*1bV/\u0002*1\nq,A\u0017uKN$h)\u001a;dQ>3gm]3ug\n+gm\u001c:f/&$\bn\u00115b]\u001eLgnZ*fO6,g\u000e^*ju\u0016$2!LA\u0018\u0011\u0015iD\u00021\u0001?Q\ta!\nK\u0003\r/v\u000b)\u0004L\u0001`\u0003)\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8OQ3g_J,w+\u001b;i\u0007\"\fgnZ5oON+w-\\3oiN$2!LA\u001e\u0011\u0015iT\u00021\u0001?Q\ti!\nK\u0003\u000e/v\u000b\t\u0005L\u0001`\u0003\u0019\u0011'o\\6feV\u0011\u0011q\t\t\u0004;\u0005%\u0013bAA&-\tY1*\u00194lC\n\u0013xn[3s\u0003Y\u0019XM\u001c3MSN$xJ\u001a4tKR\u001c(+Z9vKN$H\u0003BA)\u0003O\u0002B!a\u0015\u0002d5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\tY&!\u0018\u0002\r\r|W.\\8o\u0015\rI\u0012q\f\u0006\u0004\u0003C\u0012\u0016AB1qC\u000eDW-\u0003\u0003\u0002f\u0005U#a\u0005'jgR|eMZ:fiN\u0014Vm\u001d9p]N,\u0007bBA5\u001f\u0001\u0007\u00111N\u0001\be\u0016\fX/Z:u!\u0011\t\u0019&!\u001c\n\t\u0005=\u0014Q\u000b\u0002\u0013\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH/\u0001\ttK:$g)\u001a;dQJ+\u0017/^3tiR!\u0011QOA>!\u0011\t\u0019&a\u001e\n\t\u0005e\u0014Q\u000b\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\t\u000f\u0005%\u0004\u00031\u0001\u0002~A!\u00111KA@\u0013\u0011\t\t)!\u0016\u0003\u0019\u0019+Go\u00195SKF,Xm\u001d;\u0002!\t,\u0018\u000e\u001c3UCJ<W\r\u001e+j[\u0016\u001cHCBAD\u0003{\u000bI\r\u0005\u0004\u0002\n\u0006M\u0015\u0011\u0014\b\u0005\u0003\u0017\u000byID\u0002B\u0003\u001bK\u0011\u0001K\u0005\u0004\u0003#;\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003+\u000b9J\u0001\u0003MSN$(bAAIOA!\u00111TA\\\u001d\u0011\ti*!-\u000f\t\u0005}\u0015q\u0016\b\u0005\u0003C\u000biK\u0004\u0003\u0002$\u0006-f\u0002BAS\u0003Ss1!QAT\u0013\u0005\u0019\u0016bAA1%&\u0019\u0011$a\u0018\n\t\u0005m\u0013QL\u0005\u0004Q\u0006e\u0013\u0002BAZ\u0003k\u000ba\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004Q\u0006e\u0013\u0002BA]\u0003w\u0013\u0001\u0003T5ti>3gm]3ugR{\u0007/[2\u000b\t\u0005M\u0016Q\u0017\u0005\b\u0003\u007f\u000b\u0002\u0019AAa\u0003\t!\b\u000f\u0005\u0003\u0002D\u0006\u0015WBAA-\u0013\u0011\t9-!\u0017\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u00111Z\tA\u0002\u00055\u0017!\u0003;j[\u0016\u001cH/Y7q!\r1\u0013qZ\u0005\u0004\u0003#<#\u0001\u0002'p]\u001e\fQBZ5oIB\u000b'\u000f^5uS>tGCBAl\u0003K\fy\u0010\u0005\u0003\u0002Z\u0006}g\u0002BAO\u00037LA!!8\u00026\u00069B*[:u\u001f\u001a47/\u001a;t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003C\f\u0019O\u0001\u000fMSN$xJ\u001a4tKR\u001c\b+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\u0005u\u0017Q\u0017\u0005\b\u0003O\u0014\u0002\u0019AAu\u0003\u0019!x\u000e]5dgB1\u00111^A{\u0003sl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019pJ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA|\u0003[\u0014aAQ;gM\u0016\u0014\b\u0003BAm\u0003wLA!!@\u0002d\nAB*[:u\u001f\u001a47/\u001a;t)>\u0004\u0018n\u0019*fgB|gn]3\t\u000f\u0005}&\u00031\u0001\u0002B\u0006!2M]3bi\u0016$v\u000e]5d\u0003:$w)\u001a;M_\u001e$bA!\u0002\u0003\u0012\tU\u0001\u0003\u0002B\u0004\u0005\u001bi!A!\u0003\u000b\u0007\t-\u0001$A\u0002m_\u001eLAAa\u0004\u0003\n\tQQK\\5gS\u0016$Gj\\4\t\r\tM1\u00031\u0001?\u0003\u0015!x\u000e]5d\u0011\u001d\u00119b\u0005a\u0001\u0003\u0003\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u000bjg2+\u0017\rZ3s\u0019>\u001c\u0017\r\\(o\u0005J|7.\u001a:\u0015\u0011\tu!1\u0005B\u0013\u0005S\u00012A\nB\u0010\u0013\r\u0011\tc\n\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011\u0019\u0002\u0006a\u0001}!1!q\u0005\u000bA\u0002\u0015\n1\u0002]1si&$\u0018n\u001c8JI\"9\u00111\t\u000bA\u0002\u0005\u001d\u0003f\u0002\u0001\u0003.\te\"1\b\t\u0005\u0005_\u0011)$\u0004\u0002\u00032)\u0019!1\u0007(\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u00038\tE\"a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0003\u00031\u0002")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testGetOffsetsForUnknownTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)false).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L)).asJava()).build((short)1);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testGetOffsetsAfterDeleteRecords(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        log.deleteOldSegments();
        Optional<Object> offset = log.fetchOffsetByTimestamp(-1L, log.fetchOffsetByTimestamp$default$2()).timestampAndOffsetOpt().map(x$2 -> BoxesRunTime.boxToLong((long)x$2.offset));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)20L)), offset);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)1, (int)1).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L)).asJava()).build();
        long consumerOffset = this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).offset();
        Assertions.assertEquals((long)20L, (long)consumerOffset);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Optional firstOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2()).timestampAndOffsetOpt();
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).offset);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).timestamp);
        log.truncateTo(0L);
        Assertions.assertEquals(Optional.empty(), (Object)log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2()).timestampAndOffsetOpt());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L}))).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Optional maxTimestampOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2()).timestampAndOffsetOpt();
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        Assertions.assertEquals((long)5L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)6L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testGetOffsetsBeforeLatestTime(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds((Seq<String>)new .colon.colon((Object)"kafka-", (List)Nil$.MODULE$))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$3 -> x$3.swap())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$4 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Optional<Object> offset = log.fetchOffsetByTimestamp(-1L, log.fetchOffsetByTimestamp$default$2()).timestampAndOffsetOpt().map(x$5 -> BoxesRunTime.boxToLong((long)x$5.offset));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)20L)), offset);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)1, (int)1).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L)).asJava()).build();
        long consumerOffset = this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).offset();
        Assertions.assertEquals((long)20L, (long)consumerOffset);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, consumerOffset, -1L, 307200, Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testEmptyLogsGetOffsets(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = TestUtils.tempDirectory(null, null).getAbsolutePath() + "/" + topic + "-" + topicPartition.partition();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)1, (int)1).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L)).asJava()).build();
            if (this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).offset() == 1L) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        Assertions.assertEquals((Object)new OffsetResultHolder(Optional.empty()), (Object)log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testGetOffsetsBeforeEarliestTime(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$5 = logManager.getOrCreateLog$default$5();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2, x$5);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$7 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Optional<Object> offset = log.fetchOffsetByTimestamp(-2L, log.fetchOffsetByTimestamp$default$2()).timestampAndOffsetOpt().map(x$8 -> BoxesRunTime.boxToLong((long)x$8.offset));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), offset);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)1, (int)1).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L)).asJava()).build();
        long offsetFromResponse = this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).offset();
        Assertions.assertEquals((long)0L, (long)offsetFromResponse);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testFetchOffsetsBeforeWithChangingSegmentSize(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer((Answer)new Answer<Object>(null){
            private final AtomicInteger value;

            public int answer(InvocationOnMock invocation) {
                return this.value.getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        java.util.List logSegments = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$)).asJava();
        Mockito.when((Object)log.logSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testFetchOffsetsBeforeWithChangingSegments(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.logSegments()).thenReturn((Object)new AbstractCollection<LogSegment>(null, logSegment){
            private final LogSegment logSegment$1;

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return Arrays.asList(this.logSegment$1).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$9))).get()).partitions()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$10))).get();
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (UnifiedLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    private boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaBroker broker) {
        return broker.replicaManager().onlinePartition(new TopicPartition(topic, partitionId)).exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$isLeaderLocalOnBroker$1(x$11)));
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(UnifiedLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        NoCompression x$4 = Compression.NONE;
        byte x$5 = 2;
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, (Compression)x$4, x$2, x$5), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(UnifiedLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        NoCompression x$4 = Compression.NONE;
        byte x$5 = 2;
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, (Compression)x$4, timestamp, x$5), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$9) {
        String string = x$9.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$10) {
        return x$10.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$3) {
        return logManager$1.getLog(topicPartition$3, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }

    public static final /* synthetic */ boolean $anonfun$isLeaderLocalOnBroker$1(Partition x$11) {
        return x$11.leaderLogIfLocal().isDefined();
    }
}

