/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.server.ReplicaManager$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpointFile;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmd\u0001\u0002\u001b6\u0001iBQa\u0010\u0001\u0005\u0002\u0001CqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001D\u0011\u0019a\u0005\u0001)A\u0005\t\"9Q\n\u0001b\u0001\n\u0003q\u0005B\u0002*\u0001A\u0003%q\nC\u0004T\u0001\t\u0007I\u0011\u0001(\t\rQ\u0003\u0001\u0015!\u0003P\u0011\u001d)\u0006A1A\u0005\u0002YCaa\u0018\u0001!\u0002\u00139\u0006\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0001b\u0011%Y\u0007\u00011AA\u0002\u0013\u0005A\u000eC\u0005s\u0001\u0001\u0007\t\u0011)Q\u0005E\"91\u000f\u0001b\u0001\n\u0003!\bBB>\u0001A\u0003%Q\u000fC\u0004}\u0001\t\u0007I\u0011\u0001(\t\ru\u0004\u0001\u0015!\u0003P\u0011\u001dq\bA1A\u0005\u0002}D\u0001\"a\u0006\u0001A\u0003%\u0011\u0011\u0001\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0003\tY\u0002C\u0006\u0002$\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0002bCA\u0015\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;A1\"a\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001c!Y\u0011Q\u0006\u0001A\u0002\u0003\u0007I\u0011AA\u0018\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0003\u0006K!!\b\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011\u0011\b\u0001\u0005\u0002\u0005]\u0002\u0002CA\u001e\u0001\t\u0007I\u0011\u0001;\t\u000f\u0005u\u0002\u0001)A\u0005k\"Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011AA!\u0011-\t\t\u0006\u0001a\u0001\u0002\u0004%\t!a\u0015\t\u0017\u0005]\u0003\u00011A\u0001B\u0003&\u00111\t\u0005\f\u00033\u0002\u0001\u0019!a\u0001\n\u0003\tY\u0006C\u0006\u0002\u0002\u0002\u0001\r\u00111A\u0005\u0002\u0005\r\u0005bCAD\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;Bq!!#\u0001\t\u0003\tY\tC\u0004\u0002\"\u0002!\t!a#\t\u0013\u0005\r\u0006\u00011A\u0005\u0002\u0005\u0015\u0006\"CAU\u0001\u0001\u0007I\u0011AAV\u0011!\ty\u000b\u0001Q!\n\u0005\u001d\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\tI\u000e\u0001C!\u0003gCq!a9\u0001\t\u0003\t)\u000fC\u0004\u0003\u0010\u0001!\tA!\u0005\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!q\u0005\u0001\u0005\u0002\t%\u0002b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011%\u0011y\u0006AI\u0001\n\u0013\u0011\tGA\bM_\u001e\u0014VmY8wKJLH+Z:u\u0015\t1t'\u0001\u0004tKJ4XM\u001d\u0006\u0002q\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001<!\taT(D\u00016\u0013\tqTGA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A!\u0011\u0005q\u0002\u0011a\u0005:fa2L7-\u0019'bORKW.Z'bq6\u001bX#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\t1{gnZ\u0001\u0015e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj\u001d\u0011\u0002+I,\u0007\u000f\\5dC2\u000bw-T1y\u001b\u0016\u001c8/Y4fg\u00061\"/\u001a9mS\u000e\fG*Y4NCblUm]:bO\u0016\u001c\b%A\u000bsKBd\u0017nY1GKR\u001c\u0007nV1ji6\u000b\u00070T:\u0016\u0003=\u0003\"!\u0012)\n\u0005E3%aA%oi\u00061\"/\u001a9mS\u000e\fg)\u001a;dQ^\u000b\u0017\u000e^'bq6\u001b\b%\u0001\u000bsKBd\u0017nY1GKR\u001c\u0007.T5o\u0005f$Xm]\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r['j]\nKH/Z:!\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#A,\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001B;uS2T\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\nQ\u0001K]8qKJ$\u0018.Z:\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0013aB2p]\u001aLwm]\u000b\u0002EB\u00191M\u001a5\u000e\u0003\u0011T!!\u001a$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002hI\n\u00191+Z9\u0011\u0005qJ\u0017B\u000166\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017\r|gNZ5hg~#S-\u001d\u000b\u0003[B\u0004\"!\u00128\n\u0005=4%\u0001B+oSRDq!]\u0007\u0002\u0002\u0003\u0007!-A\u0002yIE\n\u0001bY8oM&<7\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002kB\u0011a/_\u0007\u0002o*\u0011\u0001pW\u0001\u0005Y\u0006tw-\u0003\u0002{o\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013a\u00039beRLG/[8o\u0013\u0012\fA\u0002]1si&$\u0018n\u001c8JI\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0002\u0002A!\u00111AA\n\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011AB2p[6|gNC\u00029\u0003\u0017QA!!\u0004\u0002\u0010\u00051\u0011\r]1dQ\u0016T!!!\u0005\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0016\u0005\u0015!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u000591/\u001a:wKJ\fTCAA\u000f!\ra\u0014qD\u0005\u0004\u0003C)$aC&bM.\f'I]8lKJ\f1b]3sm\u0016\u0014\u0018g\u0018\u0013fcR\u0019Q.a\n\t\u0011E4\u0012\u0011!a\u0001\u0003;\t\u0001b]3sm\u0016\u0014\u0018\u0007I\u0001\bg\u0016\u0014h/\u001a:3\u0003-\u0019XM\u001d<feJzF%Z9\u0015\u00075\f\t\u0004\u0003\u0005r3\u0005\u0005\t\u0019AA\u000f\u0003!\u0019XM\u001d<feJ\u0002\u0013\u0001D2p]\u001aLw\r\u0015:paN\fT#\u00015\u0002\u0019\r|gNZ5h!J|\u0007o\u001d\u001a\u0002\u000f5,7o]1hK\u0006AQ.Z:tC\u001e,\u0007%A\u0003bI6Lg.\u0006\u0002\u0002DA!\u0011QIA'\u001b\t\t9E\u0003\u0003\u0002@\u0005%#\u0002BA&\u0003\u0013\tqa\u00197jK:$8/\u0003\u0003\u0002P\u0005\u001d#!B!e[&t\u0017!C1e[&tw\fJ3r)\ri\u0017Q\u000b\u0005\tc\u0002\n\t\u00111\u0001\u0002D\u00051\u0011\rZ7j]\u0002\n\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0003\u0003;\u0002\u0002\"a\u0018\u0002d\u0005\u001d\u0014QN\u0007\u0003\u0003CRA!!\u0017\u0002J%!\u0011QMA1\u00055Y\u0015MZ6b!J|G-^2feB\u0019a/!\u001b\n\u0007\u0005-tOA\u0004J]R,w-\u001a:\u0011\t\u0005=\u0014Q\u0010\b\u0005\u0003c\nI\bE\u0002\u0002t\u0019k!!!\u001e\u000b\u0007\u0005]\u0014(\u0001\u0004=e>|GOP\u0005\u0004\u0003w2\u0015A\u0002)sK\u0012,g-C\u0002{\u0003\u007fR1!a\u001fG\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\ri\u0017Q\u0011\u0005\tc\u000e\n\t\u00111\u0001\u0002^\u0005I\u0001O]8ek\u000e,'\u000fI\u0001\bQ^4\u0015\u000e\\32+\t\ti\t\u0005\u0003\u0002\u0010\u0006uUBAAI\u0015\u0011\t\u0019*!&\u0002\u0015\rDWmY6q_&tGO\u0003\u0003\u0002\u0018\u0006e\u0015!C5oi\u0016\u0014h.\u00197t\u0015\u0011\tY*!\u0003\u0002\u000fM$xN]1hK&!\u0011qTAI\u0005QyeMZ:fi\u000eCWmY6q_&tGOR5mK\u00069\u0001n\u001e$jY\u0016\u0014\u0014aB:feZ,'o]\u000b\u0003\u0003O\u0003Ba\u00194\u0002\u001e\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\ri\u0017Q\u0016\u0005\tc\"\n\t\u00111\u0001\u0002(\u0006A1/\u001a:wKJ\u001c\b%\u0001\bva\u0012\fG/\u001a)s_\u0012,8-\u001a:\u0015\u00035\fQa]3u+B$2!\\A]\u0011\u001d\tYl\u000ba\u0001\u0003{\u000b\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u007f\u000bi-\u0004\u0002\u0002B*!\u00111YAc\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u000f\fI-A\u0004kkBLG/\u001a:\u000b\t\u0005-\u0017qB\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u001f\f\tM\u0001\u0005UKN$\u0018J\u001c4pQ\rY\u00131\u001b\t\u0005\u0003\u007f\u000b).\u0003\u0003\u0002X\u0006\u0005'A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002-\u0003;\u0004B!a0\u0002`&!\u0011\u0011]Aa\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0016uKN$\bjV\"iK\u000e\\\u0007o\\5oi:{g)Y5mkJ,7oU5oO2,Gj\\4TK\u001elWM\u001c;\u0015\u00075\f9\u000fC\u0004\u0002j6\u0002\r!!\u001c\u0002\rE,xN];nQ\ri\u0013Q\u001e\t\u0005\u0003_\f)0\u0004\u0002\u0002r*!\u00111_Ac\u0003\u0019\u0001\u0018M]1ng&!\u0011q_Ay\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b[\u0005m(q\u0001B\u0005!\u0011\tiPa\u0001\u000e\u0005\u0005}(\u0002\u0002B\u0001\u0003c\f\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0005\u000b\tyPA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003\u0005\u0017\t#A!\u0004\u0002\u000b-\u0014\u0018M\u001a;\u0002YQ,7\u000f\u001e%X\u0007\",7m\u001b9pS:$x+\u001b;i\r\u0006LG.\u001e:fgNKgn\u001a7f\u0019><7+Z4nK:$HcA7\u0003\u0014!9\u0011\u0011\u001e\u0018A\u0002\u00055\u0004f\u0001\u0018\u0002n\":a&a?\u0003\b\teAF\u0001B\u0006\u00035\"Xm\u001d;I/\u000eCWmY6q_&tGOT8GC&dWO]3t\u001bVdG/\u001b9mK2{wmU3h[\u0016tGo\u001d\u000b\u0004[\n}\u0001bBAu_\u0001\u0007\u0011Q\u000e\u0015\u0004_\u00055\bfB\u0018\u0002|\n\u001d!Q\u0005\u0017\u0003\u0005\u0017\tq\u0006^3ti\";6\t[3dWB|\u0017N\u001c;XSRDg)Y5mkJ,7/T;mi&\u0004H.\u001a'pON+w-\\3oiN$2!\u001cB\u0016\u0011\u001d\tI\u000f\ra\u0001\u0003[B3\u0001MAwQ\u001d\u0001\u00141 B\u0004\u0005ca#Aa\u0003\u0002\u0019M,g\u000eZ'fgN\fw-Z:\u0015\u00075\u00149\u0004\u0003\u0004\u0003:E\u0002\raT\u0001\u0002]\u00069r-\u001a;MK\u0006$WM]%e\r>\u0014\b+\u0019:uSRLwN\\\u000b\u0005\u0005\u007f\u0011Y\u0005F\u0004P\u0005\u0003\u00129Fa\u0017\t\u000f\t\r#\u00071\u0001\u0003F\u00059!M]8lKJ\u001c\b\u0003B2g\u0005\u000f\u0002BA!\u0013\u0003L1\u0001Aa\u0002B'e\t\u0007!q\n\u0002\u0002\u0005F!!\u0011KA\u000f!\r)%1K\u0005\u0004\u0005+2%a\u0002(pi\"Lgn\u001a\u0005\b\u00053\u0012\u0004\u0019AA\u0001\u0003\t!\b\u000f\u0003\u0005\u0003^I\u0002\n\u00111\u0001E\u0003\u001d!\u0018.\\3pkR\f\u0011eZ3u\u0019\u0016\fG-\u001a:JI\u001a{'\u000fU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIM*BAa\u0019\u0003zU\u0011!Q\r\u0016\u0004\t\n\u001d4F\u0001B5!\u0011\u0011YG!\u001e\u000e\u0005\t5$\u0002\u0002B8\u0005c\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tMd)\u0001\u0006b]:|G/\u0019;j_:LAAa\u001e\u0003n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\t53G1\u0001\u0003P\u0001")
public class LogRecoveryTest
extends QuorumTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps = new Properties();
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private KafkaBroker server1;
    private KafkaBroker server2;
    private final String message;
    private Admin admin;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaBroker> servers;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaBroker server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaBroker x$1) {
        this.server1 = x$1;
    }

    public KafkaBroker server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaBroker x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpointFile hwFile1() {
        return new OffsetCheckpointFile(new File((String)this.configProps1().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), null);
    }

    public OffsetCheckpointFile hwFile2() {
        return new OffsetCheckpointFile(new File((String)this.configProps2().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), null);
    }

    public Seq<KafkaBroker> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaBroker> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$1 = TestUtils$.MODULE$.plaintextBootstrapServers(this.servers());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = -1;
        long x$5 = 60000L;
        long x$6 = 0x100000L;
        int x$7 = Integer.MAX_VALUE;
        int x$8 = 30000;
        int x$9 = 0;
        int x$10 = 16384;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, x$16));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$6 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$6, fromProps_overrides, true);
        })));
        this.server1_$eq(this.createBroker(this.configProps1(), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()));
        this.server2_$eq(this.createBroker(this.configProps2(), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()));
        this.servers_$eq((Seq<KafkaBroker>)new .colon.colon((Object)this.server1(), (List)new .colon.colon((Object)this.server2(), (List)Nil$.MODULE$)));
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), new Properties()));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.servers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        int x$62 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$62, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        this.updateProducer();
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        if (this.admin() != null) {
            this.admin().close();
        }
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testHWCheckpointNoFailuresSingleLogSegment(String quorum) {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$1(this, numMessages)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable)x$7 -> {
            LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(x$7);
            return BoxedUnit.UNIT;
        });
        Long leaderHW = this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((long)numMessages, (Long)leaderHW);
        Long followerHW = this.hwFile2().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((long)numMessages, (Long)followerHW);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testHWCheckpointWithFailuresSingleLogSegment(String quorum) {
        int leader = this.getLeaderIdForPartition(this.servers(), this.topicPartition(), 15000L);
        Assertions.assertEquals((long)0L, (Long)this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        this.sendMessages(1);
        Thread.sleep(1000L);
        long l = 1L;
        this.server1().shutdown();
        Assertions.assertEquals((long)l, (Long)this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        leader = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), this.topicPartition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)leader)), (Option<Object>)None$.MODULE$, 15000L);
        Assertions.assertEquals((int)1, (int)leader, (String)"Leader must move to broker 1");
        this.server1().startup();
        this.updateProducer();
        leader = this.getLeaderIdForPartition(this.servers(), this.topicPartition(), 15000L);
        Assertions.assertTrue((leader == 0 || leader == 1 ? 1 : 0) != 0, (String)"Leader must remain on broker 1, in case of ZooKeeper session expiration it can move to broker 0");
        Assertions.assertEquals((long)l, (Long)this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresSingleLogSegment$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Server 1 is not able to join the ISR after restart");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.server2().shutdown();
        Assertions.assertEquals((long)l, (Long)this.hwFile2().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        this.server2().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), this.topicPartition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)leader)), (Option<Object>)None$.MODULE$, 15000L);
        Assertions.assertTrue((leader == 0 || leader == 1 ? 1 : 0) != 0, (String)"Leader must remain on broker 0, in case of ZooKeeper session expiration it can move to broker 1");
        this.sendMessages(1);
        ++l;
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(this.server2().replicaManager().localLogOrException(this.topicPartition()).highWatermark() == l)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)l, (Long)this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        Assertions.assertEquals((long)l, (Long)this.hwFile2().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testHWCheckpointNoFailuresMultipleLogSegments(String quorum) {
        this.sendMessages(20);
        long hw = 20L;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresMultipleLogSegments$1(this, hw)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable)x$9 -> {
            x$9.shutdown();
            return BoxedUnit.UNIT;
        });
        Long leaderHW = this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((long)hw, (Long)leaderHW);
        Long followerHW = this.hwFile2().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((long)hw, (Long)followerHW);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testHWCheckpointWithFailuresMultipleLogSegments(String quorum) {
        int leader = this.getLeaderIdForPartition(this.servers(), this.topicPartition(), 15000L);
        this.sendMessages(2);
        long l = 2L;
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(this.server2().replicaManager().localLogOrException(this.topicPartition()).highWatermark() == l)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.server1().shutdown();
        this.server2().shutdown();
        Assertions.assertEquals((long)l, (Long)this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        Assertions.assertEquals((long)l, (Long)this.hwFile2().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        this.server2().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), this.topicPartition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)leader)), (Option<Object>)None$.MODULE$, 15000L);
        Assertions.assertEquals((int)1, (int)leader, (String)"Leader must move to broker 1");
        Assertions.assertEquals((long)l, (Long)this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        this.server1().startup();
        this.updateProducer();
        Assertions.assertEquals((long)l, (Long)this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        Assertions.assertEquals((long)l, (Long)this.hwFile2().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        this.sendMessages(2);
        l += 2L;
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresMultipleLogSegments$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to create replica in follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!(this.server1().replicaManager().localLogOrException(this.topicPartition()).highWatermark() == l)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Failed to update high watermark for follower after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable)x$10 -> {
            x$10.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)l, (Long)this.hwFile1().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        Assertions.assertEquals((long)l, (Long)this.hwFile2().read().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
    }

    private void sendMessages(int n) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable)x$11 -> LogRecoveryTest.$anonfun$sendMessages$1(this, BoxesRunTime.unboxToInt((Object)x$11))).foreach((Function1 & Serializable)x$12 -> (RecordMetadata)x$12.get());
    }

    private <B extends KafkaBroker> int getLeaderIdForPartition(Seq<B> brokers, TopicPartition tp, long timeout) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$getLeaderIdForPartition$4(brokers, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeout) {
                Assertions.fail((String)LogRecoveryTest.$anonfun$getLeaderIdForPartition$5(tp, timeout));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeout), waitUntilTrue_pause));
        }
        return BoxesRunTime.unboxToInt((Object)LogRecoveryTest.leaderExists$1(brokers, tp).get());
    }

    private <B extends KafkaBroker> long getLeaderIdForPartition$default$3() {
        return 15000L;
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointNoFailuresSingleLogSegment$1(LogRecoveryTest $this, long numMessages$1) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == numMessages$1;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointNoFailuresSingleLogSegment$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ void $anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(KafkaBroker x$7) {
        x$7.replicaManager().checkpointHighWatermarks();
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresSingleLogSegment$1(LogRecoveryTest $this) {
        return ((Partition)$this.server2().replicaManager().onlinePartition($this.topicPartition()).get()).inSyncReplicaIds().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresSingleLogSegment$2() {
        return "Server 1 is not able to join the ISR after restart";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresSingleLogSegment$3(LogRecoveryTest $this, LongRef hw$1) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresSingleLogSegment$4() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointNoFailuresMultipleLogSegments$1(LogRecoveryTest $this, long hw$2) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$2;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointNoFailuresMultipleLogSegments$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$1(LogRecoveryTest $this, LongRef hw$3) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$3.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$3(LogRecoveryTest $this) {
        return $this.server1().replicaManager().localLog($this.topicPartition()).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$4() {
        return "Failed to create replica in follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$5(LogRecoveryTest $this, LongRef hw$3) {
        return $this.server1().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$3.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$6() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ Future $anonfun$sendMessages$1(LogRecoveryTest $this, int x$11) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)$this.message()));
    }

    public static final /* synthetic */ boolean $anonfun$getLeaderIdForPartition$2(Partition x$13) {
        return x$13.leaderLogIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getLeaderIdForPartition$1(TopicPartition tp$1, KafkaBroker broker) {
        return broker.replicaManager().onlinePartition(tp$1).exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogRecoveryTest.$anonfun$getLeaderIdForPartition$2(x$13)));
    }

    public static final /* synthetic */ int $anonfun$getLeaderIdForPartition$3(KafkaBroker x$14) {
        return x$14.config().brokerId();
    }

    private static final Option leaderExists$1(Seq brokers$1, TopicPartition tp$1) {
        return brokers$1.find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)LogRecoveryTest.$anonfun$getLeaderIdForPartition$1(tp$1, broker))).map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)LogRecoveryTest.$anonfun$getLeaderIdForPartition$3(x$14)));
    }

    public static final /* synthetic */ boolean $anonfun$getLeaderIdForPartition$4(Seq brokers$1, TopicPartition tp$1) {
        return LogRecoveryTest.leaderExists$1(brokers$1, tp$1).isDefined();
    }

    public static final /* synthetic */ String $anonfun$getLeaderIdForPartition$5(TopicPartition tp$1, long timeout$1) {
        return "Did not find a leader for partition " + tp$1 + " after " + timeout$1 + " ms";
    }

    public LogRecoveryTest() {
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps().put("replica.lag.time.max.ms", Long.toString(this.replicaLagTimeMaxMs()));
        this.overridingProps().put("replica.fetch.wait.max.ms", Integer.toString(this.replicaFetchWaitMaxMs()));
        this.overridingProps().put("replica.fetch.min.bytes", Integer.toString(this.replicaFetchMinBytes()));
        this.topic = "new-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.message = "hello";
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

