/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.common.KRaftVersion;
import scala.Function1;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class MetadataCacheTest$ {
    public static final MetadataCacheTest$ MODULE$ = new MetadataCacheTest$();

    public Stream<MetadataCache> cacheProvider() {
        Supplier<KRaftVersion> kRaftMetadataCache_kraftVersionSupplier = () -> KRaftVersion.KRAFT_VERSION_0;
        int kRaftMetadataCache_brokerId = 1;
        Object var2_1 = null;
        return Stream.of(new KRaftMetadataCache(kRaftMetadataCache_brokerId, kRaftMetadataCache_kraftVersionSupplier));
    }

    public void updateCache(MetadataCache cache, Seq<ApiMessage> records) {
        if (cache instanceof KRaftMetadataCache) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)cache;
            MetadataImage image = kRaftMetadataCache.currentImage();
            MetadataImage partialImage = new MetadataImage(new MetadataProvenance(100L, 10, 1000L, true), image.features(), image.cluster(), image.topics(), image.configs(), image.clientQuotas(), image.producerIds(), image.acls(), image.scram(), image.delegationTokens());
            MetadataDelta delta = new MetadataDelta.Builder().setImage(partialImage).build();
            records.foreach((Function1 & Serializable)record -> {
                delta.replay(record);
                return BoxedUnit.UNIT;
            });
            kRaftMetadataCache.setImage(delta.apply(new MetadataProvenance(100L, 10, 1000L, true)));
            return;
        }
        throw new RuntimeException("Unsupported cache type");
    }

    private MetadataCacheTest$() {
    }
}

