/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest;
import kafka.server.MetadataCacheTest$;
import kafka.server.MetadataCacheTest$Broker$2$;
import kafka.server.MetadataCacheTest$Partition$2$;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.KRaftVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tuv!B\"E\u0011\u0003Ie!B&E\u0011\u0003a\u0005\"B*\u0002\t\u0003!\u0006\"B+\u0002\t\u00031\u0006\"\u00023\u0002\t\u0003)g!B&E\u0001\u0005\u0005\u0001BB*\u0006\t\u0003\t\u0019\u0001C\u0005\u0002\b\u0015\u0011\r\u0011\"\u0001\u0002\n!A\u0011\u0011C\u0003!\u0002\u0013\tY\u0001C\u0004\u0002\u0014\u0015!\t!!\u0006\t\u000f\u0005\rS\u0001\"\u0001\u0002F!9\u0011qJ\u0003\u0005\u0002\u0005E\u0003bBA.\u000b\u0011\u0005\u0011Q\f\u0005\b\u0003O*A\u0011BA5\u0011\u001d\ti+\u0002C\u0001\u0003_Cq!!/\u0006\t\u0003\tY\fC\u0004\u0002F\u0016!\t!a2\t\u000f\u0005EW\u0001\"\u0001\u0002T\"9\u0011Q\\\u0003\u0005\u0002\u0005}\u0007bBAu\u000b\u0011%\u00111\u001e\u0005\b\u0005\u001f)A\u0011\u0001B\t\u0011\u001d\u0011\t#\u0002C\u0001\u0005#AqA!\n\u0006\t\u0003\u0011\t\u0002C\u0004\u0003*\u0015!\tA!\u0005\t\u000f\t5R\u0001\"\u0001\u0003\u0012!9!\u0011G\u0003\u0005\u0002\tM\u0002b\u0002B\u001f\u000b\u0011\u0005!\u0011\u0003\u0005\n\u0005\u0003*!\u0019!C\u0001\u0005\u0007B\u0001B!\u0012\u0006A\u0003%\u00111\u0013\u0005\n\u0005\u000f*!\u0019!C\u0001\u0005\u0007B\u0001B!\u0013\u0006A\u0003%\u00111\u0013\u0005\n\u0005\u0017*!\u0019!C\u0001\u0005\u001bB\u0001B!\u001a\u0006A\u0003%!q\n\u0005\n\u0005O*!\u0019!C\u0001\u0005SB\u0001Ba\u001d\u0006A\u0003%!1\u000e\u0005\n\u0005k*!\u0019!C\u0001\u0005oB\u0001Ba \u0006A\u0003%!\u0011\u0010\u0005\n\u0005\u0003+!\u0019!C\u0001\u0005oB\u0001Ba!\u0006A\u0003%!\u0011\u0010\u0005\n\u0005\u000b+!\u0019!C\u0001\u0005oB\u0001Ba\"\u0006A\u0003%!\u0011\u0010\u0005\n\u0005\u0013+!\u0019!C\u0001\u0005oB\u0001Ba#\u0006A\u0003%!\u0011\u0010\u0005\n\u0005\u001b+!\u0019!C\u0001\u0005\u001bB\u0001Ba$\u0006A\u0003%!q\n\u0005\n\u0005#+!\u0019!C\u0001\u0005SB\u0001Ba%\u0006A\u0003%!1\u000e\u0005\n\u0005++!\u0019!C\u0001\u0005SB\u0001Ba&\u0006A\u0003%!1\u000e\u0005\n\u00053+!\u0019!C\u0001\u0005oB\u0001Ba'\u0006A\u0003%!\u0011\u0010\u0005\n\u0005;+!\u0019!C\u0001\u0005oB\u0001Ba(\u0006A\u0003%!\u0011\u0010\u0005\n\u0005C+!\u0019!C\u0001\u0005oB\u0001Ba)\u0006A\u0003%!\u0011\u0010\u0005\n\u0005K+!\u0019!C\u0001\u0005oB\u0001Ba*\u0006A\u0003%!\u0011\u0010\u0005\n\u0005S+!\u0019!C\u0001\u0005oB\u0001Ba+\u0006A\u0003%!\u0011\u0010\u0005\n\u0005[+!\u0019!C\u0001\u0005oB\u0001Ba,\u0006A\u0003%!\u0011\u0010\u0005\n\u0005c+!\u0019!C\u0001\u0005oB\u0001Ba-\u0006A\u0003%!\u0011\u0010\u0005\n\u0005k+!\u0019!C\u0001\u0005oB\u0001Ba.\u0006A\u0003%!\u0011\u0010\u0005\n\u0005s+!\u0019!C\u0001\u0005oB\u0001Ba/\u0006A\u0003%!\u0011P\u0001\u0012\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3UKN$(BA#G\u0003\u0019\u0019XM\u001d<fe*\tq)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005)\u000bQ\"\u0001#\u0003#5+G/\u00193bi\u0006\u001c\u0015m\u00195f)\u0016\u001cHo\u0005\u0002\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A%\u0002\u001b\r\f7\r[3Qe>4\u0018\u000eZ3s)\u00059\u0006c\u0001-`C6\t\u0011L\u0003\u0002[7\u000611\u000f\u001e:fC6T!\u0001X/\u0002\tU$\u0018\u000e\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u0001\u0017L\u0001\u0004TiJ,\u0017-\u001c\t\u0003\u0015\nL!a\u0019#\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003-)\b\u000fZ1uK\u000e\u000b7\r[3\u0015\u0007\u0019L7\u000e\u0005\u0002OO&\u0011\u0001n\u0014\u0002\u0005+:LG\u000fC\u0003k\t\u0001\u0007\u0011-A\u0003dC\u000eDW\rC\u0003m\t\u0001\u0007Q.A\u0004sK\u000e|'\u000fZ:\u0011\u00079\f8/D\u0001p\u0015\t\u0001x*\u0001\u0006d_2dWm\u0019;j_:L!A]8\u0003\u0007M+\u0017\u000f\u0005\u0002u}6\tQO\u0003\u0002wo\u0006A\u0001O]8u_\u000e|GN\u0003\u0002ys\u000611m\\7n_:T!a\u0012>\u000b\u0005md\u0018AB1qC\u000eDWMC\u0001~\u0003\ry'oZ\u0005\u0003\u007fV\u0014!\"\u00119j\u001b\u0016\u001c8/Y4f'\t)Q\n\u0006\u0002\u0002\u0006A\u0011!*B\u0001\fEJ|7.\u001a:Fa>\u001c\u0007.\u0006\u0002\u0002\fA\u0019a*!\u0004\n\u0007\u0005=qJ\u0001\u0003M_:<\u0017\u0001\u00042s_.,'/\u00129pG\"\u0004\u0013!I4fiR{\u0007/[2NKR\fG-\u0019;b\u001d>tW\t_5ti&tw\rV8qS\u000e\u001cHc\u00014\u0002\u0018!)!.\u0003a\u0001C\"\u001a\u0011\"a\u0007\u0011\t\u0005u\u00111F\u0007\u0003\u0003?QA!!\t\u0002$\u00051\u0001/\u0019:b[NTA!!\n\u0002(\u00059!.\u001e9ji\u0016\u0014(bAA\u0015y\u0006)!.\u001e8ji&!\u0011QFA\u0010\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b\u0013\u0005E\u0012QHA !\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"\u0002BA\u001c\u0003?\t\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003w\t)D\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002B\u0005\nQ+\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCR\u0019a-a\u0012\t\u000b)T\u0001\u0019A1)\u0007)\tY\u0002K\u0004\u000b\u0003c\ti$!\u0014-\u0005\u0005\u0005\u0013aK4fiR{\u0007/[2NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:dU-\u00193fe:{G/\u0011<bS2\f'\r\\3\u0015\u0007\u0019\f\u0019\u0006C\u0003k\u0017\u0001\u0007\u0011\rK\u0002\f\u00037AsaCA\u0019\u0003{\tI\u0006\f\u0002\u0002B\u0005)t-\u001a;U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019&\u001cH/\u001a8fe:{G/\u0011<bS2\f'\r\\3P]2+\u0017\rZ3s)\r1\u0017q\f\u0005\u0006U2\u0001\r!\u0019\u0015\u0004\u0019\u0005m\u0001f\u0002\u0007\u00022\u0005u\u0012Q\r\u0017\u0003\u0003\u0003\n\u0001H^3sS\u001aLHk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014xJ]#oIB|\u0017N\u001c;O_R\fe/Y5mC\ndW\rF\u0007g\u0003W\ni'a \u0002\u0010\u0006e\u00151\u0015\u0005\u0006U6\u0001\r!\u0019\u0005\b\u0003_j\u0001\u0019AA9\u0003\u001d\u0011'o\\6feN\u0004BA\\9\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002z]\f\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003{\n9H\u0001\u000bSK\u001eL7\u000f^3s\u0005J|7.\u001a:SK\u000e|'\u000f\u001a\u0005\b\u0003\u0003k\u0001\u0019AAB\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAEo\u00069a.\u001a;x_J\\\u0017\u0002BAG\u0003\u000f\u0013A\u0002T5ti\u0016tWM\u001d(b[\u0016Dq!!%\u000e\u0001\u0004\t\u0019*\u0001\u0004mK\u0006$WM\u001d\t\u0004\u001d\u0006U\u0015bAAL\u001f\n\u0019\u0011J\u001c;\t\u000f\u0005mU\u00021\u0001\u0002\u001e\u0006iQ\r\u001f9fGR,G-\u0012:s_J\u00042\u0001^AP\u0013\r\t\t+\u001e\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u0005\u0015V\u00021\u0001\u0002(\u0006IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t!\rq\u0015\u0011V\u0005\u0004\u0003W{%a\u0002\"p_2,\u0017M\\\u0001$O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006\u0014V\r\u001d7jG\u0006tu\u000e^!wC&d\u0017M\u00197f)\r1\u0017\u0011\u0017\u0005\u0006U:\u0001\r!\u0019\u0015\u0004\u001d\u0005m\u0001f\u0002\b\u00022\u0005u\u0012q\u0017\u0017\u0003\u0003\u0003\nqdZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1JgJtu\u000e^!wC&d\u0017M\u00197f)\r1\u0017Q\u0018\u0005\u0006U>\u0001\r!\u0019\u0015\u0004\u001f\u0005m\u0001fB\b\u00022\u0005u\u00121\u0019\u0017\u0003\u0003\u0003\n\u0001gZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1XSRDgj\u001c8TkB\u0004xN\u001d;fIN+7-\u001e:jif\u0004&o\u001c;pG>dGc\u00014\u0002J\")!\u000e\u0005a\u0001C\"\u001a\u0001#a\u0007)\u000fA\t\t$!\u0010\u0002P2\u0012\u0011\u0011I\u0001/O\u0016$\u0018\t\\5wK\n\u0013xn[3sgNCw.\u001e7e\u001d>$()Z'vi\u0006$X\r\u001a\"z+B$\u0017\r^3DC\u000eDW\rF\u0002g\u0003+DQA[\tA\u0002\u0005D3!EA\u000eQ\u001d\t\u0012\u0011GA\u001f\u00037d#!!\u0011\u0002AQ,7\u000f^$fiB\u000b'\u000f^5uS>t'+\u001a9mS\u000e\fWI\u001c3q_&tGo\u001d\u000b\u0004M\u0006\u0005\b\"\u00026\u0013\u0001\u0004\t\u0007f\u0001\n\u0002\u001c!:!#!\r\u0002>\u0005\u001dHFAA!\u0003E9W\r^!mYJ+\u0007\u000f\\5dCN+Go\u001d\u000b\u0007\u0003[\u00149Aa\u0003\u0011\u000b9\u000by/a=\n\u0007\u0005ExJA\u0003BeJ\f\u0017\u0010\u0005\u0004\u0002v\u0006]\u00181`\u0007\u00027&\u0019\u0011\u0011`.\u0003\t1K7\u000f\u001e\t\u0005\u0003{\u0014\u0019!\u0004\u0002\u0002\u0000*\u0019!\u0011A/\u0002\t1\fgnZ\u0005\u0005\u0005\u000b\tyPA\u0004J]R,w-\u001a:\t\u000f\t%1\u00031\u0001\u0002\u0014\u0006Qa.^7Ce>\\WM]:\t\u000f\t51\u00031\u0001\u0002\u0014\u0006\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0002%Q,7\u000f^%t\u0005J|7.\u001a:GK:\u001cW\r\u001a\u000b\u0002M\"\u001aAC!\u0006\u0011\t\t]!QD\u0007\u0003\u00053QAAa\u0007\u0002$\u0005\u0019\u0011\r]5\n\t\t}!\u0011\u0004\u0002\u0005)\u0016\u001cH/A\u0012uKN$x)\u001a;BY&4XM\u0011:pW\u0016\u00148oV5uQ\n\u0013xn[3s\r\u0016t7-\u001a3)\u0007U\u0011)\"\u0001\u0011uKN$\u0018j\u001d\"s_.,'/\u00138D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007f\u0001\f\u0003\u0016\u00051B/Z:u\u000f\u0016$H*\u001b<f\u0005J|7.\u001a:Fa>\u001c\u0007\u000eK\u0002\u0018\u0005+\ta\u0007^3ti\u001e+G\u000fV8qS\u000elU\r^1eCR\fgi\u001c:EKN\u001c'/\u001b2f)>\u0004\u0018n\u0019)beRLG/[8ogJ+7\u000f]8og\u0016D3\u0001\u0007B\u000b\u0003M!Xm\u001d;HKRdU-\u00193fe\u0006sG-S:s)\r1'Q\u0007\u0005\u0006Uf\u0001\r!\u0019\u0015\u00043\u0005m\u0001fB\r\u00022\u0005u\"1\b\u0017\u0003\u0003\u0003\nA\u0006^3ti\u001e+Go\u00144gY&tWMU3qY&\u001c\u0017m]\"p]NLG-\u001a:t\t&\u0014\u0018i]:jO:lWM\u001c;)\u0007i\u0011)\"A\rpY\u0012\u0014V-];fgR\u001cuN\u001c;s_2dWM]#q_\u000eDWCAAJ\u0003iyG\u000e\u001a*fcV,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0003eqWm\u001e*fcV,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u000259,wOU3rk\u0016\u001cHoQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0011\u0002\u0019\u0019|w\u000eV8qS\u000et\u0015-\\3\u0016\u0005\t=\u0003\u0003\u0002B)\u0005?rAAa\u0015\u0003\\A\u0019!QK(\u000e\u0005\t]#b\u0001B-\u0011\u00061AH]8pizJ1A!\u0018P\u0003\u0019\u0001&/\u001a3fM&!!\u0011\rB2\u0005\u0019\u0019FO]5oO*\u0019!QL(\u0002\u001b\u0019|w\u000eV8qS\u000et\u0015-\\3!\u0003)1wn\u001c+pa&\u001c\u0017\nZ\u000b\u0003\u0005W\u0002BA!\u001c\u0003p5\tq/C\u0002\u0003r]\u0014A!V;jI\u0006Yam\\8U_BL7-\u00133!\u0003-yG\u000e\u001a$p_B\u000b'\u000f\u001e\u0019\u0016\u0005\te\u0004\u0003BA;\u0005wJAA! \u0002x\ty\u0001+\u0019:uSRLwN\u001c*fG>\u0014H-\u0001\u0007pY\u00124un\u001c)beR\u0004\u0004%A\u0006oK^4un\u001c)beR\u0004\u0014\u0001\u00048fo\u001a{w\u000eU1siB\u0002\u0013aC8mI\u001a{w\u000eU1siF\nAb\u001c7e\r>|\u0007+\u0019:uc\u0001\n1B\\3x\r>|\u0007+\u0019:uc\u0005aa.Z<G_>\u0004\u0016M\u001d;2A\u0005a!-\u0019:U_BL7MT1nK\u0006i!-\u0019:U_BL7MT1nK\u0002\n!BY1s)>\u0004\u0018nY%e\u0003-\u0011\u0017M\u001d+pa&\u001c\u0017\n\u001a\u0011\u0002'I,7M]3bi\u0016$')\u0019:U_BL7-\u00133\u0002)I,7M]3bi\u0016$')\u0019:U_BL7-\u00133!\u0003-yG\u000e\u001a\"beB\u000b'\u000f\u001e\u0019\u0002\u0019=dGMQ1s!\u0006\u0014H\u000f\r\u0011\u0002\u00179,wOQ1s!\u0006\u0014H\u000fM\u0001\r]\u0016<()\u0019:QCJ$\b\u0007I\u0001\u0010I\u0016dW\r^3e\u0005\u0006\u0014\b+\u0019:ua\u0005\u0001B-\u001a7fi\u0016$')\u0019:QCJ$\b\u0007I\u0001\f_2$')\u0019:QCJ$\u0018'\u0001\u0007pY\u0012\u0014\u0015M\u001d)beR\f\u0004%A\u0006oK^\u0014\u0015M\u001d)beR\f\u0014\u0001\u00048fo\n\u000b'\u000fU1siF\u0002\u0013a\u00043fY\u0016$X\r\u001a\"beB\u000b'\u000f^\u0019\u0002!\u0011,G.\u001a;fI\n\u000b'\u000fU1siF\u0002\u0013aC8mI\n\u000b'\u000fU1siJ\nAb\u001c7e\u0005\u0006\u0014\b+\u0019:ue\u0001\n1B\\3x\u0005\u0006\u0014\b+\u0019:ue\u0005aa.Z<CCJ\u0004\u0016M\u001d;3A\u0005yA-\u001a7fi\u0016$')\u0019:QCJ$('\u0001\teK2,G/\u001a3CCJ\u0004\u0016M\u001d;3A\u0001")
public class MetadataCacheTest {
    private final long brokerEpoch;
    private final int oldRequestControllerEpoch;
    private final int newRequestControllerEpoch;
    private final String fooTopicName;
    private final Uuid fooTopicId = Uuid.fromString((String)"HDceyWK0Ry-j3XLR8DvvGA");
    private final PartitionRecord oldFooPart0 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(0).setLeader(4).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord newFooPart0 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(0).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord oldFooPart1 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(1).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord newFooPart1 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(1).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final String barTopicName;
    private final Uuid barTopicId = Uuid.fromString((String)"97FBD1g4QyyNNZNY94bkRA");
    private final Uuid recreatedBarTopicId = Uuid.fromString((String)"lZokxuaPRty7c5P4dNdTYA");
    private final PartitionRecord oldBarPart0 = new PartitionRecord().setTopicId(this.fooTopicId()).setPartitionId(0).setLeader(7).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord newBarPart0 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(0).setLeader(7).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord deletedBarPart0 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(0).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord oldBarPart1 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(1).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord newBarPart1 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(1).setLeader(5).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord deletedBarPart1 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(1).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)));
    private final PartitionRecord oldBarPart2 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(2).setLeader(9).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord newBarPart2 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(2).setLeader(8).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));
    private final PartitionRecord deletedBarPart2 = new PartitionRecord().setTopicId(this.barTopicId()).setPartitionId(2).setLeader(-2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8), Predef$.MODULE$.int2Integer(9)));

    public static void updateCache(MetadataCache cache, Seq<ApiMessage> records) {
        MetadataCacheTest$.MODULE$.updateCache(cache, records);
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        TopicRecord topic0Record = new TopicRecord().setName(topic0).setTopicId((Uuid)topicIds.get(topic0));
        TopicRecord topic1Record = new TopicRecord().setName(topic1).setTopicId((Uuid)topicIds.get(topic1));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(0).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)new .colon.colon((Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(1).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4))), (List)new .colon.colon((Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic1)).setPartitionId(0).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)Nil$.MODULE$)));
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)new .colon.colon((Object)topic0Record, (List)new .colon.colon((Object)topic1Record, (List)Nil$.MODULE$)))).$plus$plus((IterableOnce)partitionStates)));
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)Nil$.MODULE$);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, (Seq<RegisterBrokerRecord>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, (Seq<RegisterBrokerRecord>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        RegisterBrokerRecord.BrokerEndpointCollection broker0Endpoints = new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setName(plaintextListenerName.value()), (List)new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setName(sslListenerName.value()), (List)Nil$.MODULE$)).iterator()).asJava());
        RegisterBrokerRecord.BrokerEndpointCollection broker1Endpoints = new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setName(plaintextListenerName.value()), (List)Nil$.MODULE$).iterator()).asJava());
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(broker0Endpoints), (List)new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(1).setFenced(false).setEndPoints(broker1Endpoints), (List)Nil$.MODULE$));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, (Seq<RegisterBrokerRecord>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, (Seq<RegisterBrokerRecord>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, Seq<RegisterBrokerRecord> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        int leaderEpoch = 1;
        int partitionEpoch = 3;
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(0).setPartitionEpoch(partitionEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0))), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionStates)));
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        int partitionEpoch = 3;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        RegisterBrokerRecord.BrokerEndpointCollection endPoints = new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava());
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(endPoints), (List)Nil$.MODULE$);
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(0).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setPartitionEpoch(partitionEpoch).setReplicas(replicas), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionStates)));
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava());
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setRack("rack1").setFenced(false).setEndPoints(endpoints), (List)Nil$.MODULE$);
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(0).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setReplicas(replicas), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionStates)));
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        RegisterBrokerRecord brokers = new RegisterBrokerRecord().setBrokerId(0).setRack("").setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$).iterator()).asJava()));
        TopicRecord topicRecord = new TopicRecord().setName(topic).setTopicId(topicId);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(0).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setReplicas(replicas), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)new .colon.colon((Object)brokers, (List)new .colon.colon((Object)topicRecord, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)partitionStates)));
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topicId, cache, (Seq)topicRecords);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), topicId, cache, (Seq)topicRecords);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((IterableOnceOps)aliveBrokersFromCache.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id))).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void testGetPartitionReplicaEndpoints(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int numBrokers = 10;
        int fencedBrokerId = numBrokers / 3;
        IndexedSeq brokerRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBrokers).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$testGetPartitionReplicaEndpoints$1(fencedBrokerId, securityProtocol, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        String topic = "many-partitions-topic";
        Uuid topicId = Uuid.randomUuid();
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        int replicationFactor = 3;
        java.util.List[] replicaSets = this.getAllReplicaSets(numBrokers, replicationFactor);
        int numPartitions = replicaSets.length;
        IndexedSeq partitionRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)partitionId -> MetadataCacheTest.$anonfun$testGetPartitionReplicaEndpoints$2(replicaSets, fencedBrokerId, topicId, BoxesRunTime.unboxToInt((Object)partitionId)));
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokerRecords.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionRecords)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> {
            TopicPartition tp = new TopicPartition(topic, partitionId);
            Map brokerIdToNodeMap = cache.getPartitionReplicaEndpoints(tp, listenerName);
            Set replicaSet = brokerIdToNodeMap.keySet();
            scala.collection.immutable.Set expectedReplicaSet = CollectionConverters$.MODULE$.ListHasAsScala(((PartitionRecord)partitionRecords.apply(partitionId)).replicas()).asScala().toSet();
            if (expectedReplicaSet.contains((Object)Predef$.MODULE$.int2Integer(fencedBrokerId))) {
                Assertions.assertEquals((Object)expectedReplicaSet, (Object)replicaSet.$plus((Object)BoxesRunTime.boxToInteger((int)fencedBrokerId)), (String)("Unexpected partial replica set for partition " + partitionId));
            } else {
                Assertions.assertEquals((Object)expectedReplicaSet, (Object)replicaSet, (String)("Unexpected replica set for partition " + partitionId));
            }
            replicaSet.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
                Node brokerNode = (Node)brokerIdToNodeMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)("No brokerNode for broker " + brokerId + " and partition " + partitionId)));
                RegisterBrokerRecord expectedBroker = (RegisterBrokerRecord)brokerRecords.apply(brokerId);
                RegisterBrokerRecord.BrokerEndpoint expectedEndpoint = expectedBroker.endPoints().find(listenerName.value());
                Assertions.assertEquals((Object)expectedEndpoint.host(), (Object)brokerNode.host(), (String)("Unexpected host for broker " + brokerId + " and partition " + partitionId));
                Assertions.assertEquals((int)expectedEndpoint.port(), (int)brokerNode.port(), (String)("Unexpected port for broker " + brokerId + " and partition " + partitionId));
                Assertions.assertEquals((Object)expectedBroker.rack(), (Object)brokerNode.rack(), (String)("Unexpected rack for broker " + brokerId + " and partition " + partitionId));
            });
        });
        TopicPartition tp = new TopicPartition(topic, numPartitions);
        Assertions.assertTrue((boolean)cache.getPartitionReplicaEndpoints(tp, listenerName).isEmpty());
    }

    private java.util.List<Integer>[] getAllReplicaSets(int numBrokers, int replicationFactor) {
        return (java.util.List[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBrokers).combinations(replicationFactor).map((Function1 & Serializable)replicaSet -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)replicaSet.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).toList()).asJava()).toArray(ClassTag$.MODULE$.apply(java.util.List.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsBrokerFenced() {
        void kRaftMetadataCache_kraftVersionSupplier;
        Supplier<KRaftVersion> supplier = () -> KRaftVersion.KRAFT_VERSION_0;
        int kRaftMetadataCache_brokerId = 0;
        supplier = null;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId, (Supplier)kRaftMetadataCache_kraftVersionSupplier);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetAliveBrokersWithBrokerFenced() {
        void kRaftMetadataCache_kraftVersionSupplier;
        Supplier<KRaftVersion> supplier = () -> KRaftVersion.KRAFT_VERSION_0;
        int kRaftMetadataCache_brokerId = 0;
        supplier = null;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId, (Supplier)kRaftMetadataCache_kraftVersionSupplier);
        String listenerName = "listener";
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection();
        endpoints.add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setName(listenerName).setHost("foo").setPort(123).setSecurityProtocol((short)0));
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(endpoints));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setFenced(false).setEndPoints(endpoints));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(1).setFenced((byte)1));
        MetadataImage metadataImage = delta.apply(MetadataProvenance.EMPTY);
        metadataCache.setImage(metadataImage);
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(1));
        scala.collection.immutable.Set aliveBrokers = ((IterableOnceOps)metadataCache.getAliveBrokers().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id))).toSet();
        metadataImage.cluster().brokers().forEach((brokerId, registration) -> {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!registration.fenced() ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)aliveBrokers.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))));
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)aliveBrokers.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))), (Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.getAliveBrokerNode(Predef$.MODULE$.Integer2int(brokerId), new ListenerName(listenerName)).isDefined()));
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsBrokerInControlledShutdown() {
        void kRaftMetadataCache_kraftVersionSupplier;
        Supplier<KRaftVersion> supplier = () -> KRaftVersion.KRAFT_VERSION_0;
        int kRaftMetadataCache_brokerId = 0;
        supplier = null;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId, (Supplier)kRaftMetadataCache_kraftVersionSupplier);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetLiveBrokerEpoch() {
        void kRaftMetadataCache_kraftVersionSupplier;
        Supplier<KRaftVersion> supplier = () -> KRaftVersion.KRAFT_VERSION_0;
        int kRaftMetadataCache_brokerId = 0;
        supplier = null;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId, (Supplier)kRaftMetadataCache_kraftVersionSupplier);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(101L).setFenced(true));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertEquals((long)100L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(0).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(1).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetTopicMetadataForDescribeTopicPartitionsResponse() {
        void kRaftMetadataCache_kraftVersionSupplier;
        Supplier<KRaftVersion> supplier = () -> KRaftVersion.KRAFT_VERSION_0;
        int kRaftMetadataCache_brokerId = 0;
        supplier = null;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId, (Supplier)kRaftMetadataCache_kraftVersionSupplier);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        String topic0 = "test0";
        String topic1 = "test1";
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        scala.collection.immutable.Map partitionMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)topic0, (Object)BoxesRunTime.boxToInteger((int)0))), (Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))).setLeader(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setEligibleLeaderReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1))).setLastKnownElr(Arrays.asList(Predef$.MODULE$.int2Integer(2))).setLeaderEpoch(0).setPartitionEpoch(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)topic0, (Object)BoxesRunTime.boxToInteger((int)2))), (Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(2).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3))).setLeader(3).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(3))).setEligibleLeaderReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2))).setLastKnownElr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setLeaderEpoch(1).setPartitionEpoch(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)topic0, (Object)BoxesRunTime.boxToInteger((int)1))), (Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic0)).setPartitionId(1).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setLeader(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setEligibleLeaderReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1))).setLastKnownElr(Arrays.asList(Predef$.MODULE$.int2Integer(3))).setLeaderEpoch(0).setPartitionEpoch(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)topic1, (Object)BoxesRunTime.boxToInteger((int)0))), (Object)new PartitionRecord().setTopicId((Uuid)topicIds.get(topic1)).setPartitionId(0).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))).setLeader(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2))).setEligibleLeaderReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1))).setLastKnownElr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setLeaderEpoch(10).setPartitionEpoch(11).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()))}));
        new RegisterBrokerRecord.BrokerEndpointCollection();
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerEpoch(this.brokerEpoch()).setFenced(false).setBrokerId(0).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo0").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)new .colon.colon((Object)new RegisterBrokerRecord().setBrokerEpoch(this.brokerEpoch()).setFenced(false).setBrokerId(1).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo1").setPort(9093).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)new .colon.colon((Object)new RegisterBrokerRecord().setBrokerEpoch(this.brokerEpoch()).setFenced(false).setBrokerId(2).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo2").setPort(9094).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)new .colon.colon((Object)new RegisterBrokerRecord().setBrokerEpoch(this.brokerEpoch()).setFenced(false).setBrokerId(3).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo3").setPort(9095).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)Nil$.MODULE$))));
        .colon.colon recordSeq = new .colon.colon((Object)new TopicRecord().setName(topic0).setTopicId((Uuid)topicIds.get(topic0)), (List)new .colon.colon((Object)new TopicRecord().setName(topic1).setTopicId((Uuid)topicIds.get(topic1)), (List)Nil$.MODULE$));
        recordSeq = (Seq)recordSeq.$plus$plus((IterableOnce)partitionMap.values().toSeq());
        MetadataCacheTest$.MODULE$.updateCache((MetadataCache)metadataCache, (Seq<ApiMessage>)((Seq)brokers.$plus$plus((IterableOnce)recordSeq)));
        List result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)metadataCache.getTopicMetadataForDescribeTopicResponse(new .colon.colon((Object)topic0, (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).iterator(), listenerName, (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)MetadataCacheTest.$anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$3(x$5)), 10, false).topics()).asScala().toList();
        Assertions.assertEquals((int)2, (int)result.size());
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)3, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(1);
        Assertions.assertEquals((Object)topic1, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic1), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)1, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        DescribeTopicPartitionsResponseData response = metadataCache.getTopicMetadataForDescribeTopicResponse(new .colon.colon((Object)topic0, (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).iterator(), listenerName, (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)MetadataCacheTest.$anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$4(x$6)), 2, false);
        result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.topics()).asScala().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)2, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        Assertions.assertEquals((Object)topic0, (Object)response.nextCursor().topicName());
        Assertions.assertEquals((int)2, (int)response.nextCursor().partitionIndex());
        result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)metadataCache.getTopicMetadataForDescribeTopicResponse(new .colon.colon((Object)topic0, (List)Nil$.MODULE$).iterator(), listenerName, (Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)MetadataCacheTest.$anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$5(topic0, t)), 10, false).topics()).asScala().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)2, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        response = metadataCache.getTopicMetadataForDescribeTopicResponse(new .colon.colon((Object)topic0, (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).iterator(), listenerName, (Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)MetadataCacheTest.$anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$6(topic0, t)), 1, false);
        result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.topics()).asScala().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)1, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
        Assertions.assertEquals((Object)topic1, (Object)response.nextCursor().topicName());
        Assertions.assertEquals((int)0, (int)response.nextCursor().partitionIndex());
        result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)metadataCache.getTopicMetadataForDescribeTopicResponse(new .colon.colon((Object)"Non-exist", (List)new .colon.colon((Object)topic0, (List)Nil$.MODULE$)).iterator(), listenerName, (Function1 & Serializable)t -> BoxesRunTime.boxToInteger((int)MetadataCacheTest.$anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$7(t)), 1, false).topics()).asScala().toList();
        Assertions.assertEquals((int)2, (int)result.size());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(0);
        Assertions.assertEquals((Object)"Non-exist", (Object)resultTopic.name());
        Assertions.assertEquals((int)3, (int)resultTopic.errorCode());
        resultTopic = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)result.apply(1);
        Assertions.assertEquals((Object)topic0, (Object)resultTopic.name());
        Assertions.assertEquals((int)0, (int)resultTopic.errorCode());
        Assertions.assertEquals(topicIds.get(topic0), (Object)resultTopic.topicId());
        Assertions.assertEquals((int)1, (int)resultTopic.partitions().size());
        MetadataCacheTest.checkTopicMetadata$2(topic0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CollectionConverters$.MODULE$.ListHasAsScala(resultTopic.partitions()).asScala(), partitionMap);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void testGetLeaderAndIsr(MetadataCache cache) {
        String topic = "topic";
        Uuid topicId = Uuid.randomUuid();
        int partitionIndex = 0;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(4));
        .colon.colon topicRecords = new .colon.colon((Object)new TopicRecord().setName(topic).setTopicId(topicId), (List)Nil$.MODULE$);
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId).setPartitionId(partitionIndex).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setReplicas(replicas), (List)Nil$.MODULE$);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(this.brokerEpoch()).setRack("rack1").setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(listenerName.value()), (List)Nil$.MODULE$).iterator()).asJava())), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords)).$plus$plus((IterableOnce)partitionStates)));
        Option leaderAndIsr = cache.getLeaderAndIsr(topic, partitionIndex);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leader)), (Object)leaderAndIsr.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.leader())));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)leaderAndIsr.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.leaderEpoch())));
        Assertions.assertEquals((Object)new Some(isr), (Object)leaderAndIsr.map((Function1 & Serializable)x$9 -> x$9.isr()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)-1)), (Object)leaderAndIsr.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.partitionEpoch())));
        Assertions.assertEquals((Object)new Some((Object)LeaderRecoveryState.RECOVERED), (Object)leaderAndIsr.map((Function1 & Serializable)x$11 -> x$11.leaderRecoveryState()));
    }

    @Test
    public void testGetOfflineReplicasConsidersDirAssignment() {
        new LazyRef();
        new LazyRef();
        public class Kafka_server_MetadataCacheTest$Broker$1
        implements Product,
        Serializable {
            private final int id;
            private final java.util.List<Uuid> dirs;
            private final /* synthetic */ MetadataCacheTest $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public int id() {
                return this.id;
            }

            public java.util.List<Uuid> dirs() {
                return this.dirs;
            }

            public Kafka_server_MetadataCacheTest$Broker$1 copy(int id, java.util.List<Uuid> dirs) {
                return new Kafka_server_MetadataCacheTest$Broker$1(this.$outer, id, dirs);
            }

            public int copy$default$1() {
                return this.id();
            }

            public java.util.List<Uuid> copy$default$2() {
                return this.dirs();
            }

            public String productPrefix() {
                return "Broker";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this.id());
                    }
                    case 1: {
                        return this.dirs();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_server_MetadataCacheTest$Broker$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "id";
                    }
                    case 1: {
                        return "dirs";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"Broker".hashCode()), (int)this.id()), (int)Statics.anyHash(this.dirs())), (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        if (!(x$1 instanceof Kafka_server_MetadataCacheTest$Broker$1)) break block3;
                        Kafka_server_MetadataCacheTest$Broker$1 var2_2 = (Kafka_server_MetadataCacheTest$Broker$1)x$1;
                        if (this.id() != var2_2.id()) break block3;
                        java.util.List<Uuid> list = this.dirs();
                        java.util.List<Uuid> list2 = var2_2.dirs();
                        if (list != null ? !((Object)list).equals(list2) : list2 != null) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Kafka_server_MetadataCacheTest$Broker$1(MetadataCacheTest $outer, int id, java.util.List<Uuid> dirs) {
                this.id = id;
                this.dirs = dirs;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        .colon.colon brokers = new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Broker$1(this, 0, Arrays.asList(Uuid.fromString((String)"broker1logdirjEo71BG0w"))), (List)new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Broker$1(this, 1, Arrays.asList(Uuid.fromString((String)"broker2logdirRmQQgLxgw"))), (List)Nil$.MODULE$));
        public class Kafka_server_MetadataCacheTest$Partition$1
        implements Product,
        Serializable {
            private final int id;
            private final java.util.List<Integer> replicas;
            private final java.util.List<Uuid> dirs;
            private final /* synthetic */ MetadataCacheTest $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public int id() {
                return this.id;
            }

            public java.util.List<Integer> replicas() {
                return this.replicas;
            }

            public java.util.List<Uuid> dirs() {
                return this.dirs;
            }

            public Kafka_server_MetadataCacheTest$Partition$1 copy(int id, java.util.List<Integer> replicas, java.util.List<Uuid> dirs) {
                return new Kafka_server_MetadataCacheTest$Partition$1(this.$outer, id, replicas, dirs);
            }

            public int copy$default$1() {
                return this.id();
            }

            public java.util.List<Integer> copy$default$2() {
                return this.replicas();
            }

            public java.util.List<Uuid> copy$default$3() {
                return this.dirs();
            }

            public String productPrefix() {
                return "Partition";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this.id());
                    }
                    case 1: {
                        return this.replicas();
                    }
                    case 2: {
                        return this.dirs();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_server_MetadataCacheTest$Partition$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "id";
                    }
                    case 1: {
                        return "replicas";
                    }
                    case 2: {
                        return "dirs";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"Partition".hashCode()), (int)this.id()), (int)Statics.anyHash(this.replicas())), (int)Statics.anyHash(this.dirs())), (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        if (!(x$1 instanceof Kafka_server_MetadataCacheTest$Partition$1)) break block3;
                        Kafka_server_MetadataCacheTest$Partition$1 var2_2 = (Kafka_server_MetadataCacheTest$Partition$1)x$1;
                        if (this.id() != var2_2.id()) break block3;
                        java.util.List<Integer> list = this.replicas();
                        java.util.List<Integer> list2 = var2_2.replicas();
                        if (list != null ? !((Object)list).equals(list2) : list2 != null) break block3;
                        java.util.List<Uuid> list3 = this.dirs();
                        java.util.List<Uuid> list4 = var2_2.dirs();
                        if (list3 != null ? !((Object)list3).equals(list4) : list4 != null) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Kafka_server_MetadataCacheTest$Partition$1(MetadataCacheTest $outer, int id, java.util.List<Integer> replicas, java.util.List<Uuid> dirs) {
                this.id = id;
                this.replicas = replicas;
                this.dirs = dirs;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        .colon.colon partitions = new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Partition$1(this, 0, Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Uuid.fromString((String)"broker1logdirjEo71BG0w"), DirectoryId.LOST)), (List)new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Partition$1(this, 1, Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Uuid.fromString((String)"unknownlogdirjEo71BG0w"), DirectoryId.UNASSIGNED)), (List)new .colon.colon((Object)new Kafka_server_MetadataCacheTest$Partition$1(this, 2, Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(DirectoryId.MIGRATING, Uuid.fromString((String)"broker2logdirRmQQgLxgw"))), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Arrays.asList(new Nothing$[0]))})), (Object)MetadataCacheTest.offlinePartitions$1((Seq)brokers, (Seq)partitions));
    }

    public int oldRequestControllerEpoch() {
        return this.oldRequestControllerEpoch;
    }

    public int newRequestControllerEpoch() {
        return this.newRequestControllerEpoch;
    }

    public String fooTopicName() {
        return this.fooTopicName;
    }

    public Uuid fooTopicId() {
        return this.fooTopicId;
    }

    public PartitionRecord oldFooPart0() {
        return this.oldFooPart0;
    }

    public PartitionRecord newFooPart0() {
        return this.newFooPart0;
    }

    public PartitionRecord oldFooPart1() {
        return this.oldFooPart1;
    }

    public PartitionRecord newFooPart1() {
        return this.newFooPart1;
    }

    public String barTopicName() {
        return this.barTopicName;
    }

    public Uuid barTopicId() {
        return this.barTopicId;
    }

    public Uuid recreatedBarTopicId() {
        return this.recreatedBarTopicId;
    }

    public PartitionRecord oldBarPart0() {
        return this.oldBarPart0;
    }

    public PartitionRecord newBarPart0() {
        return this.newBarPart0;
    }

    public PartitionRecord deletedBarPart0() {
        return this.deletedBarPart0;
    }

    public PartitionRecord oldBarPart1() {
        return this.oldBarPart1;
    }

    public PartitionRecord newBarPart1() {
        return this.newBarPart1;
    }

    public PartitionRecord deletedBarPart1() {
        return this.deletedBarPart1;
    }

    public PartitionRecord oldBarPart2() {
        return this.oldBarPart2;
    }

    public PartitionRecord newBarPart2() {
        return this.newBarPart2;
    }

    public PartitionRecord deletedBarPart2() {
        return this.deletedBarPart2;
    }

    private static final RegisterBrokerRecord.BrokerEndpointCollection endpoints$1(int brokerId) {
        String host = "foo-" + brokerId;
        return new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setName(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setName(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$)).iterator()).asJava());
    }

    public static final /* synthetic */ RegisterBrokerRecord $anonfun$getTopicMetadata$1(int brokerId) {
        return new RegisterBrokerRecord().setBrokerId(brokerId).setEndPoints(MetadataCacheTest.endpoints$1(brokerId)).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(HashMap topicIds$1, String topic$1, PartitionRecord ps) {
        Uuid uuid = ps.topicId();
        Object v = topicIds$1.get(topic$1);
        return !(uuid != null ? !uuid.equals(v) : v != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, PartitionRecord x$2) {
        return x$2.partitionId() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            PartitionRecord partitionState = (PartitionRecord)topicPartitionStates$1.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$2))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)("Unable to find partition state for partition " + partitionId)));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topicIds$1, topic, ps)));
        Buffer partitionMetadatas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)("Unexpected partition count for topic " + topic));
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ RegisterBrokerRecord $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(MetadataCacheTest $this, int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new RegisterBrokerRecord().setBrokerId(brokerId).setRack("").setFenced(false).setBrokerEpoch($this.brokerEpoch()).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setName(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$).iterator()).asJava()));
    }

    private final void updateCache$1(Seq brokerIds, Uuid topicId$1, MetadataCache cache$2, Seq topicRecords$1) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new PartitionRecord().setTopicId(topicId$1).setPartitionId(0).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setReplicas(replicas), (List)Nil$.MODULE$);
        MetadataCacheTest$.MODULE$.updateCache(cache$2, (Seq<ApiMessage>)((Seq)((IterableOps)brokers.$plus$plus((IterableOnce)topicRecords$1)).$plus$plus((IterableOnce)partitionStates)));
    }

    public static final /* synthetic */ RegisterBrokerRecord $anonfun$testGetPartitionReplicaEndpoints$1(int fencedBrokerId$1, SecurityProtocol securityProtocol$1, ListenerName listenerName$2, int brokerId) {
        return new RegisterBrokerRecord().setBrokerId(brokerId).setFenced(brokerId == fencedBrokerId$1).setRack("rack" + brokerId % 3).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new RegisterBrokerRecord.BrokerEndpoint().setHost("foo" + brokerId).setPort(9092).setSecurityProtocol(securityProtocol$1.id).setName(listenerName$2.value()), (List)Nil$.MODULE$).iterator()).asJava()));
    }

    public static final /* synthetic */ PartitionRecord $anonfun$testGetPartitionReplicaEndpoints$2(java.util.List[] replicaSets$1, int fencedBrokerId$1, Uuid topicId$2, int partitionId) {
        java.util.List replicas = replicaSets$1[partitionId];
        java.util.List nonFencedReplicas = replicas.stream().filter(id -> !BoxesRunTime.equalsNumObject((Number)id, (Object)BoxesRunTime.boxToInteger((int)fencedBrokerId$1))).collect(Collectors.toList());
        return new PartitionRecord().setTopicId(topicId$2).setPartitionId(partitionId).setReplicas(replicas).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setIsr(nonFencedReplicas).setEligibleLeaderReplicas(nonFencedReplicas);
    }

    public static final /* synthetic */ void $anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$2(scala.collection.immutable.Set partitionIds$1, scala.collection.immutable.Map partitionMap$1, String topic$3, DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition partition) {
        int partitionId = partition.partitionIndex();
        Assertions.assertTrue((boolean)partitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)partitionId)));
        PartitionRecord expectedPartition = (PartitionRecord)partitionMap$1.get((Object)new Tuple2((Object)topic$3, (Object)BoxesRunTime.boxToInteger((int)partitionId))).get();
        Assertions.assertEquals((int)0, (int)partition.errorCode());
        Assertions.assertEquals((int)expectedPartition.leaderEpoch(), (int)partition.leaderEpoch());
        Assertions.assertEquals((int)expectedPartition.partitionId(), (int)partition.partitionIndex());
        Assertions.assertEquals((Object)expectedPartition.eligibleLeaderReplicas(), (Object)partition.eligibleLeaderReplicas());
        Assertions.assertEquals((Object)expectedPartition.isr(), (Object)partition.isrNodes());
        Assertions.assertEquals((Object)expectedPartition.lastKnownElr(), (Object)partition.lastKnownElr());
        Assertions.assertEquals((int)expectedPartition.leader(), (int)partition.leaderId());
    }

    private static final void checkTopicMetadata$2(String topic, scala.collection.immutable.Set partitionIds, Buffer partitions, scala.collection.immutable.Map partitionMap$1) {
        partitions.foreach((Function1 & Serializable)partition -> {
            MetadataCacheTest.$anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$2(partitionIds, partitionMap$1, topic, partition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$3(String x$5) {
        return 0;
    }

    public static final /* synthetic */ int $anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$4(String x$6) {
        return 0;
    }

    public static final /* synthetic */ int $anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$5(String topic0$2, String t) {
        if (t.equals(topic0$2)) {
            return 1;
        }
        return 0;
    }

    public static final /* synthetic */ int $anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$6(String topic0$2, String t) {
        if (t.equals(topic0$2)) {
            return 2;
        }
        return 0;
    }

    public static final /* synthetic */ int $anonfun$testGetTopicMetadataForDescribeTopicPartitionsResponse$7(String t) {
        if (t.equals("Non-exist")) {
            return 1;
        }
        return 0;
    }

    private final /* synthetic */ MetadataCacheTest$Broker$2$ Broker$lzycompute$1(LazyRef Broker$module$1) {
        synchronized (Broker$module$1) {
            MetadataCacheTest$Broker$2$ metadataCacheTest$Broker$2$ = Broker$module$1.initialized() ? (MetadataCacheTest$Broker$2$)Broker$module$1.value() : (MetadataCacheTest$Broker$2$)Broker$module$1.initialize((Object)new MetadataCacheTest$Broker$2$(this));
            return metadataCacheTest$Broker$2$;
        }
    }

    private final MetadataCacheTest$Broker$2$ Broker$3(LazyRef Broker$module$1) {
        if (Broker$module$1.initialized()) {
            return (MetadataCacheTest$Broker$2$)Broker$module$1.value();
        }
        return this.Broker$lzycompute$1(Broker$module$1);
    }

    private final /* synthetic */ MetadataCacheTest$Partition$2$ Partition$lzycompute$1(LazyRef Partition$module$1) {
        synchronized (Partition$module$1) {
            MetadataCacheTest$Partition$2$ metadataCacheTest$Partition$2$ = Partition$module$1.initialized() ? (MetadataCacheTest$Partition$2$)Partition$module$1.value() : (MetadataCacheTest$Partition$2$)Partition$module$1.initialize((Object)new MetadataCacheTest$Partition$2$(this));
            return metadataCacheTest$Partition$2$;
        }
    }

    private final MetadataCacheTest$Partition$2$ Partition$3(LazyRef Partition$module$1) {
        if (Partition$module$1.initialized()) {
            return (MetadataCacheTest$Partition$2$)Partition$module$1.value();
        }
        return this.Partition$lzycompute$1(Partition$module$1);
    }

    public static final /* synthetic */ void $anonfun$testGetOfflineReplicasConsidersDirAssignment$1(MetadataDelta delta$2, Broker.1 broker) {
        delta$2.replay(new RegisterBrokerRecord().setFenced(false).setBrokerId(broker.id()).setLogDirs(broker.dirs()).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort((int)((short)9093)).setName("PLAINTEXT").setHost("broker-" + broker.id())).iterator())));
    }

    public static final /* synthetic */ void $anonfun$testGetOfflineReplicasConsidersDirAssignment$2(MetadataDelta delta$2, Uuid topicId$3, Partition.1 partition) {
        delta$2.replay(new PartitionRecord().setTopicId(topicId$3).setPartitionId(partition.id()).setReplicas(partition.replicas()).setDirectories(partition.dirs()).setLeader(Predef$.MODULE$.Integer2int(partition.replicas().get(0))).setIsr(partition.replicas()));
    }

    /*
     * WARNING - void declaration
     */
    private static final scala.collection.immutable.Map offlinePartitions$1(Seq brokers, Seq partitions) {
        void kRaftMetadataCache_kraftVersionSupplier;
        MetadataDelta delta = new MetadataDelta.Builder().build();
        brokers.foreach((Function1 & Serializable)broker -> {
            MetadataCacheTest.$anonfun$testGetOfflineReplicasConsidersDirAssignment$1(delta, broker);
            return BoxedUnit.UNIT;
        });
        Uuid topicId = Uuid.fromString((String)"95OVr1IPRYGrcNCLlpImCA");
        delta.replay(new TopicRecord().setTopicId(topicId).setName("foo"));
        partitions.foreach((Function1 & Serializable)partition -> {
            MetadataCacheTest.$anonfun$testGetOfflineReplicasConsidersDirAssignment$2(delta, topicId, partition);
            return BoxedUnit.UNIT;
        });
        Supplier<KRaftVersion> supplier = () -> KRaftVersion.KRAFT_VERSION_0;
        int kRaftMetadataCache_brokerId = 1;
        supplier = null;
        KRaftMetadataCache cache = new KRaftMetadataCache(kRaftMetadataCache_brokerId, (Supplier)kRaftMetadataCache_kraftVersionSupplier);
        cache.setImage(delta.apply(MetadataProvenance.EMPTY));
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).head();
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().map((Function1 & Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)p.partitionIndex()), (Object)p.offlineReplicas()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
        this.oldRequestControllerEpoch = 122;
        this.newRequestControllerEpoch = 123;
        this.fooTopicName = "foo";
        this.barTopicName = "bar";
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

