/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTests;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u001d4A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)!\f\u0001C\u00017\")!\r\u0001C\u0001G\nqR*\u001a;bI\u0006$\u0018MV3sg&|g.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u000f!\taa]3sm\u0016\u0014(\"A\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0002CA\u000b\u0001\u001b\u00051\u0011a\b;fgR\u0014\u0015m]5d\u001b\u0016$\u0018\rZ1uCZ+'o]5p]V\u0003xM]1eKR\u0011\u0001d\u0007\t\u0003\u001beI!A\u0007\b\u0003\tUs\u0017\u000e\u001e\u0005\u00069\t\u0001\r!H\u0001\u0010G2,8\u000f^3s\u0013:\u001cH/\u00198dKB\u0011a\u0004K\u0007\u0002?)\u0011\u0001%I\u0001\u0005i\u0016\u001cHO\u0003\u0002#G\u000511m\\7n_:T!!\u0003\u0013\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0005\u0003S}\u0011qb\u00117vgR,'/\u00138ti\u0006t7-\u001a\u0015\u0005\u0005-\n$\u0007\u0005\u0002-_5\tQF\u0003\u0002/?\u0005\u0019\u0011\r]5\n\u0005Aj#\u0001D\"mkN$XM\u001d+fgR\u001c\u0018!\u0002<bYV,G&B\u001aG\u0017B+6&\u0002\u001b8qyz\u0004C\u0001\u00176\u0013\t1TFA\u0006DYV\u001cH/\u001a:UKN$\u0018!\u0002;za\u0016\u001cH&A\u001d%\u0003iJ!a\u000f\u001f\u0002\u000b-\u0013\u0016I\u0012+\u000b\u0005uj\u0013\u0001\u0002+za\u0016\fq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\u0013\u0002\u0001&\u0011\u0011IQ\u0001\f\u0013\n\u0003vlM04?&36G\u0003\u0002D\t\u0006yQ*\u001a;bI\u0006$\u0018MV3sg&|gN\u0003\u0002#\u000b*\u0011qaI\u0016\u0006i]:e\b\u0013\u0017\u0002s\u0011\n\u0011*\u0003\u0002K\u0005\u0006Y\u0011J\u0011)`g}#t,\u0013,1W\u0015!t\u0007\u0014 NY\u0005ID%\u0001(\n\u0005=\u0013\u0015aC%C!~\u001bt,N0J-BZS\u0001N\u001cR}Ic\u0013!\u000f\u0013\u0002'&\u0011AKQ\u0001\f\u0013\n\u0003vlM07?&3\u0006gK\u00035oYst\u000bL\u0001:I\u0005A\u0016BA-C\u0003-I%\tU04?Zz\u0016JV\u0019\u0002-Q,7\u000f^+qOJ\fG-Z*b[\u00164VM]:j_:$\"\u0001\u0007/\t\u000bq\u0019\u0001\u0019A\u000f)\r\r!tG\u0018 `Y\u0005ID%\u00011\n\u0005\u0005\u0014\u0015aC%C!~\u001bt,O0J-B\n!\u0004^3ti\u0012+g-Y;mi&\u001bH*\u0019;fgR4VM]:j_:$\"\u0001\u00073\t\u000bq!\u0001\u0019A\u000f)\t\u0011!tG\u001a\u0017\u0002s\u0001")
public class MetadataVersionIntegrationTest {
    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_3_IV3), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_4_IV0), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_5_IV0), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_6_IV0), @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_6_IV1)})
    public void testBasicMetadataVersionUpgrade(ClusterInstance clusterInstance) {
        try (Admin admin = clusterInstance.admin();){
            FinalizedVersionRange ff = (FinalizedVersionRange)((FeatureMetadata)admin.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
            Assertions.assertEquals((short)ff.minVersionLevel(), (short)clusterInstance.config().metadataVersion().featureLevel());
            Assertions.assertEquals((short)ff.maxVersionLevel(), (short)clusterInstance.config().metadataVersion().featureLevel());
            short updateVersion = MetadataVersion.IBP_3_7_IV1.featureLevel();
            admin.updateFeatures(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(updateVersion, FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions()).all().get();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!MetadataVersionIntegrationTest.$anonfun$testBasicMetadataVersionUpgrade$1(admin, updateVersion)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Never saw metadata.version increase on broker");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_9_IV0)
    public void testUpgradeSameVersion(ClusterInstance clusterInstance) {
        try (Admin admin = clusterInstance.admin();){
            short updateVersion = MetadataVersion.IBP_3_9_IV0.featureLevel();
            admin.updateFeatures(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(updateVersion, FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions()).all().get();
        }
    }

    @ClusterTest(types={Type.KRAFT})
    public void testDefaultIsLatestVersion(ClusterInstance clusterInstance) {
        try (Admin admin = clusterInstance.admin();){
            FinalizedVersionRange ff = (FinalizedVersionRange)((FeatureMetadata)admin.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
            Assertions.assertEquals((short)ff.minVersionLevel(), (short)MetadataVersion.latestTesting().featureLevel(), (String)"If this test fails, check the default MetadataVersion in the @ClusterTest annotation");
            Assertions.assertEquals((short)ff.maxVersionLevel(), (short)MetadataVersion.latestTesting().featureLevel());
        }
    }

    public static final /* synthetic */ boolean $anonfun$testBasicMetadataVersionUpgrade$1(Admin admin$1, short updateVersion$1) {
        FinalizedVersionRange ff2 = (FinalizedVersionRange)((FeatureMetadata)admin$1.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        return ff2.minVersionLevel() == updateVersion$1 && ff2.maxVersionLevel() == updateVersion$1;
    }

    public static final /* synthetic */ String $anonfun$testBasicMetadataVersionUpgrade$2() {
        return "Never saw metadata.version increase on broker";
    }
}

