/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.GroupCoordinatorBaseRequestTest;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(types={Type.KRAFT})
@ScalaSignature(bytes="\u0006\u0005!4Aa\u0002\u0005\u0001\u001b!A!\u0003\u0001B\u0001B\u0003%1\u0003C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0003C\u0001\u0011\u0005Q\u0005C\u0003F\u0001\u0011\u0005Q\u0005C\u0003]\u0001\u0011%QLA\fPM\u001a\u001cX\r\u001e#fY\u0016$XMU3rk\u0016\u001cH\u000fV3ti*\u0011\u0011BC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0011%\u0011\u0011\u0003\u0003\u0002 \u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\u0014\u0015m]3SKF,Xm\u001d;UKN$\u0018aB2mkN$XM\u001d\t\u0003)yi\u0011!\u0006\u0006\u0003-]\tA\u0001^3ti*\u0011\u0001$G\u0001\u0007G>lWn\u001c8\u000b\u0005-Q\"BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001eL!aH\u000b\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDC\u0001\u0012$!\ty\u0001\u0001C\u0003\u0013\u0005\u0001\u00071#\u0001\"uKN$xJ\u001a4tKR$U\r\\3uK^KG\u000f\u001b(fo\u000e{gn];nKJ<%o\\;q!J|Go\\2pY\u0006sGMT3x\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J$\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0005+:LG\u000f\u000b\u0003\u0004[M\"\u0004C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0016\u0003\r\t\u0007/[\u0005\u0003e=\u00121b\u00117vgR,'\u000fV3ti\u0006\u00012/\u001a:wKJ\u0004&o\u001c9feRLWm\u001d\u0017\u0003k}ZSAN\u001d;yu\u0002\"AL\u001c\n\u0005az#!F\"mkN$XM]\"p]\u001aLw\r\u0015:pa\u0016\u0014H/_\u0001\u0004W\u0016L\u0018%A\u001e\u00029=4gm]3ug:\"x\u000e]5d]9,XN\f9beRLG/[8og\u0006)a/\u00197vK\u0006\na(A\u00012W\u00151\u0014\b\u0011\u001f>C\u0005\t\u0015\u0001I8gMN,Go\u001d\u0018u_BL7M\f:fa2L7-\u0019;j_:tc-Y2u_J\f!\t^3ti>3gm]3u\t\u0016dW\r^3XSRDw\n\u001c3D_:\u001cX/\\3s\u000fJ|W\u000f\u001d)s_R|7m\u001c7B]\u0012tUm^$s_V\u00048i\\8sI&t\u0017\r^8sQ\u0011!Qf\r#-\u0005Uz\u0014A\u0011;fgR|eMZ:fi\u0012+G.\u001a;f/&$\bn\u00147e\u0007>t7/^7fe\u001e\u0013x.\u001e9Qe>$xnY8m\u0003:$w\n\u001c3He>,\boQ8pe\u0012Lg.\u0019;pe\"2Q!L$IgE\u000bQ\u0001^=qKNd#!\u0013(%\u0003)K!a\u0013'\u0002\u000b-\u0013\u0016I\u0012+\u000b\u00055{\u0013\u0001\u0002+za\u0016$\u0013aT\u0005\u0003!2\u000b\u0001bQ(`\u0017J\u000be\t\u0016\u0017\u0005%^+thK\u00037sMcT+I\u0001U\u0003q9'o\\;q]\r|wN\u001d3j]\u0006$xN\u001d\u0018oK^tSM\\1cY\u0016\f\u0013AV\u0001\u0006M\u0006d7/Z\u0016\u0006meBFHW\u0011\u00023\u0006)sM]8va:\u001awn\u001c:eS:\fGo\u001c:/e\u0016\u0014\u0017\r\\1oG\u0016t\u0003O]8u_\u000e|Gn]\u0011\u00027\u000691\r\\1tg&\u001c\u0017\u0001\u0005;fgR|eMZ:fi\u0012+G.\u001a;f)\t1c\fC\u0003`\r\u0001\u0007\u0001-\u0001\bvg\u0016tUm\u001e)s_R|7m\u001c7\u0011\u0005\u001d\n\u0017B\u00012)\u0005\u001d\u0011un\u001c7fC:DC\u0001\u00013HOB\u0011a&Z\u0005\u0003M>\u00121c\u00117vgR,'\u000fV3ti\u0012+g-Y;miNd\u0013!\u0013")
public class OffsetDeleteRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetDeleteWithNewConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testOffsetDelete(true);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetDeleteWithOldConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testOffsetDelete(false);
    }

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false"), @ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetDeleteWithOldConsumerGroupProtocolAndOldGroupCoordinator() {
        this.testOffsetDelete(false);
    }

    private void testOffsetDelete(boolean useNewProtocol) {
        if (useNewProtocol && !this.isNewGroupCoordinatorEnabled()) {
            Assertions.fail((String)"Cannot use the new protocol with the old group coordinator.");
        }
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.OFFSET_DELETE.oldestVersion()), (int)ApiKeys.OFFSET_DELETE.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            void var4_4;
            Tuple2<String, Object> tuple2 = this.joinConsumerGroup("grp", useNewProtocol);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            String memberId = (String)tuple2._1();
            int n = tuple2._2$mcI$sp();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetDeleteRequestTest.$anonfun$testOffsetDelete$2(this, (String)var4_4, n, arg_0)));
            short x$5 = (short)version;
            Errors x$6 = this.deleteOffset$default$4();
            this.deleteOffset("grp", "foo", 0, x$6, Errors.GROUP_SUBSCRIBED_TO_TOPIC, x$5);
            if (useNewProtocol) {
                List x$10 = package$.MODULE$.List().empty();
                String x$11 = this.consumerGroupHeartbeat$default$4();
                String x$12 = this.consumerGroupHeartbeat$default$5();
                int x$13 = this.consumerGroupHeartbeat$default$6();
                String x$14 = this.consumerGroupHeartbeat$default$7();
                List<ConsumerGroupHeartbeatRequestData.TopicPartitions> x$15 = this.consumerGroupHeartbeat$default$9();
                Errors x$16 = this.consumerGroupHeartbeat$default$10();
                short x$17 = this.consumerGroupHeartbeat$default$11();
                this.consumerGroupHeartbeat("grp", (String)var4_4, n, x$11, x$12, x$13, x$14, (List<String>)x$10, x$15, x$16, x$17);
            } else {
                this.leaveGroup("grp", (String)var4_4, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            }
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> {
                short x$21 = (short)version;
                Errors x$22 = this.deleteOffset$default$4();
                Errors x$23 = this.deleteOffset$default$5();
                this.deleteOffset("grp", "foo", partitionId, x$22, x$23, x$21);
            });
            short x$28 = (short)version;
            Errors x$29 = this.deleteOffset$default$4();
            this.deleteOffset("grp", "foo", 5, x$29, Errors.UNKNOWN_TOPIC_OR_PARTITION, x$28);
            short x$34 = (short)version;
            Errors x$35 = this.deleteOffset$default$5();
            this.deleteOffset("grp-unknown", "foo", 2, Errors.GROUP_ID_NOT_FOUND, x$35, x$34);
            short x$40 = (short)version;
            Errors x$41 = this.deleteOffset$default$5();
            this.deleteOffset("", "foo", 2, Errors.INVALID_GROUP_ID, x$41, x$40);
            short x$46 = (short)version;
            Errors x$47 = this.deleteOffset$default$5();
            this.deleteOffset("", "foo-unknown", 2, Errors.INVALID_GROUP_ID, x$47, x$46);
            short x$52 = (short)version;
            Errors x$53 = this.deleteOffset$default$5();
            this.deleteOffset("", "foo", 5, Errors.INVALID_GROUP_ID, x$53, x$52);
        });
    }

    public static final /* synthetic */ void $anonfun$testOffsetDelete$2(OffsetDeleteRequestTest $this, String memberId$1, int memberEpoch$1, int partitionId) {
        $this.commitOffset("grp", memberId$1, memberEpoch$1, "foo", partitionId, 100L + (long)partitionId, Errors.NONE, ApiKeys.OFFSET_COMMIT.latestVersion($this.isUnstableApiEnabled()));
    }

    public OffsetDeleteRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

