/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\u0004\t\u00015AQA\u0005\u0001\u0005\u0002MAQ!\u0006\u0001\u0005\u0002YAQA\u0011\u0001\u0005\u0002\rCQ\u0001\u0013\u0001\u0005\n%CQa\u001c\u0001\u0005\nADq!a\u0002\u0001\t\u0013\tIA\u0001\u0011PM\u001a\u001cX\r^:G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;UKN$(BA\u0005\u000b\u0003\u0019\u0019XM\u001d<fe*\t1\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005A\u0011BA\t\t\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0015!\ty\u0001!A\u0012uKN$xJ\u001a4tKR\u001chi\u001c:MK\u0006$WM]#q_\u000eDWI\u001d:pe\u000e{G-Z:\u0015\u0005]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"\u0001B+oSRDQA\b\u0002A\u0002}\ta!];peVl\u0007C\u0001\u0011(\u001d\t\tS\u0005\u0005\u0002#35\t1E\u0003\u0002%\u0019\u00051AH]8pizJ!AJ\r\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003MeA#AA\u0016\u0011\u00051*T\"A\u0017\u000b\u00059z\u0013A\u00029be\u0006l7O\u0003\u00021c\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001a4\u0003\u0015QWO\\5u\u0015\u0005!\u0014aA8sO&\u0011a'\f\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b\u0006\u0002\u00029}}\u0002\"!\u000f\u001f\u000e\u0003iR!aO\u0017\u0002\u0011A\u0014xN^5eKJL!!\u0010\u001e\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0005\u0001\u0015%A!\u0002\u000b-\u0014\u0018M\u001a;\u00025Q,7\u000f^\"veJ,g\u000e^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8\u0015\u0005]!\u0005\"\u0002\u0010\u0004\u0001\u0004y\u0002FA\u0002,Q\u0011\u0019\u0001HP$-\u0003\u0001\u000b\u0011e\u001c4gg\u0016$hi\u001c:MK\u0006$WM\u001d+pa&\u001c7i\u001c7mK\u000e$\u0018n\u001c8G_J$BA\u00132i[B\u00111j\u0018\b\u0003\u0019rs!!T-\u000f\u000593fBA(U\u001d\t\u0001&K\u0004\u0002##&\tA'\u0003\u0002Tg\u00051\u0011\r]1dQ\u0016L!aC+\u000b\u0005M\u001b\u0014BA,Y\u0003\u0019\u0019w.\\7p]*\u00111\"V\u0005\u00035n\u000bq!\\3tg\u0006<WM\u0003\u0002X1&\u0011QLX\u0001 \u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;ECR\f'B\u0001.\\\u0013\t\u0001\u0017M\u0001\u0010PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s)>\u0004\u0018nY\"pY2,7\r^5p]*\u0011QL\u0018\u0005\u0006G\u0012\u0001\r\u0001Z\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\t)g-D\u0001\\\u0013\t97L\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b%$\u0001\u0019\u00016\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u00031-L!\u0001\\\r\u0003\u0007%sG\u000fC\u0003o\t\u0001\u0007!.\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0017aE1tg\u0016\u0014HOU3ta>t7/Z#se>\u0014H\u0003B\frsnDQA]\u0003A\u0002M\fQ!\u001a:s_J\u0004\"\u0001^<\u000e\u0003UT!A^.\u0002\u0011A\u0014x\u000e^8d_2L!\u0001_;\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015QX\u00011\u0001k\u0003!\u0011'o\\6fe&#\u0007\"\u0002?\u0006\u0001\u0004i\u0018a\u0002:fcV,7\u000f\u001e\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u00051,\u0001\u0005sKF,Xm\u001d;t\u0013\r\t)a \u0002\u001d\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\r\u0005-\u0011\u0011CA\n!\rq\u0018QB\u0005\u0004\u0003\u001fy(!H(gMN,Go\u001d$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3\t\u000bi4\u0001\u0019\u00016\t\u000bq4\u0001\u0019A?")
public class OffsetsForLeaderEpochRequestTest
extends BaseRequestTest {
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testOffsetsForLeaderEpochErrorCodes(String quorum) {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)this.offsetForLeaderTopicCollectionFor(partition, 0, -1), (int)1).build();
        int randomBrokerId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, request);
        int x$32 = this.createTopic$default$2();
        Properties x$42 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        Map<Object, Object> partitionToLeader = this.createTopic(topic, x$32, 2, x$42, x$5, x$6);
        java.util.Map topicDescription = (java.util.Map)this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()).describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)partition.topic(), (List)Nil$.MODULE$)).asJava()).allTopicNames().get();
        Set replicas = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)((TopicDescription)topicDescription.get(partition.topic())).partitions().get(partition.partition())).replicas()).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()))).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.brokers().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)OffsetsForLeaderEpochRequestTest.$anonfun$testOffsetsForLeaderEpochErrorCodes$3(x$3)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$4))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, request);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, request);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCurrentEpochValidation(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, 3, x$4, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), (Option<Object>)None$.MODULE$, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection offsetForLeaderTopicCollectionFor(TopicPartition topicPartition, int leaderEpoch, int currentLeaderEpoch) {
        return new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(leaderEpoch).setCurrentLeaderEpoch(currentLeaderEpoch), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$).iterator()).asJava());
    }

    private void assertResponseError(Errors error, int brokerId, OffsetsForLeaderEpochRequest request) {
        OffsetsForLeaderEpochResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.data().topics().size(), (int)response.data().topics().size());
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().topics()).asScala().foreach((Function1 & Serializable)offsetForLeaderTopic -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$1(request, error, offsetForLeaderTopic);
            return BoxedUnit.UNIT;
        });
    }

    private OffsetsForLeaderEpochResponse sendRequest(int brokerId, OffsetsForLeaderEpochRequest request) {
        return (OffsetsForLeaderEpochResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetsForLeaderEpochResponse.class));
    }

    public static final /* synthetic */ int $anonfun$testOffsetsForLeaderEpochErrorCodes$3(KafkaBroker x$3) {
        return x$3.config().brokerId();
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)this.offsetForLeaderTopicCollectionFor(topicPartition$1, 0, Predef$.MODULE$.Integer2int(currentLeaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1)))), (int)1).build();
        this.assertResponseError(error, brokerId, request);
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, OffsetForLeaderEpochResponseData.EpochEndOffset offsetForLeaderPartition) {
        Assertions.assertEquals((short)error$1.code(), (short)offsetForLeaderPartition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(OffsetsForLeaderEpochRequest request$1, Errors error$1, OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult offsetForLeaderTopic) {
        Assertions.assertEquals((int)request$1.data().topics().find(offsetForLeaderTopic.topic()).partitions().size(), (int)offsetForLeaderTopic.partitions().size());
        CollectionConverters$.MODULE$.ListHasAsScala(offsetForLeaderTopic.partitions()).asScala().foreach((Function1 & Serializable)offsetForLeaderPartition -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$2(error$1, offsetForLeaderPartition);
            return BoxedUnit.UNIT;
        });
    }
}

