/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.security.auth.login.Configuration;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tmd!B\u0016-\u0003\u0003\t\u0004\"\u0002 \u0001\t\u0003y\u0004b\u0002\"\u0001\u0005\u0004%\tb\u0011\u0005\u0007'\u0002\u0001\u000b\u0011\u0002#\t\u000bQ\u0003A\u0011C+\t\u000bA\u0004A\u0011C9\t\u0013\u0015\u0004\u0001\u0019!a\u0001\n\u0013A\b\"C=\u0001\u0001\u0004\u0005\r\u0011\"\u0003{\u0011)\t\t\u0001\u0001a\u0001\u0002\u0003\u0006KA\u001a\u0005\f\u0003\u0007\u0001\u0001\u0019!a\u0001\n#\t)\u0001C\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\u0012\u0005=\u0001bCA\n\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000fAq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011Q\b\u0001\u0005\n\u0005}\u0002bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003#\u0002A\u0011AA*\u0011%\t9\u0006\u0001b\u0001\n\u0003\tI\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA.\u0011%\t\u0019\u0007\u0001b\u0001\n\u0003\t)\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA4\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!a!\u0001\t\u0003\t)\tC\u0005\u0002F\u0002\t\n\u0011\"\u0001\u0002H\"I\u0011Q\u001c\u0001\u0012\u0002\u0013\u0005\u0011q\u001c\u0005\n\u0003G\u0004\u0011\u0013!C\u0001\u0003KDq!!;\u0001\t\u0003\tY\u000fC\u0004\u0002n\u0002!\t!a<\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!1\u0002\u0001\u0005\u0012\t5\u0001b\u0002B\u0003\u0001\u0011E!\u0011\u0003\u0005\b\u00053\u0001A\u0011AAv\u000f\u001d\u0011\t\u0004\fE\u0001\u0005g1aa\u000b\u0017\t\u0002\tU\u0002B\u0002 #\t\u0003\u00119\u0004C\u0004\u0003:\t\"\t!a;\t\u000f\t\r#\u0005\"\u0001\u0002l\"9!Q\n\u0012\u0005\u0002\t=\u0003b\u0002B+E\u0011\u0005!q\u000b\u0005\b\u0005k\u0012C\u0011\u0001B,\u0011\u001d\u00119H\tC\u0001\u0005/BqA!\u001f#\t\u0003\u00119FA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgNT!!\f\u0018\u0002\rM,'O^3s\u0015\u0005y\u0013!B6bM.\f7\u0001A\n\u0004\u0001IB\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u0002:y5\t!H\u0003\u0002<]\u0005)Q\u000f^5mg&\u0011QH\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\t\u0005\u0002B\u00015\tA&\u0001\u0012d_:$(o\u001c7mKJd\u0015n\u001d;f]\u0016\u00148+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002\tB\u0011Q)U\u0007\u0002\r*\u0011q\tS\u0001\u0005CV$\bN\u0003\u0002J\u0015\u0006A1/Z2ve&$\u0018P\u0003\u0002L\u0019\u000611m\\7n_:T!aL'\u000b\u00059{\u0015AB1qC\u000eDWMC\u0001Q\u0003\ry'oZ\u0005\u0003%\u001a\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002G\r|g\u000e\u001e:pY2,'\u000fT5ti\u0016tWM]*fGV\u0014\u0018\u000e^=Qe>$xnY8mA\u000512N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000f\u0006\u0002WIB\u0019qK\u0017/\u000e\u0003aS!!\u0017\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\\1\n\u00191+Z9\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001B;uS2T\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b\u0015$\u0001\u0019\u00014\u0002\u0011Q,7\u000f^%oM>\u0004\"a\u001a8\u000e\u0003!T!!\u001b6\u0002\u0007\u0005\u0004\u0018N\u0003\u0002lY\u00069!.\u001e9ji\u0016\u0014(BA7P\u0003\u0015QWO\\5u\u0013\ty\u0007N\u0001\u0005UKN$\u0018J\u001c4p\u0003=iW\r^1eCR\fg+\u001a:tS>tW#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005-+(BA\u0017M\u0013\t9HOA\bNKR\fG-\u0019;b-\u0016\u00148/[8o+\u00051\u0017\u0001\u0004;fgRLeNZ8`I\u0015\fHCA>\u007f!\t\u0019D0\u0003\u0002~i\t!QK\\5u\u0011\u001dyx!!AA\u0002\u0019\f1\u0001\u001f\u00132\u0003%!Xm\u001d;J]\u001a|\u0007%\u0001\bj[BdW-\\3oi\u0006$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0001cA!\u0002\n%\u0019\u00111\u0002\u0017\u0003)E+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0003IIW\u000e\u001d7f[\u0016tG/\u0019;j_:|F%Z9\u0015\u0007m\f\t\u0002\u0003\u0005\u0000\u0015\u0005\u0005\t\u0019AA\u0004\u0003=IW\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004\u0013\u0001E5t'\"\f'/Z$s_V\u0004H+Z:u)\t\tI\u0002E\u00024\u00037I1!!\b5\u0005\u001d\u0011un\u001c7fC:\f1$\\1zE\u0016<%o\\;q!J|Go\\2pYN\u0003XmY5gS\u0016$GCAA\u0012!\u0015\u0019\u0014QEA\u0015\u0013\r\t9\u0003\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005A1m\u001c8tk6,'OC\u0002\u000241\u000bqa\u00197jK:$8/\u0003\u0003\u00028\u00055\"!D$s_V\u0004\bK]8u_\u000e|G.A\u0010he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c$s_6$Vm\u001d;QCJ\fW.\u001a;feN$\"!!\u000b\u0002\u000f\u0005\u001c8JU1giR\u0011\u0011\u0011\t\t\u0004\u0003\u0006\r\u0013bAA#Y\tI2JU1giF+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0003A\u0019wN\u001c;s_2dWM]*feZ,'/\u0006\u0002\u0002LA\u0019\u0011)!\u0014\n\u0007\u0005=CF\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe\u0006\t2m\u001c8ue>dG.\u001a:TKJ4XM]:\u0016\u0005\u0005U\u0003\u0003B,[\u0003\u0017\n1CZ1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef,\"!a\u0017\u0011\u0007\u0005\u000bi&C\u0002\u0002`1\u0012A%U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\r\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/_\u0001\u0015M\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/\u001f\u0011\u0002\u0019\u0019\fW\u000f\u001c;IC:$G.\u001a:\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055T/A\u0003gCVdG/\u0003\u0003\u0002r\u0005-$\u0001E'pG.4\u0015-\u001e7u\u0011\u0006tG\r\\3s\u000351\u0017-\u001e7u\u0011\u0006tG\r\\3sA\u0005)1/\u001a;VaR\u001910!\u001f\t\u000b\u00154\u0002\u0019\u00014)\u0007Y\ti\bE\u0002h\u0003\u007fJ1!!!i\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\rGJ,\u0017\r^3Ce>\\WM\u001d\u000b\u000b\u0003\u000f\u000bi)a&\u0002&\u0006%\u0006cA!\u0002\n&\u0019\u00111\u0012\u0017\u0003\u0017-\u000bgm[1Ce>\\WM\u001d\u0005\b\u0003\u001f;\u0002\u0019AAI\u0003\u0019\u0019wN\u001c4jOB\u0019\u0011)a%\n\u0007\u0005UEFA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"CAM/A\u0005\t\u0019AAN\u0003\u0011!\u0018.\\3\u0011\t\u0005u\u0015\u0011U\u0007\u0003\u0003?S!a\u000f&\n\t\u0005\r\u0016q\u0014\u0002\u0005)&lW\rC\u0005\u0002(^\u0001\n\u00111\u0001\u0002\u001a\u000591\u000f^1siV\u0004\b\"CAV/A\u0005\t\u0019AAW\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u00034\u0003K\ty\u000b\u0005\u0003\u00022\u0006}f\u0002BAZ\u0003w\u00032!!.5\u001b\t\t9LC\u0002\u0002:B\na\u0001\u0010:p_Rt\u0014bAA_i\u00051\u0001K]3eK\u001aLA!!1\u0002D\n11\u000b\u001e:j]\u001eT1!!05\u0003Y\u0019'/Z1uK\n\u0013xn[3sI\u0011,g-Y;mi\u0012\u0012TCAAeU\u0011\tY*a3,\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a65\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fac\u0019:fCR,'I]8lKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003CTC!!\u0007\u0002L\u000612M]3bi\u0016\u0014%o\\6fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002h*\"\u0011QVAf\u0003]\u0019\b.\u001e;e_^t7JU1gi\u000e{g\u000e\u001e:pY2,'\u000fF\u0001|\u0003Q\tG\r\u001a$pe6\fG\u000f^3s'\u0016$H/\u001b8hgR\u001910!=\t\u000f\u0005MH\u00041\u0001\u0002v\u0006Iam\u001c:nCR$XM\u001d\t\u0005\u0003o\u0014\t!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003\u001d\u0019Ho\u001c:bO\u0016T1!a@M\u0003!iW\r^1eCR\f\u0017\u0002\u0002B\u0002\u0003s\u0014\u0011BR8s[\u0006$H/\u001a:\u0002\u001d9,wo\u0013*bMR\fVo\u001c:v[R!\u0011\u0011\tB\u0005\u0011\u0015)W\u00041\u0001g\u0003\u0001*\u0007\u0010\u001e:b\u0007>tGO]8mY\u0016\u00148+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\:\u0015\u0005\t=\u0001cA,[\tR1\u0011\u0011\tB\n\u0005+AQ!Z\u0010A\u0002\u0019DaAa\u0006 \u0001\u0004a\u0016aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0002\u0011Q,\u0017M\u001d#po:D3\u0001\tB\u000f!\r9'qD\u0005\u0004\u0005CA'!C!gi\u0016\u0014X)Y2iQ\u001d\u0001!Q\u0005B\u0016\u0005[\u00012a\u001aB\u0014\u0013\r\u0011I\u0003\u001b\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017E\u0001B\u0018\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0002#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002BEM\u0011!E\r\u000b\u0003\u0005g\t!b]3u+B\u001cE.Y:tQ\r!#Q\b\t\u0004O\n}\u0012b\u0001B!Q\nI!)\u001a4pe\u0016\fE\u000e\\\u0001\u000ei\u0016\f'\u000fR8x]\u000ec\u0017m]:)\u0007\u0015\u00129\u0005E\u0002h\u0005\u0013J1Aa\u0013i\u0005!\te\r^3s\u00032d\u0017!\u0007<fe&4\u0017PT8V]\u0016D\b/Z2uK\u0012$\u0006N]3bIN$2a\u001fB)\u0011\u001d\u0011\u0019F\na\u0001\u0003_\u000bqaY8oi\u0016DH/\u0001\u0016hKR$Vm\u001d;Rk>\u0014X/\\!oI\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\t\u001c7\u0016\u0005\te\u0003C\u0002B.\u0005C\u0012)'\u0004\u0002\u0003^)\u0019!q\f0\u0002\rM$(/Z1n\u0013\u0011\u0011\u0019G!\u0018\u0003\rM#(/Z1n!\u0011\u00119G!\u001d\u000e\u0005\t%$\u0002\u0002B6\u0005[\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0005_R\u0017A\u00029be\u0006l7/\u0003\u0003\u0003t\t%$!C!sOVlWM\u001c;t\u0003}:W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:DY\u0006\u001c8/[2He>,\b\u000f\u0015:pi>\u001cw\u000e\\(oYf\f\u0001iZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u000e{gn];nKJ<%o\\;q!J|Go\\2pY>sG._\u0001LO\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148o\u00117bgNL7m\u0012:pkB\u0004&o\u001c;pG>dwJ\u001c7z?j[u,[7qY&\u001c\u0017\u000e\u001e")
public abstract class QuorumTestHarness
implements Logging {
    private final SecurityProtocol controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
    private final MockFaultHandler faultHandler = this.faultHandlerFactory().faultHandler();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly_ZK_implicit() {
        return QuorumTestHarness$.MODULE$.getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly_ZK_implicit();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly() {
        return QuorumTestHarness$.MODULE$.getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly() {
        return QuorumTestHarness$.MODULE$.getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return QuorumTestHarness$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    public static void verifyNoUnexpectedThreads(String context) {
        QuorumTestHarness$.MODULE$.verifyNoUnexpectedThreads(context);
    }

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latestTesting();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    public QuorumImplementation implementation() {
        return this.implementation;
    }

    public void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public boolean isShareGroupTest() {
        return TestInfoUtils$.MODULE$.isShareGroupTest(this.testInfo());
    }

    public Option<GroupProtocol> maybeGroupProtocolSpecified() {
        return TestInfoUtils$.MODULE$.maybeGroupProtocolSpecified(this.testInfo());
    }

    public GroupProtocol groupProtocolFromTestParameters() {
        Option<GroupProtocol> gp = this.maybeGroupProtocolSpecified();
        if (gp.isEmpty()) {
            throw new IllegalStateException("Please specify the \"groupProtocol\" parameter when writing the test");
        }
        return (GroupProtocol)gp.get();
    }

    private KRaftQuorumImplementation asKRaft() {
        return (KRaftQuorumImplementation)this.implementation();
    }

    public ControllerServer controllerServer() {
        return ((KRaftQuorumImplementation)this.implementation()).controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        return new .colon.colon((Object)((KRaftQuorumImplementation)this.implementation()).controllerServer(), (List)Nil$.MODULE$);
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException("exit(" + code + ", " + message + ") called!");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException("halt(" + code + ", " + message + ") called!");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(testInfo.getTestMethod())).map((Function1 & Serializable)x$5 -> x$5.toString()).getOrElse((Function0 & Serializable)() -> "[unspecified]");
        this.info((Function0<String>)(Function0 & Serializable)() -> "Running KRAFT test " + name);
        this.implementation_$eq(this.newKRaftQuorum(testInfo));
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = (KRaftQuorumImplementation)this.implementation();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), Level.WARN);
    }

    public void addFormatterSettings(Formatter formatter) {
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        return this.newKRaftQuorum(testInfo, new Properties());
    }

    public Seq<SecurityProtocol> extraControllerSecurityProtocols() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo, Properties overridingProps) {
        Seq<Properties> propsList = this.kraftControllerConfigs(testInfo);
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.head();
        props.putAll((Map<?, ?>)overridingProps);
        props.setProperty("server.max.startup.time.ms", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        props.setProperty("process.roles", "controller");
        props.setProperty("unstable.feature.versions.enable", "true");
        if (props.getProperty("node.id") == null) {
            props.setProperty("node.id", "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty("node.id"));
        File metadataDir = TestUtils.tempDirectory(null, null);
        props.setProperty("metadata.log.dir", metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        String securityProtocolMaps = ((IterableOnceOps)this.extraControllerSecurityProtocols().map((Function1 & Serializable)sc -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(sc), ":") + sc)).mkString(",");
        String listeners = ((IterableOnceOps)this.extraControllerSecurityProtocols().map((Function1 & Serializable)sc -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(sc), "://localhost:0"))).mkString(",");
        String listenerNames = this.extraControllerSecurityProtocols().mkString(",");
        props.setProperty("listener.security.protocol.map", "CONTROLLER:" + proto + "," + securityProtocolMaps);
        props.setProperty("listeners", "CONTROLLER://localhost:0," + listeners);
        props.setProperty("controller.listener.names", "CONTROLLER," + listenerNames);
        props.setProperty("controller.quorum.voters", nodeId + "@localhost:0");
        props.setProperty(ServerLogConfigs.LOG_DELETE_DELAY_MS_CONFIG, "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        Formatter formatter = new Formatter().setClusterId(Uuid.randomUuid().toString()).setNodeId(nodeId);
        formatter.addDirectory(metadataDir.getAbsolutePath());
        formatter.setReleaseVersion(this.metadataVersion());
        formatter.setUnstableFeatureVersionsEnabled(true);
        formatter.setControllerListenerName((String)config.controllerListenerNames().head());
        formatter.setMetadataLogDirectory(config.metadataLogDir());
        short transactionVersion = TestInfoUtils$.MODULE$.isTransactionV2Enabled(testInfo) ? TransactionVersion.TV_2.featureLevel() : TransactionVersion.TV_1.featureLevel();
        formatter.setFeatureLevel("transaction.version", Predef$.MODULE$.short2Short(transactionVersion));
        short elrVersion = TestInfoUtils$.MODULE$.isEligibleLeaderReplicasV1Enabled(testInfo) ? EligibleLeaderReplicasVersion.ELRV_1.featureLevel() : EligibleLeaderReplicasVersion.ELRV_0.featureLevel();
        formatter.setFeatureLevel("eligible.leader.replicas.version", Predef$.MODULE$.short2Short(elrVersion));
        this.addFormatterSettings(formatter);
        formatter.run();
        BootstrapMetadata bootstrapMetadata = formatter.bootstrapMetadata();
        CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, InetSocketAddress>>();
        MetaPropertiesEnsemble metaPropertiesEnsemble = new MetaPropertiesEnsemble.Loader().addMetadataLogDir(metadataDir.getAbsolutePath()).load();
        metaPropertiesEnsemble.verify(Optional.of(formatter.clusterId()), OptionalInt.of(nodeId), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
        SharedServer sharedServer = new SharedServer(config, metaPropertiesEnsemble, Time.SYSTEM, new Metrics(), controllerQuorumVotersFuture, Collections.emptyList(), (FaultHandlerFactory)this.faultHandlerFactory(), ServerSocketFactory.INSTANCE);
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata);
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port))));
            });
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, Level.WARN);
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> sharedServer.stopForController(), (Logging)this, Level.WARN);
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, formatter.clusterId(), this, (FaultHandler)this.faultHandler());
    }

    @AfterEach
    public void tearDown() {
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }
}

