/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.handlers;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.KafkaConfig;
import kafka.server.handlers.DescribeTopicPartitionsRequestHandler;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.TestUtils;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeTopicPartitionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.KRaftVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Option;

class DescribeTopicPartitionsRequestHandlerTest {
    private final RequestChannelMetrics requestChannelMetrics = (RequestChannelMetrics)Mockito.mock(RequestChannelMetrics.class);
    private final KafkaPrincipalSerde kafkaPrincipalSerde = new KafkaPrincipalSerde(){

        public byte[] serialize(KafkaPrincipal principal) throws SerializationException {
            return Utils.utf8((String)principal.toString());
        }

        public KafkaPrincipal deserialize(byte[] bytes) throws SerializationException {
            return SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])bytes));
        }
    };
    ListenerName plaintextListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    String rack = "rack";
    int brokerId = 0;
    RegisterBrokerRecord.BrokerEndpoint brokerEndpoint;

    DescribeTopicPartitionsRequestHandlerTest() {
        this.brokerEndpoint = new RegisterBrokerRecord.BrokerEndpoint().setName(this.plaintextListener.value()).setHost("broker0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id);
    }

    @Test
    void testDescribeTopicPartitionsRequest() {
        RequestChannel.Request request;
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        String unauthorizedTopic = "unauthorized-topic";
        String authorizedTopic = "authorized-topic";
        String authorizedNonExistTopic = "authorized-non-exist";
        Action expectedActions1 = new Action(AclOperation.DESCRIBE, new ResourcePattern(ResourceType.TOPIC, unauthorizedTopic, PatternType.LITERAL), 1, true, true);
        Action expectedActions2 = new Action(AclOperation.DESCRIBE, new ResourcePattern(ResourceType.TOPIC, authorizedTopic, PatternType.LITERAL), 1, true, true);
        Action expectedActions3 = new Action(AclOperation.DESCRIBE, new ResourcePattern(ResourceType.TOPIC, authorizedNonExistTopic, PatternType.LITERAL), 1, true, true);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(RequestContext.class), (List)ArgumentMatchers.argThat(t -> t.contains(expectedActions1) || t.contains(expectedActions2) || t.contains(expectedActions3)))).thenAnswer(invocation -> {
            List actions = (List)invocation.getArgument(1);
            return actions.stream().map(action -> {
                if (action.resourcePattern().name().startsWith("authorized")) {
                    return AuthorizationResult.ALLOWED;
                }
                return AuthorizationResult.DENIED;
            }).collect(Collectors.toList());
        });
        Uuid authorizedTopicId = Uuid.randomUuid();
        Uuid unauthorizedTopicId = Uuid.randomUuid();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(authorizedTopic, authorizedTopicId);
        topicIds.put(unauthorizedTopic, unauthorizedTopicId);
        RegisterBrokerRecord.BrokerEndpointCollection collection = new RegisterBrokerRecord.BrokerEndpointCollection();
        collection.add((ImplicitLinkedHashCollection.Element)this.brokerEndpoint);
        List<ApiMessage> records = Arrays.asList(new RegisterBrokerRecord().setBrokerId(this.brokerId).setBrokerEpoch(0L).setIncarnationId(Uuid.randomUuid()).setEndPoints(collection).setRack(this.rack).setFenced(false), new TopicRecord().setName(authorizedTopic).setTopicId((Uuid)topicIds.get(authorizedTopic)), new TopicRecord().setName(unauthorizedTopic).setTopicId((Uuid)topicIds.get(unauthorizedTopic)), new PartitionRecord().setTopicId(authorizedTopicId).setPartitionId(1).setReplicas(Arrays.asList(0, 1, 2)).setLeader(0).setIsr(Arrays.asList(0)).setEligibleLeaderReplicas(Arrays.asList(1)).setLastKnownElr(Arrays.asList(2)).setLeaderEpoch(0).setPartitionEpoch(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()), new PartitionRecord().setTopicId(authorizedTopicId).setPartitionId(0).setReplicas(Arrays.asList(0, 1, 2)).setLeader(0).setIsr(Arrays.asList(0)).setEligibleLeaderReplicas(Arrays.asList(1)).setLastKnownElr(Arrays.asList(2)).setLeaderEpoch(0).setPartitionEpoch(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()), new PartitionRecord().setTopicId(unauthorizedTopicId).setPartitionId(0).setReplicas(Arrays.asList(0, 1, 3)).setLeader(0).setIsr(Arrays.asList(0)).setEligibleLeaderReplicas(Arrays.asList(1)).setLastKnownElr(Arrays.asList(3)).setLeaderEpoch(0).setPartitionEpoch(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()));
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0, () -> KRaftVersion.KRAFT_VERSION_1);
        this.updateKraftMetadataCache(metadataCache, records);
        DescribeTopicPartitionsRequestHandler handler = new DescribeTopicPartitionsRequestHandler(metadataCache, new AuthHelper(Option.apply((Object)authorizer)), this.createKafkaDefaultConfig());
        DescribeTopicPartitionsRequest describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData().setTopics(Arrays.asList(new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic), new DescribeTopicPartitionsRequestData.TopicRequest().setName(unauthorizedTopic))));
        try {
            request = this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            return;
        }
        DescribeTopicPartitionsResponseData response = handler.handleDescribeTopicPartitionsRequest(request);
        List topics = response.topics().valuesList();
        Assertions.assertEquals((int)2, (int)topics.size());
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(0);
        Assertions.assertEquals((Object)authorizedTopicId, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)authorizedTopic, (Object)topicToCheck.name());
        Assertions.assertEquals((int)2, (int)topicToCheck.partitions().size());
        topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(1);
        Assertions.assertNotEquals((Object)unauthorizedTopicId, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.TOPIC_AUTHORIZATION_FAILED.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)unauthorizedTopic, (Object)topicToCheck.name());
        describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData().setTopics(Arrays.asList(new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic), new DescribeTopicPartitionsRequestData.TopicRequest().setName(unauthorizedTopic))).setCursor(new DescribeTopicPartitionsRequestData.Cursor().setTopicName(authorizedTopic).setPartitionIndex(1)));
        try {
            request = this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            return;
        }
        response = handler.handleDescribeTopicPartitionsRequest(request);
        topics = response.topics().valuesList();
        Assertions.assertEquals((int)2, (int)topics.size());
        topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(0);
        Assertions.assertEquals((Object)authorizedTopicId, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)authorizedTopic, (Object)topicToCheck.name());
        Assertions.assertEquals((int)1, (int)topicToCheck.partitions().size());
        topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(1);
        Assertions.assertNotEquals((Object)unauthorizedTopicId, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.TOPIC_AUTHORIZATION_FAILED.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)unauthorizedTopic, (Object)topicToCheck.name());
        describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData());
        try {
            request = this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            return;
        }
        response = handler.handleDescribeTopicPartitionsRequest(request);
        topics = response.topics().valuesList();
        Assertions.assertEquals((int)1, (int)topics.size());
        topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(0);
        Assertions.assertEquals((Object)authorizedTopicId, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)authorizedTopic, (Object)topicToCheck.name());
        Assertions.assertEquals((int)2, (int)topicToCheck.partitions().size());
        describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData().setCursor(new DescribeTopicPartitionsRequestData.Cursor().setTopicName(authorizedTopic).setPartitionIndex(1)));
        try {
            request = this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            return;
        }
        response = handler.handleDescribeTopicPartitionsRequest(request);
        topics = response.topics().valuesList();
        Assertions.assertEquals((int)1, (int)topics.size());
        topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(0);
        Assertions.assertEquals((Object)authorizedTopicId, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)authorizedTopic, (Object)topicToCheck.name());
        Assertions.assertEquals((int)1, (int)topicToCheck.partitions().size());
        describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData().setResponsePartitionLimit(1));
        try {
            request = this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            return;
        }
        response = handler.handleDescribeTopicPartitionsRequest(request);
        topics = response.topics().valuesList();
        Assertions.assertEquals((int)1, (int)topics.size());
        topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(0);
        Assertions.assertEquals((Object)authorizedTopicId, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)authorizedTopic, (Object)topicToCheck.name());
        Assertions.assertEquals((int)1, (int)topicToCheck.partitions().size());
        Assertions.assertEquals((Object)authorizedTopic, (Object)response.nextCursor().topicName());
        Assertions.assertEquals((int)1, (int)response.nextCursor().partitionIndex());
    }

    @Test
    void testDescribeTopicPartitionsRequestWithEdgeCases() {
        RequestChannel.Request request;
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        String authorizedTopic = "authorized-topic1";
        String authorizedTopic2 = "authorized-topic2";
        Action expectedActions1 = new Action(AclOperation.DESCRIBE, new ResourcePattern(ResourceType.TOPIC, authorizedTopic, PatternType.LITERAL), 1, true, true);
        Action expectedActions2 = new Action(AclOperation.DESCRIBE, new ResourcePattern(ResourceType.TOPIC, authorizedTopic2, PatternType.LITERAL), 1, true, true);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(RequestContext.class), (List)ArgumentMatchers.argThat(t -> t.contains(expectedActions1) || t.contains(expectedActions2)))).thenAnswer(invocation -> {
            List actions = (List)invocation.getArgument(1);
            return actions.stream().map(action -> {
                if (action.resourcePattern().name().startsWith("authorized")) {
                    return AuthorizationResult.ALLOWED;
                }
                return AuthorizationResult.DENIED;
            }).collect(Collectors.toList());
        });
        Uuid authorizedTopicId = Uuid.randomUuid();
        Uuid authorizedTopicId2 = Uuid.randomUuid();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(authorizedTopic, authorizedTopicId);
        topicIds.put(authorizedTopic2, authorizedTopicId2);
        RegisterBrokerRecord.BrokerEndpointCollection collection = new RegisterBrokerRecord.BrokerEndpointCollection();
        collection.add((ImplicitLinkedHashCollection.Element)this.brokerEndpoint);
        List<ApiMessage> records = Arrays.asList(new RegisterBrokerRecord().setBrokerId(this.brokerId).setBrokerEpoch(0L).setIncarnationId(Uuid.randomUuid()).setEndPoints(collection).setRack(this.rack).setFenced(false), new TopicRecord().setName(authorizedTopic).setTopicId((Uuid)topicIds.get(authorizedTopic)), new TopicRecord().setName(authorizedTopic2).setTopicId((Uuid)topicIds.get(authorizedTopic2)), new PartitionRecord().setTopicId(authorizedTopicId).setPartitionId(0).setReplicas(Arrays.asList(0, 1, 2)).setLeader(0).setIsr(Arrays.asList(0)).setEligibleLeaderReplicas(Arrays.asList(1)).setLastKnownElr(Arrays.asList(2)).setLeaderEpoch(0).setPartitionEpoch(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()), new PartitionRecord().setTopicId(authorizedTopicId).setPartitionId(1).setReplicas(Arrays.asList(0, 1, 2)).setLeader(0).setIsr(Arrays.asList(0)).setEligibleLeaderReplicas(Arrays.asList(1)).setLastKnownElr(Arrays.asList(2)).setLeaderEpoch(0).setPartitionEpoch(1).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()), new PartitionRecord().setTopicId(authorizedTopicId2).setPartitionId(0).setReplicas(Arrays.asList(0, 1, 3)).setLeader(0).setIsr(Arrays.asList(0)).setEligibleLeaderReplicas(Arrays.asList(1)).setLastKnownElr(Arrays.asList(3)).setLeaderEpoch(0).setPartitionEpoch(2).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()));
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0, () -> KRaftVersion.KRAFT_VERSION_1);
        this.updateKraftMetadataCache(metadataCache, records);
        DescribeTopicPartitionsRequestHandler handler = new DescribeTopicPartitionsRequestHandler(metadataCache, new AuthHelper(Option.apply((Object)authorizer)), this.createKafkaDefaultConfig());
        DescribeTopicPartitionsRequest describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData().setTopics(Arrays.asList(new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic), new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic2))).setCursor(new DescribeTopicPartitionsRequestData.Cursor().setTopicName(authorizedTopic).setPartitionIndex(1)));
        try {
            request = this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            return;
        }
        DescribeTopicPartitionsResponseData response = handler.handleDescribeTopicPartitionsRequest(request);
        List topics = response.topics().valuesList();
        Assertions.assertEquals((int)2, (int)topics.size());
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(0);
        Assertions.assertEquals((Object)authorizedTopicId, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)authorizedTopic, (Object)topicToCheck.name());
        Assertions.assertEquals((int)1, (int)topicToCheck.partitions().size());
        topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(1);
        Assertions.assertEquals((Object)authorizedTopicId2, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)authorizedTopic2, (Object)topicToCheck.name());
        Assertions.assertEquals((int)1, (int)topicToCheck.partitions().size());
        describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData().setTopics(Arrays.asList(new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic), new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic2))).setCursor(new DescribeTopicPartitionsRequestData.Cursor().setTopicName(authorizedTopic2).setPartitionIndex(0)));
        try {
            request = this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            return;
        }
        response = handler.handleDescribeTopicPartitionsRequest(request);
        topics = response.topics().valuesList();
        Assertions.assertEquals((int)1, (int)topics.size());
        topicToCheck = (DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic)topics.get(0);
        Assertions.assertEquals((Object)authorizedTopicId2, (Object)topicToCheck.topicId());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicToCheck.errorCode());
        Assertions.assertEquals((Object)authorizedTopic2, (Object)topicToCheck.name());
        Assertions.assertEquals((int)1, (int)topicToCheck.partitions().size());
        describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData().setTopics(Arrays.asList(new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic), new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic2))).setCursor(new DescribeTopicPartitionsRequestData.Cursor().setTopicName("Non-existing").setPartitionIndex(0)));
        try {
            handler.handleDescribeTopicPartitionsRequest(this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener));
        }
        catch (Exception e) {
            Assertions.assertInstanceOf(InvalidRequestException.class, (Object)e, (String)e.getMessage());
        }
        describeTopicPartitionsRequest = new DescribeTopicPartitionsRequest(new DescribeTopicPartitionsRequestData().setTopics(Arrays.asList(new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic), new DescribeTopicPartitionsRequestData.TopicRequest().setName(authorizedTopic2))).setCursor(new DescribeTopicPartitionsRequestData.Cursor().setTopicName(authorizedTopic).setPartitionIndex(-1)));
        try {
            handler.handleDescribeTopicPartitionsRequest(this.buildRequest((AbstractRequest)describeTopicPartitionsRequest, this.plaintextListener));
        }
        catch (Exception e) {
            Assertions.assertInstanceOf(InvalidRequestException.class, (Object)e, (String)e.getMessage());
        }
    }

    void updateKraftMetadataCache(KRaftMetadataCache kRaftMetadataCache, List<ApiMessage> records) {
        MetadataImage image = kRaftMetadataCache.currentImage();
        MetadataImage partialImage = new MetadataImage(new MetadataProvenance(100L, 10, 1000L, true), image.features(), ClusterImage.EMPTY, image.topics(), image.configs(), image.clientQuotas(), image.producerIds(), image.acls(), image.scram(), image.delegationTokens());
        MetadataDelta delta = new MetadataDelta.Builder().setImage(partialImage).build();
        records.stream().forEach(record -> delta.replay(record));
        kRaftMetadataCache.setImage(delta.apply(new MetadataProvenance(100L, 10, 1000L, true)));
    }

    private RequestChannel.Request buildRequest(AbstractRequest request, ListenerName listenerName) throws UnknownHostException {
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(request.apiKey(), request.version(), "test-client", 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), Optional.empty(), new KafkaPrincipal("User", "Alice"), listenerName, SecurityProtocol.SSL, ClientInformation.EMPTY, false, Optional.of(this.kafkaPrincipalSerde));
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics, Option.apply(null));
    }

    KafkaConfig createKafkaDefaultConfig() {
        int brokerId = 1;
        Properties properties = TestUtils.createBrokerConfig(brokerId, true, true, TestUtils.RandomPort(), (Option<SecurityProtocol>)Option.apply(null), (Option<File>)Option.apply(null), (Option<Properties>)Option.apply(null), true, false, TestUtils.RandomPort(), false, TestUtils.RandomPort(), false, TestUtils.RandomPort(), (Option<String>)Option.apply(null), 1, false, 1, (short)1, false);
        properties.put("node.id", Integer.toString(brokerId));
        properties.put("process.roles", "broker");
        int voterId = brokerId + 1;
        properties.put("controller.quorum.voters", voterId + "@localhost:9093");
        properties.put("controller.listener.names", "SSL");
        properties.put("listener.security.protocol.map", "PLAINTEXT:PLAINTEXT,SSL:SSL");
        return new KafkaConfig((Map)properties);
    }
}

