/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.server.ReplicaManager;
import kafka.server.share.ShareFetchUtils;
import kafka.server.share.SharePartition;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.fetch.ShareAcquiredRecords;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Option;

public class ShareFetchUtilsTest {
    private static final FetchParams FETCH_PARAMS = new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty(), true);
    private static final BiConsumer<SharePartitionKey, Throwable> EXCEPTION_HANDLER = (key, exception) -> {};

    @Test
    public void testProcessFetchResponse() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)3L);
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)3L);
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)));
        Mockito.when((Object)sp1.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)));
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, memberId, new CompletableFuture(), partitionMaxBytes, 100);
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        MemoryRecords records1 = MemoryRecords.withRecords((long)100L, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        HashMap<TopicIdPartition, FetchPartitionData> responseData = new HashMap<TopicIdPartition, FetchPartitionData>();
        responseData.put(tp0, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        responseData.put(tp1, new FetchPartitionData(Errors.NONE, 0L, 100L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)((ReplicaManager)Mockito.mock(ReplicaManager.class)), EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).errorCode());
        Assertions.assertEquals(Collections.singletonList(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1)), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords());
        Assertions.assertEquals(Collections.singletonList(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords());
    }

    @Test
    public void testProcessFetchResponseWithEmptyRecords() {
        String groupId = "grp";
        String memberId = Uuid.randomUuid().toString();
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)3L);
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)3L);
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.empty());
        Mockito.when((Object)sp1.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.empty());
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, memberId, new CompletableFuture(), partitionMaxBytes, 100);
        HashMap<TopicIdPartition, FetchPartitionData> responseData = new HashMap<TopicIdPartition, FetchPartitionData>();
        responseData.put(tp0, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        responseData.put(tp1, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)((ReplicaManager)Mockito.mock(ReplicaManager.class)), EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).errorCode());
        Assertions.assertEquals(Collections.emptyList(), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords());
        Assertions.assertEquals(Collections.emptyList(), (Object)((ShareFetchResponseData.PartitionData)resultData.get(tp1)).acquiredRecords());
    }

    @Test
    public void testProcessFetchResponseWithLsoMovementForTopicPartition() {
        String groupId = "grp";
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes, 100);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(100L, 1L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)ArgumentMatchers.any(TopicPartition.class), ArgumentMatchers.anyLong(), (Option)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)0L, (Object[])new Long[]{5L});
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)4L, (Object[])new Long[]{4L});
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.empty(), (Object[])new ShareAcquiredRecords[]{ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(3L).setDeliveryCount((short)1))});
        Mockito.when((Object)sp1.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)), (Object[])new ShareAcquiredRecords[]{ShareAcquiredRecords.empty()});
        MemoryRecords records1 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        HashMap<TopicIdPartition, FetchPartitionData> responseData1 = new HashMap<TopicIdPartition, FetchPartitionData>();
        responseData1.put(tp0, new FetchPartitionData(Errors.OFFSET_OUT_OF_RANGE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        responseData1.put(tp1, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Map resultData1 = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData1, sharePartitions, (ReplicaManager)replicaManager, EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData1.size());
        Assertions.assertTrue((boolean)resultData1.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData1.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).errorCode());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        ((SharePartition)Mockito.verify((Object)sp1, (VerificationMode)Mockito.times((int)0))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
        MemoryRecords records2 = MemoryRecords.withRecords((long)100L, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        HashMap<TopicIdPartition, FetchPartitionData> responseData2 = new HashMap<TopicIdPartition, FetchPartitionData>();
        responseData2.put(tp0, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records2, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        responseData2.put(tp1, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Map resultData2 = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData2, sharePartitions, (ReplicaManager)replicaManager, EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData2.size());
        Assertions.assertTrue((boolean)resultData2.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData2.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData2.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData2.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData2.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData2.get(tp1)).errorCode());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).updateCacheAndOffsets(1L);
        ((SharePartition)Mockito.verify((Object)sp1, (VerificationMode)Mockito.times((int)0))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
    }

    @Test
    public void testProcessFetchResponseWhenNoRecordsAreAcquired() {
        String groupId = "grp";
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        Map<TopicIdPartition, Integer> partitionMaxBytes = Collections.singletonMap(tp0, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        ShareFetch shareFetch = new ShareFetch(FETCH_PARAMS, groupId, Uuid.randomUuid().toString(), new CompletableFuture(), partitionMaxBytes, 100);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(100L, 1L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)ArgumentMatchers.any(TopicPartition.class), ArgumentMatchers.anyLong(), (Option)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.empty());
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        Map<TopicIdPartition, FetchPartitionData> responseData = Collections.singletonMap(tp0, new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)replicaManager, EXCEPTION_HANDLER);
        Assertions.assertEquals((int)1, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertNull((Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).records());
        Assertions.assertTrue((boolean)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords().isEmpty());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        responseData = Collections.singletonMap(tp0, new FetchPartitionData(Errors.OFFSET_OUT_OF_RANGE, 0L, 0L, (Records)records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)replicaManager, EXCEPTION_HANDLER);
        Assertions.assertEquals((int)1, (int)resultData.size());
        Assertions.assertTrue((boolean)resultData.containsKey(tp0));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).partitionIndex());
        Assertions.assertNull((Object)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).records());
        Assertions.assertTrue((boolean)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).acquiredRecords().isEmpty());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData.get(tp0)).errorCode());
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)1))).updateCacheAndOffsets(1L);
    }

    @Test
    public void testProcessFetchResponseWithMaxFetchRecords() {
        String groupId = "grp";
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 1));
        HashMap<TopicIdPartition, Integer> partitionMaxBytes = new HashMap<TopicIdPartition, Integer>();
        partitionMaxBytes.put(tp0, 40000);
        partitionMaxBytes.put(tp1, 40000);
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        SharePartition sp1 = (SharePartition)Mockito.mock(SharePartition.class);
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        sharePartitions.put(tp1, sp1);
        Mockito.when((Object)sp0.nextFetchOffset()).thenReturn((Object)0L, (Object[])new Long[]{5L});
        Mockito.when((Object)sp1.nextFetchOffset()).thenReturn((Object)4L, (Object[])new Long[]{4L});
        Uuid memberId = Uuid.randomUuid();
        ShareFetch shareFetch = new ShareFetch(new FetchParams(ApiKeys.SHARE_FETCH.latestVersion(), -1, -1L, 0L, 1, 0x100000, FetchIsolation.HIGH_WATERMARK, Optional.empty()), groupId, memberId.toString(), new CompletableFuture(), partitionMaxBytes, 10);
        MemoryRecords records1 = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("0".getBytes(), "v".getBytes()), new SimpleRecord("1".getBytes(), "v".getBytes()), new SimpleRecord("2".getBytes(), "v".getBytes()), new SimpleRecord(null, "value".getBytes())});
        FetchPartitionData fetchPartitionData1 = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        FetchPartitionData fetchPartitionData2 = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)records1, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        Mockito.when((Object)sp0.acquire(memberId.toString(), 10, fetchPartitionData1)).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(1L).setDeliveryCount((short)1)));
        Mockito.when((Object)sp1.acquire(memberId.toString(), 8, fetchPartitionData2)).thenReturn((Object)ShareAcquiredRecords.fromAcquiredRecords((ShareFetchResponseData.AcquiredRecords)new ShareFetchResponseData.AcquiredRecords().setFirstOffset(100L).setLastOffset(103L).setDeliveryCount((short)1)));
        LinkedHashMap<TopicIdPartition, FetchPartitionData> responseData1 = new LinkedHashMap<TopicIdPartition, FetchPartitionData>();
        responseData1.put(tp0, fetchPartitionData1);
        responseData1.put(tp1, fetchPartitionData2);
        Map resultData1 = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData1, sharePartitions, (ReplicaManager)((ReplicaManager)Mockito.mock(ReplicaManager.class)), EXCEPTION_HANDLER);
        Assertions.assertEquals((int)2, (int)resultData1.size());
        Assertions.assertTrue((boolean)resultData1.containsKey(tp0));
        Assertions.assertTrue((boolean)resultData1.containsKey(tp1));
        Assertions.assertEquals((int)0, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).partitionIndex());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).errorCode());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).acquiredRecords().size());
        Assertions.assertEquals((long)0L, (long)((ShareFetchResponseData.AcquiredRecords)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).acquiredRecords().get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((ShareFetchResponseData.AcquiredRecords)((ShareFetchResponseData.PartitionData)resultData1.get(tp0)).acquiredRecords().get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).acquiredRecords().size());
        Assertions.assertEquals((long)100L, (long)((ShareFetchResponseData.AcquiredRecords)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).acquiredRecords().get(0)).firstOffset());
        Assertions.assertEquals((long)103L, (long)((ShareFetchResponseData.AcquiredRecords)((ShareFetchResponseData.PartitionData)resultData1.get(tp1)).acquiredRecords().get(0)).lastOffset());
    }

    @Test
    public void testProcessFetchResponseWithOffsetFetchException() {
        SharePartition sp0 = (SharePartition)Mockito.mock(SharePartition.class);
        Mockito.when((Object)sp0.leaderEpoch()).thenReturn((Object)1);
        TopicIdPartition tp0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        sharePartitions.put(tp0, sp0);
        ShareFetch shareFetch = (ShareFetch)Mockito.mock(ShareFetch.class);
        Mockito.when((Object)shareFetch.groupId()).thenReturn((Object)"grp");
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FencedLeaderEpochException exception = new FencedLeaderEpochException("Fenced exception");
        ((ReplicaManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)ArgumentMatchers.any(TopicPartition.class), ArgumentMatchers.anyLong(), (Option)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)sp0.acquire(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (FetchPartitionData)ArgumentMatchers.any(FetchPartitionData.class))).thenReturn((Object)ShareAcquiredRecords.empty());
        Map<TopicIdPartition, FetchPartitionData> responseData = Collections.singletonMap(tp0, new FetchPartitionData(Errors.OFFSET_OUT_OF_RANGE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false));
        BiConsumer exceptionHandler = (BiConsumer)Mockito.mock(BiConsumer.class);
        Map resultData = ShareFetchUtils.processFetchResponse((ShareFetch)shareFetch, responseData, sharePartitions, (ReplicaManager)replicaManager, (BiConsumer)exceptionHandler);
        Assertions.assertTrue((boolean)resultData.isEmpty());
        ((ShareFetch)Mockito.verify((Object)shareFetch, (VerificationMode)Mockito.times((int)1))).addErroneous(tp0, (Throwable)exception);
        ((BiConsumer)Mockito.verify((Object)exceptionHandler, (VerificationMode)Mockito.times((int)1))).accept(new SharePartitionKey("grp", tp0), exception);
        ((SharePartition)Mockito.verify((Object)sp0, (VerificationMode)Mockito.times((int)0))).updateCacheAndOffsets(((Long)ArgumentMatchers.any(Long.class)).longValue());
    }
}

