/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpointFile;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005f!B&M\u00011\u0003\u0006\u0002C/\u0001\u0005\u000b\u0007I\u0011A0\t\u00119\u0004!\u0011!Q\u0001\n\u0001D\u0001b\u001c\u0001\u0003\u0006\u0004%\t\u0001\u001d\u0005\n\u0003\u000f\u0001!\u0011!Q\u0001\nED!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0011)\ty\u0002\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011%\ti\u0003\u0001b\u0001\n\u0013\ty\u0003\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0019\u0011\u001d\t\u0019\u0005\u0001C)\u0003\u000bB!\"!\u0018\u0001\u0005\u0004%\t\u0001TA0\u0011!\tY\u0007\u0001Q\u0001\n\u0005\u0005\u0004\"CA7\u0001\u0001\u0007I\u0011BA8\u0011%\tI\t\u0001a\u0001\n\u0013\tY\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0015BA9\u0011%\t\t\u000b\u0001b\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u00028\u0002\u0001\u000b\u0011BAS\u0011%\tI\f\u0001b\u0001\n\u0013\tY\f\u0003\u0005\u0002F\u0002\u0001\u000b\u0011BA_\u0011%\t9\r\u0001b\u0001\n\u0013\tI\r\u0003\u0005\u0002`\u0002\u0001\u000b\u0011BAf\u0011%\t\t\u000f\u0001b\u0001\n\u0013\t\u0019\u000f\u0003\u0005\u0002l\u0002\u0001\u000b\u0011BAs\u0011)\ti\u000f\u0001b\u0001\n\u0003a\u0015q\u001e\u0005\t\u0005\u0003\u0001\u0001\u0015!\u0003\u0002r\"I!1\u0001\u0001A\u0002\u0013%!Q\u0001\u0005\n\u0005\u001b\u0001\u0001\u0019!C\u0005\u0005\u001fA\u0001Ba\u0005\u0001A\u0003&!q\u0001\u0005\n\u0005/\u0001\u0001\u0019!C\u0005\u00053A\u0011B!\t\u0001\u0001\u0004%IAa\t\t\u0011\t\u001d\u0002\u0001)Q\u0005\u00057AqAa\u000b\u0001\t\u0003\u0011i\u0003\u0003\u0005\u00034\u0001!\t\u0001\u0014B\u001b\u0011!\u0011\t\u0005\u0001C\u0001\u0019\n\r\u0003b\u0002B&\u0001\u0011\u0005!Q\n\u0005\n\u0005_\u0002\u0011\u0013!C\u0001\u0005cBqAa\"\u0001\t\u0003\u0011I\tC\u0004\u0003\u0018\u0002!\tA!#\t\u000f\te\u0005\u0001\"\u0001\u0003\u001c\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BT\u0001\u0011\u0005!\u0011\u0016\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011\u001d\u0011\t\r\u0001C\u0005\u0005\u0007DqAa2\u0001\t\u0003\u0011I\rC\u0004\u0003N\u0002!\tAa4\t\u0013\t\u001d\b!%A\u0005\u0002\t%\b\"\u0003Bw\u0001E\u0005I\u0011\u0001Bx\u0011\u001d\u0011\u0019\u0010\u0001C\u0001\u0005kDqa!\u0001\u0001\t\u0003\u0019\u0019\u0001C\u0004\u0004\n\u0001!\taa\u0003\t\u000f\rU\u0001\u0001\"\u0001\u0004\u0018!91\u0011\u0005\u0001\u0005\u0002\r\r\u0002\u0002CA]\u0001\u0011\u0005Aja\n\t\u000f\rE\u0002\u0001\"\u0001\u00044!911\b\u0001\u0005\n\ru\u0002bBB\"\u0001\u0011\u00051Q\t\u0005\b\u0007\u000f\u0002A\u0011AB#\u000f!\u0019I\u0005\u0014E\u0001\u0019\u000e-caB&M\u0011\u0003a5Q\n\u0005\b\u0003CYD\u0011AB(\u0011%\u0019\tf\u000fb\u0001\n\u0013\ty\u0006\u0003\u0005\u0004Tm\u0002\u000b\u0011BA1\u0011%\u0019)f\u000fb\u0001\n\u0013\ty\u0006\u0003\u0005\u0004Xm\u0002\u000b\u0011BA1\u0011%\u0019If\u000fb\u0001\n\u0013\ty\u0006\u0003\u0005\u0004\\m\u0002\u000b\u0011BA1\u0011%\u0019if\u000fb\u0001\n\u0013\ty\u0006\u0003\u0005\u0004`m\u0002\u000b\u0011BA1\u0011)\u0019\tg\u000fb\u0001\n\u0003a51\r\u0005\t\u0007SZ\u0004\u0015!\u0003\u0004f!911N\u001e\u0005\n\r5\u0004bBB9w\u0011%11\u000f\u0005\b\u0007\u007fZD\u0011ABA\u0011\u001d\u0019\u0019j\u000fC\u0001\u0007+\u0013\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u0015\tie*A\u0002m_\u001eT\u0011aT\u0001\u0006W\u000647.Y\n\u0004\u0001E;\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&AB!osJ+g\r\u0005\u0002Y76\t\u0011L\u0003\u0002[\u001d\u0006)Q\u000f^5mg&\u0011A,\u0017\u0002\b\u0019><w-\u001b8h\u0003\u001dawn\u001a#jeN\u001c\u0001!F\u0001a!\r\tGMZ\u0007\u0002E*\u00111mU\u0001\u000bG>dG.Z2uS>t\u0017BA3c\u0005\r\u0019V-\u001d\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f!![8\u000b\u0003-\fAA[1wC&\u0011Q\u000e\u001b\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0003E\u0004B\u0001\u0017:u\u007f&\u00111/\u0017\u0002\u0005!>|G\u000e\u0005\u0002v{6\taO\u0003\u0002xq\u000611m\\7n_:T!aT=\u000b\u0005i\\\u0018AB1qC\u000eDWMC\u0001}\u0003\ry'oZ\u0005\u0003}Z\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\u0002\u0005\rQ\"\u0001'\n\u0007\u0005\u0015AJ\u0001\u0006V]&4\u0017.\u001a3M_\u001e\fQ\u0001\\8hg\u0002\nA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016dWCAA\u0007!\u0011\ty!a\u0007\u000e\u0005\u0005E!bA'\u0002\u0014)!\u0011QCA\f\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0002\u001aa\fqa\u001d;pe\u0006<W-\u0003\u0003\u0002\u001e\u0005E!\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\rqJg.\u001b;?)!\t)#a\n\u0002*\u0005-\u0002cAA\u0001\u0001!)Ql\u0002a\u0001A\")qn\u0002a\u0001c\"9\u0011\u0011B\u0004A\u0002\u00055\u0011\u0001D7fiJL7m]$s_V\u0004XCAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tq!\\3ue&\u001c7OC\u0002\u0002<a\faa]3sm\u0016\u0014\u0018\u0002BA \u0003k\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003/rA!a\u0013\u0002TA\u0019\u0011QJ*\u000e\u0005\u0005=#bAA)=\u00061AH]8pizJ1!!\u0016T\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011LA.\u0005\u0019\u0019FO]5oO*\u0019\u0011QK*\u0002)=4gm]3u\u0007\",7m\u001b9pS:$h)\u001b7f+\t\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9G[\u0001\u0005Y\u0006tw-\u0003\u0003\u0002Z\u0005\u0015\u0014!F8gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rI\u0001\fG\",7m\u001b9pS:$8/\u0006\u0002\u0002rA9\u00111OA=M\u0006uTBAA;\u0015\r\t9HY\u0001\nS6lW\u000f^1cY\u0016LA!a\u001f\u0002v\t\u0019Q*\u00199\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003SA!a!\u0002\u0014\u0005Q1\r[3dWB|\u0017N\u001c;\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u0015\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0002\u001f\rDWmY6q_&tGo]0%KF$B!!$\u0002\u0014B\u0019!+a$\n\u0007\u0005E5K\u0001\u0003V]&$\b\"CAK\u001d\u0005\u0005\t\u0019AA9\u0003\rAH%M\u0001\rG\",7m\u001b9pS:$8\u000f\t\u0015\u0004\u001f\u0005m\u0005c\u0001*\u0002\u001e&\u0019\u0011qT*\u0003\u0011Y|G.\u0019;jY\u0016\f!\"\u001b8Qe><'/Z:t+\t\t)\u000bE\u0004\u0002(\u00065F/!-\u000e\u0005\u0005%&bAAVE\u00069Q.\u001e;bE2,\u0017\u0002BAX\u0003S\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u0002\u0005M\u0016bAA[\u0019\n\u0001Bj\\4DY\u0016\fg.\u001b8h'R\fG/Z\u0001\fS:\u0004&o\\4sKN\u001c\b%A\u000bv]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005u\u0006\u0003CAT\u0003[\u000b9%a0\u0011\u000b\u0005\u001d\u0016\u0011\u0019;\n\t\u0005\r\u0017\u0011\u0016\u0002\u0004'\u0016$\u0018AF;oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\t1|7m[\u000b\u0003\u0003\u0017\u0004B!!4\u0002\\6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.A\u0003m_\u000e\\7O\u0003\u0003\u0002V\u0006]\u0017AC2p]\u000e,(O]3oi*\u0019\u0011\u0011\u001c6\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\fyMA\u0007SK\u0016tGO]1oi2{7m[\u0001\u0006Y>\u001c7\u000eI\u0001\u0013a\u0006,8/\u001a3DY\u0016\fg.\u001b8h\u0007>tG-\u0006\u0002\u0002fB!\u0011QZAt\u0013\u0011\tI/a4\u0003\u0013\r{g\u000eZ5uS>t\u0017a\u00059bkN,Gm\u00117fC:LgnZ\"p]\u0012\u0004\u0013AF4bk\u001e,W*\u001a;sS\u000et\u0015-\\3XSRDG+Y4\u0016\u0005\u0005E\b\u0003CAz\u0003k\f9%a>\u000e\u0005\u0005]\u0017\u0002BAX\u0003/\u0004b!a=\u0002z\u0006u\u0018\u0002BA~\u0003/\u0014A\u0001T5tiBA\u00111_A\u0000\u0003\u000f\n9%\u0003\u0003\u0002|\u0005]\u0017aF4bk\u001e,W*\u001a;sS\u000et\u0015-\\3XSRDG+Y4!\u0003e!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8\u0016\u0005\t\u001d\u0001c\u0001*\u0003\n%\u0019!1B*\u0003\r\u0011{WO\u00197f\u0003u!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8`I\u0015\fH\u0003BAG\u0005#A\u0011\"!&\u001c\u0003\u0003\u0005\rAa\u0002\u00025\u0011L'\u000f^5fgRdunZ\"mK\u0006t\u0017M\u00197f%\u0006$\u0018n\u001c\u0011)\u0007q\tY*A\u0007uS6,wJ\u001a'bgR\u0014VO\\\u000b\u0003\u00057\u00012A\u0015B\u000f\u0013\r\u0011yb\u0015\u0002\u0005\u0019>tw-A\tuS6,wJ\u001a'bgR\u0014VO\\0%KF$B!!$\u0003&!I\u0011Q\u0013\u0010\u0002\u0002\u0003\u0007!1D\u0001\u000fi&lWm\u00144MCN$(+\u001e8!Q\ry\u00121T\u0001\u0016C2d7\t\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\u0011y\u0003E\u0004\u0002J\tEBOa\u0007\n\t\u0005m\u00141L\u0001\u000eG2,\u0017M\\5oON#\u0018\r^3\u0015\t\t]\"Q\b\t\u0006%\ne\u0012\u0011W\u0005\u0004\u0005w\u0019&AB(qi&|g\u000e\u0003\u0004\u0003@\u0005\u0002\r\u0001^\u0001\u0003iB\f\u0001c]3u\u00072,\u0017M\\5oON#\u0018\r^3\u0015\r\u00055%Q\tB$\u0011\u0019\u0011yD\ta\u0001i\"9!\u0011\n\u0012A\u0002\u0005E\u0016!B:uCR,\u0017!G4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$bAa\u0014\u0003X\t\u0015\u0004#\u0002*\u0003:\tE\u0003\u0003BA\u0001\u0005'J1A!\u0016M\u0005)aun\u001a+p\u00072,\u0017M\u001c\u0005\b\u00053\u001a\u0003\u0019\u0001B.\u0003\u0011!\u0018.\\3\u0011\t\tu#\u0011M\u0007\u0003\u0005?R!A\u0017<\n\t\t\r$q\f\u0002\u0005)&lW\rC\u0005\u0003h\r\u0002\n\u00111\u0001\u0003j\u0005i\u0001O]3DY\u0016\fgn\u0015;biN\u0004B!!\u0001\u0003l%\u0019!Q\u000e'\u0003\u001bA\u0013Xm\u00117fC:\u001cF/\u0019;t\u0003\r:'/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4%I\u00164\u0017-\u001e7uII*\"Aa\u001d+\t\t%$QO\u0016\u0003\u0005o\u0002BA!\u001f\u0003\u00046\u0011!1\u0010\u0006\u0005\u0005{\u0012y(A\u0005v]\u000eDWmY6fI*\u0019!\u0011Q*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0006\nm$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061\u0003/Y;tK\u000ecW-\u00198j]\u001e4uN\u001d(p]\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0005\t-\u0005#B1\u0003\u000e\nE\u0015b\u0001BHE\nA\u0011\n^3sC\ndW\rE\u0003S\u0005'#x0C\u0002\u0003\u0016N\u0013a\u0001V;qY\u0016\u0014\u0014!\u00043fY\u0016$\u0018M\u00197f\u0019><7/A\u0007bE>\u0014Ho\u00117fC:Lgn\u001a\u000b\u0005\u0003\u001b\u0013i\n\u0003\u0004\u0003 \u001e\u0002\r\u0001^\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003U\t'm\u001c:u\u0003:$\u0007+Y;tK\u000ecW-\u00198j]\u001e$B!!$\u0003&\"1!q\u0014\u0015A\u0002Q\faB]3tk6,7\t\\3b]&tw\r\u0006\u0003\u0002\u000e\n-\u0006b\u0002BWS\u0001\u0007!qV\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB!\u0011M!$u\u0003EI7o\u00117fC:LgnZ%o'R\fG/\u001a\u000b\u0007\u0005k\u0013YL!0\u0011\u0007I\u00139,C\u0002\u0003:N\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0003 *\u0002\r\u0001\u001e\u0005\b\u0005\u007fS\u0003\u0019AAY\u00035)\u0007\u0010]3di\u0016$7\u000b^1uK\u00069\u0012n]\"mK\u0006t\u0017N\\4J]N#\u0018\r^3QCV\u001cX\r\u001a\u000b\u0005\u0005k\u0013)\r\u0003\u0004\u0003 .\u0002\r\u0001^\u0001\u0015G\",7m[\"mK\u0006t\u0017N\\4BE>\u0014H/\u001a3\u0015\t\u00055%1\u001a\u0005\u0007\u0005?c\u0003\u0019\u0001;\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\u0006\u0005\u0002\u000e\nE'Q\u001bBq\u0011\u0019\u0011\u0019.\fa\u0001M\u00069A-\u0019;b\t&\u0014\b\"\u0003Bl[A\u0005\t\u0019\u0001Bm\u0003Y\u0001\u0018M\u001d;ji&|g\u000eV8Va\u0012\fG/Z(s\u0003\u0012$\u0007#\u0002*\u0003:\tm\u0007C\u0002*\u0003\u0014R\u0014i\u000e\u0005\u0003\u0002d\t}\u0017\u0002\u0002B\u0010\u0003KB\u0011Ba9.!\u0003\u0005\rA!:\u0002#A\f'\u000f^5uS>tGk\u001c*f[>4X\r\u0005\u0003S\u0005s!\u0018aG;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ug\u0012\"WMZ1vYR$#'\u0006\u0002\u0003l*\"!\u0011\u001cB;\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u001f\u0016\u0005\u0005K\u0014)(\u0001\nbYR,'o\u00115fG.\u0004x.\u001b8u\t&\u0014H\u0003CAG\u0005o\u0014IP!@\t\r\t}\u0005\u00071\u0001u\u0011\u0019\u0011Y\u0010\ra\u0001M\u0006a1o\\;sG\u0016dun\u001a#je\"1!q \u0019A\u0002\u0019\f!\u0002Z3ti2{w\rR5s\u0003MA\u0017M\u001c3mK2{w\rR5s\r\u0006LG.\u001e:f)\u0011\tii!\u0002\t\u000f\r\u001d\u0011\u00071\u0001\u0002H\u0005\u0019A-\u001b:\u0002/5\f\u0017PY3UeVt7-\u0019;f\u0007\",7m\u001b9pS:$H\u0003CAG\u0007\u001b\u0019ya!\u0005\t\r\tM'\u00071\u0001g\u0011\u0019\u0011yJ\ra\u0001i\"911\u0003\u001aA\u0002\tu\u0017AB8gMN,G/\u0001\u0007e_:,7\t\\3b]&tw\r\u0006\u0005\u0002\u000e\u000ee11DB\u000f\u0011\u0019\u0011yj\ra\u0001i\"1!1[\u001aA\u0002\u0019Dqaa\b4\u0001\u0004\u0011Y\"A\u0005f]\u0012|eMZ:fi\u0006aAm\u001c8f\t\u0016dW\r^5oOR!\u0011QRB\u0013\u0011\u001d\u0011i\u000b\u000ea\u0001\u0005_#Ba!\u000b\u0004.A)\u0011\u0011JB\u0016i&!\u00111YA.\u0011\u001d\u0019y#\u000ea\u0001\u0003\u000f\na\u0001\\8h\t&\u0014\u0018\u0001G7be.\u0004\u0016M\u001d;ji&|g.\u00168dY\u0016\fg.\u00192mKR1\u0011QRB\u001b\u0007oAqaa\f7\u0001\u0004\t9\u0005\u0003\u0004\u0004:Y\u0002\r\u0001^\u0001\na\u0006\u0014H/\u001b;j_:\fa#[:V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\u001c\u000b\u0007\u0005k\u001byd!\u0011\t\u000b5;\u0004\u0019A@\t\r\t}u\u00071\u0001u\u0003ui\u0017-\u001b8uC&tWK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001cHCAAG\u00035\u0011X-\\8wK6+GO]5dg\u0006\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0011\u0007\u0005\u00051hE\u0002<#^#\"aa\u0013\u0002IUs7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\fQ%\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7oQ8v]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u00025Us7\r\\3b]\u0006\u0014G.\u001a\"zi\u0016\u001cX*\u001a;sS\u000et\u0015-\\3\u00027Us7\r\\3b]\u0006\u0014G.\u001a\"zi\u0016\u001cX*\u001a;sS\u000et\u0015-\\3!\u0003ei\u0015\r\u001f#jeRL\b+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3\u000255\u000b\u0007\u0010R5sif\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u00029QKW.Z*j]\u000e,G*Y:u%VtWj]'fiJL7MT1nK\u0006iB+[7f'&t7-\u001a'bgR\u0014VO\\'t\u001b\u0016$(/[2OC6,\u0007%\u0001\u000bHCV<W-T3ue&\u001cg*Y7f\u001d>$\u0016mZ\u000b\u0003\u0007K\u0002b!a\u001d\u0004h\u0005\u0005\u0014\u0002BAb\u0003k\nQcR1vO\u0016lU\r\u001e:jG:\u000bW.\u001a(p)\u0006<\u0007%\u0001\njg\u000e{W\u000e]1di\u0006sG\rR3mKR,G\u0003\u0002B[\u0007_BQ!T$A\u0002}\f!#\\1y\u0007>l\u0007/Y2uS>tG)\u001a7bsRA!1DB;\u0007o\u001aY\bC\u0003N\u0011\u0002\u0007q\u0010C\u0004\u0004z!\u0003\rAa\u0007\u0002!\u0019L'o\u001d;ESJ$\u0018p\u00144gg\u0016$\bbBB?\u0011\u0002\u0007!1D\u0001\u0004]><\u0018\u0001E2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t)!\u0019\u0019i!#\u0004\f\u000eE\u0005\u0003BA\u0001\u0007\u000bK1aa\"M\u00059yeMZ:fiN$vn\u00117fC:DQ!T%A\u0002}Dqa!$J\u0001\u0004\u0019y)A\bmCN$8\t\\3b]>3gm]3u!\u0015\u0011&\u0011\bB\u000e\u0011\u001d\u0019i(\u0013a\u0001\u00057\tqcY1mGVd\u0017\r^3DY\u0016\fg.\u00192mK\nKH/Z:\u0015\u0011\r]5\u0011TBN\u0007;\u0003rA\u0015BJ\u00057\u0011Y\u0002C\u0003N\u0015\u0002\u0007q\u0010C\u0004\u0004z)\u0003\rAa\u0007\t\u000f\r}%\n1\u0001\u0003\u001c\u0005\tRO\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;")
public class LogCleanerManager
implements Logging {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final KafkaMetricsGroup metricsGroup;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final scala.collection.mutable.HashMap<TopicPartition, LogCleaningState> inProgress;
    private final scala.collection.mutable.HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private final HashMap<String, java.util.List<java.util.Map<String, String>>> gaugeMetricNameWithTag;
    private volatile double dirtiestLogCleanableRatio;
    private volatile long timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> calculateCleanableBytes(UnifiedLog log, long firstDirtyOffset, long uncleanableOffset) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(log, firstDirtyOffset, uncleanableOffset);
    }

    public static OffsetsToClean cleanableOffsets(UnifiedLog log, Option<Object> lastCleanOffset, long now) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, lastCleanOffset, now);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private scala.collection.mutable.HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private scala.collection.mutable.HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public HashMap<String, java.util.List<java.util.Map<String, String>>> gaugeMetricNameWithTag() {
        return this.gaugeMetricNameWithTag;
    }

    private double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    private void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        scala.collection.immutable.Map map;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            map = LogCleanerManager.$anonfun$allCleanerCheckpoints$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return map;
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        Option option;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$cleaningState$1(this, tp);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$setCleaningState$1(this, tp, state);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        Option option;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$grabFilthiestCompactedLog$1(this, time, preCleanStats);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        Iterable iterable;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> deletableLogs() {
        Iterable iterable;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$deletableLogs$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    public void abortCleaning(TopicPartition topicPartition) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                Option option = $this.inProgress().get(topicPartition);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Compaction for partition " + topicPartition + " cannot be resumed since it is not paused.");
                }
                if (option instanceof Some) {
                    int count;
                    LogCleaningState state = (LogCleaningState)((Some)option).value();
                    boolean bl = false;
                    LogCleaningPaused logCleaningPaused = null;
                    if (state instanceof LogCleaningPaused) {
                        bl = true;
                        logCleaningPaused = (LogCleaningPaused)state;
                        if (logCleaningPaused.pausedCount() == 1) {
                            return $this.inProgress().remove(topicPartition);
                        }
                    }
                    if (bl && (count = logCleaningPaused.pausedCount()) > 1) {
                        return $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
                    }
                    throw new IllegalStateException("Compaction for partition " + topicPartition + " cannot be resumed since it is in " + state + " state.");
                }
                throw new MatchError((Object)option);
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            return !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        }
        throw new MatchError((Object)option);
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
        }
        throw new MatchError((Object)option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$checkCleaningAborted$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Long>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$updateCheckpoints$1(this, dataDir, partitionToRemove, partitionToUpdateOrAdd);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public Option<Tuple2<TopicPartition, Long>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$alterCheckpointDir$1(this, sourceLogDir, topicPartition, destLogDir);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void handleLogDirFailure(String dir) {
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Stopping cleaning logs in dir " + dir);
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir$3, x0$1)))));
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, Long offset) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maybeTruncateCheckpoint$1(this, topicPartition, dataDir, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$doneCleaning$1(this, topicPartition, dataDir, endOffset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                LogCleaningState logCleaningState;
                boolean bl = false;
                Some some = null;
                Option option = $this.inProgress().get(topicPartition);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                    if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                    $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                    $this.pausedCleaningCond().signalAll();
                    return BoxedUnit.UNIT;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("State for partition " + topicPartition + " should exist.");
                }
                throw new IllegalStateException("In-progress partition " + topicPartition + " cannot be in " + option + " state.");
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            partitions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions.elem).$plus$plus((IterableOnce)this.uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        }
        finally {
            inLock_lock.unlock();
        }
        return (scala.collection.immutable.Set)partitions.elem;
    }

    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$markPartitionUncleanable$1(this, logDir, partition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isUncleanablePartition(UnifiedLog log, TopicPartition topicPartition) {
        boolean bl;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            bl = LogCleanerManager.$anonfun$isUncleanablePartition$1(this, log, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public void maintainUncleanablePartitions() {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maintainUncleanablePartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public void removeMetrics() {
        LogCleanerManager$.MODULE$.GaugeMetricNameNoTag().foreach((Function1 & Serializable)x$1 -> {
            LogCleanerManager.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.MapHasAsScala(this.gaugeMetricNameWithTag()).asScala().foreach((Function1 & Serializable)metricNameAndTags -> {
            LogCleanerManager.$anonfun$removeMetrics$2(this, metricNameAndTags);
            return BoxedUnit.UNIT;
        });
        this.gaugeMetricNameWithTag().clear();
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleanerManager $this, File dir$1) {
        return BoxesRunTime.unboxToInt((Object)$this.uncleanablePartitions().get((Object)dir$1.getAbsolutePath()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public static final /* synthetic */ int $anonfun$new$2(LogCleanerManager $this, File dir$1) {
        int n;
        ReentrantLock inLock_lock = $this.lock();
        inLock_lock.lock();
        try {
            n = LogCleanerManager.$anonfun$new$3($this, dir$1);
        }
        finally {
            inLock_lock.unlock();
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$new$1(LogCleanerManager $this, File dir) {
        java.util.Map metricTag = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava();
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleanerManager.$anonfun$new$2($this, dir)), metricTag);
        return ((java.util.List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName(), x$2 -> new ArrayList())).add(metricTag);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$new$11(scala.collection.immutable.Map lastClean$1, TopicPartition tp$1, long now$1, UnifiedLog log) {
        void var8_7;
        Option lastCleanOffset = lastClean$1.get((Object)tp$1);
        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now$1);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long uncleanableBytes = tuple2._2$mcJ$sp();
        return (long)var8_7;
    }

    public static final /* synthetic */ long $anonfun$new$10(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)$this.logs().get(tp)).map((Function1 & Serializable)log -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$11(lastClean$1, tp, now$1, log))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$new$9(LogCleanerManager $this, File dir$2) {
        Option option = $this.uncleanablePartitions().get((Object)dir$2.getAbsolutePath());
        if (option instanceof Some) {
            Set partitions = (Set)((Some)option).value();
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
            long now = Time.SYSTEM.milliseconds();
            return BoxesRunTime.unboxToLong((Object)partitions.iterator().map((Function1 & Serializable)tp -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$10($this, lastClean, now, tp))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ long $anonfun$new$8(LogCleanerManager $this, File dir$2) {
        long l;
        ReentrantLock inLock_lock = $this.lock();
        inLock_lock.lock();
        try {
            l = LogCleanerManager.$anonfun$new$9($this, dir$2);
        }
        finally {
            inLock_lock.unlock();
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$new$7(LogCleanerManager $this, File dir) {
        java.util.Map metricTag = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava();
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanableBytesMetricName(), () -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$8($this, dir)), metricTag);
        return ((java.util.List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanableBytesMetricName(), x$3 -> new ArrayList())).add(metricTag);
    }

    public static final /* synthetic */ int $anonfun$new$14(LogCleanerManager $this) {
        return (int)((double)100 * $this.dirtiestLogCleanableRatio());
    }

    public static final /* synthetic */ long $anonfun$new$15(LogCleanerManager $this) {
        return Time.SYSTEM.milliseconds() - $this.timeOfLastRun();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$allCleanerCheckpoints$1(LogCleanerManager $this) {
        return ((IterableOnceOps)$this.checkpoints().values().flatMap((Function1 & Serializable)checkpoint -> {
            try {
                return (Map)CollectionConverters$.MODULE$.MapHasAsScala(checkpoint.read()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        TopicPartition tp = (TopicPartition)x0$1._1();
                        Long offset = (Long)x0$1._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(offset)));
                    }
                    throw new MatchError(null);
                });
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to access checkpoint file " + checkpoint.file().getName() + " in dir " + checkpoint.file().getParentFile().getAbsolutePath(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Option $anonfun$cleaningState$1(LogCleanerManager $this, TopicPartition tp$2) {
        return $this.inProgress().get((Object)tp$2);
    }

    public static final /* synthetic */ Option $anonfun$setCleaningState$1(LogCleanerManager $this, TopicPartition tp$3, LogCleaningState state$1) {
        return $this.inProgress().put((Object)tp$3, (Object)state$1);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((UnifiedLog)x0$1._2()).config().compact;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            UnifiedLog log = (UnifiedLog)x0$2._2();
            return $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > ltc.log().config().minCleanableRatio;
    }

    public static final /* synthetic */ Option $anonfun$grabFilthiestCompactedLog$1(LogCleanerManager $this, Time time$1, PreCleanStats preCleanStats$1) {
        long now = time$1.milliseconds();
        $this.timeOfLastRun_$eq(now);
        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
        Iterable dirtyLogs = (Iterable)((IterableOps)((IterableOps)((IterableOps)$this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3($this, x0$2)))).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                UnifiedLog log = (UnifiedLog)x0$3._2();
                try {
                    Option lastCleanOffset = lastClean.get((Object)topicPartition);
                    OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                    if (offsetsToClean.forceUpdateCheckpoint()) {
                        $this.updateCheckpoints(log.parentDirFile(), (Option<Tuple2<TopicPartition, Long>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)Predef$.MODULE$.long2Long(offsetsToClean.firstDirtyOffset()))), $this.updateCheckpoints$default$3());
                    }
                    long compactionDelayMs = LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$maxCompactionDelay(log, offsetsToClean.firstDirtyOffset(), now);
                    preCleanStats$1.updateMaxCompactionDelay(compactionDelayMs);
                    return new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), compactionDelayMs > 0L);
                }
                catch (Throwable e) {
                    throw new LogCleaningException(log, "Failed to calculate log cleaning stats for partition " + topicPartition, e);
                }
            }
            throw new MatchError(null);
        })).filter((Function1 & Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
        $this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
        Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
        if (cleanableLogs.isEmpty()) {
            return None$.MODULE$;
        }
        preCleanStats$1.recordCleanablePartitions(cleanableLogs.size());
        LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        $this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
        return new Some((Object)filthiest);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return !((UnifiedLog)x0$1._2()).config().compact;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            return $this.inProgress().contains((Object)topicPartition);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Iterable $anonfun$pauseCleaningForNonCompactedPartitions$1(LogCleanerManager $this) {
        Iterable deletableLogs = (Iterable)((IterableOps)$this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3($this, x0$2)));
        deletableLogs.foreach((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                return $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
            }
            throw new MatchError(null);
        });
        return deletableLogs;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            return !$this.inProgress().contains((Object)topicPartition) && log.config().compact && !$this.isUncleanablePartition(log, topicPartition);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Iterable $anonfun$deletableLogs$1(LogCleanerManager $this) {
        Iterable toClean = (Iterable)$this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2($this, x0$1)));
        toClean.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                return $this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
            }
            throw new MatchError(null);
        });
        return toClean;
    }

    public static final /* synthetic */ void $anonfun$abortCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$1) {
        $this.abortAndPauseCleaning(topicPartition$1);
        $this.resumeCleaning((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition$1, (List)Nil$.MODULE$));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException("Compaction for partition " + topicPartition$2 + " cannot be aborted and paused since it is in " + s + " state.");
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ void $anonfun$checkCleaningAborted$1(LogCleanerManager $this, TopicPartition topicPartition$3) {
        if ($this.isCleaningInState(topicPartition$3, LogCleaningAborted$.MODULE$)) {
            throw new LogCleaningAbortedException();
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.logs().keys().contains((Object)tp);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$updateCheckpoints$1(LogCleanerManager $this, File dataDir$1, Option partitionToRemove$1, Option partitionToUpdateOrAdd$1) {
        OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$1);
        if (checkpoint != null) {
            try {
                scala.collection.immutable.Map map;
                scala.collection.immutable.Map map2;
                scala.collection.immutable.Map currentCheckpoint = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(checkpoint.read()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2($this, x0$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                if (partitionToRemove$1 instanceof Some) {
                    TopicPartition topicPartition = (TopicPartition)((Some)partitionToRemove$1).value();
                    map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus((Object)topicPartition);
                } else if (None$.MODULE$.equals(partitionToRemove$1)) {
                    map2 = currentCheckpoint;
                } else {
                    throw new MatchError((Object)partitionToRemove$1);
                }
                scala.collection.immutable.Map updatedCheckpoint = map2;
                if (partitionToUpdateOrAdd$1 instanceof Some) {
                    Tuple2 updatedOffset = (Tuple2)((Some)partitionToUpdateOrAdd$1).value();
                    map = (scala.collection.immutable.Map)updatedCheckpoint.$plus(updatedOffset);
                } else if (None$.MODULE$.equals(partitionToUpdateOrAdd$1)) {
                    map = updatedCheckpoint;
                } else {
                    throw new MatchError((Object)partitionToUpdateOrAdd$1);
                }
                updatedCheckpoint = map;
                checkpoint.write(CollectionConverters$.MODULE$.MapHasAsJava((Map)updatedCheckpoint).asJava());
                return;
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to access checkpoint file " + checkpoint.file().getName() + " in dir " + checkpoint.file().getParentFile().getAbsolutePath(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$alterCheckpointDir$1(LogCleanerManager $this, File sourceLogDir$1, TopicPartition topicPartition$4, File destLogDir$1) {
        try {
            Option option = $this.checkpoints().get((Object)sourceLogDir$1).flatMap((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.MapHasAsScala(x$4.read()).asScala().get((Object)topicPartition$4));
            if (option instanceof Some) {
                Long offset = (Long)((Some)option).value();
                $this.debug((Function0<String>)(Function0 & Serializable)() -> "Removing the partition offset data in checkpoint file for '" + topicPartition$4 + "' from " + sourceLogDir$1.getAbsoluteFile() + " directory.");
                Option x$2 = Option$.MODULE$.apply((Object)topicPartition$4);
                Option<Tuple2<TopicPartition, Long>> x$3 = $this.updateCheckpoints$default$2();
                $this.updateCheckpoints(sourceLogDir$1, x$3, (Option<TopicPartition>)x$2);
                $this.debug((Function0<String>)(Function0 & Serializable)() -> "Adding the partition offset data in checkpoint file for '" + topicPartition$4 + "' to " + destLogDir$1.getAbsoluteFile() + " directory.");
                $this.updateCheckpoints(destLogDir$1, (Option<Tuple2<TopicPartition, Long>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$4, (Object)offset)), $this.updateCheckpoints$default$3());
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
        }
        catch (KafkaStorageException e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to access checkpoint file in dir " + sourceLogDir$1.getAbsolutePath(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
        }
        Set logUncleanablePartitions = (Set)$this.uncleanablePartitions().getOrElse((Object)sourceLogDir$1.toString(), (Function0 & Serializable)() -> (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        if (logUncleanablePartitions.contains((Object)topicPartition$4)) {
            logUncleanablePartitions.remove((Object)topicPartition$4);
            $this.markPartitionUncleanable(destLogDir$1.toString(), topicPartition$4);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((File)x0$1._1()).getAbsolutePath();
            return string == null ? dir$3 != null : !string.equals(dir$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeTruncateCheckpoint$1(LogCleanerManager $this, TopicPartition topicPartition$5, File dataDir$2, Long offset$1) {
        if ($this.logs().get((TopicPartition)topicPartition$5).config().compact) {
            OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$2);
            if (checkpoint != null) {
                java.util.Map existing = checkpoint.read();
                if (Predef$.MODULE$.Long2long(existing.getOrDefault(topicPartition$5, Predef$.MODULE$.long2Long(0L))) > Predef$.MODULE$.Long2long(offset$1)) {
                    existing.put(topicPartition$5, offset$1);
                    checkpoint.write(existing);
                    return;
                }
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ Object $anonfun$doneCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$6, File dataDir$3, long endOffset$1) {
        LogCleaningState logCleaningState;
        boolean bl = false;
        Some some = null;
        Option option = $this.inProgress().get((Object)topicPartition$6);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                $this.updateCheckpoints(dataDir$3, (Option<Tuple2<TopicPartition, Long>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$6, (Object)Predef$.MODULE$.long2Long(endOffset$1))), $this.updateCheckpoints$default$3());
                return $this.inProgress().remove((Object)topicPartition$6);
            }
        }
        if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
            $this.inProgress().put((Object)topicPartition$6, (Object)new LogCleaningPaused(1));
            $this.pausedCleaningCond().signalAll();
            return BoxedUnit.UNIT;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("State for partition " + topicPartition$6 + " should exist.");
        }
        throw new IllegalStateException("In-progress partition " + topicPartition$6 + " cannot be in " + option + " state.");
    }

    public static final /* synthetic */ void $anonfun$uncleanablePartitions$1(LogCleanerManager $this, ObjectRef partitions$1, String logDir$1) {
        partitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions$1.elem).$plus$plus((IterableOnce)$this.uncleanablePartitions().getOrElse((Object)logDir$1, (Function0 & Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
    }

    public static final /* synthetic */ Object $anonfun$markPartitionUncleanable$1(LogCleanerManager $this, String logDir$2, TopicPartition partition$1) {
        Option option = $this.uncleanablePartitions().get((Object)logDir$2);
        if (option instanceof Some) {
            return BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition$1));
        }
        if (None$.MODULE$.equals(option)) {
            return $this.uncleanablePartitions().put((Object)logDir$2, Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$1})));
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$isUncleanablePartition$1(LogCleanerManager $this, UnifiedLog log$1, TopicPartition topicPartition$7) {
        return $this.uncleanablePartitions().get((Object)log$1.parentDir()).exists((Function1 & Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition$7)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$3(LogCleanerManager $this, TopicPartition id) {
        return $this.logs().contains(id);
    }

    public static final /* synthetic */ scala.collection.mutable.HashMap $anonfun$maintainUncleanablePartitions$1(LogCleanerManager $this) {
        $this.uncleanablePartitions().values().foreach((Function1 & Serializable)partitions -> (Set)partitions.filterInPlace((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$3($this, id))));
        return $this.uncleanablePartitions().filterInPlace((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)x1$1.nonEmpty()));
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleanerManager $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$3(LogCleanerManager $this, Tuple2 metricNameAndTags$1, java.util.Map tag) {
        $this.metricsGroup().removeMetric((String)metricNameAndTags$1._1(), tag);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$2(LogCleanerManager $this, Tuple2 metricNameAndTags) {
        CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)metricNameAndTags._2()).asScala().foreach((Function1 & Serializable)tag -> {
            LogCleanerManager.$anonfun$removeMetrics$3($this, metricNameAndTags, tag);
            return BoxedUnit.UNIT;
        });
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((IterableOnceOps)logDirs.map((Function1 & Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.inProgress = (scala.collection.mutable.HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (scala.collection.mutable.HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.gaugeMetricNameWithTag = new HashMap();
        logDirs.foreach((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$1(this, dir)));
        logDirs.foreach((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$7(this, dir)));
        this.dirtiestLogCleanableRatio = 0.0;
        this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$MaxDirtyPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleanerManager.$anonfun$new$14(this)));
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName(), () -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$15(this)));
    }
}

