/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.api;

import com.nimbusds.jose.jwk.RSAKey;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.security.JaasTestUtils;
import kafka.security.minikdc.MiniKdc;
import no.nav.security.mock.oauth2.MockOAuth2Server;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.token.KeyProvider;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallbackHandler;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\u0011\"\u0001!BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013\u0005s\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\b!\u0002\u0011\r\u0011\"\u0015R\u0011\u0019i\u0006\u0001)A\u0005%\"9a\f\u0001b\u0001\n#\n\u0006BB0\u0001A\u0003%!\u000bC\u0003a\u0001\u0011E\u0011\rC\u0003i\u0001\u0011E\u0011\u000eC\u0004s\u0001\t\u0007I\u0011A1\t\rM\u0004\u0001\u0015!\u0003c\u0011%!\b\u00011AA\u0002\u0013\u0005Q\u000fC\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\u0002\u0005%\u0001BCA\u000b\u0001\u0001\u0007\t\u0011)Q\u0005m\"Y\u0011q\u0003\u0001A\u0002\u0003\u0007I\u0011AA\r\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\t\u0017\u0005-\u0002\u00011A\u0001B\u0003&\u00111\u0004\u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\ty\u0005\u0001C!\u0003#Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002`\u0001!\t!!\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002^!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!!7\u0001\t\u0003\tY\u000eC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!\u0011\u0001\u0001\u0005\u0002\t\r!AG\"mS\u0016tGoT!vi\"Le\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u0012$\u0003\r\t\u0007/\u001b\u0006\u0003I\u0015\nQa[1gW\u0006T\u0011AJ\u0001\fS:$Xm\u001a:bi&|gn\u0001\u0001\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1F\u0003\u0002#Y)\tA%\u0003\u0002/W\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002+a%\u0011\u0011g\u000b\u0002\n'\u0006\u001cHnU3ukB\fa\u0001P5oSRtD#\u0001\u001b\u0011\u0005U\u0002Q\"A\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t\u0019\u0011J\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#A!\u0011\u0005\tsU\"A\"\u000b\u0005\u0011+\u0015\u0001B1vi\"T!AR$\u0002\u0011M,7-\u001e:jifT!\u0001S%\u0002\r\r|W.\\8o\u0015\t!#J\u0003\u0002L\u0019\u00061\u0011\r]1dQ\u0016T\u0011!T\u0001\u0004_J<\u0017BA(D\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002%B\u0019\u0011hU+\n\u0005QS$\u0001B*p[\u0016\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00025\u0006!!.\u0019<b\u0013\tavK\u0001\u0006Qe>\u0004XM\u001d;jKN\fQc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm]\u0001\u0016G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:!\u0003aY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\\\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011Q-W\u0001\u0005Y\u0006tw-\u0003\u0002hI\n11\u000b\u001e:j]\u001e\f\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\t!\u000eE\u0002la\nl\u0011\u0001\u001c\u0006\u0003[:\f\u0011\"[7nkR\f'\r\\3\u000b\u0005=T\u0014AC2pY2,7\r^5p]&\u0011\u0011\u000f\u001c\u0002\u0005\u0019&\u001cH/\u0001\u0005jgN,XM]%e\u0003%I7o];fe&#\u0007%A\bn_\u000e\\w*Q;uQN+'O^3s+\u00051\bcA<\u0002\u00045\t\u0001P\u0003\u0002zu\u00061q.Y;uQJR!a\u001f?\u0002\t5|7m\u001b\u0006\u0003\rvT!A`@\u0002\u00079\fgO\u0003\u0002\u0002\u0002\u0005\u0011an\\\u0005\u0004\u0003\u000bA(\u0001E'pG.|\u0015)\u001e;ieM+'O^3s\u0003MiwnY6P\u0003V$\bnU3sm\u0016\u0014x\fJ3r)\u0011\tY!!\u0005\u0011\u0007e\ni!C\u0002\u0002\u0010i\u0012A!\u00168ji\"A\u00111\u0003\b\u0002\u0002\u0003\u0007a/A\u0002yIE\n\u0001#\\8dW>\u000bU\u000f\u001e5TKJ4XM\u001d\u0011\u0002\u0015A\u0014\u0018N^1uK.+\u00170\u0006\u0002\u0002\u001cA!\u0011QDA\u0011\u001b\t\tyB\u0003\u0002G3&!\u00111EA\u0010\u0005)\u0001&/\u001b<bi\u0016\\U-_\u0001\u000faJLg/\u0019;f\u0017\u0016Lx\fJ3r)\u0011\tY!!\u000b\t\u0013\u0005M\u0011#!AA\u0002\u0005m\u0011a\u00039sSZ\fG/Z&fs\u0002\nQa]3u+B$B!a\u0003\u00022!9\u00111G\nA\u0002\u0005U\u0012\u0001\u0003;fgRLeNZ8\u0011\t\u0005]\u00121I\u0007\u0003\u0003sQ1AIA\u001e\u0015\u0011\ti$a\u0010\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\t'\u0002\u000b),h.\u001b;\n\t\u0005\u0015\u0013\u0011\b\u0002\t)\u0016\u001cH/\u00138g_\"\u001a1#!\u0013\u0011\t\u0005]\u00121J\u0005\u0005\u0003\u001b\nID\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003\u0017A3\u0001FA+!\u0011\t9$a\u0016\n\t\u0005e\u0013\u0011\b\u0002\n\u0003\u001a$XM]#bG\"\f1\u0003Z3gCVdGoT!vi\"\u001cuN\u001c4jON$\u0012!V\u0001 I\u00164\u0017-\u001e7u\u00072LWM\u001c;De\u0016$WM\u001c;jC2\u001c8i\u001c8gS\u001e\u001c\u0018a\u00063fM\u0006,H\u000e\u001e&xi\n+\u0017M]3s\u0007>tg-[4t\u0003i!Xm\u001d;CCNL7m\u00117jK:$8I]3eK:$\u0018.\u00197t)\u0011\tY!a\u001a\t\u000f\u0005%\u0004\u00041\u0001\u0002l\u0005iqM]8vaB\u0013x\u000e^8d_2\u0004B!!\u001c\u0002|9!\u0011qNA<!\r\t\tHO\u0007\u0003\u0003gR1!!\u001e(\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0010\u001e\u0002\rA\u0013X\rZ3g\u0013\r9\u0017Q\u0010\u0006\u0004\u0003sR\u0004f\u0002\r\u0002\u0002\u00065\u0015q\u0012\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*!\u0011qQA\u001e\u0003\u0019\u0001\u0018M]1ng&!\u00111RAC\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002\u0012\u0006y2\u0010Z5ta2\f\u0017PT1nKvtsM]8vaB\u0013x\u000e^8d_2l4\u0010M?)\u000fa\t)*!)\u0002$B!\u0011qSAO\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006\u0015\u0015\u0001\u00039s_ZLG-\u001a:\n\t\u0005}\u0015\u0011\u0014\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003K\u000b#!a*\u0002C\u001d,G\u000fV3ti\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\t\u001c7\u0002%Q,7\u000f\u001e\"bg&\u001c'j\u001e;CK\u0006\u0014XM\u001d\u000b\u0005\u0003\u0017\ti\u000bC\u0004\u0002je\u0001\r!a\u001b)\u000fe\t\t)!$\u0002\u0010\":\u0011$!&\u0002\"\u0006MFFAAS\u0003M!Xm\u001d;CCNL7MS<u\u0005\u0016\f'/\u001a:3)\u0011\tY!!/\t\u000f\u0005%$\u00041\u0001\u0002l!:!$!!\u0002\u000e\u0006=\u0005f\u0002\u000e\u0002\u0016\u0006\u0005\u0016q\u0018\u0017\u0003\u0003K\u000bq\u0005^3ti*;HOQ3be\u0016\u0014x+\u001b;i\u001b\u0006dgm\u001c:nK\u0012\f5o]3si&|gNR5mKR!\u00111BAc\u0011\u001d\tIg\u0007a\u0001\u0003WBsaGAe\u0003C\u000by\r\u0005\u0003\u00028\u0005-\u0017\u0002BAg\u0003s\u0011\u0001\u0002R5tC\ndW\rZ\u0011\u0003\u0003#\f\u0011oS!G\u0017\u0006k\u0013'O\u001a:ii\u0002c)Y5mkJ,\u0007%\u001b8!\u0007>t7/^7fe:+Go^8sWRC'/Z1e]%t\u0017\u000e^5bY&TXMU3t_V\u00148-Z:)S\u0001\u001a\u0017M\u001c\u0011dCV\u001cX\r\t5b]\u001e\u001c\be\u001c8!\u0003NLhnY&bM.\f7i\u001c8tk6,'OL2m_N,\u0007&\u000b\u0015\b7\u0005\u0005\u0015QRAHQ\u001dY\u0012QSAQ\u0003/d#!!*\u0002GQ,7\u000f\u001e&xi\n+\u0017M]3s/&$\b.R7qif\f5o]3si&|gNR5mKR!\u00111BAo\u0011\u001d\tI\u0007\ba\u0001\u0003WBs\u0001HAe\u0003C\u000by\rK\u0004\u001d\u0003\u0003\u000bi)a$)\u000fq\t)*!)\u0002f2\u0012\u0011QU\u0001&i\u0016\u001cHOS<u\u0005\u0016\f'/\u001a:XSRDW*[:tS:<\u0017i]:feRLwN\u001c$jY\u0016$B!a\u0003\u0002l\"9\u0011\u0011N\u000fA\u0002\u0005-\u0004fB\u000f\u0002J\u0006\u0005\u0016q\u001a\u0015\b;\u0005\u0005\u0015QRAHQ\u001di\u0012QSAQ\u0003gd#!!*\u00027Q,7\u000f^+ogV\u0004\bo\u001c:uK\u0012Tu\u000f\u001e*fiJLWM^3s)\u0011\tY!!?\t\u000f\u0005%d\u00041\u0001\u0002l!:a$!!\u0002\u000e\u0006=\u0005f\u0002\u0010\u0002\u0016\u0006\u0005\u0016q \u0017\u0003\u0003K\u000bacZ3oKJ\fG/\u001a)sSZ\fG/Z&fs\u001aKG.\u001a\u000b\u0003\u0005\u000b\u0001BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0004\u0005\u0017I\u0016AA5p\u0013\u0011\u0011yA!\u0003\u0003\t\u0019KG.\u001a")
public class ClientOAuthIntegrationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final String issuerId;
    private MockOAuth2Server mockOAuthServer;
    private PrivateKey privateKey;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, kafkaServerEntryName);
    }

    @Override
    public String jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$(this, adminClient, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public String kafkaClientSaslMechanism() {
        return "OAUTHBEARER";
    }

    public List<String> kafkaServerSaslMechanisms() {
        return new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
    }

    public String issuerId() {
        return this.issuerId;
    }

    public MockOAuth2Server mockOAuthServer() {
        return this.mockOAuthServer;
    }

    public void mockOAuthServer_$eq(MockOAuth2Server x$1) {
        this.mockOAuthServer = x$1;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public void privateKey_$eq(PrivateKey x$1) {
        this.privateKey = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.generateKeyPair();
        this.privateKey_$eq(keyPair.getPrivate());
        RSAKey rsaJWK = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey(this.privateKey()).keyID("foo").build();
        KeyProvider keyProvider = new KeyProvider(Collections.singletonList(rsaJWK));
        OAuth2TokenProvider tokenProvider = new OAuth2TokenProvider(keyProvider);
        OAuth2Config oauthConfig = new OAuth2Config(false, null, null, false, tokenProvider);
        this.mockOAuthServer_$eq(new MockOAuth2Server(oauthConfig));
        this.mockOAuthServer().start();
        String tokenEndpointUrl = this.mockOAuthServer().tokenEndpointUrl(this.issuerId()).url().toString();
        String jwksUrl = this.mockOAuthServer().jwksUrl(this.issuerId()).url().toString();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", tokenEndpointUrl + "," + jwksUrl);
        String listenerNamePrefix = "listener.name." + this.listenerName().value().toLowerCase();
        this.serverConfig().setProperty(listenerNamePrefix + ".oauthbearer.sasl.jaas.config", OAuthBearerLoginModule.class.getName() + " required ;");
        this.serverConfig().setProperty(listenerNamePrefix + ".oauthbearer.sasl.oauthbearer.expected.audience", this.issuerId());
        this.serverConfig().setProperty(listenerNamePrefix + ".oauthbearer.sasl.oauthbearer.jwks.endpoint.url", jwksUrl);
        this.serverConfig().setProperty(listenerNamePrefix + ".oauthbearer.sasl.server.callback.handler.class", OAuthBearerValidatorCallbackHandler.class.getName());
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), this.jaasSections$default$3()));
        this.superuserClientConfig().putAll((Map<?, ?>)this.defaultClientCredentialsConfigs());
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.mockOAuthServer() != null) {
            this.mockOAuthServer().shutdown();
        }
        this.closeSasl();
        super.tearDown();
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.files");
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
    }

    public Properties defaultOAuthConfigs() {
        String tokenEndpointUrl = this.mockOAuthServer().tokenEndpointUrl(this.issuerId()).url().toString();
        Properties configs = new Properties();
        configs.put("security.protocol", this.securityProtocol().name);
        configs.put("sasl.jaas.config", this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2()));
        configs.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        configs.put("sasl.oauthbearer.token.endpoint.url", tokenEndpointUrl);
        return configs;
    }

    public Properties defaultClientCredentialsConfigs() {
        Properties configs = this.defaultOAuthConfigs();
        configs.put("sasl.oauthbearer.client.credentials.client.id", "test-client");
        configs.put("sasl.oauthbearer.client.credentials.client.secret", "test-secret");
        return configs;
    }

    public Properties defaultJwtBearerConfigs() {
        Properties configs = this.defaultOAuthConfigs();
        configs.put("sasl.jaas.config", this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2()));
        configs.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        configs.put("sasl.oauthbearer.jwt.retriever.class", "org.apache.kafka.common.security.oauthbearer.JwtBearerJwtRetriever");
        return configs;
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testBasicClientCredentials(String groupProtocol) {
        Properties configs = this.defaultClientCredentialsConfigs();
        Assertions.assertDoesNotThrow(() -> {
            ByteArraySerializer x$2 = this.createProducer$default$1();
            ByteArraySerializer x$3 = this.createProducer$default$2();
            return this.createProducer(x$2, x$3, configs);
        });
        Assertions.assertDoesNotThrow(() -> {
            ByteArrayDeserializer x$5 = this.createConsumer$default$1();
            ByteArrayDeserializer x$6 = this.createConsumer$default$2();
            List<String> x$7 = this.createConsumer$default$4();
            return this.createConsumer(x$5, x$6, configs, x$7);
        });
        Assertions.assertDoesNotThrow(() -> {
            ListenerName x$9 = this.createAdminClient$default$1();
            return this.createAdminClient(x$9, configs);
        });
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testBasicJwtBearer(String groupProtocol) {
        File assertionFile = TestUtils.tempFile((String)this.mockOAuthServer().issueToken(this.issuerId(), "jdoe", "someaudience", Collections.singletonMap("scope", "test")).serialize());
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.files", assertionFile.getAbsolutePath());
        Properties configs = this.defaultJwtBearerConfigs();
        configs.put("sasl.oauthbearer.assertion.file", assertionFile.getAbsolutePath());
        Assertions.assertDoesNotThrow(() -> {
            ByteArraySerializer x$2 = this.createProducer$default$1();
            ByteArraySerializer x$3 = this.createProducer$default$2();
            return this.createProducer(x$2, x$3, configs);
        });
        Assertions.assertDoesNotThrow(() -> {
            ByteArrayDeserializer x$5 = this.createConsumer$default$1();
            ByteArrayDeserializer x$6 = this.createConsumer$default$2();
            List<String> x$7 = this.createConsumer$default$4();
            return this.createConsumer(x$5, x$6, configs, x$7);
        });
        Assertions.assertDoesNotThrow(() -> {
            ListenerName x$9 = this.createAdminClient$default$1();
            return this.createAdminClient(x$9, configs);
        });
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testBasicJwtBearer2(String groupProtocol) {
        File privateKeyFile = this.generatePrivateKeyFile();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.files", privateKeyFile.getAbsolutePath());
        Properties configs = this.defaultJwtBearerConfigs();
        configs.put("sasl.oauthbearer.assertion.private.key.file", privateKeyFile.getPath());
        configs.put("sasl.oauthbearer.assertion.claim.aud", "default");
        configs.put("sasl.oauthbearer.assertion.claim.sub", "kafka-client-test-sub");
        configs.put("sasl.oauthbearer.scope", "default");
        Assertions.assertDoesNotThrow(() -> {
            ByteArraySerializer x$2 = this.createProducer$default$1();
            ByteArraySerializer x$3 = this.createProducer$default$2();
            return this.createProducer(x$2, x$3, configs);
        });
        Assertions.assertDoesNotThrow(() -> {
            ByteArrayDeserializer x$5 = this.createConsumer$default$1();
            ByteArrayDeserializer x$6 = this.createConsumer$default$2();
            List<String> x$7 = this.createConsumer$default$4();
            return this.createConsumer(x$5, x$6, configs, x$7);
        });
        Assertions.assertDoesNotThrow(() -> {
            ListenerName x$9 = this.createAdminClient$default$1();
            return this.createAdminClient(x$9, configs);
        });
    }

    @Disabled(value="KAFKA-19394: Failure in ConsumerNetworkThread.initializeResources() can cause hangs on AsyncKafkaConsumer.close()")
    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testJwtBearerWithMalformedAssertionFile(String groupProtocol) {
        File assertionFile = TestUtils.tempFile((String)"CQEN*)Q#F)&)^#QNC");
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.files", assertionFile.getAbsolutePath());
        Properties configs = this.defaultJwtBearerConfigs();
        configs.put("sasl.oauthbearer.assertion.file", assertionFile.getAbsolutePath());
        Assertions.assertThrows(KafkaException.class, () -> {
            ByteArraySerializer x$2 = this.createProducer$default$1();
            ByteArraySerializer x$3 = this.createProducer$default$2();
            this.createProducer(x$2, x$3, configs);
        });
        Assertions.assertThrows(KafkaException.class, () -> {
            ByteArrayDeserializer x$5 = this.createConsumer$default$1();
            ByteArrayDeserializer x$6 = this.createConsumer$default$2();
            List<String> x$7 = this.createConsumer$default$4();
            this.createConsumer(x$5, x$6, configs, x$7);
        });
        Assertions.assertThrows(KafkaException.class, () -> {
            ListenerName x$9 = this.createAdminClient$default$1();
            this.createAdminClient(x$9, configs);
        });
    }

    @Disabled(value="KAFKA-19394: Failure in ConsumerNetworkThread.initializeResources() can cause hangs on AsyncKafkaConsumer.close()")
    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testJwtBearerWithEmptyAssertionFile(String groupProtocol) {
        File assertionFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.files", assertionFile.getAbsolutePath());
        Properties configs = this.defaultJwtBearerConfigs();
        configs.put("sasl.oauthbearer.assertion.file", assertionFile.getAbsolutePath());
        Assertions.assertThrows(KafkaException.class, () -> {
            ByteArraySerializer x$2 = this.createProducer$default$1();
            ByteArraySerializer x$3 = this.createProducer$default$2();
            this.createProducer(x$2, x$3, configs);
        });
        Assertions.assertThrows(KafkaException.class, () -> {
            ByteArrayDeserializer x$5 = this.createConsumer$default$1();
            ByteArrayDeserializer x$6 = this.createConsumer$default$2();
            List<String> x$7 = this.createConsumer$default$4();
            this.createConsumer(x$5, x$6, configs, x$7);
        });
        Assertions.assertThrows(KafkaException.class, () -> {
            ListenerName x$9 = this.createAdminClient$default$1();
            this.createAdminClient(x$9, configs);
        });
    }

    @Disabled(value="KAFKA-19394: Failure in ConsumerNetworkThread.initializeResources() can cause hangs on AsyncKafkaConsumer.close()")
    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testJwtBearerWithMissingAssertionFile(String groupProtocol) {
        String missingFileName = "/this/does/not/exist.txt";
        Properties configs = this.defaultJwtBearerConfigs();
        configs.put("sasl.oauthbearer.assertion.file", missingFileName);
        Assertions.assertThrows(KafkaException.class, () -> {
            ByteArraySerializer x$2 = this.createProducer$default$1();
            ByteArraySerializer x$3 = this.createProducer$default$2();
            this.createProducer(x$2, x$3, configs);
        });
        Assertions.assertThrows(KafkaException.class, () -> {
            ByteArrayDeserializer x$5 = this.createConsumer$default$1();
            ByteArrayDeserializer x$6 = this.createConsumer$default$2();
            List<String> x$7 = this.createConsumer$default$4();
            this.createConsumer(x$5, x$6, configs, x$7);
        });
        Assertions.assertThrows(KafkaException.class, () -> {
            ListenerName x$9 = this.createAdminClient$default$1();
            this.createAdminClient(x$9, configs);
        });
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testUnsupportedJwtRetriever(String groupProtocol) {
        String className = "org.apache.kafka.common.security.oauthbearer.ThisIsNotARealJwtRetriever";
        Properties configs = this.defaultOAuthConfigs();
        configs.put("sasl.oauthbearer.jwt.retriever.class", className);
        Assertions.assertThrows(ConfigException.class, () -> {
            ByteArraySerializer x$2 = this.createProducer$default$1();
            ByteArraySerializer x$3 = this.createProducer$default$2();
            this.createProducer(x$2, x$3, configs);
        });
        Assertions.assertThrows(ConfigException.class, () -> {
            ByteArrayDeserializer x$5 = this.createConsumer$default$1();
            ByteArrayDeserializer x$6 = this.createConsumer$default$2();
            List<String> x$7 = this.createConsumer$default$4();
            this.createConsumer(x$5, x$6, configs, x$7);
        });
        Assertions.assertThrows(ConfigException.class, () -> {
            ListenerName x$9 = this.createAdminClient$default$1();
            this.createAdminClient(x$9, configs);
        });
    }

    public File generatePrivateKeyFile() {
        File file = File.createTempFile("private-", ".key");
        byte[] bytes = Base64.getEncoder().encode(this.privateKey().getEncoded());
        try (AbstractInterruptibleChannel channel = null;){
            channel = FileChannel.open(file.toPath(), EnumSet.of(StandardOpenOption.WRITE), new FileAttribute[0]);
            Utils.writeFully((FileChannel)channel, (ByteBuffer)ByteBuffer.wrap(bytes));
        }
        return file;
    }

    public ClientOAuthIntegrationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 3;
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.issuerId = "default";
        Statics.releaseFence();
    }
}

