/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.EndToEndAuthorizationTest;
import kafka.security.JaasTestUtils;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.metadata.storage.Formatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001\u0002\u0013&\u0001)BQa\f\u0001\u0005\u0002ABqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u0019I\u0005\u0001)A\u0005\u007f!)!\n\u0001C)\u0017\"91\f\u0001b\u0001\n#b\u0006BB4\u0001A\u0003%Q\fC\u0004i\u0001\t\u0007I\u0011\u000b/\t\r%\u0004\u0001\u0015!\u0003^\u0011\u001dQ\u0007A1A\u0005B-Daa\u001c\u0001!\u0002\u0013a\u0007b\u00029\u0001\u0005\u0004%Ia\r\u0005\u0007c\u0002\u0001\u000b\u0011\u0002\u001b\t\u000fI\u0004!\u0019!C!W\"11\u000f\u0001Q\u0001\n1Dq\u0001\u001e\u0001C\u0002\u0013E1\u0007\u0003\u0004v\u0001\u0001\u0006I\u0001\u000e\u0005\bm\u0002\u0011\r\u0011\"\u0005x\u0011\u0019A\b\u0001)A\u0005C\")\u0011\u0010\u0001C\u0001u\"9\u0011q\u0001\u0001\u0005B\u0005%\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!!\u0014\u0001\t\u0003\nY\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011\u001d\ti\r\u0001C\u0001\u0003\u0003Bq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002P\u0002!\t!!7\t\u0013\u00055\b!%A\u0005\u0002\u0005=(\u0001\u000b#fY\u0016<\u0017\r^5p]R{7.\u001a8F]\u0012$v.\u00128e\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8UKN$(B\u0001\u0014(\u0003\r\t\u0007/\u001b\u0006\u0002Q\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001,!\taS&D\u0001&\u0013\tqSEA\rF]\u0012$v.\u00128e\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u00012!\ta\u0003!\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\nA\u0001\\1oO*\t\u0011(\u0001\u0003kCZ\f\u0017BA\u001e7\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003}\u00022\u0001Q$5\u001b\u0005\t%B\u0001\"D\u0003%IW.\\;uC\ndWM\u0003\u0002E\u000b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S!\u0003\t1K7\u000f^\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000fI\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012\u0001\u0014\t\u0003\u001bfk\u0011A\u0014\u0006\u0003\u001fB\u000bA!Y;uQ*\u0011\u0011KU\u0001\tg\u0016\u001cWO]5us*\u00111\u000bV\u0001\u0007G>lWn\u001c8\u000b\u0005!*&B\u0001,X\u0003\u0019\t\u0007/Y2iK*\t\u0001,A\u0002pe\u001eL!A\u0017(\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/F\u0001^!\rqv,Y\u0007\u0002\u000b&\u0011\u0001-\u0012\u0002\u0005'>lW\r\u0005\u0002cK6\t1M\u0003\u0002eq\u0005!Q\u000f^5m\u0013\t17M\u0001\u0006Qe>\u0004XM\u001d;jKN\fQc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm]\u0001\u0016G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:!\u0003=\u0019G.[3oiB\u0013\u0018N\\2ja\u0006dW#\u00017\u0011\u00055k\u0017B\u00018O\u00059Y\u0015MZ6b!JLgnY5qC2\f\u0001c\u00197jK:$\bK]5oG&\u0004\u0018\r\u001c\u0011\u0002\u001d\rd\u0017.\u001a8u!\u0006\u001c8o^8sI\u0006y1\r\\5f]R\u0004\u0016m]:x_J$\u0007%\u0001\blC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002\u001f-\fgm[1Qe&t7-\u001b9bY\u0002\nQb[1gW\u0006\u0004\u0016m]:x_J$\u0017AD6bM.\f\u0007+Y:to>\u0014H\rI\u0001\u001caJLg/\u001b7fO\u0016$\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0007>tg-[4\u0016\u0003\u0005\fA\u0004\u001d:jm&dWmZ3e\u0003\u0012l\u0017N\\\"mS\u0016tGoQ8oM&<\u0007%\u0001\u000fde\u0016\fG/\u001a#fY\u0016<\u0017\r^5p]R{7.\u001a8PaRLwN\\:\u0015\u0003m\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003\u0015\tG-\\5o\u0015\r\t\t\u0001V\u0001\bG2LWM\u001c;t\u0013\r\t)! \u0002\u001d\u0007J,\u0017\r^3EK2,w-\u0019;j_:$vn[3o\u001fB$\u0018n\u001c8t\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$B!a\u0003\u0002\u0012A\u0019a,!\u0004\n\u0007\u0005=QI\u0001\u0003V]&$\bbBA\n-\u0001\u0007\u0011QC\u0001\ti\u0016\u001cH/\u00138g_B!\u0011qCA\u0012\u001b\t\tIBC\u0002'\u00037QA!!\b\u0002 \u00059!.\u001e9ji\u0016\u0014(bAA\u0011/\u0006)!.\u001e8ji&!\u0011QEA\r\u0005!!Vm\u001d;J]\u001a|\u0017\u0001F1eI\u001a{'/\\1ui\u0016\u00148+\u001a;uS:<7\u000f\u0006\u0003\u0002\f\u0005-\u0002bBA\u0017/\u0001\u0007\u0011qF\u0001\nM>\u0014X.\u0019;uKJ\u0004B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0004ti>\u0014\u0018mZ3\u000b\u0007\u0005eB+\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\ti$a\r\u0003\u0013\u0019{'/\\1ui\u0016\u0014\u0018aG2sK\u0006$X\r\u0015:jm&dWmZ3e\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0002\u0002DA\u0019A0!\u0012\n\u0007\u0005\u001dSPA\u0003BI6Lg.\u0001\u0018de\u0016\fG/Z!eI&$\u0018n\u001c8bY\u000e\u0013X\rZ3oi&\fGn]!gi\u0016\u00148+\u001a:wKJ\u001c8\u000b^1si\u0016$GCAA\u0006\u0003\t\u001awN\u001c4jOV\u0014XmU3dkJLG/_!gi\u0016\u00148+\u001a:wKJ\u001c8\u000b^1si\u0006\tC/Z:u\u0007J,\u0017\r^3Vg\u0016\u0014x+\u001b;i\t\u0016dWmZ1uS>tGk\\6f]R!\u00111BA*\u0011\u001d\t)f\u0007a\u0001\u0003/\nQb\u001a:pkB\u0004&o\u001c;pG>d\u0007\u0003BA-\u0003OrA!a\u0017\u0002dA\u0019\u0011QL#\u000e\u0005\u0005}#bAA1S\u00051AH]8pizJ1!!\u001aF\u0003\u0019\u0001&/\u001a3fM&\u00191(!\u001b\u000b\u0007\u0005\u0015T\tK\u0004\u001c\u0003[\nI(a\u001f\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cRA!a\u001d\u0002\u001c\u00051\u0001/\u0019:b[NLA!a\u001e\u0002r\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003{\nqd\u001f3jgBd\u0017-\u001f(b[\u0016lhf\u001a:pkB\u0004&o\u001c;pG>dWh\u001f\u0019~Q\u001dY\u0012\u0011QAG\u0003\u001f\u0003B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000b\t(\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\tY)!\"\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\u0005E\u0015EAAJ\u0003\u0005:W\r\u001e+fgR<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117m\u0003\u0015\u0019X\r^+q)\u0011\tY!!'\t\u000f\u0005MA\u00041\u0001\u0002\u0016!\u001aA$!(\u0011\t\u0005]\u0011qT\u0005\u0005\u0003C\u000bIB\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001#Y:tKJ$Hk\\6f]>;h.\u001a:\u0015\r\u0005-\u0011qUAV\u0011\u0019\tI+\ba\u0001Y\u0006)qn\u001e8fe\"9\u0011QV\u000fA\u0002\u0005=\u0016!\u0002;pW\u0016t\u0007\u0003BAY\u0003sk!!a-\u000b\t\u0005U\u0016qW\u0001\u000bI\u0016dWmZ1uS>t'bAAW!&!\u00111XAZ\u0005=!U\r\\3hCRLwN\u001c+pW\u0016t\u0017\u0001F1tg\u0016\u0014H\u000fV8lK:\u0014V-];fgR,'\u000f\u0006\u0004\u0002\f\u0005\u0005\u0017Q\u0019\u0005\u0007\u0003\u0007t\u0002\u0019\u00017\u0002\u0013I,\u0017/^3ti\u0016\u0014\bbBAW=\u0001\u0007\u0011qV\u0001\fCN\u001cXM\u001d;U_.,g\u000e\u0006\u0003\u0002\f\u0005-\u0007bBAW?\u0001\u0007\u0011qV\u0001 GJ,\u0017\r^3U_.,gNU3rk\u0016\u001cH/\u001a:BI6Lgn\u00117jK:$\u0018AF2sK\u0006$X\rR3mK\u001e\fG/[8o)>\\WM\\:\u0015\u0005\u0005M\u0007c\u00020\u0002V\u0006=\u0016qV\u0005\u0004\u0003/,%A\u0002+va2,'\u0007\u0006\u0004\u0002T\u0006m\u00171\u001d\u0005\u0007s\n\u0002\r!!8\u0011\ty\u000byn_\u0005\u0004\u0003C,%!\u0003$v]\u000e$\u0018n\u001c81\u0011%\t)O\tI\u0001\u0002\u0004\t9/\u0001\u0004bgN,'\u000f\u001e\t\u0004=\u0006%\u0018bAAv\u000b\n9!i\\8mK\u0006t\u0017\u0001I2sK\u0006$X\rR3mK\u001e\fG/[8o)>\\WM\\:%I\u00164\u0017-\u001e7uII*\"!!=+\t\u0005\u001d\u00181_\u0016\u0003\u0003k\u0004B!a>\u0003\u00025\u0011\u0011\u0011 \u0006\u0005\u0003w\fi0A\u0005v]\u000eDWmY6fI*\u0019\u0011q`#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0004\u0005e(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class DelegationTokenEndToEndAuthorizationTest
extends EndToEndAuthorizationTest {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms = CollectionConverters$.MODULE$.CollectionHasAsScala(ScramMechanism.mechanismNames()).asScala().toList();
    private final Some<Properties> serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
    private final Some<Properties> clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    private final KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "scram-user");
    private final String clientPassword;
    private final KafkaPrincipal kafkaPrincipal = new KafkaPrincipal("User", "scram-admin");
    private final String kafkaPassword;
    private final Properties privilegedAdminClientConfig = new Properties();

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public KafkaPrincipal clientPrincipal() {
        return this.clientPrincipal;
    }

    private String clientPassword() {
        return this.clientPassword;
    }

    @Override
    public KafkaPrincipal kafkaPrincipal() {
        return this.kafkaPrincipal;
    }

    public String kafkaPassword() {
        return this.kafkaPassword;
    }

    public Properties privilegedAdminClientConfig() {
        return this.privilegedAdminClientConfig;
    }

    public CreateDelegationTokenOptions createDelegationTokenOptions() {
        return new CreateDelegationTokenOptions();
    }

    @Override
    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
        super.configureSecurityBeforeServersStart(testInfo);
    }

    @Override
    public void addFormatterSettings(Formatter formatter) {
        formatter.setClusterId("XcZZOzUqS4yHOjhMQB6JLQ");
        formatter.setScramArguments(java.util.List.of("SCRAM-SHA-256=[name=scram-admin,password=scram-admin-secret]"));
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), this.kafkaPassword());
    }

    public void createAdditionalCredentialsAfterServersStarted() {
    }

    @Override
    public void configureSecurityAfterServersStart() {
        super.configureSecurityAfterServersStart();
        this.createScramCredentialsViaPrivilegedAdminClient(this.clientPrincipal().getName(), this.clientPassword());
        this.waitForUserScramCredentialToAppearOnAllBrokers(this.clientPrincipal().getName(), this.kafkaClientSaslMechanism());
        this.createAdditionalCredentialsAfterServersStarted();
        Tuple2<DelegationToken, DelegationToken> tokens = this.createDelegationTokens();
        DelegationToken token = (DelegationToken)tokens._1();
        DelegationToken privilegedToken = (DelegationToken)tokens._2();
        this.privilegedAdminClientConfig().putAll((Map<?, ?>)this.adminClientConfig());
        String clientLoginContext = JaasTestUtils.tokenClientLoginModule(token.tokenInfo().tokenId(), token.hmacAsBase64String());
        this.producerConfig().put("sasl.jaas.config", clientLoginContext);
        this.consumerConfig().put("sasl.jaas.config", clientLoginContext);
        this.adminClientConfig().put("sasl.jaas.config", clientLoginContext);
        String privilegedClientLoginContext = JaasTestUtils.tokenClientLoginModule(privilegedToken.tokenInfo().tokenId(), privilegedToken.hmacAsBase64String());
        this.privilegedAdminClientConfig().put("sasl.jaas.config", privilegedClientLoginContext);
        this.superuserClientConfig().put("sasl.jaas.config", privilegedClientLoginContext);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testCreateUserWithDelegationToken(String groupProtocol) {
        try (Admin privilegedAdminClient = Admin.create((Properties)this.privilegedAdminClientConfig());){
            String user = "user";
            AlterUserScramCredentialsResult results = privilegedAdminClient.alterUserScramCredentials(java.util.List.of(new UserScramCredentialUpsertion(user, new ScramCredentialInfo(org.apache.kafka.clients.admin.ScramMechanism.SCRAM_SHA_256, 4096), "password")));
            Assertions.assertEquals((int)1, (int)results.values().size());
            ((KafkaFuture)results.values().get(user)).get();
        }
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), this.jaasSections$default$3()));
        super.setUp(testInfo);
        this.privilegedAdminClientConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
    }

    public void assertTokenOwner(KafkaPrincipal owner, DelegationToken token) {
        Assertions.assertEquals((Object)owner, (Object)token.tokenInfo().owner());
    }

    public void assertTokenRequester(KafkaPrincipal requester, DelegationToken token) {
        Assertions.assertEquals((Object)requester, (Object)token.tokenInfo().tokenRequester());
    }

    public void assertToken(DelegationToken token) {
        this.assertTokenOwner(this.clientPrincipal(), token);
        this.assertTokenRequester(this.clientPrincipal(), token);
    }

    public Admin createTokenRequesterAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.clientPrincipal().getName(), this.clientPassword());
    }

    public Tuple2<DelegationToken, DelegationToken> createDelegationTokens() {
        return this.createDelegationTokens((Function0<CreateDelegationTokenOptions>)(Function0 & Serializable)() -> this.createDelegationTokenOptions(), this.createDelegationTokens$default$2());
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<DelegationToken, DelegationToken> createDelegationTokens(Function0<CreateDelegationTokenOptions> createDelegationTokenOptions, boolean bl) {
        Tuple2 tuple2;
        try (Admin adminClient = this.createTokenRequesterAdminClient();
             Admin privilegedAdminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), this.kafkaPassword());){
            DelegationToken token = (DelegationToken)adminClient.createDelegationToken((CreateDelegationTokenOptions)createDelegationTokenOptions.apply()).delegationToken().get();
            if (bl) {
                this.assertToken(token);
            }
            DelegationToken privilegedToken = (DelegationToken)privilegedAdminClient.createDelegationToken().delegationToken().get();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DelegationTokenEndToEndAuthorizationTest.$anonfun$createDelegationTokens$2(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for token to propagate to all servers");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            tuple2 = new Tuple2((Object)token, (Object)privilegedToken);
        }
        return tuple2;
    }

    public boolean createDelegationTokens$default$2() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$createDelegationTokens$3(KafkaBroker server) {
        return server.tokenCache().tokens().size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$createDelegationTokens$2(DelegationTokenEndToEndAuthorizationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenEndToEndAuthorizationTest.$anonfun$createDelegationTokens$3(server)));
    }

    public static final /* synthetic */ String $anonfun$createDelegationTokens$4() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public DelegationTokenEndToEndAuthorizationTest() {
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.clientPassword = "scram-user-secret";
        this.kafkaPassword = "scram-admin-secret";
        this.serverConfig().setProperty("delegation.token.secret.key", "testKey");
        this.controllerConfig().setProperty("delegation.token.secret.key", "testKey");
    }
}

