/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.CommittedPartitionState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PendingShrinkIsr;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.ConfigRepository;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.metadata.MockConfigRepository;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpoints;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogLoader;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogReadInfo;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\tug\u0001\u0002\u001c8\u0001qBQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001C\u0002\u0013\u0005a\n\u0003\u0004S\u0001\u0001\u0006Ia\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0001O\u0011\u0019!\u0006\u0001)A\u0005\u001f\"9Q\u000b\u0001b\u0001\n\u0003q\u0005B\u0002,\u0001A\u0003%q\nC\u0004X\u0001\t\u0007I\u0011\u0001-\t\r\u0019\u0004\u0001\u0015!\u0003Z\u0011\u001d9\u0007A1A\u0005\u0002!Da!\u001d\u0001!\u0002\u0013I\u0007b\u0002:\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007g\u0002\u0001\u000b\u0011B5\t\u000fQ\u0004!\u0019!C\u0001k\"1Q\u0010\u0001Q\u0001\nYDqA \u0001C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\b\u0001\u0001\u000b\u0011BA\u0001\u0011!\tI\u0001\u0001b\u0001\n\u0003y\b\u0002CA\u0006\u0001\u0001\u0006I!!\u0001\t\u0017\u00055\u0001\u00011AA\u0002\u0013\u0005\u0011q\u0002\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0002C\u0006\u0002,\u0001\u0001\r\u0011!Q!\n\u0005E\u0001bCA\u0017\u0001\u0001\u0007\t\u0019!C\u0001\u0003_A1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002:!Y\u0011Q\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0019\u0011%\ty\u0004\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\"\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA+\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!a\u001e\u0001\t\u0003\ty\u0006C\u0004\u0002\u0002\u0002!\t!a\u0018\t\u000f\u0005-\u0005\u0001\"\u0001\u0002`!9\u0011q\u0012\u0001\u0005\u0002\u0005}\u0003bBAJ\u0001\u0011\u0005\u0011q\f\u0005\b\u0003/\u0003A\u0011BA0\u0011\u001d\tI\n\u0001C\u0005\u0003?Bq!a'\u0001\t\u0013\ti\nC\u0004\u0002V\u0002!I!a6\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u000e\u0001\u0011%!Q\u0004\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u00172aAa\u0016\u0001\t\te\u0003BCA\f[\t\u0005\t\u0015!\u0003\u0003\\!Q!QN\u0017\u0003\u0002\u0003\u0006IAa\u0004\t\u0015\t=TF!A!\u0002\u0013\u0011\t\b\u0003\u0006\u0003x5\u0012\t\u0011)A\u0005\u0005sB!B!\".\u0005\u0003\u0005\u000b\u0011\u0002BD\u0011%qXF!A!\u0002\u0013\t\t\u0001\u0003\u0004J[\u0011\u0005!Q\u0012\u0005\b\u0005?kC\u0011\tBQ\u0005E\u0001\u0016M\u001d;ji&|g\u000eT8dWR+7\u000f\u001e\u0006\u0003qe\nqa\u00197vgR,'OC\u0001;\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u001fD!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fMB\u0011AiR\u0007\u0002\u000b*\u0011a)O\u0001\u0006kRLGn]\u0005\u0003\u0011\u0016\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017B\u0011A\nA\u0007\u0002o\u0005\u0011b.^7SKBd\u0017nY1GKR\u001c\u0007.\u001a:t+\u0005y\u0005C\u0001 Q\u0013\t\tvHA\u0002J]R\f1C\\;n%\u0016\u0004H.[2b\r\u0016$8\r[3sg\u0002\nAB\\;n!J|G-^2feN\fQB\\;n!J|G-^2feN\u0004\u0013!\u00068v[J+7m\u001c:egB+'\u000f\u0015:pIV\u001cWM]\u0001\u0017]Vl'+Z2pe\u0012\u001c\b+\u001a:Qe>$WoY3sA\u0005AQn\\2l)&lW-F\u0001Z!\tQF-D\u0001\\\u0015\taV,\u0001\u0003vi&d'B\u00010`\u0003\u0019\u0019XM\u001d<fe*\u0011!\b\u0019\u0006\u0003C\n\fa!\u00199bG\",'\"A2\u0002\u0007=\u0014x-\u0003\u0002f7\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u00051A/\u001c9ESJ,\u0012!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\f!![8\u000b\u00039\fAA[1wC&\u0011\u0001o\u001b\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002mB\u0011qo_\u0007\u0002q*\u0011\u0011P_\u0001\u000bG>t7-\u001e:sK:$(B\u0001/n\u0013\ta\bPA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003A)\u00070Z2vi>\u00148+\u001a:wS\u000e,\u0007%A\bbaB,g\u000eZ*f[\u0006\u0004\bn\u001c:f+\t\t\t\u0001E\u0002x\u0003\u0007I1!!\u0002y\u0005%\u0019V-\\1qQ>\u0014X-\u0001\tbaB,g\u000eZ*f[\u0006\u0004\bn\u001c:fA\u0005\u00112\u000f\u001b:j].L5O]*f[\u0006\u0004\bn\u001c:f\u0003M\u0019\bN]5oW&\u001b(oU3nCBDwN]3!\u0003)awnZ'b]\u0006<WM]\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/I\u0014a\u00017pO&!\u00111DA\u000b\u0005)aunZ'b]\u0006<WM]\u0001\u000fY><W*\u00198bO\u0016\u0014x\fJ3r)\u0011\t\t#a\n\u0011\u0007y\n\u0019#C\u0002\u0002&}\u0012A!\u00168ji\"I\u0011\u0011F\u000b\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\u0004q\u0012\n\u0014a\u00037pO6\u000bg.Y4fe\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0005\u0005E\u0002c\u0001'\u00024%\u0019\u0011QG\u001c\u0003\u0013A\u000b'\u000f^5uS>t\u0017!\u00049beRLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005m\u0002\"CA\u00151\u0005\u0005\t\u0019AA\u0019\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tIeX\u0001\u0007G>lWn\u001c8\n\t\u00055\u0013q\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0002;pa&\u001c\u0017\nZ\u000b\u0003\u0003+\u0002B!!\u0012\u0002X%!\u0011\u0011LA$\u0005\u0011)V/\u001b3\u0002\u0011Q|\u0007/[2JI\u0002\nQa]3u+B$\"!!\t)\u0007y\t\u0019\u0007\u0005\u0003\u0002f\u0005MTBAA4\u0015\u0011\tI'a\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002n\u0005=\u0014a\u00026va&$XM\u001d\u0006\u0004\u0003c\u0012\u0017!\u00026v]&$\u0018\u0002BA;\u0003O\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0010\u0002|A!\u0011QMA?\u0013\u0011\ty(a\u001a\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\n;fgRtu\u000eT8dW\u000e{g\u000e^3oi&|gnV5uQ>,H/S:s+B$\u0017\r^3)\u0007\u0001\n)\t\u0005\u0003\u0002f\u0005\u001d\u0015\u0002BAE\u0003O\u0012A\u0001V3ti\u0006!D/Z:u\u0003B\u0004XM\u001c3SKBd\u0017nY1GKR\u001c\u0007nV5uQN\u001b\u0007.\u001a3vY\u0016\u00148\t[3dW\u001a{'o\u00155sS:\\\u0017j\u001d:)\u0007\u0005\n))A\u0012uKN$\u0018\t\u001d9f]\u0012\u0014V\r\u001d7jG\u00064U\r^2i/&$\b.\u00169eCR,\u0017j\u001d:)\u0007\t\n))\u0001\u0015uKN$x)\u001a;SKBd\u0017nY1XSRDW\u000b\u001d3bi\u0016\f5o]5h]6,g\u000e^!oI&\u001b(\u000fK\u0002$\u0003\u000b\u000baeY8oGV\u0014(/\u001a8u!J|G-^2f\r\u0016$8\r[,ji\"\u0014V-\u00193M_\u000e\\wJ\u001c7z\u0003\r\u001awN\\2veJ,g\u000e\u001e)s_\u0012,8-\u001a$fi\u000eDw+\u001b;i/JLG/\u001a'pG.\fqb]2iK\u0012,H.Z!qa\u0016tGm\u001d\u000b\u0003\u0003?\u0003b!!)\u00022\u0006]f\u0002BAR\u0003[sA!!*\u0002,6\u0011\u0011q\u0015\u0006\u0004\u0003S[\u0014A\u0002\u001fs_>$h(C\u0001A\u0013\r\tykP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019,!.\u0003\u0007M+\u0017OC\u0002\u00020~\u0002D!!/\u0002DB)q/a/\u0002@&\u0019\u0011Q\u0018=\u0003\r\u0019+H/\u001e:f!\u0011\t\t-a1\r\u0001\u0011Y\u0011Q\u0019\u0014\u0002\u0002\u0003\u0005)\u0011AAd\u0005\ryF%M\t\u0005\u0003\u0013\fy\rE\u0002?\u0003\u0017L1!!4@\u0005\u001dqu\u000e\u001e5j]\u001e\u00042APAi\u0013\r\t\u0019n\u0010\u0002\u0004\u0003:L\u0018aF:dQ\u0016$W\u000f\\3G_2dwn^3s\r\u0016$8\r[3t)\u0019\tI.!:\u0002jB1\u0011\u0011UAY\u00037\u0004D!!8\u0002bB)q/a/\u0002`B!\u0011\u0011YAq\t-\t\u0019oJA\u0001\u0002\u0003\u0015\t!a2\u0003\u0007}##\u0007\u0003\u0004\u0002h\u001e\u0002\raT\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u0004\u0002l\u001e\u0002\raT\u0001\u000b]Vl'+Z2pe\u0012\u001c\u0018!E:dQ\u0016$W\u000f\\3TQJLgn[%teR1\u0011\u0011_A~\u0005\u0017\u0001D!a=\u0002xB)q/a/\u0002vB!\u0011\u0011YA|\t-\tI\u0010KA\u0001\u0002\u0003\u0015\t!a2\u0003\u0007}#3\u0007C\u0004\u0002~\"\u0002\r!a@\u0002\u0015\u0005\u001cG/\u001b<f\r2\fw\r\u0005\u0003\u0003\u0002\t\u001dQB\u0001B\u0002\u0015\r\u0011)\u0001_\u0001\u0007CR|W.[2\n\t\t%!1\u0001\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u000f\t5\u0001\u00061\u0001\u0003\u0010\u0005yQn\\2l)&lWm\u00157fKBl5\u000fE\u0002?\u0005#I1Aa\u0005@\u0005\u0011auN\\4\u0002/M,G/\u001e9QCJ$\u0018\u000e^5p]^KG\u000f['pG.\u001cH\u0003BA\u0019\u00053Aq!!\u0004*\u0001\u0004\t\t\"A\nde\u0016\fG/\u001a'pOB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0003 \t\u001d\u0002\u0003\u0002B\u0011\u0005Gi\u0011A_\u0005\u0004\u0005KQ(A\u0003)s_B,'\u000f^5fg\"9!\u0011\u0006\u0016A\u0002\t-\u0012!C8wKJ\u0014\u0018\u000eZ3t!!\u0011iC!\u000e\u0003<\tmb\u0002\u0002B\u0018\u0005c\u00012!!*@\u0013\r\u0011\u0019dP\u0001\u0007!J,G-\u001a4\n\t\t]\"\u0011\b\u0002\u0004\u001b\u0006\u0004(b\u0001B\u001a\u007fA!!Q\u0006B\u001f\u0013\u0011\u0011yD!\u000f\u0003\rM#(/\u001b8h\u0003\u0019\t\u0007\u000f]3oIR1\u0011\u0011\u0005B#\u0005\u000fBq!!\f,\u0001\u0004\t\t\u0004\u0003\u0004\u0002l.\u0002\raT\u0001\u000eM\u0016$8\r\u001b$pY2|w/\u001a:\u0015\u0015\u0005\u0005\"Q\nB(\u0005'\u0012)\u0006C\u0004\u0002.1\u0002\r!!\r\t\r\tEC\u00061\u0001P\u0003)1w\u000e\u001c7po\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003Od\u0003\u0019A(\t\r\u0005-H\u00061\u0001P\u0005\u001d\u0019Fn\\<M_\u001e\u001c2!\fB.!\u0011\u0011iF!\u001b\u000e\u0005\t}#\u0002BA\f\u0005CRAAa\u0019\u0003f\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0005Oz\u0016aB:u_J\fw-Z\u0005\u0005\u0005W\u0012yF\u0001\u0006V]&4\u0017.\u001a3M_\u001e\fa\u0002\\8h'R\f'\u000f^(gMN,G/\u0001\u0005m_\u000e\fG\u000eT8h!\u0011\u0011iFa\u001d\n\t\tU$q\f\u0002\t\u0019>\u001c\u0017\r\u001c'pO\u0006\u0001B.Z1eKJ,\u0005o\\2i\u0007\u0006\u001c\u0007.\u001a\t\u0005\u0005w\u0012\t)\u0004\u0002\u0003~)!!q\u0010B1\u0003\u0015)\u0007o\\2i\u0013\u0011\u0011\u0019I! \u0003)1+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f\u0003Q\u0001(o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4feB!!Q\fBE\u0013\u0011\u0011YIa\u0018\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s)9\u0011yIa%\u0003\u0016\n]%\u0011\u0014BN\u0005;\u00032A!%.\u001b\u0005\u0001\u0001bBA\fi\u0001\u0007!1\f\u0005\b\u0005[\"\u0004\u0019\u0001B\b\u0011\u001d\u0011y\u0007\u000ea\u0001\u0005cBqAa\u001e5\u0001\u0004\u0011I\bC\u0004\u0003\u0006R\u0002\rAa\"\t\ry$\u0004\u0019AA\u0001\u00039\t\u0007\u000f]3oI\u0006\u001bH*Z1eKJ$BBa)\u0003*\ne&1\u0018Bc\u0005'\u0004BA!\u0018\u0003&&!!q\u0015B0\u00055aunZ!qa\u0016tG-\u00138g_\"9!1V\u001bA\u0002\t5\u0016a\u0002:fG>\u0014Hm\u001d\t\u0005\u0005_\u0013),\u0004\u0002\u00032*!!1WA$\u0003\u0019\u0011XmY8sI&!!q\u0017BY\u00055iU-\\8ssJ+7m\u001c:eg\"1\u0011q]\u001bA\u0002=CqA!06\u0001\u0004\u0011y,\u0001\u0004pe&<\u0017N\u001c\t\u0005\u0005;\u0012\t-\u0003\u0003\u0003D\n}#\u0001D!qa\u0016tGm\u0014:jO&t\u0007b\u0002Bdk\u0001\u0007!\u0011Z\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\t\u0005\u0005\u0017\u0014y-\u0004\u0002\u0003N*\u0019\u0011\u0011J/\n\t\tE'Q\u001a\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\u0005\b\u0005+,\u0004\u0019\u0001Bl\u0003E1XM]5gS\u000e\fG/[8o\u000fV\f'\u000f\u001a\t\u0005\u0005;\u0012I.\u0003\u0003\u0003\\\n}#!\u0005,fe&4\u0017nY1uS>tw)^1sI\u0002")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime = new MockTime();
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils.randomPartitionLogDir((File)this.tmpDir());
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
    private final Semaphore appendSemaphore = new Semaphore(0);
    private final Semaphore shrinkIsrSemaphore = new Semaphore(0);
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    private final Uuid topicId = Uuid.randomUuid();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    @BeforeEach
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        MockConfigRepository configRepository = MockConfigRepository.forTopic((String)this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), (Properties)this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), logConfig, (ConfigRepository)configRepository, new CleanerConfig(false), this.mockTime(), 4, false, (Option<UnifiedLog>)None$.MODULE$, false, 30000L));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"shrinkIsr not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(4), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava();
        java.util.List secondReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        Partition qual$1 = this.partition();
        LeaderAndIsrRequest.PartitionState x$1 = PartitionLockTest.partitionState$1(secondReplicaSet);
        None$ x$3 = None$.MODULE$;
        Option x$4 = qual$1.makeLeader$default$4();
        qual$1.makeLeader(x$1, offsetCheckpoints, (Option)x$3, x$4);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)("Expected replica " + replicaToCheck + " to be defined"));
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                Partition qual$2 = this.partition();
                LeaderAndIsrRequest.PartitionState x$5 = PartitionLockTest.partitionState$1(replicas);
                None$ x$7 = None$.MODULE$;
                Option x$8 = qual$2.makeLeader$default$4();
                qual$2.makeLeader(x$5, offsetCheckpoints, (Option)x$7, x$8);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)("Expected replica " + replicaToCheck + " to be defined"));
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)("Expected replica " + replicaToCheck + " to be defined"));
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleFollowerFetches(leaderEpoch, 1).foreach((Function1 & Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        int leaderEpoch = this.partition().getLeaderEpoch();
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleFollowerFetches(leaderEpoch, this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable)x$8 -> x$8.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$9 -> x$9.get(15L, TimeUnit.SECONDS));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleAppends() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable)x$10 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$10)));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleFollowerFetches(int leaderEpoch, int numRecords) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable)index -> PartitionLockTest.$anonfun$scheduleFollowerFetches$1(this, leaderEpoch, numRecords, BoxesRunTime.unboxToInt((Object)index)));
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        AlterPartitionListener isrChangeListener = (AlterPartitionListener)Mockito.mock(AlterPartitionListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty(), logManager.startup$default$2());
        Partition partition = new Partition(this, brokerId, isrChangeListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public PendingShrinkIsr prepareIsrShrink(CommittedPartitionState currentState, scala.collection.immutable.Set<Object> outOfSyncReplicaIds) {
                PendingShrinkIsr pendingShrinkIsr;
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    pendingShrinkIsr = super.prepareIsrShrink(currentState, outOfSyncReplicaIds);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
                return pendingShrinkIsr;
            }

            public UnifiedLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId, Option<Uuid> targetLogDirectoryId) {
                UnifiedLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                LeaderEpochFileCache leaderEpochCache = UnifiedLog.createLeaderEpochCache((File)log.dir(), (TopicPartition)log.topicPartition(), (LogDirFailureChannel)logDirFailureChannel, Optional.empty(), (Scheduler)this.$outer.mockTime().scheduler);
                int maxTransactionTimeout = 300000;
                ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(86400000, false);
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxTransactionTimeout, producerStateManagerConfig, (Time)this.$outer.mockTime());
                LoadedLogOffsets offsets = new LogLoader(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.$outer.mockTime().scheduler, (Time)this.$outer.mockTime(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap<K, V>(), false).load();
                LocalLog localLog = new LocalLog(log.dir(), log.config(), segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.$outer.mockTime().scheduler, (Time)this.$outer.mockTime(), log.topicPartition(), logDirFailureChannel);
                return new SlowLog(this.$outer, log, offsets.logStartOffset, localLog, leaderEpochCache, producerStateManager, this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), 30000L, brokerId$1, (Function0)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final long apply() {
                        return 1L;
                    }

                    public final long apply$mcJ$sp() {
                        return 1L;
                    }
                }, (Time)$outer.mockTime(), isrChangeListener$1, delayedOperations$1, metadataCache$1, logManager$1, alterIsrManager$1, (Option)None$.MODULE$);
            }
        };
        TopicIdPartition topicIdPartition = new TopicIdPartition(this.topicId(), this.kafka$cluster$PartitionLockTest$$topicPartition().partition());
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn(Optional.empty());
        Mockito.when((Object)alterIsrManager.submit((TopicIdPartition)ArgumentMatchers.eq((Object)topicIdPartition), (LeaderAndIsr)ArgumentMatchers.any())).thenReturn(new CompletableFuture());
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)new Some((Object)this.topicId()), partition.createLogIfNotExists$default$5());
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$1(brokerId, BoxesRunTime.unboxToInt((Object)i))).toList()).asJava();
        replicas.forEach(replicaId -> Mockito.when((Object)metadataCache.getAliveBrokerEpoch(Predef$.MODULE$.Integer2int(replicaId))).thenReturn(Optional.of(Predef$.MODULE$.long2Long(1L))));
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequest.PartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)new Some((Object)this.topicId()), partition.makeLeader$default$4()), (String)"Expected become leader transition to succeed");
        return partition;
    }

    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    private void append(Partition partition, int numRecords) {
        RequestLocal requestLocal = RequestLocal.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)x$11 -> PartitionLockTest.$anonfun$append$1(partition, requestLocal, BoxesRunTime.unboxToInt((Object)x$11)));
    }

    private void fetchFollower(Partition partition, int followerId, int leaderEpoch, int numRecords) {
        long logStartOffset = 0L;
        long fetchOffset = 0L;
        Optional<Object> lastFetchedEpoch = Optional.empty();
        int maxBytes = 1;
        while (fetchOffset < (long)numRecords) {
            FetchParams fetchParams = new FetchParams(followerId, 1L, 0L, 1, maxBytes, FetchIsolation.LOG_END, Optional.empty());
            FetchRequest.PartitionData fetchPartitionData = new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, logStartOffset, maxBytes, Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), lastFetchedEpoch);
            LogReadInfo logReadInfo = partition.fetchRecords(fetchParams, fetchPartitionData, this.mockTime().milliseconds(), maxBytes, true, true);
            Assertions.assertTrue((!logReadInfo.divergingEpoch.isPresent() ? 1 : 0) != 0);
            Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.fetchedData.records.batches()).asScala();
            if (!batches.nonEmpty()) continue;
            Assertions.assertEquals((int)1, (int)batches.size());
            RecordBatch batch = (RecordBatch)batches.head();
            lastFetchedEpoch = Optional.of(BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch()));
            fetchOffset = batch.lastOffset() + 1L;
        }
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequest.PartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequest.PartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$10) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleFollowerFetches$1(PartitionLockTest $this, int leaderEpoch$1, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.fetchFollower($this.partition(), index, leaderEpoch$1, numRecords$1);
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$append$1(Partition partition$1, RequestLocal requestLocal$1, int x$11) {
        MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), (byte)2, (Compression)Compression.NONE, -1L, (short)-1, -1, 0L, -1);
        return partition$1.appendRecordsToLeader(batch, AppendOrigin.CLIENT, 0, requestLocal$1, partition$1.appendRecordsToLeader$default$5());
    }

    public PartitionLockTest() {
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
    }

    private class SlowLog
    extends UnifiedLog {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, RequestLocal requestLocal, VerificationGuard verificationGuard) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, requestLocal, verificationGuard);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, UnifiedLog log, long logStartOffset, LocalLog localLog, LeaderEpochFileCache leaderEpochCache, ProducerStateManager producerStateManager, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(logStartOffset, localLog, new BrokerTopicStats(), log.producerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, Optional.empty(), false, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        }
    }
}

