/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogCleaner;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tee!B\u001a5\u0003\u0003I\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0003#\u0001\u0001\u0004\u0005\r\u0011\"\u0001F\u0011%!\u0006\u00011AA\u0002\u0013\u0005Q\u000bC\u0005\\\u0001\u0001\u0007\t\u0011)Q\u0005\r\"9A\f\u0001b\u0001\n\u0003i\u0006B\u00024\u0001A\u0003%a\fC\u0004h\u0001\t\u0007I\u0011\u00025\t\rQ\u0004\u0001\u0015!\u0003j\u0011\u001d)\bA1A\u0005\nYDaA\u001f\u0001!\u0002\u00139\bbB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011%\t\u0019\u0001\u0001b\u0001\n\u0013\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0004\u0011!\ty\u0001\u0001b\u0001\n\u00131\bbBA\t\u0001\u0001\u0006Ia\u001e\u0005\t\u0003'\u0001!\u0019!C\u0005m\"9\u0011Q\u0003\u0001!\u0002\u00139\b\"CA\f\u0001\t\u0007I\u0011BA\u0003\u0011!\tI\u0002\u0001Q\u0001\n\u0005\u001d\u0001bBA\u000e\u0001\u0019\u0005\u0011Q\u0004\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017B\u0011\"a\u001d\u0001#\u0003%\t!!\u001e\t\u0013\u0005-\u0005!%A\u0005\u0002\u00055\u0005\"CAI\u0001E\u0005I\u0011AAJ\u0011%\t9\nAI\u0001\n\u0003\tI\nC\u0005\u0002\u001e\u0002\t\n\u0011\"\u0001\u0002\u001a\"I\u0011q\u0014\u0001\u0012\u0002\u0013\u0005\u00111\u0013\u0005\b\u0003C\u0003A\u0011AAR\u0011%\ti\u000fAI\u0001\n\u0003\ti\tC\u0005\u0002p\u0002\t\n\u0011\"\u0001\u0002\u001a\"I\u0011\u0011\u001f\u0001\u0012\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003g\u0004\u0011\u0013!C\u0001\u00033C\u0011\"!>\u0001#\u0003%\t!a%\t\u0013\u0005]\b!%A\u0005\u0002\u0005e\u0005\"CA}\u0001E\u0005I\u0011AAM\u0011%\tY\u0010AI\u0001\n\u0003\t\u0019\nC\u0005\u0002~\u0002\t\n\u0011\"\u0001\u0002\u0000\"I!1\u0001\u0001\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\t\u0005\u000b\u0001\u0001\u0019!C\u0005m\"I!q\u0001\u0001A\u0002\u0013%!\u0011\u0002\u0005\b\u0005\u001b\u0001\u0001\u0015)\u0003x\u0011\u0019\u0011y\u0001\u0001C\u0001m\"9!\u0011\u0003\u0001\u0005\u0002\u0005E\u0002b\u0002B\n\u0001\u0011\u0005!Q\u0003\u0005\n\u0005;\u0002\u0011\u0013!C\u0001\u00033C\u0011Ba\u0018\u0001#\u0003%\tA!\u0019\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003h!9!Q\u0011\u0001\u0005\u0002\t\u001d%!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u001b7\u0003\rawn\u001a\u0006\u0002o\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001;!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0011\t\u0003\u0007\u0002i\u0011\u0001N\u0001\bG2,\u0017M\\3s+\u00051\u0005CA$S\u001b\u0005A%BA\u001bJ\u0015\tQ5*A\u0005j]R,'O\\1mg*\u0011A*T\u0001\bgR|'/Y4f\u0015\t9dJ\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<\u0017BA*I\u0005)aunZ\"mK\u0006tWM]\u0001\fG2,\u0017M\\3s?\u0012*\u0017\u000f\u0006\u0002W3B\u00111hV\u0005\u00031r\u0012A!\u00168ji\"9!lAA\u0001\u0002\u00041\u0015a\u0001=%c\u0005A1\r\\3b]\u0016\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u000b\u0002=B\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\u0003S>T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\n!a)\u001b7f\u0003\u001dawn\u001a#je\u0002\nA\u0001\\8hgV\t\u0011\u000eE\u0002k_Fl\u0011a\u001b\u0006\u0003Y6\fq!\\;uC\ndWM\u0003\u0002oy\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005A\\'A\u0003'jgR\u0014UO\u001a4feB\u0011qI]\u0005\u0003g\"\u0013!\"\u00168jM&,G\rT8h\u0003\u0015awnZ:!\u0003U!WMZ1vYRl\u0015\r_'fgN\fw-Z*ju\u0016,\u0012a\u001e\t\u0003waL!!\u001f\u001f\u0003\u0007%sG/\u0001\feK\u001a\fW\u000f\u001c;NCblUm]:bO\u0016\u001c\u0016N_3!\u0003u!WMZ1vYRl\u0015N\\\"mK\u0006t\u0017M\u00197f\t&\u0014H/\u001f*bi&|W#A?\u0011\u0005mr\u0018BA@=\u0005\u00151En\\1u\u0003y!WMZ1vYRl\u0015N\\\"mK\u0006t\u0017M\u00197f\t&\u0014H/\u001f*bi&|\u0007%A\reK\u001a\fW\u000f\u001c;NS:\u001cu.\u001c9bGRLwN\u001c'bO6\u001bVCAA\u0004!\rY\u0014\u0011B\u0005\u0004\u0003\u0017a$\u0001\u0002'p]\u001e\f!\u0004Z3gCVdG/T5o\u0007>l\u0007/Y2uS>tG*Y4N'\u0002\n!\u0003Z3gCVdG\u000fR3mKR,G)\u001a7bs\u0006\u0019B-\u001a4bk2$H)\u001a7fi\u0016$U\r\\1zA\u0005\u0011B-\u001a4bk2$8+Z4nK:$8+\u001b>f\u0003M!WMZ1vYR\u001cVmZ7f]R\u001c\u0016N_3!\u0003e!WMZ1vYRl\u0015\r_\"p[B\f7\r^5p]2\u000bw-T:\u00025\u0011,g-Y;mi6\u000b\u0007pQ8na\u0006\u001cG/[8o\u0019\u0006<Wj\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0003vi&d'bAA\u0015\u001b\u000611/\u001a:wKJLA!!\f\u0002$\tAQj\\2l)&lW-\u0001\u0005uK\u0006\u0014Hm\\<o)\u00051\u0006f\u0001\f\u00026A!\u0011qGA#\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012aA1qS*!\u0011qHA!\u0003\u001dQW\u000f]5uKJT1!a\u0011Q\u0003\u0015QWO\\5u\u0013\u0011\t9%!\u000f\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u00057pO\u000e{gNZ5h!J|\u0007/\u001a:uS\u0016\u001cH\u0003EA'\u0003/\nY&a\u0018\u0002d\u0005\u001d\u00141NA8!\u0011\ty%a\u0015\u000e\u0005\u0005E#bAA\u0013E&!\u0011QKA)\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\n\u00033:\u0002\u0013!a\u0001\u0003\u001b\n\u0011\u0003\u001d:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t\u0011\u0019\tif\u0006a\u0001o\u0006qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007\u0002CA1/A\u0005\t\u0019A?\u0002-5Lgn\u00117fC:\f'\r\\3ESJ$\u0018PU1uS>D\u0011\"!\u001a\u0018!\u0003\u0005\r!a\u0002\u0002%5LgnQ8na\u0006\u001cG/[8o\u0019\u0006<Wj\u001d\u0005\t\u0003S:\u0002\u0013!a\u0001o\u0006YA-\u001a7fi\u0016$U\r\\1z\u0011!\tig\u0006I\u0001\u0002\u00049\u0018aC:fO6,g\u000e^*ju\u0016D\u0011\"!\u001d\u0018!\u0003\u0005\r!a\u0002\u0002%5\f\u0007pQ8na\u0006\u001cG/[8o\u0019\u0006<Wj]\u0001\u001eY><7i\u001c8gS\u001e\u0004&o\u001c9feRLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000f\u0016\u0005\u0003\u001b\nIh\u000b\u0002\u0002|A!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015!C;oG\",7m[3e\u0015\r\t)\tP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAE\u0003\u007f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003uawnZ\"p]\u001aLw\r\u0015:pa\u0016\u0014H/[3tI\u0011,g-Y;mi\u0012\u001aTCAAHU\ri\u0018\u0011P\u0001\u001eY><7i\u001c8gS\u001e\u0004&o\u001c9feRLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0013\u0016\u0005\u0003\u000f\tI(A\u000fm_\u001e\u001cuN\u001c4jOB\u0013x\u000e]3si&,7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tYJK\u0002x\u0003s\nQ\u0004\\8h\u0007>tg-[4Qe>\u0004XM\u001d;jKN$C-\u001a4bk2$HEN\u0001\u001eY><7i\u001c8gS\u001e\u0004&o\u001c9feRLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0005YQ.Y6f\u00072,\u0017M\\3s)]1\u0015QUAg\u0003\u001f\f\u0019.a6\u0002Z\u0006m\u0017Q\\Ap\u0003C\fY\u000fC\u0004\u0002(z\u0001\r!!+\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0002,\u0006m\u0016\u0011\u0019\b\u0005\u0003[\u000b9L\u0004\u0003\u00020\u0006UVBAAY\u0015\r\t\u0019\fO\u0001\u0007yI|w\u000e\u001e \n\u0003uJ1!!/=\u0003\u001d\u0001\u0018mY6bO\u0016LA!!0\u0002@\nA\u0011\n^3sC\ndWMC\u0002\u0002:r\u0002B!a1\u0002J6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000fl\u0015AB2p[6|g.\u0003\u0003\u0002L\u0006\u0015'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0003Cr\u0002\u0013!a\u0001{\"A\u0011\u0011\u001b\u0010\u0011\u0002\u0003\u0007q/\u0001\u0006ok6$\u0006N]3bIND\u0011\"!6\u001f!\u0003\u0005\r!a\u0002\u0002\u0013\t\f7m[8gM6\u001b\b\u0002CA/=A\u0005\t\u0019A<\t\u0013\u0005\u0015d\u0004%AA\u0002\u0005\u001d\u0001\u0002CA5=A\u0005\t\u0019A<\t\u0011\u00055d\u0004%AA\u0002]D\u0011\"!\u001d\u001f!\u0003\u0005\r!a\u0002\t\u0013\u0005\rh\u0004%AA\u0002\u0005\u0015\u0018aE2mK\u0006tWM]%p\u0005V4g-\u001a:TSj,\u0007\u0003B\u001e\u0002h^L1!!;=\u0005\u0019y\u0005\u000f^5p]\"I\u0011\u0011\f\u0010\u0011\u0002\u0003\u0007\u0011QJ\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIM\nQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$C'A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012:\u0014!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H\u0005O\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:\u0003Yi\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIE\u0002TC\u0001B\u0001U\u0011\t)/!\u001f\u0002-5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cE\n1a\u0019;s\u0003\u001d\u0019GO]0%KF$2A\u0016B\u0006\u0011\u001dQ&&!AA\u0002]\fAa\u0019;sA\u000591m\\;oi\u0016\u0014\u0018AC5oG\u000e{WO\u001c;fe\u0006IqO]5uK\u0012+\bo\u001d\u000b\u000f\u0005/\u0011)D!\u000f\u0003>\t}\"q\nB*!\u0019\u0011IBa\u0007\u0003 5\tQ.C\u0002\u0003\u001e5\u00141aU3r!!Y$\u0011E<\u0003&\u0005\u001d\u0011b\u0001B\u0012y\t1A+\u001e9mKN\u0002BAa\n\u000309!!\u0011\u0006B\u0016!\r\ty\u000bP\u0005\u0004\u0005[a\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00032\tM\"AB*ue&twMC\u0002\u0003.qBaAa\u000e/\u0001\u00049\u0018a\u00028v[.+\u0017p\u001d\u0005\u0007\u0005wq\u0003\u0019A<\u0002\u000f9,X\u000eR;qg\")QG\fa\u0001c\"9!\u0011\t\u0018A\u0002\t\r\u0013!B2pI\u0016\u001c\u0007\u0003\u0002B#\u0005\u0017j!Aa\u0012\u000b\t\t%\u0013QY\u0001\tG>l\u0007O]3tg&!!Q\nB$\u0005-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\t\u0011\tEc\u0006%AA\u0002]\f\u0001b\u001d;beR\\U-\u001f\u0005\n\u0005+r\u0003\u0013!a\u0001\u0005/\n!\"\\1hS\u000e4\u0016\r\\;f!\rY$\u0011L\u0005\u0004\u00057b$\u0001\u0002\"zi\u0016\f1c\u001e:ji\u0016$U\u000f]:%I\u00164\u0017-\u001e7uIU\n1c\u001e:ji\u0016$U\u000f]:%I\u00164\u0017-\u001e7uIY*\"Aa\u0019+\t\t]\u0013\u0011P\u0001\u001cGJ,\u0017\r^3MCJ<WmU5oO2,W*Z:tC\u001e,7+\u001a;\u0015\u0011\t%$1\u0010B@\u0005\u0007\u0003ra\u000fB6\u0005K\u0011y'C\u0002\u0003nq\u0012a\u0001V;qY\u0016\u0014\u0004\u0003\u0002B9\u0005oj!Aa\u001d\u000b\t\tU\u0014QY\u0001\u0007e\u0016\u001cwN\u001d3\n\t\te$1\u000f\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\r\tu\u0014\u00071\u0001x\u0003\rYW-\u001f\u0005\b\u0005\u0003\u000b\u0004\u0019\u0001B,\u0003QiWm]:bO\u00164uN]7biZ+'o]5p]\"9!\u0011I\u0019A\u0002\t\r\u0013\u0001C2m_N,Gj\\4\u0015\u0007Y\u0013I\tC\u00036e\u0001\u0007\u0011\u000fK\u0004\u0001\u0005\u001b\u0013\u0019J!&\u0011\t\u0005]\"qR\u0005\u0005\u0005#\u000bIDA\u0002UC\u001e\fQA^1mk\u0016\f#Aa&\u0002\u0017%tG/Z4sCRLwN\u001c")
public abstract class AbstractLogCleanerIntegrationTest {
    private LogCleaner cleaner;
    private final File logDir = TestUtils.tempDirectory(null, null);
    private final ListBuffer<UnifiedLog> logs = ListBuffer$.MODULE$.empty();
    private final int defaultMaxMessageSize;
    private final float defaultMinCleanableDirtyRatio;
    private final long defaultMinCompactionLagMS;
    private final int defaultDeleteDelay;
    private final int defaultSegmentSize;
    private final long defaultMaxCompactionLagMs = Long.MAX_VALUE;
    private int ctr = 0;

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    private ListBuffer<UnifiedLog> logs() {
        return this.logs;
    }

    private int defaultMaxMessageSize() {
        return this.defaultMaxMessageSize;
    }

    private float defaultMinCleanableDirtyRatio() {
        return this.defaultMinCleanableDirtyRatio;
    }

    private long defaultMinCompactionLagMS() {
        return this.defaultMinCompactionLagMS;
    }

    private int defaultDeleteDelay() {
        return this.defaultDeleteDelay;
    }

    private int defaultSegmentSize() {
        return this.defaultSegmentSize;
    }

    private long defaultMaxCompactionLagMs() {
        return this.defaultMaxCompactionLagMs;
    }

    public abstract MockTime time();

    @AfterEach
    public void teardown() {
        if (this.cleaner() != null) {
            this.cleaner().shutdown();
        }
        this.time().scheduler.shutdown();
        this.logs().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    public Properties logConfigProperties(Properties propertyOverrides, int maxMessageSize, float minCleanableDirtyRatio, long minCompactionLagMs, int deleteDelay, int segmentSize, long maxCompactionLagMs) {
        Properties props = new Properties();
        props.put("max.message.bytes", Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        props.put("segment.index.bytes", Predef$.MODULE$.int2Integer(102400));
        props.put("file.delete.delay.ms", Predef$.MODULE$.int2Integer(deleteDelay));
        props.put("cleanup.policy", "compact");
        props.put("min.cleanable.dirty.ratio", Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        props.put("min.compaction.lag.ms", Predef$.MODULE$.long2Long(minCompactionLagMs));
        props.put("max.compaction.lag.ms", Predef$.MODULE$.long2Long(maxCompactionLagMs));
        new Implicits.PropertiesOps(props).$plus$plus$eq(propertyOverrides);
        return props;
    }

    public Properties logConfigProperties$default$1() {
        return new Properties();
    }

    public float logConfigProperties$default$3() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public long logConfigProperties$default$4() {
        return this.defaultMinCompactionLagMS();
    }

    public int logConfigProperties$default$5() {
        return this.defaultDeleteDelay();
    }

    public int logConfigProperties$default$6() {
        return this.defaultSegmentSize();
    }

    public long logConfigProperties$default$7() {
        return this.defaultMaxCompactionLagMs();
    }

    public LogCleaner makeCleaner(Iterable<TopicPartition> partitions, float minCleanableDirtyRatio, int numThreads, long backoffMs, int maxMessageSize, long minCompactionLagMs, int deleteDelay, int segmentSize, long maxCompactionLagMs, Option<Object> cleanerIoBufferSize, Properties propertyOverrides) {
        ConcurrentHashMap logMap = new ConcurrentHashMap();
        partitions.foreach((Function1 & Serializable)partition -> {
            File dir = new File(this.logDir(), partition.topic() + "-" + partition.partition());
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            LogConfig logConfig = new LogConfig((Map)this.logConfigProperties(propertyOverrides, maxMessageSize, minCleanableDirtyRatio, minCompactionLagMs, deleteDelay, segmentSize, maxCompactionLagMs));
            UnifiedLog log = UnifiedLog.create((File)dir, (LogConfig)logConfig, (long)0L, (long)0L, (Scheduler)$this.time().scheduler, (BrokerTopicStats)new BrokerTopicStats(), (Time)this.time(), (int)300000, (ProducerStateManagerConfig)new ProducerStateManagerConfig(86400000, false), (int)600000, (LogDirFailureChannel)new LogDirFailureChannel(10), (boolean)true, Optional.empty());
            logMap.put(partition, log);
            return (ListBuffer)this.logs().$plus$eq((Object)log);
        });
        CleanerConfig cleanerConfig = new CleanerConfig(numThreads, 0x400000L, 0.9, BoxesRunTime.unboxToInt((Object)cleanerIoBufferSize.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> maxMessageSize / 2)), maxMessageSize, Double.MAX_VALUE, backoffMs, true);
        return new LogCleaner(cleanerConfig, List.of(this.logDir()), logMap, new LogDirFailureChannel(1), (Time)this.time());
    }

    public float makeCleaner$default$2() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public long makeCleaner$default$4() {
        return 15000L;
    }

    public int makeCleaner$default$5() {
        return this.defaultMaxMessageSize();
    }

    public long makeCleaner$default$6() {
        return this.defaultMinCompactionLagMS();
    }

    public int makeCleaner$default$7() {
        return this.defaultDeleteDelay();
    }

    public int makeCleaner$default$8() {
        return this.defaultSegmentSize();
    }

    public long makeCleaner$default$9() {
        return this.defaultMaxCompactionLagMs();
    }

    public Option<Object> makeCleaner$default$10() {
        return None$.MODULE$;
    }

    public Properties makeCleaner$default$11() {
        return new Properties();
    }

    private int ctr() {
        return this.ctr;
    }

    private void ctr_$eq(int x$1) {
        this.ctr = x$1;
    }

    public int counter() {
        return this.ctr();
    }

    public void incCounter() {
        this.ctr_$eq(this.ctr() + 1);
    }

    public Seq<Tuple3<Object, String, Object>> writeDups(int numKeys, int numDups, UnifiedLog log, Compression codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$3 -> AbstractLogCleanerIntegrationTest.$anonfun$writeDups$1(this, startKey, numKeys, log, codec, magicValue, BoxesRunTime.unboxToInt((Object)x$3)));
    }

    public int writeDups$default$5() {
        return 0;
    }

    public byte writeDups$default$6() {
        return 2;
    }

    public Tuple2<String, MemoryRecords> createLargeSingleMessageSet(int key, byte messageFormatVersion, Compression codec) {
        String value = AbstractLogCleanerIntegrationTest.messageValue$1(128);
        byte[] x$1 = value.getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        long x$5 = -1L;
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec, x$5, messageFormatVersion);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    public void closeLog(UnifiedLog log) {
        log.close();
        this.logs().$minus$eq((Object)log);
    }

    public static final /* synthetic */ Tuple3 $anonfun$writeDups$2(AbstractLogCleanerIntegrationTest $this, UnifiedLog log$1, Compression codec$1, byte magicValue$1, int key) {
        String value = Integer.toString($this.counter());
        byte[] x$1 = value.getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        long x$5 = -1L;
        LogAppendInfo appendInfo = log$1.appendAsLeaderWithRecordVersion(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, x$5, magicValue$1), 0, RecordVersion.lookup((byte)magicValue$1));
        log$1.updateHighWatermark(log$1.logEndOffset());
        $this.incCounter();
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)appendInfo.firstOffset()));
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeDups$1(AbstractLogCleanerIntegrationTest $this, int startKey$1, int numKeys$1, UnifiedLog log$1, Compression codec$1, byte magicValue$1, int x$3) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable)key -> AbstractLogCleanerIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, magicValue$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    private static final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray((ClassTag)ClassTag$.MODULE$.Char()));
    }

    public AbstractLogCleanerIntegrationTest() {
        this.defaultMaxMessageSize = 128;
        this.defaultMinCleanableDirtyRatio = 0.0f;
        this.defaultMinCompactionLagMS = 0L;
        this.defaultDeleteDelay = 1000;
        this.defaultSegmentSize = 2048;
    }
}

