/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005B\u0015Bq\u0001\f\u0001C\u0002\u0013\u0005Q\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0011\r\u0011\"\u0001.\u0011\u0019A\u0004\u0001)A\u0005]!I\u0011\b\u0001a\u0001\u0002\u0004%\tA\u000f\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\u0002!C\u0011B\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B\u001e\t\u000b=\u0003A\u0011\t)\t\u000be\u0003A\u0011\t.\t\u000b-\u0004A\u0011\t7\t\u000bE\u0004A\u0011\u0001:\t\u000b}\u0004A\u0011\u00017\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!9\u00111\u0004\u0001\u0005\n\u0005u\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\n\u0003k\u0001\u0011\u0013!C\u0005\u0003o\u0011A\u0004R=oC6L7MT;n\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193t)\u0016\u001cHO\u0003\u0002\u0016-\u00059a.\u001a;x_J\\'\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0003;Y\taa]3sm\u0016\u0014\u0018BA\u0010\u001d\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0015\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u00121!\u00138u\u0003!Ig\u000e^3s]\u0006dW#\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001\u00027b]\u001eT\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t11\u000b\u001e:j]\u001e\f\u0011\"\u001b8uKJt\u0017\r\u001c\u0011\u0002\u0011\u0015DH/\u001a:oC2\f\u0011\"\u001a=uKJt\u0017\r\u001c\u0011\u0002\u000b\u0005$W.\u001b8\u0016\u0003m\u0002\"\u0001P#\u000e\u0003uR!!\u000f \u000b\u0005}\u0002\u0015aB2mS\u0016tGo\u001d\u0006\u0003/\u0005S!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011a)\u0010\u0002\u0006\u0003\u0012l\u0017N\\\u0001\nC\u0012l\u0017N\\0%KF$\"!\u0013'\u0011\u0005\u001dR\u0015BA&)\u0005\u0011)f.\u001b;\t\u000f5C\u0011\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\u0002\r\u0005$W.\u001b8!\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002J#\")!K\u0003a\u0001'\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005Q;V\"A+\u000b\u0005Y\u0013\u0014\u0001B;uS2L!\u0001W+\u0003\u0015A\u0013x\u000e]3si&,7/A\u0003tKR,\u0006\u000f\u0006\u0002J7\")Al\u0003a\u0001;\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002_K6\tqL\u0003\u0002aC\u0006\u0019\u0011\r]5\u000b\u0005\t\u001c\u0017a\u00026va&$XM\u001d\u0006\u0003I\u000e\u000bQA[;oSRL!AZ0\u0003\u0011Q+7\u000f^%oM>D#a\u00035\u0011\u0005yK\u0017B\u00016`\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\t\u0011\n\u000b\u0002\r]B\u0011al\\\u0005\u0003a~\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002)\u001d,GOT;n\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193t)\t13\u000fC\u0003u\u001b\u0001\u0007Q/\u0001\u0005mSN$XM\\3s!\t1XP\u0004\u0002xwB\u0011\u0001\u0010K\u0007\u0002s*\u0011!\u0010G\u0001\u0007yI|w\u000e\u001e \n\u0005qD\u0013A\u0002)sK\u0012,g-\u0003\u00026}*\u0011A\u0010K\u0001\u001di\u0016\u001cH\u000fR=oC6L7MT;n\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193tQ\rq\u00111\u0001\t\u0004=\u0006\u0015\u0011bAA\u0004?\n!A+Z:u\u0003I\u0011XmY8oM&<WO]3TKJ4XM]:\u0015\u000b%\u000bi!!\u0005\t\r\u0005=q\u00021\u0001T\u0003!qWm\u001e)s_B\u001c\bbBA\n\u001f\u0001\u0007\u0011QC\u0001\u000eCB\u0013x\u000e\u001d+p-\u0016\u0014\u0018NZ=\u0011\u000b\u001d\n9\"^;\n\u0007\u0005e\u0001F\u0001\u0004UkBdWMM\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$H#A\u001e\u0002+]\f\u0017\u000e\u001e$pe\u000e{gNZ5h\u001f:\u001cVM\u001d<feR9\u0011*a\t\u0002(\u0005-\u0002BBA\u0013#\u0001\u0007Q/\u0001\u0005qe>\u0004h*Y7f\u0011\u0019\tI#\u0005a\u0001k\u0006I\u0001O]8q-\u0006dW/\u001a\u0005\n\u0003[\t\u0002\u0013!a\u0001\u0003_\t\u0011\"\\1y/\u0006LG/T:\u0011\u0007\u001d\n\t$C\u0002\u00024!\u0012A\u0001T8oO\u0006yr/Y5u\r>\u00148i\u001c8gS\u001e|enU3sm\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e\"\u0006BA\u0018\u0003wY#!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fB\u0013AC1o]>$\u0018\r^5p]&!\u00111JA!\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DynamicNumNetworkThreadsTest
extends BaseRequestTest {
    private final String internal;
    private final String external;
    private Admin admin;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String internal() {
        return this.internal;
    }

    public String external() {
        return this.external;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("listeners", this.internal() + "://localhost:0, " + this.external() + "://localhost:0");
        properties.put("listener.security.protocol.map", this.internal() + ":PLAINTEXT, " + this.external() + ":PLAINTEXT");
        properties.put("listener.name." + this.internal().toLowerCase() + ".num.network.threads", "2");
        properties.put("num.network.threads", Integer.toString(3));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), new Properties()));
        Assertions.assertEquals((int)2, (int)this.getNumNetworkThreads(this.internal()));
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), "test", this.brokers(), this.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        Assertions.assertEquals((int)3, (int)this.getNumNetworkThreads(this.external()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    public int getNumNetworkThreads(String listener) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(((KafkaBroker)this.brokers().head()).metrics().metrics().keySet()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicNumNetworkThreadsTest.$anonfun$getNumNetworkThreads$1(x$2)))).count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DynamicNumNetworkThreadsTest.$anonfun$getNumNetworkThreads$2(listener, x$3)));
    }

    @Test
    public void testDynamicNumNetworkThreads() {
        int newBaseNetworkThreadsCount = 4;
        Properties props = new Properties();
        props.put("num.network.threads", Integer.toString(newBaseNetworkThreadsCount));
        this.reconfigureServers(props, (Tuple2<String, String>)new Tuple2((Object)"num.network.threads", (Object)Integer.toString(newBaseNetworkThreadsCount)));
        Assertions.assertEquals((int)2, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)newBaseNetworkThreadsCount, (int)this.getNumNetworkThreads(this.external()));
        int newInternalNetworkThreadsCount = 3;
        props = new Properties();
        props.put("listener.name." + this.internal().toLowerCase() + ".num.network.threads", Integer.toString(newInternalNetworkThreadsCount));
        this.reconfigureServers(props, (Tuple2<String, String>)new Tuple2((Object)("listener.name." + this.internal().toLowerCase() + ".num.network.threads"), (Object)Integer.toString(newInternalNetworkThreadsCount)));
        Assertions.assertEquals((int)newInternalNetworkThreadsCount, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)newBaseNetworkThreadsCount, (int)this.getNumNetworkThreads(this.external()));
    }

    private void reconfigureServers(Properties newProps, Tuple2<String, String> aPropToVerify) {
        Admin adminClient = this.createAdminClient();
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), adminClient, newProps, false, AlterConfigOp.OpType.SET).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), 10000L);
        adminClient.close();
    }

    private Admin createAdminClient() {
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.brokers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicNumNetworkThreadsTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var10_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    public static final /* synthetic */ boolean $anonfun$getNumNetworkThreads$1(MetricName x$2) {
        String string = x$2.name();
        String string2 = "request-rate";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$getNumNetworkThreads$2(String listener$1, MetricName x$3) {
        String string = listener$1;
        Object v = x$3.tags().get("listener");
        return !(string != null ? !string.equals(v) : v != null);
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicNumNetworkThreadsTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaBroker)$this.brokers().head()).config().originals().get(propName$1));
    }

    public DynamicNumNetworkThreadsTest() {
        this.internal = "PLAINTEXT";
        this.external = "EXTERNAL";
    }
}

