/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.minikdc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.loader.LdifSchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.Utils;
import org.apache.mina.core.service.IoAcceptor;

public class MiniKdc {
    static final String ORG_NAME = "org.name";
    static final String ORG_DOMAIN = "org.domain";
    static final String KDC_BIND_ADDRESS = "kdc.bind.address";
    static final String KDC_PORT = "kdc.port";
    static final String INSTANCE = "instance";
    static final String MAX_TICKET_LIFETIME = "max.ticket.lifetime";
    static final String MAX_RENEWABLE_LIFETIME = "max.renewable.lifetime";
    static final String TRANSPORT = "transport";
    static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    private static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    private static final String DEBUG = "debug";
    private final String orgName;
    private final String orgDomain;
    private final String realm;
    private final String host;
    private int port;
    private final Properties config;
    private final File workDir;
    private final File krb5conf;
    private DirectoryService ds;
    private KdcServer kdc;
    private boolean closed = false;

    public MiniKdc(Properties config, File workDir) {
        HashSet<String> requiredProperties = new HashSet<String>(List.of(ORG_NAME, ORG_DOMAIN, KDC_BIND_ADDRESS, KDC_PORT, INSTANCE, TRANSPORT, MAX_TICKET_LIFETIME, MAX_RENEWABLE_LIFETIME));
        if (!config.keySet().containsAll(requiredProperties)) {
            throw new IllegalArgumentException("Missing required properties: " + String.valueOf(requiredProperties));
        }
        this.config = config;
        this.workDir = workDir;
        this.orgName = config.getProperty(ORG_NAME);
        this.orgDomain = config.getProperty(ORG_DOMAIN);
        this.realm = this.orgName.toUpperCase(Locale.ENGLISH) + "." + this.orgDomain.toUpperCase(Locale.ENGLISH);
        this.krb5conf = new File(workDir, "krb5.conf");
        this.host = config.getProperty(KDC_BIND_ADDRESS);
        this.port = Integer.parseInt(config.getProperty(KDC_PORT));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Arguments: <WORKDIR> <MINIKDCPROPERTIES> <KEYTABFILE> [<PRINCIPALS>]+");
            Exit.exit((int)1);
        }
        String workDirPath = args[0];
        String configPath = args[1];
        String keytabPath = args[2];
        String[] principals = new String[args.length - 3];
        System.arraycopy(args, 3, principals, 0, principals.length);
        File workDir = new File(workDirPath);
        if (!workDir.exists()) {
            throw new RuntimeException("Specified work directory does not exist: " + workDir.getAbsolutePath());
        }
        Properties config = MiniKdc.createConfig();
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            throw new RuntimeException("Specified configuration does not exist: " + configFile.getAbsolutePath());
        }
        Properties userConfig = Utils.loadProps((String)configFile.getAbsolutePath());
        config.putAll((Map<?, ?>)userConfig);
        File keytabFile = new File(keytabPath).getAbsoluteFile();
        MiniKdc.start(workDir, config, keytabFile, List.of(principals));
    }

    public static Properties createConfig() {
        Properties properties = new Properties();
        properties.put(ORG_NAME, "EXAMPLE");
        properties.put(ORG_DOMAIN, "COM");
        properties.put(KDC_BIND_ADDRESS, "localhost");
        properties.put(KDC_PORT, "0");
        properties.put(INSTANCE, "DefaultKrbServer");
        properties.put(MAX_TICKET_LIFETIME, "86400000");
        properties.put(MAX_RENEWABLE_LIFETIME, "604800000");
        properties.put(TRANSPORT, "TCP");
        properties.put(DEBUG, "false");
        return properties;
    }

    public void start() throws Exception {
        if (this.kdc != null) {
            throw new IllegalStateException("KDC already started");
        }
        if (this.closed) {
            throw new IllegalStateException("KDC already closed");
        }
        this.initDirectoryService();
        this.initKdcServer();
        this.initJvmKerberosConfig();
    }

    public static MiniKdc start(File workDir, Properties config, File keytabFile, List<String> principals) throws Exception {
        MiniKdc miniKdc = new MiniKdc(config, workDir);
        miniKdc.start();
        miniKdc.createPrincipal(keytabFile, principals);
        String infoMessage = String.format("\nStandalone MiniKdc Running\n---------------------------------------------------\n  Realm           : %s\n  Running at      : %s:%d\n  krb5conf        : %s\n\n  created keytab  : %s\n  with principals : %s\n\nHit <CTRL-C> or kill <PID> to stop it\n---------------------------------------------------\n", miniKdc.getRealm(), miniKdc.getHost(), miniKdc.getPort(), miniKdc.getKrb5conf().getAbsolutePath(), keytabFile.getAbsolutePath(), String.join((CharSequence)", ", principals));
        System.out.println(infoMessage);
        Exit.addShutdownHook((String)"minikdc-shutdown-hook", miniKdc::stop);
        return miniKdc;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public File getKrb5conf() {
        return this.krb5conf;
    }

    public void stop() {
        if (!this.closed) {
            this.closed = true;
            if (this.kdc != null) {
                System.clearProperty(JAVA_SECURITY_KRB5_CONF);
                System.clearProperty(SUN_SECURITY_KRB5_DEBUG);
                for (Transport transport : this.kdc.getTransports()) {
                    IoAcceptor acceptor = transport.getAcceptor();
                    if (acceptor == null) continue;
                    acceptor.dispose(true);
                }
                this.kdc.stop();
                try {
                    this.ds.shutdown();
                }
                catch (Exception ex) {
                    System.err.println("Could not shutdown ApacheDS properly, exception: " + String.valueOf(ex));
                }
            }
        }
    }

    public void createPrincipal(File keytabFile, List<String> principals) throws IOException {
        String generatedPassword = UUID.randomUUID().toString();
        Keytab keytab = new Keytab();
        List entries = principals.stream().flatMap(principal -> {
            try {
                this.createPrincipal((String)principal, generatedPassword);
            }
            catch (IOException | LdapException e) {
                throw new RuntimeException(e);
            }
            String principalWithRealm = principal + "@" + this.realm;
            KerberosTime timestamp = new KerberosTime();
            return KerberosKeyFactory.getKerberosKeys((String)principalWithRealm, (String)generatedPassword).values().stream().map(encryptionKey -> {
                byte keyVersion = (byte)encryptionKey.getKeyVersion();
                return new KeytabEntry(principalWithRealm, 1, timestamp, keyVersion, encryptionKey);
            });
        }).toList();
        keytab.setEntries(entries);
        keytab.write(keytabFile);
    }

    private void initDirectoryService() throws Exception {
        this.ds = new DefaultDirectoryService();
        this.ds.setInstanceLayout(new InstanceLayout(this.workDir));
        this.ds.setCacheService(new CacheService());
        InstanceLayout instanceLayout = this.ds.getInstanceLayout();
        File schemaPartitionDirectory = new File(instanceLayout.getPartitionsDirectory(), "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(instanceLayout.getPartitionsDirectory());
        extractor.extractOrCopy();
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaPartitionDirectory);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        schemaManager.loadAllEnabled();
        this.ds.setSchemaManager((SchemaManager)schemaManager);
        LdifPartition schemaLdifPartition = new LdifPartition((SchemaManager)schemaManager, this.ds.getDnFactory());
        schemaLdifPartition.setPartitionPath(schemaPartitionDirectory.toURI());
        SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
        schemaPartition.setWrappedPartition((Partition)schemaLdifPartition);
        this.ds.setSchemaPartition(schemaPartition);
        JdbmPartition systemPartition = new JdbmPartition(this.ds.getSchemaManager(), this.ds.getDnFactory());
        systemPartition.setId("system");
        systemPartition.setPartitionPath(new File(this.ds.getInstanceLayout().getPartitionsDirectory(), systemPartition.getId()).toURI());
        systemPartition.setSuffixDn(new Dn(new String[]{"ou=system"}));
        systemPartition.setSchemaManager(this.ds.getSchemaManager());
        this.ds.setSystemPartition((Partition)systemPartition);
        this.ds.getChangeLog().setEnabled(false);
        this.ds.setDenormalizeOpAttrsEnabled(true);
        this.ds.addLast((Interceptor)new KeyDerivationInterceptor());
        String orgName = this.config.getProperty(ORG_NAME).toLowerCase(Locale.ENGLISH);
        String orgDomain = this.config.getProperty(ORG_DOMAIN).toLowerCase(Locale.ENGLISH);
        JdbmPartition partition = new JdbmPartition(this.ds.getSchemaManager(), this.ds.getDnFactory());
        partition.setId(orgName);
        partition.setPartitionPath(new File(this.ds.getInstanceLayout().getPartitionsDirectory(), orgName).toURI());
        Dn dn = new Dn(new String[]{"dc=" + orgName + ",dc=" + orgDomain});
        partition.setSuffixDn(dn);
        this.ds.addPartition((Partition)partition);
        HashSet<JdbmIndex> indexedAttributes = new HashSet<JdbmIndex>();
        indexedAttributes.add(new JdbmIndex("objectClass", false));
        indexedAttributes.add(new JdbmIndex("dc", false));
        indexedAttributes.add(new JdbmIndex("ou", false));
        partition.setIndexedAttributes(indexedAttributes);
        this.ds.setInstanceId(this.config.getProperty(INSTANCE));
        this.ds.setShutdownHookEnabled(false);
        this.ds.startup();
        Entry entry = this.ds.newEntry(dn);
        entry.add("objectClass", new String[]{"top", "domain"});
        entry.add("dc", new String[]{orgName});
        this.ds.getAdminSession().add(entry);
    }

    private void addInitialEntriesToDirectoryService(String bindAddress) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", this.orgName.toLowerCase(Locale.ENGLISH));
        map.put("1", this.orgDomain.toLowerCase(Locale.ENGLISH));
        map.put("2", this.orgName.toUpperCase(Locale.ENGLISH));
        map.put("3", this.orgDomain.toUpperCase(Locale.ENGLISH));
        map.put("4", bindAddress);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResourceAsStream("minikdc.ldiff")));){
            StringBuilder builder = new StringBuilder();
            reader.lines().forEach(line -> builder.append((String)line).append("\n"));
            this.addEntriesToDirectoryService(StrSubstitutor.replace((Object)builder, map));
        }
        catch (LdapException e) {
            throw new RuntimeException(e);
        }
    }

    private void initKdcServer() throws IOException, LdapInvalidDnException {
        String transport;
        String bindAddress = this.config.getProperty(KDC_BIND_ADDRESS);
        this.addInitialEntriesToDirectoryService(bindAddress);
        KerberosConfig kerberosConfig = new KerberosConfig();
        kerberosConfig.setMaximumRenewableLifetime(Long.parseLong(this.config.getProperty(MAX_RENEWABLE_LIFETIME)));
        kerberosConfig.setMaximumTicketLifetime(Long.parseLong(this.config.getProperty(MAX_TICKET_LIFETIME)));
        kerberosConfig.setSearchBaseDn("dc=" + this.orgName + ",dc=" + this.orgDomain);
        kerberosConfig.setPaEncTimestampRequired(false);
        this.kdc = new KdcServer(kerberosConfig);
        this.kdc.setDirectoryService(this.ds);
        TcpTransport absTransport = switch (transport = this.config.getProperty(TRANSPORT).trim()) {
            case "TCP" -> new TcpTransport(bindAddress, this.port, 3, 50);
            case "UDP" -> new UdpTransport(this.port);
            default -> throw new IllegalArgumentException("Invalid transport: " + transport);
        };
        this.kdc.addTransports(new Transport[]{absTransport});
        this.kdc.setServiceName(this.config.getProperty(INSTANCE));
        this.kdc.start();
        if (this.port == 0) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)absTransport.getAcceptor().getLocalAddress();
            this.port = inetSocketAddress.getPort();
        }
        System.out.println("MiniKdc listening at port: " + this.port);
    }

    private void initJvmKerberosConfig() throws IOException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        this.writeKrb5Conf();
        System.setProperty(JAVA_SECURITY_KRB5_CONF, this.krb5conf.getAbsolutePath());
        System.setProperty(SUN_SECURITY_KRB5_DEBUG, this.config.getProperty(DEBUG, "false"));
        System.out.println("MiniKdc setting JVM krb5.conf to: " + this.krb5conf.getAbsolutePath());
        this.refreshJvmKerberosConfig();
    }

    private void writeKrb5Conf() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResourceAsStream("minikdc-krb5.conf"), StandardCharsets.UTF_8));){
            reader.lines().forEach(line -> stringBuilder.append((String)line).append("{3}"));
        }
        String output = MessageFormat.format(stringBuilder.toString(), this.realm, this.host, String.valueOf(this.port), System.lineSeparator());
        Files.writeString(this.krb5conf.toPath(), (CharSequence)output, new OpenOption[0]);
    }

    private void refreshJvmKerberosConfig() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> klass = Java.isIbmJdk() && !Java.isIbmJdkSemeru() ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        klass.getMethod("refresh", new Class[0]).invoke(klass, new Object[0]);
    }

    private InputStream getResourceAsStream(String resourceName) throws IOException {
        ClassLoader cl = Optional.of(Thread.currentThread().getContextClassLoader()).orElse(MiniKdc.class.getClassLoader());
        InputStream resourceStream = cl.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new IOException("Can not read resource file " + resourceName);
        }
        return resourceStream;
    }

    private void createPrincipal(String principal, String password) throws LdapException, IOException {
        String ldifContent = "dn: uid=" + principal + ",ou=users,dc=" + this.orgName + ",dc=" + this.orgDomain + "\nobjectClass: top\nobjectClass: person\nobjectClass: organizationalPerson\nobjectClass: inetOrgPerson\nobjectClass: krb5principal\nobjectClass: krb5kdcentry\ncn: " + principal + "\nsn: " + principal + "\nuid: " + principal + "\nuserPassword: " + password + "\nkrb5PrincipalName: " + principal + "@" + this.realm + "\nkrb5KeyVersionNumber: 0\n";
        this.addEntriesToDirectoryService(ldifContent);
    }

    private void addEntriesToDirectoryService(String ldifContent) throws LdapException, IOException {
        try (LdifReader reader = new LdifReader((Reader)new StringReader(ldifContent));){
            reader.forEach(ldifEntry -> {
                try {
                    this.ds.getAdminSession().add((Entry)new DefaultEntry(this.ds.getSchemaManager(), ldifEntry.getEntry()));
                }
                catch (LdapException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

