/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.config.AbstractKafkaConfig;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.transaction.AddPartitionsToTxnManager;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r5c\u0001\u0002 @\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004]\u0001\u0001\u0006I!\u0015\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u0019)\u0007\u0001)A\u0005?\"9a\r\u0001b\u0001\n\u00139\u0007bBA\u0004\u0001\u0001\u0006I\u0001\u001b\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u0017A\u0001\"!\b\u0001A\u0003%\u0011Q\u0002\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0003C\u0006\u00022\u0001\u0001\r\u00111A\u0005\n\u0005M\u0002bCA \u0001\u0001\u0007\t\u0011)Q\u0005\u0003GA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005%\u0003\u0001)A\u0005\u0003\u000bB\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0014\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003\u001fB\u0011\"!\u001b\u0001\u0005\u0004%I!a\u001b\t\u0011\u0005M\u0004\u0001)A\u0005\u0003[B\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001b\t\u0011\u0005]\u0004\u0001)A\u0005\u0003[B\u0011\"!\u001f\u0001\u0005\u0004%I!a\u001b\t\u0011\u0005m\u0004\u0001)A\u0005\u0003[B\u0011\"! \u0001\u0005\u0004%I!a\u0011\t\u0011\u0005}\u0004\u0001)A\u0005\u0003\u000bB\u0011\"!!\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005\r\u0005\u0001)A\u0005\u0003\u000bB\u0011\"!\"\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005\u001d\u0005\u0001)A\u0005\u0003\u000bB\u0011\"!#\u0001\u0005\u0004%I!a#\t\u0011\u0005M\u0005\u0001)A\u0005\u0003\u001bC\u0011\"!&\u0001\u0005\u0004%I!a#\t\u0011\u0005]\u0005\u0001)A\u0005\u0003\u001bC\u0011\"!'\u0001\u0005\u0004%I!a#\t\u0011\u0005m\u0005\u0001)A\u0005\u0003\u001bC\u0011\"!(\u0001\u0005\u0004%I!a(\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u0003CC\u0011\"!+\u0001\u0005\u0004%I!a(\t\u0011\u0005-\u0006\u0001)A\u0005\u0003CC\u0011\"!,\u0001\u0005\u0004%I!a(\t\u0011\u0005=\u0006\u0001)A\u0005\u0003CC\u0011\"!-\u0001\u0005\u0004%I!a-\t\u0011\u0005\u0005\u0007\u0001)A\u0005\u0003kC\u0011\"a1\u0001\u0005\u0004%I!!2\t\u0011\u00055\u0007\u0001)A\u0005\u0003\u000fDq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002j\u0002!\t!!5\t\u000f\u0005M\b\u0001\"\u0003\u0002v\"9!\u0011\u0007\u0001\u0005\u0002\tM\u0002b\u0002B2\u0001\u0011\u0005!Q\r\u0005\b\u0005_\u0002A\u0011AAi\u0011\u001d\u0011I\b\u0001C\u0001\u0003#DqA! \u0001\t\u0003\t\t\u000eC\u0004\u0003\u0002\u0002!IAa!\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"I!Q\u001a\u0001\u0012\u0002\u0013%!q\u001a\u0005\n\u0005K\u0004\u0011\u0013!C\u0005\u0005OD\u0011Ba;\u0001#\u0003%IA!<\t\u000f\tE\b\u0001\"\u0003\u0003t\"I1Q\u0005\u0001\u0012\u0002\u0013%1q\u0005\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011\u001d\u0019\t\u0004\u0001C\u0005\u0007g\u0011Q$\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0001\u0006\u000baa]3sm\u0016\u0014(\"\u0001\"\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0005C\u0001(\u0001\u001b\u0005y\u0014!\u00048fi^|'o[\"mS\u0016tG/F\u0001R!\t\u0011&,D\u0001T\u0015\t!V+A\u0004dY&,g\u000e^:\u000b\u0005\t3&BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001eL!aW*\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039qW\r^<pe.\u001cE.[3oi\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",W#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t,\u0016\u0001C7fi\u0006$\u0017\r^1\n\u0005\u0011\f'!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0016\u0003!\u0004B!\u001b9s{6\t!N\u0003\u0002lY\u0006Aa-\u001e8di&|gN\u0003\u0002n]\u0006!Q\u000f^5m\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d6\u0003\u0011\u0019+hn\u0019;j_:\u0004\"a\u001d>\u000f\u0005QD\bCA;H\u001b\u00051(BA<D\u0003\u0019a$o\\8u}%\u0011\u0011pR\u0001\u0007!J,G-\u001a4\n\u0005md(AB*ue&twM\u0003\u0002z\u000fB\u0019a0a\u0001\u000e\u0003}T1!!\u0001o\u0003\u0011a\u0017M\\4\n\u0007\u0005\u0015qPA\u0004J]R,w-\u001a:\u0002\u001bA\f'\u000f^5uS>tgi\u001c:!\u0003\u0011!\u0018.\\3\u0016\u0005\u00055\u0001\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0006kRLGn\u001d\u0006\u0004\u0003/)\u0016AB2p[6|g.\u0003\u0003\u0002\u001c\u0005E!\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u00023\u0005$G\rU1si&$\u0018n\u001c8t)>$\u0006P\\'b]\u0006<WM]\u000b\u0003\u0003G\u0001B!!\n\u0002.5\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0006ue\u0006t7/Y2uS>t'B\u0001!V\u0013\u0011\ty#a\n\u00033\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\\'b]\u0006<WM]\u0001\u001eC\u0012$\u0007+\u0019:uSRLwN\\:U_RCh.T1oC\u001e,'o\u0018\u0013fcR!\u0011QGA\u001e!\r1\u0015qG\u0005\u0004\u0003s9%\u0001B+oSRD\u0011\"!\u0010\f\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'\u0001\u000ebI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)btW*\u00198bO\u0016\u0014\b%A\u0003u_BL7-\u0006\u0002\u0002FA\u0019a0a\u0012\n\u0005m|\u0018A\u0002;pa&\u001c\u0007%A\bu_BL7\rU1si&$\u0018n\u001c8t+\t\ty\u0005\u0005\u0004\u0002R\u0005m\u0013qL\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u00033:\u0015AC2pY2,7\r^5p]&!\u0011QLA*\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0005\u00141M\u0007\u0003\u0003+IA!!\u001a\u0002\u0016\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003\u0015qw\u000eZ31+\t\ti\u0007\u0005\u0003\u0002b\u0005=\u0014\u0002BA9\u0003+\u0011AAT8eK\u00061an\u001c3fa\u0001\nQA\\8eKF\naA\\8eKF\u0002\u0013!\u00028pI\u0016\u0014\u0014A\u00028pI\u0016\u0014\u0004%\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ec\u0005\tBO]1og\u0006\u001cG/[8oC2LE-\r\u0011\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0014!\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001333A\u0005\u0001BO]1og\u0006\u001cG/[8oC2LEmM\u0001\u0012iJ\fgn]1di&|g.\u00197JIN\u0002\u0013a\u00039s_\u0012,8-\u001a:JIF*\"!!$\u0011\u0007\u0019\u000by)C\u0002\u0002\u0012\u001e\u0013A\u0001T8oO\u0006a\u0001O]8ek\u000e,'/\u001332A\u0005Y\u0001O]8ek\u000e,'/\u001333\u00031\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u001a!\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u001a\u0002\u0019A\u0014x\u000eZ;dKJLEm\r\u0011\u00027\u0005,H\u000f[3oi&\u001c\u0017\r^5p]\u0016\u0013(o\u001c:SKN\u0004xN\\:f+\t\t\t\u000bE\u0002S\u0003GK1!!*T\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\fA$Y;uQ\u0016tG/[2bi&|g.\u0012:s_J\u0014Vm\u001d9p]N,\u0007%A\fwKJ\u001c\u0018n\u001c8NSNl\u0017\r^2i%\u0016\u001c\bo\u001c8tK\u0006Ab/\u001a:tS>tW*[:nCR\u001c\u0007NU3ta>t7/\u001a\u0011\u0002)\u0011L7oY8o]\u0016\u001cG/\u001a3SKN\u0004xN\\:f\u0003U!\u0017n]2p]:,7\r^3e%\u0016\u001c\bo\u001c8tK\u0002\nQ\u0004\u001e:b]N\f7\r^5p]N+\b\u000f]8si\u0016$w\n]3sCRLwN\\\u000b\u0003\u0003k\u0003B!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000b9#A\rBI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)btW*\u00198bO\u0016\u0014\u0018\u0002BA`\u0003s\u0013Q\u0004\u0016:b]N\f7\r^5p]N+\b\u000f]8si\u0016$w\n]3sCRLwN\\\u0001\u001fiJ\fgn]1di&|gnU;qa>\u0014H/\u001a3Pa\u0016\u0014\u0018\r^5p]\u0002\naaY8oM&<WCAAd!\rq\u0015\u0011Z\u0005\u0004\u0003\u0017|$aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%A\u0003tKR,\b\u000f\u0006\u0002\u00026!\u001aQ&!6\u0011\t\u0005]\u0017Q]\u0007\u0003\u00033TA!a7\u0002^\u0006\u0019\u0011\r]5\u000b\t\u0005}\u0017\u0011]\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\u0019\u000fW\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003O\fIN\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004]\u00055\b\u0003BAl\u0003_LA!!=\u0002Z\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\ng\u0016$XI\u001d:peN$B!a>\u0003\u0016A!\u0011\u0011 B\t\u001d\u0011\tYPa\u0004\u000f\t\u0005u(Q\u0002\b\u0005\u0003\u007f\u0014YA\u0004\u0003\u0003\u0002\t%a\u0002\u0002B\u0002\u0005\u000fq1!\u001eB\u0003\u0013\u0005I\u0016BA,Y\u0013\t\u0011e+\u0003\u0002A+&!\u0011\u0011FA\u0016\u0013\u0011\tY,a\n\n\t\tM\u0011\u0011\u0018\u0002\u000f\u0003B\u0004XM\u001c3DC2d'-Y2l\u0011\u001d\u00119b\fa\u0001\u00053\ta!\u001a:s_J\u001c\b\u0003\u0003B\u000e\u0005C\tyF!\n\u000e\u0005\tu!\u0002\u0002B\u0010\u0003/\nq!\\;uC\ndW-\u0003\u0003\u0003$\tu!aA'baB!!q\u0005B\u0017\u001b\t\u0011IC\u0003\u0003\u0003,\u0005U\u0011\u0001\u00039s_R|7m\u001c7\n\t\t=\"\u0011\u0006\u0002\u0007\u000bJ\u0014xN]:\u0002\u001dQ,7\u000f^!eIRCh\u000eR1uCR!\u0011Q\u0007B\u001b\u0011\u001d\u00119\u0004\ra\u0001\u0005s\ta\"[:BI\u0012\u0004\u0016M\u001d;ji&|g\u000eE\u0002G\u0005wI1A!\u0010H\u0005\u001d\u0011un\u001c7fC:D3\u0001\rB!!\u0011\u0011\u0019E!\u0013\u000e\u0005\t\u0015#\u0002\u0002B$\u0003;\fa\u0001]1sC6\u001c\u0018\u0002\u0002B&\u0005\u000b\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d\u0001$q\nB.\u0005;\u0002BA!\u0015\u0003X5\u0011!1\u000b\u0006\u0005\u0005+\u0012)%\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\u0011IFa\u0015\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"!q\fB13\u0005\t\u0011$\u0001\u0001\u0002)Q,7\u000f^$f]\u0016\u0014\u0018\r^3SKF,Xm\u001d;t)\u0011\t)Da\u001a\t\u000f\t]\u0012\u00071\u0001\u0003:!\u001a\u0011G!\u0011)\u000fE\u0012yEa\u0017\u0003n1\"!q\fB1\u0003\u0011\"Xm\u001d;Ue\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s%\u0016\u001cx\u000e\\;uS>t\u0007f\u0001\u001a\u0003tA!\u0011q\u001bB;\u0013\u0011\u00119(!7\u0003\tQ+7\u000f^\u0001+i\u0016\u001cH/\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]\"\u000bg\u000e\u001a7fe\u0016\u0013(o\u001c:IC:$G.\u001b8hQ\r\u0019$1O\u0001%i\u0016\u001cH/\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]6\u000bg.Y4fe6+GO]5dg\"\u001aAGa\u001d\u000295|7m\u001b+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0016$\u0018\rZ1uCRA\u0011Q\u0007BC\u0005\u001f\u0013\u0019\nC\u0004\u0003\bV\u0002\rA!#\u0002\u001dA\f'\u000f^5uS>t\u0017J\u001c3fqB\u0019aIa#\n\u0007\t5uIA\u0002J]RDqA!%6\u0001\u0004\u0011I)\u0001\u0005mK\u0006$WM]%e\u0011\u001d\u0011)*\u000ea\u0001\u0005/\u000b!\u0002\\3bI\u0016\u0014hj\u001c3f!\u00151%\u0011TA7\u0013\r\u0011Yj\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001d\rd\u0017.\u001a8u%\u0016\u001c\bo\u001c8tKRQ\u0011\u0011\u0015BQ\u0005c\u0013yL!3\t\u000f\t\rf\u00071\u0001\u0003&\u0006A!/Z:q_:\u001cX\r\u0005\u0003\u0003(\n5VB\u0001BU\u0015\u0011\u0011Y+!\u0006\u0002\u0011I,\u0017/^3tiNLAAa,\u0003*\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/\u001a\u0005\n\u0005g3\u0004\u0013!a\u0001\u0005k\u000bQ\"Y;uQ\u0016C8-\u001a9uS>t\u0007\u0003\u0002B\\\u0005wk!A!/\u000b\t\t]\u0011QC\u0005\u0005\u0005{\u0013ILA\fBkRDWM\u001c;jG\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\"I!\u0011\u0019\u001c\u0011\u0002\u0003\u0007!1Y\u0001\u0012[&\u001cX.\u0019;dQ\u0016C8-\u001a9uS>t\u0007\u0003\u0002B\\\u0005\u000bLAAa2\u0003:\nYRK\\:vaB|'\u000f^3e-\u0016\u00148/[8o\u000bb\u001cW\r\u001d;j_:D\u0011Ba37!\u0003\u0005\rA!\u000f\u0002\u0019\u0011L7oY8o]\u0016\u001cG/\u001a3\u00021\rd\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$#'\u0006\u0002\u0003R*\"!Q\u0017BjW\t\u0011)\u000e\u0005\u0003\u0003X\n\u0005XB\u0001Bm\u0015\u0011\u0011YN!8\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bp\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r(\u0011\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001G2mS\u0016tGOU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u001e\u0016\u0005\u0005\u0007\u0014\u0019.\u0001\rdY&,g\u000e\u001e*fgB|gn]3%I\u00164\u0017-\u001e7uIQ*\"Aa<+\t\te\"1[\u0001\u0010iJ\fgn]1di&|g\u000eR1uCRQ!Q_B\b\u0007'\u00199b!\t\u0011\t\t]8\u0011\u0002\b\u0005\u0005s\u001c\u0019A\u0004\u0003\u0003|\n}h\u0002BA\u0000\u0005{L1!a\u0006V\u0013\u0011\u0019\t!!\u0006\u0002\u000f5,7o]1hK&!1QAB\u0004\u0003u\tE\r\u001a)beRLG/[8ogR{G\u000b\u001f8SKF,Xm\u001d;ECR\f'\u0002BB\u0001\u0003+IAaa\u0003\u0004\u000e\ti\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o)J\fgn]1di&|gN\u0003\u0003\u0004\u0006\r\u001d\u0001BBB\tu\u0001\u0007!/A\bue\u0006t7/Y2uS>t\u0017\r\\%e\u0011\u001d\u0019)B\u000fa\u0001\u0003\u001b\u000b!\u0002\u001d:pIV\u001cWM]%e\u0011%\u0019IB\u000fI\u0001\u0002\u0004\u0019Y\"A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004\r\u000eu\u0011bAB\u0010\u000f\n)1\u000b[8si\"911\u0005\u001eA\u0002\te\u0012A\u0003<fe&4\u0017p\u00148ms\u0006IBO]1og\u0006\u001cG/[8o\t\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019IC\u000b\u0003\u0004\u001c\tM\u0017a\u0004:fG\u0016Lg/\u001a*fgB|gn]3\u0015\t\u0005U2q\u0006\u0005\b\u0005Gc\u0004\u0019AAQ\u000351XM]5gsJ+\u0017/^3tiRa\u0011QGB\u001b\u0007s\u0019Yd!\u0010\u0004@!91qG\u001fA\u0002\u00055\u0014aE3ya\u0016\u001cG/\u001a3EKN$\u0018N\\1uS>t\u0007BBB\t{\u0001\u0007!\u000fC\u0004\u0004\u0016u\u0002\r!!$\t\u000f\r\rR\b1\u0001\u0003:!91\u0011I\u001fA\u0002\r\r\u0013!\u0005:fcV,7\u000f^!oI\"\u000bg\u000e\u001a7feB!1QIB%\u001b\t\u00199EC\u0002n\u0003WIAaa\u0013\u0004H\tY\"+Z9vKN$\u0018I\u001c3D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ\u0004")
public class AddPartitionsToTxnManagerTest {
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final Function<String, Integer> partitionFor = (Function)Mockito.mock(Function.class);
    private final MockTime time = new MockTime();
    private AddPartitionsToTxnManager addPartitionsToTxnManager;
    private final String topic;
    private final List<TopicPartition> topicPartitions = new .colon.colon((Object)new TopicPartition(this.topic(), 1), (List)new .colon.colon((Object)new TopicPartition(this.topic(), 2), (List)new .colon.colon((Object)new TopicPartition(this.topic(), 3), (List)Nil$.MODULE$)));
    private final Node node0 = new Node(0, "host1", 0);
    private final Node node1 = new Node(1, "host2", 1);
    private final Node node2 = new Node(2, "host2", 2);
    private final String transactionalId1;
    private final String transactionalId2;
    private final String transactionalId3;
    private final long producerId1;
    private final long producerId2;
    private final long producerId3;
    private final ClientResponse authenticationErrorResponse;
    private final ClientResponse versionMismatchResponse;
    private final ClientResponse disconnectedResponse;
    private final AddPartitionsToTxnManager.TransactionSupportedOperation transactionSupportedOperation;
    private final KafkaConfig config;

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Function<String, Integer> partitionFor() {
        return this.partitionFor;
    }

    private MockTime time() {
        return this.time;
    }

    private AddPartitionsToTxnManager addPartitionsToTxnManager() {
        return this.addPartitionsToTxnManager;
    }

    private void addPartitionsToTxnManager_$eq(AddPartitionsToTxnManager x$1) {
        this.addPartitionsToTxnManager = x$1;
    }

    private String topic() {
        return this.topic;
    }

    private List<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    private Node node0() {
        return this.node0;
    }

    private Node node1() {
        return this.node1;
    }

    private Node node2() {
        return this.node2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private String transactionalId3() {
        return this.transactionalId3;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private long producerId3() {
        return this.producerId3;
    }

    private ClientResponse authenticationErrorResponse() {
        return this.authenticationErrorResponse;
    }

    private ClientResponse versionMismatchResponse() {
        return this.versionMismatchResponse;
    }

    private ClientResponse disconnectedResponse() {
        return this.disconnectedResponse;
    }

    private AddPartitionsToTxnManager.TransactionSupportedOperation transactionSupportedOperation() {
        return this.transactionSupportedOperation;
    }

    private KafkaConfig config() {
        return this.config;
    }

    @BeforeEach
    public void setup() {
        this.addPartitionsToTxnManager_$eq(new AddPartitionsToTxnManager((AbstractKafkaConfig)this.config(), this.networkClient(), this.metadataCache(), this.partitionFor(), (Time)this.time()));
    }

    @AfterEach
    public void teardown() {
        this.addPartitionsToTxnManager().shutdown();
    }

    private AddPartitionsToTxnManager.AppendCallback setErrors(scala.collection.mutable.Map<TopicPartition, Errors> errors) {
        return callbackErrors -> callbackErrors.forEach((tp, err) -> errors.put(tp, err));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAddTxnData(boolean isAddPartition) {
        AddPartitionsToTxnManager.TransactionSupportedOperation transactionSupportedOperation = isAddPartition ? AddPartitionsToTxnManager.TransactionSupportedOperation.ADD_PARTITION : AddPartitionsToTxnManager.TransactionSupportedOperation.GENERIC_ERROR_SUPPORTED;
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId1())).thenReturn((Object)Predef$.MODULE$.int2Integer(0));
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId2())).thenReturn((Object)Predef$.MODULE$.int2Integer(1));
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId3())).thenReturn((Object)Predef$.MODULE$.int2Integer(0));
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)new Some((Object)this.node0()));
        this.mockTransactionStateMetadata(1, 1, (Option<Node>)new Some((Object)this.node1()));
        scala.collection.mutable.Map transaction1Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction2Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction3Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1Errors), transactionSupportedOperation);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction2Errors), transactionSupportedOperation);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId3(), this.producerId3(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction3Errors), transactionSupportedOperation);
        scala.collection.mutable.Map transaction1RetryWithSameEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction1RetryWithNewerEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction1RetryWithOldEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithSameEpochErrors), transactionSupportedOperation);
        Assertions.assertEquals((Object)this.topicPartitions().map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), (Object)Errors.NETWORK_EXCEPTION)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)transaction1Errors);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)1, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithNewerEpochErrors), transactionSupportedOperation);
        scala.collection.immutable.Map expectedEpochErrors = this.topicPartitions().map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), (Object)Errors.INVALID_PRODUCER_EPOCH)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)expectedEpochErrors, (Object)transaction1RetryWithSameEpochErrors);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithOldEpochErrors), transactionSupportedOperation);
        Assertions.assertEquals((Object)expectedEpochErrors, (Object)transaction1RetryWithOldEpochErrors);
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.addPartitionsToTxnManager().generateRequests()).asScala().foreach((Function1 & Serializable)requestAndHandler -> {
            AddPartitionsToTxnManagerTest.$anonfun$testAddTxnData$3(this, isAddPartition, requestAndHandler);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGenerateRequests(boolean isAddPartition) {
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId1())).thenReturn((Object)Predef$.MODULE$.int2Integer(0));
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId2())).thenReturn((Object)Predef$.MODULE$.int2Integer(1));
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId3())).thenReturn((Object)Predef$.MODULE$.int2Integer(2));
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)new Some((Object)this.node0()));
        this.mockTransactionStateMetadata(1, 1, (Option<Node>)new Some((Object)this.node1()));
        this.mockTransactionStateMetadata(2, 2, (Option<Node>)new Some((Object)this.node2()));
        AddPartitionsToTxnManager.TransactionSupportedOperation transactionSupportedOperation = isAddPartition ? AddPartitionsToTxnManager.TransactionSupportedOperation.ADD_PARTITION : AddPartitionsToTxnManager.TransactionSupportedOperation.GENERIC_ERROR_SUPPORTED;
        scala.collection.mutable.Map transactionErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors), transactionSupportedOperation);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors), transactionSupportedOperation);
        Iterable requestsAndHandlers = CollectionConverters$.MODULE$.CollectionHasAsScala(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)2, (int)requestsAndHandlers.size());
        requestsAndHandlers.foreach((Function1 & Serializable)requestAndHandler -> {
            AddPartitionsToTxnManagerTest.$anonfun$testGenerateRequests$1(this, isAddPartition, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors), transactionSupportedOperation);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId3(), this.producerId3(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors), transactionSupportedOperation);
        this.time().sleep(10L);
        Iterable requestsAndHandlers2 = CollectionConverters$.MODULE$.CollectionHasAsScala(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requestsAndHandlers2.size());
        requestsAndHandlers2.foreach((Function1 & Serializable)requestAndHandler -> {
            this.verifyRequest(this.node2(), this.transactionalId3(), this.producerId3(), !isAddPartition, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        ((RequestAndCompletionHandler)((IterableOps)requestsAndHandlers.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testGenerateRequests$3$adapted(kafka.server.AddPartitionsToTxnManagerTest org.apache.kafka.server.util.RequestAndCompletionHandler ), (Lorg/apache/kafka/server/util/RequestAndCompletionHandler;)Ljava/lang/Object;)((AddPartitionsToTxnManagerTest)this))).head()).handler.onComplete(this.authenticationErrorResponse());
        Iterable requestsAndHandlers3 = CollectionConverters$.MODULE$.CollectionHasAsScala(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requestsAndHandlers3.size());
        requestsAndHandlers3.foreach((Function1 & Serializable)requestAndHandler -> {
            this.verifyRequest(this.node1(), this.transactionalId2(), this.producerId2(), !isAddPartition, requestAndHandler);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTransactionCoordinatorResolution() {
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId1())).thenReturn((Object)Predef$.MODULE$.int2Integer(0));
        Mockito.when((Object)this.metadataCache().getLeaderAndIsr("__transaction_state", 0)).thenReturn(Optional.empty());
        this.checkError$1();
        this.mockTransactionStateMetadata(0, -1, (Option<Node>)Option$.MODULE$.empty());
        this.checkError$1();
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)Option$.MODULE$.empty());
        this.checkError$1();
    }

    @Test
    public void testAddPartitionsToTxnHandlerErrorHandling() {
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId1())).thenReturn((Object)Predef$.MODULE$.int2Integer(0));
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId2())).thenReturn((Object)Predef$.MODULE$.int2Integer(0));
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)new Some((Object)this.node0()));
        scala.collection.mutable.Map transaction1Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction2Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Map expectedAuthErrors = this.topicPartitions().map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)Errors.SASL_AUTHENTICATION_FAILED)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.authenticationErrorResponse());
        Assertions.assertEquals((Object)expectedAuthErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedAuthErrors, (Object)transaction2Errors);
        HashMap expectedVersionMismatchErrors = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.versionMismatchResponse());
        Assertions.assertEquals((Object)expectedVersionMismatchErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedVersionMismatchErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map expectedDisconnectedErrors = this.topicPartitions().map((Function1 & Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)Errors.NETWORK_EXCEPTION)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.disconnectedResponse());
        Assertions.assertEquals((Object)expectedDisconnectedErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedDisconnectedErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map expectedTopLevelErrors = this.topicPartitions().map((Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$7), (Object)Errors.INVALID_TXN_STATE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AddPartitionsToTxnResponse topLevelErrorAddPartitionsResponse = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        boolean clientResponse_disconnected = false;
        ClientResponse topLevelErrorResponse = new ClientResponse(null, null, null, 0L, 0L, clientResponse_disconnected, null, null, (AbstractResponse)topLevelErrorAddPartitionsResponse);
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(topLevelErrorResponse);
        Assertions.assertEquals((Object)expectedTopLevelErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTopLevelErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map preConvertedTransaction1Errors = this.topicPartitions().map((Function1 & Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$8), (Object)Errors.PRODUCER_FENCED)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map expectedTransaction1Errors = this.topicPartitions().map((Function1 & Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$9), (Object)Errors.INVALID_PRODUCER_EPOCH)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map preConvertedTransaction2Errors = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.INVALID_TXN_STATE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Errors.NONE)}));
        scala.collection.immutable.Map expectedTransaction2Errors = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.INVALID_TXN_STATE)}));
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transaction1ErrorResponse = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId1(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)preConvertedTransaction1Errors).asJava());
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transaction2ErrorResponse = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId2(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)preConvertedTransaction2Errors).asJava());
        AddPartitionsToTxnResponse mixedErrorsAddPartitionsResponse = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setResultsByTransaction(new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)transaction1ErrorResponse, (List)new .colon.colon((Object)transaction2ErrorResponse, (List)Nil$.MODULE$)).iterator()).asJava())));
        boolean clientResponse_disconnected2 = false;
        ClientResponse mixedErrorsResponse = new ClientResponse(null, null, null, 0L, 0L, clientResponse_disconnected2, null, null, (AbstractResponse)mixedErrorsAddPartitionsResponse);
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(mixedErrorsResponse);
        Assertions.assertEquals((Object)expectedTransaction1Errors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTransaction2Errors, (Object)transaction2Errors);
        scala.collection.immutable.Map preConvertedTransactionAbortableErrorsTxn1 = this.topicPartitions().map((Function1 & Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$10), (Object)Errors.TRANSACTION_ABORTABLE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map preConvertedTransactionAbortableErrorsTxn2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.TRANSACTION_ABORTABLE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Errors.NONE)}));
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transactionAbortableErrorResponseTxn1 = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId1(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)preConvertedTransactionAbortableErrorsTxn1).asJava());
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transactionAbortableErrorResponseTxn2 = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId2(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)preConvertedTransactionAbortableErrorsTxn2).asJava());
        AddPartitionsToTxnResponse mixedErrorsAddPartitionsResponseAbortableError = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setResultsByTransaction(new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)transactionAbortableErrorResponseTxn1, (List)new .colon.colon((Object)transactionAbortableErrorResponseTxn2, (List)Nil$.MODULE$)).iterator()).asJava())));
        boolean clientResponse_disconnected3 = false;
        ClientResponse mixedAbortableErrorsResponse = new ClientResponse(null, null, null, 0L, 0L, clientResponse_disconnected3, null, null, (AbstractResponse)mixedErrorsAddPartitionsResponseAbortableError);
        scala.collection.immutable.Map expectedTransactionAbortableErrorsTxn1LowerVersion = this.topicPartitions().map((Function1 & Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$11), (Object)Errors.INVALID_TXN_STATE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map expectedTransactionAbortableErrorsTxn2LowerVersion = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.INVALID_TXN_STATE)}));
        scala.collection.immutable.Map expectedTransactionAbortableErrorsTxn1HigherVersion = this.topicPartitions().map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$12), (Object)Errors.TRANSACTION_ABORTABLE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map expectedTransactionAbortableErrorsTxn2HigherVersion = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.TRANSACTION_ABORTABLE)}));
        this.addTransactionsToVerifyRequestVersion$1(AddPartitionsToTxnManager.TransactionSupportedOperation.DEFAULT_ERROR, transaction1Errors, transaction2Errors);
        this.receiveResponse(mixedAbortableErrorsResponse);
        Assertions.assertEquals((Object)expectedTransactionAbortableErrorsTxn1LowerVersion, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTransactionAbortableErrorsTxn2LowerVersion, (Object)transaction2Errors);
        this.addTransactionsToVerifyRequestVersion$1(AddPartitionsToTxnManager.TransactionSupportedOperation.GENERIC_ERROR_SUPPORTED, transaction1Errors, transaction2Errors);
        this.receiveResponse(mixedAbortableErrorsResponse);
        Assertions.assertEquals((Object)expectedTransactionAbortableErrorsTxn1HigherVersion, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTransactionAbortableErrorsTxn2HigherVersion, (Object)transaction2Errors);
    }

    @Test
    public void testAddPartitionsToTxnManagerMetrics() {
        long startTime = this.time().milliseconds();
        scala.collection.mutable.Map transactionErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        LongRef maxVerificationTime = LongRef.create((long)0L);
        Meter mockVerificationFailureMeter = (Meter)Mockito.mock(Meter.class);
        Histogram mockVerificationTime = (Histogram)Mockito.mock(Histogram.class);
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId1())).thenReturn((Object)Predef$.MODULE$.int2Integer(0));
        Mockito.when((Object)this.partitionFor().apply(this.transactionalId2())).thenReturn((Object)Predef$.MODULE$.int2Integer(1));
        this.mockTransactionStateMetadata(0, 0, (Option<Node>)new Some((Object)this.node0()));
        this.mockTransactionStateMetadata(1, 1, (Option<Node>)new Some((Object)this.node1()));
        mockVerificationTime.update(ArgumentMatchers.anyLong());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            long newTime = BoxesRunTime.unboxToLong((Object)invocation.getArgument(0));
            if (newTime > maxVerificationTime$1.elem) {
                maxVerificationTime$1.elem = newTime;
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        MockedConstruction mockMetricsGroupCtor = Mockito.mockConstruction(KafkaMetricsGroup.class, (mock, context) -> {
            Mockito.when((Object)mock.newMeter((String)ArgumentMatchers.eq((Object)"VerificationFailureRate"), ArgumentMatchers.anyString(), (TimeUnit)((Object)((Object)ArgumentMatchers.any(TimeUnit.class))))).thenReturn((Object)mockVerificationFailureMeter);
            Mockito.when((Object)mock.newHistogram((String)ArgumentMatchers.eq((Object)"VerificationTimeMs"))).thenReturn((Object)mockVerificationTime);
        });
        AddPartitionsToTxnManager addPartitionsManagerWithMockedMetrics = new AddPartitionsToTxnManager((AbstractKafkaConfig)this.config(), this.networkClient(), this.metadataCache(), this.partitionFor(), (Time)this.time());
        try {
            addPartitionsManagerWithMockedMetrics.addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors), this.transactionSupportedOperation());
            addPartitionsManagerWithMockedMetrics.addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors), this.transactionSupportedOperation());
            this.time().sleep(100L);
            Collection requestsAndHandlers = addPartitionsManagerWithMockedMetrics.generateRequests();
            IntRef requestsHandled = IntRef.create((int)0);
            requestsAndHandlers.forEach(requestAndCompletionHandler -> {
                this.time().sleep(100L);
                requestAndCompletionHandler.handler.onComplete(this.authenticationErrorResponse());
                ++requestsHandled$1.elem;
                ((Histogram)Mockito.verify((Object)mockVerificationTime, (VerificationMode)Mockito.times((int)requestsHandled$1.elem))).update(ArgumentMatchers.anyLong());
                Assertions.assertEquals((long)maxVerificationTime$1.elem, (long)(this.time().milliseconds() - startTime));
                ((Meter)Mockito.verify((Object)mockVerificationFailureMeter, (VerificationMode)Mockito.times((int)requestsHandled$1.elem))).mark(3L);
            });
            addPartitionsManagerWithMockedMetrics.shutdown();
            KafkaMetricsGroup mockMetricsGroup = (KafkaMetricsGroup)mockMetricsGroupCtor.constructed().get(0);
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).newMeter((String)ArgumentMatchers.eq((Object)"VerificationFailureRate"), ArgumentMatchers.anyString(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).newHistogram((String)ArgumentMatchers.eq((Object)"VerificationTimeMs"));
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).removeMetric("VerificationFailureRate");
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).removeMetric("VerificationTimeMs");
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockMetricsGroup});
        }
        catch (Throwable throwable) {
            if (mockMetricsGroupCtor != null) {
                mockMetricsGroupCtor.close();
            }
            if (addPartitionsManagerWithMockedMetrics.isRunning()) {
                addPartitionsManagerWithMockedMetrics.shutdown();
            }
            throw throwable;
        }
        mockMetricsGroupCtor.close();
        if (addPartitionsManagerWithMockedMetrics.isRunning()) {
            addPartitionsManagerWithMockedMetrics.shutdown();
        }
    }

    private void mockTransactionStateMetadata(int partitionIndex, int leaderId, Option<Node> leaderNode) {
        Mockito.when((Object)this.metadataCache().getLeaderAndIsr("__transaction_state", partitionIndex)).thenReturn(Optional.of(new LeaderAndIsr(leaderId, Arrays.asList(Predef$.MODULE$.int2Integer(leaderId)))));
        if (leaderId != -1) {
            Mockito.when((Object)this.metadataCache().getAliveBrokerNode(leaderId, this.config().interBrokerListenerName())).thenReturn(Optional.ofNullable(leaderNode.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            return;
        }
    }

    private ClientResponse clientResponse(AbstractResponse response, AuthenticationException authException, UnsupportedVersionException mismatchException, boolean disconnected) {
        return new ClientResponse(null, null, null, 0L, 0L, disconnected, mismatchException, authException, response);
    }

    private AuthenticationException clientResponse$default$2() {
        return null;
    }

    private UnsupportedVersionException clientResponse$default$3() {
        return null;
    }

    private boolean clientResponse$default$4() {
        return false;
    }

    private AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction transactionData(String transactionalId, long producerId, short producerEpoch, boolean verifyOnly) {
        return new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId).setProducerId(producerId).setProducerEpoch(producerEpoch).setVerifyOnly(verifyOnly).setTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$).iterator()).asJava()));
    }

    private short transactionData$default$3() {
        return 0;
    }

    private void receiveResponse(ClientResponse response) {
        ((RequestAndCompletionHandler)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.addPartitionsToTxnManager().generateRequests()).asScala().head()).handler.onComplete(response);
    }

    private void verifyRequest(Node expectedDestination, String transactionalId, long producerId, boolean verifyOnly, RequestAndCompletionHandler requestAndHandler) {
        Assertions.assertEquals((long)this.time().milliseconds(), (long)requestAndHandler.creationTimeMs);
        Assertions.assertEquals((Object)expectedDestination, (Object)requestAndHandler.destination);
        short x$4 = 0;
        Assertions.assertEquals((Object)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection((java.util.Iterator)CollectionConverters$.MODULE$.IteratorHasAsJava((Iterator)new .colon.colon((Object)this.transactionData((String)transactionalId, (long)producerId, (short)x$4, (boolean)verifyOnly), (List)Nil$.MODULE$).iterator()).asJava())).data, (Object)((AddPartitionsToTxnRequest.Builder)requestAndHandler.request).data);
    }

    public static final /* synthetic */ void $anonfun$testAddTxnData$3(AddPartitionsToTxnManagerTest $this, boolean isAddPartition$1, RequestAndCompletionHandler requestAndHandler) {
        Node node = requestAndHandler.destination;
        Node node2 = $this.node0();
        if (!(node != null ? !node.equals(node2) : node2 != null)) {
            Assertions.assertEquals((long)$this.time().milliseconds(), (long)requestAndHandler.creationTimeMs);
            String x$1 = $this.transactionalId3();
            long x$2 = $this.producerId3();
            boolean x$3 = !isAddPartition$1;
            short x$4 = 0;
            Assertions.assertEquals((Object)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection((java.util.Iterator)CollectionConverters$.MODULE$.IteratorHasAsJava((Iterator)new .colon.colon((Object)$this.transactionData((String)x$1, (long)x$2, (short)x$4, (boolean)x$3), (List)new .colon.colon((Object)$this.transactionData((String)$this.transactionalId1(), (long)$this.producerId1(), (short)1, (boolean)(!isAddPartition$1 ? true : false)), (List)Nil$.MODULE$)).iterator()).asJava())).data, (Object)((AddPartitionsToTxnRequest.Builder)requestAndHandler.request).data);
            return;
        }
        $this.verifyRequest($this.node1(), $this.transactionalId2(), $this.producerId2(), !isAddPartition$1, requestAndHandler);
    }

    public static final /* synthetic */ void $anonfun$testGenerateRequests$1(AddPartitionsToTxnManagerTest $this, boolean isAddPartition$2, RequestAndCompletionHandler requestAndHandler) {
        Node node = requestAndHandler.destination;
        Node node2 = $this.node0();
        if (!(node != null ? !node.equals(node2) : node2 != null)) {
            $this.verifyRequest($this.node0(), $this.transactionalId1(), $this.producerId1(), !isAddPartition$2, requestAndHandler);
            return;
        }
        $this.verifyRequest($this.node1(), $this.transactionalId2(), $this.producerId2(), !isAddPartition$2, requestAndHandler);
    }

    public static final /* synthetic */ boolean $anonfun$testGenerateRequests$3(AddPartitionsToTxnManagerTest $this, RequestAndCompletionHandler x$4) {
        Node node = x$4.destination;
        Node node2 = $this.node1();
        return !(node != null ? !node.equals(node2) : node2 != null);
    }

    private final void checkError$1() {
        scala.collection.mutable.Map errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)errors), this.transactionSupportedOperation());
        Assertions.assertEquals((Object)this.topicPartitions().map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)Errors.COORDINATOR_NOT_AVAILABLE)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)errors);
    }

    private final void addTransactionsToVerify$1(scala.collection.mutable.Map transaction1Errors$1, scala.collection.mutable.Map transaction2Errors$1) {
        transaction1Errors$1.clear();
        transaction2Errors$1.clear();
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1Errors$1), this.transactionSupportedOperation());
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction2Errors$1), this.transactionSupportedOperation());
    }

    private final void addTransactionsToVerifyRequestVersion$1(AddPartitionsToTxnManager.TransactionSupportedOperation operationExpected, scala.collection.mutable.Map transaction1Errors$1, scala.collection.mutable.Map transaction2Errors$1) {
        transaction1Errors$1.clear();
        transaction2Errors$1.clear();
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId1(), this.producerId1(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1Errors$1), operationExpected);
        this.addPartitionsToTxnManager().addOrVerifyTransaction(this.transactionalId2(), this.producerId2(), (short)0, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicPartitions()).asJava(), this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction2Errors$1), operationExpected);
    }

    /*
     * WARNING - void declaration
     */
    public AddPartitionsToTxnManagerTest() {
        void clientResponse_disconnected;
        this.topic = "foo";
        this.transactionalId1 = "txn1";
        this.transactionalId2 = "txn2";
        this.transactionalId3 = "txn3";
        this.producerId1 = 0L;
        this.producerId2 = 1L;
        this.producerId3 = 2L;
        boolean bl = false;
        SaslAuthenticationException clientResponse_authException = new SaslAuthenticationException("");
        Object var3_2 = null;
        this.authenticationErrorResponse = new ClientResponse(null, null, null, 0L, 0L, (boolean)clientResponse_disconnected, null, (AuthenticationException)clientResponse_authException, null);
        UnsupportedVersionException x$2 = new UnsupportedVersionException("");
        boolean x$4 = false;
        this.versionMismatchResponse = new ClientResponse(null, null, null, 0L, 0L, x$4, x$2, null, null);
        boolean clientResponse_disconnected2 = true;
        this.disconnectedResponse = new ClientResponse(null, null, null, 0L, 0L, clientResponse_disconnected2, null, null, null);
        this.transactionSupportedOperation = AddPartitionsToTxnManager.TransactionSupportedOperation.GENERIC_ERROR_SUPPORTED;
        this.config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    }

    public static final /* synthetic */ Object $anonfun$testGenerateRequests$3$adapted(AddPartitionsToTxnManagerTest $this, RequestAndCompletionHandler x$4) {
        return BoxesRunTime.boxToBoolean((boolean)AddPartitionsToTxnManagerTest.$anonfun$testGenerateRequests$3($this, x$4));
    }
}

