/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.server.AddPartitionsToTxnRequestServerTest$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAqA\b\u0001C\u0002\u0013%q\u0004\u0003\u0004)\u0001\u0001\u0006I\u0001\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0011\u0019\t\u0004\u0001)A\u0005W!)!\u0007\u0001C!g!)q\b\u0001C!\u0001\")1\u000b\u0001C\u0001)\")A\u000e\u0001C\u0001[\")!\u000f\u0001C\u0001[\")A\u000f\u0001C\u0005k\u001e9\u0011qK\t\t\u0002\u0005ecA\u0002\t\u0012\u0011\u0003\tY\u0006\u0003\u0004\u001c\u001b\u0011\u0005\u00111\r\u0005\u0007W6!\t!!\u001a\u0003G\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c*fcV,7\u000f^*feZ,'\u000fV3ti*\u0011!cE\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Q\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001$G\u0007\u0002#%\u0011!$\u0005\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012!\b\t\u00031\u0001\ta\u0001^8qS\u000e\fT#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t11\u000b\u001e:j]\u001e\fq\u0001^8qS\u000e\f\u0004%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003i]\u0002\"\u0001L\u001b\n\u0005Yj#\u0001B+oSRDQ\u0001\u000f\u0004A\u0002e\n!\u0002\u001d:pa\u0016\u0014H/[3t!\tQT(D\u0001<\u0015\taD%\u0001\u0003vi&d\u0017B\u0001 <\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003i\u0005CQAQ\u0004A\u0002\r\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003\t6k\u0011!\u0012\u0006\u0003\r\u001e\u000b1!\u00199j\u0015\tA\u0015*A\u0004kkBLG/\u001a:\u000b\u0005)[\u0015!\u00026v]&$(\"\u0001'\u0002\u0007=\u0014x-\u0003\u0002O\u000b\nAA+Z:u\u0013:4w\u000e\u000b\u0002\b!B\u0011A)U\u0005\u0003%\u0016\u0013!BQ3g_J,W)Y2i\u0003q\u001a\bn\\;mIJ+7-Z5wK>\u0003XM]1uS>tgj\u001c;BiR,W\u000e\u001d;fI^CWM\\(uQ\u0016\u0014\b+\u0019:uSRLwN\u001c%bg\u0016\u0013(o\u001c:\u0015\u0005Q*\u0006\"\u0002,\t\u0001\u00049\u0016a\u0002<feNLwN\u001c\t\u0003YaK!!W\u0017\u0003\u000bMCwN\u001d;)\u0005!Y\u0006C\u0001/`\u001b\u0005i&B\u00010H\u0003\u0019\u0001\u0018M]1ng&\u0011\u0001-\u0018\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b\u0006\u0002\u0005cQ&\u0004\"a\u00194\u000e\u0003\u0011T!!Z/\u0002\u0011A\u0014xN^5eKJL!a\u001a3\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003)\f\u0013a[\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\u0018A\n;fgR|e.Z*vG\u000e,7o](oK\u0016\u0013(o\u001c:J]\n\u000bGo\u00195fIJ+\u0017/^3tiR\tA\u0007\u000b\u0002\n_B\u0011A\t]\u0005\u0003c\u0016\u0013A\u0001V3ti\u0006qA/Z:u-\u0016\u0014\u0018NZ=P]2L\bF\u0001\u0006p\u0003E\u0019X\r^+q)J\fgn]1di&|gn\u001d\u000b\bm\u0006%\u00121HA#!\u0011asoK=\n\u0005al#A\u0002+va2,'\u0007E\u0002{\u0003Gq1a_A\u000f\u001d\ra\u0018q\u0003\b\u0004{\u0006Eab\u0001@\u0002\u000e9\u0019q0!\u0003\u000f\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u0016\u0003\u0019a$o\\8u}%\tA*C\u0002\u0002\f-\u000ba!\u00199bG\",\u0017b\u0001\u000b\u0002\u0010)\u0019\u00111B&\n\t\u0005M\u0011QC\u0001\u0007G>lWn\u001c8\u000b\u0007Q\ty!\u0003\u0003\u0002\u001a\u0005m\u0011aB7fgN\fw-\u001a\u0006\u0005\u0003'\t)\"\u0003\u0003\u0002 \u0005\u0005\u0012!H!eIB\u000b'\u000f^5uS>t7\u000fV8Uq:\u0014V-];fgR$\u0015\r^1\u000b\t\u0005e\u00111D\u0005\u0005\u0003K\t9CA\u000fBI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)btGK]1og\u0006\u001cG/[8o\u0015\u0011\ty\"!\t\t\u000f\u0005-2\u00021\u0001\u0002.\u0005yAO]1og\u0006\u001cG/[8oC2LE\r\u0005\u0003\u00020\u0005]b\u0002BA\u0019\u0003g\u00012!!\u0001.\u0013\r\t)$L\u0001\u0007!J,G-\u001a4\n\u0007\u001d\nIDC\u0002\u000265Bq!!\u0010\f\u0001\u0004\ty$\u0001\u0006wKJLg-_(oYf\u00042\u0001LA!\u0013\r\t\u0019%\f\u0002\b\u0005>|G.Z1o\u0011\u001d\t9e\u0003a\u0001\u0003\u0013\n!\u0002]1si&$\u0018n\u001c8t!\u0019\ty#a\u0013\u0002P%!\u0011QJA\u001d\u0005\r\u0019V\r\u001e\t\u0005\u0003#\n\u0019&\u0004\u0002\u0002\u001c%!\u0011QKA\u000e\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1%\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]J+\u0017/^3tiN+'O^3s)\u0016\u001cH\u000f\u0005\u0002\u0019\u001bM\u0019Q\"!\u0018\u0011\u00071\ny&C\u0002\u0002b5\u0012a!\u00118z%\u00164GCAA-+\t\t9\u0007\u0005\u0004\u0002j\u0005=\u00141O\u0007\u0003\u0003WR1!!\u001c<\u0003\u0019\u0019HO]3b[&!\u0011\u0011OA6\u0005\u0019\u0019FO]3b[B\u00191-!\u001e\n\u0007\u0005]DMA\u0005Be\u001e,X.\u001a8ug\u0002")
public class AddPartitionsToTxnRequestServerTest
extends BaseRequestTest {
    private final String topic1;
    private final int numPartitions;

    public static Stream<Arguments> parameters() {
        return AddPartitionsToTxnRequestServerTest$.MODULE$.parameters();
    }

    private String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("auto.create.topics.enable", Boolean.toString(false));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic1(), this.numPartitions(), this.brokers().size(), new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldReceiveOperationNotAttemptedWhenOtherPartitionHasError(short version) {
        AddPartitionsToTxnRequest addPartitionsToTxnRequest;
        TopicPartition nonExistentTopic = new TopicPartition("unknownTopic", 0);
        TopicPartition createdTopicPartition = new TopicPartition(this.topic1(), 0);
        String transactionalId = "foobar";
        long producerId = 1000L;
        short producerEpoch = 0;
        if (version < 4) {
            addPartitionsToTxnRequest = AddPartitionsToTxnRequest.Builder.forClient((String)transactionalId, (long)producerId, (short)producerEpoch, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)createdTopicPartition, (List)new .colon.colon((Object)nonExistentTopic, (List)Nil$.MODULE$))).asJava()).build(version);
        } else {
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
            topics.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(createdTopicPartition.topic()).setPartitions(Collections.singletonList(Predef$.MODULE$.int2Integer(createdTopicPartition.partition()))));
            topics.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(nonExistentTopic.topic()).setPartitions(Collections.singletonList(Predef$.MODULE$.int2Integer(nonExistentTopic.partition()))));
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection();
            transactions.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId).setProducerId(producerId).setProducerEpoch(producerEpoch).setVerifyOnly(false).setTopics(topics));
            addPartitionsToTxnRequest = AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions).build(version);
        }
        AddPartitionsToTxnRequest request = addPartitionsToTxnRequest;
        int leaderId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        AddPartitionsToTxnResponse response = (AddPartitionsToTxnResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AddPartitionsToTxnResponse.class));
        java.util.Map errors = version < 4 ? (java.util.Map)response.errors().get("") : (java.util.Map)response.errors().get(transactionalId);
        Assertions.assertEquals((int)2, (int)errors.size());
        Assertions.assertTrue((boolean)errors.containsKey(createdTopicPartition));
        Assertions.assertEquals((Object)Errors.OPERATION_NOT_ATTEMPTED, errors.get(createdTopicPartition));
        Assertions.assertTrue((boolean)errors.containsKey(nonExistentTopic));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, errors.get(nonExistentTopic));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOneSuccessOneErrorInBatchedRequest() {
        void var9_8;
        void var10_9;
        TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
        String transactionalId1 = "foobar";
        String transactionalId2 = "barfoo";
        long producerId2 = 1000L;
        short producerEpoch2 = 0;
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection txn2Topics = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
        txn2Topics.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(tp0.topic()).setPartitions(Collections.singletonList(Predef$.MODULE$.int2Integer(tp0.partition()))));
        Tuple2<Object, AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction> tuple2 = this.setUpTransactions(transactionalId1, false, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0}))));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int coordinatorId = tuple2._1$mcI$sp();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction txn1 = (AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction)tuple2._2();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection();
        transactions.add((ImplicitLinkedHashCollection.Element)var10_9);
        transactions.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId2).setProducerId(producerId2).setProducerEpoch(producerEpoch2).setVerifyOnly(false).setTopics(txn2Topics));
        AddPartitionsToTxnRequest request = (AddPartitionsToTxnRequest)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions).build();
        java.util.Map errors = ((AddPartitionsToTxnResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer((int)var9_8), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AddPartitionsToTxnResponse.class))).errors();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionalId1), Collections.singletonMap(tp0, Errors.NONE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionalId2), Collections.singletonMap(tp0, Errors.INVALID_PRODUCER_ID_MAPPING))}))).asJava(), (Object)errors);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testVerifyOnly() {
        void var4_4;
        void var5_5;
        TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
        String transactionalId = "foobar";
        Tuple2<Object, AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction> tuple2 = this.setUpTransactions(transactionalId, true, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0}))));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int coordinatorId = tuple2._1$mcI$sp();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction txn = (AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction)tuple2._2();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection();
        transactions.add((ImplicitLinkedHashCollection.Element)var5_5);
        AddPartitionsToTxnRequest verifyRequest = (AddPartitionsToTxnRequest)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions).build();
        java.util.Map verifyErrors = ((AddPartitionsToTxnResponse)this.connectAndReceive((AbstractRequest)verifyRequest, this.brokerSocketServer((int)var4_4), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AddPartitionsToTxnResponse.class))).errors();
        Assertions.assertEquals(Collections.singletonMap(transactionalId, Collections.singletonMap(tp0, Errors.TRANSACTION_ABORTABLE)), (Object)verifyErrors);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction> setUpTransactions(String transactionalId, boolean verifyOnly, Set<TopicPartition> partitions) {
        InitProducerIdResponse initProducerIdResponse;
        FindCoordinatorRequest findCoordinatorRequest = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKey(transactionalId).setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id())).build();
        this.connectAndReceive((AbstractRequest)findCoordinatorRequest, this.brokerSocketServer(((KafkaBroker)this.brokers().head()).config().brokerId()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class));
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.brokers(), "__transaction_state", 50);
        TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)this.brokers(), this.controllerServer(), "Timeout waiting for controller metadata propagating to brokers");
        int coordinatorId = ((FindCoordinatorResponseData.Coordinator)((FindCoordinatorResponse)this.connectAndReceive((AbstractRequest)findCoordinatorRequest, this.brokerSocketServer(((KafkaBroker)this.brokers().head()).config().brokerId()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class))).data().coordinators().get(0)).nodeId();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            InitProducerIdRequest $anonfun$setUpTransactions$1_initPidRequest = (InitProducerIdRequest)new InitProducerIdRequest.Builder(new InitProducerIdRequestData().setTransactionalId(transactionalId).setTransactionTimeoutMs(10000)).build();
            initProducerIdResponse = (InitProducerIdResponse)this.connectAndReceive((AbstractRequest)$anonfun$setUpTransactions$1_initPidRequest, this.brokerSocketServer(coordinatorId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitProducerIdResponse.class));
            Errors errors = initProducerIdResponse.error();
            Errors errors2 = Errors.COORDINATOR_LOAD_IN_PROGRESS;
            boolean bl = errors == null ? errors2 != null : !errors.equals(errors2);
            Object var16_9 = null;
            errors2 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to get a valid InitProducerIdResponse.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long producerId1 = initProducerIdResponse.data().producerId();
        short producerEpoch1 = initProducerIdResponse.data().producerEpoch();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection txn1Topics = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
        partitions.foreach((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)txn1Topics.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(tp.topic()).setPartitions(Collections.singletonList(Predef$.MODULE$.int2Integer(tp.partition()))))));
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorId), (Object)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId).setProducerId(producerId1).setProducerEpoch(producerEpoch1).setVerifyOnly(verifyOnly).setTopics(txn1Topics));
    }

    public static final /* synthetic */ boolean $anonfun$setUpTransactions$1(AddPartitionsToTxnRequestServerTest $this, String transactionalId$1, ObjectRef initPidResponse$1, int coordinatorId$1) {
        InitProducerIdRequest initPidRequest = (InitProducerIdRequest)new InitProducerIdRequest.Builder(new InitProducerIdRequestData().setTransactionalId(transactionalId$1).setTransactionTimeoutMs(10000)).build();
        initPidResponse$1.elem = (InitProducerIdResponse)$this.connectAndReceive((AbstractRequest)initPidRequest, $this.brokerSocketServer(coordinatorId$1), $this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitProducerIdResponse.class));
        Errors errors = ((InitProducerIdResponse)initPidResponse$1.elem).error();
        Errors errors2 = Errors.COORDINATOR_LOAD_IN_PROGRESS;
        return errors == null ? errors2 != null : !errors.equals(errors2);
    }

    public static final /* synthetic */ String $anonfun$setUpTransactions$2() {
        return "Failed to get a valid InitProducerIdResponse.";
    }

    public AddPartitionsToTxnRequestServerTest() {
        this.topic1 = "topic1";
        this.numPartitions = 1;
    }
}

