/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u000f\u001f\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006q\u0001!\t!\u000f\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u0013\u0002!\tA\u0010\u0005\u0006\u0017\u0002!\tA\u0010\u0005\u00065\u0002!\tA\u0010\u0005\u00069\u0002!\tA\u0010\u0005\u0006=\u0002!Ia\u0018\u0005\u0006e\u0002!\tA\u0010\u0005\u0006i\u0002!\tA\u0010\u0005\u0006m\u0002!\tA\u0010\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u001d\ti\u0002\u0001Q\u0001\niD\u0001\"a\b\u0001\u0005\u0004%I!\u001f\u0005\b\u0003C\u0001\u0001\u0015!\u0003{\u0011\u0019\t\u0019\u0003\u0001C\u0005}!1\u0011Q\u0005\u0001\u0005\u0002yBa!!\u000b\u0001\t\u0003q\u0004BBA\u0017\u0001\u0011\u0005a\b\u0003\u0004\u00022\u0001!\tA\u0010\u0005\b\u0003k\u0001A\u0011BA\u001c\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"9\u00111\u0014\u0001\u0005\n\u0005u\u0005bBA]\u0001\u0011%\u00111\u0018\u0005\b\u00037\u0004A\u0011BAo\u0005]\u0019E.[3oiF+x\u000e^1t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002 A\u000511/\u001a:wKJT\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\tac'D\u0001.\u0015\tqs&\u0001\u0003uKN$(B\u0001\u00192\u0003\u0019\u0019w.\\7p]*\u0011\u0011E\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028[\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003uq\u0002\"a\u000f\u0001\u000e\u0003yAQA\u000b\u0002A\u0002-\nA\u0004^3ti\u0006cG/\u001a:DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cH\u000fF\u0001@!\t)\u0003)\u0003\u0002BM\t!QK\\5uQ\t\u00191\t\u0005\u0002E\u000f6\tQI\u0003\u0002G[\u0005\u0019\u0011\r]5\n\u0005!+%aC\"mkN$XM\u001d+fgR\f\u0001\u0006^3ti\u0006cG/\u001a:DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cHOV1mS\u0012\fG/Z(oYfD#\u0001B\"\u0002;Q,7\u000f^\"mS\u0016tG/U;pi\u0006\u001chi\u001c:TGJ\fW.V:feNDC!B'W/B\u0011a\nV\u0007\u0002\u001f*\u0011a\t\u0015\u0006\u0003#J\u000bqA[;qSR,'O\u0003\u0002Ti\u0005)!.\u001e8ji&\u0011Qk\u0014\u0002\t\t&\u001c\u0018M\u00197fI\u0006)a/\u00197vK\u0006\n\u0001,A.U\u001f\u0012{%\bI&B\r.\u000bU&M\u001c7gA\u0002S\u0006\t\u0011D_:4XM\u001d;!\u00072LWM\u001c;Rk>$\u0018m\u001d*fcV,7\u000f\u001e+fgR\u001cC/Z:u\u00072LWM\u001c;Rk>$\u0018m\u001d$peN\u001b'/Y7Vg\u0016\u00148\u000f\t;pA-\u0014\u0018M\u001a;)\u0005\u0015\u0019\u0015\u0001\u0007;fgR\fE\u000e^3s\u0013B\fVo\u001c;bgJ+\u0017/^3ti\"\u0012aaQ\u0001%i\u0016\u001cH/\u00117uKJ\u001cE.[3oiF+x\u000e^1t\u0013:4\u0018\r\\5e%\u0016\fX/Z:ug\"\u0012qaQ\u0001 Kb\u0004Xm\u0019;J]Z\fG.\u001b3SKF,Xm\u001d;XSRDW*Z:tC\u001e,GcA aK\"1\u0011\r\u0003CA\u0002\t\f\u0001B];o]\u0006\u0014G.\u001a\t\u0004K\r|\u0014B\u00013'\u0005!a$-\u001f8b[\u0016t\u0004\"\u00024\t\u0001\u00049\u0017aD3ya\u0016\u001cG/\u001a3NKN\u001c\u0018mZ3\u0011\u0005!|gBA5n!\tQg%D\u0001l\u0015\ta'%\u0001\u0004=e>|GOP\u0005\u0003]\u001a\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011aNJ\u0001.i\u0016\u001cH/\u00117uKJ\u001cE.[3oiF+x\u000e^1t\u0013:4\u0018\r\\5e\u000b:$\u0018\u000e^=D_6\u0014\u0017N\\1uS>t\u0007FA\u0005D\u0003i!Xm\u001d;BYR,'o\u00117jK:$\u0018+^8uCN\u0014\u0015\rZ%qQ\tQ1)\u0001\u0019uKN$H)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCNLeN^1mS\u00124\u0015\u000e\u001c;fe\u000e{WNY5oCRLwN\u001c\u0015\u0003\u0017\r\u000bq#\\1uG\",6/\u001a:DY&,g\u000e^#oi&$\u0018.Z:\u0016\u0003i\u0004Ra_A\u0001\u0003\u000bi\u0011\u0001 \u0006\u0003{z\f\u0011\"[7nkR\f'\r\\3\u000b\u0005}4\u0013AC2pY2,7\r^5p]&\u0019\u00111\u0001?\u0003\t1K7\u000f\u001e\t\bK\u0005\u001d\u00111BA\f\u0013\r\tIA\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u00050\u0003\u0015\tXo\u001c;b\u0013\u0011\t)\"a\u0004\u0003#\rc\u0017.\u001a8u#V|G/Y#oi&$\u0018\u0010E\u0002&\u00033I1!a\u0007'\u0005\u0019!u.\u001e2mK\u0006AR.\u0019;dQV\u001bXM]\"mS\u0016tG/\u00128uSRLWm\u001d\u0011\u0002\u001f5\fGo\u00195Ja\u0016sG/\u001b;jKN\f\u0001#\\1uG\"L\u0005/\u00128uSRLWm\u001d\u0011\u0002EM,G/\u001e9EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m]'bi\u000eDG+Z:u\u0003\t\"Xm\u001d;EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m]'bi\u000eDW\t_1di\"\u0012\u0011cQ\u0001%i\u0016\u001cH\u000fR3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cX*\u0019;dQB\u000b'\u000f^5bY\"\u0012!cQ\u0001'i\u0016\u001cHo\u00117jK:$\u0018+^8uCN,fn];qa>\u0014H/\u001a3F]RLG/\u001f+za\u0016\u001c\bFA\nD\u0003e!Xm\u001d;DY&,g\u000e^)v_R\f7oU1oSRL'0\u001a3)\u0005Q\u0019\u0015A\u0007<fe&4\u0017\u0010R3tGJL'-Z#oi&$\u00180U;pi\u0006\u001cH#B \u0002:\u0005u\u0002bBA\u001e+\u0001\u0007\u00111B\u0001\u0007K:$\u0018\u000e^=\t\u000f\u0005}R\u00031\u0001\u0002B\u00051\u0011/^8uCN\u0004b\u0001[A\"O\u0006]\u0011bAA#c\n\u0019Q*\u00199\u0002\u001dQ|7\t\\5f]R,e\u000e^5usR1\u00111BA&\u0003+Bq!!\u0014\u0017\u0001\u0004\ty%\u0001\u0003vg\u0016\u0014\b\u0003B\u0013\u0002R\u001dL1!a\u0015'\u0005\u0019y\u0005\u000f^5p]\"9\u0011q\u000b\fA\u0002\u0005=\u0013\u0001C2mS\u0016tG/\u00133\u0002\u0015Q|\u0017\n]#oi&$\u0018\u0010\u0006\u0003\u0002\f\u0005u\u0003bBA0/\u0001\u0007\u0011qJ\u0001\u0003SB\fA\u0003Z3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cH\u0003BA3\u0003\u007f\u0002\u0002\"a\u001a\u0002r\u0005-\u00111O\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005!Q\u000f^5m\u0015\t\ty'\u0001\u0003kCZ\f\u0017\u0002BA#\u0003S\u0002r!a\u001a\u0002r\u001d\f)\b\u0005\u0003\u0002x\u0005uTBAA=\u0015\u0011\tY(!\u001c\u0002\t1\fgnZ\u0005\u0005\u00037\tI\bC\u0004\u0002\u0002b\u0001\r!a!\u0002\r\u0019LG\u000e^3s!\u0011\ti!!\"\n\t\u0005\u001d\u0015q\u0002\u0002\u0012\u00072LWM\u001c;Rk>$\u0018MR5mi\u0016\u0014\u0018aH:f]\u0012$Um]2sS\n,7\t\\5f]R\fVo\u001c;bgJ+\u0017/^3tiR!\u0011QRAM!\u0011\ty)!&\u000e\u0005\u0005E%bAAJ_\u0005A!/Z9vKN$8/\u0003\u0003\u0002\u0018\u0006E%\u0001\b#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3ta>t7/\u001a\u0005\b\u0003\u0003K\u0002\u0019AAB\u0003E\tG\u000e^3s\u000b:$\u0018\u000e^=Rk>$\u0018m\u001d\u000b\t\u0003?\u000b)+a*\u00020B!\u0011qOAQ\u0013\u0011\t\u0019+!\u001f\u0003\tY{\u0017\u000e\u001a\u0005\b\u0003wQ\u0002\u0019AA\u0006\u0011\u001d\tIK\u0007a\u0001\u0003W\u000bQ!\u00197uKJ\u0004b\u0001[A\"O\u00065\u0006#B\u0013\u0002R\u0005]\u0001bBAY5\u0001\u0007\u00111W\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\t\u0004K\u0005U\u0016bAA\\M\t9!i\\8mK\u0006t\u0017!E1mi\u0016\u00148\t\\5f]R\fVo\u001c;bgR1\u0011QXAj\u00033\u0004\u0002\"a0\u0002F\u0006-\u0011qY\u0007\u0003\u0003\u0003T1!a1\u007f\u0003\u001diW\u000f^1cY\u0016LA!!\u0012\u0002BB1\u0011\u0011ZAh\u0003?k!!a3\u000b\u0007\u00055w&A\u0005j]R,'O\\1mg&!\u0011\u0011[Af\u0005=Y\u0015MZ6b\rV$XO]3J[Bd\u0007bBAk7\u0001\u0007\u0011q[\u0001\be\u0016\fX/Z:u!\u001dA\u00171IA\u0006\u0003WCq!!-\u001c\u0001\u0004\t\u0019,\u0001\u000ftK:$\u0017\t\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:SKF,Xm\u001d;\u0015\r\u0005}\u0017Q\u001dB\u0001!\u0011\ty)!9\n\t\u0005\r\u0018\u0011\u0013\u0002\u001a\u00032$XM]\"mS\u0016tG/U;pi\u0006\u001c(+Z:q_:\u001cX\rC\u0004\u0002hr\u0001\r!!;\u0002\u000f\u0015tGO]5fgB1\u00111^A{\u0003wtA!!<\u0002r:\u0019!.a<\n\u0003\u001dJ1!a='\u0003\u001d\u0001\u0018mY6bO\u0016LA!a>\u0002z\nA\u0011\n^3sC\ndWMC\u0002\u0002t\u001a\u0002B!!\u0004\u0002~&!\u0011q`A\b\u0005U\u0019E.[3oiF+x\u000e^1BYR,'/\u0019;j_:Dq!!-\u001d\u0001\u0004\t\u0019\f")
public class ClientQuotasRequestTest {
    private final ClusterInstance cluster;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities;

    @ClusterTest
    public void testAlterClientQuotasRequest() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-id")}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)15000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)15000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)5000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)5000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.3)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)12.3))}))));
    }

    @ClusterTest
    public void testAlterClientQuotasRequestValidateOnly() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)23.45)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
    }

    @Disabled(value="TODO: KAFKA-17630 -  Convert ClientQuotasRequestTest#testClientQuotasForScramUsers to kraft")
    @ClusterTest
    public void testClientQuotasForScramUsers() {
        String userName = "user";
        try (Admin admin = this.cluster.admin();){
            admin.alterUserScramCredentials(Arrays.asList(new UserScramCredentialUpsertion(userName, new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 4096), "password"))).all().get();
            ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)userName)}))).asJava());
            this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
            this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
            this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        }
    }

    @ClusterTest
    public void testAlterIpQuotasRequest() {
        String knownHost = "1.2.3.4";
        String unknownHost = "2.3.4.5";
        ClientQuotaEntity entity = this.toIpEntity((Option<String>)new Some((Object)knownHost));
        ClientQuotaEntity defaultEntity = this.toIpEntity((Option<String>)new Some(null));
        ClientQuotaFilterComponent entityFilter = ClientQuotaFilterComponent.ofEntity((String)"ip", (String)knownHost);
        ClientQuotaFilterComponent defaultEntityFilter = ClientQuotaFilterComponent.ofDefaultEntity((String)"ip");
        ClientQuotaFilterComponent allIpEntityFilter = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)100.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)100.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)150.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0))})), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)200.0)))}))), false);
        this.verifyIpQuotas$1(defaultEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.verifyIpQuotas$1(allIpEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(entityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidRequests() {
        ObjectRef entity = ObjectRef.create((Object)new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"")}))).asJava()));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"name")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
    }

    private void expectInvalidRequestWithMessage(Function0<BoxedUnit> runnable, String expectedMessage) {
        InvalidRequestException exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> runnable.apply$mcV$sp());
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage), (String)("Expected message " + exception + " to contain " + expectedMessage));
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidEntityCombination() {
        ClientQuotaEntity userAndIpEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        ClientQuotaEntity clientAndIpEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        String expectedExceptionMessage = "Invalid quota entity combination";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(userAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)("Expected message " + expectInvalidRequestWithMessage_exception + " to contain " + expectedExceptionMessage));
        Object var4_4 = null;
        Object var5_5 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(clientAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_percentage"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)("Expected message " + expectInvalidRequestWithMessage_exception2 + " to contain " + expectedExceptionMessage));
    }

    @ClusterTest
    public void testAlterClientQuotasBadIp() {
        ClientQuotaEntity invalidHostPatternEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"not a valid host because it has spaces")}))).asJava());
        ClientQuotaEntity unresolvableHostEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"RFC2606.invalid")}))).asJava());
        String expectedExceptionMessage = "not a valid IP";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(invalidHostPatternEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)("Expected message " + expectInvalidRequestWithMessage_exception + " to contain " + expectedExceptionMessage));
        Object var4_4 = null;
        Object var5_5 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(unresolvableHostEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)("Expected message " + expectInvalidRequestWithMessage_exception2 + " to contain " + expectedExceptionMessage));
    }

    @ClusterTest
    public void testDescribeClientQuotasInvalidFilterCombination() {
        ClientQuotaFilterComponent ipFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        ClientQuotaFilterComponent userFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"user");
        ClientQuotaFilterComponent clientIdFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"client-id");
        String expectedExceptionMessage = "Invalid entity filter component combination";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ipFilterComponent, (List)new .colon.colon((Object)userFilterComponent, (List)Nil$.MODULE$))).asJava()));
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)("Expected message " + expectInvalidRequestWithMessage_exception + " to contain " + expectedExceptionMessage));
        Object var5_5 = null;
        Object var6_6 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ipFilterComponent, (List)new .colon.colon((Object)clientIdFilterComponent, (List)Nil$.MODULE$))).asJava()));
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)("Expected message " + expectInvalidRequestWithMessage_exception2 + " to contain " + expectedExceptionMessage));
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities() {
        return this.matchUserClientEntities;
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities() {
        return this.matchIpEntities;
    }

    private void setupDescribeClientQuotasMatchTest() {
        scala.collection.immutable.Map userClientQuotas = this.matchUserClientEntities().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
                double v = x0$1._2$mcD$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"request_percentage", (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map ipQuotas = this.matchIpEntities().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ClientQuotaEntity e = (ClientQuotaEntity)x0$2._1();
                double v = x0$2._2$mcD$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"connection_creation_rate", (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> result = this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)userClientQuotas.$plus$plus((IterableOnce)ipQuotas)), false);
        ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities())).foreach((Function1 & Serializable)e -> (Void)((KafkaFutureImpl)result.apply(e._1())).get(10L, TimeUnit.SECONDS));
    }

    @ClusterTest
    public void testDescribeClientQuotasMatchExact() {
        this.setupDescribeClientQuotasMatchTest();
        this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-2")), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-1")), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-2"), (Object)new Some(null)), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-4"), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)new Some(null), (Object)new Some((Object)"client-id-2")), (List)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-1")), (List)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-3")), (List)Nil$.MODULE$))))))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Option u = (Option)x0$2._1();
                Option c = (Option)x0$2._2();
                return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)Option$.MODULE$.option2Iterable(u.map((Function1 & Serializable)x$1 -> new Tuple2((Object)"user", x$1))).$plus$plus((IterableOnce)c.map((Function1 & Serializable)x$2 -> new Tuple2((Object)"client-id", x$2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
            }
            throw new MatchError(null);
        }).foreach((Function1 & Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$7(this, e);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testDescribeClientQuotasMatchPartial() {
        void var166_130;
        Tuple2 tuple2;
        void testMatchEntities$1_expectedMatchSize;
        void testMatchEntities$1_partition;
        Object var153_120;
        Tuple2 tuple22;
        void testMatchEntities$1_expectedMatchSize2;
        void testMatchEntities$1_partition2;
        Object var140_110;
        Tuple2 tuple23;
        void testMatchEntities$1_expectedMatchSize3;
        void testMatchEntities$1_partition3;
        Object var127_100;
        Tuple2 tuple24;
        void testMatchEntities$1_expectedMatchSize4;
        void testMatchEntities$1_partition4;
        Object var114_90;
        Tuple2 tuple25;
        void testMatchEntities$1_expectedMatchSize5;
        void testMatchEntities$1_partition5;
        Object var101_80;
        Tuple2 tuple26;
        void testMatchEntities$1_expectedMatchSize6;
        void testMatchEntities$1_partition6;
        Object var88_70;
        Tuple2 tuple27;
        void testMatchEntities$1_expectedMatchSize7;
        void testMatchEntities$1_partition7;
        Object var75_60;
        Tuple2 tuple28;
        void testMatchEntities$1_expectedMatchSize8;
        void testMatchEntities$1_partition8;
        Object var62_50;
        Tuple2 tuple29;
        void testMatchEntities$1_expectedMatchSize9;
        void testMatchEntities$1_partition9;
        Object var49_40;
        Tuple2 tuple210;
        void testMatchEntities$1_expectedMatchSize10;
        void testMatchEntities$1_partition10;
        Object var36_30;
        Tuple2 tuple211;
        void testMatchEntities$1_expectedMatchSize11;
        void testMatchEntities$1_partition11;
        Object var23_20;
        Tuple2 tuple212;
        void testMatchEntities$1_expectedMatchSize12;
        void testMatchEntities$1_partition12;
        Object var10_10;
        Tuple2 tuple213;
        void testMatchEntities$1_partition13;
        this.setupDescribeClientQuotasMatchTest();
        Function1 & Serializable intersect = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$5(entity));
        int testMatchEntities$1_expectedMatchSize13 = 3;
        ClientQuotaFilter testMatchEntities$1_filter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-1"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect2 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter, (Function1)testMatchEntities$1_partition13, testMatchEntities$1_expectedMatchSize13);
        long l = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple213 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime + testMatchEntities$1_tryUntilNoAssertionError_waitTime) {
                tuple213 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple214 = tuple213;
        if (tuple214 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either = (Either)tuple214._1();
        if (!(var10_10 instanceof Left)) {
            if (var10_10 instanceof Right) {
                throw (AssertionError)((Right)var10_10).value();
            }
            throw new MatchError((Object)var10_10);
        }
        ((Left)var10_10).value();
        intersect2 = null;
        tuple214 = null;
        var10_10 = null;
        Object var1_3 = null;
        intersect = null;
        Function1 & Serializable intersect3 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$6(entity));
        boolean bl = false;
        ClientQuotaFilter testMatchEntities$1_filter2 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"unknown"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect4 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter2, (Function1)testMatchEntities$1_partition12, (int)testMatchEntities$1_expectedMatchSize12);
        long l2 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime2 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple212 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime2 + testMatchEntities$1_tryUntilNoAssertionError_waitTime2) {
                tuple212 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime2), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var26_18 = null;
        Tuple2 tuple215 = tuple212;
        if (tuple215 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either2 = (Either)tuple215._1();
        if (!(var23_20 instanceof Left)) {
            if (var23_20 instanceof Right) {
                throw (AssertionError)((Right)var23_20).value();
            }
            throw new MatchError((Object)var23_20);
        }
        ((Left)var23_20).value();
        intersect4 = null;
        tuple215 = null;
        var23_20 = null;
        Object var14_13 = null;
        intersect3 = null;
        Function1 & Serializable intersect5 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$7(entity));
        int n = 2;
        ClientQuotaFilter testMatchEntities$1_filter3 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-2"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect6 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter3, (Function1)testMatchEntities$1_partition11, (int)testMatchEntities$1_expectedMatchSize11);
        long l3 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime3 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime3 + testMatchEntities$1_tryUntilNoAssertionError_waitTime3) {
                tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime3), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var39_28 = null;
        Tuple2 tuple216 = tuple211;
        if (tuple216 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either3 = (Either)tuple216._1();
        if (!(var36_30 instanceof Left)) {
            if (var36_30 instanceof Right) {
                throw (AssertionError)((Right)var36_30).value();
            }
            throw new MatchError((Object)var36_30);
        }
        ((Left)var36_30).value();
        intersect6 = null;
        tuple216 = null;
        var36_30 = null;
        Object var27_23 = null;
        intersect5 = null;
        Function1 & Serializable intersect7 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$8(entity));
        int n2 = 2;
        ClientQuotaFilter testMatchEntities$1_filter4 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect8 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter4, (Function1)testMatchEntities$1_partition10, (int)testMatchEntities$1_expectedMatchSize10);
        long l4 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime4 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime4 + testMatchEntities$1_tryUntilNoAssertionError_waitTime4) {
                tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime4), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var52_38 = null;
        Tuple2 tuple217 = tuple210;
        if (tuple217 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either4 = (Either)tuple217._1();
        if (!(var49_40 instanceof Left)) {
            if (var49_40 instanceof Right) {
                throw (AssertionError)((Right)var49_40).value();
            }
            throw new MatchError((Object)var49_40);
        }
        ((Left)var49_40).value();
        intersect8 = null;
        tuple217 = null;
        var49_40 = null;
        Object var40_33 = null;
        intersect7 = null;
        Function1 & Serializable intersect9 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$9(entity));
        boolean bl2 = true;
        ClientQuotaFilter testMatchEntities$1_filter5 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-2"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect10 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter5, (Function1)testMatchEntities$1_partition9, (int)testMatchEntities$1_expectedMatchSize9);
        long l5 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime5 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime5 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime5 + testMatchEntities$1_tryUntilNoAssertionError_waitTime5) {
                tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime5), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var65_48 = null;
        Tuple2 tuple218 = tuple29;
        if (tuple218 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either5 = (Either)tuple218._1();
        if (!(var62_50 instanceof Left)) {
            if (var62_50 instanceof Right) {
                throw (AssertionError)((Right)var62_50).value();
            }
            throw new MatchError((Object)var62_50);
        }
        ((Left)var62_50).value();
        intersect10 = null;
        tuple218 = null;
        var62_50 = null;
        Object var53_43 = null;
        intersect9 = null;
        Function1 & Serializable intersect11 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$10(entity));
        boolean bl3 = false;
        ClientQuotaFilter testMatchEntities$1_filter6 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-1"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect12 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter6, (Function1)testMatchEntities$1_partition8, (int)testMatchEntities$1_expectedMatchSize8);
        long l6 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime6 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime6 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime6 + testMatchEntities$1_tryUntilNoAssertionError_waitTime6) {
                tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime6), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var78_58 = null;
        Tuple2 tuple219 = tuple28;
        if (tuple219 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either6 = (Either)tuple219._1();
        if (!(var75_60 instanceof Left)) {
            if (var75_60 instanceof Right) {
                throw (AssertionError)((Right)var75_60).value();
            }
            throw new MatchError((Object)var75_60);
        }
        ((Left)var75_60).value();
        intersect12 = null;
        tuple219 = null;
        var75_60 = null;
        Object var66_53 = null;
        intersect11 = null;
        Function1 & Serializable intersect13 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$11(entity));
        int n3 = 4;
        ClientQuotaFilter testMatchEntities$1_filter7 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect14 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter7, (Function1)testMatchEntities$1_partition7, (int)testMatchEntities$1_expectedMatchSize7);
        long l7 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime7 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime7 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime7 + testMatchEntities$1_tryUntilNoAssertionError_waitTime7) {
                tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime7), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var91_68 = null;
        Tuple2 tuple220 = tuple27;
        if (tuple220 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either7 = (Either)tuple220._1();
        if (!(var88_70 instanceof Left)) {
            if (var88_70 instanceof Right) {
                throw (AssertionError)((Right)var88_70).value();
            }
            throw new MatchError((Object)var88_70);
        }
        ((Left)var88_70).value();
        intersect14 = null;
        tuple220 = null;
        var88_70 = null;
        Object var79_63 = null;
        intersect13 = null;
        Function1 & Serializable intersect15 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$12(entity));
        int n4 = 10;
        ClientQuotaFilter testMatchEntities$1_filter8 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect16 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter8, (Function1)testMatchEntities$1_partition6, (int)testMatchEntities$1_expectedMatchSize6);
        long l8 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime8 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime8 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime8 + testMatchEntities$1_tryUntilNoAssertionError_waitTime8) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime8), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var104_78 = null;
        Tuple2 tuple221 = tuple26;
        if (tuple221 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either8 = (Either)tuple221._1();
        if (!(var101_80 instanceof Left)) {
            if (var101_80 instanceof Right) {
                throw (AssertionError)((Right)var101_80).value();
            }
            throw new MatchError((Object)var101_80);
        }
        ((Left)var101_80).value();
        intersect16 = null;
        tuple221 = null;
        var101_80 = null;
        Object var92_73 = null;
        intersect15 = null;
        Function1 & Serializable intersect17 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$13(entity));
        boolean bl4 = true;
        ClientQuotaFilter testMatchEntities$1_filter9 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"client-id"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect18 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter9, (Function1)testMatchEntities$1_partition5, (int)testMatchEntities$1_expectedMatchSize5);
        long l9 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime9 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime9 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime9 + testMatchEntities$1_tryUntilNoAssertionError_waitTime9) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime9), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var117_88 = null;
        Tuple2 tuple222 = tuple25;
        if (tuple222 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either9 = (Either)tuple222._1();
        if (!(var114_90 instanceof Left)) {
            if (var114_90 instanceof Right) {
                throw (AssertionError)((Right)var114_90).value();
            }
            throw new MatchError((Object)var114_90);
        }
        ((Left)var114_90).value();
        intersect18 = null;
        tuple222 = null;
        var114_90 = null;
        Object var105_83 = null;
        intersect17 = null;
        Function1 & Serializable intersect19 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$14(entity));
        int n5 = 7;
        ClientQuotaFilter testMatchEntities$1_filter10 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"client-id"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect20 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter10, (Function1)testMatchEntities$1_partition4, (int)testMatchEntities$1_expectedMatchSize4);
        long l10 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime10 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime10 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime10 + testMatchEntities$1_tryUntilNoAssertionError_waitTime10) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime10), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var130_98 = null;
        Tuple2 tuple223 = tuple24;
        if (tuple223 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either10 = (Either)tuple223._1();
        if (!(var127_100 instanceof Left)) {
            if (var127_100 instanceof Right) {
                throw (AssertionError)((Right)var127_100).value();
            }
            throw new MatchError((Object)var127_100);
        }
        ((Left)var127_100).value();
        intersect20 = null;
        tuple223 = null;
        var127_100 = null;
        Object var118_93 = null;
        intersect19 = null;
        Function1 & Serializable intersect21 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$15(entity));
        int n6 = 2;
        ClientQuotaFilter testMatchEntities$1_filter11 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"ip"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect22 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter11, (Function1)testMatchEntities$1_partition3, (int)testMatchEntities$1_expectedMatchSize3);
        long l11 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime11 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime11 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime11 + testMatchEntities$1_tryUntilNoAssertionError_waitTime11) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime11), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var143_108 = null;
        Tuple2 tuple224 = tuple23;
        if (tuple224 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either11 = (Either)tuple224._1();
        if (!(var140_110 instanceof Left)) {
            if (var140_110 instanceof Right) {
                throw (AssertionError)((Right)var140_110).value();
            }
            throw new MatchError((Object)var140_110);
        }
        ((Left)var140_110).value();
        intersect22 = null;
        tuple224 = null;
        var140_110 = null;
        Object var131_103 = null;
        intersect21 = null;
        Function1 & Serializable intersect23 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$16(entity));
        int n7 = 13;
        ClientQuotaFilter testMatchEntities$1_filter12 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        JFunction0.mcV.sp & Serializable intersect24 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter12, (Function1)testMatchEntities$1_partition2, (int)testMatchEntities$1_expectedMatchSize2);
        long l12 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime12 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime12 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime12 + testMatchEntities$1_tryUntilNoAssertionError_waitTime12) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime12), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var156_118 = null;
        Tuple2 tuple225 = tuple22;
        if (tuple225 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either12 = (Either)tuple225._1();
        if (!(var153_120 instanceof Left)) {
            if (var153_120 instanceof Right) {
                throw (AssertionError)((Right)var153_120).value();
            }
            throw new MatchError((Object)var153_120);
        }
        ((Left)var153_120).value();
        intersect24 = null;
        tuple225 = null;
        var153_120 = null;
        Object var144_113 = null;
        intersect23 = null;
        Function1 & Serializable intersect25 = (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$17(x$3));
        boolean bl5 = false;
        ClientQuotaFilter testMatchEntities$1_filter13 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        JFunction0.mcV.sp & Serializable intersect26 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter13, (Function1)testMatchEntities$1_partition, (int)testMatchEntities$1_expectedMatchSize);
        long l13 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime13 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime13 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime13 + testMatchEntities$1_tryUntilNoAssertionError_waitTime13) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime13), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var169_128 = null;
        Tuple2 tuple226 = tuple2;
        if (tuple226 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either13 = (Either)tuple226._1();
        if (var166_130 instanceof Left) {
            ((Left)var166_130).value();
            return;
        }
        if (var166_130 instanceof Right) {
            throw (AssertionError)((Right)var166_130).value();
        }
        throw new MatchError((Object)var166_130);
    }

    @ClusterTest
    public void testClientQuotasUnsupportedEntityTypes() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"name")}))).asJava());
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty()));
    }

    @ClusterTest
    public void testClientQuotasSanitized() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user with spaces")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyDescribeEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Object> quotas) {
        void var8_11;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 5000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$1(this, entity, quotas);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var12_7 = null;
            Object var13_8 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        if (var8_11 instanceof Left) {
            ((Left)var8_11).value();
            return;
        }
        if (var8_11 instanceof Right) {
            throw (AssertionError)((Right)var8_11).value();
        }
        throw new MatchError((Object)var8_11);
    }

    private ClientQuotaEntity toClientEntity(Option<String> user, Option<String> clientId) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)Option$.MODULE$.option2Iterable(user.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), x$4))).$plus$plus((IterableOnce)clientId.map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), x$5)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private ClientQuotaEntity toIpEntity(Option<String> ip) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Option$.MODULE$.option2Iterable(ip.map((Function1 & Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), x$6))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describeClientQuotas(ClientQuotaFilter filter) {
        KafkaFutureImpl result = new KafkaFutureImpl();
        this.sendDescribeClientQuotasRequest(filter).complete(result);
        try {
            return (java.util.Map)result.get();
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private DescribeClientQuotasResponse sendDescribeClientQuotasRequest(ClientQuotaFilter filter) {
        DescribeClientQuotasRequest request = (DescribeClientQuotasRequest)new DescribeClientQuotasRequest.Builder(filter).build();
        return (DescribeClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(DescribeClientQuotasResponse.class));
    }

    private Void alterEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Option<Object>> alter, boolean validateOnly) {
        try {
            return (Void)((KafkaFutureImpl)this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), alter)}))), validateOnly).apply((Object)entity)).get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> alterClientQuotas(scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>> request, boolean validateOnly) {
        scala.collection.immutable.Iterable entries = (scala.collection.immutable.Iterable)request.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
                scala.collection.immutable.Map alter = (scala.collection.immutable.Map)x0$1._2();
                Collection ops = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alter.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String key = (String)x0$2._1();
                        Option value = (Option)x0$2._2();
                        return new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> ClientQuotasRequestTest.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(null);
                })).asJavaCollection();
                return new ClientQuotaAlteration(entity, ops);
            }
            throw new MatchError(null);
        });
        java.util.Map response = CollectionConverters$.MODULE$.MapHasAsJava((Map)request.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)new KafkaFutureImpl()))).asJava();
        this.sendAlterClientQuotasRequest((Iterable<ClientQuotaAlteration>)entries, validateOnly).complete(response);
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(response).asScala();
        Assertions.assertEquals((int)request.size(), (int)result.size());
        request.foreach((Function1 & Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$alterClientQuotas$5(result, e);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    private AlterClientQuotasResponse sendAlterClientQuotasRequest(Iterable<ClientQuotaAlteration> entries, boolean validateOnly) {
        AlterClientQuotasRequest request = (AlterClientQuotasRequest)new AlterClientQuotasRequest.Builder(CollectionConverters$.MODULE$.IterableHasAsJava(entries).asJavaCollection(), validateOnly).build();
        return (AlterClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(AlterClientQuotasResponse.class));
    }

    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$2(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map props = (java.util.Map)x0$1._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"connection_creation_rate"})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(props).asScala().keySet());
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)), (Double)((Double)props.get("connection_creation_rate")));
            String entityName = (String)entity.entries().get("ip");
            InetAddress entityIp = entityName == null ? InetAddress.getByName(unknownHost$1) : InetAddress.getByName(entityName);
            int currentServerQuota = ((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokerSocketServers()).asScala().head()).connectionQuotas().connectionRateForIp(entityIp);
            Assertions.assertTrue((Math.abs(BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)) - (double)currentServerQuota) < 0.01 ? 1 : 0) != 0, (String)("Connection quota of " + entity + " is not " + expectedMatches$1.apply((Object)entity) + " but " + currentServerQuota));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$1(ClientQuotasRequestTest $this, ClientQuotaFilterComponent entityFilter$1, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1) {
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entityFilter$1, (List)Nil$.MODULE$)).asJava()));
        Assertions.assertEquals((Object)expectedMatches$1.keySet(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().keySet());
        CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$2($this, expectedMatches$1, unknownHost$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyIpQuotas$1(ClientQuotaFilterComponent entityFilter, scala.collection.immutable.Map expectedMatches, String unknownHost$1) {
        void var9_12;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$1(this, entityFilter, expectedMatches, unknownHost$1);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var13_8 = null;
            Object var14_9 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        if (var9_12 instanceof Left) {
            ((Left)var9_12).value();
            return;
        }
        if (var9_12 instanceof Right) {
            throw (AssertionError)((Right)var9_12).value();
        }
        throw new MatchError((Object)var9_12);
    }

    private final java.util.Map matchEntity$1(ClientQuotaEntity entity) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(entity.entries()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                switch (entityName == null ? 0 : entityName.hashCode()) {
                    case 0: {
                        if (entityName != null) break;
                        return ClientQuotaFilterComponent.ofDefaultEntity((String)entityType);
                    }
                }
                return ClientQuotaFilterComponent.ofEntity((String)entityType, (String)entityName);
            }
            throw new MatchError(null);
        });
        return this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components.toList()).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$3(ClientQuotasRequestTest $this, ClientQuotaEntity e$1, double v$1) {
        java.util.Map result = $this.matchEntity$1(e$1);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((result.get(e$1) != null ? 1 : 0) != 0);
        Double value = (Double)((java.util.Map)result.get(e$1)).get("request_percentage");
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((double)Predef$.MODULE$.Double2double(value), (double)v$1, (double)1.0E-6);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$2(ClientQuotasRequestTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var10_12;
            Tuple2 tuple2;
            ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
            double v = x0$1._2$mcD$sp();
            long l = 100L;
            long tryUntilNoAssertionError_waitTime = 15000L;
            long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void tryUntilNoAssertionError_pause;
                Right right;
                try {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$3($this, e, v);
                    BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                    right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
                }
                catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                    right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                }
                Object var14_8 = null;
                Object var15_9 = null;
                Right tryUntilNoAssertionError_computeUntilTrue_result = right;
                if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
            }
            Object var13_7 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Either tryUntilNoAssertionError_either = (Either)tuple22._1();
            if (!(var10_12 instanceof Left)) {
                if (var10_12 instanceof Right) {
                    throw (AssertionError)((Right)var10_12).value();
                }
                throw new MatchError((Object)var10_12);
            }
            BoxedUnit cfr_ignored_0 = (BoxedUnit)((Left)var10_12).value();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$7(ClientQuotasRequestTest $this, ClientQuotaEntity e) {
        java.util.Map result = $this.matchEntity$1(e);
        Assertions.assertEquals((int)0, (int)result.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$2(Function1 partition$1, Tuple2 e) {
        return BoxesRunTime.unboxToBoolean((Object)partition$1.apply(e._1()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$3(scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            double expectedValue = x0$1._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get("request_percentage");
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$4(scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$2._1();
            double expectedValue = x0$2._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get("connection_creation_rate");
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$1(ClientQuotasRequestTest $this, ClientQuotaFilter filter$1, Function1 partition$1, int expectedMatchSize$1) {
        void var6_6;
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(filter$1);
        Tuple2 tuple2 = ((List)$this.matchUserClientEntities().$plus$plus($this.matchIpEntities())).partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(partition$1, e)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List expectedMatches = (List)tuple2._1();
        Assertions.assertEquals((int)expectedMatchSize$1, (int)var6_6.size());
        Assertions.assertEquals((int)expectedMatchSize$1, (int)result.size(), (String)("Failed to match " + expectedMatchSize$1 + " entities for " + filter$1));
        scala.collection.immutable.Map expectedMatchesMap = var6_6.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        $this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(expectedMatchesMap, result, x0$1);
            return BoxedUnit.UNIT;
        });
        $this.matchIpEntities().foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(expectedMatchesMap, result, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void testMatchEntities$1(ClientQuotaFilter filter, int expectedMatchSize, Function1 partition) {
        void var9_16;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                Object var17_13;
                java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> $anonfun$testDescribeClientQuotasMatchPartial$1_result = this.describeClientQuotas(filter);
                Tuple2 tuple22 = ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities())).partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(partition$1, e)));
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                List $anonfun$testDescribeClientQuotasMatchPartial$1_expectedMatches = (List)tuple22._1();
                Assertions.assertEquals((int)expectedMatchSize, (int)var17_13.size());
                Assertions.assertEquals((int)expectedMatchSize, (int)$anonfun$testDescribeClientQuotasMatchPartial$1_result.size(), (String)("Failed to match " + expectedMatchSize + " entities for " + filter));
                scala.collection.immutable.Map $anonfun$testDescribeClientQuotasMatchPartial$1_expectedMatchesMap = var17_13.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(expectedMatchesMap, result, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.matchIpEntities().foreach((Function1 & Serializable)x0$2 -> {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(expectedMatchesMap, result, x0$2);
                    return BoxedUnit.UNIT;
                });
                Object var15_11 = null;
                tuple22 = null;
                var17_13 = null;
                Object var18_14 = null;
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var13_8 = null;
            Object var14_9 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple23 = tuple2;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple23._1();
        if (var9_16 instanceof Left) {
            ((Left)var9_16).value();
            return;
        }
        if (var9_16 instanceof Right) {
            throw (AssertionError)((Right)var9_16).value();
        }
        throw new MatchError((Object)var9_16);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$5(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-1";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$6(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$7(ClientQuotaEntity entity) {
        Object v = entity.entries().get("client-id");
        String string = "client-id-2";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$8(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && entity.entries().get("user") == null;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$9(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-2";
        return v != null && v.equals(string) && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$10(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$11(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$12(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$13(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id") && !entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$14(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$15(ClientQuotaEntity entity) {
        return entity.entries().containsKey("ip");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$16(ClientQuotaEntity entity) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$17(ClientQuotaEntity x$3) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$5(java.util.Map configs$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            double v = x0$2._2$mcD$sp();
            Double value = (Double)configs$1.get(k);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((double)v, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$1(ClientQuotasRequestTest $this, ClientQuotaEntity entity$3, scala.collection.immutable.Map quotas$1) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(entity$3.entries()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                return (ClientQuotaFilterComponent)Option$.MODULE$.apply((Object)entityName).map((Function1 & Serializable)name -> ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name)).getOrElse((Function0 & Serializable)() -> ClientQuotaFilterComponent.ofDefaultEntity((String)entityType));
            }
            throw new MatchError(null);
        });
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describe = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components.toList()).asJava()));
        if (quotas$1.isEmpty()) {
            Assertions.assertEquals((int)0, (int)describe.size());
            return;
        }
        Assertions.assertEquals((int)1, (int)describe.size());
        java.util.Map<String, Double> configs = describe.get(entity$3);
        Assertions.assertNotNull(configs);
        Assertions.assertEquals((int)quotas$1.size(), (int)configs.size());
        quotas$1.foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$5(configs, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public static final /* synthetic */ void $anonfun$alterClientQuotas$5(scala.collection.mutable.Map result$3, Tuple2 e) {
        Assertions.assertTrue((boolean)result$3.contains(e._1()));
    }

    public ClientQuotasRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.matchUserClientEntities = ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)50.5)), new Tuple3((Object)new Some((Object)"user-2"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)51.51)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)52.52)), new Tuple3((Object)new Some(null), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)53.53)), new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)54.54)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)55.55)), new Tuple3((Object)new Some((Object)"user-1"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)56.56)), new Tuple3((Object)new Some((Object)"user-2"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)57.57)), new Tuple3((Object)new Some((Object)"user-3"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)58.58)), new Tuple3((Object)new Some(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)59.59)), new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)60.6))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Option u = (Option)x0$1._1();
                Option c = (Option)x0$1._2();
                double v = BoxesRunTime.unboxToDouble((Object)x0$1._3());
                return new Tuple2((Object)this.toClientEntity((Option<String>)u, (Option<String>)c), (Object)BoxesRunTime.boxToDouble((double)v));
            }
            throw new MatchError(null);
        });
        this.matchIpEntities = new .colon.colon((Object)new Tuple2((Object)new Some((Object)"1.2.3.4"), (Object)BoxesRunTime.boxToDouble((double)10.0)), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"2.3.4.5"), (Object)BoxesRunTime.boxToDouble((double)20.0)), (List)Nil$.MODULE$)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Some ip = (Some)x0$2._1();
                double quota = x0$2._2$mcD$sp();
                return new Tuple2((Object)this.toIpEntity((Option<String>)ip), (Object)BoxesRunTime.boxToDouble((double)quota));
            }
            throw new MatchError(null);
        });
    }
}

