/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00194AAC\u0006\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C!3!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C\u0001g!)!\b\u0001C\u0001g!)A\b\u0001C\u0001g!)a\b\u0001C\u0001g!)\u0001\t\u0001C\u0005\u0003\"9!\fAI\u0001\n\u0013Y&a\n#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e+fgRT!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0003\u0001E\u0001\"AE\n\u000e\u0003-I!\u0001F\u0006\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\f\u0011\u0005I\u0001\u0011!B:fiV\u0003HC\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0011)f.\u001b;\t\u000b\u0005\u0012\u0001\u0019\u0001\u0012\u0002\u0011Q,7\u000f^%oM>\u0004\"a\t\u0017\u000e\u0003\u0011R!!\n\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0002(Q\u00059!.\u001e9ji\u0016\u0014(BA\u0015+\u0003\u0015QWO\\5u\u0015\u0005Y\u0013aA8sO&\u0011Q\u0006\n\u0002\t)\u0016\u001cH/\u00138g_\"\u0012!a\f\t\u0003GAJ!!\r\u0013\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\nuKN$H)Z:de&\u0014WMT8uQ&tw\rF\u0001\u001bQ\t\u0019Q\u0007\u0005\u0002$m%\u0011q\u0007\n\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$H)Z:de&\u0014WmV5uQ:+H\u000e\u001c\u0015\u0003\tU\n\u0011\u0004^3ti\u0012+7o\u0019:jE\u0016tu\u000e^\"p]R\u0014x\u000e\u001c7fe\"\u0012Q!N\u0001\u001ai\u0016\u001cH\u000fR3tGJL'-Z*b[\u0016,6/\u001a:Uo&\u001cW\r\u000b\u0002\u0007k\u0005yA/Z:u+:\\gn\\<o+N,'\u000f\u000b\u0002\bk\u000593/\u001a8e\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u)\r\u0011UJ\u0015\t\u0003\u0007.k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003\u000f\"\u000baaY8n[>t'B\u0001\bJ\u0015\tQ%&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0019\u0012\u0013A\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a\u0005\u0006\u001d\"\u0001\raT\u0001\be\u0016\fX/Z:u!\t\u0019\u0005+\u0003\u0002R\t\n\u0019C)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$\bbB*\t!\u0003\u0005\r\u0001V\u0001\rg>\u001c7.\u001a;TKJ4XM\u001d\t\u0003+bk\u0011A\u0016\u0006\u0003/6\tqA\\3uo>\u00148.\u0003\u0002Z-\na1k\\2lKR\u001cVM\u001d<fe\u0006\t4/\u001a8e\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T#\u0001/+\u0005Qk6&\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017!C;oG\",7m[3e\u0015\t\u0019G$\u0001\u0006b]:|G/\u0019;j_:L!!\u001a1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DescribeUserScramCredentialsRequestTest
extends BaseRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.serverConfig().setProperty("authorizer.class.name", StandardAuthorizer.class.getName());
        this.serverConfig().setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
        super.setUp(testInfo);
    }

    @Test
    public void testDescribeNothing() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.adminSocketServer());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @Test
    public void testDescribeWithNull() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(null)).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.adminSocketServer());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @Test
    public void testDescribeNotController() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        short error = this.sendDescribeUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Did not expect controller error when routed to non-controller");
    }

    @Test
    public void testDescribeSameUserTwice() {
        String user = "user1";
        DescribeUserScramCredentialsRequestData.UserName userName = new DescribeUserScramCredentialsRequestData.UserName().setName(user);
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)userName, (List)new .colon.colon((Object)userName, (List)Nil$.MODULE$))).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.adminSocketServer());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.DUPLICATE_RESOURCE.code(), (short)result.errorCode(), (String)("Expected duplicate resource error for " + user));
        Assertions.assertEquals((Object)("Cannot describe SCRAM credentials for the same user twice in a single request: " + user), (Object)result.errorMessage());
    }

    @Test
    public void testUnknownUser() {
        String unknownUser = "unknownUser";
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeUserScramCredentialsRequestData.UserName().setName(unknownUser), (List)Nil$.MODULE$)).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.adminSocketServer());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.RESOURCE_NOT_FOUND.code(), (short)result.errorCode(), (String)("Expected duplicate resource error for " + unknownUser));
        Assertions.assertEquals((Object)("Attempt to describe a user credential that does not exist: " + unknownUser), (Object)result.errorMessage());
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }
}

