/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import kafka.network.SocketServer;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class IntegrationTestUtils$ {
    public static final IntegrationTestUtils$ MODULE$ = new IntegrationTestUtils$();
    private static int correlationId = 0;

    public void sendRequest(Socket socket, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length);
        outgoing.write(request);
        outgoing.flush();
    }

    private void sendWithHeader(AbstractRequest request, RequestHeader header, Socket socket) {
        byte[] serializedBytes = Utils.toArray((ByteBuffer)request.serializeWithHeader(header));
        this.sendRequest(socket, serializedBytes);
    }

    public <T extends AbstractResponse> RequestHeader nextRequestHeader(ApiKeys apiKey, short apiVersion, String clientId, Option<Object> correlationIdOpt) {
        int correlationId = BoxesRunTime.unboxToInt((Object)correlationIdOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            MODULE$.correlationId_$eq(MODULE$.correlationId() + 1);
            return MODULE$.correlationId();
        }));
        return new RequestHeader(apiKey, apiVersion, clientId, correlationId);
    }

    public <T extends AbstractResponse> String nextRequestHeader$default$3() {
        return "client-id";
    }

    public <T extends AbstractResponse> Option<Object> nextRequestHeader$default$4() {
        return None$.MODULE$;
    }

    public void send(AbstractRequest request, Socket socket, String clientId, Option<Object> correlationId) {
        RequestHeader header = this.nextRequestHeader(request.apiKey(), request.version(), clientId, correlationId);
        this.sendWithHeader(request, header, socket);
    }

    public String send$default$3() {
        return "client-id";
    }

    public Option<Object> send$default$4() {
        return None$.MODULE$;
    }

    public <T extends AbstractResponse> T receive(Socket socket, ApiKeys apiKey, short version, ClassTag<T> classTag) {
        Option option;
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        byte[] responseBytes = new byte[incoming.readInt()];
        incoming.readFully(responseBytes);
        ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
        ResponseHeader.parse((ByteBuffer)responseBuffer, (short)apiKey.responseHeaderVersion(version));
        AbstractResponse abstractResponse = AbstractResponse.parseResponse((ApiKeys)apiKey, (Readable)new ByteBufferAccessor(responseBuffer), (short)version);
        if (abstractResponse != null && !(option = classTag.unapply((Object)abstractResponse)).isEmpty() && option.get() != null) {
            return (T)abstractResponse;
        }
        throw new ClassCastException("Expected response with type " + classTag.runtimeClass() + ", but found " + abstractResponse.getClass());
    }

    public <T extends AbstractResponse> T sendAndReceive(AbstractRequest request, Socket socket, String clientId, Option<Object> correlationId, ClassTag<T> classTag) {
        this.send(request, socket, clientId, correlationId);
        return this.receive(socket, request.apiKey(), request.version(), classTag);
    }

    public <T extends AbstractResponse> String sendAndReceive$default$3() {
        return "client-id";
    }

    public <T extends AbstractResponse> Option<Object> sendAndReceive$default$4() {
        return None$.MODULE$;
    }

    public <T extends AbstractResponse> T connectAndReceive(AbstractRequest request, SocketServer destination, ListenerName listenerName, ClassTag<T> classTag) {
        T t;
        try (Socket socket = this.connect(destination, listenerName);){
            t = this.sendAndReceive(request, socket, "client-id", (Option<Object>)None$.MODULE$, classTag);
        }
        return t;
    }

    private int correlationId() {
        return correlationId;
    }

    private void correlationId_$eq(int x$1) {
        correlationId = x$1;
    }

    public Socket connect(SocketServer socketServer, ListenerName listenerName) {
        return new Socket("localhost", socketServer.boundPort(listenerName));
    }

    private IntegrationTestUtils$() {
    }
}

