/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.server.BrokerServer;
import kafka.server.KafkaBroker;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.utils.TestUtils$Roll$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0001,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u0003Y\u0003B\u0002\u001c\u0001A\u0003%A\u0006C\u00048\u0001\t\u0007I\u0011\u0002\u001d\t\r\u0005\u0003\u0001\u0015!\u0003:\u0011\u001d\u0011\u0005A1A\u0005\n-Baa\u0011\u0001!\u0002\u0013a\u0003b\u0002#\u0001\u0005\u0004%\te\u000b\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002\u0017\t\u000b\u0019\u0003A\u0011I$\t\u000bq\u0003A\u0011A/\t\r}\u0004A\u0011AA\u0001\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\ti\t\u0001C\u0001\u0003\u001f\u0013\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u\u0015\tYB$\u0001\u0004tKJ4XM\u001d\u0006\u0002;\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001!!\t\tC%D\u0001#\u0015\t\u0019C$A\u0002ba&L!!\n\u0012\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u000e\u0002\u001bA\u0014x\u000eZ;dKJ\u001cu.\u001e8u+\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#aA%oi\u0006q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0013!D2p]N,X.\u001a:D_VtG/\u0001\bd_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001\rEJ|7.\u001a:D_VtG\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\ra\u0006\u0014H/\u001b;j_:tU/\\\u0001\u000ea\u0006\u0014H/\u001b;j_:tU/\u001c\u0011\u0002\u00171|w\rR5s\u0007>,h\u000e^\u0001\rY><G)\u001b:D_VtG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0011.\u0003\"!L%\n\u0005)s#\u0001B+oSRDQ\u0001\u0014\bA\u00025\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003\u001dZk\u0011a\u0014\u0006\u0003GAS!!\u0015*\u0002\u000f),\b/\u001b;fe*\u00111\u000bV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002+\u0006\u0019qN]4\n\u0005]{%\u0001\u0003+fgRLeNZ8)\u00059I\u0006C\u0001([\u0013\tYvJ\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0005^3tiB\u0013x\u000eZ;dK\u0016\u0013(o\u001c:Ge>lg)Y5mkJ,wJ\u001c'pOJ{G\u000e\u001c\u000b\u0003\u0011zCQaX\bA\u0002\u0001\fQb\u001a:pkB\u0004&o\u001c;pG>d\u0007CA1i\u001d\t\u0011g\r\u0005\u0002d]5\tAM\u0003\u0002f=\u00051AH]8pizJ!a\u001a\u0018\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015N\u0003\u0002h]!\"qb[9s!\taw.D\u0001n\u0015\tq\u0007+\u0001\u0004qCJ\fWn]\u0005\u0003a6\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003M\fqd\u001f3jgBd\u0017-\u001f(b[\u0016lhf\u001a:pkB\u0004&o\u001c;pG>dWh\u001f\u0019~Q\u0011yQo\u001f?\u0011\u0005YLX\"A<\u000b\u0005al\u0017\u0001\u00039s_ZLG-\u001a:\n\u0005i<(\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A?\"\u0003y\f\u0011eZ3u)\u0016\u001cHo\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\fQ\u0004^3ti2{w\rR5s\u001d>$\u0018NZ5dCRLwN\u001c+j[\u0016|W\u000f\u001e\u000b\u0004\u0011\u0006\r\u0001\"B0\u0011\u0001\u0004\u0001\u0007\u0006\u0002\tlcJDS\u0001E;|\u0003\u0013a\u0013!`\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7m)\rA\u0015q\u0002\u0005\u0006?F\u0001\r\u0001\u0019\u0015\u0005#-\f(\u000fK\u0003\u0012kn\f)\u0002L\u0001~\u0003\u001d\"Xm\u001d;Qe>$WoY3FeJ|'O\u0012:p[\u001a\u000b\u0017\u000e\\;sK>s7\t[3dWB|\u0017N\u001c;\u0015\u0007!\u000bY\u0002C\u0003`%\u0001\u0007\u0001\r\u000b\u0003\u0013WF\u0014\b&\u0002\nvw\u0006\u0005B&A?\u0002?Q,7\u000f^%P\u000bb\u001cW\r\u001d;j_:$UO]5oO\u000eCWmY6q_&tG\u000fF\u0002I\u0003OAQaX\nA\u0002\u0001DCaE6re\"*1#^>\u0002.1\nQ0\u0001\u001buKN$(+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fe\r^3s\u0019><G)\u001b:GC&dWO]3P]\u001a{G\u000e\\8xKJ$2\u0001SA\u001a\u0011\u0015yF\u00031\u0001aQ\u0011!2.\u001d:)\u000bQ)80!\u000f-\u0003u\f!\u0006^3tiB\u0013x\u000eZ;dK\u0016\u0013(o\u001c:t\rJ|W\u000eT8h\t&\u0014h)Y5mkJ,wJ\u001c'fC\u0012,'\u000fF\u0002I\u0003\u007fAq!!\u0011\u0016\u0001\u0004\t\u0019%A\u0006gC&dWO]3UsB,\u0007\u0003BA#\u0003/rA!a\u0012\u0002R9!\u0011\u0011JA'\u001d\r\u0019\u00171J\u0005\u0002;%\u0019\u0011q\n\u000f\u0002\u000bU$\u0018\u000e\\:\n\t\u0005M\u0013QK\u0001\n)\u0016\u001cH/\u0016;jYNT1!a\u0014\u001d\u0013\u0011\tI&a\u0017\u0003#1{w\rR5s\r\u0006LG.\u001e:f)f\u0004XM\u0003\u0003\u0002T\u0005U\u0013!\n;fgR\u0004&o\u001c3vG\u0016\fe\r^3s\u0019><G)\u001b:GC&dWO]3P]2+\u0017\rZ3s)\rA\u0015\u0011\r\u0005\b\u0003\u00032\u0002\u0019AA\"\u0003u\u0019XOY:de&\u0014W-\u00118e/\u0006LGOR8s\u0003N\u001c\u0018n\u001a8nK:$H#\u0002%\u0002h\u0005%\u0004\"B\u001c\u0018\u0001\u0004\u0001\u0007bBA6/\u0001\u0007\u0011QN\u0001\tG>t7/^7feBA\u0011qNA?\u0003\u0003\u000b\t)\u0004\u0002\u0002r)!\u00111NA:\u0015\u0011\t)(a\u001e\u0002\u000f\rd\u0017.\u001a8ug*\u0019Q$!\u001f\u000b\u0007\u0005mD+\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u007f\n\tH\u0001\u0005D_:\u001cX/\\3s!\u0015i\u00131QAD\u0013\r\t)I\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004[\u0005%\u0015bAAF]\t!!)\u001f;f\u0003I\u0019\u0017-^:f\u0019><G)\u001b:GC&dWO]3\u0015\u0011\u0005E\u0015QTAP\u0003S\u0003B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/k\u0014AA5p\u0013\u0011\tY*!&\u0003\t\u0019KG.\u001a\u0005\b\u0003\u0003B\u0002\u0019AA\"\u0011\u001d\t\t\u000b\u0007a\u0001\u0003G\u000bA\u0002\\3bI\u0016\u0014(I]8lKJ\u00042!KAS\u0013\r\t9K\u0007\u0002\f\u0017\u000647.\u0019\"s_.,'\u000fC\u0004\u0002,b\u0001\r!!,\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BAX\u0003kk!!!-\u000b\t\u0005M\u0016qO\u0001\u0007G>lWn\u001c8\n\t\u0005]\u0016\u0011\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0001")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.ensureConsistentKRaftMetadata();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testProduceErrorFromFailureOnLogRoll(String groupProtocol) {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Roll$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testLogDirNotificationTimeout(String groupProtocol) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        int leaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$1(x$1))).get()).leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$2(leaderServerId, x$2))).get();
        this.controllerServer().shutdown();
        this.controllerServer().awaitShutdown();
        this.causeLogDirFailure(TestUtils$Checkpoint$.MODULE$, leaderServer, partition);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$3(leaderServer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogDirFailureTest.$anonfun$testLogDirNotificationTimeout$4(leaderServer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        leaderServer.awaitShutdown();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testIOExceptionDuringLogRoll(String groupProtocol) {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Roll$.MODULE$);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testProduceErrorFromFailureOnCheckpoint(String groupProtocol) {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testIOExceptionDuringCheckpoint(String groupProtocol) {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower(String groupProtocol) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$3))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$4))).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), (ClassTag)ClassTag$.MODULE$.Int())), (Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 != leaderServerId).get());
        KafkaBroker followerServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$7))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable)i -> leaderServer.replicaManager().onlinePartition(new TopicPartition(this.topic(), i)).flatMap((Function1 & Serializable)x$8 -> x$8.leaderLogIfLocal()).isDefined()).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assertions.assertEquals((int)this.brokerCount(), (int)((Partition)leaderServer.replicaManager().onlinePartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicaIds().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceErrorsFromLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType) {
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(x$9))).get()).leader().id();
        KafkaBroker leaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(leaderServerId, x$10))).get();
        this.causeLogDirFailure(failureType, leaderServer, partition);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> producer.send(record).get(6000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((e.getCause() instanceof KafkaStorageException || e.getCause() instanceof NotLeaderOrFollowerException ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public void testProduceAfterLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int originalLeaderServerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$11))).get()).leader().id();
        KafkaBroker originalLeaderServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(originalLeaderServerId, x$12))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, 15000L);
        File failedLogDir = this.causeLogDirFailure(failureType, originalLeaderServer, partition);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$3(this, producer, record, originalLeaderServerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected new leader for the partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$6(this, originalLeaderServerId, failedLogDir)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Expected to find an offline log dir");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    private void subscribeAndWaitForAssignment(String topic, Consumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        long pollUntilTrue_waitTimeMs = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (LogDirFailureTest.$anonfun$subscribeAndWaitForAssignment$1(consumer)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected non-empty assignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public File causeLogDirFailure(TestUtils.LogDirFailureType failureType, KafkaBroker leaderBroker, TopicPartition partition) {
        File logDir = leaderBroker.replicaManager().localLogOrException(partition).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> Utils.delete((File)logDir), (Logging)this, Level.WARN);
        Files.createFile(logDir.toPath(), new FileAttribute[0]);
        Assertions.assertTrue((boolean)logDir.isFile());
        TestUtils.LogDirFailureType logDirFailureType = failureType;
        TestUtils$Roll$ testUtils$Roll$ = TestUtils$Roll$.MODULE$;
        if (logDirFailureType != null && logDirFailureType.equals(testUtils$Roll$)) {
            Assertions.assertThrows(KafkaStorageException.class, () -> ((UnifiedLog)leaderBroker.replicaManager().getLog(partition).get()).roll());
        } else {
            TestUtils.LogDirFailureType logDirFailureType2 = failureType;
            TestUtils$Checkpoint$ testUtils$Checkpoint$ = TestUtils$Checkpoint$.MODULE$;
            if (logDirFailureType2 != null && logDirFailureType2.equals(testUtils$Checkpoint$)) {
                leaderBroker.replicaManager().checkpointHighWatermarks();
            }
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 3000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$causeLogDirFailure$3(leaderBroker, logDir)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected log directory offline");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)leaderBroker.replicaManager().localLog(partition).isEmpty());
        return logDir;
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$1(PartitionInfo x$1) {
        return x$1.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$2(int leaderServerId$1, KafkaBroker x$2) {
        return x$2.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testLogDirNotificationTimeout$3(KafkaBroker leaderServer$1) {
        BrokerState brokerState = leaderServer$1.brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testLogDirNotificationTimeout$4(KafkaBroker leaderServer$1) {
        return "Expected broker to be in NOT_RUNNING state but was " + leaderServer$1.brokerState();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$3) {
        return x$3.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$2, KafkaBroker x$4) {
        return x$4.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaBroker x$7) {
        return x$7.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assertions.assertFalse((boolean)thread.isShutdownComplete(), (String)"ReplicaFetcherThread should still be working if its partition count > 0");
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(PartitionInfo x$9) {
        return x$9.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(int leaderServerId$3, KafkaBroker x$10) {
        return x$10.config().brokerId() == leaderServerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$11) {
        return x$11.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int originalLeaderServerId$1, KafkaBroker x$12) {
        return x$12.config().brokerId() == originalLeaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$4(PartitionInfo x$13) {
        return x$13.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$3(LogDirFailureTest $this, KafkaProducer producer$2, ProducerRecord record$2, int originalLeaderServerId$1) {
        producer$2.send(record$2);
        return ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer$2.partitionsFor($this.topic())).asScala().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$4(x$13))).get()).leader().id() != originalLeaderServerId$1;
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$5() {
        return "Expected new leader for the partition";
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$7(int originalLeaderServerId$1, KafkaBroker x$14) {
        return x$14.config().nodeId() == originalLeaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$9(File failedLogDir$1, BrokerServer x$16) {
        return x$16.logDirFailureChannel().hasOfflineLogDir(((Object)failedLogDir$1.toPath()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$10(LogDirFailureTest $this, int originalLeaderServerId$1, BrokerServer broker) {
        return broker.replicaManager().metadataCache().getTopicMetadata(Set.of($this.topic()), broker.config().interBrokerListenerName(), false, false).stream().flatMap(t -> t.partitions().stream()).anyMatch(p -> p.partitionIndex() == 0 && p.offlineReplicas().contains(BoxesRunTime.boxToInteger((int)originalLeaderServerId$1)));
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$6(LogDirFailureTest $this, int originalLeaderServerId$1, File failedLogDir$1) {
        Option brokerWithDirFail = $this.brokers().find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$7(originalLeaderServerId$1, x$14))).map((Function1 & Serializable)x$15 -> (BrokerServer)x$15);
        return brokerWithDirFail.exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$9(failedLogDir$1, x$16))) && brokerWithDirFail.exists((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$10($this, originalLeaderServerId$1, broker)));
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$13() {
        return "Expected to find an offline log dir";
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForAssignment$1(Consumer consumer$1) {
        return !consumer$1.assignment().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public static final /* synthetic */ boolean $anonfun$causeLogDirFailure$3(KafkaBroker leaderBroker$1, File logDir$1) {
        return !leaderBroker$1.logManager().isLogDirOnline(logDir$1.getAbsolutePath());
    }

    public static final /* synthetic */ String $anonfun$causeLogDirFailure$4() {
        return "Expected log directory offline";
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty("replica.high.watermark.checkpoint.interval.ms", "60000");
        this.serverConfig().setProperty("num.replica.fetchers", "1");
        this.serverConfig().setProperty("log.dir.failure.timeout.ms", "5000");
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
    }
}

