/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}AQ!\t\u0001\u0005B\tBQ!\u000b\u0001\u0005R)BQ\u0001\u000f\u0001\u0005\u0002eBQa\u0012\u0001\u0005\u0002eBQa\u0015\u0001\u0005\u0002eBQ!\u0016\u0001\u0005\u0002eBQa\u0016\u0001\u0005\u0002eBQ!\u0017\u0001\u0005\u0002eBQa\u0017\u0001\u0005\u0002eBQ!\u0018\u0001\u0005\u0002eBQa\u0018\u0001\u0005\n\u0001DQ\u0001\u001a\u0001\u0005\n\u0015DQA\u001e\u0001\u0005\n]Daa \u0001\u0005\n\u0005\u0005\u0001bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\t\u0019\f\u0001C\u0005\u0003k\u0013Q\u0002T8h\u001f\u001a47/\u001a;UKN$(BA\u000b\u0017\u0003\u0019\u0019XM\u001d<fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001d\u001b\u0005!\u0012BA\u000f\u0015\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001!!\tY\u0002!A\u0006ce>\\WM]\"pk:$X#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\u0007%sG/A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u00111F\f\t\u0003I1J!!L\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006_\r\u0001\r\u0001M\u0001\u0006aJ|\u0007o\u001d\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA!\u001e;jY*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005)\u0001&o\u001c9feRLWm]\u0001\u001ei\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\r>\u0014XK\\6o_^tGk\u001c9jGR\t1\u0006\u000b\u0002\u0005wA\u0011A(R\u0007\u0002{)\u0011ahP\u0001\u0004CBL'B\u0001!B\u0003\u001dQW\u000f]5uKJT!AQ\"\u0002\u000b),h.\u001b;\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UH\u0001\u0003UKN$\u0018\u0001\t;fgR<U\r^(gMN,Go]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sINDc!B%M\u001b>\u0003\u0006C\u0001\u0013K\u0013\tYUE\u0001\u0006eKB\u0014XmY1uK\u0012\fq!\\3tg\u0006<W-I\u0001O\u0003Ua\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;!-B\nQa]5oG\u0016\f\u0013!U\u0001\u0001Q\t)1(\u0001\u001cuKN$h)\u001a;dQ>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007OR8s\u001b\u0006DH+[7fgR\fW\u000e]!gi\u0016\u0014HK];oG\u0006$X\r\u000b\u0002\u0007w\u0005\u0001E/Z:u\r\u0016$8\r[(gMN,GOQ=US6,7\u000f^1na\u001a{'/T1y)&lWm\u001d;b[B<\u0016\u000e\u001e5V]>\u0014H-\u001a:fIRKW.Z:uC6\u00048\u000f\u000b\u0002\bw\u0005qB/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016d\u0015\r^3tiRKW.\u001a\u0015\u0003\u0011m\nq\u0003^3ti\u0016k\u0007\u000f^=M_\u001e\u001cx)\u001a;PM\u001a\u001cX\r^:)\u0005%Y\u0014!\u000e;fgR4U\r^2i\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004hi\u001c:NCb$\u0016.\\3ti\u0006l\u0007oV5uQ\u0016k\u0007\u000f^=M_\u001eD#AC\u001e\u0002AQ,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u000b\u0006\u0014H.[3tiRKW.\u001a\u0015\u0003\u0017m\naA\u0019:pW\u0016\u0014X#A1\u0011\u0005m\u0011\u0017BA2\u0015\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0002-M,g\u000e\u001a'jgR|eMZ:fiN\u0014V-];fgR$\"AZ9\u0011\u0005\u001d|W\"\u00015\u000b\u0005%T\u0017\u0001\u0003:fcV,7\u000f^:\u000b\u0005-d\u0017AB2p[6|gN\u0003\u0002\u0018[*\u0011anQ\u0001\u0007CB\f7\r[3\n\u0005AD'a\u0005'jgR|eMZ:fiN\u0014Vm\u001d9p]N,\u0007\"\u0002:\u000e\u0001\u0004\u0019\u0018a\u0002:fcV,7\u000f\u001e\t\u0003ORL!!\u001e5\u0003%1K7\u000f^(gMN,Go\u001d*fcV,7\u000f^\u0001\u0011g\u0016tGMR3uG\"\u0014V-];fgR$\"\u0001_>\u0011\u0005\u001dL\u0018B\u0001>i\u000551U\r^2i%\u0016\u001c\bo\u001c8tK\")!O\u0004a\u0001yB\u0011q-`\u0005\u0003}\"\u0014ABR3uG\"\u0014V-];fgR\f\u0001CY;jY\u0012$\u0016M]4fiRKW.Z:\u0015\r\u0005\r\u0011qHA&!\u0019\t)!!\u0006\u0002\u001c9!\u0011qAA\t\u001d\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u00071\u00051AH]8pizJ\u0011AJ\u0005\u0004\u0003')\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003/\tIB\u0001\u0003MSN$(bAA\nKA!\u0011QDA\u001d\u001d\u0011\ty\"a\r\u000f\t\u0005\u0005\u0012\u0011\u0007\b\u0005\u0003G\tyC\u0004\u0003\u0002&\u00055b\u0002BA\u0014\u0003WqA!!\u0003\u0002*%\tA)\u0003\u0002o\u0007&\u0011q#\\\u0005\u0003W2L!\u0001\u00146\n\t\u0005U\u0012qG\u0001\u0017\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH\u000fR1uC*\u0011AJ[\u0005\u0005\u0003w\tiD\u0001\tMSN$xJ\u001a4tKR\u001cHk\u001c9jG*!\u0011QGA\u001c\u0011\u001d\t\te\u0004a\u0001\u0003\u0007\n!\u0001\u001e9\u0011\t\u0005\u0015\u0013qI\u0007\u0002U&\u0019\u0011\u0011\n6\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011QJ\bA\u0002\u0005=\u0013!\u0003;j[\u0016\u001cH/Y7q!\r!\u0013\u0011K\u0005\u0004\u0003'*#\u0001\u0002'p]\u001e\fQBZ5oIB\u000b'\u000f^5uS>tGCBA-\u0003O\n\t\t\u0005\u0003\u0002\\\u0005\u0005d\u0002BA\u0010\u0003;JA!a\u0018\u00028\u00059B*[:u\u001f\u001a47/\u001a;t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003G\n)G\u0001\u000fMSN$xJ\u001a4tKR\u001c\b+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\u0005}\u0013q\u0007\u0005\b\u0003S\u0002\u0002\u0019AA6\u0003\u0019!x\u000e]5dgB1\u0011QNA<\u0003wj!!a\u001c\u000b\t\u0005E\u00141O\u0001\b[V$\u0018M\u00197f\u0015\r\t)(J\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA=\u0003_\u0012aAQ;gM\u0016\u0014\b\u0003BA.\u0003{JA!a \u0002f\tAB*[:u\u001f\u001a47/\u001a;t)>\u0004\u0018n\u0019*fgB|gn]3\t\u000f\u0005\u0005\u0003\u00031\u0001\u0002D\u0005!2M]3bi\u0016$v\u000e]5d\u0003:$w)\u001a;M_\u001e$b!a\"\u0002\u001c\u0006=\u0006\u0003BAE\u0003/k!!a#\u000b\t\u00055\u0015qR\u0001\u0004Y><'\u0002BAI\u0003'\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005UE.A\u0004ti>\u0014\u0018mZ3\n\t\u0005e\u00151\u0012\u0002\u000b+:Lg-[3e\u0019><\u0007bBAO#\u0001\u0007\u0011qT\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003C\u000bIK\u0004\u0003\u0002$\u0006\u0015\u0006cAA\u0005K%\u0019\u0011qU\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\tY+!,\u0003\rM#(/\u001b8h\u0015\r\t9+\n\u0005\b\u0003c\u000b\u0002\u0019AA\"\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ#[:MK\u0006$WM\u001d'pG\u0006dwJ\u001c\"s_.,'\u000f\u0006\u0005\u00028\u0006u\u0016qXAb!\r!\u0013\u0011X\u0005\u0004\u0003w+#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003;\u0013\u0002\u0019AAP\u0011\u0019\t\tM\u0005a\u0001G\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u0015y&\u00031\u0001bQ\u001d\u0001\u0011qYAg\u0003\u001f\u00042\u0001PAe\u0013\r\tY-\u0010\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\t\tA\u0006")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)false).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L)).asJava()).build((short)1);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        log.deleteOldSegments();
        Optional<Object> offset = log.fetchOffsetByTimestamp(-1L, Optional.empty()).timestampAndOffsetOpt().map(x$2 -> BoxesRunTime.boxToLong((long)x$2.offset));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)20L)), offset);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)1, (int)1).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L)).asJava()).build();
        long consumerOffset = this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).offset();
        Assertions.assertEquals((long)20L, (long)consumerOffset);
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Optional firstOffset = log.fetchOffsetByTimestamp(-3L, Optional.empty()).timestampAndOffsetOpt();
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).offset);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).timestamp);
        log.truncateTo(0L);
        Assertions.assertEquals(Optional.empty(), (Object)log.fetchOffsetByTimestamp(-3L, Optional.empty()).timestampAndOffsetOpt());
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L}))).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Optional maxTimestampOffset = log.fetchOffsetByTimestamp(-3L, Optional.empty()).timestampAndOffsetOpt();
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        Assertions.assertEquals((long)5L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)6L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds((Seq<String>)new .colon.colon((Object)"kafka-", (List)Nil$.MODULE$))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$3 -> x$3.swap())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$4 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0));
        log.flush(false);
        Optional<Object> offset = log.fetchOffsetByTimestamp(-1L, Optional.empty()).timestampAndOffsetOpt().map(x$5 -> BoxesRunTime.boxToLong((long)x$5.offset));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)20L)), offset);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)1, (int)1).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L)).asJava()).build();
        long consumerOffset = this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).offset();
        Assertions.assertEquals((long)20L, (long)consumerOffset);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, consumerOffset, -1L, 307200, Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = TestUtils.tempDirectory(null, null).getAbsolutePath() + "/" + topic + "-" + topicPartition.partition();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)1, (int)1).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L)).asJava()).build();
            if (this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).offset() == 1L) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        Assertions.assertEquals((Object)new OffsetResultHolder(Optional.empty()), (Object)log.fetchOffsetByTimestamp(-3L, Optional.empty()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        Optional x$2 = Optional.empty();
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$5 = logManager.getOrCreateLog$default$5();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, x$2, x$5);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$7 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0));
        log.flush(false);
        Optional<Object> offset = log.fetchOffsetByTimestamp(-2L, Optional.empty()).timestampAndOffsetOpt().map(x$8 -> BoxesRunTime.boxToLong((long)x$8.offset));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), offset);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)1, (int)1).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L)).asJava()).build();
        long offsetFromResponse = this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).offset();
        Assertions.assertEquals((long)0L, (long)offsetFromResponse);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$9))).get()).partitions()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$10))).get();
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (UnifiedLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    private boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaBroker broker) {
        return broker.replicaManager().onlinePartition(new TopicPartition(topic, partitionId)).exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$isLeaderLocalOnBroker$1(x$11)));
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(UnifiedLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        NoCompression x$4 = Compression.NONE;
        byte x$5 = 2;
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, (Compression)x$4, x$2, x$5), 0);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(UnifiedLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        NoCompression x$4 = Compression.NONE;
        byte x$5 = 2;
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, (Compression)x$4, timestamp, x$5), 0);
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$9) {
        String string = x$9.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$10) {
        return x$10.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$3) {
        return logManager$1.getLog(topicPartition$3, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }

    public static final /* synthetic */ boolean $anonfun$isLeaderLocalOnBroker$1(Partition x$11) {
        return x$11.leaderLogIfLocal().isDefined();
    }
}

