/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.util.MockBlockingSender;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaFetch;
import org.apache.kafka.server.ReplicaState;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t5g\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004I\u0001\u0001\u0006I!\u0010\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003=\u0011\u0019Q\u0005\u0001)A\u0005{!91\n\u0001b\u0001\n\u0013a\u0004B\u0002'\u0001A\u0003%Q\bC\u0004N\u0001\t\u0007I\u0011\u0002(\t\rI\u0003\u0001\u0015!\u0003P\u0011\u001d\u0019\u0006A1A\u0005\n9Ca\u0001\u0016\u0001!\u0002\u0013y\u0005bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007O\u0002\u0001\u000b\u0011B,\t\u000f!\u0004!\u0019!C\u0005S\"1\u0011\u000f\u0001Q\u0001\n)DqA\u001d\u0001C\u0002\u0013%1\u000f\u0003\u0004x\u0001\u0001\u0006I\u0001\u001e\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u001d\t\t\u0001\u0001Q\u0001\niDq!a\u0001\u0001\t\u0013\t)\u0001C\u0005\u0002,\u0001\t\n\u0011\"\u0003\u0002.!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA2\u0001\u0011%\u0011Q\r\u0005\n\u0003\u0003\u0004\u0011\u0013!C\u0005\u0003\u0007Dq!a2\u0001\t\u0003\t)\u0005C\u0004\u0002R\u0002!\t!a5\t\u000f\u0005E\b\u0001\"\u0001\u0002F!9\u0011Q\u001f\u0001\u0005\u0002\u0005\u0015\u0003bBA}\u0001\u0011%\u00111 \u0005\b\u0005\u0007\u0001A\u0011AA#\u0011\u001d\u00119\u0001\u0001C\u0001\u0003\u000bBqAa\u0003\u0001\t\u0003\t)\u0005C\u0004\u0003\u0010\u0001!\t!!\u0012\t\u000f\tM\u0001\u0001\"\u0001\u0002F!9!q\u0003\u0001\u0005\u0002\u0005\u0015\u0003b\u0002B\u000e\u0001\u0011\u0005\u0011Q\t\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001bBqAa\u0013\u0001\t\u0013\u0011y\bC\u0004\u0003\u0018\u0002!IA!'\t\u000f\t}\u0005\u0001\"\u0001\u0003\"\nA\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$Vm\u001d;\u000b\u00051j\u0013AB:feZ,'OC\u0001/\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\b\u0005\u0002;\u00015\t1&\u0001\u0003ucA\u0004T#A\u001f\u0011\u0005y2U\"A \u000b\u0005\u0001\u000b\u0015AB2p[6|gN\u0003\u0002/\u0005*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9uH\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u000bQ\f\u0004\u000f\r\u0011\u0002\tQ\f\u0004/M\u0001\u0006iF\u0002\u0018\u0007I\u0001\u0005iJ\u0002\u0018'A\u0003ueA\f\u0004%\u0001\u0005u_BL7-\u001332+\u0005y\u0005C\u0001 Q\u0013\t\tvH\u0001\u0003Vk&$\u0017!\u0003;pa&\u001c\u0017\nZ\u0019!\u0003!!x\u000e]5d\u0013\u0012\u0014\u0014!\u0003;pa&\u001c\u0017\n\u001a\u001a!\u0003!!x\u000e]5d\u0013\u0012\u001cX#A,\u0011\takvlT\u0007\u00023*\u0011!lW\u0001\nS6lW\u000f^1cY\u0016T!\u0001X\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002_3\n\u0019Q*\u00199\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001\u00027b]\u001eT\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\n11\u000b\u001e:j]\u001e\f\u0011\u0002^8qS\u000eLEm\u001d\u0011\u0002\u001d\t\u0014xn[3s\u000b:$\u0007k\\5oiV\t!\u000e\u0005\u0002l_6\tAN\u0003\u0002n]\u00069a.\u001a;x_J\\'B\u0001\u0017B\u0013\t\u0001HN\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002\u001f\t\u0014xn[3s\u000b:$\u0007k\\5oi\u0002\n\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0003Q\u0004\"AO;\n\u0005Y\\#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003E1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003i\u0004\"a\u001f@\u000e\u0003qT!!`\u0016\u0002\u00115,G/\u00193bi\u0006L!a ?\u0003%-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003EIg.\u001b;jC24U\r^2i'R\fG/\u001a\u000b\t\u0003\u000f\ti!a\u0006\u0002\"A\u0019!(!\u0003\n\u0007\u0005-1FA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016Dq!a\u0004\u0015\u0001\u0004\t\t\"A\u0004u_BL7-\u00133\u0011\tI\n\u0019bT\u0005\u0004\u0003+\u0019$AB(qi&|g\u000eC\u0004\u0002\u001aQ\u0001\r!a\u0007\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\t\u0004e\u0005u\u0011bAA\u0010g\t!Aj\u001c8h\u0011%\t\u0019\u0003\u0006I\u0001\u0002\u0004\t)#A\u0006mK\u0006$WM]#q_\u000eD\u0007c\u0001\u001a\u0002(%\u0019\u0011\u0011F\u001a\u0003\u0007%sG/A\u000ej]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003_QC!!\n\u00022-\u0012\u00111\u0007\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003%)hn\u00195fG.,GMC\u0002\u0002>M\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t%a\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0004dY\u0016\fg.\u001e9\u0015\u0005\u0005\u001d\u0003c\u0001\u001a\u0002J%\u0019\u00111J\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0004-\u0005=\u0003\u0003BA)\u0003?j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0004CBL'\u0002BA-\u00037\nqA[;qSR,'OC\u0002\u0002^\u0011\u000bQA[;oSRLA!!\u0019\u0002T\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001bGJ,\u0017\r^3SKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u000b\u0013\u0003O\ni'!\"\u0002\n\u0006M\u0015QSAP\u0003S\u000b\u0019\fE\u0002;\u0003SJ1!a\u001b,\u0005Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bI\"9\u0011qN\fA\u0002\u0005E\u0014\u0001\u00028b[\u0016\u0004B!a\u001d\u0002\u0002:!\u0011QOA?!\r\t9hM\u0007\u0003\u0003sR1!a\u001f0\u0003\u0019a$o\\8u}%\u0019\u0011qP\u001a\u0002\rA\u0013X\rZ3g\u0013\r1\u00171\u0011\u0006\u0004\u0003\u007f\u001a\u0004bBAD/\u0001\u0007\u0011QE\u0001\nM\u0016$8\r[3s\u0013\u0012Dq!a#\u0018\u0001\u0004\ti)\u0001\u0007ce>\\WM]\"p]\u001aLw\rE\u0002;\u0003\u001fK1!!%,\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000bI<\u0002\u0019\u0001;\t\u000f\u0005]u\u00031\u0001\u0002\u001a\u0006Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0007i\nY*C\u0002\u0002\u001e.\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0004\u0002\"^\u0001\r!a)\u0002\u000bE,x\u000e^1\u0011\u0007i\n)+C\u0002\u0002(.\u0012ABU3qY&\u001c\u0017-U;pi\u0006Dq!a+\u0018\u0001\u0004\ti+\u0001\u000emK\u0006$WM]#oIB|\u0017N\u001c;CY>\u001c7.\u001b8h'\u0016tG\rE\u0002;\u0003_K1!!-,\u00051\u0011En\\2lS:<7+\u001a8e\u0011%\t)l\u0006I\u0001\u0002\u0004\t9,A\bnKR\fG-\u0019;b-\u0016\u00148/[8o!\u0011\tI,!0\u000e\u0005\u0005m&B\u0001!o\u0013\u0011\ty,a/\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\fAe\u0019:fCR,'+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003\u000bTC!a.\u00022\u0005A3\u000f[8vY\u0012\u001cVM\u001c3MCR,7\u000f\u001e*fcV,7\u000f\u001e,feNLwN\\:Cs\u0012+g-Y;mi\"\u001a\u0011$a3\u0011\t\u0005E\u0013QZ\u0005\u0005\u0003\u001f\f\u0019F\u0001\u0003UKN$\u0018!F1tg\u0016\u0014H\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u000b\u000b\u0003\u000f\n).a8\u0002j\u00065\bbBAl5\u0001\u0007\u0011\u0011\\\u0001\bM\u0016$8\r[3s!\rQ\u00141\\\u0005\u0004\u0003;\\#!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\b\u0003CT\u0002\u0019AAr\u0003U\u0019\bn\\;mI\n+'+Z1es\u001a{'OR3uG\"\u00042AMAs\u0013\r\t9o\r\u0002\b\u0005>|G.Z1o\u0011\u001d\tYO\u0007a\u0001\u0003G\fQc\u001d5pk2$')\u001a+sk:\u001c\u0017\r^5oO2{w\rC\u0004\u0002pj\u0001\r!a9\u0002\u001fMDw.\u001e7e\u0005\u0016$U\r\\1zK\u0012\fQe\u001d5pk2$\u0007*\u00198eY\u0016,\u0005pY3qi&|gN\u0012:p[\ncwnY6j]\u001e\u001cVM\u001c3)\u0007m\tY-\u0001\u001dtQ>,H\u000e\u001a(pi\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQ^KG\u000f\u001b+sk:\u001c\u0017\r^3P]\u001a+Go\u00195)\u0007q\tY-\u0001\u0012wKJLg-\u001f$fi\u000eDG*Z1eKJ,\u0005o\\2i\u001f:4\u0015N]:u\r\u0016$8\r\u001b\u000b\u0007\u0003\u000f\ni0a@\t\u000f\u0005UV\u00041\u0001\u00028\"9!\u0011A\u000fA\u0002\u0005\u0015\u0012aD3q_\u000eDg)\u001a;dQ\u000e{WO\u001c;\u0002\u0003NDw.\u001e7e)J,hnY1uK&3G*Z1eKJ\u0014V\r\u001d7jKN<\u0016\u000e\u001e5ESZ,'oZ5oO\u0016\u0003xn\u00195O_R\\en\\<o)>4u\u000e\u001c7po\u0016\u0014\bf\u0001\u0010\u0002L\u0006iC/Z:u)J,hnY1uK>sg)\u001a;dQ\u0012{Wm\u001d(piV\u0003H-\u0019;f\u0011&<\u0007nV1uKJl\u0017M]6)\u0007}\tY-A\u000fuKN$H*Y4JgV\u0003H-\u0019;fI^CWM\u001c(p%\u0016\u001cwN\u001d3tQ\r\u0001\u00131Z\u0001Ig\"|W\u000f\u001c3DCR\u001c\u0007.\u0012=dKB$\u0018n\u001c8Ge>l'\t\\8dW&twmU3oI^CWM\\*ikR$\u0018N\\4E_^t'+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D3!IAf\u0003\u0019\u001a\bn\\;mIV\u0003H-\u0019;f%\u0016\f7o]5h]6,g\u000e\u001e\"zi\u0016\u001c\u0018J\\'fiJL7m\u001d\u0015\u0004E\u0005-\u0017AR:i_VdGMT8u+B$\u0017\r^3SK\u0006\u001c8/[4o[\u0016tGOQ=uKNLe.T3ue&\u001c7o\u00165f]:{'+Z1tg&<g.\\3oiNLe\u000e\u0015:pOJ,7o\u001d\u0015\u0004G\u0005-\u0017A\u0004;fgR\u0014U/\u001b7e\r\u0016$8\r\u001b\u0015\u0004I\u0005-\u0017A\f;fgRdunY1m\r\u0016$8\r[\"p[BdW\r^5p]&3\u0007*[4i/\u0006$XM]7be.,\u0006\u000fZ1uK\u0012$B!a\u0012\u0003$!9!QE\u0013A\u0002\u0005\r\u0018\u0001\u00065jO\"<\u0016\r^3s[\u0006\u00148.\u00169eCR,G\rK\u0002&\u0005S\u0001BAa\u000b\u000325\u0011!Q\u0006\u0006\u0005\u0005_\t9&\u0001\u0004qCJ\fWn]\u0005\u0005\u0005g\u0011iCA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs!\nB\u001c\u0005\u0007\u0012)\u0005\u0005\u0003\u0003:\t}RB\u0001B\u001e\u0015\u0011\u0011iD!\f\u0002\u0011A\u0014xN^5eKJLAA!\u0011\u0003<\tYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006\u0002B$\u0005\u0013J\u0012!A\r\u0002\u0001\u0005\tc.Z<PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u0014Vm];miRA!q\nB;\u0005s\u0012Y\b\u0005\u0003\u0003R\t=d\u0002\u0002B*\u0005SrAA!\u0016\u0003f9!!q\u000bB2\u001d\u0011\u0011IF!\u0019\u000f\t\tm#q\f\b\u0005\u0003o\u0012i&C\u0001F\u0013\t\u0019E)\u0003\u0002/\u0005&\u0011\u0001)Q\u0005\u0004\u0005Oz\u0014aB7fgN\fw-Z\u0005\u0005\u0005W\u0012i'\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f'b\u0001B4\u007f%!!\u0011\u000fB:\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRTAAa\u001b\u0003n!1!q\u000f\u0014A\u0002u\n!\u0001\u001e9\t\u000f\u0005\rb\u00051\u0001\u0002&!9!Q\u0010\u0014A\u0002\u0005m\u0011!C3oI>3gm]3u))\u0011yE!!\u0003\u0004\nM%Q\u0013\u0005\u0007\u0005o:\u0003\u0019A\u001f\t\u000f\t\u0015u\u00051\u0001\u0003\b\u0006)QM\u001d:peB!!\u0011\u0012BH\u001b\t\u0011YIC\u0002\u0003\u000e~\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005#\u0013YI\u0001\u0004FeJ|'o\u001d\u0005\b\u0003G9\u0003\u0019AA\u0013\u0011\u001d\u0011ih\na\u0001\u00037\ta$Y:tKJ$\bK]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006<\u0006.\u001a8\u0015\t\u0005\u001d#1\u0014\u0005\b\u0005;C\u0003\u0019AAr\u00035I7OU3bgNLwM\\5oO\u0006!1\u000f^;c)!\t9Ea)\u00034\n]\u0006b\u0002BSS\u0001\u0007!qU\u0001\na\u0006\u0014H/\u001b;j_:\u0004BA!+\u000306\u0011!1\u0016\u0006\u0004\u0005[k\u0013aB2mkN$XM]\u0005\u0005\u0005c\u0013YKA\u0005QCJ$\u0018\u000e^5p]\"9!QW\u0015A\u0002\u0005e\u0015A\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0005\b\u0005sK\u0003\u0019\u0001B^\u0003\rawn\u001a\t\u0005\u0005{\u0013I-\u0004\u0002\u0003@*!!\u0011\u0018Ba\u0015\u0011\u0011\u0019M!2\u0002\u0013%tG/\u001a:oC2\u001c(b\u0001Bd\u0003\u000691\u000f^8sC\u001e,\u0017\u0002\u0002Bf\u0005\u007f\u0013!\"\u00168jM&,G\rT8h\u0001")
public class ReplicaFetcherThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final Uuid topicId1 = Uuid.randomUuid();
    private final Uuid topicId2 = Uuid.randomUuid();
    private final scala.collection.immutable.Map<String, Uuid> topicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)this.topicId2())}));
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 1000);
    private final FailedPartitions kafka$server$ReplicaFetcherThreadTest$$failedPartitions = new FailedPartitions();
    private final KRaftMetadataCache metadataCache = new KRaftMetadataCache(0, () -> KRaftVersion.LATEST_PRODUCTION);

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private TopicPartition t2p1() {
        return this.t2p1;
    }

    private Uuid topicId1() {
        return this.topicId1;
    }

    private Uuid topicId2() {
        return this.topicId2;
    }

    private scala.collection.immutable.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    public FailedPartitions kafka$server$ReplicaFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private InitialFetchState initialFetchState(Option<Uuid> topicId, long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(topicId, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$3() {
        return 1;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private ReplicaFetcherThread createReplicaFetcherThread(String name, int fetcherId, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend, MetadataVersion metadataVersion) {
        LogContext logContext = new LogContext("[ReplicaFetcher replicaId=" + brokerConfig.brokerId() + ", leaderId=" + leaderEndpointBlockingSend.brokerEndPoint().id() + ", fetcherId=" + fetcherId + "] ");
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, leaderEndpointBlockingSend.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), leaderEndpointBlockingSend, fetchSessionHandler, brokerConfig, replicaMgr, quota, (Function0 & Serializable)() -> MetadataVersion.MINIMUM_VERSION, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        return new ReplicaFetcherThread(name, (LeaderEndPoint)leader, brokerConfig, failedPartitions, replicaMgr, quota, logContext.logPrefix());
    }

    private MetadataVersion createReplicaFetcherThread$default$8() {
        return MetadataVersion.latestTesting();
    }

    @Test
    public void shouldSendLatestRequestVersionsByDefault() {
        MetadataVersion testingVersion = MetadataVersion.latestTesting();
        Assertions.assertEquals((short)ApiKeys.FETCH.latestVersion(true), (short)testingVersion.fetchRequestVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(true), (short)testingVersion.listOffsetRequestVersion());
    }

    public void assertPartitionStates(AbstractFetcherThread fetcher, boolean shouldBeReadyForFetch, boolean shouldBeTruncatingLog, boolean shouldBeDelayed) {
        new .colon.colon((Object)this.t1p0(), (List)new .colon.colon((Object)this.t1p1(), (List)new .colon.colon((Object)this.t2p1(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$assertPartitionStates$1(fetcher, shouldBeReadyForFetch, shouldBeTruncatingLog, shouldBeDelayed, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldHandleExceptionFromBlockingSend() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)mockBlockingSend.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any())).thenThrow(new Throwable[]{new NullPointerException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, null, mockBlockingSend, MetadataVersion.latestTesting());
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(thread.leader().fetchEpochEndOffsets(java.util.Map.of(this.t1p0(), new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(0), this.t1p1(), new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(0)))).asScala();
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))), (Object)result, (String)"results from leader epoch request should have undefined offset");
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotFetchLeaderEpochOnFirstFetchWithTruncateOnFetch() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.latestTesting(), 0);
    }

    private void verifyFetchLeaderEpochOnFirstFetch(MetadataVersion metadataVersion, int epochFetchCount) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn(Optional.of(new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> offsets = java.util.Map.of(this.t1p0(), this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L), this.t1p1(), this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L));
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), Time.SYSTEM);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, QuotaFactory.UNBOUNDED_QUOTA, mockNetwork, metadataVersion);
        thread.addPartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
    }

    @Test
    public void shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        ObjectRef latestLogEpoch = ObjectRef.create(Optional.of(BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)115L));
        Mockito.when((Object)log.latestEpoch()).thenAnswer(x$1 -> (Optional)latestLogEpoch$1.elem);
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn(Optional.of(new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn(Optional.of(new OffsetAndEpoch(129L, 2)));
        Mockito.when((Object)log.endOffsetForEpoch(2)).thenReturn(Optional.of(new OffsetAndEpoch(119L, 1)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), Time.SYSTEM);
        LogContext logContext = new LogContext("[ReplicaFetcher replicaId=" + config.brokerId() + ", leaderId=" + this.brokerEndPoint().id() + ", fetcherId=0] ");
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, this.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, fetchSessionHandler, config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> MetadataVersion.MINIMUM_VERSION, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        ReplicaFetcherThread thread = new ReplicaFetcherThread(this, leader, config, replicaManager, quota, logContext){

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
                return None$.MODULE$;
            }
        };
        thread.addPartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1))})));
        Set partitions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0(), this.t1p1()}));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(141L)))}))));
        mockNetwork.setIdsForNextResponse((Map<String, Uuid>)this.topicIds());
        latestLogEpoch.elem = Optional.of(BoxesRunTime.boxToInteger((int)4));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)140)), (String)("Expected " + this.t1p0() + " to truncate to offset 140 (truncation offsets: " + truncateToCapture.getAllValues() + ")"));
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)141)), (String)("Expected " + this.t1p1() + " to truncate to offset 141 (truncation offsets: " + truncateToCapture.getAllValues() + ")"));
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(130L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(131L)))}))));
        mockNetwork.setIdsForNextResponse((Map<String, Uuid>)this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)129)), (String)("Expected to truncate to offset 129 (truncation offsets: " + truncateToCapture.getAllValues() + ")"));
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(120L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(121L)))}))));
        mockNetwork.setIdsForNextResponse((Map<String, Uuid>)this.topicIds());
        latestLogEpoch.elem = Optional.empty();
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)4, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)6))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)119)), (String)("Expected to truncate to offset 119 (truncation offsets: " + truncateToCapture.getAllValues() + ")"));
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$7(thread, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTruncateOnFetchDoesNotUpdateHighWatermark() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        int logEndOffset = 150;
        int highWatermark = 130;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(highWatermark)));
        Mockito.when((Object)log.latestEpoch()).thenReturn(Optional.of(Predef$.MODULE$.int2Integer(5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn(Optional.of(new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(logEndOffset)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        LogContext logContext = new LogContext("[ReplicaFetcher replicaId=" + config.brokerId() + ", leaderId=" + this.brokerEndPoint().id() + ", fetcherId=0] ");
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), Time.SYSTEM);
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, new FetchSessionHandler(logContext, this.brokerEndPoint().id()), config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> MetadataVersion.MINIMUM_VERSION, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("fetcher-thread", (LeaderEndPoint)leader, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, logContext.logPrefix());
        thread.addPartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), logEndOffset, 1))})));
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setHighWatermark(160L).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L)))}))));
        mockNetwork.setIdsForNextResponse((Map<String, Uuid>)this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)1))).truncateTo(140L, false);
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)0))).maybeUpdateHighWatermark(ArgumentMatchers.anyLong());
    }

    @Test
    public void testLagIsUpdatedWhenNoRecords() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int lastFetchedEpoch = 2;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn(Optional.of(Predef$.MODULE$.int2Integer(lastFetchedEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(0)).thenReturn(Optional.of(new OffsetAndEpoch(0L, 0)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.maybeUpdateHighWatermark(0L)).thenReturn(Optional.empty());
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn((Object)new Some((Object)new LogAppendInfo(-1L, 0L, Optional.empty(), -1L, -1L, -1L, RecordValidationStats.EMPTY, CompressionType.NONE, -1, -1L)));
        LogContext logContext = new LogContext("[ReplicaFetcher replicaId=" + config.brokerId() + ", leaderId=" + this.brokerEndPoint().id() + ", fetcherId=0] ");
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), Time.SYSTEM);
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, new FetchSessionHandler(logContext, this.brokerEndPoint().id()), config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> MetadataVersion.MINIMUM_VERSION, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("fetcher-thread", (LeaderEndPoint)leader, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, logContext.logPrefix());
        thread.addPartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()).flatMap((Function1 & Serializable)x$2 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$2.lag()))));
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setHighWatermark(0L).setRecords((BaseRecords)MemoryRecords.EMPTY))}))));
        mockNetwork.setIdsForNextResponse((Map<String, Uuid>)this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)thread.fetchState(this.t1p0()).flatMap((Function1 & Serializable)x$3 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$3.lag()))));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)lastFetchedEpoch)), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(thread.fetchState(this.t1p0()))).flatMap(x$4 -> x$4.lastFetchedEpoch()));
    }

    @Test
    public void shouldCatchExceptionFromBlockingSendWhenShuttingDownReplicaFetcherThread() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        mockBlockingSend.initiateClose();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalArgumentException()});
        mockBlockingSend.close();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalStateException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, null, mockBlockingSend, MetadataVersion.latestTesting());
        thread.start();
        thread.initiateShutdown();
        thread.awaitShutdown();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).initiateClose();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).close();
    }

    @Test
    public void shouldUpdateReassignmentBytesInMetrics() {
        this.assertProcessPartitionDataWhen(true);
    }

    @Test
    public void shouldNotUpdateReassignmentBytesInMetricsWhenNoReassignmentsInProgress() {
        this.assertProcessPartitionDataWhen(false);
    }

    @Test
    public void testBuildFetch() {
        TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId1(), this.t1p0());
        TopicIdPartition tid1p1 = new TopicIdPartition(this.topicId1(), this.t1p1());
        TopicIdPartition tid2p1 = new TopicIdPartition(this.topicId2(), this.t2p1());
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaQuota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        LogContext logContext = new LogContext("[ReplicaFetcher replicaId=" + config.brokerId() + ", leaderId=" + this.brokerEndPoint().id() + ", fetcherId=0] ");
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, this.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), mockBlockingSend, fetchSessionHandler, config, replicaManager, replicaQuota, (Function0 & Serializable)() -> MetadataVersion.MINIMUM_VERSION, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", (LeaderEndPoint)leader, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, logContext.logPrefix());
        int leaderEpoch = 1;
        scala.collection.immutable.Map partitionMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState(Optional.of(this.topicId1()), 150L, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.FETCHING, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState(Optional.of(this.topicId1()), 155L, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.FETCHING, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState(Optional.of(this.topicId2()), 160L, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.FETCHING, Optional.empty()))}));
        Optional fetchRequestOpt = (Optional)thread.leader().buildFetch(CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionMap).asJava()).result();
        Assertions.assertTrue((boolean)fetchRequestOpt.isPresent());
        FetchRequest.Builder fetchRequestBuilder = ((ReplicaFetch)fetchRequestOpt.get()).fetchRequest();
        scala.collection.immutable.Map partitionDataMap = (scala.collection.immutable.Map)partitionMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                PartitionFetchState state = (PartitionFetchState)x0$1._2();
                return new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionDataMap).asJava(), (Object)fetchRequestBuilder.fetchData());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.replaced().size());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.removed().size());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        responseData.put(tid1p0, new FetchResponseData.PartitionData());
        responseData.put(tid1p1, new FetchResponseData.PartitionData());
        responseData.put(tid2p1, new FetchResponseData.PartitionData());
        FetchResponse fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, responseData, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        leader.fetchSessionHandler().handleResponse(fetchResponse, ApiKeys.FETCH.latestVersion());
        Uuid newTopicId = Uuid.randomUuid();
        scala.collection.immutable.Map partitionMap2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState(Optional.of(this.topicId1()), 155L, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.FETCHING, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState(Optional.of(newTopicId), 160L, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.FETCHING, Optional.empty()))}));
        Optional fetchRequestOpt2 = (Optional)thread.leader().buildFetch(CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionMap2).asJava()).result();
        scala.collection.immutable.Map partitionDataMap2 = (scala.collection.immutable.Map)((MapOps)partitionMap2.drop(1)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                PartitionFetchState state = (PartitionFetchState)x0$2._2();
                return new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            }
            throw new MatchError(null);
        });
        Assertions.assertTrue((boolean)fetchRequestOpt2.isPresent());
        FetchRequest.Builder fetchRequestBuilder2 = ((ReplicaFetch)fetchRequestOpt2.get()).fetchRequest();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionDataMap2).asJava(), (Object)fetchRequestBuilder2.fetchData());
        Assertions.assertEquals(Collections.singletonList(tid2p1), (Object)fetchRequestBuilder2.replaced());
        Assertions.assertEquals(Collections.singletonList(tid1p0), (Object)fetchRequestBuilder2.removed());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLocalFetchCompletionIfHighWatermarkUpdated(boolean highWatermarkUpdated) {
        void withRecords_records;
        void withRecords_timestampType;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        long highWatermarkReceivedFromLeader = 100L;
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Optional maybeNewHighWatermark = highWatermarkUpdated ? Optional.of(Predef$.MODULE$.long2Long(highWatermarkReceivedFromLeader)) : Optional.empty();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.maybeUpdateHighWatermark(highWatermarkReceivedFromLeader)).thenReturn(maybeNewHighWatermark);
        Some appendInfo = new Some(Mockito.mock(LogAppendInfo.class));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn((Object)appendInfo);
        Buffer completeDelayedFetchRequestsArgument = (Buffer)Buffer$.MODULE$.empty();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        replicaManager.completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> (Buffer)completeDelayedFetchRequestsArgument.$plus$plus$eq((IterableOnce)((scala.collection.immutable.Seq)invocation.getArguments()[0])));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("replica-fetcher", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, mockBlockingSend, MetadataVersion.latestTesting());
        TopicPartition tp0 = new TopicPartition("testTopic", 0);
        TopicPartition tp1 = new TopicPartition("testTopic", 1);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var20_18 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setRecords((BaseRecords)records).setHighWatermark(highWatermarkReceivedFromLeader);
        thread.processPartitionData(tp0, 0L, Integer.MAX_VALUE, partitionData.setPartitionIndex(0));
        thread.processPartitionData(tp1, 0L, Integer.MAX_VALUE, partitionData.setPartitionIndex(1));
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        thread.doWork();
        if (highWatermarkUpdated) {
            Assertions.assertEquals((Object)new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)), (Object)completeDelayedFetchRequestsArgument);
            ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        } else {
            ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        }
        Assertions.assertEquals((Object)Buffer$.MODULE$.empty(), (Object)thread.partitionsWithNewHighWatermark());
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, int leaderEpoch, long endOffset) {
        return this.newOffsetForLeaderPartitionResult(tp, Errors.NONE, leaderEpoch, endOffset);
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset);
    }

    /*
     * WARNING - void declaration
     */
    private void assertProcessPartitionDataWhen(boolean isReassigning) {
        void withRecords_records;
        void withRecords_timestampType;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var13_7 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Mockito.when((Object)log.maybeUpdateHighWatermark(0L)).thenReturn(Optional.empty());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isReassigning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isAddingLocalReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica(records, false, Integer.MAX_VALUE)).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, mockBlockingSend, MetadataVersion.latestTesting());
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setRecords((BaseRecords)records);
        thread.processPartitionData(this.t1p0(), 0L, Integer.MAX_VALUE, partitionData);
        if (isReassigning) {
            Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        } else {
            Assertions.assertEquals((long)0L, (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        }
        Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().replicationBytesInRate().get()).count());
    }

    public void stub(Partition partition, ReplicaManager replicaManager, UnifiedLog log) {
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t2p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t2p1())).thenReturn((Object)partition);
    }

    public static final /* synthetic */ void $anonfun$assertPartitionStates$1(AbstractFetcherThread fetcher$1, boolean shouldBeReadyForFetch$1, boolean shouldBeTruncatingLog$1, boolean shouldBeDelayed$1, TopicPartition tp) {
        Assertions.assertTrue((boolean)fetcher$1.fetchState(tp).isDefined());
        PartitionFetchState fetchState = (PartitionFetchState)fetcher$1.fetchState(tp).get();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeReadyForFetch$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isReadyForFetch()), (String)("Partition " + tp + " should" + (!shouldBeReadyForFetch$1 ? " NOT" : "") + " be ready for fetching"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeTruncatingLog$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isTruncating()), (String)("Partition " + tp + " should" + (!shouldBeTruncatingLog$1 ? " NOT" : "") + " be truncating its log"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeDelayed$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isDelayed()), (String)("Partition " + tp + " should" + (!shouldBeDelayed$1 ? " NOT" : "") + " be delayed"));
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)ReplicaState.FETCHING, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    private static final FetchResponseData.PartitionData partitionData$1(int partition, FetchResponseData.EpochEndOffset divergingEpoch) {
        return new FetchResponseData.PartitionData().setPartitionIndex(partition).setLastStableOffset(0L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch);
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)ReplicaState.FETCHING, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)ReplicaState.FETCHING, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$7(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)ReplicaState.FETCHING, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }
}

