/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.DelayedActionQueue;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\r\u001b\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00043\u0001\u0001\u0006IA\f\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019\t\u0005\u0001)A\u0005k!9!\t\u0001b\u0001\n\u0013\u0019\u0005BB&\u0001A\u0003%A\tC\u0004M\u0001\t\u0007I\u0011B'\t\ra\u0003\u0001\u0015!\u0003O\u0011\u001dI\u0006A1A\u0005\niCaa\u0018\u0001!\u0002\u0013Y\u0006\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0003b\u0011%)\u0007\u00011AA\u0002\u0013%a\rC\u0005m\u0001\u0001\u0007\t\u0011)Q\u0005E\"IQ\u000e\u0001a\u0001\u0002\u0004%IA\u001c\u0005\n{\u0002\u0001\r\u00111A\u0005\nyD!\"!\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003p\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!!\b\u0001\t\u0003\t)\u0001C\u0004\u0002(\u0001!\t!!\u0002\t\u000f\u0005-\u0002\u0001\"\u0001\u0002\u0006!9\u0011q\u0006\u0001\u0005\u0002\u0005\u0015\u0001bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003g\u0002A\u0011BA;\u0005eyeMZ:fiN4uN\u001d'fC\u0012,'/\u00129pG\"$Vm\u001d;\u000b\u0005ma\u0012!B3q_\u000eD'BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00025\u000511m\u001c8gS\u001e,\u0012A\f\t\u0003_Aj\u0011\u0001H\u0005\u0003cq\u00111bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u000e\t\u0003m}j\u0011a\u000e\u0006\u0003qe\nA!\u001e;jY*\u0011QD\u000f\u0006\u0003?mR!\u0001P\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000e\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#\u0001#\u0011\u0005\u0015KU\"\u0001$\u000b\u0005\t;%B\u0001%;\u0003\u0019\u0019w.\\7p]&\u0011!J\u0012\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013aD1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:\u0016\u00039\u0003\"aT+\u000f\u0005A\u001bV\"A)\u000b\u0005Is\u0012!B;uS2\u001c\u0018B\u0001+R\u0003%!Vm\u001d;Vi&d7/\u0003\u0002W/\nIRj\\2l\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\t!\u0016+\u0001\tbYR,'/S:s\u001b\u0006t\u0017mZ3sA\u0005\u0011A\u000f]\u000b\u00027B\u0011A,X\u0007\u0002\u000f&\u0011al\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\r!\b\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0007CA\u0018d\u0013\t!GD\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0003O*\u0004\"a\t5\n\u0005%$#\u0001B+oSRDqa[\u0007\u0002\u0002\u0003\u0007!-A\u0002yIE\nqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\rcV|G/Y'b]\u0006<WM]\u000b\u0002_B\u0011\u0001O\u001f\b\u0003cbt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005U\u0004\u0013A\u0002\u001fs_>$h(C\u0001 \u0013\tib$\u0003\u0002z9\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&\u00111\u0010 \u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0005ed\u0012\u0001E9v_R\fW*\u00198bO\u0016\u0014x\fJ3r)\t9w\u0010C\u0004l!\u0005\u0005\t\u0019A8\u0002\u001bE,x\u000e^1NC:\fw-\u001a:!\u0003\u0015\u0019X\r^+q)\u00059\u0007f\u0001\n\u0002\nA!\u00111BA\r\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011aA1qS*!\u00111CA\u000b\u0003\u001dQW\u000f]5uKJT1!a\u0006>\u0003\u0015QWO\\5u\u0013\u0011\tY\"!\u0004\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u000etQ>,H\u000eZ$fi\u0016\u0003xn\u00195t\rJ|WNU3qY&\u001c\u0017\rK\u0002\u0014\u0003C\u0001B!a\u0003\u0002$%!\u0011QEA\u0007\u0005\u0011!Vm\u001d;\u0002QMDw.\u001e7e%\u0016$XO\u001d8O_2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\\%g)\"\u0014xn\u001e8)\u0007Q\t\t#A\u0016tQ>,H\u000e\u001a*fiV\u0014h.\u00168l]><h\u000eV8qS\u000e|%\u000fU1si&$\u0018n\u001c8JMRC'o\\<oQ\r)\u0012\u0011E\u0001\ti\u0016\f'\u000fR8x]\"\u001aa#a\r\u0011\t\u0005-\u0011QG\u0005\u0005\u0003o\tiAA\u0005BMR,'/R1dQ\u00069b.Z<PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s)>\u0004\u0018n\u0019\u000b\t\u0003{\t\u0019'!\u001a\u0002pA!\u0011qHA/\u001d\u0011\t\t%a\u0016\u000f\t\u0005\r\u00131\u000b\b\u0005\u0003\u000b\n\tF\u0004\u0003\u0002H\u0005=c\u0002BA%\u0003\u001br1a]A&\u0013\u0005q\u0014B\u0001\u001f>\u0013\ty2(\u0003\u0002Iu%\u0019\u0011QK$\u0002\u000f5,7o]1hK&!\u0011\u0011LA.\u0003}yeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u0003+:\u0015\u0002BA0\u0003C\u0012Ac\u00144gg\u0016$hi\u001c:MK\u0006$WM\u001d+pa&\u001c'\u0002BA-\u00037BQ!W\fA\u0002mCq!a\u001a\u0018\u0001\u0004\tI'\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0007cA\u0012\u0002l%\u0019\u0011Q\u000e\u0013\u0003\u0007%sG\u000fC\u0004\u0002r]\u0001\r!!\u001b\u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\u001e]\u0016<xJ\u001a4tKR4uN\u001d'fC\u0012,'\u000fV8qS\u000e\u0014Vm];miRQ\u0011qOAC\u0003\u000f\u000b9*!'\u0011\t\u0005e\u0014q\u0010\b\u0005\u0003\u0003\nY(\u0003\u0003\u0002~\u0005m\u0013\u0001I(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3ta>t7/\u001a#bi\u0006LA!!!\u0002\u0004\nQrJ\u001a4tKR4uN\u001d'fC\u0012,'\u000fV8qS\u000e\u0014Vm];mi*!\u0011QPA.\u0011\u0015I\u0006\u00041\u0001\\\u0011\u001d\tI\t\u0007a\u0001\u0003\u0017\u000bQ!\u001a:s_J\u0004B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#;\u0015\u0001\u00039s_R|7m\u001c7\n\t\u0005U\u0015q\u0012\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u0005E\u0004\u00041\u0001\u0002j!9\u00111\u0014\rA\u0002\u0005u\u0015!C3oI>3gm]3u!\r\u0019\u0013qT\u0005\u0004\u0003C##\u0001\u0002'p]\u001e\u0004")
public class OffsetsForLeaderEpochTest {
    private final KafkaConfig config = (KafkaConfig)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).head();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final TestUtils.MockAlterPartitionManager alterIsrManager = new TestUtils.MockAlterPartitionManager();
    private final TopicPartition tp = new TopicPartition("topic", 1);
    private ReplicaManager replicaManager;
    private QuotaFactory.QuotaManagers quotaManager;

    private KafkaConfig config() {
        return this.config;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TestUtils.MockAlterPartitionManager alterIsrManager() {
        return this.alterIsrManager;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    private QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    private void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.quotaManager_$eq(QuotaFactory.instantiate((KafkaConfig)this.config(), (Metrics)this.metrics(), (Time)this.time(), (String)"", (String)""));
    }

    @Test
    public void shouldGetEpochsFromReplica() {
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(42L, 5);
        int epochRequested = 5;
        .colon.colon request = new .colon.colon((Object)this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested), (List)Nil$.MODULE$);
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)mockLog.endOffsetForEpoch(epochRequested)).thenReturn(Optional.of(offsetAndEpoch));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        KRaftMetadataCache x$7 = new KRaftMetadataCache(this.config().brokerId(), () -> KRaftVersion.KRAFT_VERSION_0);
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        None$ x$10 = None$.MODULE$;
        BrokerTopicStats x$11 = new BrokerTopicStats();
        AtomicBoolean x$12 = new AtomicBoolean(false);
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        None$ x$19 = None$.MODULE$;
        Function0 x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$21 = None$.MODULE$;
        DirectoryEventHandler x$22 = DirectoryEventHandler.NOOP;
        DelayedActionQueue x$23 = new DelayedActionQueue();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, (Option)x$10, x$6, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$11, x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, x$20, (Option)x$21, x$22, (ActionQueue)x$23));
        Partition partition = this.replicaManager().createPartition(this.tp());
        partition.setLog(mockLog, false);
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.config().brokerId())));
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.newOffsetForLeaderTopicResult(this.tp(), Errors.NONE, offsetAndEpoch.epoch(), offsetAndEpoch.offset()), (List)Nil$.MODULE$), (Object)response);
    }

    @Test
    public void shouldReturnNoLeaderForPartitionIfThrown() {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        KRaftMetadataCache x$7 = new KRaftMetadataCache(this.config().brokerId(), () -> KRaftVersion.KRAFT_VERSION_0);
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        None$ x$10 = None$.MODULE$;
        BrokerTopicStats x$11 = new BrokerTopicStats();
        AtomicBoolean x$12 = new AtomicBoolean(false);
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        None$ x$19 = None$.MODULE$;
        Function0 x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$21 = None$.MODULE$;
        DirectoryEventHandler x$22 = DirectoryEventHandler.NOOP;
        DelayedActionQueue x$23 = new DelayedActionQueue();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, (Option)x$10, x$6, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$11, x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, x$20, (Option)x$21, x$22, (ActionQueue)x$23));
        this.replicaManager().createPartition(this.tp());
        int epochRequested = 5;
        .colon.colon request = new .colon.colon((Object)this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested), (List)Nil$.MODULE$);
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.newOffsetForLeaderTopicResult(this.tp(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L), (List)Nil$.MODULE$), (Object)response);
    }

    @Test
    public void shouldReturnUnknownTopicOrPartitionIfThrown() {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        KRaftMetadataCache x$7 = new KRaftMetadataCache(this.config().brokerId(), () -> KRaftVersion.KRAFT_VERSION_0);
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        None$ x$10 = None$.MODULE$;
        BrokerTopicStats x$11 = new BrokerTopicStats();
        AtomicBoolean x$12 = new AtomicBoolean(false);
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        None$ x$19 = None$.MODULE$;
        Function0 x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$21 = None$.MODULE$;
        DirectoryEventHandler x$22 = DirectoryEventHandler.NOOP;
        DelayedActionQueue x$23 = new DelayedActionQueue();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, (Option)x$10, x$6, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$11, x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, x$20, (Option)x$21, x$22, (ActionQueue)x$23));
        int epochRequested = 5;
        .colon.colon request = new .colon.colon((Object)this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested), (List)Nil$.MODULE$);
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.newOffsetForLeaderTopicResult(this.tp(), Errors.UNKNOWN_TOPIC_OR_PARTITION, -1, -1L), (List)Nil$.MODULE$), (Object)response);
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopic newOffsetForLeaderTopic(TopicPartition tp, int currentLeaderEpoch, int leaderEpoch) {
        return new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setLeaderEpoch(leaderEpoch), (List)Nil$.MODULE$)).asJava());
    }

    private OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult newOffsetForLeaderTopicResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset), (List)Nil$.MODULE$)).asJava());
    }
}

