/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005m2AAB\u0004\u0001\u0019!)q\u0003\u0001C\u00011!9!\u0004\u0001b\u0001\n\u0003Y\u0002B\u0002\u0014\u0001A\u0003%A\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003:\u0001\u0011\u0005\u0001FA\u0007D_J,W\u000b^5mgR+7\u000f\u001e\u0006\u0003\u0011%\tQ!\u001e;jYNT\u0011AC\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q)R\"A\u0004\n\u0005Y9!a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"\u0001\u0006\u0001\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#\u0001\u000f\u0011\u0005u!S\"\u0001\u0010\u000b\u0005}\u0001\u0013!\u0002:fO\u0016D(BA\u0011#\u0003\u0011)H/\u001b7\u000b\u0003\r\nAA[1wC&\u0011QE\b\u0002\b!\u0006$H/\u001a:o\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000eI\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u0001*!\tq!&\u0003\u0002,\u001f\t!QK\\5uQ\t!Q\u0006\u0005\u0002/o5\tqF\u0003\u00021c\u0005\u0019\u0011\r]5\u000b\u0005I\u001a\u0014a\u00026va&$XM\u001d\u0006\u0003iU\nQA[;oSRT\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d0\u0005\u0011!Vm\u001d;\u0002\u0015Q,7\u000f^%o\u0019>\u001c7\u000e\u000b\u0002\u0006[\u0001")
public class CoreUtilsTest
implements Logging {
    private final Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        ObjectRef loggedMessage = ObjectRef.create((Object)None$.MODULE$);
        Logging testLogging = new Logging(null, loggedMessage){
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final ObjectRef loggedMessage$1;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.INFO));
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.DEBUG));
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.WARN));
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.ERROR));
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                this.loggedMessage$1.elem = new Some((Object)((String)msg.apply() + Level.TRACE));
            }
            {
                this.loggedMessage$1 = loggedMessage$1;
            }
        };
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.TRACE);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.TRACE)), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.DEBUG);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.DEBUG)), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.INFO);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.INFO)), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.WARN);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.WARN)), (Object)((Option)loggedMessage.elem));
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, testLogging, Level.ERROR);
        Assertions.assertEquals((Object)new Some((Object)("test" + Level.ERROR)), (Object)((Option)loggedMessage.elem));
    }

    @Test
    public void testInLock() {
        int n;
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            n = CoreUtilsTest.$anonfun$testInLock$1(lock);
        }
        finally {
            lock.unlock();
        }
        int result = n;
        Assertions.assertEquals((int)2, (int)result);
        Assertions.assertFalse((boolean)lock.isLocked(), (String)"Should be unlocked");
    }

    public static final /* synthetic */ int $anonfun$testInLock$1(ReentrantLock lock$1) {
        Assertions.assertTrue((boolean)lock$1.isHeldByCurrentThread(), (String)"Should be in lock");
        return 2;
    }
}

