/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t-b!\u0002\u0014(\u0003\u0003a\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"\u00023\u0001\t\u0003)\u0007\"\u00026\u0001\t\u0003Yw!\u00029(\u0011\u0003\th!\u0002\u0014(\u0011\u0003\u0011\b\"B\u0019\u0007\t\u00031\bbB<\u0007\u0005\u0004%\t\u0001\u001f\u0005\b\u0003\u00171\u0001\u0015!\u0003z\u0011!\tiA\u0002b\u0001\n\u0003A\bbBA\b\r\u0001\u0006I!\u001f\u0004\u0007\u0003#1\u0001!a\u0005\t\rEbA\u0011AA&\u0011\u001d\t\t\u0006\u0004C!\u0003'Bq!a\u0018\r\t\u0003\n\tG\u0002\u0004\u0002l\u0019\u0001\u0011Q\u000e\u0005\u0007cA!\t!!\u001e\t\u000f\u0005E\u0003\u0003\"\u0011\u0002z!9\u0011Q\u0010\t\u0005B\u0005}dABAC\r\u0001\t9\t\u0003\u00042)\u0011\u0005\u0011\u0011\u0012\u0005\n\u0003\u001b#\u0002\u0019!C\u0001\u0003\u001fC\u0011\"a&\u0015\u0001\u0004%\t!!'\t\u0011\u0005}E\u0003)Q\u0005\u0003#Cq!a\u0018\u0015\t\u0003\n\t\u000bC\u0004\u00028R!\t%!/\t\u000f\u0005%H\u0003\"\u0011\u0002l\"9\u0011q\f\u000b\u0005B\u00055hABAz\r\u0001\t)\u0010\u0003\u00042;\u0011\u0005\u0011q\u001f\u0005\n\u0003wl\u0002\u0019!C\u0001\u0003{D\u0011B!\u0002\u001e\u0001\u0004%\tAa\u0002\t\u0011\t-Q\u0004)Q\u0005\u0003\u007fDq!! \u001e\t\u0003\u0012i\u0001C\u0004\u00028v!\tE!\u0006\t\u000f\u0005%X\u0004\"\u0011\u0002l\"9\u0011QP\u000f\u0005B\t\u0015\"\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\tA\u0013&A\u0002ba&T\u0011AK\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0006\u0005\u0002/_5\tq%\u0003\u00021O\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#A\u001a\u0011\u00059\u0002\u0011!\u0006;fgR\u001c\u0016.\u001c9mK\u000e{gn];naRLwN\u001c\u000b\u0003mq\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012A!\u00168ji\")QH\u0001a\u0001}\u0005iqM]8vaB\u0013x\u000e^8d_2\u0004\"a\u0010$\u000f\u0005\u0001#\u0005CA!9\u001b\u0005\u0011%BA\",\u0003\u0019a$o\\8u}%\u0011Q\tO\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002Fq!\"!A\u0013,X!\tYE+D\u0001M\u0015\tie*\u0001\u0004qCJ\fWn\u001d\u0006\u0003\u001fB\u000bqA[;qSR,'O\u0003\u0002R%\u0006)!.\u001e8ji*\t1+A\u0002pe\u001eL!!\u0016'\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001-\u0002?m$\u0017n\u001d9mCft\u0015-\\3~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\u0004T\u0010\u000b\u0003\u00035\u0002\f\u0007CA._\u001b\u0005a&BA/M\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA0]\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\u0005\u0011\u0017%A2\u0002C\u001d,G\u000fV3ti\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\t\u001c7\u00027Q,7\u000f^\"mkN$XM\u001d*fg>,(oY3MSN$XM\\3s)\t1d\rC\u0003>\u0007\u0001\u0007a\b\u000b\u0003\u0004\u0015Z;\u0006\u0006B\u0002[A&d\u0013AY\u0001\u0018i\u0016\u001cHoQ8pe\u0012Lg.\u0019;pe\u001a\u000b\u0017\u000e\\8wKJ$\"A\u000e7\t\u000bu\"\u0001\u0019\u0001 )\t\u0011Qek\u0016\u0015\u0005\ti\u0003w\u000eL\u0001c\u0003A\u0011\u0015m]3D_:\u001cX/\\3s)\u0016\u001cH\u000f\u0005\u0002/\rM\u0011aa\u001d\t\u0003oQL!!\u001e\u001d\u0003\r\u0005s\u0017PU3g)\u0005\t\u0018aE;qI\u0006$X\r\u0015:pIV\u001cWM]\"pk:$X#A=\u0011\u0007i\f9!D\u0001|\u0015\taX0\u0001\u0004bi>l\u0017n\u0019\u0006\u0003}~\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\t\t!a\u0001\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B>\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003Q)\b\u000fZ1uKB\u0013x\u000eZ;dKJ\u001cu.\u001e8uA\u0005\u0019R\u000f\u001d3bi\u0016\u001cuN\\:v[\u0016\u00148i\\;oi\u0006!R\u000f\u001d3bi\u0016\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\u0012Q\u0005V3ti\u000ecWo\u001d;feJ+7o\\;sG\u0016d\u0015n\u001d;f]\u0016\u00148+\u001a:jC2L'0\u001a:\u0014\u000f1\t)\"!\t\u0002DA!\u0011qCA\u000f\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005\r\u0011\u0001\u00027b]\u001eLA!a\b\u0002\u001a\t1qJ\u00196fGR\u0004b!a\t\u00024\u0005]RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u001bM,'/[1mSj\fG/[8o\u0015\u0011\tY#!\f\u0002\r\r|W.\\8o\u0015\rQ\u0013q\u0006\u0006\u0004\u0003c\u0011\u0016AB1qC\u000eDW-\u0003\u0003\u00026\u0005\u0015\"AC*fe&\fG.\u001b>feB)q'!\u000f\u0002>%\u0019\u00111\b\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0007]\ny$C\u0002\u0002Ba\u0012AAQ=uKB!\u0011QIA$\u001b\t\tI#\u0003\u0003\u0002J\u0005%\"aF\"mkN$XM\u001d*fg>,(oY3MSN$XM\\3s)\t\ti\u0005E\u0002\u0002P1i\u0011AB\u0001\t_:,\u0006\u000fZ1uKR\u0019a'!\u0016\t\u000f\u0005]c\u00021\u0001\u0002Z\u0005y1\r\\;ti\u0016\u0014(+Z:pkJ\u001cW\r\u0005\u0003\u0002F\u0005m\u0013\u0002BA/\u0003S\u0011qb\u00117vgR,'OU3t_V\u00148-Z\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$b!a\u000e\u0002d\u0005\u001d\u0004BBA3\u001f\u0001\u0007a(A\u0003u_BL7\rC\u0004\u0002j=\u0001\r!a\u000e\u0002\t\u0011\fG/\u0019\u0002()\u0016\u001cHo\u00117vgR,'OU3t_V\u00148-\u001a'jgR,g.\u001a:EKN,'/[1mSj,'oE\u0004\u0011\u0003+\ty'a\u0011\u0011\r\u0005\r\u0012\u0011OA\u001c\u0013\u0011\t\u0019(!\n\u0003\u0019\u0011+7/\u001a:jC2L'0\u001a:\u0015\u0005\u0005]\u0004cAA(!Q\u0019a'a\u001f\t\u000f\u0005]#\u00031\u0001\u0002Z\u0005YA-Z:fe&\fG.\u001b>f)\u0019\t9$!!\u0002\u0004\"1\u0011QM\nA\u0002yBq!!\u001b\u0014\u0001\u0004\t9D\u0001\bTKJL\u0017\r\\5{KJLU\u000e\u001d7\u0014\u000bQ\t)\"!\t\u0015\u0005\u0005-\u0005cAA()\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u0005\u0005E\u0005\u0003BA\u0012\u0003'KA!!&\u0002&\t\u0019\")\u001f;f\u0003J\u0014\u0018-_*fe&\fG.\u001b>fe\u0006q1/\u001a:jC2L'0\u001a:`I\u0015\fHc\u0001\u001c\u0002\u001c\"I\u0011QT\f\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u0004q\u0012\n\u0014aC:fe&\fG.\u001b>fe\u0002\"\u0002\"a\u000e\u0002$\u0006\u0015\u0016Q\u0017\u0005\u0007\u0003KJ\u0002\u0019\u0001 \t\u000f\u0005\u001d\u0016\u00041\u0001\u0002*\u00069\u0001.Z1eKJ\u001c\b\u0003BAV\u0003ck!!!,\u000b\t\u0005=\u0016\u0011F\u0001\u0007Q\u0016\fG-\u001a:\n\t\u0005M\u0016Q\u0016\u0002\b\u0011\u0016\fG-\u001a:t\u0011\u001d\tI'\u0007a\u0001\u0003o\t\u0011bY8oM&<WO]3\u0015\u000bY\nY,a8\t\u000f\u0005u&\u00041\u0001\u0002@\u000691m\u001c8gS\u001e\u001c\b\u0007BAa\u0003\u001b\u0004r!a1\u0002Fz\nI-D\u0001\u0000\u0013\r\t9m \u0002\u0004\u001b\u0006\u0004\b\u0003BAf\u0003\u001bd\u0001\u0001\u0002\u0007\u0002P\u0006m\u0016\u0011!A\u0001\u0006\u0003\t\tNA\u0002`IE\nB!a5\u0002ZB\u0019q'!6\n\u0007\u0005]\u0007HA\u0004O_RD\u0017N\\4\u0011\u0007]\nY.C\u0002\u0002^b\u00121!\u00118z\u0011\u001d\t\tO\u0007a\u0001\u0003G\fQ![:LKf\u00042aNAs\u0013\r\t9\u000f\u000f\u0002\b\u0005>|G.Z1o\u0003\u0015\u0019Gn\\:f)\u00051DCBA\u001c\u0003_\f\t\u0010\u0003\u0004\u0002fq\u0001\rA\u0010\u0005\b\u0003Sb\u0002\u0019AA\u001c\u0005A!Um]3sS\u0006d\u0017N_3s\u00136\u0004HnE\u0003\u001e\u0003+\ty\u0007\u0006\u0002\u0002zB\u0019\u0011qJ\u000f\u0002\u0019\u0011,7/\u001a:jC2L'0\u001a:\u0016\u0005\u0005}\b\u0003BA\u0012\u0005\u0003IAAa\u0001\u0002&\t)\")\u001f;f\u0003J\u0014\u0018-\u001f#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001\u00053fg\u0016\u0014\u0018.\u00197ju\u0016\u0014x\fJ3r)\r1$\u0011\u0002\u0005\n\u0003;\u0003\u0013\u0011!a\u0001\u0003\u007f\fQ\u0002Z3tKJL\u0017\r\\5{KJ\u0004C\u0003CA\u001c\u0005\u001f\u0011\tBa\u0005\t\r\u0005\u0015$\u00051\u0001?\u0011\u001d\t9K\ta\u0001\u0003SCq!!\u001b#\u0001\u0004\t9\u0004F\u00037\u0005/\u0011\u0019\u0003C\u0004\u0002>\u000e\u0002\rA!\u00071\t\tm!q\u0004\t\b\u0003\u0007\f)M\u0010B\u000f!\u0011\tYMa\b\u0005\u0019\t\u0005\"qCA\u0001\u0002\u0003\u0015\t!!5\u0003\u0007}##\u0007C\u0004\u0002b\u000e\u0002\r!a9\u0015\r\u0005]\"q\u0005B\u0015\u0011\u0019\t)'\na\u0001}!9\u0011\u0011N\u0013A\u0002\u0005]\u0002")
public abstract class BaseConsumerTest
extends AbstractConsumerTest {
    public static AtomicInteger updateConsumerCount() {
        return BaseConsumerTest$.MODULE$.updateConsumerCount();
    }

    public static AtomicInteger updateProducerCount() {
        return BaseConsumerTest$.MODULE$.updateProducerCount();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testSimpleConsumption(String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign(List.of(this.tp()));
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testClusterResourceListener(String groupProtocol) {
        int numRecords = 100;
        Properties producerProps = new Properties();
        producerProps.put("key.serializer", TestClusterResourceListenerSerializer.class);
        producerProps.put("value.serializer", TestClusterResourceListenerSerializer.class);
        KafkaProducer producer = this.createProducer(null, null, producerProps);
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Properties consumerProps = new Properties();
        consumerProps.put("key.deserializer", TestClusterResourceListenerDeserializer.class);
        consumerProps.put("value.deserializer", TestClusterResourceListenerDeserializer.class);
        Consumer consumer = this.createConsumer(null, null, consumerProps, this.createConsumer$default$4());
        consumer.subscribe(List.of(this.tp().topic()));
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateProducerCount().get());
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateConsumerCount().get());
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testCoordinatorFailover(String groupProtocol) {
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        if (groupProtocol.equalsIgnoreCase(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("session.timeout.ms", "5001");
            this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        }
        this.consumerConfig().setProperty("max.poll.interval.ms", "15000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(List.of(this.topic()), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Buffer parts = null;
        while (parts == null) {
            parts = CollectionConverters$.MODULE$.ListHasAsScala(consumer.partitionsFor("__consumer_offsets")).asScala();
        }
        Assertions.assertEquals((int)1, (int)parts.size());
        Assertions.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaBroker)this.brokers().apply(coordinator)).shutdown();
        this.ensureNoRebalance(consumer, listener);
    }

    public static class DeserializerImpl
    implements Deserializer<byte[]> {
        private ByteArrayDeserializer deserializer = new ByteArrayDeserializer();

        public Object deserialize(String x$1, Headers x$2, ByteBuffer x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public ByteArrayDeserializer deserializer() {
            return this.deserializer;
        }

        public void deserializer_$eq(ByteArrayDeserializer x$1) {
            this.deserializer = x$1;
        }

        public byte[] deserialize(String topic, Headers headers, byte[] data) {
            Header header = headers.lastHeader("content-type");
            Assertions.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
            return this.deserializer().deserialize(topic, data);
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.deserializer().configure(configs, isKey);
        }

        public void close() {
            this.deserializer().close();
        }

        public byte[] deserialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }
    }

    public static class SerializerImpl
    implements Serializer<byte[]> {
        private ByteArraySerializer serializer = new ByteArraySerializer();

        public ByteArraySerializer serializer() {
            return this.serializer;
        }

        public void serializer_$eq(ByteArraySerializer x$1) {
            this.serializer = x$1;
        }

        public byte[] serialize(String topic, Headers headers, byte[] data) {
            headers.add("content-type", "application/octet-stream".getBytes());
            return this.serializer().serialize(topic, data);
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.serializer().configure(configs, isKey);
        }

        public void close() {
            this.serializer().close();
        }

        public byte[] serialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }
    }

    public static class TestClusterResourceListenerDeserializer
    implements Deserializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public Object deserialize(String x$1, Headers x$2, byte[] x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public Object deserialize(String x$1, Headers x$2, ByteBuffer x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateConsumerCount().incrementAndGet();
        }

        public byte[] deserialize(String topic, byte[] data) {
            return data;
        }
    }

    public static class TestClusterResourceListenerSerializer
    implements Serializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public byte[] serialize(String x$1, Headers x$2, Object x$3) {
            return super.serialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateProducerCount().incrementAndGet();
        }

        public byte[] serialize(String topic, byte[] data) {
            return data;
        }
    }
}

