/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.coordinator.group.CoordinatorLoaderImpl;
import kafka.coordinator.group.CoordinatorLoaderImpl$;
import kafka.coordinator.group.StringKeyValueDeserializer;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.common.runtime.CoordinatorPlayback;
import org.apache.kafka.coordinator.common.runtime.Deserializer;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001B\n\u0015\u0001mAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0005\u0002\u001dBQ\u0001\u000f\u0001\u0005\u0002\u001dBQA\u000f\u0001\u0005\u0002\u001dBQ\u0001\u0010\u0001\u0005\u0002\u001dBQA\u0010\u0001\u0005\u0002\u001dBQ\u0001\u0011\u0001\u0005\u0002\u001dBQA\u0011\u0001\u0005\u0002\u001dBQ\u0001\u0012\u0001\u0005\u0002\u001dBQA\u0012\u0001\u0005\u0002\u001dBQ\u0001\u0013\u0001\u0005\u0002\u001dBQA\u0013\u0001\u0005\u0002\u001dBQ\u0001\u0014\u0001\u0005\u0002\u001dBQA\u0014\u0001\u0005\u0002\u001dBQ\u0001\u0015\u0001\u0005\nEC\u0011\"a\u0001\u0001#\u0003%I!!\u0002\t\u0013\u0005m\u0001!%A\u0005\n\u0005u\u0001B\u0002)\u0001\t\u0013\t\tCA\rD_>\u0014H-\u001b8bi>\u0014Hj\\1eKJLU\u000e\u001d7UKN$(BA\u000b\u0017\u0003\u00159'o\\;q\u0015\t9\u0002$A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u0005!\u0012\u0001\u0007;fgRtuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R\t\u0001\u0006\u0005\u0002\u001eS%\u0011!F\b\u0002\u0005+:LG\u000f\u000b\u0002\u0003YA\u0011QFN\u0007\u0002])\u0011q\u0006M\u0001\u0004CBL'BA\u00193\u0003\u001dQW\u000f]5uKJT!a\r\u001b\u0002\u000b),h.\u001b;\u000b\u0003U\n1a\u001c:h\u0013\t9dF\u0001\u0003UKN$\u0018a\b;fgRdu.\u00193j]\u001eL5OU3kK\u000e$X\rZ,iK:\u001cEn\\:fI\"\u00121\u0001L\u0001\fi\u0016\u001cH\u000fT8bI&tw\r\u000b\u0002\u0005Y\u0005aB/Z:u\u0019>\fG-\u001b8h'R|\u0007\u000f]3e/\",gn\u00117pg\u0016$\u0007FA\u0003-\u0003}!Xm\u001d;V].twn\u001e8SK\u000e|'\u000f\u001a+za\u0016\f%/Z%h]>\u0014X\r\u001a\u0015\u0003\r1\nq\u0005^3ti\u0012+7/\u001a:jC2L'0\u0019;j_:,%O]8s\r\u0006LGn\u001d+iK2{\u0017\rZ5oO\"\u0012q\u0001L\u0001(i\u0016\u001cH\u000fT8bI\u001e\u0013x.\u001e9B]\u0012|eMZ:fiN<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;fI2{w\r\u000b\u0002\tY\u0005yA/Z:u\u0019>\fGmU;n[\u0006\u0014\u0018\u0010\u000b\u0002\nY\u0005AC/Z:u+B$\u0017\r^3MCN$xK]5ui\u0016twJ\u001a4tKR|eNQ1uG\"du.\u00193fI\"\u0012!\u0002L\u0001Ei\u0016\u001cH/\u00169eCR,G*Y:u/JLG\u000f^3o\u001f\u001a47/\u001a;B]\u0012,\u0006\u000fZ1uK2\u000b7\u000f^\"p[6LG\u000f^3e\u001f\u001a47/\u001a;O_J+7m\u001c:egJ+\u0017\r\u001a\u0015\u0003\u00171\nq\b^3tiV\u0003H-\u0019;f\u0019\u0006\u001cHo\u0016:jiR,gn\u00144gg\u0016$xJ\u001c\"bi\u000eDGj\\1eK\u0012<\u0006.\u001b7f\u0011&<\u0007nV1uKJl\u0017M]6BQ\u0016\fG\r\u000b\u0002\rY\u0005\u0011C/Z:u!\u0006\u0014H/\u001b;j_:<u.Z:PM\u001ad\u0017N\\3EkJLgn\u001a'pC\u0012D#!\u0004\u0017\u0002SQ,7\u000f^+qI\u0006$X\rT1ti^\u0013\u0018\u000e\u001e;f]>3gm]3u\u0007>lW.\u001b;J]R,'O^1mQ\tqA&A\u0007m_\u001e\u0014V-\u00193SKN,H\u000e\u001e\u000b\u0006%~#gm\u001b\t\u0003'vk\u0011\u0001\u0016\u0006\u0003+Z\u000b1\u0001\\8h\u0015\t9\u0006,A\u0005j]R,'O\\1mg*\u0011\u0011LW\u0001\bgR|'/Y4f\u0015\tI2L\u0003\u0002]i\u00051\u0011\r]1dQ\u0016L!A\u0018+\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u0015\u0001w\u00021\u0001b\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0011\u0005u\u0011\u0017BA2\u001f\u0005\u0011auN\\4\t\u000f\u0015|\u0001\u0013!a\u0001C\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u000f\u001d|\u0001\u0013!a\u0001Q\u0006i\u0001O]8ek\u000e,'/\u00129pG\"\u0004\"!H5\n\u0005)t\"!B*i_J$\b\"\u00027\u0010\u0001\u0004i\u0017a\u0002:fG>\u0014Hm\u001d\t\u0004]ZLhBA8u\u001d\t\u00018/D\u0001r\u0015\t\u0011($\u0001\u0004=e>|GOP\u0005\u0002?%\u0011QOH\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bPA\u0002TKFT!!\u001e\u0010\u0011\u0005i|X\"A>\u000b\u0005ql\u0018A\u0002:fG>\u0014HM\u0003\u0002\u007f5\u000611m\\7n_:L1!!\u0001|\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0003]awn\u001a*fC\u0012\u0014Vm];mi\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\b)\u001a\u0011-!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0006\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\tyAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\u0003\\8h%\u0016\fGMU3tk2$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}!f\u00015\u0002\nQI!+a\t\u0002&\u0005\u001d\u0012\u0011\u0006\u0005\u0006AJ\u0001\r!\u0019\u0005\u0006KJ\u0001\r!\u0019\u0005\u0006OJ\u0001\r\u0001\u001b\u0005\b\u0003W\u0011\u0002\u0019AA\u0017\u0003E\u0019wN\u001c;s_2\u0014VmY8sIRK\b/\u001a\t\u0004u\u0006=\u0012bAA\u0019w\n\t2i\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3)\u000f\u0001\t)$a\u000f\u0002>A\u0019Q&a\u000e\n\u0007\u0005ebFA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003q\u0002")
public class CoordinatorLoaderImplTest {
    @Test
    public void testNonexistentPartition() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Deserializer serde = (Deserializer)Mockito.mock(Deserializer.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            Mockito.when((Object)replicaManager.getLog(tp)).thenReturn((Object)None$.MODULE$);
            CompletableFuture result = loader.load(tp, coordinator);
            return (NotLeaderOrFollowerException)TestUtils.assertFutureThrows(NotLeaderOrFollowerException.class, (Future)result);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoadingIsRejectedWhenClosed() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Deserializer serde = (Deserializer)Mockito.mock(Deserializer.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            loader.close();
            CompletableFuture result = loader.load(tp, coordinator);
            return (RuntimeException)TestUtils.assertFutureThrows(RuntimeException.class, (Future)result);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoading() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testLoading$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoadingStoppedWhenClosed() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testLoadingStoppedWhenClosed$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUnknownRecordTypeAreIgnored() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUnknownRecordTypeAreIgnored$1(this, replicaManager, tp, log, serde, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testDeserializationErrorFailsTheLoading() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testDeserializationErrorFailsTheLoading$1(this, replicaManager, tp, log, serde, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoadGroupAndOffsetsWithCorruptedLog() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testLoadGroupAndOffsetsWithCorruptedLog$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoadSummary() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        MockTime time = new MockTime();
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl((Time)time, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testLoadSummary$1(this, time, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUpdateLastWrittenOffsetOnBatchLoaded() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUpdateLastWrittenOffsetOnBatchLoaded$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUpdateLastWrittenOffsetAndUpdateLastCommittedOffsetNoRecordsRead() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUpdateLastWrittenOffsetAndUpdateLastCommittedOffsetNoRecordsRead$1(replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUpdateLastWrittenOffsetOnBatchLoadedWhileHighWatermarkAhead() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUpdateLastWrittenOffsetOnBatchLoadedWhileHighWatermarkAhead$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testPartitionGoesOfflineDuringLoad() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS()), (Function1 & Serializable)loader -> {
            Mockito.when((Object)replicaManager.getLog(tp)).thenReturn((Object)new Some((Object)log));
            Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
            Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
            Mockito.when((Object)replicaManager.getLogEndOffset(tp)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)5L))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)));
            .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
            long x$3 = -1L;
            short x$4 = -1;
            FetchDataInfo readResult1 = this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
            Mockito.when((Object)log.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
            .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
            long x$7 = -1L;
            short x$8 = -1;
            FetchDataInfo readResult2 = this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
            Mockito.when((Object)log.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
            return (NotLeaderOrFollowerException)TestUtils.assertFutureThrows(NotLeaderOrFollowerException.class, (Future)loader.load(tp, coordinator));
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUpdateLastWrittenOffsetCommitInterval() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000, 2L), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUpdateLastWrittenOffsetCommitInterval$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private FetchDataInfo logReadResult(long startOffset, long producerId, short producerEpoch, Seq<SimpleRecord> records) {
        MemoryRecords memoryRecords;
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        if (producerId == -1L) {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            NoCompression withRecords_compression = Compression.NONE;
            TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
            memoryRecords = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            Object var16_8 = null;
            Object var10_7 = null;
            simpleRecordArray = null;
        } else {
            void withTransactionalRecords_records;
            void withTransactionalRecords_partitionLeaderEpoch;
            void withTransactionalRecords_baseSequence;
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            int n = -1;
            boolean bl = false;
            NoCompression withTransactionalRecords_compression = Compression.NONE;
            memoryRecords = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withTransactionalRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)withTransactionalRecords_partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
            Object var12_12 = null;
            simpleRecordArray = null;
        }
        MemoryRecords memoryRecords2 = memoryRecords;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecords.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)memoryRecords2.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecords.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(memoryRecords2.buffer().duplicate());
            return buffer.flip();
        });
        return new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecords);
    }

    private FetchDataInfo logReadResult(long startOffset, long producerId, short producerEpoch, ControlRecordType controlRecordType) {
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        MemoryRecords memoryRecords = MemoryRecords.withEndTransactionMarker((long)startOffset, (long)0L, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(controlRecordType, 0));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecords.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)memoryRecords.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecords.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(memoryRecords.buffer().duplicate());
            return buffer.flip();
        });
        return new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecords);
    }

    private long logReadResult$default$2() {
        return -1L;
    }

    private short logReadResult$default$3() {
        return -1;
    }

    public static final /* synthetic */ void $anonfun$testLoading$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$2, TopicPartition tp$3, UnifiedLog log$1, CoordinatorPlayback coordinator$3, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$2.getLog(tp$3)).thenReturn((Object)new Some((Object)log$1));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$1.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$2.getLogEndOffset(tp$3)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)9L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$1.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$1.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$1.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        FetchDataInfo readResult3 = $this.logReadResult(5L, 100L, (short)5, (Seq<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v6".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v7".getBytes()), (List)Nil$.MODULE$)));
        Mockito.when((Object)log$1.read(5L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult3);
        FetchDataInfo readResult4 = $this.logReadResult(7L, 100L, (short)5, ControlRecordType.COMMIT);
        Mockito.when((Object)log$1.read(7L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult4);
        FetchDataInfo readResult5 = $this.logReadResult(8L, 500L, (short)10, ControlRecordType.ABORT);
        Mockito.when((Object)log$1.read(8L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult5);
        Assertions.assertNotNull(loader.load(tp$3, coordinator$3).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(0L, -1L, (short)-1, (Object)new Tuple2((Object)"k1", (Object)"v1"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(2L, -1L, (short)-1, (Object)new Tuple2((Object)"k3", (Object)"v3"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(3L, -1L, (short)-1, (Object)new Tuple2((Object)"k4", (Object)"v4"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(4L, -1L, (short)-1, (Object)new Tuple2((Object)"k5", (Object)"v5"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(5L, 100L, (short)5, (Object)new Tuple2((Object)"k6", (Object)"v6"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(6L, 100L, (short)5, (Object)new Tuple2((Object)"k7", (Object)"v7"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replayEndTransactionMarker(100L, (short)5, TransactionResult.COMMIT);
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replayEndTransactionMarker(500L, (short)10, TransactionResult.ABORT);
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastWrittenOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastWrittenOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastWrittenOffset(Predef$.MODULE$.long2Long(7L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastWrittenOffset(Predef$.MODULE$.long2Long(8L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastCommittedOffset(Predef$.MODULE$.long2Long(0L));
    }

    public static final /* synthetic */ void $anonfun$testLoadingStoppedWhenClosed$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$3, TopicPartition tp$4, UnifiedLog log$2, CoordinatorPlayback coordinator$4, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$3.getLog(tp$4)).thenReturn((Object)new Some((Object)log$2));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$2.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$3.getLogEndOffset(tp$4)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)100L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)log$2.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)1000), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenAnswer(x$1 -> {
            latch.countDown();
            return readResult;
        });
        CompletableFuture result = loader.load(tp$4, coordinator$4);
        latch.await(10L, TimeUnit.SECONDS);
        loader.close();
        RuntimeException ex = (RuntimeException)TestUtils.assertFutureThrows(RuntimeException.class, (Future)result);
        Assertions.assertEquals((Object)"Coordinator loader is closed.", (Object)ex.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testUnknownRecordTypeAreIgnored$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$4, TopicPartition tp$5, UnifiedLog log$3, StringKeyValueDeserializer serde$1, CoordinatorPlayback coordinator$5, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$4.getLog(tp$5)).thenReturn((Object)new Some((Object)log$3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$3.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$4.getLogEndOffset(tp$5)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$3.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Mockito.when(serde$1.deserialize((ByteBuffer)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any())).thenThrow(new Throwable[]{new Deserializer.UnknownRecordTypeException(1)}).thenReturn((Object)new Tuple2((Object)"k2", (Object)"v2"));
        loader.load(tp$5, coordinator$5).get(10L, TimeUnit.SECONDS);
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$5)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
    }

    public static final /* synthetic */ void $anonfun$testDeserializationErrorFailsTheLoading$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$5, TopicPartition tp$6, UnifiedLog log$4, StringKeyValueDeserializer serde$2, CoordinatorPlayback coordinator$6, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$5.getLog(tp$6)).thenReturn((Object)new Some((Object)log$4));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$4.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$5.getLogEndOffset(tp$6)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$4.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Mockito.when(serde$2.deserialize((ByteBuffer)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Error!")});
        RuntimeException ex = (RuntimeException)TestUtils.assertFutureThrows(RuntimeException.class, (Future)loader.load(tp$6, coordinator$6));
        Assertions.assertEquals((Object)("Deserializing record DefaultRecord(offset=0, timestamp=-1, key=2 bytes, value=2 bytes) from " + tp$6 + " failed due to: Error!"), (Object)ex.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testLoadGroupAndOffsetsWithCorruptedLog$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$6, TopicPartition tp$7, UnifiedLog log$5, CoordinatorPlayback coordinator$7, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$6.getLog(tp$7)).thenReturn((Object)new Some((Object)log$5));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$5.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$6.getLogEndOffset(tp$7)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)10L)));
        Nil$ x$2 = Nil$.MODULE$;
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$5.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Assertions.assertNotNull(loader.load(tp$7, coordinator$7).get(10L, TimeUnit.SECONDS));
    }

    public static final /* synthetic */ void $anonfun$testLoadSummary$1(CoordinatorLoaderImplTest $this, MockTime time$1, ReplicaManager replicaManager$7, TopicPartition tp$8, UnifiedLog log$6, CoordinatorPlayback coordinator$8, CoordinatorLoaderImpl loader) {
        long startTimeMs = time$1.milliseconds();
        Mockito.when((Object)replicaManager$7.getLog(tp$8)).thenReturn((Object)new Some((Object)log$6));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$6.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$7.getLogEndOffset(tp$8)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)5L)));
        .colon.colon x$22 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$22);
        Mockito.when((Object)log$6.read(0L, 1000, FetchIsolation.LOG_END, true)).thenAnswer(x$2 -> {
            time$1.sleep(1000L);
            return readResult1;
        });
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$6.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        CoordinatorLoader.LoadSummary summary = (CoordinatorLoader.LoadSummary)loader.load(tp$8, coordinator$8).get(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)startTimeMs, (long)summary.startTimeMs());
        Assertions.assertEquals((long)(startTimeMs + 1000L), (long)summary.endTimeMs());
        Assertions.assertEquals((long)5L, (long)summary.numRecords());
        Assertions.assertEquals((long)(readResult1.records.sizeInBytes() + readResult2.records.sizeInBytes()), (long)summary.numBytes());
    }

    public static final /* synthetic */ void $anonfun$testUpdateLastWrittenOffsetOnBatchLoaded$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$8, TopicPartition tp$9, UnifiedLog log$7, CoordinatorPlayback coordinator$9, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$8.getLog(tp$9)).thenReturn((Object)new Some((Object)log$7));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$7.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$7.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L)).thenReturn((Object)BoxesRunTime.boxToLong((long)0L)).thenReturn((Object)BoxesRunTime.boxToLong((long)2L));
        Mockito.when((Object)replicaManager$8.getLogEndOffset(tp$9)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)7L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$7.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$7.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        .colon.colon x$10 = new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v6".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v7".getBytes()), (List)Nil$.MODULE$));
        long x$11 = -1L;
        short x$12 = -1;
        FetchDataInfo readResult3 = $this.logReadResult(5L, x$11, x$12, (Seq<SimpleRecord>)x$10);
        Mockito.when((Object)log$7.read(5L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult3);
        Assertions.assertNotNull(loader.load(tp$9, coordinator$9).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(0L, -1L, (short)-1, (Object)new Tuple2((Object)"k1", (Object)"v1"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(2L, -1L, (short)-1, (Object)new Tuple2((Object)"k3", (Object)"v3"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(3L, -1L, (short)-1, (Object)new Tuple2((Object)"k4", (Object)"v4"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(4L, -1L, (short)-1, (Object)new Tuple2((Object)"k5", (Object)"v5"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(5L, -1L, (short)-1, (Object)new Tuple2((Object)"k6", (Object)"v6"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(6L, -1L, (short)-1, (Object)new Tuple2((Object)"k7", (Object)"v7"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(7L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(5L));
    }

    public static final /* synthetic */ void $anonfun$testUpdateLastWrittenOffsetAndUpdateLastCommittedOffsetNoRecordsRead$1(ReplicaManager replicaManager$9, TopicPartition tp$10, UnifiedLog log$8, CoordinatorPlayback coordinator$10, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$9.getLog(tp$10)).thenReturn((Object)new Some((Object)log$8));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$8.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$8.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$9.getLogEndOffset(tp$10)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertNotNull(loader.load(tp$10, coordinator$10).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$10, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(ArgumentMatchers.anyLong()));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$10, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(ArgumentMatchers.anyLong()));
    }

    public static final /* synthetic */ void $anonfun$testUpdateLastWrittenOffsetOnBatchLoadedWhileHighWatermarkAhead$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$10, TopicPartition tp$11, UnifiedLog log$9, CoordinatorPlayback coordinator$11, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$10.getLog(tp$11)).thenReturn((Object)new Some((Object)log$9));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$9.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$9.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L)).thenReturn((Object)BoxesRunTime.boxToLong((long)7L)).thenReturn((Object)BoxesRunTime.boxToLong((long)7L));
        Mockito.when((Object)replicaManager$10.getLogEndOffset(tp$11)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)7L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$9.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$9.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        .colon.colon x$10 = new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v6".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v7".getBytes()), (List)Nil$.MODULE$));
        long x$11 = -1L;
        short x$12 = -1;
        FetchDataInfo readResult3 = $this.logReadResult(5L, x$11, x$12, (Seq<SimpleRecord>)x$10);
        Mockito.when((Object)log$9.read(5L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult3);
        Assertions.assertNotNull(loader.load(tp$11, coordinator$11).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(0L, -1L, (short)-1, (Object)new Tuple2((Object)"k1", (Object)"v1"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(2L, -1L, (short)-1, (Object)new Tuple2((Object)"k3", (Object)"v3"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(3L, -1L, (short)-1, (Object)new Tuple2((Object)"k4", (Object)"v4"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(4L, -1L, (short)-1, (Object)new Tuple2((Object)"k5", (Object)"v5"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(5L, -1L, (short)-1, (Object)new Tuple2((Object)"k6", (Object)"v6"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(6L, -1L, (short)-1, (Object)new Tuple2((Object)"k7", (Object)"v7"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(7L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(7L));
    }

    public static final /* synthetic */ void $anonfun$testUpdateLastWrittenOffsetCommitInterval$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$12, TopicPartition tp$13, UnifiedLog log$11, CoordinatorPlayback coordinator$13, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$12.getLog(tp$13)).thenReturn((Object)new Some((Object)log$11));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$11.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$11.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)7L));
        Mockito.when((Object)replicaManager$12.getLogEndOffset(tp$13)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)7L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$11.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$11.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        .colon.colon x$10 = new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v6".getBytes()), (List)Nil$.MODULE$);
        long x$11 = -1L;
        short x$12 = -1;
        FetchDataInfo readResult3 = $this.logReadResult(5L, x$11, x$12, (Seq<SimpleRecord>)x$10);
        Mockito.when((Object)log$11.read(5L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult3);
        .colon.colon x$14 = new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v7".getBytes()), (List)Nil$.MODULE$);
        long x$15 = -1L;
        short x$16 = -1;
        FetchDataInfo readResult4 = $this.logReadResult(6L, x$15, x$16, (Seq<SimpleRecord>)x$14);
        Mockito.when((Object)log$11.read(6L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult4);
        Assertions.assertNotNull(loader.load(tp$13, coordinator$13).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13)).replay(0L, -1L, (short)-1, (Object)new Tuple2((Object)"k1", (Object)"v1"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13)).replay(2L, -1L, (short)-1, (Object)new Tuple2((Object)"k3", (Object)"v3"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13)).replay(3L, -1L, (short)-1, (Object)new Tuple2((Object)"k4", (Object)"v4"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13)).replay(4L, -1L, (short)-1, (Object)new Tuple2((Object)"k5", (Object)"v5"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13)).replay(5L, -1L, (short)-1, (Object)new Tuple2((Object)"k6", (Object)"v6"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13)).replay(6L, -1L, (short)-1, (Object)new Tuple2((Object)"k7", (Object)"v7"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(6L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(7L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(6L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$13, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(7L));
    }
}

