/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.Lz4Compression;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogCleaner;
import org.apache.kafka.storage.internals.log.LogCleanerManager;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAqa\b\u0001C\u0002\u0013\u0005\u0001\u0005\u0003\u0004/\u0001\u0001\u0006I!\t\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019I\u0004\u0001)A\u0005c!9!\b\u0001b\u0001\n\u0003Y\u0004B\u0002$\u0001A\u0003%A\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003X\u0001\u0011\u0005\u0001\nC\u0003]\u0001\u0011%Q\f\u0003\u0004]\u0001\u0011%\u00111\u0001\u0005\u00079\u0002!I!a\n\t\r\u0005]\u0002\u0001\"\u0001I\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!a\u001b\u0001\t\u0013\ti\u0007\u0003\u0004\u0002\u0014\u0002!\t\u0001\u0013\u0002\u001a\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0014)\u0005\u0019An\\4\u000b\u0003U\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011DG\u0007\u0002%%\u00111D\u0005\u0002\"\u0003\n\u001cHO]1di2{wm\u00117fC:,'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"!\u0007\u0001\u0002\u000b\r|G-Z2\u0016\u0003\u0005\u0002\"A\t\u0017\u000e\u0003\rR!\u0001J\u0013\u0002\u0011\r|W\u000e\u001d:fgNT!AJ\u0014\u0002\r\r|W.\\8o\u0015\t)\u0002F\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<\u0017BA\u0017$\u0005-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\u0002\r\r|G-Z2!\u0003\u0011!\u0018.\\3\u0016\u0003E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0003m\u001d\naa]3sm\u0016\u0014\u0018B\u0001\u001d4\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003q\u00022!\u0010!C\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$!B!se\u0006L\bCA\"E\u001b\u0005)\u0013BA#&\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000f\rdW-\u00198vaR\t\u0011\n\u0005\u0002>\u0015&\u00111J\u0010\u0002\u0005+:LG\u000f\u000b\u0002\t\u001bB\u0011a*V\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0004CBL'B\u0001*T\u0003\u001dQW\u000f]5uKJT!\u0001\u0016\u0016\u0002\u000b),h.\u001b;\n\u0005Y{%!C!gi\u0016\u0014X)Y2i\u0003i\"Xm\u001d;NCJ\\7\u000fU1si&$\u0018n\u001c8t\u0003N|eM\u001a7j]\u0016\fe\u000e\u001a)paVd\u0017\r^3t+:\u001cG.Z1oC\ndW-T3ue&\u001c7\u000f\u000b\u0002\n3B\u0011aJW\u0005\u00037>\u0013A\u0001V3ti\u0006Aq-\u001a;HCV<W-\u0006\u0002_[R\u0011qL\u001e\t\u0004A&\\W\"A1\u000b\u0005\t\u001c\u0017\u0001B2pe\u0016T!\u0001Z3\u0002\u000f5,GO]5dg*\u0011amZ\u0001\u0007s\u0006lW.\u001a:\u000b\u0003!\f1aY8n\u0013\tQ\u0017MA\u0003HCV<W\r\u0005\u0002m[2\u0001A!\u00028\u000b\u0005\u0004y'!\u0001+\u0012\u0005A\u001c\bCA\u001fr\u0013\t\u0011hHA\u0004O_RD\u0017N\\4\u0011\u0005u\"\u0018BA;?\u0005\r\te.\u001f\u0005\u0006o*\u0001\r\u0001_\u0001\u0007M&dG/\u001a:\u0011\tuJ8P`\u0005\u0003uz\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0001d\u0018BA?b\u0005)iU\r\u001e:jG:\u000bW.\u001a\t\u0003{}L1!!\u0001?\u0005\u001d\u0011un\u001c7fC:,B!!\u0002\u0002\fQ!\u0011qAA\u0007!\u0011\u0001\u0017.!\u0003\u0011\u00071\fY\u0001B\u0003o\u0017\t\u0007q\u000eC\u0004\u0002\u0010-\u0001\r!!\u0005\u0002\u00155,GO]5d\u001d\u0006lW\r\u0005\u0003\u0002\u0014\u0005\u0005b\u0002BA\u000b\u0003;\u00012!a\u0006?\u001b\t\tIBC\u0002\u0002\u001cY\ta\u0001\u0010:p_Rt\u0014bAA\u0010}\u00051\u0001K]3eK\u001aLA!a\t\u0002&\t11\u000b\u001e:j]\u001eT1!a\b?+\u0011\tI#a\f\u0015\r\u0005-\u0012\u0011GA\u001a!\u0011\u0001\u0017.!\f\u0011\u00071\fy\u0003B\u0003o\u0019\t\u0007q\u000eC\u0004\u0002\u00101\u0001\r!!\u0005\t\u000f\u0005UB\u00021\u0001\u0002\u0012\u0005YQ.\u001a;sS\u000e\u001c6m\u001c9f\u0003]!Xm\u001d;NCbdunZ\"p[B\f7\r^5p]2\u000bw\r\u000b\u0002\u000e3\u0006Y!/Z1e\rJ|W\u000eT8h)\u0011\ty$a\u0016\u0011\r\u0005\u0005\u0013qIA&\u001b\t\t\u0019EC\u0002\u0002Fy\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI%a\u0011\u0003\u0011%#XM]1cY\u0016\u0004r!PA'\u0003#\n\t&C\u0002\u0002Py\u0012a\u0001V;qY\u0016\u0014\u0004cA\u001f\u0002T%\u0019\u0011Q\u000b \u0003\u0007%sG\u000f\u0003\u0004\u0014\u001d\u0001\u0007\u0011\u0011\f\t\u0005\u00037\n9'\u0004\u0002\u0002^)\u00191#a\u0018\u000b\t\u0005\u0005\u00141M\u0001\nS:$XM\u001d8bYNT1!!\u001a(\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u001b\u0002^\tQQK\\5gS\u0016$Gj\\4\u0002\u0019]\u0014\u0018\u000e^3LKf$U\u000f]:\u0015!\u0005=\u0014QOA=\u0003{\ny(!!\u0002\f\u0006=\u0005CBA!\u0003c\nY%\u0003\u0003\u0002t\u0005\r#aA*fc\"9\u0011qO\bA\u0002\u0005E\u0013a\u00028v[.+\u0017p\u001d\u0005\b\u0003wz\u0001\u0019AA)\u0003\u001dqW/\u001c#vaNDaaE\bA\u0002\u0005e\u0003\"B\u0010\u0010\u0001\u0004\t\u0003bBAB\u001f\u0001\u0007\u0011QQ\u0001\ni&lWm\u001d;b[B\u00042!PAD\u0013\r\tII\u0010\u0002\u0005\u0019>tw\rC\u0004\u0002\u000e>\u0001\r!!\u0015\u0002\u0015M$\u0018M\u001d;WC2,X\rC\u0004\u0002\u0012>\u0001\r!!\u0015\u0002\tM$X\r]\u0001\u0013i\u0016\u001cH/S:UQJ,\u0017\r\u001a$bS2,G\r\u000b\u0002\u00113\u0002")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final Compression codec = new Lz4Compression.Builder().build();
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};

    public Compression codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get(this.topicPartitions()[0]);
        UnifiedLog log2 = (UnifiedLog)this.cleaner().logs().get(this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"There should be 2 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = Predef$.MODULE$.Long2long((Long)LogCleanerManager.calculateCleanableBytes((UnifiedLog)log, (long)0L, (long)((LogSegment)CollectionConverters$.MODULE$.ListHasAsScala(log.logSegments()).asScala().last()).baseOffset()).getValue()) + Predef$.MODULE$.Long2long((Long)LogCleanerManager.calculateCleanableBytes((UnifiedLog)log2, (long)0L, (long)((LogSegment)CollectionConverters$.MODULE$.ListHasAsScala(log2.logSegments()).asScala().last()).baseOffset()).getValue());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 1000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains(this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains(this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains(this.topicPartitions()[2]));
        this.cleaner().logs().remove(this.topicPartitions()[0]);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 2000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(this, uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"There should be 1 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions2 = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains(this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions2.contains(this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains(this.topicPartitions()[2]));
    }

    private <T> Gauge<T> getGauge(Function1<MetricName, Object> filter) {
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable getGauge_filter = (Function1 & Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$3(metricName, mName));
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable getGauge_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$4(metricName, metricScope, k));
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get(topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, (Compression)Compression.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep((long)(maxCompactionLagMs / 2));
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep((long)(maxCompactionLagMs / 2 + 1));
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, (Compression)Compression.NONE, T1, 0, 0);
        log.roll();
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        this.cleaner().awaitCleaned(new TopicPartition("log", 0), firstBlockCleanableSegmentOffset, 60000L);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        Long lastCleaned = (Long)this.cleaner().cleanerManager().allCleanerCheckpoints().get(new TopicPartition("log", 0));
        Assertions.assertTrue((Predef$.MODULE$.Long2long(lastCleaned) >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)("log cleaner should have processed at least to offset " + firstBlockCleanableSegmentOffset + ", but lastCleaned=" + lastCleaned));
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.time().sleep((long)(maxCompactionLagMs + 1));
        this.cleaner().awaitCleaned(new TopicPartition("log", 0), activeSegAtT1.baseOffset(), 60000L);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        Long lastCleaned2 = (Long)this.cleaner().cleanerManager().allCleanerCheckpoints().get(new TopicPartition("log", 0));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((Predef$.MODULE$.Long2long(lastCleaned2) >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)("log cleaner should have processed at least to offset " + secondBlockCleanableSegmentOffset + ", but lastCleaned=" + lastCleaned2));
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(log.logSegments()).asScala().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)record -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())));
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2())));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }));
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, UnifiedLog log, Compression codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$1 -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)x$1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, 100000, x$6, x$7, x$8, x$9, x$10, x$11));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().forEach(x$2 -> x$2.interrupt());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Threads didn't terminate unexpectedly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get(tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)CollectionConverters$.MODULE$.ListHasAsScala(log.logSegments()).asScala().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(long expectedTotalUncleanableBytes$1) {
        return "There should be " + expectedTotalUncleanableBytes$1 + " uncleanable bytes";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(LogCleanerIntegrationTest $this, Gauge uncleanablePartitionsCountGauge$1) {
        $this.time().sleep(1000L);
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6() {
        return "There should be 1 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName k = (MetricName)x0$1._1();
            return BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$3(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$4(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, UnifiedLog log$1, Compression codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = 2;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0);
        log$1.updateHighWatermark(log$1.logEndOffset());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, UnifiedLog log$1, Compression codec$1, long timestamp$1, int step$1, int x$1) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)CollectionConverters$.MODULE$.ListHasAsScala($this.cleaner().cleaners()).asScala().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }
}

