/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kafka.network.Processor$;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.BrokerFeatures;
import org.apache.kafka.server.DefaultApiVersionManager;
import org.apache.kafka.server.SimpleApiVersionManager;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005=2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u00011!)Q\u0006\u0001C\u00011\ti\u0001K]8dKN\u001cxN\u001d+fgRT!\u0001C\u0005\u0002\u000f9,Go^8sW*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u000f\u0005aC/Z:u!\u0006\u00148/\u001a*fcV,7\u000f\u001e%fC\u0012,'oV5uQ\u0012K7/\u00192mK\u0012\f\u0005/\u001b,feNLwN\u001c\u000b\u00023A\u0011aBG\u0005\u00037=\u0011A!\u00168ji\"\u0012!!\b\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\n1!\u00199j\u0015\t\u00113%A\u0004kkBLG/\u001a:\u000b\u0005\u0011*\u0013!\u00026v]&$(\"\u0001\u0014\u0002\u0007=\u0014x-\u0003\u0002)?\t!A+Z:u\u0003!\"Xm\u001d;QCJ\u001cXMU3rk\u0016\u001cH\u000fS3bI\u0016\u0014x+\u001b;i+:\u001cX\u000f\u001d9peR,G-\u00119jQ\t\u0019Q$A\u0018uKN$\b+\u0019:tKJ+\u0017/^3ti\"+\u0017\rZ3s/&$\b.\u00168tkB\u0004xN\u001d;fI\u0006\u0003\u0018NV3sg&|g\u000e\u000b\u0002\u0005;\u00051C/Z:u!\u0006\u00148/\u001a*fcV,7\u000f\u001e%fC\u0012,'OR8s!J|G-^2f-B\"vN\u0016\u001a)\u0005\u0015i\u0002")
public class ProcessorTest {
    @Test
    public void testParseRequestHeaderWithDisabledApiVersion() {
        ByteBuffer requestHeader = RequestTestUtils.serializeRequestHeader((RequestHeader)new RequestHeader(ApiKeys.INIT_PRODUCER_ID, 0, "clientid", 0));
        SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER, true, () -> new FinalizedFeatures(MetadataVersion.latestTesting(), Map.of(), 0L));
        Assertions.assertTrue((boolean)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> Processor$.MODULE$.parseRequestHeader((ApiVersionManager)apiVersionManager, requestHeader), (String)"INIT_PRODUCER_ID with listener type CONTROLLER should throw InvalidRequestException exception")).toString().contains("disabled api"));
    }

    @Test
    public void testParseRequestHeaderWithUnsupportedApi() {
        short headerVersion = (short)0;
        RequestHeaderData requestHeaderData = new RequestHeaderData().setRequestApiKey(ApiKeys.LEADER_AND_ISR.id).setRequestApiVersion(headerVersion).setClientId("clientid").setCorrelationId(0);
        ByteBuffer requestHeader = RequestTestUtils.serializeRequestHeader((RequestHeader)new RequestHeader(requestHeaderData, headerVersion));
        DefaultApiVersionManager apiVersionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, (Supplier)Mockito.mock(Supplier.class), BrokerFeatures.createDefault((boolean)true), (MetadataCache)new KRaftMetadataCache(0, () -> KRaftVersion.LATEST_PRODUCTION), true, Optional.empty());
        Assertions.assertTrue((boolean)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> Processor$.MODULE$.parseRequestHeader((ApiVersionManager)apiVersionManager, requestHeader), (String)"LEADER_AND_ISR should throw InvalidRequestException exception")).toString().contains("Unsupported api"));
    }

    @Test
    public void testParseRequestHeaderWithUnsupportedApiVersion() {
        ByteBuffer requestHeader = RequestTestUtils.serializeRequestHeader((RequestHeader)new RequestHeader(ApiKeys.FETCH, 0, "clientid", 0));
        DefaultApiVersionManager apiVersionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, (Supplier)Mockito.mock(Supplier.class), BrokerFeatures.createDefault((boolean)true), (MetadataCache)new KRaftMetadataCache(0, () -> KRaftVersion.LATEST_PRODUCTION), true, Optional.empty());
        Assertions.assertTrue((boolean)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> Processor$.MODULE$.parseRequestHeader((ApiVersionManager)apiVersionManager, requestHeader), (String)"FETCH v0 should throw UnsupportedVersionException exception")).toString().contains("unsupported version"));
    }

    @Test
    public void testParseRequestHeaderForProduceV0ToV2() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            ByteBuffer requestHeader = RequestTestUtils.serializeRequestHeader((RequestHeader)new RequestHeader(ApiKeys.PRODUCE, (short)version, "clientid", 0));
            DefaultApiVersionManager apiVersionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, (Supplier)Mockito.mock(Supplier.class), BrokerFeatures.createDefault((boolean)true), (MetadataCache)new KRaftMetadataCache(0, () -> KRaftVersion.LATEST_PRODUCTION), true, Optional.empty());
            Assertions.assertTrue((boolean)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> Processor$.MODULE$.parseRequestHeader((ApiVersionManager)apiVersionManager, requestHeader), (String)("PRODUCE " + version + " should throw UnsupportedVersionException exception"))).toString().contains("unsupported version"));
        });
    }
}

