/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLogTest$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ArbitraryMemoryRecords;
import org.apache.kafka.common.record.InvalidMemoryRecordsProvider;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.MetadataLogConfig;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.SegmentPosition;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u00115a\u0001B(Q\u0005UCQ\u0001\u0018\u0001\u0005\u0002uC\u0011\u0002\u0019\u0001A\u0002\u0003\u0007I\u0011A1\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0003Y\u0007\"C9\u0001\u0001\u0004\u0005\t\u0015)\u0003c\u0011\u001d\u0011\bA1A\u0005\u0002MDq!a\u0001\u0001A\u0003%A\u000fC\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\b!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005\u001d\u0001bBA\u001a\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003o\u0001A\u0011AA\u0004\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a,\u0001\t\u0003\t\t\fC\u0004\u0002l\u0002!\t!a\u0002\t\u000f\u0005=\b\u0001\"\u0001\u0002\b!9\u00111\u001f\u0001\u0005\u0002\u0005\u001d\u0001bBA|\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003w\u0004A\u0011AA\u0004\u0011\u001d\ty\u0010\u0001C\u0001\u0003\u000fAqAa\u0001\u0001\t\u0003\t9\u0001C\u0004\u0003\b\u0001!\t!a\u0002\t\u000f\t-\u0001\u0001\"\u0001\u0002\b!9!q\u0002\u0001\u0005\u0002\u0005\u001d\u0001b\u0002B\n\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0005/\u0001A\u0011AA\u0004\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003\u000fAqAa\b\u0001\t\u0003\t9\u0001C\u0004\u0003$\u0001!\t!a\u0002\t\u000f\t\u001d\u0002\u0001\"\u0001\u0002\b!9!1\u0006\u0001\u0005\u0002\u0005\u001d\u0001b\u0002B\u0018\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0005g\u0001A\u0011AA\u0004\u0011\u001d\u00119\u0004\u0001C\u0005\u0005sAqAa\u0010\u0001\t\u0013\u0011\t\u0005C\u0004\u0003V\u0001!\t!a\u0002\t\u000f\te\u0003\u0001\"\u0001\u0002\b!9!Q\f\u0001\u0005\u0002\u0005\u001d\u0001b\u0002B1\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0005K\u0002A\u0011AA\u0004\u0011\u001d\u0011I\u0007\u0001C\u0001\u0003\u000fAqA!\u001c\u0001\t\u0013\u0011y\u0007C\u0004\u0003\u0004\u0002!\t!a\u0002\t\u000f\t\u001d\u0005\u0001\"\u0001\u0002\b!9!1\u0012\u0001\u0005\u0002\u0005\u001d\u0001b\u0002BH\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0005'\u0003A\u0011AA\u0004\u0011\u001d\u00119\n\u0001C\u0001\u0003\u000fAqAa'\u0001\t\u0003\t9\u0001C\u0004\u0003 \u0002!\t!a\u0002\t\u000f\t\r\u0006\u0001\"\u0001\u0002\b!9!q\u0015\u0001\u0005\u0002\u0005\u001d\u0001b\u0002BV\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0005_\u0003A\u0011AA\u0004\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0003\u000fAqAa.\u0001\t\u0003\t9aB\u0004\u0003<BC\tA!0\u0007\r=\u0003\u0006\u0012\u0001B`\u0011\u0019a\u0016\b\"\u0001\u0003B\u001a1!1Y\u001d\u0001\u0005\u000bDa\u0001X\u001e\u0005\u0002\t-\bb\u0002B?w\u0011\u0005#\u0011\u001f\u0005\b\u0007\u000fYD\u0011IB\u0005\u0011\u001d\u0019Ib\u000fC!\u00077A\u0011ba\u000b:\u0005\u0004%\ta!\f\t\u0011\re\u0012\b)A\u0005\u0007_Aqaa\u000f:\t\u0003\u0019i\u0004C\u0005\u0004fe\n\n\u0011\"\u0001\u0004h!91QP\u001d\u0005\u0002\r}\u0004\"CBDsE\u0005I\u0011AB4\u0011\u001d\u0019I)\u000fC\u0001\u0007\u0017Cqaa%:\t\u0003\u0019)\nC\u0004\u0004\u001cf\"\ta!(\t\u000f\rm\u0015\b\"\u0001\u00046\"91\u0011Z\u001d\u0005\n\r-\u0007bBBms\u0011%11\u001c\u0005\n\u0007\u007fL\u0014\u0013!C\u0005\t\u0003A\u0011\u0002\"\u0002:#\u0003%I\u0001\"\u0001\t\u0013\u0011\u001d\u0011(%A\u0005\n\u0011%!\u0001F&bM.\fW*\u001a;bI\u0006$\u0018\rT8h)\u0016\u001cHO\u0003\u0002R%\u0006!!/\u00194u\u0015\u0005\u0019\u0016!B6bM.\f7\u0001A\n\u0003\u0001Y\u0003\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001_!\ty\u0006!D\u0001Q\u0003\u001d!X-\u001c9ESJ,\u0012A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f!![8\u000b\u0003\u001d\fAA[1wC&\u0011\u0011\u000e\u001a\u0002\u0005\r&dW-A\u0006uK6\u0004H)\u001b:`I\u0015\fHC\u00017p!\t9V.\u0003\u0002o1\n!QK\\5u\u0011\u001d\u00018!!AA\u0002\t\f1\u0001\u001f\u00132\u0003!!X-\u001c9ESJ\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0003Q\u0004\"!^@\u000e\u0003YT!a\u001e=\u0002\tU$\u0018\u000e\u001c\u0006\u0003sj\faa]3sm\u0016\u0014(BA*|\u0015\taX0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0006\u0019qN]4\n\u0007\u0005\u0005aO\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%A\u0003tKR,\u0006\u000fF\u0001mQ\r9\u00111\u0002\t\u0005\u0003\u001b\tY\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\r\t\u0007/\u001b\u0006\u0005\u0003+\t9\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005eQ0A\u0003kk:LG/\u0003\u0003\u0002\u001e\u0005=!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\t\u0003G\u0001B!!\u0004\u0002&%!\u0011qEA\b\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0006uKN$8i\u001c8gS\u001eD3!CA\u0017!\u0011\ti!a\f\n\t\u0005E\u0012q\u0002\u0002\u0005)\u0016\u001cH/\u0001\u000euKN$XK\\3ya\u0016\u001cG/\u001a3BaB,g\u000eZ(gMN,G\u000fK\u0002\u000b\u0003[\t\u0011\u0004^3ti\u0016k\u0007\u000f^=BaB,g\u000e\u001a(pi\u0006cGn\\<fI\"\u001a1\"!\f\u00021Q,7\u000f^%om\u0006d\u0017\u000eZ'f[>\u0014\u0018PU3d_J$7\u000fF\u0003m\u0003\u007f\t\u0019\u0006C\u0004\u0002B1\u0001\r!a\u0011\u0002\u000fI,7m\u001c:egB!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013A\u0002:fG>\u0014HMC\u0002\u0002Ni\faaY8n[>t\u0017\u0002BA)\u0003\u000f\u0012Q\"T3n_JL(+Z2pe\u0012\u001c\bbBA+\u0019\u0001\u0007\u0011qK\u0001\u0012Kb\u0004Xm\u0019;fI\u0016C8-\u001a9uS>t\u0007CBA-\u0003;\n\t'\u0004\u0002\u0002\\)\u0011qOZ\u0005\u0005\u0003?\nYF\u0001\u0005PaRLwN\\1m!\u0019\t\u0019'!\u001d\u0002x9!\u0011QMA7!\r\t9\u0007W\u0007\u0003\u0003SR1!a\u001bU\u0003\u0019a$o\\8u}%\u0019\u0011q\u000e-\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019(!\u001e\u0003\u000b\rc\u0017m]:\u000b\u0007\u0005=\u0004\f\u0005\u0003\u0002z\u0005\re\u0002BA>\u0003\u007frA!a\u001a\u0002~%\t\u0011,C\u0002\u0002\u0002b\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0006\u0006\u001d%!C#yG\u0016\u0004H/[8o\u0015\r\t\t\t\u0017\u0015\u0004\u0019\u0005-\u0005\u0003BAG\u0003'k!!a$\u000b\t\u0005E\u00151C\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005U\u0015q\u0012\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bf\u0002\u0007\u0002\u001a\u0006\u0015\u0016q\u0015\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*!\u0011qTAH\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BAR\u0003;\u0013q\"\u0011:hk6,g\u000e^:T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003S\u0003B!!\u0012\u0002,&!\u0011QVA$\u0005qIeN^1mS\u0012lU-\\8ssJ+7m\u001c:egB\u0013xN^5eKJ\f\u0011\u0003^3tiJ\u000bg\u000eZ8n%\u0016\u001cwN\u001d3t)\ra\u00171\u0017\u0005\b\u0003\u0003j\u0001\u0019AA\"Q!\t\u0019,a.\u0002J\u0006-\u0007\u0003BA]\u0003\u000bl!!a/\u000b\t\u0005E\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0003kc^L7N\u0003\u0002\u0002D\u0006\u0019a.\u001a;\n\t\u0005\u001d\u00171\u0018\u0002\u0007\r>\u0014\u0018\t\u001c7\u0002\u0011M,\b\u000f\u001d7jKJ\u001c#!!4\u0011\t\u0005\u0015\u0013qZ\u0005\u0005\u0003#\f9E\u0001\fBe\nLGO]1ss6+Wn\u001c:z%\u0016\u001cwN\u001d3tQ-i\u0011Q[An\u0003;\fy.!9\u0011\t\u0005e\u0016q[\u0005\u0005\u00033\fYL\u0001\u0005Qe>\u0004XM\u001d;z\u0003\u0015!(/[3t;\u0005!\u0017\u0001D1gi\u0016\u0014h)Y5mkJ,GEAAr\u0013\u0011\t)/a:\u0002\u0017M\u000bU\n\u0015'F?>sE*\u0017\u0006\u0005\u0003S\fY,\u0001\tBMR,'OR1jYV\u0014X-T8eK\u00061B/Z:u\u0013:4\u0018\r\\5e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eK\u0002\u000f\u0003[\t!\u0003^3ti\u000e\u0013X-\u0019;f':\f\u0007o\u001d5pi\"\u001aq\"!\f\u0002?Q,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e$s_6,e\u000eZ(gMN,G\u000fK\u0002\u0011\u0003[\t\u0011\u0005^3ti\u000e\u0013X-\u0019;f':\f\u0007o\u001d5pi&sW*\u001b3eY\u0016|eMQ1uG\"D3!EA\u0017\u0003!\"Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;MCR,'\u000f\u00165b]\"Kw\r[,bi\u0016\u0014X.\u0019:lQ\r\u0011\u0012QF\u0001!i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|G/T;dQ2\u000bG/\u001a:Fa>\u001c\u0007\u000eK\u0002\u0014\u0003[\tq\u0004^3ti\"Kw\r[,bi\u0016\u0014X.\u0019:l\u001f\u001a47/\u001a;NKR\fG-\u0019;bQ\r!\u0012QF\u0001'i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GOQ3g_J,Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bfA\u000b\u0002.\u0005\u0001C/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\t&4XM]4j]\u001e,\u0005o\\2iQ\r1\u0012QF\u0001\u001di\u0016\u001cHo\u0011:fCR,7K\\1qg\"|Go\u00147eKJ,\u0005o\\2iQ\r9\u0012QF\u0001#i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GoV5uQ6K7o]5oO\u0016\u0003xn\u00195)\u0007a\ti#\u0001\u000euKN$8I]3bi\u0016,\u00050[:uS:<7K\\1qg\"|G\u000fK\u0002\u001a\u0003[\t1\u0002^3tiR{\u0007/[2JI\"\u001a!$!\f\u0002/Q,7\u000f\u001e*fC\u0012l\u0015n]:j]\u001e\u001cf.\u00199tQ>$\bfA\u000e\u0002.\u0005iB/Z:u\t\u0016dW\r^3O_:,\u00050[:uK:$8K\\1qg\"|G\u000fK\u0002\u001d\u0003[\t\u0011\u0005^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7z)>d\u0015\r^3tiNs\u0017\r]:i_RD3!HA\u0017\u0003\r\"Xm\u001d;UeVt7-\u0019;f/&dGNU3n_Z,w\n\u001c3feNs\u0017\r]:i_RD3AHA\u0017\u0003\r\"Xm\u001d;Ti\u0006\u0014H/\u001e9XSRD\u0017J\u001c<bY&$7K\\1qg\"|Go\u0015;bi\u0016D3aHA\u0017\u00031\"Xm\u001d;T]\u0006\u00048\u000f[8u\t\u0016dW\r^5p]^KG\u000f[%om\u0006d\u0017\u000eZ*oCB\u001c\bn\u001c;Ti\u0006$X\rK\u0002!\u0003[\ta\"\\3uC\u0012\fG/\u0019'pO\u0012K'\u000fF\u0002c\u0005wAaA!\u0010\"\u0001\u0004\u0011\u0017A\u00027pO\u0012K'/\u0001\nxe&$X-R7qif\u001cf.\u00199tQ>$H#\u00027\u0003D\t\u001d\u0003B\u0002B#E\u0001\u0007!-A\u0006nKR\fG-\u0019;b\t&\u0014\bb\u0002B%E\u0001\u0007!1J\u0001\u000bg:\f\u0007o\u001d5pi&#\u0007\u0003\u0002B'\u0005#j!Aa\u0014\u000b\u0007\u00055\u00030\u0003\u0003\u0003T\t=#AD(gMN,G/\u00118e\u000bB|7\r[\u0001\u0018i\u0016\u001cH\u000fR8fg:$HK];oG\u0006$XMR;mYfD3aIA\u0017\u0003m!Xm\u001d;DY\u0016\fg.\u001e9QCJ$\u0018.\u00197T]\u0006\u00048\u000f[8ug\"\u001aA%!\f\u00023Q,7\u000f^\"mK\u0006tW\u000f](mI\u0016\u00148K\\1qg\"|Go\u001d\u0015\u0004K\u00055\u0012!\n;fgR\u001c%/Z1uKJ+\u0007\u000f\\5dCR,G\rT8h)J,hnY1uKN4U\u000f\u001c7zQ\r1\u0013QF\u0001\u0011i\u0016\u001cH/T1y\u0005\u0006$8\r[*ju\u0016D3aJA\u0017\u0003y!Xm\u001d;UeVt7-\u0019;f\u0005\u0016dwn\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eK\u0002)\u0003[\taBY;jY\u00124U\u000f\u001c7CCR\u001c\u0007\u000e\u0006\u0005\u0002D\tE$1\u0010B@\u0011\u001d\u0011\u0019(\u000ba\u0001\u0005k\n1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019qKa\u001e\n\u0007\te\u0004LA\u0002J]RDqA! *\u0001\u0004\u0011)(\u0001\u0006sK\u000e|'\u000fZ*ju\u0016DqA!!*\u0001\u0004\u0011)(A\nnCb\u0014\u0015\r^2i'&TX-\u00138CsR,7/\u0001\u0016uKN$h+\u00197jI\u0006$X-\u00129pG\"<%/Z1uKJ$\u0006.\u00198MCN$8J\\8x]\u0016\u0003xn\u00195)\u0007)\ni#\u0001\u0017uKN$h+\u00197jI\u0006$X-\u00129pG\"dUm]:UQ\u0006tw\n\u001c3fgR\u001cf.\u00199tQ>$X\t]8dQ\"\u001a1&!\f\u0002]Q,7\u000f\u001e,bY&$\u0017\r^3PM\u001a\u001cX\r\u001e'fgN$\u0006.\u00198PY\u0012,7\u000f^*oCB\u001c\bn\u001c;PM\u001a\u001cX\r\u001e\u0015\u0004Y\u00055\u0012!\f;fgR4\u0016\r\\5eCR,wJ\u001a4tKR,\u0015/^1m)>|E\u000eZ3tiNs\u0017\r]:i_R|eMZ:fi\"\u001aQ&!\f\u0002\u0005R,7\u000f\u001e,bY&$\u0017\r^3V].twn\u001e8Fa>\u001c\u0007\u000eT3tgRC\u0017M\u001c'bgR\\en\\<o\u000fJ,\u0017\r^3s)\"\fgn\u00147eKN$8K\\1qg\"|G\u000fK\u0002/\u0003[\t\u0001\u0006^3tiZ\u000bG.\u001b3bi\u0016,\u0005o\\2i\u0019\u0016\u001c8\u000f\u00165b]\u001aK'o\u001d;Fa>\u001c\u0007.\u00138M_\u001eD3aLA\u0017\u0003\u0011\"Xm\u001d;WC2LG-\u0019;f\u001f\u001a47/\u001a;He\u0016\fG\u000f\u00165b]\u0016sGm\u00144gg\u0016$\bf\u0001\u0019\u0002.\u0005iB/Z:u-\u0006d\u0017\u000eZ1uK>3gm]3u\u0019\u0016\u001c8\u000f\u00165b]2+u\nK\u00022\u0003[\tq\u0004^3tiZ\u000bG.\u001b3bi\u00164\u0016\r\\5e\u000bB|7\r[!oI>3gm]3uQ\r\u0011\u0014QF\u0001'i\u0016\u001cH/\u00113wC:\u001cW\rT8h'R\f'\u000f^(gMN,G/\u00114uKJ\u001cE.Z1oS:<\u0007fA\u001a\u0002.\u0005\u0019B/Z:u\t\u0016dW\r^3T]\u0006\u00048\u000f[8ug\"\u001aA'!\f\u0002-Q,7\u000f^*pMR\u0014V\r^3oi&|g\u000eT5nSRD3!NA\u0017\u0003\u0015\"Xm\u001d;TK\u001elWM\u001c;Ng\u000e{gNZ5h\u0013N\u001cV\r^%o\u001b\u0016$\u0018\rZ1uC2{w\rK\u00027\u0003[\t!\u0005^3tiN+w-\\3oiNdUm]:UQ\u0006tG*\u0019;fgR\u001cf.\u00199tQ>$\bfA\u001c\u0002.\u0005!2*\u00194lC6+G/\u00193bi\u0006dun\u001a+fgR\u0004\"aX\u001d\u0014\u0005e2FC\u0001B_\u00059\u0011\u0015\u0010^3BeJ\f\u0017pU3sI\u0016\u001cRa\u000fBd\u0005'\u0004BA!3\u0003P6\u0011!1\u001a\u0006\u0004\u0005\u001b4\u0017\u0001\u00027b]\u001eLAA!5\u0003L\n1qJ\u00196fGR\u0004bA!6\u0003\\\n}WB\u0001Bl\u0015\u0011\u0011INa\u0014\u0002\u001bM,'/[1mSj\fG/[8o\u0013\u0011\u0011iNa6\u0003\u0017I+7m\u001c:e'\u0016\u0014H-\u001a\t\u0006/\n\u0005(Q]\u0005\u0004\u0005GD&!B!se\u0006L\bcA,\u0003h&\u0019!\u0011\u001e-\u0003\t\tKH/\u001a\u000b\u0003\u0005[\u00042Aa<<\u001b\u0005IDC\u0002B;\u0005g\u00149\u0010C\u0004\u0003vv\u0002\rAa8\u0002\t\u0011\fG/\u0019\u0005\b\u0005sl\u0004\u0019\u0001B~\u0003I\u0019XM]5bY&T\u0018\r^5p]\u000e\u000b7\r[3\u0011\t\tu81A\u0007\u0003\u0005\u007fTAa!\u0001\u0002L\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0004\u0006\t}(\u0001G(cU\u0016\u001cGoU3sS\u0006d\u0017N_1uS>t7)Y2iK\u0006)qO]5uKR9Ana\u0003\u0004\u000e\r=\u0001b\u0002B{}\u0001\u0007!q\u001c\u0005\b\u0005st\u0004\u0019\u0001B~\u0011\u001d\u0019\tB\u0010a\u0001\u0007'\t1a\\;u!\u0011\u0011ip!\u0006\n\t\r]!q \u0002\t/JLG/\u00192mK\u0006!!/Z1e)\u0019\u0011yn!\b\u0004(!91qD A\u0002\r\u0005\u0012!B5oaV$\b\u0003\u0002B\u007f\u0007GIAa!\n\u0003\u0000\nA!+Z1eC\ndW\rC\u0004\u0004*}\u0002\rA!\u001e\u0002\tML'0Z\u0001\u0019\t\u00164\u0017-\u001e7u\u001b\u0016$\u0018\rZ1uC2{wmQ8oM&<WCAB\u0018!\u0011\u0019\td!\u000e\u000e\u0005\rM\"BA){\u0013\u0011\u00199da\r\u0003#5+G/\u00193bi\u0006dunZ\"p]\u001aLw-A\rEK\u001a\fW\u000f\u001c;NKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\u0004\u0013A\u00062vS2$W*\u001a;bI\u0006$\u0018\rT8h\u0003:$G)\u001b:\u0015\u0011\r}21LB/\u0007C\u0002\u0012bVB!\u0007\u000b\u001a)fa\f\n\u0007\r\r\u0003L\u0001\u0004UkBdWm\r\t\u0005\u0007\u000f\u001a\t&\u0004\u0002\u0004J)!11JB'\u0003\u00111\u0017\u000e\\3\u000b\u0007\r=c-A\u0002oS>LAaa\u0015\u0004J\t!\u0001+\u0019;i!\ry6qK\u0005\u0004\u00073\u0002&\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h\u0011\u0015\u0001'\t1\u0001c\u0011\u0019\u0019yF\u0011a\u0001i\u0006!A/[7f\u0011%\u0019\u0019G\u0011I\u0001\u0002\u0004\u0019y#A\tnKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\f\u0001EY;jY\u0012lU\r^1eCR\fGj\\4B]\u0012$\u0015N\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u000e\u0016\u0005\u0007_\u0019Yg\u000b\u0002\u0004nA!1qNB=\u001b\t\u0019\tH\u0003\u0003\u0004t\rU\u0014!C;oG\",7m[3e\u0015\r\u00199\bW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB>\u0007c\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003A\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\u0006\u0005\u0004V\r\u000551QBC\u0011\u0015\u0001G\t1\u0001c\u0011\u0019\u0019y\u0006\u0012a\u0001i\"I11\r#\u0011\u0002\u0003\u00071qF\u0001\u001bEVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$C-\u001a4bk2$HeM\u0001\u0012GJ,\u0017\r^3OK^\u001cf.\u00199tQ>$H#\u00027\u0004\u000e\u000eE\u0005bBBH\r\u0002\u00071QK\u0001\u0004Y><\u0007b\u0002B%\r\u0002\u0007!1J\u0001\u001bGJ,\u0017\r^3OK^\u001cf.\u00199tQ>$XK\\2lK\u000e\\W\r\u001a\u000b\u0006Y\u000e]5\u0011\u0014\u0005\b\u0007\u001f;\u0005\u0019AB+\u0011\u001d\u0011Ie\u0012a\u0001\u0005\u0017\na!\u00199qK:$G\u0003CBP\u0007K\u001bik!-\u0011\t\rE2\u0011U\u0005\u0005\u0007G\u001b\u0019DA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0007\u001fC\u0005\u0019ABT!\u0011\u0019\td!+\n\t\r-61\u0007\u0002\u000e%\u0016\u0004H.[2bi\u0016$Gj\\4\t\u000f\r=\u0006\n1\u0001\u0003v\u0005ya.^7cKJ|eMU3d_J$7\u000fC\u0004\u00044\"\u0003\rA!\u001e\u0002\u000b\u0015\u0004xn\u00195\u0015\u000b1\u001c9la2\t\u000f\re\u0016\n1\u0001\u0004<\u0006q1O\\1qg\"|Go\u0016:ji\u0016\u0014\b\u0003BB_\u0007\u0007l!aa0\u000b\u0007\r\u0005'0\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\u0011\u0019)ma0\u0003#I\u000bwo\u00158baNDw\u000e^,sSR,'\u000fC\u0004\u00040&\u0003\rA!\u001e\u0002%\r\u0014X-\u0019;f\u0019><G)\u001b:fGR|'/\u001f\u000b\u0006E\u000e57q\u001a\u0005\u0007\u0005{Q\u0005\u0019\u00012\t\u000f\rE'\n1\u0001\u0004T\u0006QAn\\4ESJt\u0015-\\3\u0011\t\u0005\r4Q[\u0005\u0005\u0007/\f)H\u0001\u0004TiJLgnZ\u0001\u0018GJ,\u0017\r^3NKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e$\u0002ca\f\u0004^\u000e\u000581^Bx\u0007g\u001c9pa?\t\u000f\r}7\n1\u0001\u0003v\u00059\u0012N\u001c;fe:\fG\u000eT8h'\u0016<W.\u001a8u\u0005f$Xm\u001d\u0005\b\u0007G\\\u0005\u0019ABs\u0003AawnZ*fO6,g\u000e^'jY2L7\u000fE\u0002X\u0007OL1a!;Y\u0005\u0011auN\\4\t\u000f\r58\n1\u0001\u0004f\u0006\t\"/\u001a;f]RLwN\\'bq\nKH/Z:\t\u000f\rE8\n1\u0001\u0004f\u0006y!/\u001a;f]RLwN\\'jY2L7\u000fC\u0005\u0004v.\u0003\n\u00111\u0001\u0003v\u0005Y\u0012N\u001c;fe:\fG.T1y\u0005\u0006$8\r[*ju\u0016LeNQ=uKND\u0011b!?L!\u0003\u0005\rA!\u001e\u00027%tG/\u001a:oC2l\u0015\r\u001f$fi\u000eD7+\u001b>f\u0013:\u0014\u0015\u0010^3t\u0011%\u0019ip\u0013I\u0001\u0002\u0004\u0019)/A\rj]R,'O\\1m\t\u0016dW\r^3EK2\f\u00170T5mY&\u001c\u0018!I2sK\u0006$X-T3uC\u0012\fG/\u0019'pO\u000e{gNZ5hI\u0011,g-Y;mi\u0012*TC\u0001C\u0002U\u0011\u0011)ha\u001b\u0002C\r\u0014X-\u0019;f\u001b\u0016$\u0018\rZ1uC2{wmQ8oM&<G\u0005Z3gCVdG\u000f\n\u001c\u0002C\r\u0014X-\u0019;f\u001b\u0016$\u0018\rZ1uC2{wmQ8oM&<G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u0011-!\u0006BBs\u0007W\u0002")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();

    public static void append(RawSnapshotWriter snapshotWriter, int numberOfRecords) {
        KafkaMetadataLogTest$.MODULE$.append(snapshotWriter, numberOfRecords);
    }

    public static LogAppendInfo append(ReplicatedLog log, int numberOfRecords, int epoch) {
        return KafkaMetadataLogTest$.MODULE$.append(log, numberOfRecords, epoch);
    }

    public static void createNewSnapshotUnckecked(KafkaMetadataLog log, OffsetAndEpoch snapshotId) {
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
    }

    public static void createNewSnapshot(KafkaMetadataLog log, OffsetAndEpoch snapshotId) {
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
    }

    public static MetadataLogConfig buildMetadataLog$default$3() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public static KafkaMetadataLog buildMetadataLog(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog(tempDir, time, metadataLogConfig);
    }

    public static MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public static Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(tempDir, time, metadataLogConfig);
    }

    public static MetadataLogConfig DefaultMetadataLogConfig() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put("process.roles", List.of("broker"));
        props.put("controller.quorum.voters", "1@localhost:9093");
        props.put("node.id", BoxesRunTime.boxToInteger((int)2));
        props.put("controller.listener.names", "SSL");
        props.put("metadata.log.segment.bytes", BoxesRunTime.boxToInteger((int)10240));
        props.put("metadata.log.segment.ms", BoxesRunTime.boxToInteger((int)10240));
        Assertions.assertThrows(ConfigException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = new MetadataLogConfig((AbstractConfig)kafkaConfig);
            KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
        });
        props.put("metadata.log.segment.bytes", BoxesRunTime.boxToInteger((int)0xA00000));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = new MetadataLogConfig((AbstractConfig)kafkaConfig);
        KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnexpectedAppendOffset() {
        void withRecords_records;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
        NoCompression withRecords_compression = Compression.NONE;
        Object var6_6 = null;
        simpleRecordArray = null;
        log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            NoCompression withRecords_compression = Compression.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            NoCompression withRecords_compression = Compression.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsFollower((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        });
    }

    @Test
    public void testEmptyAppendNotAllowed() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.appendAsFollower((Records)MemoryRecords.EMPTY, 1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.appendAsLeader((Records)MemoryRecords.EMPTY, 1));
    }

    @ParameterizedTest
    @ArgumentsSource(value=InvalidMemoryRecordsProvider.class)
    public void testInvalidMemoryRecords(MemoryRecords records, Optional<Class<Exception>> expectedException) {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        long previousEndOffset = log.endOffset().offset();
        Executable action = () -> log.appendAsFollower((Records)records, Integer.MAX_VALUE);
        if (expectedException.isPresent()) {
            Assertions.assertThrows(expectedException.get(), (Executable)action);
        } else {
            Assertions.assertThrows(CorruptRecordException.class, (Executable)action);
        }
        Assertions.assertEquals((long)previousEndOffset, (long)log.endOffset().offset());
    }

    @Property(tries=100, afterFailure=AfterFailureMode.SAMPLE_ONLY)
    public void testRandomRecords(@ForAll(supplier=ArbitraryMemoryRecords.class) MemoryRecords records) {
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(tempDir, this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
            long previousEndOffset = log.endOffset().offset();
            Assertions.assertThrows(CorruptRecordException.class, () -> log.appendAsFollower((Records)records, Integer.MAX_VALUE));
            Assertions.assertEquals((long)previousEndOffset, (long)log.endOffset().offset());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidLeaderEpoch() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compression;
        void withRecords_records2;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        long previousEndOffset = log.endOffset().offset();
        int epoch = log.lastFetchedEpoch() + 1;
        int numberOfRecords = 10;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable)number -> KafkaMetadataLogTest.$anonfun$testInvalidLeaderEpoch$1(BoxesRunTime.unboxToInt((Object)number))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression2 = Compression.NONE;
        Object var10_6 = null;
        simpleRecordArray = null;
        MemoryRecords batchWithValidEpoch = MemoryRecords.withRecords((byte)2, (long)previousEndOffset, (Compression)withRecords_compression2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)epoch, (boolean)false, (SimpleRecord[])withRecords_records2);
        SimpleRecord[] simpleRecordArray2 = (SimpleRecord[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable)number -> KafkaMetadataLogTest.$anonfun$testInvalidLeaderEpoch$2(BoxesRunTime.unboxToInt((Object)number))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int n = epoch + 1;
        NoCompression noCompression = Compression.NONE;
        long withRecords_initialOffset = previousEndOffset + (long)numberOfRecords;
        noCompression = null;
        simpleRecordArray2 = null;
        MemoryRecords batchWithInvalidEpoch = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        ByteBuffer buffer = ByteBuffer.allocate(batchWithValidEpoch.sizeInBytes() + batchWithInvalidEpoch.sizeInBytes());
        buffer.put(batchWithValidEpoch.buffer());
        buffer.put(batchWithInvalidEpoch.buffer());
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        log.appendAsFollower((Records)records, epoch);
        Assertions.assertEquals((long)(previousEndOffset + (long)numberOfRecords), (long)log.endOffset().offset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
    }

    @Test
    public void testCreateSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotInMiddleOfBatch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), epoch)));
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    @Test
    public void testHighWatermarkOffsetMetadata() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        LogOffsetMetadata highWatermarkMetadata = log.highWatermark();
        Assertions.assertEquals((long)numberOfRecords, (long)highWatermarkMetadata.offset());
        Assertions.assertTrue((boolean)highWatermarkMetadata.metadata().isPresent());
        SegmentPosition segmentPosition = (SegmentPosition)highWatermarkMetadata.metadata().get();
        Assertions.assertEquals((long)0L, (long)segmentPosition.baseOffset());
        Assertions.assertTrue((segmentPosition.relativePosition() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfRecords).foreach((Function1 & Serializable)x$2 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, epoch));
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        log.log().maybeIncrementLogStartOffset(snapshotId.offset() - 1L, LogStartOffsetIncrementReason.SegmentDeletion);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset() - 2L, snapshotId.epoch())));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotOlderEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    @Test
    public void testCreateExistingSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 10;
        int epoch = 0;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset());
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset());
    }

    @Test
    public void testTruncateFullyToLatestSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, sameEpochSnapshotId);
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.endOffset().offset());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.highWatermark().offset());
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, greaterEpochSnapshotId);
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.endOffset().offset());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.highWatermark().offset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId3);
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, greaterSnapshotId);
        Assertions.assertNotEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        Assertions.assertTrue((boolean)var3_3.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        var3_3.close();
        this.mockTime().sleep(var4_4.internalDeleteDelayMillis());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$4 -> x$4.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$3((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testStartupWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.log().truncateFullyAndStartAt(100L, Optional.empty());
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(50L, 1));
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(100L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.log().truncateFullyAndStartAt(200L, Optional.empty());
        log.close();
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(500L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((long)500L, (long)log.log().logStartOffset());
    }

    @Test
    public void testSnapshotDeletionWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.log().truncateFullyAndStartAt(100L, Optional.empty());
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(100L, 1);
        this.writeEmptySnapshot(metadataDir, snapshotId);
        Path deletedPath = Snapshots.markForDelete((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId);
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
    }

    private File metadataLogDir(File logDir) {
        return new File(logDir.getAbsolutePath(), LocalLog.logDirName((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition()));
    }

    private void writeEmptySnapshot(File metadataDir, OffsetAndEpoch snapshotId) {
        Using$.MODULE$.resource((Object)FileRawSnapshotWriter.create((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId), (Function1 & Serializable)x$5 -> {
            x$5.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testDoesntTruncateFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, olderEpochSnapshotId);
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, olderOffsetSnapshotId);
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void var2_2;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, snapshotId);
        var3_3.close();
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)var3_3.startOffset());
        Assertions.assertEquals((int)epoch, (int)var3_3.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)var3_3.endOffset().offset());
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$7 -> x$7.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId3);
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, greaterSnapshotId);
        var3_3.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(var4_4.internalDeleteDelayMillis());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$9 -> x$9.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$3((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch(), (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.endOffset().offset());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.highWatermark().offset());
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.kafka$raft$KafkaMetadataLogTest$$createMetadataLogConfig(KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().logSegmentBytes(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().logSegmentMillis(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().retentionMaxBytes(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().retentionMillis(), maxBatchSizeInBytes, 0x800000, 60000L);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset());
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numRecords = 10;
        int epoch = 5;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset());
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset());
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset());
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), (Compression)Compression.NONE, 0L, this.mockTime().milliseconds(), leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = List.of(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset(), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        log.log().maybeIncrementLogStartOffset((long)offset, LogStartOffsetIncrementReason.SegmentDeletion);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset(), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 5;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.kafka$raft$KafkaMetadataLogTest$$createMetadataLogConfig(512, 10000L, 256L, 60000L, 512, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().internalMaxFetchSizeInBytes(), 60000L);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$10 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId1);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId2);
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset() ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    @Test
    public void testDeleteSnapshots() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.kafka$raft$KafkaMetadataLogTest$$createMetadataLogConfig(1024, 10000L, 1024L, 60000L, 100, 0x800000, 60000L);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable)x$11 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Object var3_3 = null;
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    @Test
    public void testSoftRetentionLimit() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.kafka$raft$KafkaMetadataLogTest$$createMetadataLogConfig(10240, 10000L, 10240L, 60000L, 100, 0x800000, 60000L);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$12 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        Using$.MODULE$.resource(log.createNewSnapshotUnchecked(snapshotId1).get(), (Function1 & Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        Using$.MODULE$.resource(log.createNewSnapshotUnchecked(snapshotId2).get(), (Function1 & Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    @Test
    public void testSegmentMsConfigIsSetInMetadataLog() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((long)KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().logSegmentMillis(), (long)log.log().config().segmentMs);
    }

    @Test
    public void testSegmentsLessThanLatestSnapshot() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.kafka$raft$KafkaMetadataLogTest$$createMetadataLogConfig(10240, 10000L, 10240L, 60000L, 200, 0x800000, 60000L);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$13 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 10, 1));
        log.updateHighWatermark(new LogOffsetMetadata(log.endOffset().offset()));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(((LogSegment)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(log.log().logSegments()).asScala().drop(1)).head()).baseOffset(), 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId1);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(((LogSegment)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(log.log().logSegments()).asScala().drop(2)).head()).baseOffset(), 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId2);
        long defaultLogRetentionMs = 1209600000L;
        this.mockTime().sleep(defaultLogRetentionMs);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount());
        Assertions.assertTrue((log.startOffset() > 0L ? 1 : 0) != 0, (String)(log.startOffset() + " must be greater than 0"));
        long latestSnapshotOffset = ((OffsetAndEpoch)log.latestSnapshotId().get()).offset();
        Assertions.assertTrue((latestSnapshotOffset >= log.startOffset() ? 1 : 0) != 0, (String)("latest snapshot offset (" + latestSnapshotOffset + ") must be >= log start offset (" + log.startOffset() + ")"));
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testInvalidLeaderEpoch$1(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testInvalidLeaderEpoch$2(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$3(KafkaMetadataLog log$12, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId().offset() < log$12.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$3(KafkaMetadataLog log$13, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId().offset() < log$13.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset());
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$18, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$18.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$18, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset(), (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$18.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$18, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }
    }
}

