/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001B\u0007\u000f\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAQa\u0007\u0001\u0005BqAQ!\f\u0001\u0005B9Bqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004L\u0001\u0001\u0006I!\u0012\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003E\u0011\u0019i\u0005\u0001)A\u0005\u000b\")a\n\u0001C\u0001\u001f\")A\u000b\u0001C\u0001\u001f\")a\u000b\u0001C\u0005/\"9\u0001\u000fAI\u0001\n\u0013\t\b\"\u0002?\u0001\t\u0013i(!M!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgRtu\u000e^!vi\"|'/\u001b>fIR+7\u000f\u001e\u0006\u0003\u001fA\taa]3sm\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+Yi\u0011AD\u0005\u0003/9\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"!\u0006\u0001\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHCA\u000f$!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0011)f.\u001b;\t\u000b\u0011\u0012\u0001\u0019A\u0013\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!Q\u000f^5m\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u0007>tg-[4t)\tyS\u0007E\u00021g\u0015j\u0011!\r\u0006\u0003e}\t!bY8mY\u0016\u001cG/[8o\u0013\t!\u0014GA\u0002TKFDQAN\u0002A\u0002]\n\u0001\u0002^3ti&sgm\u001c\t\u0003q\u0005k\u0011!\u000f\u0006\u0003um\n1!\u00199j\u0015\taT(A\u0004kkBLG/\u001a:\u000b\u0005yz\u0014!\u00026v]&$(\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cs\tAA+Z:u\u0013:4w.A\u0003vg\u0016\u0014\u0018'F\u0001F!\t1\u0015*D\u0001H\u0015\tA\u0015&\u0001\u0003mC:<\u0017B\u0001&H\u0005\u0019\u0019FO]5oO\u00061Qo]3sc\u0001\nQ!^:feJ\na!^:feJ\u0002\u0013!\b;fgR\fE\u000e^3s\u001d>$\b.\u001b8h\u001d>$\u0018)\u001e;i_JL'0\u001a3\u0015\u0003uA#\u0001C)\u0011\u0005a\u0012\u0016BA*:\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f^!mi\u0016\u00148k\\7fi\"Lgn\u001a(pi\u0006+H\u000f[8sSj,G\r\u000b\u0002\n#\u0006!3/\u001a8e\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fF\u0002YG\"\u0004\"!W1\u000e\u0003iS!a\u0017/\u0002\u0011I,\u0017/^3tiNT!!\u00180\u0002\r\r|W.\\8o\u0015\t\trL\u0003\u0002a\u007f\u00051\u0011\r]1dQ\u0016L!A\u0019.\u0003C\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3\t\u000b\u0011T\u0001\u0019A3\u0002\u000fI,\u0017/^3tiB\u0011\u0011LZ\u0005\u0003Oj\u0013\u0001%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3ti\"9\u0011N\u0003I\u0001\u0002\u0004Q\u0017\u0001D:pG.,GoU3sm\u0016\u0014\bCA6o\u001b\u0005a'BA7\u0011\u0003\u001dqW\r^<pe.L!a\u001c7\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002]M,g\u000eZ!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0002e*\u0012!n]\u0016\u0002iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\nk:\u001c\u0007.Z2lK\u0012T!!_\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002|m\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002C\rDWmY6BY2,%O]8sg\u0006cG/\u001a:j]\u001e\u001c%/\u001a3f]RL\u0017\r\\:\u0015\ruq\u00181GA\"\u0011\u0019yH\u00021\u0001\u0002\u0002\u0005q!/Z:vYR\u001cHk\\\"iK\u000e\\\u0007#\u0002\u0014\u0002\u0004\u0005\u001d\u0011bAA\u0003O\t!A*[:u!\u0011\tI!!\f\u000f\t\u0005-\u0011q\u0005\b\u0005\u0003\u001b\t\u0019C\u0004\u0003\u0002\u0010\u0005\u0005b\u0002BA\t\u0003?qA!a\u0005\u0002\u001e9!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001aI\ta\u0001\u0010:p_Rt\u0014\"\u0001!\n\u0005\u0001|\u0014BA\t`\u0013\tif,C\u0002\u0002&q\u000bq!\\3tg\u0006<W-\u0003\u0003\u0002*\u0005-\u0012!J!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm\u001d9p]N,G)\u0019;b\u0015\r\t)\u0003X\u0005\u0005\u0003_\t\tDA\u0010BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:vYRTA!!\u000b\u0002,!9\u0011Q\u0007\u0007A\u0002\u0005]\u0012!D3ya\u0016\u001cG/\u001a3FeJ|'\u000f\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti\u0004X\u0001\taJ|Go\\2pY&!\u0011\u0011IA\u001e\u0005\u0019)%O]8sg\"9\u0011Q\t\u0007A\u0002\u0005\u001d\u0013AC2p]R,\u0007\u0010^'tOB!\u0011\u0011JA)\u001d\u0011\tY%!\u0014\u0011\u0007\u0005Uq$C\u0002\u0002P}\ta\u0001\u0015:fI\u00164\u0017b\u0001&\u0002T)\u0019\u0011qJ\u0010")
public class AlterUserScramCredentialsRequestNotAuthorizedTest
extends BaseRequestTest {
    private final String user1;
    private final String user2;

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("controlled.shutdown.enable", "false");
        properties.put("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        properties.put("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName());
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs(testInfo);
        ((Properties)controllerConfigs.head()).put("authorizer.class.name", AlterCredentialsTest.TestStandardAuthorizer.class.getName());
        ((Properties)controllerConfigs.head()).put("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName());
        return controllerConfigs;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    @Test
    public void testAlterNothingNotAuthorized() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testAlterSomethingNotAuthorized() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.CLUSTER_AUTHORIZATION_FAILED, "when not authorized");
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestNotAuthorizedTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)("Expected all '" + expectedError.name() + "' errors when altering credentials " + contextMsg));
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public AlterUserScramCredentialsRequestNotAuthorizedTest() {
        this.user1 = "user1";
        this.user2 = "user2";
    }
}

