/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.GroupCoordinatorBaseRequestTest;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.initial.rebalance.delay.ms", value="1000")})
@ScalaSignature(bytes="\u0006\u0005i3AAB\u0004\u0001\u0019!A\u0011\u0003\u0001B\u0001B\u0003%!\u0003C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003$\u0001\u0011\u0005A\u0005C\u00033\u0001\u0011\u0005A\u0005C\u00035\u0001\u0011%QGA\u000bMSN$xI]8vaN\u0014V-];fgR$Vm\u001d;\u000b\u0005!I\u0011AB:feZ,'OC\u0001\u000b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0007\u0011\u00059yQ\"A\u0004\n\u0005A9!aH$s_V\u00048i\\8sI&t\u0017\r^8s\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u000691\r\\;ti\u0016\u0014\bCA\n\u001e\u001b\u0005!\"BA\u000b\u0017\u0003\u0011!Xm\u001d;\u000b\u0005]A\u0012AB2p[6|gN\u0003\u0002\u000b3)\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0013\tqBCA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011\u0011E\t\t\u0003\u001d\u0001AQ!\u0005\u0002A\u0002I\t!\u0006^3ti2K7\u000f^$s_V\u00048oV5uQ:+woQ8ogVlWM]$s_V\u0004\bK]8u_\u000e|G\u000eF\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0011)f.\u001b;)\u0005\ra\u0003CA\u00171\u001b\u0005q#BA\u0018\u0015\u0003\r\t\u0007/[\u0005\u0003c9\u00121b\u00117vgR,'\u000fV3ti\u0006QC/Z:u\u0019&\u001cHo\u0012:pkB\u001cx+\u001b;i\u001f2$7i\u001c8tk6,'o\u0012:pkB\u0004&o\u001c;pG>d\u0007F\u0001\u0003-\u00039!Xm\u001d;MSN$xI]8vaN$\"!\n\u001c\t\u000b]*\u0001\u0019\u0001\u001d\u0002\u001dU\u001cXMT3x!J|Go\\2pYB\u0011a%O\u0005\u0003u\u001d\u0012qAQ8pY\u0016\fg\u000e\u000b\u0004\u0001y}\u0002ei\u0012\t\u0003[uJ!A\u0010\u0018\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:\u0002\u000bQL\b/Z:-\u0003\u0005#\u0013AQ\u0005\u0003\u0007\u0012\u000bQa\u0013*B\rRS!!\u0012\u0018\u0002\tQK\b/Z\u0001\u0011g\u0016\u0014h/\u001a:Qe>\u0004XM\u001d;jKNd3\u0001\u0013*VW\u0015IE*T(Q!\ti#*\u0003\u0002L]\t)2\t\\;ti\u0016\u00148i\u001c8gS\u001e\u0004&o\u001c9feRL\u0018aA6fs\u0006\na*\u0001\u000fpM\u001a\u001cX\r^:/i>\u0004\u0018n\u0019\u0018ok6t\u0003/\u0019:uSRLwN\\:\u0002\u000bY\fG.^3\"\u0003E\u000b\u0011!M\u0016\u0006\u00132\u001bv\nU\u0011\u0002)\u0006\u0001sN\u001a4tKR\u001ch\u0006^8qS\u000et#/\u001a9mS\u000e\fG/[8o]\u0019\f7\r^8sW\u0015IEJV(YC\u00059\u0016\u0001I4s_V\u0004h&\u001b8ji&\fGN\f:fE\u0006d\u0017M\\2f]\u0011,G.Y=/[N\f\u0013!W\u0001\u0005cA\u0002\u0004\u0007")
public class ListGroupsRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest
    public void testListGroupsWithNewConsumerGroupProtocol() {
        this.testListGroups(true);
    }

    @ClusterTest
    public void testListGroupsWithOldConsumerGroupProtocol() {
        this.testListGroups(false);
    }

    private void testListGroups(boolean useNewProtocol) {
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_GROUPS.oldestVersion()), (int)ApiKeys.LIST_GROUPS.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            void var9_9;
            void var4_4;
            void var12_12;
            Tuple2<String, Object> tuple2 = this.joinDynamicConsumerGroupWithOldProtocol("grp-1", this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup1 = (String)tuple2._1();
            ListGroupsResponseData.ListedGroup response1 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-1").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.STABLE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            byte[] x$3 = this.joinDynamicConsumerGroupWithOldProtocol$default$2();
            byte[] x$4 = this.joinDynamicConsumerGroupWithOldProtocol$default$3();
            Tuple2<String, Object> tuple22 = this.joinDynamicConsumerGroupWithOldProtocol("grp-2", x$3, x$4, false);
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup2 = (String)tuple22._1();
            ListGroupsResponseData.ListedGroup response2 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-2").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.COMPLETING_REBALANCE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            Tuple2<String, Object> tuple23 = this.joinDynamicConsumerGroupWithOldProtocol("grp-3", this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
            if (tuple23 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup3 = (String)tuple23._1();
            this.leaveGroup("grp-3", (String)var12_12, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            ListGroupsResponseData.ListedGroup response3 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-3").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.EMPTY.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            String memberId1InGroup4 = null;
            ListGroupsResponseData.ListedGroup response4 = null;
            String memberId1InGroup5 = null;
            String memberId2InGroup5 = null;
            ListGroupsResponseData.ListedGroup response5 = null;
            ListGroupsResponseData.ListedGroup response6 = null;
            if (useNewProtocol) {
                memberId1InGroup4 = (String)this.joinConsumerGroup("grp-4", true)._1();
                response4 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-4").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.STABLE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
                memberId1InGroup5 = (String)this.joinConsumerGroup("grp-5", true)._1();
                memberId2InGroup5 = (String)this.joinConsumerGroup("grp-5", true)._1();
                response5 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-5").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.RECONCILING.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
                String memberId1InGroup6 = (String)this.joinConsumerGroup("grp-6", true)._1();
                this.leaveGroup("grp-6", memberId1InGroup6, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                response6 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-6").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.EMPTY.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
            }
            Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)new .colon.colon(response4, (List)new .colon.colon(response5, (List)new .colon.colon(response6, (List)Nil$.MODULE$)))))).toSet() : new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$))).toSet()), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
            if (version >= 4) {
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response1, (List)Nil$.MODULE$)) : new .colon.colon((Object)response1, (List)Nil$.MODULE$)), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.STABLE.toString(), (List)Nil$.MODULE$), (List<String>)package$.MODULE$.List().empty(), (short)version));
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response2, (List)new .colon.colon((Object)response5, (List)Nil$.MODULE$)).toSet() : new .colon.colon((Object)response2, (List)Nil$.MODULE$).toSet()), (Object)this.listGroups((List<String>)new .colon.colon((Object)ClassicGroupState.COMPLETING_REBALANCE.toString(), (List)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.RECONCILING.toString(), (List)Nil$.MODULE$)), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response1, (List)new .colon.colon((Object)response3, (List)new .colon.colon((Object)response6, (List)Nil$.MODULE$)))).toSet() : new .colon.colon((Object)response1, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$)).toSet()), (Object)this.listGroups((List<String>)new .colon.colon((Object)ClassicGroupState.STABLE.toString(), (List)new .colon.colon((Object)ClassicGroupState.EMPTY.toString(), (List)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (List)Nil$.MODULE$))), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
                Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING.toString(), (List)Nil$.MODULE$), (List<String>)package$.MODULE$.List().empty(), (short)version));
            }
            if (version >= 5) {
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)Nil$.MODULE$) : package$.MODULE$.List().empty()), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.STABLE.toString(), (List)Nil$.MODULE$), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), (short)version));
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response5, (List)new .colon.colon(response6, (List)Nil$.MODULE$))).toSet() : Predef$.MODULE$.Set().empty()), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), (short)version).toSet());
                Assertions.assertEquals((Object)new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$))).toSet(), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), (short)version).toSet());
            }
            this.leaveGroup("grp-1", (String)var4_4, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.leaveGroup("grp-2", (String)var9_9, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            if (useNewProtocol) {
                this.leaveGroup("grp-4", memberId1InGroup4, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                this.leaveGroup("grp-5", memberId1InGroup5, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                this.leaveGroup("grp-5", memberId2InGroup5, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            }
            this.deleteGroups((List<String>)(useNewProtocol ? new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)new .colon.colon((Object)"grp-3", (List)new .colon.colon((Object)"grp-4", (List)new .colon.colon((Object)"grp-5", (List)new .colon.colon((Object)"grp-6", (List)Nil$.MODULE$)))))) : new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)new .colon.colon((Object)"grp-3", (List)Nil$.MODULE$)))), (List<Errors>)(useNewProtocol ? (List)package$.MODULE$.List().fill(6, (Function0 & Serializable)() -> Errors.NONE) : (List)package$.MODULE$.List().fill(3, (Function0 & Serializable)() -> Errors.NONE)), ApiKeys.DELETE_GROUPS.latestVersion(this.isUnstableApiEnabled()));
            Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)package$.MODULE$.List().empty(), (short)version));
        });
    }

    public ListGroupsRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

