/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.server.BaseRequestTest;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.ProduceRequestTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.compress.Lz4Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.compress.ZstdCompression;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAqA\b\u0001C\u0002\u0013\u0005q\u0004\u0003\u00047\u0001\u0001\u0006I\u0001\t\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006\u0015\u0002!Ia\u0013\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0007\u0003\u001b\u0001A\u0011\u0001\u001d\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!1\u0011Q\u0004\u0001\u0005\u0002aBa!!\t\u0001\t\u0003A\u0004bBA\u0013\u0001\u0011%\u0011qE\u0004\b\u0003\u000f\n\u0002\u0012AA%\r\u0019\u0001\u0012\u0003#\u0001\u0002L!11$\u0004C\u0001\u0003'Bq!a\u0003\u000e\t\u0003\t)F\u0001\nQe>$WoY3SKF,Xm\u001d;UKN$(B\u0001\n\u0014\u0003\u0019\u0019XM\u001d<fe*\tA#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001a\u001b\u0005\t\u0012B\u0001\u000e\u0012\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001e!\tA\u0002!A\u0007nKR\u0014\u0018nY:LKf\u001cV\r^\u000b\u0002AA\u0019\u0011\u0005\u000b\u0016\u000e\u0003\tR!a\t\u0013\u0002\u000f5,H/\u00192mK*\u0011QEJ\u0001\u000bG>dG.Z2uS>t'\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%\u0012#aA*fiB\u00111\u0006N\u0007\u0002Y)\u0011QFL\u0001\u0005G>\u0014XM\u0003\u00020a\u00059Q.\u001a;sS\u000e\u001c(BA\u00193\u0003\u0019I\u0018-\\7fe*\t1'A\u0002d_6L!!\u000e\u0017\u0003\u00155+GO]5d\u001d\u0006lW-\u0001\bnKR\u0014\u0018nY:LKf\u001cV\r\u001e\u0011\u00021Q,7\u000f^*j[BdW\r\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000fF\u0001:!\tQ4(D\u0001'\u0013\tadE\u0001\u0003V]&$\bF\u0001\u0003?!\ty\u0004*D\u0001A\u0015\t\t%)A\u0002ba&T!a\u0011#\u0002\u000f),\b/\u001b;fe*\u0011QIR\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%\u0003%\u0001\u0002+fgR\fAcZ3u!\u0006\u0014H/\u001b;j_:$v\u000eT3bI\u0016\u0014Hc\u0001'[MB!Q\nV,X\u001d\tq%\u000b\u0005\u0002PM5\t\u0001K\u0003\u0002R+\u00051AH]8pizJ!a\u0015\u0014\u0002\rA\u0013X\rZ3g\u0013\t)fKA\u0002NCBT!a\u0015\u0014\u0011\u0005iB\u0016BA-'\u0005\rIe\u000e\u001e\u0005\u00067\u0016\u0001\r\u0001X\u0001\u0006C\u0012l\u0017N\u001c\t\u0003;\u0012l\u0011A\u0018\u0006\u00037~S!\u0001Y1\u0002\u000f\rd\u0017.\u001a8ug*\u0011AC\u0019\u0006\u0003G\u001a\u000ba!\u00199bG\",\u0017BA3_\u0005\u0015\tE-\\5o\u0011\u00159W\u00011\u0001i\u0003\u0015!x\u000e]5d!\ti\u0015.\u0003\u0002k-\n11\u000b\u001e:j]\u001e\fq\u0004^3tiB\u0013x\u000eZ;dK^KG\u000f[%om\u0006d\u0017\u000e\u001a+j[\u0016\u001cH/Y7q)\rITn\u001c\u0005\u0006]\u001a\u0001\r\u0001[\u0001\u0017[\u0016\u001c8/Y4f)&lWm\u0015;b[B\u001cuN\u001c4jO\")\u0001O\u0002a\u0001c\u0006y!/Z2pe\u0012$\u0016.\\3ti\u0006l\u0007\u000f\u0005\u0002;e&\u00111O\n\u0002\u0005\u0019>tw\r\u000b\u0002\u0007kB\u0011a/_\u0007\u0002o*\u0011\u0001PQ\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005i<(!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"2a\u0001`A\u0003\u0003\u000f\u00012!`A\u0001\u001b\u0005q(BA@x\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018bAA\u0002}\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012\u0011\u0011B\u0011\u0003\u0003\u0017\tq\u0003^5nKN$\u0018-\u001c9D_:4\u0017n\u001a)s_ZLG-\u001a:\u0002/Q,7\u000f\u001e)s_\u0012,8-\u001a+p\u001d>t'+\u001a9mS\u000e\f\u0007FA\u0004?\u0003\u0015\u001a'/Z1uKR{\u0007/[2B]\u00124\u0015N\u001c3QCJ$\u0018\u000e^5p]^KG\u000f\u001b'fC\u0012,'\u000f\u0006\u0003\u0002\u0016\u0005m\u0001#\u0002\u001e\u0002\u0018];\u0016bAA\rM\t1A+\u001e9mKJBQa\u001a\u0005A\u0002!\fA\u0004^3ti\u000e{'O];qi2SH\u0007\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000f\u000b\u0002\n}\u00051B/Z:u5N#F\t\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000f\u000b\u0002\u000b}\u0005\u00112/\u001a8e!J|G-^2f%\u0016\fX/Z:u)\u0019\tI#!\u000f\u0002>A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012\u0001\u0003:fcV,7\u000f^:\u000b\u0007\u0005M\u0012-\u0001\u0004d_6lwN\\\u0005\u0005\u0003o\tiCA\bQe>$WoY3SKN\u0004xN\\:f\u0011\u0019\tYd\u0003a\u0001/\u0006AA.Z1eKJLE\rC\u0004\u0002@-\u0001\r!!\u0011\u0002\u000fI,\u0017/^3tiB!\u00111FA\"\u0013\u0011\t)%!\f\u0003\u001dA\u0013x\u000eZ;dKJ+\u0017/^3ti\u0006\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u!\tARbE\u0002\u000e\u0003\u001b\u00022AOA(\u0013\r\t\tF\n\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005%SCAA,!\u0019\tI&a\u001a\u0002l5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0004tiJ,\u0017-\u001c\u0006\u0005\u0003C\n\u0019'\u0001\u0003vi&d'BAA3\u0003\u0011Q\u0017M^1\n\t\u0005%\u00141\f\u0002\u0007'R\u0014X-Y7\u0011\u0007u\fi'C\u0002\u0002py\u0014\u0011\"\u0011:hk6,g\u000e^:")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public static Stream<Arguments> timestampConfigProvider() {
        return ProduceRequestTest$.MODULE$.timestampConfigProvider();
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSimpleProduceRequest() {
        void withRecords_records;
        void withRecords_timestampType;
        void var3_3;
        void var2_2;
        void withRecords_records2;
        void withRecords_timestampType2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var4_5 = null;
        simpleRecordArray = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records2), 0L, (int)var2_2, (int)var3_3);
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())};
        GzipCompression withRecords_compression2 = new GzipCompression.Builder().build();
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var6_10 = null;
        simpleRecordArray2 = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1L, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<Object, Object> getPartitionToLeader(Admin admin, String topic) {
        TopicDescription topicDescription;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((topicDescription = (TopicDescription)((java.util.Map)admin.describeTopics(Arrays.asList(topic)).allTopicNames().get(10L, TimeUnit.MINUTES)).get(topic)) != null)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProduceRequestTest.$anonfun$getPartitionToLeader$2(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p.partition())), (Object)BoxesRunTime.boxToInteger((int)p.leader().id())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @ParameterizedTest
    @MethodSource(value={"timestampConfigProvider"})
    public void testProduceWithInvalidTimestamp(String messageTimeStampConfig, long recordTimestamp) {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(messageTimeStampConfig, "1000");
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, topic, x$3, x$4, 1, 1, (Map<Object, Seq<Object>>)x$8, topicConfig);
        int leader = BoxesRunTime.unboxToInt((Object)this.getPartitionToLeader(admin, topic).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        TopicDescription topicDescription = TestUtils$.MODULE$.describeTopic(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), topic);
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, recordTimestamp, (Compression)new GzipCompression.Builder().build());
        TopicIdPartition topicPartition = new TopicIdPartition(topicDescription.topicId(), partition, "topic");
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setTopicId(topicPartition.topicId()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicIdPartition tp = new TopicIdPartition(topicProduceResponse.topicId(), partitionProduceResponse.index(), (String)this.getTopicNames().get((Object)topicProduceResponse.topicId()).getOrElse((Function0 & Serializable)() -> ""));
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((int)3, (int)partitionProduceResponse.recordErrors().size());
        Buffer recordErrors = CollectionConverters$.MODULE$.ListHasAsScala(partitionProduceResponse.recordErrors()).asScala();
        recordErrors.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((int)i, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.apply(i)).batchIndex()));
        recordErrors.foreach((Function1 & Serializable)recordError -> {
            ProduceRequestTest.$anonfun$testProduceWithInvalidTimestamp$3(recordError);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionProduceResponse.errorMessage());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceToNonReplica() {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        TestUtils$.MODULE$.createTopicWithAdmin(admin, topic, this.brokers(), this.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        int leader = BoxesRunTime.unboxToInt((Object)this.getPartitionToLeader(admin, topic).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.brokers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$2)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaBroker)nonReplicaOpt.get()).config().brokerId();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var12_8 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setTopicId((Uuid)this.getTopicIds().get((Object)"topic").get()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        return (Tuple2)this.createTopic(topic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()).collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    int leader = x1._2$mcI$sp();
                    if (leader != -1) {
                        return (B1)new Tuple2.mcII.sp(partition, leader);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                return x1 != null && x1._2$mcI$sp() != -1;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)("No leader elected for topic " + topic));
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptLz4ProduceRequest() {
        void var2_2;
        void var3_3;
        void withRecords_records;
        void withRecords_timestampType;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        Uuid topicId = (Uuid)this.getTopicIds().get((Object)"topic").get();
        int timestamp = 1000000;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(Int$.MODULE$.int2long(timestamp), "key".getBytes(), "value".getBytes())};
        Lz4Compression withRecords_compression = new Lz4Compression.Builder().build();
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_7 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        ProduceResponse produceResponse = this.sendProduceRequest((int)var3_3, (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setTopicId(topicId).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex((int)var2_2).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)topicId, (Object)topicProduceResponse.topicId());
        Assertions.assertEquals((int)var2_2, (int)partitionProduceResponse.index());
        Assertions.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$4))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount("InvalidMessageCrcRecordsPerSec") > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZSTDProduceRequest() {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("compression.type", BrokerCompressionType.ZSTD.name);
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, x$4, topicConfig, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        ZstdCompression withRecords_compression = new ZstdCompression.Builder().build();
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var16_10 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData partitionRecords = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        ProduceResponse produceResponse1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, partitionRecords).build());
        ProduceResponseData.TopicProduceResponse topicProduceResponse1 = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse1.data().responses()).asScala().head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse1 = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse1.partitionResponses()).asScala().head();
        TopicPartition tp1 = new TopicPartition(topicProduceResponse1.name(), partitionProduceResponse1.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse1.errorCode()));
        Assertions.assertEquals((long)0L, (long)partitionProduceResponse1.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse1.logAppendTimeMs());
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        return (ProduceResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ProduceResponse.class));
    }

    private final void sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        Uuid topicId = (Uuid)this.getTopicIds().get((Object)"topic").get();
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setTopicId(topicId).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition$1).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build();
        Assertions.assertEquals((short)ApiKeys.PRODUCE.latestVersion(), (short)produceRequest.version());
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)topicId, (Object)topicProduceResponse.topicId());
        Assertions.assertEquals((int)partition$1, (int)partitionProduceResponse.index());
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)expectedOffset, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionToLeader$1(Admin admin$1, String topic$1, ObjectRef topicDescription$1) {
        java.util.Map topicMap = (java.util.Map)admin$1.describeTopics(Arrays.asList(topic$1)).allTopicNames().get(10L, TimeUnit.MINUTES);
        topicDescription$1.elem = (TopicDescription)topicMap.get(topic$1);
        return (TopicDescription)topicDescription$1.elem != null;
    }

    public static final /* synthetic */ String $anonfun$getPartitionToLeader$2(String topic$1) {
        return "Timed out waiting to describe topic " + topic$1;
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, Compression codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (Compression)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$testProduceWithInvalidTimestamp$3(ProduceResponseData.BatchIndexAndErrorMessage recordError) {
        Assertions.assertNotNull((Object)recordError.batchIndexErrorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$2, KafkaBroker x$2) {
        return x$2.config().brokerId() != leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$4) {
        return x$4.getMBeanName().endsWith("InvalidMessageCrcRecordsPerSec");
    }
}

