/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.quota.QuotaType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00045\u0001\u0001\u0006Ia\u000b\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0011\u0019!\u0005\u0001)A\u0005o!IQ\t\u0001a\u0001\u0002\u0004%\tA\u0012\u0005\n-\u0002\u0001\r\u00111A\u0005\u0002]C\u0011\"\u0018\u0001A\u0002\u0003\u0005\u000b\u0015B$\t\u000fy\u0003!\u0019!C\u0001?\"1\u0001\u000e\u0001Q\u0001\n\u0001D\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u00016\t\u0013I\u0004\u0001\u0019!a\u0001\n\u0003\u0019\b\"C;\u0001\u0001\u0004\u0005\t\u0015)\u0003l\u0011\u00151\b\u0001\"\u0011x\u0011\u0019\t9\u0001\u0001C\u0001o\"1\u0011\u0011\u0003\u0001\u0005\u0002]Dq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002$\u0001!\t!!\n\t\r\u0005e\u0002\u0001\"\u0001x\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002Z\u0001!I!a\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003+\u0003A\u0011BAL\u0005U\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018m\u001d+fgRT!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003qI!!\n\u000f\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u00111\u0005A\u0001\t[N<\u0017\u0007\r\u0019L\u0005V\t1\u0006E\u0002-_Ej\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003YIJ!aM\u0017\u0003\t\tKH/Z\u0001\n[N<\u0017\u0007\r\u0019L\u0005\u0002\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016,\u0012a\u000e\t\u0003q\tk\u0011!\u000f\u0006\u0003um\nqA\\3uo>\u00148N\u0003\u0002={\u000511m\\7n_:T!a\b \u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0005\u0003\u0007f\u0012A\u0002T5ti\u0016tWM\u001d(b[\u0016\fQ\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004\u0013a\u00022s_.,'o]\u000b\u0002\u000fB\u0019\u0001\nU*\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'!\u0003\u0019a$o\\8u}%\ta&\u0003\u0002P[\u00059\u0001/Y2lC\u001e,\u0017BA)S\u0005\r\u0019V-\u001d\u0006\u0003\u001f6\u0002\"a\t+\n\u0005Uc\"aC&bM.\f'I]8lKJ\f1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u0011\u0001l\u0017\t\u0003YeK!AW\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b9\u001e\t\t\u00111\u0001H\u0003\rAH%M\u0001\tEJ|7.\u001a:tA\u0005)Ao\u001c9jGV\t\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006!A.\u00198h\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005A\u0001O]8ek\u000e,'/F\u0001l!\u0011a\u0007oK\u0016\u000e\u00035T!!\u001b8\u000b\u0005=l\u0014aB2mS\u0016tGo]\u0005\u0003c6\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\u0018\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHC\u0001-u\u0011\u001daF\"!AA\u0002-\f\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012\u0001\u0017\u0015\u0003\u001de\u00042A_A\u0002\u001b\u0005Y(B\u0001?~\u0003\r\t\u0007/\u001b\u0006\u0003}~\fqA[;qSR,'OC\u0002\u0002\u0002\u0001\u000bQA[;oSRL1!!\u0002|\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0016tQ>,H\u000e\u001a\"p_R\u001cHO]1q)^|'I]8lKJ\u001cx+\u001b;i\u0019\u0016\fG-\u001a:UQJ|G\u000f\u001e7fQ\ry\u00111\u0002\t\u0004u\u00065\u0011bAA\bw\n!A+Z:u\u00035\u001a\bn\\;mI\n{w\u000e^:ue\u0006\u0004Hk^8Ce>\\WM]:XSRDgi\u001c7m_^,'\u000f\u00165s_R$H.\u001a\u0015\u0004!\u0005-\u0011AN:i_VdG-T1uG\"\fVo\u001c;b%\u0016\u0004H.[2bi&tw\r\u00165s_V<\u0007.\u00118BgflW.\u001a;sS\u000e$v\u000e]8m_\u001eLHc\u0001-\u0002\u001a!9\u00111D\tA\u0002\u0005u\u0011A\u00047fC\u0012,'\u000f\u00165s_R$H.\u001a\t\u0004Y\u0005}\u0011bAA\u0011[\t9!i\\8mK\u0006t\u0017A\u0001;q)\u0011\t9#a\f\u0011\t\u0005%\u00121F\u0007\u0002w%\u0019\u0011QF\u001e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u0007\nA\u0002\u0005M\u0012!\u00039beRLG/[8o!\ra\u0013QG\u0005\u0004\u0003oi#aA%oi\u0006I2\u000f[8vY\u0012$\u0006N]8ui2,w\n\u001c3TK\u001elWM\u001c;tQ\r\u0019\u00121B\u0001\bC\u0012$G)\u0019;b)\u0015A\u0016\u0011IA#\u0011\u001d\t\u0019\u0005\u0006a\u0001\u0003g\t\u0001\"\\:h\u0007>,h\u000e\u001e\u0005\u0007\u0003\u000f\"\u0002\u0019A\u0016\u0002\u00075\u001cx-A\u000bxC&$hi\u001c:PM\u001a\u001cX\r^:U_6\u000bGo\u00195\u0015\u000fa\u000bi%!\u0015\u0002V!9\u0011qJ\u000bA\u0002\u0005M\u0012AB8gMN,G\u000fC\u0004\u0002TU\u0001\r!a\r\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0003/*\u0002\u0019AA\u001a\u0003!\u0011'o\\6fe&#\u0017!\u00032s_.,'OR8s)\r\u0019\u0016Q\f\u0005\b\u0003?2\u0002\u0019AA\u001a\u0003\tIG-A\u0007de\u0016\fG/\u001a\"s_.,'o\u001d\u000b\u00041\u0006\u0015\u0004bBA4/\u0001\u0007\u0011\u0011N\u0001\nEJ|7.\u001a:JIN\u0004B\u0001\u0013)\u00024\u00051\u0011M\u001e*bi\u0016$b!a\u001c\u0002v\u0005\u001d\u0005c\u0001\u0017\u0002r%\u0019\u00111O\u0017\u0003\r\u0011{WO\u00197f\u0011\u001d\t9\b\u0007a\u0001\u0003s\nqB]3qY&\u001c\u0017\r^5p]RK\b/\u001a\t\u0005\u0003w\n\u0019)\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0015\tXo\u001c;b\u0015\tiR(\u0003\u0003\u0002\u0006\u0006u$!C)v_R\fG+\u001f9f\u0011\u0019)\u0005\u00041\u0001\u0002j\u0005aQ.Z1tkJ,GMU1uKR1\u0011qNAG\u0003#Ca!a$\u001a\u0001\u0004\u0019\u0016A\u00022s_.,'\u000fC\u0004\u0002\u0014f\u0001\r!!\u001f\u0002\u000fI,\u0007\u000fV=qK\u0006q!/Z4jgR,'O\u0011:pW\u0016\u0014Hc\u0001-\u0002\u001a\"9\u0011q\f\u000eA\u0002\u0005M\u0002")
public class ReplicationQuotasTest
extends QuorumTestHarness {
    private final byte[] msg100KB = new byte[100000];
    private final ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private scala.collection.immutable.Seq<KafkaBroker> brokers;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer;

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public ListenerName listenerName() {
        return this.listenerName;
    }

    public scala.collection.immutable.Seq<KafkaBroker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(scala.collection.immutable.Seq<KafkaBroker> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers(), true);
        super.tearDown();
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(false);
    }

    public void shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(boolean leaderThrottle) {
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaBroker>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105).map((Function1 & Serializable)id -> this.createBroker(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4())));
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 107})))}));
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        LongRef throttle = LongRef.create((long)(msgCount * msg.length / expectedDuration));
        if (!leaderThrottle) {
            throttle.elem *= 3L;
        }
        Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()), (Function1 & Serializable)admin -> {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.registerBroker(id));
            admin.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new NewTopic(this.topic(), CollectionConverters$.MODULE$.MapHasAsJava((Map)assignment.map((Function1 & Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)a._1$mcI$sp())), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)a._2()).map((Function1 & Serializable)x$3 -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$5(BoxesRunTime.unboxToInt((Object)x$3)))).toList()).asJava()))).asJava()), (List)Nil$.MODULE$)).asJava()).all().get();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 107).foreach((Function1 & Serializable)brokerId -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$6(this, throttle, BoxesRunTime.unboxToInt((Object)brokerId)));
            ConfigEntry configEntry = leaderThrottle ? new ConfigEntry("leader.replication.throttled.replicas", "0:100,1:101,2:102,3:103,4:104,5:105") : new ConfigEntry("follower.replication.throttled.replicas", "0:106,1:106,2:106,3:107,4:107,5:107");
            return (Void)admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, this.topic())), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(configEntry, AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)partition -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$8(this, msg, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        this.waitForOffsetsToMatch(msgCount, 6, 100);
        this.waitForOffsetsToMatch(msgCount, 7, 101);
        long start = System.currentTimeMillis();
        this.createBrokers((scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertEquals((long)throttle$1.elem, (long)this.brokerFor(brokerId).quotaManagers().follower().upperBound()));
        if (!leaderThrottle) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(106).quotaManagers().follower().isThrottled(this.tp(partition))));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(107).quotaManagers().follower().isThrottled(this.tp(partition))));
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(6), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        long unthrottledTook = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 106));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 107));
        long throttledTook = System.currentTimeMillis() - start;
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assertions.assertTrue(((double)unthrottledTook < throttledLowerBound ? 1 : 0) != 0, (String)("Expected " + unthrottledTook + " < " + throttledLowerBound));
        Assertions.assertTrue(((double)throttledTook > throttledLowerBound ? 1 : 0) != 0, (String)("Expected " + throttledTook + " > " + throttledLowerBound));
        Assertions.assertTrue((throttledTook < (long)throttledUpperBound ? 1 : 0) != 0, (String)("Expected " + throttledTook + " < " + throttledUpperBound));
        double rateUpperBound = (double)throttle.elem * 1.1;
        double rateLowerBound = (double)throttle.elem * 0.5;
        double rate = leaderThrottle ? this.avRate(QuotaType.LEADER_REPLICATION, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate(QuotaType.FOLLOWER_REPLICATION, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        Assertions.assertTrue((rate < rateUpperBound ? 1 : 0) != 0, (String)("Expected " + rate + " < " + rateUpperBound));
        Assertions.assertTrue((rate > rateLowerBound ? 1 : 0) != 0, (String)("Expected " + rate + " > " + rateLowerBound));
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    @Test
    public void shouldThrottleOldSegments() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        config.put("log.segment.bytes", Integer.toString(0x100000));
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaBroker>)new .colon.colon((Object)this.createBroker(KafkaConfig$.MODULE$.fromProps(config), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()), (List)Nil$.MODULE$));
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()), (Function1 & Serializable)admin -> {
            this.registerBroker(101);
            admin.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new NewTopic(this.topic(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101}))).map((Function1 & Serializable)x$5 -> ReplicationQuotasTest.$anonfun$shouldThrottleOldSegments$2(BoxesRunTime.unboxToInt((Object)x$5)))).asJava())), (List)Nil$.MODULE$)).asJava()).all().get();
            java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "100")), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("leader.replication.throttled.rate", Long.toString(throttle)), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, this.topic())), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("leader.replication.throttled.replicas", "0:100"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection())}))).asJava();
            return (Void)admin.incrementalAlterConfigs(configs).all().get();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting new broker");
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaBroker>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)this.createBroker(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()))));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)("Throttled replication of " + throttledTook + "ms should be > " + (double)(expectedDuration * 1000) * 0.9 + "ms"));
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)("Throttled replication of " + throttledTook + "ms should be < " + expectedDuration * 1500 + "ms"));
    }

    public void addData(int msgCount, byte[] msg) {
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1 & Serializable)x$6 -> ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)x$6))).foreach((Function1 & Serializable)x$7 -> (RecordMetadata)x$7.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$1(this, offset, brokerId, partitionId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$4(partitionId, brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaBroker brokerFor(int id) {
        return (KafkaBroker)((IterableOps)this.brokers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$9)))).head();
    }

    public void createBrokers(scala.collection.immutable.Seq<Object> brokerIds) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.brokers_$eq((scala.collection.immutable.Seq<KafkaBroker>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)this.createBroker(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4())))));
    }

    private double avRate(QuotaType replicationType, scala.collection.immutable.Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)brokers.map((Function1 & Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)))).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$10, replicationType)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaBroker broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)CollectionConverters$.MODULE$.MapHasAsScala(broker.metrics().metrics()).asScala().apply((Object)metricName)).metricValue());
    }

    private void registerBroker(int id) {
        BrokerRegistrationRequestData.ListenerCollection listeners = new BrokerRegistrationRequestData.ListenerCollection();
        listeners.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Listener().setName(SecurityProtocol.PLAINTEXT.name).setHost("localhost").setPort(9092 + id));
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(MetadataVersion.latestProduction().featureLevel()).setMaxSupportedVersion(MetadataVersion.latestTesting().featureLevel()));
        Feature.PRODUCTION_FEATURES.forEach(feature -> features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName(feature.featureName()).setMinSupportedVersion(feature.minimumProduction()).setMaxSupportedVersion(feature.latestTesting())));
        this.controllerServer().controller().registerBroker(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, new BrokerRegistrationRequestData().setBrokerId(id).setClusterId(this.controllerServer().clusterId()).setIncarnationId(Uuid.randomUuid()).setListeners(listeners).setLogDirs(Collections.singletonList(Uuid.fromString((String)("TESTBROKER" + Integer.toString(100000 + id).substring(1) + "DIRAAAA")))).setFeatures(features)).get();
    }

    public static final /* synthetic */ Integer $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$5(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ java.util.Map $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$6(ReplicationQuotasTest $this, LongRef throttle$1, int brokerId) {
        AbstractMap.SimpleImmutableEntry<AlterConfigOp.OpType, String> entry = new AbstractMap.SimpleImmutableEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.SET, Long.toString(throttle$1.elem));
        return (java.util.Map)$this.controllerServer().controller().incrementalAlterConfigs(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, String.valueOf(brokerId))), (Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader.replication.throttled.rate"), entry), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"follower.replication.throttled.rate"), entry)}))).asJava())}))).asJava(), false).get();
    }

    public static final /* synthetic */ Future $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$8(ReplicationQuotasTest $this, byte[] msg$1, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)msg$1));
    }

    public static final /* synthetic */ Integer $anonfun$shouldThrottleOldSegments$2(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$2, int x$6) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$2));
    }

    public static final /* synthetic */ boolean $anonfun$waitForOffsetsToMatch$1(ReplicationQuotasTest $this, int offset$1, int brokerId$1, int partitionId$1) {
        LogManager qual$1 = $this.brokerFor(brokerId$1).logManager();
        TopicPartition x$1 = new TopicPartition($this.topic(), partitionId$1);
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)offset$1), (Object)qual$1.getLog(x$1, x$2).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.logEndOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public static final /* synthetic */ String $anonfun$waitForOffsetsToMatch$4(int partitionId$1, int brokerId$1) {
        return "Offsets did not match for partition " + partitionId$1 + " on broker " + brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaBroker x$9) {
        return x$9.config().brokerId() == id$1;
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }
}

