/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.ReplicaManager;
import kafka.server.share.SharePartition;
import kafka.server.share.SharePartitionManager;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.InvalidRecordStateException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.coordinator.group.ShareGroupAutoOffsetResetStrategy;
import org.apache.kafka.server.share.acknowledge.ShareAcknowledgementBatch;
import org.apache.kafka.server.share.fetch.DelayedShareFetchGroupKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchKey;
import org.apache.kafka.server.share.fetch.ShareAcquiredRecords;
import org.apache.kafka.server.share.fetch.ShareFetchTestUtils;
import org.apache.kafka.server.share.metrics.SharePartitionMetrics;
import org.apache.kafka.server.share.persister.NoOpStatePersister;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.Persister;
import org.apache.kafka.server.share.persister.PersisterStateBatch;
import org.apache.kafka.server.share.persister.ReadShareGroupStateParameters;
import org.apache.kafka.server.share.persister.ReadShareGroupStateResult;
import org.apache.kafka.server.share.persister.TopicData;
import org.apache.kafka.server.share.persister.WriteShareGroupStateParameters;
import org.apache.kafka.server.share.persister.WriteShareGroupStateResult;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.server.util.FutureUtils;
import org.apache.kafka.server.util.timer.MockTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Option;

public class SharePartitionTest {
    private static final String ACQUISITION_LOCK_NEVER_GOT_RELEASED = "Acquisition lock never got released.";
    private static final String GROUP_ID = "test-group";
    private static final int MAX_DELIVERY_COUNT = 5;
    private static final TopicIdPartition TOPIC_ID_PARTITION = new TopicIdPartition(Uuid.randomUuid(), 0, "test-topic");
    private static final String MEMBER_ID = "member-1";
    private static final Time MOCK_TIME = new MockTime();
    private static final short MAX_IN_FLIGHT_MESSAGES = 200;
    private static final int ACQUISITION_LOCK_TIMEOUT_MS = 100;
    private static final int DEFAULT_MAX_WAIT_ACQUISITION_LOCK_TIMEOUT_MS = 120;
    private static final int BATCH_SIZE = 500;
    private static final int DEFAULT_FETCH_OFFSET = 0;
    private static final int MAX_FETCH_RECORDS = Integer.MAX_VALUE;
    private static final byte ACKNOWLEDGE_TYPE_GAP_ID = 0;
    private static final FetchIsolation FETCH_ISOLATION_HWM = FetchIsolation.HIGH_WATERMARK;
    private static Timer mockTimer;
    private SharePartitionMetrics sharePartitionMetrics;

    @BeforeEach
    public void setUp() {
        kafka.utils.TestUtils.clearYammerMetrics();
        mockTimer = new MockTimer();
        this.sharePartitionMetrics = new SharePartitionMetrics(GROUP_ID, TOPIC_ID_PARTITION.topic(), TOPIC_ID_PARTITION.partition());
    }

    @AfterEach
    public void tearDown() throws Exception {
        mockTimer.close();
        this.sharePartitionMetrics.close();
    }

    @Test
    public void testRecordStateValidateTransition() {
        Assertions.assertThrows(NullPointerException.class, () -> SharePartition.RecordState.AVAILABLE.validateTransition(null));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.AVAILABLE.validateTransition(SharePartition.RecordState.AVAILABLE));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACQUIRED.validateTransition(SharePartition.RecordState.ACQUIRED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACKNOWLEDGED.validateTransition(SharePartition.RecordState.ACKNOWLEDGED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ARCHIVED.validateTransition(SharePartition.RecordState.ARCHIVED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACKNOWLEDGED.validateTransition(SharePartition.RecordState.AVAILABLE));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACKNOWLEDGED.validateTransition(SharePartition.RecordState.ACQUIRED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ACKNOWLEDGED.validateTransition(SharePartition.RecordState.ARCHIVED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ARCHIVED.validateTransition(SharePartition.RecordState.AVAILABLE));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ARCHIVED.validateTransition(SharePartition.RecordState.ACKNOWLEDGED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.ARCHIVED.validateTransition(SharePartition.RecordState.ARCHIVED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.AVAILABLE.validateTransition(SharePartition.RecordState.ACKNOWLEDGED));
        Assertions.assertThrows(IllegalStateException.class, () -> SharePartition.RecordState.AVAILABLE.validateTransition(SharePartition.RecordState.ARCHIVED));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)SharePartition.RecordState.AVAILABLE.validateTransition(SharePartition.RecordState.ACQUIRED));
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)SharePartition.RecordState.ACQUIRED.validateTransition(SharePartition.RecordState.AVAILABLE));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)SharePartition.RecordState.ACQUIRED.validateTransition(SharePartition.RecordState.ACKNOWLEDGED));
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)SharePartition.RecordState.ACQUIRED.validateTransition(SharePartition.RecordState.ARCHIVED));
    }

    @Test
    public void testRecordStateForId() {
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)SharePartition.RecordState.forId((byte)0));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)SharePartition.RecordState.forId((byte)1));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)SharePartition.RecordState.forId((byte)2));
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)SharePartition.RecordState.forId((byte)4));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharePartition.RecordState.forId((byte)5));
    }

    @Test
    public void testMaybeInitialize() throws InterruptedException {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        Assertions.assertNotNull(sharePartition.cachedState().get(11L));
        Assertions.assertEquals((long)10L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)2, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertEquals((long)15L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(11L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(11L)).batchState());
        Assertions.assertEquals((int)3, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(11L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(11L)).offsetState());
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightBatchCount").intValue() == 2, (String)"In-flight batch count should be 2.");
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightMessageCount").longValue() == 11L, (String)"In-flight message count should be 11.");
        Assertions.assertEquals((double)11.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().sum());
        Assertions.assertEquals((long)2L, (long)this.sharePartitionMetrics.inFlightBatchMessageCount().count());
        Assertions.assertEquals((double)5.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().min());
        Assertions.assertEquals((double)6.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().max());
    }

    @Test
    public void testMaybeInitializeDefaultStartEpochGroupConfigReturnsEarliest() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.EARLIEST);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 0L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-2L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
    }

    @Test
    public void testMaybeInitializeDefaultStartEpochGroupConfigReturnsLatest() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.LATEST);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 15L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-1L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
    }

    @Test
    public void testMaybeInitializeDefaultStartEpochGroupConfigReturnsByDuration() throws InterruptedException {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        ShareGroupAutoOffsetResetStrategy resetStrategy = (ShareGroupAutoOffsetResetStrategy)Mockito.mock(ShareGroupAutoOffsetResetStrategy.class);
        long expectedTimestamp = MOCK_TIME.milliseconds() - TimeUnit.HOURS.toMillis(1L);
        Mockito.when((Object)resetStrategy.type()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.StrategyType.BY_DURATION);
        Mockito.when((Object)resetStrategy.timestamp()).thenReturn((Object)expectedTimestamp);
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)resetStrategy);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(MOCK_TIME.milliseconds() - TimeUnit.HOURS.toMillis(1L), 15L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)expectedTimestamp), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightBatchCount").intValue() == 0, (String)"In-flight batch count should be 0.");
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightMessageCount").longValue() == 0L, (String)"In-flight message count should be 0.");
    }

    @Test
    public void testMaybeInitializeDefaultStartEpochGroupConfigNotPresent() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.empty());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 15L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-1L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
    }

    @Test
    public void testMaybeInitializeFetchOffsetForLatestTimestampThrowsError() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.empty());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException("fetch offsets exception")});
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-1L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeFetchOffsetForEarliestTimestampThrowsError() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.EARLIEST);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException("fetch offsets exception")});
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)-2L), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeFetchOffsetForByDurationThrowsError() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)-1L, (short)PartitionFactory.DEFAULT_ERROR_CODE, (String)PartitionFactory.DEFAULT_ERR_MESSAGE, List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        ShareGroupAutoOffsetResetStrategy resetStrategy = (ShareGroupAutoOffsetResetStrategy)Mockito.mock(ShareGroupAutoOffsetResetStrategy.class);
        long expectedTimestamp = MOCK_TIME.milliseconds() - TimeUnit.HOURS.toMillis(1L);
        Mockito.when((Object)groupConfig.shareAutoOffsetReset()).thenReturn((Object)resetStrategy);
        Mockito.when((Object)resetStrategy.type()).thenReturn((Object)ShareGroupAutoOffsetResetStrategy.StrategyType.BY_DURATION);
        Mockito.when((Object)resetStrategy.timestamp()).thenReturn((Object)expectedTimestamp);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException("fetch offsets exception")});
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withGroupConfigManager(groupConfigManager).withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.eq((long)expectedTimestamp), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeSharePartitionAgain() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        ((Persister)Mockito.verify((Object)persister, (VerificationMode)Mockito.times((int)1))).readState((ReadShareGroupStateParameters)Mockito.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaybeInitializeSharePartitionAgainConcurrentRequests() throws InterruptedException {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ArrayList results = new ArrayList(10);
        try {
            for (int i = 0; i < 10; ++i) {
                executorService.submit(() -> results.add(sharePartition.maybeInitialize()));
            }
        }
        finally {
            if (!executorService.awaitTermination(30L, TimeUnit.MILLISECONDS)) {
                executorService.shutdown();
            }
        }
        Assertions.assertTrue((boolean)results.stream().allMatch(CompletableFuture::isDone));
        Assertions.assertFalse((boolean)results.stream().allMatch(CompletableFuture::isCompletedExceptionally));
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        ((Persister)Mockito.verify((Object)persister, (VerificationMode)Mockito.times((int)1))).readState((ReadShareGroupStateParameters)Mockito.any());
    }

    @Test
    public void testMaybeInitializeWithEmptyStateBatches() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertTrue((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)5, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeInitializeWithErrorPartitionResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.NOT_COORDINATOR.code(), (String)Errors.NOT_COORDINATOR.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(CoordinatorNotAvailableException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (String)Errors.COORDINATOR_NOT_AVAILABLE.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(CoordinatorNotAvailableException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.COORDINATOR_LOAD_IN_PROGRESS.code(), (String)Errors.COORDINATOR_LOAD_IN_PROGRESS.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(CoordinatorNotAvailableException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(GroupIdNotFoundException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.FENCED_STATE_EPOCH.code(), (String)Errors.FENCED_STATE_EPOCH.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(NotLeaderOrFollowerException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.FENCED_LEADER_EPOCH.code(), (String)Errors.FENCED_LEADER_EPOCH.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(NotLeaderOrFollowerException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.UNKNOWN_SERVER_ERROR.code(), (String)Errors.UNKNOWN_SERVER_ERROR.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(UnknownServerException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)5, (long)10L, (short)Errors.NETWORK_EXCEPTION.code(), (String)Errors.NETWORK_EXCEPTION.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(UnknownServerException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithInvalidStartOffsetStateBatches() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)6L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithInvalidTopicIdResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(Uuid.randomUuid(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithInvalidPartitionResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)1, (int)3, (long)5L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithNoOpStatePersister() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 0L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        SharePartition sharePartition = SharePartitionBuilder.builder().withReplicaManager(replicaManager).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertTrue((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithNullResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(null));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithNullTopicsData() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(null);
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithEmptyTopicsData() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of());
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeWithReadException() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new RuntimeException("Read exception")));
        SharePartition sharePartition1 = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition1.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(RuntimeException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FAILED, (Object)sharePartition1.partitionState());
        persister = (Persister)Mockito.mock(Persister.class);
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Read exception")});
        SharePartition sharePartition2 = SharePartitionBuilder.builder().withPersister(persister).build();
        Assertions.assertThrows(RuntimeException.class, () -> ((SharePartition)sharePartition2).maybeInitialize());
    }

    @Test
    public void testMaybeInitializeFencedSharePartition() {
        SharePartition sharePartition = SharePartitionBuilder.builder().build();
        sharePartition.markFenced();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(LeaderNotAvailableException.class, (Future)result);
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.FENCED, (Object)sharePartition.partitionState());
    }

    @Test
    public void testMaybeInitializeStateBatchesWithGapAtBeginning() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)10L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(15L, 20L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(15L));
        Assertions.assertNotNull(sharePartition.cachedState().get(21L));
        Assertions.assertEquals((long)20L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((int)2, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
        Assertions.assertEquals((long)30L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).batchState());
        Assertions.assertEquals((int)3, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).offsetState());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)10L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)30L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testMaybeInitializeStateBatchesWithMultipleGaps() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)10L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(15L, 20L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(30L, 40L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(15L));
        Assertions.assertNotNull(sharePartition.cachedState().get(30L));
        Assertions.assertEquals((long)20L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((int)2, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
        Assertions.assertEquals((long)40L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchState());
        Assertions.assertEquals((int)3, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).offsetState());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)10L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testMaybeInitializeStateBatchesWithGapNotAtBeginning() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)15L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(15L, 20L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(30L, 40L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)21L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)21L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(30L));
        Assertions.assertEquals((long)40L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchState());
        Assertions.assertEquals((int)3, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).offsetState());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)21L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testMaybeInitializeStateBatchesWithoutGaps() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)15L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(15L, 20L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ARCHIVED.id, 3)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertTrue((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)31L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)31L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)31L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNull((Object)initialReadGapOffset);
    }

    @Test
    public void testAcquireSingleRecord() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        MemoryRecords records = this.memoryRecords(1);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 1);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)1L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).firstOffset());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightBatchCount").intValue() == 1, (String)"In-flight batch count should be 1.");
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightMessageCount").longValue() == 1L, (String)"In-flight message count should be 1.");
        Assertions.assertEquals((double)1.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().sum());
    }

    @Test
    public void testAcquireMultipleRecords() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        MemoryRecords records = this.memoryRecords(5, 10L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 3L, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)10L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).firstOffset());
        Assertions.assertEquals((long)14L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightBatchCount").intValue() == 1, (String)"In-flight batch count should be 1.");
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightMessageCount").longValue() == 5L, (String)"In-flight message count should be 5.");
        Assertions.assertEquals((double)5.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().sum());
    }

    @Test
    public void testAcquireWithMaxFetchRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, 10, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(0L, 4L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
        records = this.memoryRecords(25);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, 10, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 20);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(5L, 24L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).firstOffset());
        Assertions.assertEquals((long)5L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).firstOffset());
        Assertions.assertEquals((long)24L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testAcquireWithMultipleBatchesAndMaxFetchRecords() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)10L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)15L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)30L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, 10, 0L, this.fetchPartitionData((Records)records, 10L), FETCH_ISOLATION_HWM), 20);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(10L, 29L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)10L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).firstOffset());
        Assertions.assertEquals((long)29L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightBatchCount").intValue() == 1, (String)"In-flight batch count should be 1.");
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightMessageCount").longValue() == 20L, (String)"In-flight message count should be 20.");
        Assertions.assertEquals((double)20.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().sum());
    }

    @Test
    public void testAcquireMultipleRecordsWithOverlapAndNewBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 0L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 3L, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        records = this.memoryRecords(10, 0L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 3L, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(this.memoryRecords(5, 5L), 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testAcquireSameBatchAgain() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 10L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 3L, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 3L, 0);
        Assertions.assertEquals((int)0, (int)acquiredRecordsList.size());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        MemoryRecords subsetRecords = this.memoryRecords(2, 10L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)subsetRecords, 3L, 0);
        Assertions.assertEquals((int)0, (int)acquiredRecordsList.size());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcquireWithEmptyFetchRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, Integer.MAX_VALUE, 0L, this.fetchPartitionData((Records)MemoryRecords.EMPTY), FETCH_ISOLATION_HWM), 0);
        Assertions.assertEquals((int)0, (int)acquiredRecordsList.size());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testAcquireWithBatchSizeAndSingleBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 2, 10, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(0L, 4L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
    }

    @Test
    public void testAcquireWithBatchSizeAndMultipleBatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)2L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)10L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)7, (long)15L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)6, (long)22L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 5, 100, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 26);
        List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords = this.expectedAcquiredRecords(records, 1);
        expectedAcquiredRecords.remove(0);
        expectedAcquiredRecords.addAll(0, this.expectedAcquiredRecord(2L, 9L, 1));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecords.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)28L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)4, (int)sharePartition.cachedState().size());
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(2L));
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(10L));
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(15L));
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(22L));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchDeliveryCount());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).offsetState());
    }

    @Test
    public void testAcquireWithBatchSizeAndMaxFetchRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)0L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)5L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)20L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 2, 10, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 20);
        List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords = this.expectedAcquiredRecords(records, 1);
        expectedAcquiredRecords.remove(2);
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecords.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((long)0L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).lastOffset());
        Assertions.assertEquals((long)5L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).firstOffset());
        Assertions.assertEquals((long)19L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchMemberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testAcquireSingleBatchWithBatchSizeAndEndOffsetLargerThanBatchFirstOffset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.updateCacheAndOffsets(8L);
        MemoryRecords records = this.memoryRecords(10, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 5, 100, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 7);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(8L, 14L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(8L));
    }

    @Test
    public void testAcquireWithBatchSizeAndEndOffsetLargerThanBatchFirstOffset() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        sharePartition.updateCacheAndOffsets(4L);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)8, (long)2L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)7, (long)10L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 5, 100, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 13);
        List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords = this.expectedAcquiredRecords(records, 1);
        expectedAcquiredRecords.remove(0);
        expectedAcquiredRecords.addAll(0, this.expectedAcquiredRecord(4L, 9L, 1));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecords.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)17L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(4L));
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(10L));
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightBatchCount").intValue() == 2, (String)"In-flight batch count should be 2.");
        TestUtils.waitForCondition(() -> ShareFetchTestUtils.yammerMetricValue((String)"InFlightMessageCount").longValue() == 13L, (String)"In-flight message count should be 13.");
        Assertions.assertEquals((double)13.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().sum());
        Assertions.assertEquals((long)2L, (long)this.sharePartitionMetrics.inFlightBatchMessageCount().count());
        Assertions.assertEquals((double)6.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().min());
        Assertions.assertEquals((double)7.0, (double)this.sharePartitionMetrics.inFlightBatchMessageCount().max());
    }

    @Test
    public void testAcquireBatchSkipWithBatchSizeAndEndOffsetLargerThanFirstBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.updateCacheAndOffsets(12L);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)8, (long)2L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)7, (long)10L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 5, 100, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(12L, 16L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)17L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(12L));
    }

    @Test
    public void testNextFetchOffsetInitialState() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetWithCachedStateAcquired() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5), 2L, 5);
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetWithFindAndCachedStateEmpty() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.findNextFetchOffset(true);
        Assertions.assertTrue((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetWithFindAndCachedState() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.findNextFetchOffset(true);
        Assertions.assertTrue((boolean)sharePartition.findNextFetchOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5), 5);
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
    }

    @Test
    public void testCanAcquireRecordsWithEmptyCache() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(1).build();
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testCanAcquireRecordsWithCachedDataAndLimitNotReached() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(6).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5), 5);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testCanAcquireRecordsWithCachedDataAndLimitReached() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(1).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5), 5);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testMaybeAcquireAndReleaseFetchLock() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        FileRecords.TimestampAndOffset timestampAndOffset = new FileRecords.TimestampAndOffset(-1L, 0L, Optional.empty());
        ((ReplicaManager)Mockito.doReturn((Object)new OffsetResultHolder(Optional.of(timestampAndOffset), Optional.empty())).when((Object)replicaManager)).fetchOffsetForTimestamp((TopicPartition)Mockito.any(TopicPartition.class), Mockito.anyLong(), (Option)Mockito.any(), (Optional)Mockito.any(), Mockito.anyBoolean());
        Time time = (Time)Mockito.mock(Time.class);
        Mockito.when((Object)time.hiResClockMs()).thenReturn((Object)100L).thenReturn((Object)110L).thenReturn((Object)120L).thenReturn((Object)140L).thenReturn((Object)170L);
        SharePartition sharePartition = SharePartitionBuilder.builder().withReplicaManager(replicaManager).withTime(time).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        Uuid fetchId = Uuid.randomUuid();
        sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)sharePartition.maybeAcquireFetchLock(fetchId));
        Assertions.assertFalse((boolean)sharePartition.maybeAcquireFetchLock(fetchId));
        sharePartition.releaseFetchLock(fetchId);
        Assertions.assertEquals((long)1L, (long)this.sharePartitionMetrics.fetchLockTimeMs().count());
        Assertions.assertEquals((double)10.0, (double)this.sharePartitionMetrics.fetchLockTimeMs().sum());
        Assertions.assertEquals((long)1L, (long)this.sharePartitionMetrics.fetchLockRatio().count());
        Assertions.assertEquals((double)100.0, (double)this.sharePartitionMetrics.fetchLockRatio().mean());
        Assertions.assertTrue((boolean)sharePartition.maybeAcquireFetchLock(fetchId));
        sharePartition.releaseFetchLock(fetchId);
        Assertions.assertEquals((long)2L, (long)this.sharePartitionMetrics.fetchLockTimeMs().count());
        Assertions.assertEquals((double)40.0, (double)this.sharePartitionMetrics.fetchLockTimeMs().sum());
        Assertions.assertEquals((long)2L, (long)this.sharePartitionMetrics.fetchLockRatio().count());
        Assertions.assertEquals((double)80.0, (double)this.sharePartitionMetrics.fetchLockRatio().mean());
    }

    @Test
    public void testRecordFetchLockRatioMetric() {
        Time time = (Time)Mockito.mock(Time.class);
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).withTime(time).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        sharePartition.recordFetchLockRatioMetric(0L);
        Assertions.assertEquals((long)1L, (long)this.sharePartitionMetrics.fetchLockRatio().count());
        Assertions.assertEquals((double)100.0, (double)this.sharePartitionMetrics.fetchLockRatio().mean());
        Mockito.when((Object)time.hiResClockMs()).thenReturn((Object)10L).thenReturn((Object)80L).thenReturn((Object)160L);
        Uuid fetchId = Uuid.randomUuid();
        Assertions.assertTrue((boolean)sharePartition.maybeAcquireFetchLock(fetchId));
        sharePartition.releaseFetchLock(fetchId);
        Assertions.assertEquals((long)2L, (long)this.sharePartitionMetrics.fetchLockRatio().count());
        Assertions.assertEquals((double)100.0, (double)this.sharePartitionMetrics.fetchLockRatio().mean());
        Assertions.assertTrue((boolean)sharePartition.maybeAcquireFetchLock(fetchId));
        sharePartition.recordFetchLockRatioMetric(0L);
        Assertions.assertEquals((long)3L, (long)this.sharePartitionMetrics.fetchLockRatio().count());
        Assertions.assertEquals((double)67.0, (double)this.sharePartitionMetrics.fetchLockRatio().mean());
        sharePartition.recordFetchLockRatioMetric(10L);
        Assertions.assertEquals((long)4L, (long)this.sharePartitionMetrics.fetchLockRatio().count());
        Assertions.assertEquals((double)53.0, (double)this.sharePartitionMetrics.fetchLockRatio().mean());
    }

    @Test
    public void testAcknowledgeSingleRecordBatch() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        SharePartition sharePartition = SharePartitionBuilder.builder().withReplicaManager(replicaManager).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(1, 0L);
        MemoryRecords records2 = this.memoryRecords(1, 1L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records1, 1);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records2, 1);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(1L, 1L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)2L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).offsetState());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedShareFetchRequest((DelayedShareFetchKey)new DelayedShareFetchGroupKey(GROUP_ID, TOPIC_ID_PARTITION));
    }

    @Test
    public void testAcknowledgeMultipleRecordBatch() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        SharePartition sharePartition = SharePartitionBuilder.builder().withReplicaManager(replicaManager).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(10, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 10);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 14L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).completeDelayedShareFetchRequest((DelayedShareFetchKey)new DelayedShareFetchGroupKey(GROUP_ID, TOPIC_ID_PARTITION));
    }

    @Test
    public void testAcknowledgeMultipleRecordBatchWithGapOffsets() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)5, (long)10L);
        recordsBuilder.appendWithOffset(18L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records1, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)7L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records2, 9);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records2, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)19L, (long)sharePartition.nextFetchOffset());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 6L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(10L, 18L, List.of(Byte.valueOf((byte)2), Byte.valueOf((byte)2), Byte.valueOf((byte)2), Byte.valueOf((byte)2), Byte.valueOf((byte)2), Byte.valueOf((byte)0), Byte.valueOf((byte)0), Byte.valueOf((byte)0), Byte.valueOf((byte)1)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcknowledgeMultipleSubsetRecordBatchWithGapOffsets() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)2, (long)10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records1, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)7L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records2, 11);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records2, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)21L, (long)sharePartition.nextFetchOffset());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(6L, 18L, List.of((byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)21L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcknowledgeOutOfRangeCachedData() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 15L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
        MemoryRecords records = this.memoryRecords(5, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(20L, 25L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)ackResult);
    }

    @Test
    public void testAcknowledgeOutOfRangeCachedDataFirstBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 0L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        records = this.memoryRecords(5, 20L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        List<ShareAcknowledgementBatch> acknowledgeBatches = List.of(new ShareAcknowledgementBatch(0L, 10L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(20L, 24L, List.of(Byte.valueOf((byte)1))));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, acknowledgeBatches);
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)ackResult);
        records = this.memoryRecords(6, 5L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 6);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        ackResult = sharePartition.acknowledge(MEMBER_ID, acknowledgeBatches);
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
    }

    @Test
    public void testAcknowledgeWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        CompletableFuture ackResult = sharePartition.acknowledge("member-2", List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
    }

    @Test
    public void testAcknowledgeWhenOffsetNotAcquired() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 5L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(6L, 8L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(6L, 8L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
    }

    @Test
    public void testAcknowledgeRollbackWithFullBatchError() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 5L);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        MemoryRecords records3 = this.memoryRecords(5, 15L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(10L, 14L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(15L, 19L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(15L, 19L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
    }

    @Test
    public void testAcknowledgeRollbackWithSubsetError() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 5L);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        MemoryRecords records3 = this.memoryRecords(5, 15L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        Assertions.assertEquals((int)1, (int)acquiredRecordsList.size());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(10L, 14L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(15L, 19L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(16L, 19L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
    }

    @Test
    public void testAcquireReleasedRecord() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(5, 10L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(12L, 13L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 2);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(12L, 13L, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testAcquireReleasedRecordMultipleBatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 10L);
        MemoryRecords records2 = this.memoryRecords(5, 15L);
        MemoryRecords records3 = this.memoryRecords(5, 23L);
        MemoryRecords records4 = this.memoryRecords(5, 28L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records1, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records2, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records3, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)28L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records4, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records4, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)33L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).offsetState());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(12L, 30L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)4, (int)sharePartition.cachedState().size());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(23L)).batchMemberId());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).offsetState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(28L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(29L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(30L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(31L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(32L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(28L)).offsetState());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records1, 3);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(12L, 14L, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(records3, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        MemoryRecords subsetRecords = this.memoryRecords(2, 17L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)subsetRecords, 2);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(17L, 18L, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        subsetRecords = this.memoryRecords(1, 28L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)subsetRecords, 1);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecords(28L, 28L, 2).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records2, 3);
        List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords = this.expectedAcquiredRecords(15L, 16L, 2);
        expectedAcquiredRecords.addAll(this.expectedAcquiredRecords(19L, 19L, 2));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecords.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((long)29L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testAcquireGapAtBeginningAndRecordsFetchedFromGap() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        MemoryRecords records = this.memoryRecords(5, 11L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 5);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(11L, 15L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)16L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)16L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireGapAtBeginningAndFetchedRecordsOverlapInFlightBatches() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        MemoryRecords records = this.memoryRecords(15, 11L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 10);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(11L, 20L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)41L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)21L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireGapAtBeginningAndFetchedRecordsOverlapInFlightAvailableBatches() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        MemoryRecords records = this.memoryRecords(15, 11L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 15);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(11L, 20L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(21L, 21L, 3));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(22L, 22L, 3));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(23L, 23L, 3));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(24L, 24L, 3));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(25L, 25L, 3));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)26L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)26L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireWhenCachedStateContainsGapsAndRecordsFetchedFromNonGapOffset() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(11L, 20L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        MemoryRecords records = this.memoryRecords(15, 11L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 15);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(11L, 20L, 3));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(21L, 25L, 1));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)26L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)26L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireGapAtBeginningAndFetchedRecordsOverlapMultipleInFlightBatches() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(41L, 50L, SharePartition.RecordState.AVAILABLE.id, 1), new PersisterStateBatch(61L, 70L, SharePartition.RecordState.ARCHIVED.id, 1), new PersisterStateBatch(81L, 90L, SharePartition.RecordState.AVAILABLE.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        MemoryRecords records = this.memoryRecords(75, 11L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 55);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(11L, 20L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(31L, 40L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(41L, 50L, 2));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(51L, 60L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(71L, 80L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(81L, 81L, 2));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(82L, 82L, 2));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(83L, 83L, 2));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(84L, 84L, 2));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(85L, 85L, 2));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)90L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)86L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)86L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)90L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireGapAtBeginningAndFetchedRecordsEndJustBeforeGap() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(41L, 50L, SharePartition.RecordState.ACKNOWLEDGED.id, 1), new PersisterStateBatch(61L, 70L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        MemoryRecords records = this.memoryRecords(20, 11L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 20);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(11L, 20L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(21L, 30L, 3));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)70L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)31L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)31L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)70L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireGapAtBeginningAndFetchedRecordsIncludeGapOffsetsAtEnd() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(41L, 50L, SharePartition.RecordState.AVAILABLE.id, 1), new PersisterStateBatch(61L, 70L, SharePartition.RecordState.ARCHIVED.id, 1), new PersisterStateBatch(81L, 90L, SharePartition.RecordState.AVAILABLE.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        MemoryRecords records = this.memoryRecords(65, 11L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 45);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(11L, 20L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(31L, 40L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(41L, 50L, 2));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(51L, 60L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(71L, 75L, 1));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)90L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)76L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)76L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)90L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireWhenRecordsFetchedFromGapAndMaxFetchRecordsIsExceeded() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(11L, 20L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)3, (long)21L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)3, (long)24L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)2, (long)27L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, 6, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 6);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(21L, 26L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)21L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)27L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)27L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireMaxFetchRecordsExceededAfterAcquiringGaps() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)10, (long)11L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)10, (long)21L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, 8, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 10);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(11L, 20L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)21L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)21L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireMaxFetchRecordsExceededBeforeAcquiringGaps() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(11L, 20L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.AVAILABLE.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)10, (long)11L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)20, (long)21L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, 8, 0L, this.fetchPartitionData((Records)records), FETCH_ISOLATION_HWM), 10);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(11L, 20L, 3).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)21L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)21L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testAcquireWhenRecordsFetchedFromGapAndPartitionContainsNaturalGaps() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)10L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(15L, 20L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(30L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)11, (long)10L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)21, (long)30L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 24);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(10L, 14L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(21L, 29L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(41L, 50L, 1));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)50L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)51L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNull((Object)initialReadGapOffset);
    }

    @Test
    public void testAcquireCachedStateInitialGapMatchesWithActualPartitionGap() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(41L, 50L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)21L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)25, (long)36L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 20);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(31L, 40L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(51L, 60L, 1));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)60L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)61L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNull((Object)initialReadGapOffset);
    }

    @Test
    public void testAcquireCachedStateInitialGapOverlapsWithActualPartitionGap() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(41L, 50L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)20, (long)16L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)25, (long)36L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 25);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(16L, 20L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(31L, 40L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(51L, 60L, 1));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)16L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)60L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)61L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNull((Object)initialReadGapOffset);
    }

    @Test
    public void testAcquireCachedStateGapInBetweenOverlapsWithActualPartitionGap() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(41L, 50L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)10, (long)11L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)21L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)20, (long)41L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 30);
        ArrayList<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord = new ArrayList<ShareFetchResponseData.AcquiredRecords>(this.expectedAcquiredRecord(11L, 20L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(31L, 40L, 1));
        expectedAcquiredRecord.addAll(this.expectedAcquiredRecord(51L, 60L, 1));
        Assertions.assertArrayEquals((Object[])expectedAcquiredRecord.toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)60L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)61L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNull((Object)initialReadGapOffset);
    }

    @Test
    public void testAcquireWhenRecordsFetchedAfterGapsAreFetched() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(11L, 20L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        MemoryRecords records = this.memoryRecords(15, 21L);
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 10);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(21L, 30L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)21L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)41L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)31L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
        records = this.memoryRecords(15, 41L);
        acquiredRecordsList = this.fetchAcquiredRecords(sharePartition, (Records)records, 15);
        Assertions.assertArrayEquals((Object[])this.expectedAcquiredRecord(41L, 55L, 1).toArray(), (Object[])acquiredRecordsList.toArray());
        Assertions.assertEquals((Object)SharePartition.SharePartitionState.ACTIVE, (Object)sharePartition.partitionState());
        Assertions.assertFalse((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)21L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)55L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.stateEpoch());
        Assertions.assertEquals((long)56L, (long)sharePartition.nextFetchOffset());
        initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNull((Object)initialReadGapOffset);
    }

    @Test
    public void testAcquisitionLockForAcquiringSingleRecord() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(1), 1);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null && sharePartition.timer().size() == 0, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(0L, List.of())));
        Assertions.assertEquals((long)1L, (long)this.sharePartitionMetrics.acquisitionLockTimeoutPerSec().count());
        Assertions.assertTrue((this.sharePartitionMetrics.acquisitionLockTimeoutPerSec().meanRate() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testAcquisitionLockForAcquiringMultipleRecords() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 10L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(10L, List.of())));
        Assertions.assertEquals((long)5L, (long)this.sharePartitionMetrics.acquisitionLockTimeoutPerSec().count());
        Assertions.assertTrue((this.sharePartitionMetrics.acquisitionLockTimeoutPerSec().meanRate() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testAcquisitionLockForAcquiringMultipleRecordsWithOverlapAndNewBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).withSharePartitionMetrics(this.sharePartitionMetrics).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 0L), 5);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 0L), 5);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)2, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(0L, List.of(), 5L, List.of())));
        Assertions.assertEquals((long)10L, (long)this.sharePartitionMetrics.acquisitionLockTimeoutPerSec().count());
        Assertions.assertTrue((this.sharePartitionMetrics.acquisitionLockTimeoutPerSec().meanRate() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testAcquisitionLockForAcquiringSameBatchAgain() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 10L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(10L, List.of())));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
    }

    @Test
    public void testAcquisitionLockOnAcknowledgingSingleRecordBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(1, 0L), 1);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 0L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(0L, List.of())));
    }

    @Test
    public void testAcquisitionLockOnAcknowledgingMultipleRecordBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 5L), 10);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 14L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of())));
    }

    @Test
    public void testAcquisitionLockOnAcknowledgingMultipleRecordBatchWithGapOffsets() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)5, (long)10L);
        recordsBuilder.appendWithOffset(18L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        MemoryRecords records3 = this.memoryRecords(2, 1L);
        this.fetchAcquiredRecords(sharePartition, (Records)records3, 2);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)2, (int)sharePartition.timer().size());
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 9);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)3, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 18L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 1L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchAcquisitionLockTimeoutTask() == null && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(1L, List.of(), 5L, List.of(), 10L, List.of())));
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    @Test
    public void testAcquisitionLockForAcquiringSubsetBatchAgain() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(8, 10L), 8);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 10L && sharePartition.cachedState().size() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(10L, List.of())));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(3, 12L), 3);
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)3, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 10L && expectedOffsetStateMap.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        }, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(10L, List.of(Long.valueOf(10L), Long.valueOf(11L), Long.valueOf(12L), Long.valueOf(13L), Long.valueOf(14L), Long.valueOf(15L), Long.valueOf(16L), Long.valueOf(17L)))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testAcquisitionLockOnAcknowledgingMultipleSubsetRecordBatchWithGapOffsets() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)2, (long)10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 11);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)2, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(6L, 18L, List.of((byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(18L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(19L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(20L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)3, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap1 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap1.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap2 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap2.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && expectedOffsetStateMap1.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState()) && expectedOffsetStateMap2.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        }, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of(Long.valueOf(5L), Long.valueOf(6L)), 10L, List.of(10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(18L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(19L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(20L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testAcquisitionLockTimeoutCauseMaxDeliveryCountExceed() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 0L), 10);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 10L), 10);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)2, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(10L, List.of())));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 10L), 10);
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((int)2, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.ARCHIVED && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount() == 2 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(10L, List.of())));
    }

    @Test
    public void testAcquisitionLockTimeoutCauseSPSOMoveForward() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 0L), 10);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(0L, List.of())));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 0L), 5);
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(0L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(1L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(2L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(3L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(4L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && expectedOffsetStateMap.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
        }, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(0L, List.of(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L), Long.valueOf(9L)))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
    }

    @Test
    public void testAcquisitionLockTimeoutCauseSPSOMoveForwardAndClearCachedState() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 0L), 10);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 0L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(0L, List.of())));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 0L), 10);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.cachedState().isEmpty() && sharePartition.nextFetchOffset() == 10L, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of()));
    }

    @Test
    public void testAcknowledgeAfterAcquisitionLockTimeout() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of())));
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
        ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
    }

    @Test
    public void testAcquisitionLockAfterDifferentAcknowledges() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 6L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)3, (int)sharePartition.timer().size());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(8L, 9L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && expectedOffsetStateMap.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        }, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of(Long.valueOf(5L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L), Long.valueOf(9L)))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testAcquisitionLockOnBatchWithWriteShareGroupStateFailure() throws InterruptedException {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 5L), 10);
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.timer().size() == 0 && sharePartition.nextFetchOffset() == 5L && sharePartition.cachedState().size() == 1 && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask() == null, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of())));
    }

    @Test
    public void testAcquisitionLockOnOffsetWithWriteShareGroupStateFailure() throws InterruptedException {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(6, 5L), 6);
        Assertions.assertEquals((int)1, (int)sharePartition.timer().size());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(8L, 9L, List.of(Byte.valueOf((byte)1)))));
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return sharePartition.timer().size() == 0 && sharePartition.cachedState().size() == 1 && expectedOffsetStateMap.equals(((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        }, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of(Long.valueOf(5L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L), Long.valueOf(9L), Long.valueOf(10L)))));
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testReleaseSingleRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(1, 0L), 1);
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((int)0, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
    }

    @Test
    public void testReleaseMultipleRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 5L), 10);
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)0, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testReleaseMultipleAcknowledgedRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records0 = this.memoryRecords(5, 0L);
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecords records2 = this.memoryRecords(9, 10L);
        this.fetchAcquiredRecords(sharePartition, (Records)records0, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 9);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 18L, List.of(Byte.valueOf((byte)1)))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcknowledgedMultipleSubsetRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)2, (long)10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 11);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(6L, 18L, List.of((byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(1, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)2, (long)10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        sharePartition.acquire("member-2", 500, Integer.MAX_VALUE, 5L, this.fetchPartitionData((Records)records1), FETCH_ISOLATION_HWM);
        sharePartition.acquire(MEMBER_ID, 500, Integer.MAX_VALUE, 10L, this.fetchPartitionData((Records)records2), FETCH_ISOLATION_HWM);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(10L, 18L, List.of(Byte.valueOf((byte)1), Byte.valueOf((byte)1), Byte.valueOf((byte)0), Byte.valueOf((byte)0), Byte.valueOf((byte)1), Byte.valueOf((byte)0), Byte.valueOf((byte)1), Byte.valueOf((byte)0), Byte.valueOf((byte)1)))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)19L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        releaseResult = sharePartition.releaseAcquiredRecords("member-2");
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsWithAnotherMemberAndSubsetAcknowledged() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)2, (long)10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        sharePartition.acquire("member-2", 500, Integer.MAX_VALUE, 5L, this.fetchPartitionData((Records)records1), FETCH_ISOLATION_HWM);
        sharePartition.acquire(MEMBER_ID, 500, Integer.MAX_VALUE, 10L, this.fetchPartitionData((Records)records2), FETCH_ISOLATION_HWM);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(10L, 18L, List.of(Byte.valueOf((byte)1), Byte.valueOf((byte)1), Byte.valueOf((byte)0), Byte.valueOf((byte)0), Byte.valueOf((byte)1), Byte.valueOf((byte)0), Byte.valueOf((byte)1), Byte.valueOf((byte)0), Byte.valueOf((byte)1)))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)19L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        sharePartition.acknowledge("member-2", List.of(new ShareAcknowledgementBatch(5L, 5L, List.of(Byte.valueOf((byte)1)))));
        releaseResult = sharePartition.releaseAcquiredRecords("member-2");
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)6L, (long)sharePartition.nextFetchOffset());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsForEmptyCachedData() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testReleaseAcquiredRecordsAfterDifferentAcknowledges() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 6L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(8L, 9L, List.of(Byte.valueOf((byte)1)))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testMaxDeliveryCountLimitNotExceededForRecordsSubsetAfterReleaseAcquiredRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 0L), 10);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(10L, 14L, List.of(Byte.valueOf((byte)2)))));
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testMaxDeliveryCountLimitNotExceededForRecordsSubsetAfterReleaseAcquiredRecordsSubset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 10L);
        MemoryRecords records2 = this.memoryRecords(5, 15L);
        MemoryRecords records3 = this.memoryRecords(5, 20L);
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(List.of(new ShareAcknowledgementBatch(13L, 16L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(17L, 19L, List.of(Byte.valueOf((byte)3))), new ShareAcknowledgementBatch(20L, 24L, List.of(Byte.valueOf((byte)2))))));
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertThrows(IllegalStateException.class, () -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).offsetState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).offsetState());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordsSubsetCacheCleared() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 10L);
        MemoryRecords records2 = this.memoryRecords(5, 15L);
        MemoryRecords records3 = this.memoryRecords(5, 20L);
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(List.of(new ShareAcknowledgementBatch(10L, 12L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(13L, 16L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(17L, 19L, List.of(Byte.valueOf((byte)3))), new ShareAcknowledgementBatch(20L, 24L, List.of(Byte.valueOf((byte)2))))));
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(List.of(new ShareAcknowledgementBatch(13L, 16L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(20L, 24L, List.of(Byte.valueOf((byte)2))))));
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testReleaseAcquiredRecordsSubsetWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(7, 5L), 7);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 7L, List.of(Byte.valueOf((byte)1)))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords("member-2");
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testReleaseBatchWithWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 5L), 10);
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertTrue((boolean)releaseResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(GroupIdNotFoundException.class, (Future)releaseResult);
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
    }

    @Test
    public void testReleaseOffsetWithWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(6, 5L), 6);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(8L, 9L, List.of(Byte.valueOf((byte)1)))));
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertTrue((boolean)releaseResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(GroupIdNotFoundException.class, (Future)releaseResult);
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).memberId());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).memberId());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).memberId());
    }

    @Test
    public void testAcquisitionLockOnReleasingMultipleRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 5L), 10);
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)0, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
    }

    @Test
    public void testAcquisitionLockOnReleasingAcknowledgedMultipleSubsetRecordBatchWithGapOffsets() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)2, (long)10L);
        recordsBuilder.appendWithOffset(14L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(16L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        recordsBuilder.appendWithOffset(20L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 11);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(6L, 18L, List.of((byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, (byte)0, (byte)1, (byte)0, (byte)1))));
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        expectedOffsetStateMap.clear();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(18L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(19L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(20L)).acquisitionLockTimeoutTask());
        Assertions.assertEquals((int)0, (int)sharePartition.timer().size());
    }

    @Test
    public void testLsoMovementOnInitializationSharePartition() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        sharePartition.updateCacheAndOffsets(0L);
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        sharePartition.updateCacheAndOffsets(5L);
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.endOffset());
    }

    @Test
    public void testLsoMovementForArchivingBatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 12L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 17L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 22L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 27L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 32L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(2L, 6L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(12L, 16L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(22L, 26L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(27L, 31L, List.of(Byte.valueOf((byte)3)))));
        sharePartition.updateCacheAndOffsets(20L);
        Assertions.assertEquals((long)22L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)20L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)36L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)6, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(12L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(12L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(12L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(17L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(17L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(17L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(22L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(27L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(27L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(27L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(32L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(32L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(32L)).batchAcquisitionLockTimeoutTask());
    }

    @Test
    public void testLsoMovementForArchivingOffsets() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(4L, 8L, List.of(Byte.valueOf((byte)1)))));
        sharePartition.updateCacheAndOffsets(5L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(7L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(8L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(9L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        expectedOffsetStateMap = new HashMap();
        expectedOffsetStateMap.put(2L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(3L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(4L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(2L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(3L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(4L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(5L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).offsetState().get(6L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testLsoMovementForArchivingOffsetsWithStartAndEndBatchesNotFullMatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.updateCacheAndOffsets(4L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)4L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        sharePartition.updateCacheAndOffsets(8L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)8L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
    }

    @Test
    public void testLsoMovementForArchivingOffsetsWithStartOffsetNotFullMatches() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.updateCacheAndOffsets(4L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)4L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        sharePartition.updateCacheAndOffsets(7L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
    }

    @Test
    public void testLsoMovementForArchivingOffsetsWithStartOffsetNotFullMatchesPostAcceptAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.updateCacheAndOffsets(4L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)4L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(7L, 8L, List.of(Byte.valueOf((byte)1)))));
        sharePartition.updateCacheAndOffsets(7L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementForArchivingOffsetsWithStartOffsetNotFullMatchesPostReleaseAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.updateCacheAndOffsets(4L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)4L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(7L, 8L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.updateCacheAndOffsets(7L);
        Assertions.assertEquals((long)7L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementToEndOffset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(7L, 8L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementToEndOffsetWhereEndOffsetIsAvailable() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(7L, 8L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(11L, 11L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)11L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementAheadOfEndOffsetPostAcknowledgment() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(7L, 8L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.updateCacheAndOffsets(12L);
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)12L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)12L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).offsetState());
    }

    @Test
    public void testLsoMovementAheadOfEndOffset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 7L), 5);
        sharePartition.updateCacheAndOffsets(14L);
        Assertions.assertEquals((long)14L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(7L)).batchState());
    }

    @Test
    public void testLsoMovementWithGapsInCachedStateMap() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 2L);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        MemoryRecords records3 = this.memoryRecords(5, 20L);
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records3, 5);
        sharePartition.updateCacheAndOffsets(18L);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)18L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
    }

    @Test
    public void testLsoMovementWithGapsInCachedStateMapAndAcknowledgedBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 2L);
        MemoryRecords records2 = this.memoryRecords(5, 10L);
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(10L, 14L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.updateCacheAndOffsets(10L);
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    @Test
    public void testLsoMovementPostGapsInAcknowledgments() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(2, 5L);
        MemoryRecordsBuilder recordsBuilder = ShareFetchTestUtils.memoryRecordsBuilder((int)5, (long)10L);
        recordsBuilder.appendWithOffset(18L, 0L, TestUtils.randomString((int)10).getBytes(), TestUtils.randomString((int)10).getBytes());
        MemoryRecords records2 = recordsBuilder.build();
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 9);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 6L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(10L, 18L, List.of(Byte.valueOf((byte)2), Byte.valueOf((byte)2), Byte.valueOf((byte)2), Byte.valueOf((byte)2), Byte.valueOf((byte)2), Byte.valueOf((byte)0), Byte.valueOf((byte)0), Byte.valueOf((byte)0), Byte.valueOf((byte)2)))));
        sharePartition.updateCacheAndOffsets(18L);
        Assertions.assertEquals((long)18L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)18L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)18L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsBatchesPostStartOffsetMovement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.acquire("member-2", 500, Integer.MAX_VALUE, 15L, this.fetchPartitionData((Records)this.memoryRecords(5, 15L)), FETCH_ISOLATION_HWM);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 20L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 25L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 30L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 35L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(6L, 7L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(8L, 8L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(25L, 29L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(35L, 37L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.updateCacheAndOffsets(24L);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)39L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)7, (int)sharePartition.cachedState().size());
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)"member-2", (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        expectedOffsetStateMap = new HashMap();
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(21L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(22L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(23L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(24L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).offsetState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(25L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(25L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchState());
        expectedOffsetStateMap = new HashMap();
        expectedOffsetStateMap.put(35L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(36L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(37L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(38L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(39L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(35L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsBatchesPostStartOffsetMovementToStartOfBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.updateCacheAndOffsets(10L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    @Test
    public void testReleaseAcquiredRecordsBatchesPostStartOffsetMovementToMiddleOfBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testReleaseAcquiredRecordsDecreaseDeliveryCount() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(12L, 13L, List.of(Byte.valueOf((byte)1)))));
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        CompletableFuture releaseResult = sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertNull(releaseResult.join());
        Assertions.assertFalse((boolean)releaseResult.isCompletedExceptionally());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        expectedOffsetStateMap = new HashMap();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 0, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testAcquisitionLockTimeoutForBatchesPostStartOffsetMovement() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.acquire("member-2", 500, Integer.MAX_VALUE, 15L, this.fetchPartitionData((Records)this.memoryRecords(5, 15L)), FETCH_ISOLATION_HWM);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 20L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 25L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 30L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 35L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(6L, 7L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(8L, 8L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(25L, 29L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(35L, 37L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.updateCacheAndOffsets(24L);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)39L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)7, (int)sharePartition.cachedState().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap1 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap1.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap1.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap2 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap2.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(21L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(22L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(23L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap2.put(24L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap3 = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap3.put(35L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap3.put(36L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap3.put(37L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap3.put(38L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap3.put(39L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().equals(expectedOffsetStateMap1) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).offsetState().equals(expectedOffsetStateMap2) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(25L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(30L)).batchState() == SharePartition.RecordState.AVAILABLE && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(35L)).offsetState().equals(expectedOffsetStateMap3);
        }, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of(Long.valueOf(5L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L), Long.valueOf(9L)), 20L, List.of(Long.valueOf(20L), Long.valueOf(21L), Long.valueOf(22L), Long.valueOf(23L), Long.valueOf(24L)), 25L, List.of(), 30L, List.of(), 35L, List.of(Long.valueOf(35L), Long.valueOf(36L), Long.valueOf(37L), Long.valueOf(38L), Long.valueOf(39L)))));
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
    }

    @Test
    public void testAcquisitionLockTimeoutForBatchesPostStartOffsetMovementToStartOfBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.updateCacheAndOffsets(10L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId().equals(SharePartition.EMPTY_MEMBER_ID) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.ARCHIVED && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId().equals(SharePartition.EMPTY_MEMBER_ID) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState() == SharePartition.RecordState.AVAILABLE, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of(), 10L, List.of())));
    }

    @Test
    public void testAcquisitionLockTimeoutForBatchesPostStartOffsetMovementToMiddleOfBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.updateCacheAndOffsets(11L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)11L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> {
            HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
            expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
            return ((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().equals(expectedOffsetStateMap) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId().equals(SharePartition.EMPTY_MEMBER_ID) && ((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState() == SharePartition.RecordState.ARCHIVED;
        }, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of(5L, List.of(), 10L, List.of(Long.valueOf(10L), Long.valueOf(11L), Long.valueOf(12L), Long.valueOf(13L), Long.valueOf(14L)))));
    }

    @Test
    public void testScheduleAcquisitionLockTimeoutValueFromGroupConfig() {
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        int expectedDurationMs = 500;
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareRecordLockDurationMs()).thenReturn((Object)expectedDurationMs);
        SharePartition sharePartition = SharePartitionBuilder.builder().withGroupConfigManager(groupConfigManager).build();
        SharePartition.AcquisitionLockTimerTask timerTask = sharePartition.scheduleAcquisitionLockTimeout(MEMBER_ID, 100L, 200L);
        ((GroupConfigManager)Mockito.verify((Object)groupConfigManager, (VerificationMode)Mockito.times((int)2))).groupConfig(GROUP_ID);
        ((GroupConfig)Mockito.verify((Object)groupConfig)).shareRecordLockDurationMs();
        Assertions.assertEquals((long)expectedDurationMs, (long)timerTask.delayMs);
    }

    @Test
    public void testScheduleAcquisitionLockTimeoutValueUpdatesSuccessfully() {
        GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        GroupConfig groupConfig = (GroupConfig)Mockito.mock(GroupConfig.class);
        int expectedDurationMs1 = 500;
        int expectedDurationMs2 = 1000;
        Mockito.when((Object)groupConfigManager.groupConfig(GROUP_ID)).thenReturn(Optional.of(groupConfig));
        Mockito.when((Object)groupConfig.shareRecordLockDurationMs()).thenReturn((Object)expectedDurationMs1).thenReturn((Object)expectedDurationMs2);
        SharePartition sharePartition = SharePartitionBuilder.builder().withGroupConfigManager(groupConfigManager).build();
        SharePartition.AcquisitionLockTimerTask timerTask1 = sharePartition.scheduleAcquisitionLockTimeout(MEMBER_ID, 100L, 200L);
        ((GroupConfigManager)Mockito.verify((Object)groupConfigManager, (VerificationMode)Mockito.times((int)2))).groupConfig(GROUP_ID);
        ((GroupConfig)Mockito.verify((Object)groupConfig)).shareRecordLockDurationMs();
        Assertions.assertEquals((long)expectedDurationMs1, (long)timerTask1.delayMs);
        SharePartition.AcquisitionLockTimerTask timerTask2 = sharePartition.scheduleAcquisitionLockTimeout(MEMBER_ID, 100L, 200L);
        ((GroupConfigManager)Mockito.verify((Object)groupConfigManager, (VerificationMode)Mockito.times((int)4))).groupConfig(GROUP_ID);
        ((GroupConfig)Mockito.verify((Object)groupConfig, (VerificationMode)Mockito.times((int)2))).shareRecordLockDurationMs();
        Assertions.assertEquals((long)expectedDurationMs2, (long)timerTask2.delayMs);
    }

    @Test
    public void testAcknowledgeBatchAndOffsetPostLsoMovement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.updateCacheAndOffsets(12L);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)12L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(2L, 6L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(10L, 14L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)12L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)12L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchAcquisitionLockTimeoutTask());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testAcknowledgeBatchPostLsoMovement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 20L), 5);
        sharePartition.updateCacheAndOffsets(14L);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(2L, 14L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertNull(ackResult.join());
        Assertions.assertFalse((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)24L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testLsoMovementThenAcquisitionLockTimeoutThenAcknowledge() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        sharePartition.updateCacheAndOffsets(7L);
        Assertions.assertEquals((long)7L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(2L)).batchAcquisitionLockTimeoutTask());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.nextFetchOffset() == 7L && sharePartition.cachedState().isEmpty() && sharePartition.startOffset() == 7L && sharePartition.endOffset() == 7L, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of()));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(2L, 14L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)14L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchAcquisitionLockTimeoutTask());
    }

    @Test
    public void testLsoMovementThenAcquisitionLockTimeoutThenAcknowledgeBatchLastOffsetAheadOfStartOffsetBatch() throws InterruptedException {
        SharePartition sharePartition = SharePartitionBuilder.builder().withDefaultAcquisitionLockTimeoutMs(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(2, 1L), 2);
        sharePartition.updateCacheAndOffsets(3L);
        Assertions.assertEquals((long)3L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)3L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)3L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(1L)).batchAcquisitionLockTimeoutTask());
        mockTimer.advanceClock(120L);
        TestUtils.waitForCondition(() -> sharePartition.nextFetchOffset() == 3L && sharePartition.cachedState().isEmpty() && sharePartition.startOffset() == 3L && sharePartition.endOffset() == 3L, (long)120L, () -> this.assertionFailedMessage(sharePartition, Map.of()));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(2, 3L), 2);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(3, 5L), 3);
        Assertions.assertEquals((long)8L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)3L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(1L, 7L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)3L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)3L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)7L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(3L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(3L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(3L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchAcquisitionLockTimeoutTask());
    }

    @Test
    public void testWriteShareGroupStateWithNullResponse() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(null));
        CompletableFuture result = sharePartition.writeShareGroupState(List.of());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)result);
    }

    @Test
    public void testWriteShareGroupStateWithNullTopicsData() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(null);
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)result);
    }

    @Test
    public void testWriteShareGroupStateWithInvalidTopicsData() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of());
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)writeResult);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of()), new TopicData(Uuid.randomUuid(), List.of())));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)writeResult);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of())));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)writeResult);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(Uuid.randomUuid(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)writeResult);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message()), PartitionFactory.newPartitionErrorData((int)1, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)writeResult);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)1, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        writeResult = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)writeResult);
    }

    @Test
    public void testWriteShareGroupStateWithWriteException() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition1 = SharePartitionBuilder.builder().withPersister(persister).build();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn((Object)FutureUtils.failedFuture((Throwable)new RuntimeException("Write exception")));
        CompletableFuture writeResult = sharePartition1.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)writeResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(IllegalStateException.class, (Future)writeResult);
        persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition2 = SharePartitionBuilder.builder().withPersister(persister).build();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Write exception")});
        Assertions.assertThrows(RuntimeException.class, () -> sharePartition2.writeShareGroupState(ArgumentMatchers.anyList()));
    }

    @Test
    public void testWriteShareGroupState() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertNull(result.join());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
    }

    @Test
    public void testWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NOT_COORDINATOR.code(), (String)Errors.NOT_COORDINATOR.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        CompletableFuture result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(CoordinatorNotAvailableException.class, (Future)result);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (String)Errors.COORDINATOR_NOT_AVAILABLE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(CoordinatorNotAvailableException.class, (Future)result);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.COORDINATOR_LOAD_IN_PROGRESS.code(), (String)Errors.COORDINATOR_LOAD_IN_PROGRESS.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(CoordinatorNotAvailableException.class, (Future)result);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(GroupIdNotFoundException.class, (Future)result);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, (Future)result);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.FENCED_STATE_EPOCH.code(), (String)Errors.FENCED_STATE_EPOCH.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(NotLeaderOrFollowerException.class, (Future)result);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.FENCED_LEADER_EPOCH.code(), (String)Errors.FENCED_LEADER_EPOCH.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(NotLeaderOrFollowerException.class, (Future)result);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.UNKNOWN_SERVER_ERROR.code(), (String)Errors.UNKNOWN_SERVER_ERROR.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        result = sharePartition.writeShareGroupState(ArgumentMatchers.anyList());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        TestUtils.assertFutureThrows(UnknownServerException.class, (Future)result);
    }

    @Test
    public void testWriteShareGroupStateWithNoOpStatePersister() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        List<PersisterStateBatch> stateBatches = List.of(new PersisterStateBatch(5L, 10L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(11L, 15L, SharePartition.RecordState.ARCHIVED.id, 3));
        CompletableFuture result = sharePartition.writeShareGroupState(stateBatches);
        Assertions.assertNull(result.join());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementTypeAccept() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(250, 0L), 250);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 249L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertEquals((long)250L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementTypeReject() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(250, 0L), 250);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 249L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertEquals((long)250L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementTypeRelease() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(250, 0L), 250);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 249L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchState());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).batchDeliveryCount());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementsFromBeginningForBatchSubset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(20).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 0L), 15);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 15L), 15);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 12L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(12L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(13L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)13L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)29L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementsFromBeginningForEntireBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(20).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 0L), 15);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 15L), 15);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 14L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)29L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAcknowledgementsInBetween() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(20).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 0L), 15);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 15L), 15);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(10L, 14L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(9L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(10L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)29L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateWhenAllRecordsInCachedStateAreAcknowledged() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(20).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 0L), 15);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 15L), 15);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 29L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)30L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)30L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateMultipleAcquisitionsAndAcknowledgements() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(20, 0L), 20);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(20, 20L), 20);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(20, 40L), 20);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 19L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)20L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)59L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)60L, (long)sharePartition.nextFetchOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(20, 60L), 20);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(20L, 49L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertEquals((Object)SharePartition.RecordState.ACKNOWLEDGED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(40L)).offsetState().get(49L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(40L)).offsetState().get(50L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(60L)).batchState());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)50L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)79L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)80L, (long)sharePartition.nextFetchOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(100, 80L), 100);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(50L, 179L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)180L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)180L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)180L, (long)sharePartition.nextFetchOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(20, 180L), 20);
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(180L)).batchState());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)180L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)199L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)200L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testMaybeUpdateCachedStateGapAfterLastOffsetAcknowledged() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(11L, 20L, SharePartition.RecordState.AVAILABLE.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 11L), 10);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(11L, 20L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)21L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)40L, (long)sharePartition.endOffset());
        Assertions.assertEquals((long)21L, (long)sharePartition.nextFetchOffset());
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)21L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
    }

    @Test
    public void testCanAcquireRecordsReturnsTrue() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(150, 0L), 150);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)149L, (long)sharePartition.endOffset());
    }

    @Test
    public void testCanAcquireRecordsChangeResponsePostAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.endOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(150, 0L), 150);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(100, 150L), 100);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 249L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)250L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)250L, (long)sharePartition.endOffset());
    }

    @Test
    public void testCanAcquireRecordsAfterReleaseAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(150, 0L), 150);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)149L, (long)sharePartition.endOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(100, 150L), 100);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 89L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testCanAcquireRecordsAfterArchiveAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(150, 0L), 150);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)149L, (long)sharePartition.endOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(100, 150L), 100);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 89L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertEquals((long)90L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testCanAcquireRecordsAfterAcceptAcknowledgement() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(150, 0L), 150);
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)149L, (long)sharePartition.endOffset());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(100, 150L), 100);
        Assertions.assertFalse((boolean)sharePartition.canAcquireRecords());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 89L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertEquals((long)90L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)249L, (long)sharePartition.endOffset());
        Assertions.assertTrue((boolean)sharePartition.canAcquireRecords());
    }

    @Test
    public void testAcknowledgeBatchWithWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(10, 5L), 10);
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 14L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, (Future)ackResult);
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
    }

    @Test
    public void testAcknowledgeOffsetWithWriteShareGroupStateFailure() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.GROUP_ID_NOT_FOUND.code(), (String)Errors.GROUP_ID_NOT_FOUND.message())))));
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(writeShareGroupStateResult));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(6, 5L), 6);
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(8L, 10L, List.of(Byte.valueOf((byte)3)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(5L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(6L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(7L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(8L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(9L)).memberId());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState().get(10L)).memberId());
    }

    @Test
    public void testAcknowledgeSubsetWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(7, 5L), 7);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 7L, List.of(Byte.valueOf((byte)1)))));
        CompletableFuture ackResult = sharePartition.acknowledge("member-2", List.of(new ShareAcknowledgementBatch(9L, 11L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
    }

    @Test
    public void testAcknowledgeWithAnotherMemberRollbackBatchError() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        sharePartition.acquire("member-2", 500, Integer.MAX_VALUE, 10L, this.fetchPartitionData((Records)this.memoryRecords(5, 10L)), FETCH_ISOLATION_HWM);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 15L), 5);
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(10L, 14L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(15L, 19L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)"member-2", (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
    }

    @Test
    public void testAcknowledgeWithAnotherMemberRollbackSubsetError() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 10L), 5);
        sharePartition.acquire("member-2", 500, Integer.MAX_VALUE, 15L, this.fetchPartitionData((Records)this.memoryRecords(5, 15L)), FETCH_ISOLATION_HWM);
        CompletableFuture ackResult = sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(10L, 14L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(16L, 18L, List.of(Byte.valueOf((byte)1)))));
        Assertions.assertTrue((boolean)ackResult.isCompletedExceptionally());
        TestUtils.assertFutureThrows(InvalidRecordStateException.class, (Future)ackResult);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchDeliveryCount());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchState());
        Assertions.assertEquals((Object)"member-2", (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchMemberId());
        Assertions.assertEquals((int)1, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(15L)).batchDeliveryCount());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records = this.memoryRecords(10, 5L);
        this.fetchAcquiredRecords(sharePartition, (Records)records, 10);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 14L, List.of(Byte.valueOf((byte)2)))));
        this.fetchAcquiredRecords(sharePartition, (Records)records, 10);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 14L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)15L, (long)sharePartition.endOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordsSubset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 10L);
        MemoryRecords records2 = this.memoryRecords(5, 15L);
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 5);
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(List.of(new ShareAcknowledgementBatch(10L, 12L, List.of(Byte.valueOf((byte)1))), new ShareAcknowledgementBatch(13L, 16L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(17L, 19L, List.of(Byte.valueOf((byte)1))))));
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 2);
        this.fetchAcquiredRecords(sharePartition, (Records)records2, 2);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(13L, 16L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)0, (int)sharePartition.cachedState().size());
    }

    @Test
    public void testMaxDeliveryCountLimitExceededForRecordsSubsetAndCachedStateNotCleared() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxDeliveryCount(2).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 0L);
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        sharePartition.acknowledge(MEMBER_ID, new ArrayList<ShareAcknowledgementBatch>(List.of(new ShareAcknowledgementBatch(0L, 1L, List.of(Byte.valueOf((byte)2))))));
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(2, 0L), 2);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(0L, 4L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)2L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(0L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(1L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 2, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(2L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(3L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(4L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState());
    }

    @Test
    public void testNextFetchOffsetPostAcquireAndAcknowledgeFunctionality() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(10, 0L);
        String memberId1 = "memberId-1";
        String memberId2 = "memberId-2";
        sharePartition.acquire(memberId1, 500, Integer.MAX_VALUE, 0L, this.fetchPartitionData((Records)records1), FETCH_ISOLATION_HWM);
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(memberId2, 500, Integer.MAX_VALUE, 10L, this.fetchPartitionData((Records)this.memoryRecords(10, 10L)), FETCH_ISOLATION_HWM);
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        sharePartition.acknowledge(memberId1, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertTrue((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(memberId1, 500, Integer.MAX_VALUE, 0L, this.fetchPartitionData((Records)records1), FETCH_ISOLATION_HWM);
        Assertions.assertTrue((boolean)sharePartition.findNextFetchOffset());
        Assertions.assertEquals((long)20L, (long)sharePartition.nextFetchOffset());
        Assertions.assertFalse((boolean)sharePartition.findNextFetchOffset());
    }

    @Test
    public void testNextFetchOffsetWithMultipleConsumers() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withMaxInflightMessages(100).withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(3, 0L);
        String memberId1 = MEMBER_ID;
        String memberId2 = "member-2";
        sharePartition.acquire(memberId1, 500, Integer.MAX_VALUE, 0L, this.fetchPartitionData((Records)records1), FETCH_ISOLATION_HWM);
        Assertions.assertEquals((long)3L, (long)sharePartition.nextFetchOffset());
        sharePartition.acknowledge(memberId1, List.of(new ShareAcknowledgementBatch(0L, 2L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(memberId2, 500, Integer.MAX_VALUE, 3L, this.fetchPartitionData((Records)this.memoryRecords(2, 3L)), FETCH_ISOLATION_HWM);
        Assertions.assertEquals((long)0L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire(memberId1, 500, Integer.MAX_VALUE, 0L, this.fetchPartitionData((Records)records1), FETCH_ISOLATION_HWM);
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        sharePartition.acknowledge(memberId2, List.of(new ShareAcknowledgementBatch(3L, 4L, List.of(Byte.valueOf((byte)2)))));
        Assertions.assertEquals((long)3L, (long)sharePartition.nextFetchOffset());
    }

    @Test
    public void testNumberOfWriteCallsOnUpdates() {
        SharePartition sharePartition = (SharePartition)Mockito.spy((Object)SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 2L), 5);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(2L, 6L, List.of(Byte.valueOf((byte)1)))));
        ((SharePartition)Mockito.verify((Object)sharePartition, (VerificationMode)Mockito.times((int)1))).writeShareGroupState(ArgumentMatchers.anyList());
        sharePartition.releaseAcquiredRecords(MEMBER_ID);
        ((SharePartition)Mockito.verify((Object)sharePartition, (VerificationMode)Mockito.times((int)1))).writeShareGroupState(ArgumentMatchers.anyList());
    }

    @Test
    public void testReacquireSubsetWithAnotherMember() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        MemoryRecords records1 = this.memoryRecords(5, 5L);
        this.fetchAcquiredRecords(sharePartition, (Records)records1, 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(12, 10L), 12);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 11L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(12L, 13L, List.of(Byte.valueOf((byte)0))), new ShareAcknowledgementBatch(14L, 15L, List.of(Byte.valueOf((byte)2))), new ShareAcknowledgementBatch(17L, 20L, List.of(Byte.valueOf((byte)2)))));
        sharePartition.acquire("member-2", 500, Integer.MAX_VALUE, 5L, this.fetchPartitionData((Records)records1), FETCH_ISOLATION_HWM);
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        sharePartition.acquire("member-2", 500, Integer.MAX_VALUE, 10L, this.fetchPartitionData((Records)this.memoryRecords(7, 10L)), FETCH_ISOLATION_HWM);
        Assertions.assertEquals((long)17L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)"member-2", (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchMemberId());
        Assertions.assertEquals((int)2, (int)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchDeliveryCount());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 2, "member-2"));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 2, "member-2"));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 2, "member-2"));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 2, "member-2"));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(20L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(21L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
    }

    @Test
    public void testMaybeInitializeWhenReadStateRpcReturnsZeroAvailableRecords() {
        ArrayList<PersisterStateBatch> stateBatches = new ArrayList<PersisterStateBatch>();
        stateBatches.add(new PersisterStateBatch(233L, 233L, SharePartition.RecordState.ARCHIVED.id, 1));
        for (int i = 0; i < 500; ++i) {
            stateBatches.add(new PersisterStateBatch(234L + (long)i, 234L + (long)i, SharePartition.RecordState.ACKNOWLEDGED.id, 1));
        }
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)233L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), stateBatches)))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        CompletableFuture result = sharePartition.maybeInitialize();
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertTrue((boolean)sharePartition.cachedState().isEmpty());
        Assertions.assertEquals((long)734L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)734L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)734L, (long)sharePartition.endOffset());
    }

    @Test
    public void testAcquireWithWriteShareGroupStateDelay() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        this.mockPersisterReadStateMethod(persister);
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).withState(SharePartition.SharePartitionState.ACTIVE).build();
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        CompletableFuture<WriteShareGroupStateResult> future = new CompletableFuture<WriteShareGroupStateResult>();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(future);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 0L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        ArrayList<ShareAcknowledgementBatch> acknowledgementBatches = new ArrayList<ShareAcknowledgementBatch>();
        acknowledgementBatches.add(new ShareAcknowledgementBatch(2L, 3L, List.of(Byte.valueOf((byte)2))));
        acknowledgementBatches.add(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)2))));
        sharePartition.acknowledge(MEMBER_ID, acknowledgementBatches);
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 0L), 5);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
        future.complete(writeShareGroupStateResult);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 0L), 7);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(0L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(1L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(2L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(3L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(0L)).offsetState().get(4L)).state());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    @Test
    public void testFindLastOffsetAcknowledgedWhenGapAtBeginning() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)3, (long)11L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of(new PersisterStateBatch(21L, 30L, SharePartition.RecordState.ACKNOWLEDGED.id, 2), new PersisterStateBatch(31L, 40L, SharePartition.RecordState.ARCHIVED.id, 1)))))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
        SharePartition sharePartition = SharePartitionBuilder.builder().withPersister(persister).build();
        sharePartition.maybeInitialize();
        SharePartition.InitialReadGapOffset initialReadGapOffset = sharePartition.initialReadGapOffset();
        Assertions.assertNotNull((Object)initialReadGapOffset);
        Assertions.assertEquals((long)11L, (long)initialReadGapOffset.gapStartOffset());
        Assertions.assertEquals((long)40L, (long)initialReadGapOffset.endOffset());
        long lastOffsetAcknowledged = sharePartition.findLastOffsetAcknowledged();
        Assertions.assertEquals((long)-1L, (long)lastOffsetAcknowledged);
    }

    @Test
    public void testCacheUpdateWhenBatchHasOngoingTransition() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).withPersister(persister).build();
        this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, Integer.MAX_VALUE, 21L, this.fetchPartitionData((Records)this.memoryRecords(10, 21L)), FETCH_ISOLATION_HWM), 10);
        Assertions.assertFalse((boolean)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).batchHasOngoingStateTransition());
        CompletableFuture<WriteShareGroupStateResult> future = new CompletableFuture<WriteShareGroupStateResult>();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(future);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(21L, 30L, List.of(Byte.valueOf(AcknowledgeType.ACCEPT.id)))));
        Assertions.assertEquals((long)21L, (long)sharePartition.startOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertTrue((boolean)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).batchHasOngoingStateTransition());
        Assertions.assertFalse((boolean)sharePartition.canMoveStartOffset());
        Assertions.assertEquals((long)-1L, (long)sharePartition.findLastOffsetAcknowledged());
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        future.complete(writeShareGroupStateResult);
        Assertions.assertEquals((long)31L, (long)sharePartition.startOffset());
        Assertions.assertTrue((boolean)sharePartition.cachedState().isEmpty());
    }

    @Test
    public void testCacheUpdateWhenOffsetStateHasOngoingTransition() {
        Persister persister = (Persister)Mockito.mock(Persister.class);
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).withPersister(persister).build();
        this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 500, Integer.MAX_VALUE, 21L, this.fetchPartitionData((Records)this.memoryRecords(10, 21L)), FETCH_ISOLATION_HWM), 10);
        Assertions.assertFalse((boolean)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).batchHasOngoingStateTransition());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).offsetState());
        CompletableFuture<WriteShareGroupStateResult> future = new CompletableFuture<WriteShareGroupStateResult>();
        Mockito.when((Object)persister.writeState((WriteShareGroupStateParameters)Mockito.any())).thenReturn(future);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(21L, 23L, List.of(Byte.valueOf(AcknowledgeType.ACCEPT.id)))));
        Assertions.assertEquals((long)21L, (long)sharePartition.startOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).offsetState());
        Assertions.assertTrue((boolean)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).offsetState().get(21L)).hasOngoingStateTransition());
        Assertions.assertTrue((boolean)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).offsetState().get(22L)).hasOngoingStateTransition());
        Assertions.assertTrue((boolean)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).offsetState().get(23L)).hasOngoingStateTransition());
        Assertions.assertFalse((boolean)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(21L)).offsetState().get(24L)).hasOngoingStateTransition());
        Assertions.assertFalse((boolean)sharePartition.canMoveStartOffset());
        Assertions.assertEquals((long)-1L, (long)sharePartition.findLastOffsetAcknowledged());
        WriteShareGroupStateResult writeShareGroupStateResult = (WriteShareGroupStateResult)Mockito.mock(WriteShareGroupStateResult.class);
        Mockito.when((Object)writeShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionErrorData((int)0, (short)Errors.NONE.code(), (String)Errors.NONE.message())))));
        future.complete(writeShareGroupStateResult);
        Assertions.assertEquals((long)24L, (long)sharePartition.startOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(21L));
    }

    @Test
    public void testAcquireAndAcknowledgeWithRecordsAheadOfRecordBatchStartOffset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        try (MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)5L, (int)2);){
            this.memoryRecords(2, 10L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
            this.memoryRecords(2, 15L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
        }
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.fetchAcquiredRecords(sharePartition, (Records)records, 12);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 9L, List.of(Byte.valueOf((byte)0))), new ShareAcknowledgementBatch(10L, 11L, List.of(Byte.valueOf(AcknowledgeType.ACCEPT.id))), new ShareAcknowledgementBatch(12L, 14L, List.of(Byte.valueOf(AcknowledgeType.REJECT.id))), new ShareAcknowledgementBatch(15L, 16L, List.of(Byte.valueOf(AcknowledgeType.RELEASE.id)))));
        Assertions.assertEquals((long)15L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertNotNull(sharePartition.cachedState().get(5L));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(5L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(6L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(7L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(8L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(9L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ACKNOWLEDGED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.AVAILABLE, 1, SharePartition.EMPTY_MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(5L)).offsetState());
    }

    @Test
    public void testAcquireWhenBatchesAreRemovedFromBetweenInSubsequentFetchData() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)0L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)5L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)20L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.fetchAcquiredRecords(sharePartition, (Records)records, 35);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 40L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 45L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 50L), 15);
        sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertEquals((int)4, (int)sharePartition.cachedState().size());
        buffer = ByteBuffer.allocate(4096);
        try (MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)2);){
            this.memoryRecords(2, 1L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
        }
        builder = MemoryRecords.builder((ByteBuffer)buffer, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)20L, (int)2);
        try {
            this.memoryRecords(2, 20L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
            this.memoryRecords(2, 33L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
        }
        finally {
            if (builder != null) {
                builder.close();
            }
        }
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)40L).close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)50L, (int)2);
        try {
            this.memoryRecords(5, 51L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
            this.memoryRecords(2, 58L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
            this.memoryRecords(1, 63L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
        }
        finally {
            if (builder != null) {
                builder.close();
            }
        }
        buffer.flip();
        records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.fetchAcquiredRecords(sharePartition, (Records)records, 59);
        Assertions.assertEquals((long)64L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)4, (int)sharePartition.cachedState().size());
        sharePartition.cachedState().forEach((offset, inFlightState) -> {
            if (offset < 50L) {
                Assertions.assertNotNull((Object)inFlightState.batchState());
                Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)inFlightState.batchState());
            } else {
                Assertions.assertNotNull((Object)inFlightState.offsetState());
                inFlightState.offsetState().forEach((recordOffset, offsetState) -> {
                    SharePartition.RecordState recordState = recordOffset < 64L ? SharePartition.RecordState.ACQUIRED : SharePartition.RecordState.AVAILABLE;
                    Assertions.assertEquals((Object)recordState, (Object)offsetState.state(), (String)("Incorrect state for offset: " + recordOffset));
                });
            }
        });
    }

    @Test
    public void testAcquireWhenBatchesRemovedForFetchOffset() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 0L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 10L), 15);
        sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertEquals((int)3, (int)sharePartition.cachedState().size());
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        try (MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)5L, (int)2);){
            this.memoryRecords(4, 6L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
        }
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.fetchAcquiredRecords(sharePartition, (Records)records, 0L, 0L, 5);
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        sharePartition.cachedState().forEach((offset, inFlightState) -> {
            Assertions.assertNotNull((Object)inFlightState.batchState());
            Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)inFlightState.batchState());
        });
    }

    @Test
    public void testAcquireWhenBatchesRemovedForFetchOffsetWithinBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(5, 5L), 5);
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 10L), 15);
        sharePartition.acknowledge(MEMBER_ID, List.of(new ShareAcknowledgementBatch(5L, 7L, List.of(Byte.valueOf(AcknowledgeType.ACCEPT.id))))).join();
        sharePartition.releaseAcquiredRecords(MEMBER_ID).join();
        Assertions.assertEquals((int)2, (int)sharePartition.cachedState().size());
        this.fetchAcquiredRecords(sharePartition, (Records)this.memoryRecords(15, 10L), 8L, 0L, 15);
        Assertions.assertEquals((long)25L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)8L, (long)sharePartition.startOffset());
        sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertEquals((long)10L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        Assertions.assertEquals((Object)SharePartition.RecordState.AVAILABLE, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).batchState());
    }

    @Test
    public void testAcquireWhenBatchesRemovedForFetchOffsetForSameCachedBatch() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)0L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)5L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)20L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.fetchAcquiredRecords(sharePartition, (Records)records, 35);
        sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        buffer = ByteBuffer.allocate(4096);
        try (MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)5L, (int)2);){
            this.memoryRecords(4, 6L).records().forEach(arg_0 -> ((MemoryRecordsBuilder)builder).append(arg_0));
        }
        buffer.flip();
        records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        this.fetchAcquiredRecords(sharePartition, (Records)records, 0L, 0L, 5);
        Assertions.assertEquals((long)10L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((long)0L, (long)sharePartition.startOffset());
        sharePartition.releaseAcquiredRecords(MEMBER_ID);
        Assertions.assertEquals((long)5L, (long)sharePartition.startOffset());
        Assertions.assertEquals((long)5L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)1, (int)sharePartition.cachedState().size());
        sharePartition.cachedState().forEach((offset, inFlightState) -> {
            Assertions.assertNotNull((Object)inFlightState.offsetState());
            inFlightState.offsetState().forEach((recordOffset, offsetState) -> {
                SharePartition.RecordState recordState = recordOffset < 5L ? SharePartition.RecordState.ARCHIVED : SharePartition.RecordState.AVAILABLE;
                Assertions.assertEquals((Object)recordState, (Object)offsetState.state());
            });
        });
    }

    private String assertionFailedMessage(SharePartition sharePartition, Map<Long, List<Long>> offsets) {
        StringBuilder errorMessage = new StringBuilder(ACQUISITION_LOCK_NEVER_GOT_RELEASED + String.format(" timer size: %d, next fetch offset: %d\n", sharePartition.timer().size(), sharePartition.nextFetchOffset()));
        for (Map.Entry<Long, List<Long>> entry : offsets.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                errorMessage.append(String.format("batch start offset: %d\n", entry.getKey()));
                for (Long offset : entry.getValue()) {
                    errorMessage.append(String.format("\toffset: %d, offset state: %s, offset acquisition lock timeout task present: %b\n", offset, ((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(entry.getKey())).offsetState().get(offset)).state().id(), ((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(entry.getKey())).offsetState().get(offset)).acquisitionLockTimeoutTask() != null));
                }
                continue;
            }
            errorMessage.append(String.format("batch start offset: %d, batch state: %s, batch acquisition lock timeout task present: %b\n", entry.getKey(), ((SharePartition.InFlightBatch)sharePartition.cachedState().get(entry.getKey())).batchState().id(), ((SharePartition.InFlightBatch)sharePartition.cachedState().get(entry.getKey())).batchAcquisitionLockTimeoutTask() != null));
        }
        return errorMessage.toString();
    }

    @Test
    public void testFilterRecordBatchesFromAcquiredRecords() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecords1 = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(1L).setLastOffset(5L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(10L).setLastOffset(15L).setDeliveryCount((short)2), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(20L).setLastOffset(25L).setDeliveryCount((short)1));
        List<RecordBatch> recordBatches1 = List.of((RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)3, (long)2L).build().batches().iterator().next(), (RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)3, (long)12L).build().batches().iterator().next());
        Assertions.assertEquals(List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(1L).setLastOffset(1L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(5L).setLastOffset(5L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(10L).setLastOffset(11L).setDeliveryCount((short)2), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(15L).setLastOffset(15L).setDeliveryCount((short)2), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(20L).setLastOffset(25L).setDeliveryCount((short)1)), (Object)sharePartition.filterRecordBatchesFromAcquiredRecords(acquiredRecords1, recordBatches1));
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecords2 = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(1L).setLastOffset(4L).setDeliveryCount((short)3), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(5L).setLastOffset(8L).setDeliveryCount((short)3), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(9L).setLastOffset(30L).setDeliveryCount((short)2), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(31L).setLastOffset(40L).setDeliveryCount((short)3));
        List<RecordBatch> recordBatches2 = List.of((RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)21, (long)5L).build().batches().iterator().next(), (RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)5, (long)31L).build().batches().iterator().next());
        Assertions.assertEquals(List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(1L).setLastOffset(4L).setDeliveryCount((short)3), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(26L).setLastOffset(30L).setDeliveryCount((short)2), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(36L).setLastOffset(40L).setDeliveryCount((short)3)), (Object)sharePartition.filterRecordBatchesFromAcquiredRecords(acquiredRecords2, recordBatches2));
        Assertions.assertEquals(acquiredRecords2, (Object)sharePartition.filterRecordBatchesFromAcquiredRecords(acquiredRecords2, List.of()));
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecords3 = List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(19L).setDeliveryCount((short)1));
        List<RecordBatch> recordBatches3 = List.of((RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)1, (long)8L).build().batches().iterator().next(), (RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)1, (long)18L).build().batches().iterator().next());
        Assertions.assertEquals(List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset(7L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(9L).setLastOffset(17L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(19L).setLastOffset(19L).setDeliveryCount((short)1)), (Object)sharePartition.filterRecordBatchesFromAcquiredRecords(acquiredRecords3, recordBatches3));
    }

    @Test
    public void testAcquireWithReadCommittedIsolationLevel() {
        SharePartition sharePartition = (SharePartition)Mockito.spy((Object)SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build());
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)10L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)15L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)15, (long)20L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)8, (long)50L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)10, (long)58L).close();
        ShareFetchTestUtils.memoryRecordsBuilder((ByteBuffer)buffer, (int)5, (long)70L).close();
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        FetchPartitionData fetchPartitionData = this.fetchPartitionData((Records)records, this.newAbortedTransactions());
        Mockito.when((Object)sharePartition.fetchAbortedTransactionRecordBatches(fetchPartitionData.records.batches(), (List)fetchPartitionData.abortedTransactions.get())).thenReturn(List.of((RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)5, (long)10L).build().batches().iterator().next(), (RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)10, (long)58L).build().batches().iterator().next(), (RecordBatch)ShareFetchTestUtils.memoryRecordsBuilder((int)5, (long)70L).build().batches().iterator().next()));
        List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = this.fetchAcquiredRecords(sharePartition.acquire(MEMBER_ID, 10, 100, 0L, fetchPartitionData, FetchIsolation.TXN_COMMITTED), 45);
        Assertions.assertEquals(List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(15L).setLastOffset(19L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(20L).setLastOffset(49L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(50L).setLastOffset(57L).setDeliveryCount((short)1), new ShareFetchResponseData.AcquiredRecords().setFirstOffset(68L).setLastOffset(69L).setDeliveryCount((short)1)), acquiredRecordsList);
        Assertions.assertEquals((long)75L, (long)sharePartition.nextFetchOffset());
        Assertions.assertEquals((int)4, (int)sharePartition.cachedState().size());
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(10L));
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(20L));
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(50L));
        Assertions.assertTrue((boolean)sharePartition.cachedState().containsKey(70L));
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState());
        Assertions.assertEquals((long)19L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).lastOffset());
        Assertions.assertEquals((long)49L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).lastOffset());
        Assertions.assertEquals((long)69L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).lastOffset());
        Assertions.assertEquals((long)74L, (long)((SharePartition.InFlightBatch)sharePartition.cachedState().get(70L)).lastOffset());
        Assertions.assertEquals((Object)SharePartition.RecordState.ACQUIRED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchState());
        Assertions.assertEquals((Object)SharePartition.RecordState.ARCHIVED, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(70L)).batchState());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchMemberId());
        Assertions.assertEquals((Object)SharePartition.EMPTY_MEMBER_ID, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(70L)).batchMemberId());
        Assertions.assertNotNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(20L)).batchAcquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(70L)).batchAcquisitionLockTimeoutTask());
        HashMap<Long, SharePartition.InFlightState> expectedOffsetStateMap = new HashMap<Long, SharePartition.InFlightState>();
        expectedOffsetStateMap.put(10L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(11L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(12L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(13L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(14L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(15L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(16L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(17L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(18L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(19L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(10L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(11L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(12L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(13L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(14L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(15L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(16L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(17L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(18L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(10L)).offsetState().get(19L)).acquisitionLockTimeoutTask());
        expectedOffsetStateMap = new HashMap();
        expectedOffsetStateMap.put(50L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(51L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(52L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(53L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(54L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(55L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(56L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(57L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(58L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(59L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(60L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(61L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(62L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(63L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(64L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(65L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(66L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(67L, new SharePartition.InFlightState(SharePartition.RecordState.ARCHIVED, 1, SharePartition.EMPTY_MEMBER_ID));
        expectedOffsetStateMap.put(68L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        expectedOffsetStateMap.put(69L, new SharePartition.InFlightState(SharePartition.RecordState.ACQUIRED, 1, MEMBER_ID));
        Assertions.assertEquals(expectedOffsetStateMap, (Object)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(50L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(51L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(52L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(53L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(54L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(55L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(56L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(57L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(58L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(59L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(60L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(61L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(62L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(63L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(64L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(65L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(66L)).acquisitionLockTimeoutTask());
        Assertions.assertNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(67L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(68L)).acquisitionLockTimeoutTask());
        Assertions.assertNotNull((Object)((SharePartition.InFlightState)((SharePartition.InFlightBatch)sharePartition.cachedState().get(50L)).offsetState().get(69L)).acquisitionLockTimeoutTask());
    }

    @Test
    public void testContainsAbortMarker() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        RecordBatch recordBatch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)recordBatch.isControlBatch()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)sharePartition.containsAbortMarker(recordBatch));
        recordBatch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Iterator batchIterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)batchIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)recordBatch.iterator()).thenReturn((Object)batchIterator);
        Mockito.when((Object)recordBatch.isControlBatch()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)sharePartition.containsAbortMarker(recordBatch));
        recordBatch = (RecordBatch)Mockito.mock(RecordBatch.class);
        batchIterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)batchIterator.hasNext()).thenReturn((Object)true);
        DefaultRecord record = (DefaultRecord)Mockito.mock(DefaultRecord.class);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        buffer.putShort((short)5);
        buffer.putShort(ControlRecordType.ABORT.type());
        buffer.putInt(23432);
        buffer.flip();
        Mockito.when((Object)record.key()).thenReturn((Object)buffer);
        Mockito.when(batchIterator.next()).thenReturn((Object)record);
        Mockito.when((Object)recordBatch.iterator()).thenReturn((Object)batchIterator);
        Mockito.when((Object)recordBatch.isControlBatch()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)sharePartition.containsAbortMarker(recordBatch));
        recordBatch = (RecordBatch)Mockito.mock(RecordBatch.class);
        batchIterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)batchIterator.hasNext()).thenReturn((Object)true);
        record = (DefaultRecord)Mockito.mock(DefaultRecord.class);
        buffer = ByteBuffer.allocate(4096);
        buffer.putShort((short)5);
        buffer.putShort(ControlRecordType.COMMIT.type());
        buffer.putInt(23432);
        buffer.flip();
        Mockito.when((Object)record.key()).thenReturn((Object)buffer);
        Mockito.when(batchIterator.next()).thenReturn((Object)record);
        Mockito.when((Object)recordBatch.iterator()).thenReturn((Object)batchIterator);
        Mockito.when((Object)recordBatch.isControlBatch()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)sharePartition.containsAbortMarker(recordBatch));
    }

    @Test
    public void testFetchAbortedTransactionRecordBatchesForOnlyAbortedTransactions() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 10, 1L, 0L);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<FetchResponseData.AbortedTransaction> abortedTransactions = List.of(new FetchResponseData.AbortedTransaction().setFirstOffset(0L).setProducerId(1L));
        List actual = sharePartition.fetchAbortedTransactionRecordBatches(records.batches(), abortedTransactions);
        Assertions.assertEquals((int)1, (int)actual.size());
        Assertions.assertEquals((long)0L, (long)((RecordBatch)actual.get(0)).baseOffset());
        Assertions.assertEquals((long)9L, (long)((RecordBatch)actual.get(0)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(0)).producerId());
        buffer = ByteBuffer.allocate(1024);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 1, 1L, 0L);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 1, 1L, 2L);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 1, 1L, 4L);
        buffer.flip();
        records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        abortedTransactions = List.of(new FetchResponseData.AbortedTransaction().setFirstOffset(0L).setProducerId(1L), new FetchResponseData.AbortedTransaction().setFirstOffset(2L).setProducerId(1L), new FetchResponseData.AbortedTransaction().setFirstOffset(4L).setProducerId(1L));
        actual = sharePartition.fetchAbortedTransactionRecordBatches(records.batches(), abortedTransactions);
        Assertions.assertEquals((int)3, (int)actual.size());
        Assertions.assertEquals((long)0L, (long)((RecordBatch)actual.get(0)).baseOffset());
        Assertions.assertEquals((long)0L, (long)((RecordBatch)actual.get(0)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(0)).producerId());
        Assertions.assertEquals((long)2L, (long)((RecordBatch)actual.get(1)).baseOffset());
        Assertions.assertEquals((long)2L, (long)((RecordBatch)actual.get(1)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(1)).producerId());
        Assertions.assertEquals((long)4L, (long)((RecordBatch)actual.get(2)).baseOffset());
        Assertions.assertEquals((long)4L, (long)((RecordBatch)actual.get(2)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(2)).producerId());
        buffer = ByteBuffer.allocate(1024);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 10, 2L, 0L);
        buffer.flip();
        records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        abortedTransactions = List.of(new FetchResponseData.AbortedTransaction().setFirstOffset(0L).setProducerId(1L));
        actual = sharePartition.fetchAbortedTransactionRecordBatches(records.batches(), abortedTransactions);
        Assertions.assertEquals((int)0, (int)actual.size());
    }

    @Test
    public void testFetchAbortedTransactionRecordBatchesForAbortedAndCommittedTransactions() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 2, 1L, 0L);
        this.newTransactionalRecords(buffer, ControlRecordType.COMMIT, 2, 2L, 3L);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 2, 2L, 6L);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 2, 1L, 9L);
        this.newTransactionalRecords(buffer, ControlRecordType.COMMIT, 2, 1L, 12L);
        this.newTransactionalRecords(buffer, ControlRecordType.ABORT, 2, 1L, 15L);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        List<FetchResponseData.AbortedTransaction> abortedTransactions = List.of(new FetchResponseData.AbortedTransaction().setFirstOffset(0L).setProducerId(1L), new FetchResponseData.AbortedTransaction().setFirstOffset(6L).setProducerId(1L), new FetchResponseData.AbortedTransaction().setFirstOffset(9L).setProducerId(1L), new FetchResponseData.AbortedTransaction().setFirstOffset(15L).setProducerId(1L));
        List actual = sharePartition.fetchAbortedTransactionRecordBatches(records.batches(), abortedTransactions);
        Assertions.assertEquals((int)3, (int)actual.size());
        Assertions.assertEquals((long)0L, (long)((RecordBatch)actual.get(0)).baseOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(0)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(0)).producerId());
        Assertions.assertEquals((long)9L, (long)((RecordBatch)actual.get(1)).baseOffset());
        Assertions.assertEquals((long)10L, (long)((RecordBatch)actual.get(1)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(1)).producerId());
        Assertions.assertEquals((long)15L, (long)((RecordBatch)actual.get(2)).baseOffset());
        Assertions.assertEquals((long)16L, (long)((RecordBatch)actual.get(2)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(2)).producerId());
        abortedTransactions = List.of(new FetchResponseData.AbortedTransaction().setFirstOffset(0L).setProducerId(1L), new FetchResponseData.AbortedTransaction().setFirstOffset(6L).setProducerId(2L), new FetchResponseData.AbortedTransaction().setFirstOffset(9L).setProducerId(1L), new FetchResponseData.AbortedTransaction().setFirstOffset(15L).setProducerId(1L));
        actual = sharePartition.fetchAbortedTransactionRecordBatches(records.batches(), abortedTransactions);
        Assertions.assertEquals((int)4, (int)actual.size());
        Assertions.assertEquals((long)0L, (long)((RecordBatch)actual.get(0)).baseOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(0)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(0)).producerId());
        Assertions.assertEquals((long)6L, (long)((RecordBatch)actual.get(1)).baseOffset());
        Assertions.assertEquals((long)7L, (long)((RecordBatch)actual.get(1)).lastOffset());
        Assertions.assertEquals((long)2L, (long)((RecordBatch)actual.get(1)).producerId());
        Assertions.assertEquals((long)9L, (long)((RecordBatch)actual.get(2)).baseOffset());
        Assertions.assertEquals((long)10L, (long)((RecordBatch)actual.get(2)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(2)).producerId());
        Assertions.assertEquals((long)15L, (long)((RecordBatch)actual.get(3)).baseOffset());
        Assertions.assertEquals((long)16L, (long)((RecordBatch)actual.get(3)).lastOffset());
        Assertions.assertEquals((long)1L, (long)((RecordBatch)actual.get(3)).producerId());
    }

    @Test
    public void testFetchLockReleasedByDifferentId() {
        SharePartition sharePartition = SharePartitionBuilder.builder().withState(SharePartition.SharePartitionState.ACTIVE).build();
        Uuid fetchId1 = Uuid.randomUuid();
        Uuid fetchId2 = Uuid.randomUuid();
        Assertions.assertNull((Object)sharePartition.fetchLock());
        Assertions.assertTrue((boolean)sharePartition.maybeAcquireFetchLock(fetchId1));
        sharePartition.releaseFetchLock(fetchId2);
        Assertions.assertNull((Object)sharePartition.fetchLock());
    }

    private void newTransactionalRecords(ByteBuffer buffer, ControlRecordType controlRecordType, int numRecords, long producerId, long baseOffset) {
        try (MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)MOCK_TIME.milliseconds(), (long)producerId, (short)0, (int)0, (boolean)true, (int)-1);){
            for (int i = 0; i < numRecords; ++i) {
                builder.append(new SimpleRecord(MOCK_TIME.milliseconds(), "key".getBytes(), "value".getBytes()));
            }
            builder.build();
        }
        this.writeTransactionMarker(buffer, controlRecordType, (int)baseOffset + numRecords, producerId);
    }

    private void writeTransactionMarker(ByteBuffer buffer, ControlRecordType controlRecordType, int offset, long producerId) {
        MemoryRecords.writeEndTransactionalMarker((ByteBuffer)buffer, (long)offset, (long)MOCK_TIME.milliseconds(), (int)0, (long)producerId, (short)0, (EndTransactionMarker)new EndTransactionMarker(controlRecordType, 0));
    }

    private List<FetchResponseData.AbortedTransaction> newAbortedTransactions() {
        FetchResponseData.AbortedTransaction abortedTransaction = new FetchResponseData.AbortedTransaction();
        abortedTransaction.setFirstOffset(0L);
        abortedTransaction.setProducerId(1000L);
        return List.of(abortedTransaction);
    }

    private FetchPartitionData fetchPartitionData(Records records) {
        return this.fetchPartitionData(records, 0L);
    }

    private FetchPartitionData fetchPartitionData(Records records, List<FetchResponseData.AbortedTransaction> abortedTransactions) {
        return this.fetchPartitionData(records, 0L, abortedTransactions);
    }

    private FetchPartitionData fetchPartitionData(Records records, long logStartOffset) {
        return new FetchPartitionData(Errors.NONE, 5L, logStartOffset, records, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
    }

    private FetchPartitionData fetchPartitionData(Records records, long logStartOffset, List<FetchResponseData.AbortedTransaction> abortedTransactions) {
        return new FetchPartitionData(Errors.NONE, 5L, logStartOffset, records, Optional.empty(), OptionalLong.empty(), Optional.of(abortedTransactions), OptionalInt.empty(), false);
    }

    private List<ShareFetchResponseData.AcquiredRecords> fetchAcquiredRecords(SharePartition sharePartition, Records records, long logStartOffset, int expectedOffsetCount) {
        return this.fetchAcquiredRecords(sharePartition, records, ((RecordBatch)records.batches().iterator().next()).baseOffset(), logStartOffset, expectedOffsetCount);
    }

    private List<ShareFetchResponseData.AcquiredRecords> fetchAcquiredRecords(SharePartition sharePartition, Records records, long fetchOffset, long logStartOffset, int expectedOffsetCount) {
        ShareAcquiredRecords shareAcquiredRecords = sharePartition.acquire(MEMBER_ID, 500, Integer.MAX_VALUE, fetchOffset, this.fetchPartitionData(records, logStartOffset), FETCH_ISOLATION_HWM);
        return this.fetchAcquiredRecords(shareAcquiredRecords, expectedOffsetCount);
    }

    private List<ShareFetchResponseData.AcquiredRecords> fetchAcquiredRecords(SharePartition sharePartition, Records records, int expectedOffsetCount) {
        ShareAcquiredRecords shareAcquiredRecords = sharePartition.acquire(MEMBER_ID, 500, Integer.MAX_VALUE, ((RecordBatch)records.batches().iterator().next()).baseOffset(), this.fetchPartitionData(records), FETCH_ISOLATION_HWM);
        return this.fetchAcquiredRecords(shareAcquiredRecords, expectedOffsetCount);
    }

    private List<ShareFetchResponseData.AcquiredRecords> fetchAcquiredRecords(ShareAcquiredRecords shareAcquiredRecords, int expectedOffsetCount) {
        Assertions.assertNotNull((Object)shareAcquiredRecords);
        Assertions.assertEquals((int)expectedOffsetCount, (int)shareAcquiredRecords.count());
        return shareAcquiredRecords.acquiredRecords();
    }

    private MemoryRecords memoryRecords(int numOfRecords) {
        return this.memoryRecords(numOfRecords, 0L);
    }

    private MemoryRecords memoryRecords(int numOfRecords, long startOffset) {
        try (MemoryRecordsBuilder builder = ShareFetchTestUtils.memoryRecordsBuilder((int)numOfRecords, (long)startOffset);){
            MemoryRecords memoryRecords = builder.build();
            return memoryRecords;
        }
    }

    private List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecord(long baseOffset, long lastOffset, int deliveryCount) {
        return List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(baseOffset).setLastOffset(lastOffset).setDeliveryCount((short)deliveryCount));
    }

    private List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords(MemoryRecords memoryRecords, int deliveryCount) {
        ArrayList<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
        memoryRecords.batches().forEach(batch -> acquiredRecordsList.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(batch.baseOffset()).setLastOffset(batch.lastOffset()).setDeliveryCount((short)deliveryCount)));
        return acquiredRecordsList;
    }

    private List<ShareFetchResponseData.AcquiredRecords> expectedAcquiredRecords(long baseOffset, long lastOffset, int deliveryCount) {
        ArrayList<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
        for (long i = baseOffset; i <= lastOffset; ++i) {
            acquiredRecordsList.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(i).setLastOffset(i).setDeliveryCount((short)deliveryCount));
        }
        return acquiredRecordsList;
    }

    public void mockPersisterReadStateMethod(Persister persister) {
        ReadShareGroupStateResult readShareGroupStateResult = (ReadShareGroupStateResult)Mockito.mock(ReadShareGroupStateResult.class);
        Mockito.when((Object)readShareGroupStateResult.topicsData()).thenReturn(List.of(new TopicData(TOPIC_ID_PARTITION.topicId(), List.of(PartitionFactory.newPartitionAllData((int)0, (int)0, (long)0L, (short)Errors.NONE.code(), (String)Errors.NONE.message(), List.of())))));
        Mockito.when((Object)persister.readState((ReadShareGroupStateParameters)Mockito.any())).thenReturn(CompletableFuture.completedFuture(readShareGroupStateResult));
    }

    private static class SharePartitionBuilder {
        private int defaultAcquisitionLockTimeoutMs = 30000;
        private int maxDeliveryCount = 5;
        private int maxInflightMessages = 200;
        private Persister persister = new NoOpStatePersister();
        private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        private GroupConfigManager groupConfigManager = (GroupConfigManager)Mockito.mock(GroupConfigManager.class);
        private SharePartition.SharePartitionState state = SharePartition.SharePartitionState.EMPTY;
        private Time time = MOCK_TIME;
        private SharePartitionMetrics sharePartitionMetrics = (SharePartitionMetrics)Mockito.mock(SharePartitionMetrics.class);

        private SharePartitionBuilder() {
        }

        private SharePartitionBuilder withMaxInflightMessages(int maxInflightMessages) {
            this.maxInflightMessages = maxInflightMessages;
            return this;
        }

        private SharePartitionBuilder withPersister(Persister persister) {
            this.persister = persister;
            return this;
        }

        private SharePartitionBuilder withDefaultAcquisitionLockTimeoutMs(int acquisitionLockTimeoutMs) {
            this.defaultAcquisitionLockTimeoutMs = acquisitionLockTimeoutMs;
            return this;
        }

        private SharePartitionBuilder withMaxDeliveryCount(int maxDeliveryCount) {
            this.maxDeliveryCount = maxDeliveryCount;
            return this;
        }

        private SharePartitionBuilder withReplicaManager(ReplicaManager replicaManager) {
            this.replicaManager = replicaManager;
            return this;
        }

        private SharePartitionBuilder withGroupConfigManager(GroupConfigManager groupConfigManager) {
            this.groupConfigManager = groupConfigManager;
            return this;
        }

        private SharePartitionBuilder withState(SharePartition.SharePartitionState state) {
            this.state = state;
            return this;
        }

        private SharePartitionBuilder withTime(Time time) {
            this.time = time;
            return this;
        }

        private SharePartitionBuilder withSharePartitionMetrics(SharePartitionMetrics sharePartitionMetrics) {
            this.sharePartitionMetrics = sharePartitionMetrics;
            return this;
        }

        public static SharePartitionBuilder builder() {
            return new SharePartitionBuilder();
        }

        public SharePartition build() {
            return new SharePartition(SharePartitionTest.GROUP_ID, TOPIC_ID_PARTITION, 0, this.maxInflightMessages, this.maxDeliveryCount, this.defaultAcquisitionLockTimeoutMs, mockTimer, this.time, this.persister, this.replicaManager, this.groupConfigManager, this.state, (SharePartitionManager.SharePartitionListener)Mockito.mock(SharePartitionManager.SharePartitionListener.class), this.sharePartitionMetrics);
        }
    }
}

