/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0005\t-d\u0001B\u001c9\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015CQ\u0001\u0013\u0001\u0005\n%CqA\u0015\u0001C\u0002\u0013\u00051\u000b\u0003\u0004e\u0001\u0001\u0006I\u0001\u0016\u0005\u0006K\u0002!\tA\u001a\u0005\u0006k\u0002!\tA\u001a\u0005\u0006o\u0002!\tA\u001a\u0005\u0006s\u0002!\tA\u001a\u0005\u0006w\u0002!\tA\u001a\u0005\u0006{\u0002!\tA\u001a\u0005\u0006\u007f\u0002!\tA\u001a\u0005\n\u0003\u0007\u0001!\u0019!C\u0001\u0003\u000bAq!a\u0002\u0001A\u0003%!\nC\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0002\u0006!9\u00111\u0002\u0001!\u0002\u0013Q\u0005bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\n\u0003C\u0002\u0011\u0013!C\u0005\u0003GB\u0011\"!\u001f\u0001#\u0003%I!a\u001f\t\r\u0005}\u0004\u0001\"\u0001g\u0011\u0019\t\u0019\t\u0001C\u0001M\"1\u0011q\u0011\u0001\u0005\u0002\u0019Da!a#\u0001\t\u00031\u0007BBAH\u0001\u0011\u0005a\r\u0003\u0004\u0002\u0014\u0002!\tA\u001a\u0005\u0007\u0003/\u0003A\u0011\u00014\t\r\u0005m\u0005\u0001\"\u0001g\u0011\u0019\ty\n\u0001C\u0001M\"1\u00111\u0015\u0001\u0005\u0002\u0019Da!a*\u0001\t\u00031\u0007BBAV\u0001\u0011\u0005a\rC\u0004\u00020\u0002!\t!!-\t\r\u0005m\u0007\u0001\"\u0001g\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDq!a;\u0001\t\u0003\ti\u000f\u0003\u0004\u0003\u0004\u0001!\tA\u001a\u0005\u0007\u0005\u000f\u0001A\u0011\u00014\t\r\t-\u0001\u0001\"\u0001g\u0011\u0019\u0011y\u0001\u0001C\u0001M\"9!1\u0003\u0001\u0005\n\tU\u0001B\u0002B\u000f\u0001\u0011\u0005a\r\u0003\u0004\u0003\"\u0001!\tA\u001a\u0005\u0007\u0005K\u0001A\u0011\u00014\t\u000f\t%\u0002\u0001\"\u0003\u0003,!1!1\u0007\u0001\u0005\u0002\u0019DaAa\u000e\u0001\t\u00031\u0007B\u0002B\u001e\u0001\u0011\u0005a\r\u0003\u0004\u0003@\u0001!\tA\u001a\u0005\u0007\u0005\u0007\u0002A\u0011\u00014\t\r\t\u001d\u0003\u0001\"\u0001g\u0011\u0019\u0011Y\u0005\u0001C\u0001M\"1!q\n\u0001\u0005\u0002\u0019DaAa\u0015\u0001\t\u00031\u0007B\u0002B,\u0001\u0011\u0005a\r\u0003\u0004\u0003\\\u0001!\tA\u001a\u0002\u0010'R|'/Y4f)>|G\u000eV3ti*\u0011\u0011HO\u0001\u0006i>|Gn\u001d\u0006\u0002w\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001?!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0012\t\u0003\u000f\u0002i\u0011\u0001O\u0001\u0019]\u0016<8+\u001a7g\u001b\u0006t\u0017mZ3e!J|\u0007/\u001a:uS\u0016\u001cH#\u0001&\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015\u0001B;uS2T\u0011aT\u0001\u0005U\u00064\u0018-\u0003\u0002R\u0019\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u001fQ,7\u000f^5oO\u001a+\u0017\r^;sKN,\u0012\u0001\u0016\t\u0004\u0017V;\u0016B\u0001,M\u0005\u0011a\u0015n\u001d;\u0011\u0005a\u0013W\"A-\u000b\u0005i[\u0016AB2p[6|gN\u0003\u0002];\u000611/\u001a:wKJT!a\u000f0\u000b\u0005}\u0003\u0017AB1qC\u000eDWMC\u0001b\u0003\ry'oZ\u0005\u0003Gf\u0013qAR3biV\u0014X-\u0001\tuKN$\u0018N\\4GK\u0006$XO]3tA\u0005QB/Z:u\u0007>tg-[4U_2{w\rR5sK\u000e$xN]5fgR\tq\r\u0005\u0002@Q&\u0011\u0011\u000e\u0011\u0002\u0005+:LG\u000f\u000b\u0002\u0006WB\u0011An]\u0007\u0002[*\u0011an\\\u0001\u0004CBL'B\u00019r\u0003\u001dQW\u000f]5uKJT!A\u001d1\u0002\u000b),h.\u001b;\n\u0005Ql'\u0001\u0002+fgR\f\u0001\u0006^3ti\u000e{gNZ5h)>dun\u001a#je\u0016\u001cGo\u001c:jKN<\u0016\u000e\u001e5NKR\fGj\\4ESJD#AB6\u0002?Q,7\u000f^%oM>\u001cu.\\7b]\u0012|e.R7qif$\u0015N]3di>\u0014\u0018\u0010\u000b\u0002\bW\u0006\tC/Z:u\u0013:4wnQ8n[\u0006tGm\u00148NSN\u001c\u0018N\\4ESJ,7\r^8ss\"\u0012\u0001b[\u0001!i\u0016\u001cH/\u00138g_\u000e{W.\\1oI>sG)\u001b:fGR|'/_!t\r&dW\r\u000b\u0002\nW\u00069C/Z:u\u0013:4wnV5uQ6K7/\\1uG\",G\rT3hC\u000eL8*\u00194lC\u000e{gNZ5hQ\tQ1.A\u0011uKN$\u0018J\u001c4p/&$\b.T5t[\u0006$8\r[3e\u0017J\u000bg\r^\"p]\u001aLw\r\u000b\u0002\fW\u0006iB-\u001a4bk2$8\u000b^1uS\u000e\fVo\u001c:v[B\u0013x\u000e]3si&,7/F\u0001K\u0003y!WMZ1vYR\u001cF/\u0019;jGF+xN];n!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\u0010eK\u001a\fW\u000f\u001c;Es:\fW.[2Rk>\u0014X/\u001c)s_B,'\u000f^5fg\u0006yB-\u001a4bk2$H)\u001f8b[&\u001c\u0017+^8sk6\u0004&o\u001c9feRLWm\u001d\u0011\u0002!I,hNR8s[\u0006$8i\\7nC:$GCCA\t\u0003/\t9#a\u000b\u0002XA\u0019q(a\u0005\n\u0007\u0005U\u0001IA\u0002J]RDq!!\u0007\u0011\u0001\u0004\tY\"\u0001\u0004tiJ,\u0017-\u001c\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005(\u0002\u0005%|\u0017\u0002BA\u0013\u0003?\u0011QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004\u0002*A\u0001\rAS\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\"CA\u0017!A\u0005\t\u0019AA\u0018\u00039)\u0007\u0010\u001e:b\u0003J<W/\\3oiN\u0004b!!\r\u0002B\u0005\u001dc\u0002BA\u001a\u0003{qA!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sa\u0014A\u0002\u001fs_>$h(C\u0001B\u0013\r\ty\u0004Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019%!\u0012\u0003\u0007M+\u0017OC\u0002\u0002@\u0001\u0003B!!\u0013\u0002R9!\u00111JA'!\r\t)\u0004Q\u0005\u0004\u0003\u001f\u0002\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002T\u0005U#AB*ue&twMC\u0002\u0002P\u0001C\u0011\"!\u0017\u0011!\u0003\u0005\r!a\u0017\u0002\u001f%<gn\u001c:f\r>\u0014X.\u0019;uK\u0012\u00042aPA/\u0013\r\ty\u0006\u0011\u0002\b\u0005>|G.Z1o\u0003i\u0011XO\u001c$pe6\fGoQ8n[\u0006tG\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t)G\u000b\u0003\u00020\u0005\u001d4FAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M\u0004)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001e\u0002n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025I,hNR8s[\u0006$8i\\7nC:$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005u$\u0006BA.\u0003O\na\u0006^3ti\u001a{'/\\1u'V\u001c7-Z3eg&3\u0017\t\u001c7ESJ,7\r^8sS\u0016\u001c\u0018I]3Bm\u0006LG.\u00192mK\"\u00121c[\u00013i\u0016\u001cHOR8s[\u0006$8+^2dK\u0016$7/\u00134Bi2+\u0017m\u001d;P]\u0016$\u0015N]3di>\u0014\u00180S:Bm\u0006LG.\u00192mK\"\u0012Ac[\u0001\"i\u0016\u001cHOR8s[\u0006$h)Y5mg>s\u0017\t\u001c:fC\u0012Lhi\u001c:nCR$X\r\u001a\u0015\u0003+-\f1\u0003^3ti&;gn\u001c:f\r>\u0014X.\u0019;uK\u0012D#AF6\u0002[Q,7\u000f\u001e$pe6\fGOR1jYNLe-\u00117m\t&\u0014Xm\u0019;pe&,7/\u0011:f+:\fg/Y5mC\ndW\r\u000b\u0002\u0018W\u0006aB/Z:u\r>\u0014X.\u0019;XSRD'+\u001a7fCN,g+\u001a:tS>t\u0007F\u0001\rl\u0003\u0015\"Xm\u001d;G_Jl\u0017\r^,ji\"\u0014V\r\\3bg\u00164VM]:j_:\f5OR3biV\u0014X\r\u000b\u0002\u001aW\u0006aB/Z:u\r>\u0014X.\u0019;XSRD\u0017J\u001c<bY&$g)Z1ukJ,\u0007F\u0001\u000el\u0003\u0019\"Xm\u001d;G_Jl\u0017\r^,ji\"LeN^1mS\u0012\\%+\u00194u-\u0016\u00148/[8o\u0019\u00164X\r\u001c\u0015\u00037-\f1\u0006^3ti\u001a{'/\\1u/&$\bNU3mK\u0006\u001cXMV3sg&|g.\u00118e\u0017J\u000bg\r\u001e,feNLwN\u001c\u0015\u00039-\fA\u0007^3ti\u001a{'/\\1u/&$\bNU3mK\u0006\u001cXMV3sg&|g\u000eR3gCVdG/\u00118e%\u0016dW-Y:f-\u0016\u00148/[8oQ\ti2.A\u0015uKN$hi\u001c:nCR<\u0016\u000e\u001e5Ti\u0006tG-\u00197p]\u00164E.Y4P]\n\u0013xn[3s\r\u0006LGn\u001d\u0015\u0003=-\fA\u0004^3ti\u001a{'/\\1u/&$\bn\u0015;b]\u0012\fGn\u001c8f\r2\fw\rF\u0002h\u0003gCq!!. \u0001\u0004\tY&\u0001\ftKR\\%/\u00194u-\u0016\u00148/[8o\r\u0016\fG/\u001e:fQ\ry\u0012\u0011\u0018\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*\u0019\u0011qX8\u0002\rA\f'/Y7t\u0013\u0011\t\u0019-!0\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000fK\u0004 \u0003\u000f\f\u0019.!6\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017TA!!4\u0002>\u0006A\u0001O]8wS\u0012,'/\u0003\u0003\u0002R\u0006-'a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003/\fI.G\u0001\u00013\u0005\t\u0011A\u000f;fgR4uN]7bi^KG\u000f[*uC:$\u0017\r\\8oK\u001ac\u0017mZ!oI&s\u0017\u000e^5bY\u000e{g\u000e\u001e:pY2,'o\u001d$mC\u001e4\u0015-\u001b7tQ\t\u00013.\u0001\u0013uKN$hi\u001c:nCR<\u0016\u000e\u001e5J]&$\u0018.\u00197D_:$(o\u001c7mKJ\u001ch\t\\1h)\r9\u00171\u001d\u0005\b\u0003k\u000b\u0003\u0019AA.Q\r\t\u0013\u0011\u0018\u0015\bC\u0005\u001d\u00171[AuY\u0011\t9.!7\u0002\u000fR,7\u000f\u001e$pe6\fGoV5uQ>,Ho\u0015;bi&\u001c\u0017+^8sk64\u0015-\u001b7t/&$\bn\\;u\u0013:LG/[1m\u0007>tGO]8mY\u0016\u00148o\u00148D_:$(o\u001c7mKJ$2aZAx\u0011\u001d\t\tP\ta\u0001\u0003\u000f\nA\u0002\u001d:pG\u0016\u001c8OU8mKND3AIA]Q\u001d\u0011\u0013qYA|\u0003s\fqa\u001d;sS:<7\u000f\f\u0003\u0002|\u0006}\u0018EAA\u007f\u0003)\u0019wN\u001c;s_2dWM]\u0011\u0003\u0005\u0003\t\u0011C\u0019:pW\u0016\u0014HfY8oiJ|G\u000e\\3s\u0003Y\"Xm\u001d;G_Jl\u0017\r^,ji\"tu.\u00138ji&\fGnQ8oiJ|G\u000e\\3sgN+8mY3fIN|enQ8oiJ|G\u000e\\3sQ\t\u00193.\u0001\u001fuKN$hi\u001c:nCR<\u0016\u000e\u001e5O_&s\u0017\u000e^5bY\u000e{g\u000e\u001e:pY2,'o\u001d$mC\u001e\fe\u000eZ*uC:$\u0017\r\\8oK\u001ac\u0017m\u001a$bS2\u001c\bF\u0001\u0013l\u0003\u0011#Xm\u001d;G_Jl\u0017\r^,ji\"tu.\u00138ji&\fGnQ8oiJ|G\u000e\\3sg\u001ac\u0017mZ!oI&s\u0017\u000e^5bY\u000e{g\u000e\u001e:pY2,'o\u001d$mC\u001e4\u0015-\u001b7tQ\t)3.\u0001$uKN$hi\u001c:nCR<\u0016\u000e\u001e5pkR\u001cF/\u0019;jGF+xN];n'V\u001c7-Z3eg^KG\u000f[8vi&s\u0017\u000e^5bY\u000e{g\u000e\u001e:pY2,'o](o\u0005J|7.\u001a:)\u0005\u0019Z\u0017\u0001\u0007:v]Z+'o]5p]6\u000b\u0007\u000f]5oO\u000e{W.\\1oIR1\u0011\u0011\u0003B\f\u00053Aq!!\u0007(\u0001\u0004\tY\u0002C\u0004\u0003\u001c\u001d\u0002\r!a\u0012\u0002\u001dI,G.Z1tKZ+'o]5p]\u0006IC/Z:u-\u0016\u00148/[8o\u001b\u0006\u0004\b/\u001b8h/&$\bNV1mS\u0012\u0014V\r\\3bg\u00164VM]:j_:D#\u0001K6\u0002MQ,7\u000f\u001e,feNLwN\\'baBLgnZ,ji\"tuNU3mK\u0006\u001cXMV3sg&|g\u000e\u000b\u0002*W\u0006YC/Z:u-\u0016\u00148/[8o\u001b\u0006\u0004\b/\u001b8h/&$\b.\u00138wC2LGMU3mK\u0006\u001cXMV3sg&|g\u000e\u000b\u0002+W\u0006i\"/\u001e8GK\u0006$XO]3EKB,g\u000eZ3oG&,7oQ8n[\u0006tG\r\u0006\u0004\u0002\u0012\t5\"q\u0006\u0005\b\u00033Y\u0003\u0019AA\u000e\u0011\u001d\u0011\td\u000ba\u0001\u0003_\t\u0001BZ3biV\u0014Xm]\u0001\u001fi\u0016\u001cH\u000fV3ti&twMR3biV\u0014X\rR3qK:$WM\\2jKND#\u0001L6\u0002?Q,7\u000f^'vYRL\u0007\u000f\\3GK\u0006$XO]3EKB,g\u000eZ3oG&,7\u000f\u000b\u0002.W\u0006ID/Z:u\u0011\u0006tG\r\\3GK\u0006$XO]3EKB,g\u000eZ3oG&,7OR8s\r\u0016\fG/\u001e:f/&$\bNT8EKB,g\u000eZ3oG&,7\u000f\u000b\u0002/W\u0006qC/Z:u\u0011\u0006tG\r\\3GK\u0006$XO]3EKB,g\u000eZ3oG&,7OR8s+:\\gn\\<o\r\u0016\fG/\u001e:fQ\ty3.\u0001!uKN$\b*\u00198eY\u00164U-\u0019;ve\u0016$U\r]3oI\u0016t7-[3t\r>\u0014h)Z1ukJ,w+\u001b;i+:\\gn\\<o\r\u0016\fG/\u001e:f-\u0016\u00148/[8oQ\t\u00014.\u0001\u001buKN$\b*\u00198eY\u00164U-\u0019;ve\u0016$U\r]3oI\u0016t7-[3t\r>\u0014\u0018J\u001c<bY&$g+\u001a:tS>tgi\u001c:nCRD#!M6\u00023Q,7\u000f\u001e\"p_R\u001cHO]1q'\u000e\u0014\u0018-\u001c*fG>\u0014Hm\u001d\u0015\u0003e-\f\u0011\u0005^3tiN\u001b'/Y7SK\u000e|'\u000fZ:PY\u0012\u0014V\r\\3bg\u00164VM]:j_:D#aM6\u0002+Q,7\u000f\u001e)beN,g*Y7f\u0003:$G*\u001a<fY\"\u0012Ag[\u0001\"i\u0016\u001cH\u000fU1sg\u0016t\u0015-\\3B]\u0012dUM^3m/&$\bNT8FcV\fGn\u001d\u0015\u0003k-\f\u0011\u0005^3tiB\u000b'o]3OC6,\u0017I\u001c3MKZ,GnV5uQ:{g*^7cKJD#AN6)\u000f\u0001\u0011\tGa\u001a\u0003jA\u0019ANa\u0019\n\u0007\t\u0015TNA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003!\u0002")
public class StorageToolTest {
    private final java.util.List<Feature> testingFeatures = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])Feature.FEATURES).toList()).asJava();
    private final Properties defaultStaticQuorumProperties = new Properties();
    private final Properties defaultDynamicQuorumProperties;

    private Properties newSelfManagedProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo,/tmp/bar");
        properties.setProperty("process.roles", "controller");
        properties.setProperty("node.id", "2");
        properties.setProperty("controller.quorum.voters", "2@localhost:9092");
        properties.put("controller.listener.names", "CONTROLLER");
        properties.put("listeners", "CONTROLLER://:9092");
        return properties;
    }

    public java.util.List<Feature> testingFeatures() {
        return this.testingFeatures;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty("metadata.log.dir", "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found log directory:\n  " + tempDir.toString() + "\n\nFound problem:\n  " + tempDir.toString() + " is not formatted.\n\n"), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found problem:\n  " + tempDir.toString() + " does not exist\n\n"), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found problem:\n  " + tempFile.toString() + " is not a directory\n\n"), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", java.util.List.of("version=1", "node.id=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found log directory:\n  " + tempDir.toString() + "\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, node.id=1, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n"), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedKRaftConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", java.util.List.of("version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)("Found log directory:\n  " + tempDir.toString() + "\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n"), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    public Properties defaultStaticQuorumProperties() {
        return this.defaultStaticQuorumProperties;
    }

    public Properties defaultDynamicQuorumProperties() {
        return this.defaultDynamicQuorumProperties;
    }

    private int runFormatCommand(ByteArrayOutputStream stream, Properties properties, scala.collection.immutable.Seq<String> extraArguments, boolean ignoreFormatted) {
        int n;
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            String configPathString = new File(tempDir.getAbsolutePath(), "format.props").toString();
            PropertiesUtils.writePropertiesFile((Properties)properties, (String)configPathString, (boolean)true);
            ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ"}));
            if (ignoreFormatted) {
                arguments.$plus$eq((Object)"--ignore-formatted");
            }
            arguments.$plus$eq((Object)"--config");
            arguments.$plus$eq((Object)configPathString);
            extraArguments.foreach((Function1 & Serializable)x$1 -> (ListBuffer)arguments.$plus$eq(x$1));
            n = StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
        }
        finally {
            Utils.delete((File)tempDir);
        }
        return n;
    }

    private scala.collection.immutable.Seq<String> runFormatCommand$default$3() {
        return Nil$.MODULE$;
    }

    private boolean runFormatCommand$default$4() {
        return false;
    }

    @Test
    public void testFormatSucceedsIfAllDirectoriesAreAvailable() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
        ((IterableOnceOps)availableDirs.tail()).foreach((Function1 & Serializable)dir -> {
            StorageToolTest.$anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(stream, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFormatSucceedsIfAtLeastOneDirectoryIsAvailable() {
        File availableDir1 = TestUtils.tempDirectory(null, null);
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDir1 + "," + unavailableDir1);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDir1}))), (String)("Failed to find content in output: " + stream.toString()));
        Assertions.assertFalse((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting log directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)("Failed to find content in output: " + stream.toString()));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatFailsOnAlreadyFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertTrue((boolean)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream2, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false)).getMessage().contains("already formatted. Use --ignore-formatted to ignore this directory and format the others"));
    }

    @Test
    public void testIgnoreFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream2, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, true));
    }

    @Test
    public void testFormatFailsIfAllDirectoriesAreUnavailable() {
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        File unavailableDir2 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", unavailableDir1 + "," + unavailableDir2);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"No available log directories to format.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, false)).getMessage());
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)("Failed to find content in output: " + stream.toString()));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir2}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.8-IV0", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithReleaseVersionAsFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"metadata.version=20", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithInvalidFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Unsupported feature: non.existent.feature. Supported features are: eligible.leader.replicas.version, group.version, kraft.version, share.version, streams.version, transaction.version", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"non.existent.feature=20", (List)Nil$.MODULE$)), false)).getMessage());
    }

    @Test
    public void testFormatWithInvalidKRaftVersionLevel() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"No feature:kraft.version with feature level 999", (Object)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=999", (List)new .colon.colon((Object)"--standalone", (List)Nil$.MODULE$))), false)).getMessage());
    }

    @Test
    public void testFormatWithReleaseVersionAndKRaftVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.7-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.7-IV0"), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithReleaseVersionDefaultAndReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.6-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.6-IV0"), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithStandaloneFlagOnBrokerFails() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.setProperty("process.roles", "broker");
        properties.setProperty("node.id", "0");
        properties.setProperty("controller.listener.names", "CONTROLLER");
        properties.setProperty("controller.quorum.bootstrap.servers", "localhost:9093");
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        Assertions.assertEquals((Object)"You can only use --standalone on a controller.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false)).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithStandaloneFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithStandaloneFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithInitialControllersFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @ParameterizedTest
    @ValueSource(strings={"controller", "broker,controller"})
    public void testFormatWithoutStaticQuorumFailsWithoutInitialControllersOnController(String processRoles) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        if (processRoles.contains("broker")) {
            properties.setProperty("listeners", "PLAINTEXT://:9092,CONTROLLER://:9093");
            properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092,CONTROLLER://127.0.0.1:9093");
        }
        properties.setProperty("process.roles", processRoles);
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Because controller.quorum.voters is not set on this controller, you must specify one of the following: --standalone, --initial-controllers, or --no-initial-controllers.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), false)).getMessage());
    }

    @Test
    public void testFormatWithNoInitialControllersSucceedsOnController() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--no-initial-controllers"}));
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    @Test
    public void testFormatWithNoInitialControllersFlagAndStandaloneFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.9-IV0", "--no-initial-controllers", "--standalone"}));
        ArgumentParserException exception = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertEquals((Object)"argument --standalone/-s: not allowed with argument --no-initial-controllers/-N", (Object)exception.getMessage());
    }

    @Test
    public void testFormatWithNoInitialControllersFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.9-IV0", "--no-initial-controllers", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        ArgumentParserException exception = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertEquals((Object)"argument --initial-controllers/-I: not allowed with argument --no-initial-controllers/-N", (Object)exception.getMessage());
    }

    @Test
    public void testFormatWithoutStaticQuorumSucceedsWithoutInitialControllersOnBroker() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("listeners", "PLAINTEXT://:9092");
        properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092");
        properties.setProperty("process.roles", "broker");
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)("Failed to find content in output: " + stream.toString()));
    }

    private int runVersionMappingCommand(ByteArrayOutputStream stream, String releaseVersion) {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"version-mapping"}));
        if (releaseVersion != null) {
            arguments.$plus$eq((Object)"--release-version");
            arguments.$plus$eq((Object)releaseVersion);
        }
        return StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
    }

    @Test
    public void testVersionMappingWithValidReleaseVersion() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runVersionMappingCommand(stream, MetadataVersion.MINIMUM_VERSION.toString()));
        String output = stream.toString();
        MetadataVersion metadataVersion = MetadataVersion.MINIMUM_VERSION;
        Assertions.assertTrue((boolean)output.contains("metadata.version=" + metadataVersion.featureLevel() + " (" + metadataVersion.version() + ")"), (String)("Output did not contain expected Metadata Version: " + output));
        CollectionConverters$.MODULE$.ListHasAsScala(Feature.PRODUCTION_FEATURES).asScala().foreach((Function1 & Serializable)feature -> {
            StorageToolTest.$anonfun$testVersionMappingWithValidReleaseVersion$1(metadataVersion, output, feature);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testVersionMappingWithNoReleaseVersion() {
        new Properties().putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runVersionMappingCommand(stream, null));
        String output = stream.toString();
        MetadataVersion metadataVersion = MetadataVersion.latestProduction();
        Assertions.assertTrue((boolean)output.contains("metadata.version=" + metadataVersion.featureLevel() + " (" + metadataVersion.version() + ")"), (String)("Output did not contain expected Metadata Version: " + output));
        CollectionConverters$.MODULE$.ListHasAsScala(Feature.PRODUCTION_FEATURES).asScala().foreach((Function1 & Serializable)feature -> {
            StorageToolTest.$anonfun$testVersionMappingWithNoReleaseVersion$1(metadataVersion, output, feature);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testVersionMappingWithInvalidReleaseVersion() {
        new Properties().putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TerseFailure exception = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runVersionMappingCommand(stream, "2.9-IV2"));
        Assertions.assertEquals((Object)("Unknown release version '2.9-IV2'. Supported versions are: " + MetadataVersion.MINIMUM_VERSION.version() + " to " + MetadataVersion.LATEST_PRODUCTION.version()), (Object)exception.getMessage());
        TerseFailure exception2 = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runVersionMappingCommand(stream, "invalid"));
        Assertions.assertEquals((Object)("Unknown release version 'invalid'. Supported versions are: " + MetadataVersion.MINIMUM_VERSION.version() + " to " + MetadataVersion.LATEST_PRODUCTION.version()), (Object)exception2.getMessage());
    }

    private int runFeatureDependenciesCommand(ByteArrayOutputStream stream, scala.collection.immutable.Seq<String> features) {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"feature-dependencies"}));
        features.foreach((Function1 & Serializable)feature -> {
            arguments.$plus$eq((Object)"--feature");
            return (ListBuffer)arguments.$plus$eq(feature);
        });
        return StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
    }

    @Test
    public void testTestingFeatureDependencies() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Namespace namespace = StorageTool$.MODULE$.parseArguments(new String[]{"feature-dependencies", "--feature", "test.feature.version=2"});
        StorageTool$.MODULE$.runFeatureDependenciesCommand(namespace, new PrintStream(stream), this.testingFeatures());
        String output = stream.toString().trim();
        System.out.println(output);
        MetadataVersion latestTestingVersion = MetadataVersion.latestTesting();
        String latestTestingVersionString = "metadata.version=" + latestTestingVersion.featureLevel() + " (" + latestTestingVersion.version() + ")";
        Assertions.assertEquals((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("test.feature.version=2 requires:\n         |    " + latestTestingVersionString + "\n         |")).trim(), (Object)output);
    }

    @Test
    public void testMultipleFeatureDependencies() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        .colon.colon features = new .colon.colon((Object)"transaction.version=2", (List)new .colon.colon((Object)"group.version=1", (List)Nil$.MODULE$));
        Assertions.assertEquals((int)0, (int)this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)features));
        String output = stream.toString().trim();
        System.out.println(output);
        Assertions.assertEquals((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("transaction.version=2 has no dependencies.\n         |group.version=1 has no dependencies.\n         |")).trim(), (Object)output);
    }

    @Test
    public void testHandleFeatureDependenciesForFeatureWithNoDependencies() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"metadata.version=17", (List)Nil$.MODULE$)));
        String output = stream.toString().trim();
        Assertions.assertEquals((Object)"metadata.version=17 (3.7-IV2) has no dependencies.", (Object)output);
    }

    @Test
    public void testHandleFeatureDependenciesForUnknownFeature() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TerseFailure exception = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"unknown.feature.version=1", (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)"Unknown feature: unknown.feature.version", (Object)exception.getMessage());
    }

    @Test
    public void testHandleFeatureDependenciesForFeatureWithUnknownFeatureVersion() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TerseFailure exception = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"transaction.version=1000", (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)"Feature level 1000 is not supported for feature transaction.version", (Object)exception.getMessage());
    }

    @Test
    public void testHandleFeatureDependenciesForInvalidVersionFormat() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TerseFailure exception = (TerseFailure)Assertions.assertThrows(TerseFailure.class, () -> this.runFeatureDependenciesCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"metadata.version=invalid", (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)"Invalid version format: invalid for feature metadata.version", (Object)exception.getMessage());
    }

    @Test
    public void testBootstrapScramRecords() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false));
        BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(((File)availableDirs.head()).toString()).read();
        List scramRecords = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(bootstrapMetadata.records()).asScala().filter((Function1 & Serializable)apiMessageAndVersion -> BoxesRunTime.boxToBoolean((boolean)StorageToolTest.$anonfun$testBootstrapScramRecords$1(apiMessageAndVersion)))).map((Function1 & Serializable)apiMessageAndVersion -> (UserScramCredentialRecord)apiMessageAndVersion.message())).toList();
        Assertions.assertEquals((int)2, (int)scramRecords.size());
        Assertions.assertEquals((Object)"alice", (Object)((UserScramCredentialRecord)scramRecords.head()).name());
        Assertions.assertEquals((Object)"bob", (Object)((UserScramCredentialRecord)scramRecords.last()).name());
    }

    @Test
    public void testScramRecordsOldReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.4", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((Object)"SCRAM is only supported in metadata.version 3.5-IV2 or later.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, (scala.collection.immutable.Seq<String>)arguments.toSeq(), false)).getMessage());
    }

    @Test
    public void testParseNameAndLevel() {
        Assertions.assertEquals((Object)new Tuple2((Object)"foo.bar", (Object)BoxesRunTime.boxToShort((short)((short)56))), (Object)StorageTool$.MODULE$.parseNameAndLevel("foo.bar=56"));
    }

    @Test
    public void testParseNameAndLevelWithNoEquals() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version5: equals sign not found.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version5")).getMessage());
    }

    @Test
    public void testParseNameAndLevelWithNoNumber() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version=foo: unable to parse foo as a short.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version=foo")).getMessage());
    }

    public static final /* synthetic */ void $anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(ByteArrayOutputStream stream$1, File dir) {
        Assertions.assertTrue((boolean)stream$1.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting data directory %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{dir}))), (String)("Failed to find content in output: " + stream$1.toString()));
    }

    public static final /* synthetic */ void $anonfun$testVersionMappingWithValidReleaseVersion$1(MetadataVersion metadataVersion$1, String output$1, Feature feature) {
        short featureLevel = feature.defaultLevel(metadataVersion$1);
        Assertions.assertTrue((boolean)output$1.contains(feature.featureName() + "=" + featureLevel), (String)("Output did not contain expected feature mapping: " + output$1));
    }

    public static final /* synthetic */ void $anonfun$testVersionMappingWithNoReleaseVersion$1(MetadataVersion metadataVersion$2, String output$2, Feature feature) {
        short featureLevel = feature.defaultLevel(metadataVersion$2);
        Assertions.assertTrue((boolean)output$2.contains(feature.featureName() + "=" + featureLevel), (String)("Output did not contain expected feature mapping: " + output$2));
    }

    public static final /* synthetic */ boolean $anonfun$testBootstrapScramRecords$1(ApiMessageAndVersion apiMessageAndVersion) {
        return apiMessageAndVersion.message() instanceof UserScramCredentialRecord;
    }

    public StorageToolTest() {
        this.defaultStaticQuorumProperties().setProperty("process.roles", "broker");
        this.defaultStaticQuorumProperties().setProperty("node.id", "0");
        this.defaultStaticQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultStaticQuorumProperties().setProperty("controller.quorum.voters", "100@localhost:9093");
        this.defaultDynamicQuorumProperties = new Properties();
        this.defaultDynamicQuorumProperties().setProperty("process.roles", "controller");
        this.defaultDynamicQuorumProperties().setProperty("node.id", "0");
        this.defaultDynamicQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultDynamicQuorumProperties().setProperty("controller.quorum.bootstrap.servers", "localhost:9093");
        this.defaultDynamicQuorumProperties().setProperty("listeners", "CONTROLLER://:9093");
        this.defaultDynamicQuorumProperties().setProperty("advertised.listeners", "CONTROLLER://127.0.0.1:9093");
        this.defaultDynamicQuorumProperties().setProperty("unstable.api.versions.enable", "true");
        this.defaultDynamicQuorumProperties().setProperty("unstable.feature.versions.enable", "true");
    }
}

