/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.ConnectionThrottledException;
import org.apache.kafka.network.TooManyConnectionsException;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011EcA\u00021b\u0003\u0003\u0019W\r\u0003\u0005x\u0001\t\u0015\r\u0011\"\u0001z\u0011!q\bA!A!\u0002\u0013Q\b\"C@\u0001\u0005\u000b\u0007I\u0011AA\u0001\u0011)\tI\u0002\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u00037\u0001!\u00111A\u0005\u0002\u0005u\u0001BCA\u0016\u0001\t\u0005\r\u0011\"\u0001\u0002.!Q\u0011q\b\u0001\u0003\u0002\u0003\u0006K!a\b\t\u0015\u0005\u0005\u0003A!A!\u0002\u0013\t\u0019\u0005\u0003\u0006\u0002J\u0001\u0011)\u0019!C\u0001\u0003\u0017B!\"a\u0015\u0001\u0005\u0003\u0005\u000b\u0011BA'\u0011)\t)\u0006\u0001B\u0001B\u0003%\u0011q\u000b\u0005\u000b\u0003C\u0002!\u0011!Q\u0001\n\u0005\r\u0004BCA5\u0001\t\u0005\t\u0015!\u0003\u0002l!Q\u0011\u0011\u000f\u0001\u0003\u0002\u0003\u0006I!a\u001d\t\u0015\u0005u\u0004A!A!\u0002\u0013\ty\b\u0003\u0006\u0002\f\u0002\u0011\t\u0011)A\u0005\u0003\u001bC!\"a%\u0001\u0005\u0003\u0005\u000b\u0011BAK\u0011)\t\t\u000b\u0001B\u0001B\u0003%\u00111\u0015\u0005\b\u0003[\u0003A\u0011AAX\u0011%\ti\r\u0001b\u0001\n\u0013\ty\r\u0003\u0005\u0002\\\u0002\u0001\u000b\u0011BAi\u0011%\ti\u000e\u0001b\u0001\n\u0003\ty\u000e\u0003\u0005\u0002v\u0002\u0001\u000b\u0011BAq\u0011%\t9\u0010\u0001b\u0001\n\u0013\tI\u0010\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0011BA~\u0011%\u0011\u0019\u0001\u0001b\u0001\n\u0013\tI\u0010\u0003\u0005\u0003\u0006\u0001\u0001\u000b\u0011BA~\u0011%\u00119\u0001\u0001b\u0001\n\u0013\tI\u0010\u0003\u0005\u0003\n\u0001\u0001\u000b\u0011BA~\u0011%\u0011Y\u0001\u0001b\u0001\n\u0013\u0011i\u0001\u0003\u0005\u0003 \u0001\u0001\u000b\u0011\u0002B\b\u00111\u0011\t\u0003\u0001a\u0001\u0002\u0004%\t!\u0019B\u0012\u00111\u0011Y\u0003\u0001a\u0001\u0002\u0004%\t!\u0019B\u0017\u0011-\u0011\t\u0004\u0001a\u0001\u0002\u0003\u0006KA!\n\t\u0015\tM\u0002A1A\u0005\u0002\u0005\u0014)\u0004\u0003\u0005\u00038\u0001\u0001\u000b\u0011BA\"\u0011)\u0011I\u0004\u0001b\u0001\n\u0003\t'1\b\u0005\t\u0005'\u0002\u0001\u0015!\u0003\u0003>!I!Q\u000b\u0001C\u0002\u0013%\u0011q\u001a\u0005\t\u0005/\u0002\u0001\u0015!\u0003\u0002R\"I!\u0011\f\u0001C\u0002\u0013%!1\f\u0005\t\u0005g\u0002\u0001\u0015!\u0003\u0003^!I!Q\u000f\u0001C\u0002\u0013%!q\u000f\u0005\t\u0005\u007f\u0002\u0001\u0015!\u0003\u0003z!I!\u0011\u0011\u0001A\u0002\u0013%!Q\u0007\u0005\n\u0005\u0007\u0003\u0001\u0019!C\u0005\u0005\u000bC\u0001B!#\u0001A\u0003&\u00111\t\u0005\u000b\u0005\u0017\u0003!\u0019!C\u0001C\n5\u0005\u0002CB)\u0001\u0001\u0006IAa$\t\u0013\rM\u0003A1A\u0005\n\u0005}\u0007\u0002CB+\u0001\u0001\u0006I!!9\t\u0015\r]\u0003A1A\u0005\u0002\u0005\u001cI\u0006\u0003\u0005\u0004j\u0001\u0001\u000b\u0011BB.\u0011%\u0019Y\u0007\u0001b\u0001\n\u0003\u0019i\u0007\u0003\u0005\u0004v\u0001\u0001\u000b\u0011BB8\u0011\u001d\u00199\b\u0001C\u0001\u0007s2qA!'\u0001\u0001\u0006\u0014Y\n\u0003\u0006\u0003Hf\u0012)\u001a!C\u0001\u0005\u0013D!B!5:\u0005#\u0005\u000b\u0011\u0002Bf\u0011)\u0011\u0019.\u000fBK\u0002\u0013\u0005!Q\u001b\u0005\u000b\u0005;L$\u0011#Q\u0001\n\t]\u0007bBAWs\u0011\u0005!q\u001c\u0005\b\u0005KLD\u0011\tBt\u0011%\u0011i/OA\u0001\n\u0003\u0011y\u000fC\u0005\u0003vf\n\n\u0011\"\u0001\u0003x\"I1QB\u001d\u0012\u0002\u0013\u00051q\u0002\u0005\n\u0007'I\u0014\u0011!C!\u0007+A\u0011b!\b:\u0003\u0003%\tA!\u000e\t\u0013\r}\u0011(!A\u0005\u0002\r\u0005\u0002\"CB\u0016s\u0005\u0005I\u0011IB\u0017\u0011%\u00199$OA\u0001\n\u0003\u0019I\u0004C\u0005\u0004>e\n\t\u0011\"\u0011\u0004@!I11I\u001d\u0002\u0002\u0013\u00053Q\t\u0005\n\u0007\u000fJ\u0014\u0011!C!\u0007\u0013B\u0011ba\u0013:\u0003\u0003%\te!\u0014\b\u0015\rm\u0004!!A\t\u0002\u0005\u001ciH\u0002\u0006\u0003\u001a\u0002\t\t\u0011#\u0001b\u0007\u007fBq!!,N\t\u0003\u00199\nC\u0005\u0004H5\u000b\t\u0011\"\u0012\u0004J!I1\u0011T'\u0002\u0002\u0013\u000551\u0014\u0005\n\u0007Ck\u0015\u0011!CA\u0007GC\u0001b!.\u0001\t\u0003\t7q\u0017\u0005\b\u0007{\u0003A\u0011AB=\u0011\u001d\u0019y\f\u0001C\u0001\u0007sBqa!1\u0001\t\u0003\u001aI\bC\u0004\u0004D\u0002!Ia!\u001f\t\u000f\r\u0015\u0007\u0001\"\u0003\u0004H\"91\u0011\u001d\u0001\u0005\n\re\u0004bBBr\u0001\u0011%1Q\u001d\u0005\b\u0007g\u0004A\u0011CB{\u0011\u001d\u0019Y\u0010\u0001C\u0005\u0007sBqa!@\u0001\t\u0013\u0019y\u0010C\u0004\u0005\f\u0001!\ta!\u001f\t\u000f\u00115\u0001\u0001\"\u0001\u0005\u0010!9AQ\u0003\u0001\u0005\u0002\u0011]!\u0001C!dG\u0016\u0004Ho\u001c:\u000b\u0005\t\u001c\u0017a\u00028fi^|'o\u001b\u0006\u0002I\u0006)1.\u00194lCN!\u0001A\u001a8r!\t9G.D\u0001i\u0015\tI'.\u0001\u0003mC:<'\"A6\u0002\t)\fg/Y\u0005\u0003[\"\u0014aa\u00142kK\u000e$\bCA4p\u0013\t\u0001\bN\u0001\u0005Sk:t\u0017M\u00197f!\t\u0011X/D\u0001t\u0015\t!8-A\u0003vi&d7/\u0003\u0002wg\n9Aj\\4hS:<\u0017\u0001D:pG.,GoU3sm\u0016\u00148\u0001A\u000b\u0002uB\u00111\u0010`\u0007\u0002C&\u0011Q0\u0019\u0002\r'>\u001c7.\u001a;TKJ4XM]\u0001\u000eg>\u001c7.\u001a;TKJ4XM\u001d\u0011\u0002\u0011\u0015tG\rU8j]R,\"!a\u0001\u0011\t\u0005\u0015\u0011QC\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u000511m\\7n_:T1\u0001ZA\u0007\u0015\u0011\ty!!\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019\"A\u0002pe\u001eLA!a\u0006\u0002\b\tAQI\u001c3q_&tG/A\u0005f]\u0012\u0004v.\u001b8uA\u000511m\u001c8gS\u001e,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nd\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011FA\u0012\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u00020\u0005m\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0005\u0005U\u0012!B:dC2\f\u0017\u0002BA\u001d\u0003g\u0011A!\u00168ji\"I\u0011Q\b\u0004\u0002\u0002\u0003\u0007\u0011qD\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\u0007]>$W-\u00133\u0011\t\u0005E\u0012QI\u0005\u0005\u0003\u000f\n\u0019DA\u0002J]R\f\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0016\u0005\u00055\u0003cA>\u0002P%\u0019\u0011\u0011K1\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018!E2p]:,7\r^5p]F+x\u000e^1tA\u0005!A/[7f!\u0011\tI&!\u0018\u000e\u0005\u0005m#b\u0001;\u0002\b%!\u0011qLA.\u0005\u0011!\u0016.\\3\u0002)%\u001c\bK]5wS2,w-\u001a3MSN$XM\\3s!\u0011\t\t$!\u001a\n\t\u0005\u001d\u00141\u0007\u0002\b\u0005>|G.Z1o\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u00042a_A7\u0013\r\ty'\u0019\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003\u001diW\r\u001e:jGN\u0004B!!\u001e\u0002z5\u0011\u0011q\u000f\u0006\u0005\u0003c\n9!\u0003\u0003\u0002|\u0005]$aB'fiJL7m]\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\u0011\t))a\u0003\u0002\u0011M,7-\u001e:jifLA!!#\u0002\u0004\n\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0005\u00033\ny)\u0003\u0003\u0002\u0012\u0006m#A\u0003'pO\u000e{g\u000e^3yi\u0006QQ.Z7pef\u0004vn\u001c7\u0011\t\u0005]\u0015QT\u0007\u0003\u00033SA!a'\u0002\b\u00051Q.Z7pefLA!a(\u0002\u001a\nQQ*Z7pef\u0004vn\u001c7\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000f\u0005\u0003\u0002&\u0006%VBAAT\u0015\u0011\t)#a\u0003\n\t\u0005-\u0016q\u0015\u0002\u0012\u0003BLg+\u001a:tS>tW*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u000f\u00022\u0006M\u0016QWA\\\u0003s\u000bY,!0\u0002@\u0006\u0005\u00171YAc\u0003\u000f\fI-a3\u0011\u0005m\u0004\u0001\"B<\u0014\u0001\u0004Q\bBB@\u0014\u0001\u0004\t\u0019\u0001C\u0004\u0002\u001cM\u0001\r!a\b\t\u000f\u0005\u00053\u00031\u0001\u0002D!9\u0011\u0011J\nA\u0002\u00055\u0003bBA+'\u0001\u0007\u0011q\u000b\u0005\b\u0003C\u001a\u0002\u0019AA2\u0011\u001d\tIg\u0005a\u0001\u0003WBq!!\u001d\u0014\u0001\u0004\t\u0019\bC\u0004\u0002~M\u0001\r!a \t\u000f\u0005-5\u00031\u0001\u0002\u000e\"9\u00111S\nA\u0002\u0005U\u0005bBAQ'\u0001\u0007\u00111U\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003#\u0004B!a5\u0002X6\u0011\u0011Q\u001b\u0006\u0005\u0003c\n9+\u0003\u0003\u0002Z\u0006U'!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\n\u0011b\u001d5pk2$'+\u001e8\u0016\u0005\u0005\u0005\b\u0003BAr\u0003cl!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\u0007CR|W.[2\u000b\t\u0005-\u0018Q^\u0001\u000bG>t7-\u001e:sK:$(bAAxU\u0006!Q\u000f^5m\u0013\u0011\t\u00190!:\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003)\u0019\bn\\;mIJ+h\u000eI\u0001\u000fg\u0016tGMQ;gM\u0016\u00148+\u001b>f+\t\tY\u0010E\u0002h\u0003{L1!a@i\u0005\u001dIe\u000e^3hKJ\fqb]3oI\n+hMZ3s'&TX\rI\u0001\u000fe\u0016\u001cgOQ;gM\u0016\u00148+\u001b>f\u0003=\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\u0004\u0013!\u00057jgR,gNQ1dW2|wmU5{K\u0006\u0011B.[:uK:\u0014\u0015mY6m_\u001e\u001c\u0016N_3!\u0003-q\u0017n\\*fY\u0016\u001cGo\u001c:\u0016\u0005\t=\u0001\u0003\u0002B\t\u00057i!Aa\u0005\u000b\t\tU!qC\u0001\tG\"\fgN\\3mg*\u0019!\u0011\u00046\u0002\u00079Lw.\u0003\u0003\u0003\u001e\tM!\u0001C*fY\u0016\u001cGo\u001c:\u0002\u00199LwnU3mK\u000e$xN\u001d\u0011\u0002\u001bM,'O^3s\u0007\"\fgN\\3m+\t\u0011)\u0003\u0005\u0003\u0003\u0012\t\u001d\u0012\u0002\u0002B\u0015\u0005'\u00111cU3sm\u0016\u00148k\\2lKR\u001c\u0005.\u00198oK2\f\u0011c]3sm\u0016\u00148\t[1o]\u0016dw\fJ3r)\u0011\tyCa\f\t\u0013\u0005u\u0012%!AA\u0002\t\u0015\u0012AD:feZ,'o\u00115b]:,G\u000eI\u0001\nY>\u001c\u0017\r\u001c)peR,\"!a\u0011\u0002\u00151|7-\u00197Q_J$\b%\u0001\u0006qe>\u001cWm]:peN,\"A!\u0010\u0011\r\t}\"\u0011\nB'\u001b\t\u0011\tE\u0003\u0003\u0003D\t\u0015\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0005\u0005\u000f\n\u0019$\u0001\u0006d_2dWm\u0019;j_:LAAa\u0013\u0003B\tY\u0011I\u001d:bs\n+hMZ3s!\rY(qJ\u0005\u0004\u0005#\n'!\u0003)s_\u000e,7o]8s\u0003-\u0001(o\\2fgN|'o\u001d\u0011\u0002A\t\f7m[<be\u0012\u001cu.\u001c9bi&\u0014\u0017\u000e\\5us6+GO]5d\u000fJ|W\u000f]\u0001\"E\u0006\u001c7n^1sI\u000e{W\u000e]1uS\nLG.\u001b;z\u001b\u0016$(/[2He>,\b\u000fI\u0001\u001eE2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]'fiJL7MT1nKV\u0011!Q\f\t\u0005\u0005?\u0012y'\u0004\u0002\u0003b)!!1\rB3\u0003\u0011\u0019wN]3\u000b\t\u0005E$q\r\u0006\u0005\u0005S\u0012Y'\u0001\u0004zC6lWM\u001d\u0006\u0003\u0005[\n1aY8n\u0013\u0011\u0011\tH!\u0019\u0003\u00155+GO]5d\u001d\u0006lW-\u0001\u0010cY>\u001c7.\u001a3QKJ\u001cWM\u001c;NKR,'/T3ue&\u001cg*Y7fA\u0005\u0019\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;feV\u0011!\u0011\u0010\t\u0005\u0005?\u0012Y(\u0003\u0003\u0003~\t\u0005$!B'fi\u0016\u0014\u0018\u0001\u00062m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014\b%A\u000bdkJ\u0014XM\u001c;Qe>\u001cWm]:pe&sG-\u001a=\u00023\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fq~#S-\u001d\u000b\u0005\u0003_\u00119\tC\u0005\u0002>9\n\t\u00111\u0001\u0002D\u000512-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016D\b%\u0001\tuQJ|G\u000f\u001e7fIN{7m[3ugV\u0011!q\u0012\t\u0007\u0005\u007f\u0011\tJ!&\n\t\tM%\u0011\t\u0002\u000e!JLwN]5usF+X-^3\u0011\u0007\t]\u0015(D\u0001\u0001\u0005I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0014\u0013e\u0012iJa)\u0003<\n\u0005\u0007\u0003BA\u0019\u0005?KAA!)\u00024\t1\u0011I\\=SK\u001a\u0004bA!*\u00036\nUe\u0002\u0002BT\u0005csAA!+\u000306\u0011!1\u0016\u0006\u0004\u0005[C\u0018A\u0002\u001fs_>$h(\u0003\u0002\u00026%!!1WA\u001a\u0003\u001d\u0001\u0018mY6bO\u0016LAAa.\u0003:\n9qJ\u001d3fe\u0016$'\u0002\u0002BZ\u0003g\u0001B!!\r\u0003>&!!qXA\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004BA!*\u0003D&!!Q\u0019B]\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0019xnY6fiV\u0011!1\u001a\t\u0005\u0005#\u0011i-\u0003\u0003\u0003P\nM!!D*pG.,Go\u00115b]:,G.A\u0004t_\u000e\\W\r\u001e\u0011\u0002#\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5/\u0006\u0002\u0003XB!\u0011\u0011\u0007Bm\u0013\u0011\u0011Y.a\r\u0003\t1{gnZ\u0001\u0013K:$G\u000b\u001b:piRdW\rV5nK6\u001b\b\u0005\u0006\u0004\u0003\u0016\n\u0005(1\u001d\u0005\b\u0005\u000ft\u0004\u0019\u0001Bf\u0011\u001d\u0011\u0019N\u0010a\u0001\u0005/\fqaY8na\u0006\u0014X\r\u0006\u0003\u0002D\t%\bb\u0002Bv\u007f\u0001\u0007!QS\u0001\u0005i\"\fG/\u0001\u0003d_BLHC\u0002BK\u0005c\u0014\u0019\u0010C\u0005\u0003H\u0002\u0003\n\u00111\u0001\u0003L\"I!1\u001b!\u0011\u0002\u0003\u0007!q[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IP\u000b\u0003\u0003L\nm8F\u0001B\u007f!\u0011\u0011yp!\u0003\u000e\u0005\r\u0005!\u0002BB\u0002\u0007\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\r\u001d\u00111G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0006\u0007\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"a!\u0005+\t\t]'1`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r]\u0001cA4\u0004\u001a%\u001911\u00045\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$Baa\t\u0004*A!\u0011\u0011GB\u0013\u0013\u0011\u00199#a\r\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002>\u0015\u000b\t\u00111\u0001\u0002D\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00040A11\u0011GB\u001a\u0007Gi!A!\u0012\n\t\rU\"Q\t\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002d\rm\u0002\"CA\u001f\u000f\u0006\u0005\t\u0019AB\u0012\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\r]1\u0011\t\u0005\n\u0003{A\u0015\u0011!a\u0001\u0003\u0007\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0007\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007/\ta!Z9vC2\u001cH\u0003BA2\u0007\u001fB\u0011\"!\u0010L\u0003\u0003\u0005\raa\t\u0002#QD'o\u001c;uY\u0016$7k\\2lKR\u001c\b%A\u0004ti\u0006\u0014H/\u001a3\u0002\u0011M$\u0018M\u001d;fI\u0002\nQb\u001d;beR,GMR;ukJ,WCAB.!\u0019\u0019ifa\u0018\u0004d5\u0011\u0011\u0011^\u0005\u0005\u0007C\nIOA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042aZB3\u0013\r\u00199\u0007\u001b\u0002\u0005->LG-\u0001\bti\u0006\u0014H/\u001a3GkR,(/\u001a\u0011\u0002\rQD'/Z1e+\t\u0019y\u0007\u0005\u0003\u0002Z\rE\u0014\u0002BB:\u00037\u00121bS1gW\u0006$\u0006N]3bI\u00069A\u000f\u001b:fC\u0012\u0004\u0013!B:uCJ$HCAA\u0018\u0003I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0011\u0007\t]UjE\u0003N\u0007\u0003\u001bi\t\u0005\u0006\u0004\u0004\u000e%%1\u001aBl\u0005+k!a!\"\u000b\t\r\u001d\u00151G\u0001\beVtG/[7f\u0013\u0011\u0019Yi!\"\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0004\u0010\u000eUUBABI\u0015\r\u0019\u0019J[\u0001\u0003S>LAA!2\u0004\u0012R\u00111QP\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005+\u001bija(\t\u000f\t\u001d\u0007\u000b1\u0001\u0003L\"9!1\u001b)A\u0002\t]\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0007K\u001b\t\f\u0005\u0004\u00022\r\u001d61V\u0005\u0005\u0007S\u000b\u0019D\u0001\u0004PaRLwN\u001c\t\t\u0003c\u0019iKa3\u0003X&!1qVA\u001a\u0005\u0019!V\u000f\u001d7fe!I11W)\u0002\u0002\u0003\u0007!QS\u0001\u0004q\u0012\u0002\u0014\u0001\u0005:f[>4X\r\u0015:pG\u0016\u001c8o\u001c:t)\u0011\tyc!/\t\u000f\rm&\u000b1\u0001\u0002D\u0005Y!/Z7pm\u0016\u001cu.\u001e8u\u00035\u0011WmZ5o'\",H\u000fZ8x]\u0006)1\r\\8tK\u0006\u0019!/\u001e8\u0002\u0011\rdwn]3BY2\f\u0001c\u001c9f]N+'O^3s'>\u001c7.\u001a;\u0015\u0011\t\u00152\u0011ZBn\u0007?Dqaa3X\u0001\u0004\u0019i-\u0001\u0003i_N$\b\u0003BBh\u0007/tAa!5\u0004TB!!\u0011VA\u001a\u0013\u0011\u0019).a\r\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019Yb!7\u000b\t\rU\u00171\u0007\u0005\b\u0007;<\u0006\u0019AA\"\u0003\u0011\u0001xN\u001d;\t\u000f\t\u001dq\u000b1\u0001\u0002D\u0005!\u0012mY2faRtUm^\"p]:,7\r^5p]N\fa!Y2dKB$H\u0003BBt\u0007S\u0004b!!\r\u0004(\n-\u0007bBBv3\u0002\u00071Q^\u0001\u0004W\u0016L\b\u0003\u0002B\t\u0007_LAa!=\u0003\u0014\ta1+\u001a7fGRLwN\\&fs\u0006q2m\u001c8gS\u001e,(/Z!dG\u0016\u0004H/\u001a3T_\u000e\\W\r^\"iC:tW\r\u001c\u000b\u0005\u0003_\u00199\u0010C\u0004\u0004zj\u0003\rAa3\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0003e\u0019Gn\\:f)\"\u0014x\u000e\u001e;mK\u0012\u001cuN\u001c8fGRLwN\\:\u0002'\u0005\u001c8/[4o\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0011\u0005\rD\u0011\u0001C\u0002\t\u000fAqa!?]\u0001\u0004\u0011Y\rC\u0004\u0005\u0006q\u0003\rA!\u0014\u0002\u0013A\u0014xnY3tg>\u0014\bb\u0002C\u00059\u0002\u0007\u00111M\u0001\t[\u0006L(\t\\8dW\u00061q/Y6fkB\fQ\"\u00193e!J|7-Z:t_J\u001cH\u0003BA\u0018\t#Aq\u0001b\u0005_\u0001\u0004\t\u0019%\u0001\u0005u_\u000e\u0013X-\u0019;f\u00031qWm\u001e)s_\u000e,7o]8s))\u0011i\u0005\"\u0007\u0005\u001e\u0011-BQ\b\u0005\b\t7y\u0006\u0019AA\"\u0003\tIG\rC\u0004\u0005 }\u0003\r\u0001\"\t\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0011\rBqE\u0007\u0003\tKQ1AYA\u0004\u0013\u0011!I\u0003\"\n\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f\u00115r\f1\u0001\u00050\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\tc!I$\u0004\u0002\u00054)!AQ\u0007C\u001c\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005\u0015\u0015qA\u0005\u0005\tw!\u0019D\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"9AqH0A\u0002\u0011\u0005\u0013!H2p]:,7\r^5p]\u0012K7oY8o]\u0016\u001cG\u000fT5ti\u0016tWM]:\u0011\r\rEB1\tC$\u0013\u0011!)E!\u0012\u0003\u0007M+\u0017\u000f\u0005\u0003\u0005J\u00115SB\u0001C&\u0015\r\u0011\u0017qU\u0005\u0005\t\u001f\"YE\u0001\u000fD_:tWm\u0019;j_:$\u0015n]2p]:,7\r\u001e'jgR,g.\u001a:")
public abstract class Acceptor
implements Runnable,
Logging {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final Endpoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private ServerSocketChannel serverChannel;
    private final int localPort;
    private final ArrayBuffer<Processor> processors;
    private final KafkaMetricsGroup backwardCompatibilityMetricGroup;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private final AtomicBoolean started;
    private final CompletableFuture<Void> startedFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public Endpoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public void serverChannel_$eq(ServerSocketChannel x$1) {
        this.serverChannel = x$1;
    }

    public int localPort() {
        return this.localPort;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private KafkaMetricsGroup backwardCompatibilityMetricGroup() {
        return this.backwardCompatibilityMetricGroup;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    public CompletableFuture<Void> startedFuture() {
        return this.startedFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public void start() {
        synchronized (this) {
            this.liftedTree1$1();
            return;
        }
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable)x$10 -> {
                    x$10.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        if (!this.started().get()) {
            this.closeAll();
        }
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$11 -> {
                x$11.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.closeAll();
        }
    }

    private void closeAll() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
        Utils.closeQuietly((AutoCloseable)this.serverChannel(), (String)"Acceptor serverChannel");
        Utils.closeQuietly((AutoCloseable)this.nioSelector(), (String)"Acceptor nioSelector");
        this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
            SocketServer$.MODULE$.closeSocket(throttledSocket.socket());
            return BoxedUnit.UNIT;
        });
        this.throttledSockets().clear();
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = this.socketServer().socketFactory().openServerSocket(this.endPoint().listener(), socketAddress, listenBacklogSize, Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        this.info((Function0<String>)(Function0 & Serializable)() -> "Awaiting socket connections on " + socketAddress.getHostString() + ":" + serverChannel.socket().getLocalPort() + ".");
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        ListenerName listenerName = ListenerName.normalised((String)this.endPoint().listener());
        try {
            this.connectionQuotas().inc(listenerName, socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Rejected connection from " + e$3.ip + ", address already has the configured maximum of " + e$3.count + " connections.");
            this.connectionQuotas().closeChannel(this, listenerName, socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Delaying closing of connection from " + ip + " for " + e$4.throttleTimeMs + " ms");
            long endThrottleTimeMs = e.startThrottleTimeMs + e.throttleTimeMs;
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, listenerName, socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$12)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing socket from ip " + closingSocket.socket().getRemoteAddress());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Accepted connection from " + socketChannel.socket().getRemoteSocketAddress() + " on " + socketChannel.socket().getLocalSocketAddress() + " and assigned it to processor " + processor.id() + ", sendBufferSize [actual|requested]: [" + socketChannel.socket().getSendBufferSize() + "|" + this.sendBufferSize() + "] recvBufferSize [actual|requested]: [" + socketChannel.socket().getReceiveBufferSize() + "|" + this.recvBufferSize() + "]");
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = ListenerName.normalised((String)this.endPoint().listener());
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol, this.socketServer().connectionDisconnectListeners());
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started().get()) {
                    processor.start();
                    return;
                }
            });
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.processors().$plus$plus$eq((IterableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol, Seq<ConnectionDisconnectListener> connectionDisconnectListeners) {
        String name = "data-plane-kafka-network-thread-" + this.nodeId + "-" + this.endPoint().listener() + "-" + this.endPoint().securityProtocol() + "-" + id;
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name, connectionDisconnectListeners);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1() {
        try {
            if (!this.shouldRun().get()) {
                throw new ClosedChannelException();
            }
            if (this.serverChannel() == null) {
                this.serverChannel_$eq(this.openServerSocket(this.endPoint().host(), this.endPoint().port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Opened endpoint " + this.endPoint().host() + ":" + this.endPoint().port());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting processors for listener " + this.endPoint().listener());
            this.processors().foreach((Function1 & Serializable)x$8 -> {
                x$8.start();
                return BoxedUnit.UNIT;
            });
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting acceptor thread for listener " + this.endPoint().listener());
            this.thread().start();
            this.startedFuture().complete(null);
            this.started().set(true);
            return BoxedUnit.UNIT;
        }
        catch (ClosedChannelException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Refusing to start acceptor for " + this.endPoint().listener() + " since the acceptor has already been shut down.");
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(e));
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to start acceptor for " + this.endPoint().listener(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(new RuntimeException("Unable to start acceptor for " + this.endPoint().listener(), t)));
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$12) {
        return x$12.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, Endpoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        int n;
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        if (endPoint.port() != 0) {
            n = endPoint.port();
        } else {
            this.serverChannel_$eq(this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
            int newPort = this.serverChannel().socket().getLocalPort();
            this.info((Function0<String>)(Function0 & Serializable)() -> "Opened wildcard endpoint " + this.endPoint().host() + ":" + newPort);
            n = newPort;
        }
        this.localPort = n;
        this.processors = new ArrayBuffer();
        this.backwardCompatibilityMetricGroup = new KafkaMetricsGroup("kafka.network", "Acceptor");
        this.blockedPercentMeterMetricName = this.backwardCompatibilityMetricGroup().metricName("AcceptorBlockedPercent", CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listener())}))).asJava());
        this.blockedPercentMeter = this.metricsGroup().newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.started = new AtomicBoolean();
        this.startedFuture = new CompletableFuture();
        String nonDaemon_name = "data-plane-kafka-socket-acceptor-" + endPoint.listener() + "-" + endPoint.securityProtocol() + "-" + endPoint.port();
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) break block3;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if ((socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

