/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.BrokerEndPoint$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerIdZNode$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005I3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)1\u0006\u0001C\u0001=!)Q\u0006\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0001=!)1\u0007\u0001C\u0001=!)Q\u0007\u0001C\u0001=!)q\u0007\u0001C\u0001=!)\u0011\b\u0001C\u0001=!)1\b\u0001C\u0005y\t\u0011\"I]8lKJ,e\u000e\u001a)pS:$H+Z:u\u0015\tqq\"A\u0004dYV\u001cH/\u001a:\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"A\u0007\u0002#Q,7\u000f\u001e%bg\"\fe\u000eZ#rk\u0006d7\u000fF\u0001 !\t!\u0002%\u0003\u0002\"+\t!QK\\5uQ\t\u00111\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005)!.\u001e8ji*\t\u0001&A\u0002pe\u001eL!AK\u0013\u0003\tQ+7\u000f^\u0001\u001ai\u0016\u001cHO\u0012:p[*\u001bxN\u001c$viV\u0014XMV3sg&|g\u000e\u000b\u0002\u0004G\u0005qA/Z:u\rJ|WNS:p]Z\u0013\u0004F\u0001\u0003$\u00039!Xm\u001d;Ge>l'j]8o-FB#!B\u0012\u0002\u001dQ,7\u000f\u001e$s_6T5o\u001c8Wg!\u0012aaI\u0001\u001bi\u0016\u001cHO\u0012:p[*\u001bxN\u001c,5/&$\bNT;mYJ\u000b7m\u001b\u0015\u0003\u000f\r\n\u0001\u0004^3ti\u001a\u0013x.\u001c&t_:4FgV5uQ:{'+Y2lQ\tA1%A\ruKN$(I]8lKJ,e\u000e\u001a9pS:$hI]8n+JL\u0007FA\u0005$\u0003M!Xm\u001d;F]\u0012\u0004x.\u001b8u\rJ|W.\u0016:jQ\tQ1%A\bqCJ\u001cXM\u0011:pW\u0016\u0014(j]8o)\ri\u0004)\u0012\t\u00039yJ!aP\u0007\u0003\r\t\u0013xn[3s\u0011\u0015\t5\u00021\u0001C\u0003\tIG\r\u0005\u0002\u0015\u0007&\u0011A)\u0006\u0002\u0004\u0013:$\b\"\u0002$\f\u0001\u00049\u0015A\u00036t_:\u001cFO]5oOB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"AS\u000b\u000e\u0003-S!\u0001T\t\u0002\rq\u0012xn\u001c;?\u0013\tqU#\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(\u0016\u0001")
public class BrokerEndPointTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testHashAndEquals() {
        void apply_elems;
        Integer n;
        Broker broker1 = TestUtils$.MODULE$.createBroker(1, "myhost", 9092, SecurityProtocol.PLAINTEXT);
        Broker broker2 = TestUtils$.MODULE$.createBroker(1, "myhost", 9092, SecurityProtocol.PLAINTEXT);
        Broker broker3 = TestUtils$.MODULE$.createBroker(2, "myhost", 1111, SecurityProtocol.PLAINTEXT);
        Broker broker4 = TestUtils$.MODULE$.createBroker(1, "other", 1111, SecurityProtocol.PLAINTEXT);
        Assert.assertEquals((Object)broker1, (Object)broker2);
        Assert.assertNotEquals((Object)broker1, (Object)broker3);
        Assert.assertNotEquals((Object)broker1, (Object)broker4);
        Assert.assertEquals((long)broker1.hashCode(), (long)broker2.hashCode());
        Assert.assertNotEquals((long)broker1.hashCode(), (long)broker3.hashCode());
        Assert.assertNotEquals((long)broker1.hashCode(), (long)broker4.hashCode());
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n2 = n = Integer.valueOf(1);
        n = null;
        Integer $minus$greater$extension_y = n2;
        Object var5_6 = null;
        objectArray[0] = new Tuple2((Object)broker1, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)new Some((Object)1), (Object)((MapOps)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).get((Object)broker1));
    }

    @Test
    public void testFromJsonFutureVersion() {
        String brokerInfoStr = "{\n      \"foo\":\"bar\",\n      \"version\":100,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"SSL://localhost:9093\"]\n    }";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        Assert.assertEquals((Object)"localhost", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9093L, (long)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV2() {
        String brokerInfoStr = "{\n      \"version\":2,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"PLAINTEXT://localhost:9092\"]\n    }";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        Assert.assertEquals((Object)"localhost", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9092L, (long)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV1() {
        String brokerInfoStr = "{\"jmx_port\":-1,\"timestamp\":\"1420485325400\",\"host\":\"172.16.8.243\",\"version\":1,\"port\":9091}";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        Assert.assertEquals((Object)"172.16.8.243", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9091L, (long)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV3() {
        String json = "{\n      \"version\":3,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"PLAINTEXT://host1:9092\", \"SSL://host1:9093\"],\n      \"rack\":\"dc1\"\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        Assert.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9093L, (long)brokerEndPoint.port());
        Assert.assertEquals((Object)new Some((Object)"dc1"), (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNullRack() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"},\n      \"rack\":null\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assert.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9092L, (long)brokerEndPoint.port());
        Assert.assertEquals((Object)None$.MODULE$, (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNoRack() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"}\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assert.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9092L, (long)brokerEndPoint.port());
        Assert.assertEquals((Object)None$.MODULE$, (Object)broker.rack());
    }

    @Test
    public void testBrokerEndpointFromUri() {
        String connectionString = "localhost:9092";
        BrokerEndPoint endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"localhost", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        connectionString = "local_host:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"local_host", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        connectionString = "[::1]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"::1", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        connectionString = "[fe80::b1da:69ca:57f7:63d8%3]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"fe80::b1da:69ca:57f7:63d8%3", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        connectionString = "MyHostname:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"MyHostname", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
    }

    @Test
    public void testEndpointFromUri() {
        String connectionString = "PLAINTEXT://localhost:9092";
        EndPoint endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"localhost", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://localhost:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://local_host:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"local_host", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://local_host:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertNull((Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://[::1]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"::1", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://[::1]:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"fe80::b1da:69ca:57f7:63d8%3", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://MyHostname:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"MyHostname", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://MyHostname:9092", (Object)endpoint.connectionString());
    }

    private Broker parseBrokerJson(int id, String jsonString) {
        return BrokerIdZNode$.MODULE$.decode(id, jsonString.getBytes(StandardCharsets.UTF_8)).broker();
    }
}

