/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\t\u0013\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!A\u0004A!A!\u0002\u0013I\u0004\"\u0002\u001f\u0001\t\u0003i\u0004b\u0002#\u0001\u0005\u0004%I!\u0012\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002$\t\u000b5\u0003A\u0011\t(\t\u000b\t\u0004A\u0011B2\t\u000b!\u0004A\u0011B5\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\u0012QCW6SKBd\u0017nY1Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0014)\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0012!B;uS2\u001c\u0018BA\u0011\u001f\u0005\u001daunZ4j]\u001e\faaY8oM&<\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0015\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001&\n\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\"!G\u0016\n\u00051\u0012\"!E*uCR,7\t[1oO\u0016dunZ4fe\u0006\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u0005ey\u0013B\u0001\u0019\u0013\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\tu.\u001cE.[3oiB\u00111GN\u0007\u0002i)\u0011Q\u0007F\u0001\u0003u.L!a\u000e\u001b\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003q\u0019wN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\"!\u0007\u001e\n\u0005m\u0012\"\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u0001\u0007y%t\u0017\u000e\u001e \u0015\ryz\u0004)\u0011\"D!\tI\u0002\u0001C\u0003#\r\u0001\u00071\u0005C\u0003*\r\u0001\u0007!\u0006C\u0003.\r\u0001\u0007a\u0006C\u00032\r\u0001\u0007!\u0007C\u00039\r\u0001\u0007\u0011(\u0001\u0007d_:$(o\u001c7mKJLE-F\u0001G!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\rIe\u000e^\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0004\u001fJk\u0006CA$Q\u0013\t\t\u0006J\u0001\u0003V]&$\b\"B*\n\u0001\u0004!\u0016\u0001\u0003:fa2L7-Y:\u0011\u0007UC&,D\u0001W\u0015\t9\u0006*\u0001\u0006d_2dWm\u0019;j_:L!!\u0017,\u0003\u0007M+\u0017\u000f\u0005\u0002\u001a7&\u0011AL\u0005\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\u0006=&\u0001\raX\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0005\u0002\u001aA&\u0011\u0011M\u0005\u0002\r%\u0016\u0004H.[2b'R\fG/Z\u0001\u0015I>D\u0015M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:\u0015\t=#gm\u001a\u0005\u0006K*\u0001\rAR\u0001\ne\u0016\u0004H.[2b\u0013\u0012DQa\u0015\u0006A\u0002QCQA\u0018\u0006A\u0002}\u000bQC]3n_Z,'+\u001a9mS\u000e\f7O\u0012:p[&\u001b(\u000fF\u0003k\u0003\u000f\tI\u0001E\u0003leV\f\tA\u0004\u0002maB\u0011Q\u000eS\u0007\u0002]*\u0011qNF\u0001\u0007yI|w\u000e\u001e \n\u0005ED\u0015A\u0002)sK\u0012,g-\u0003\u0002ti\n\u0019Q*\u00199\u000b\u0005ED\u0005C\u0001<\u007f\u001b\u00059(B\u0001=z\u0003\u0019\u0019w.\\7p]*\u0011QC\u001f\u0006\u0003wr\fa!\u00199bG\",'\"A?\u0002\u0007=\u0014x-\u0003\u0002\u0000o\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007cA\r\u0002\u0004%\u0019\u0011Q\u0001\n\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u0015)7\u00021\u0001G\u0011\u001d\tYa\u0003a\u0001\u0003\u001b\t!\u0002]1si&$\u0018n\u001c8t!\r)\u0006,^\u0001\u0018I>\u0014V-\\8wKJ+\u0007\u000f\\5dCN4%o\\7JgJ$b!a\u0005\u00024\u0005U\u0002cB$\u0002\u0016\u0005e\u0011QB\u0005\u0004\u0003/A%A\u0002+va2,'\u0007E\u0003leV\fY\u0002\u0005\u0005\u0002\u001e\u0005\u001d\u0012QFA\u0001\u001d\u0011\ty\"a\t\u000f\u00075\f\t#C\u0001J\u0013\r\t)\u0003S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI#a\u000b\u0003\r\u0015KG\u000f[3s\u0015\r\t)\u0003\u0013\t\u0005\u0003;\ty#\u0003\u0003\u00022\u0005-\"!C#yG\u0016\u0004H/[8o\u0011\u0015)G\u00021\u0001G\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001b\tQdZ3u)>\u0004\u0018n\u0019)beRLG/[8o'R\fG/Z:Ge>l'l\u001b\u000b\u0005\u0003w\ti\u0005E\u0004H\u0003+\ti$!\u0004\u0011\u000b-\u0014X/a\u0010\u0011\u0011\u0005u\u0011qEA\u0017\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\"\u0012aA1qS&!\u00111JA#\u00051aU-\u00193fe\u0006sG-S:s\u0011\u001d\tY!\u0004a\u0001\u0003\u001b\tq\u0003\\8h'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8\u0015\u0017=\u000b\u0019&a\u0016\u0002Z\u0005u\u0013\u0011\r\u0005\u0007\u0003+r\u0001\u0019\u0001\u0016\u0002\r1|wmZ3s\u0011\u0015)g\u00021\u0001G\u0011\u0019\tYF\u0004a\u0001k\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\u0007\u0003?r\u0001\u0019A0\u0002\u0013\r,(O]*uCR,\u0007\"\u00020\u000f\u0001\u0004y\u0016\u0001\u00067pO&sg/\u00197jIR\u0013\u0018M\\:ji&|g\u000eF\u0003P\u0003O\nY\u0007\u0003\u0004\u0002j=\u0001\rAW\u0001\be\u0016\u0004H.[2b\u0011\u0015qv\u00021\u0001`\u0003Qawn\u001a$bS2,Gm\u0015;bi\u0016\u001c\u0005.\u00198hKRIq*!\u001d\u0002t\u0005U\u0014q\u000f\u0005\u0007\u0003S\u0002\u0002\u0019\u0001.\t\r\u0005}\u0003\u00031\u0001`\u0011\u0015q\u0006\u00031\u0001`\u0011\u001d\tI\b\u0005a\u0001\u0003w\n\u0011\u0001\u001e\t\u0005\u0003;\ti(\u0003\u0003\u0002\u0000\u0005-\"!\u0003+ie><\u0018M\u00197f\u0001")
public class ZkReplicaStateMachine
extends ReplicaStateMachine {
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;

    private int controllerId() {
        return this.controllerId;
    }

    @Override
    public void handleStateChanges(Seq<PartitionAndReplica> replicas, ReplicaState targetState) {
        if (replicas.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                replicas.groupBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.replica())).foreach((Function1 & Serializable)x0$1 -> {
                    ZkReplicaStateMachine.$anonfun$handleStateChanges$2(this, targetState, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
                return;
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Controller moved to another broker when moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Error while moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doHandleStateChanges(int replicaId, Seq<PartitionAndReplica> replicas, ReplicaState targetState) {
        void var7_7;
        void var8_8;
        StateChangeLogger stateLogger = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        boolean traceEnabled = stateLogger.isTraceEnabled();
        replicas.foreach((Function1 & Serializable)replica -> {
            this.controllerContext.putReplicaStateIfNotExists(replica, NonExistentReplica$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2<Seq<PartitionAndReplica>, Seq<PartitionAndReplica>> tuple2 = this.controllerContext.checkValidReplicaStateChange(replicas, targetState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq validReplicas = (Seq)tuple2._1();
        Seq invalidReplicas = (Seq)tuple2._2();
        var8_8.foreach((Function1 & Serializable)replica -> {
            this.logInvalidTransition(replica, targetState);
            return BoxedUnit.UNIT;
        });
        if (NewReplica$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$3(this, replicaId, traceEnabled, stateLogger, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (OnlineReplica$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$4(this, replicaId, traceEnabled, stateLogger, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (OfflineReplica$.MODULE$.equals(targetState)) {
            void var11_11;
            void var10_10;
            var7_7.foreach((Function1 & Serializable)replica -> {
                this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId}))), replica.topicPartition(), false);
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple22 = var7_7.partition((Function1 & Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaStateMachine.$anonfun$doHandleStateChanges$7(this, replica)));
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Seq replicasWithLeadershipInfo = (Seq)tuple22._1();
            Seq replicasWithoutLeadershipInfo = (Seq)tuple22._2();
            this.removeReplicasFromIsr(replicaId, (Seq<TopicPartition>)((Seq)var10_10.map((Function1 & Serializable)x$5 -> x$5.topicPartition()))).foreach((Function1 & Serializable)x0$1 -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$9(this, stateLogger, replicaId, traceEnabled, x0$1);
                return BoxedUnit.UNIT;
            });
            var11_11.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$12(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionStarted$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$13(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionIneligible$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$14(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionSuccessful$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$15(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (NonExistentReplica$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$16(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)targetState);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> removeReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        ObjectRef objectRef;
        Map.EmptyMap$ emptyMap$;
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        Map.EmptyMap$ emptyMap$2 = emptyMap$ = Map.EmptyMap$.MODULE$;
        emptyMap$ = null;
        Map.EmptyMap$ create_e = emptyMap$2;
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e);
        Object var8_4 = null;
        objectRef = null;
        ObjectRef results = objectRef2;
        Seq<TopicPartition> remaining = partitions;
        while (remaining.nonEmpty()) {
            void var6_9;
            void var7_10;
            Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderIsrAndControllerEpoch>>, Seq<TopicPartition>> tuple2 = this.doRemoveReplicasFromIsr(replicaId, remaining);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            scala.collection.immutable.Map finishedRemoval = (scala.collection.immutable.Map)tuple2._1();
            Seq removalsToRetry = (Seq)tuple2._2();
            remaining = var7_10;
            var6_9.foreach((Function1 & Serializable)x0$1 -> {
                ZkReplicaStateMachine.$anonfun$removeReplicasFromIsr$1(this, replicaId, results, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return (scala.collection.immutable.Map)results.elem;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderIsrAndControllerEpoch>>, Seq<TopicPartition>> doRemoveReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        void var12_12;
        void var11_11;
        void var8_8;
        void var5_5;
        void var7_7;
        void var4_4;
        Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> tuple2 = this.getTopicPartitionStatesFromZk(partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map leaderAndIsrs = (scala.collection.immutable.Map)tuple2._1();
        Seq partitionsWithNoLeaderAndIsrInZk = (Seq)tuple2._2();
        Tuple2 tuple22 = var4_4.partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$1(replicaId, x0$1)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map leaderAndIsrsWithReplica = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map leaderAndIsrsWithoutReplica = (scala.collection.immutable.Map)tuple22._2();
        scala.collection.immutable.Map adjustedLeaderAndIsrs = (scala.collection.immutable.Map)var7_7.flatMap((Function1 & Serializable)x0$2 -> {
            None$ none$;
            if (x0$2 != null) {
                TopicPartition partition = (TopicPartition)x0$2._1();
                Option option = ((Either)x0$2._2()).toOption();
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                if (map_this.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)map_this.get();
                    none$ = new Some((Object)ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$5(replicaId, partition, leaderAndIsr));
                }
            } else {
                throw new MatchError(null);
            }
            None$ none$2 = none$;
            Object var4_3 = null;
            none$ = null;
            None$ none$3 = none$2;
            return none$3;
        });
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError(null);
        }
        Map<TopicPartition, Either<Exception, LeaderAndIsr>> finishedPartitions = updateLeaderAndIsrResult.finishedPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        scala.collection.immutable.Map exceptionsForPartitionsWithNoLeaderAndIsrInZk = var5_5.iterator().flatMap((Function1 & Serializable)partition -> {
            if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
                Left left;
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(26).append(new StringBuilder(75).append("Failed to change state of replica ").append(replicaId).append(" for partition ").append(partition).append(" since the leader and isr ").toString()).append("path in zookeeper is empty").toString());
                if (package$.MODULE$.Left() == null) {
                    throw null;
                }
                Left left2 = left = new Left((Object)exception);
                left = null;
                Left $minus$greater$extension_y = left2;
                Object var4_5 = null;
                return Option$.MODULE$.apply((Object)new Tuple2(partition, (Object)$minus$greater$extension_y));
            }
            return None$.MODULE$;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = (scala.collection.immutable.Map)((MapOps)var8_8.$plus$plus((IterableOnce)var11_11)).map((Function1 & Serializable)x0$3 -> {
            Either either;
            TopicPartition partition;
            if (x0$3 != null) {
                partition = (TopicPartition)x0$3._1();
                Either result = (Either)x0$3._2();
                if (result == null) {
                    throw null;
                }
                if (result instanceof Right) {
                    Object map_b = ((Right)result).value();
                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)map_b;
                    either = new Right((Object)ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$9(this, partition, leaderAndIsr));
                } else {
                    either = result;
                }
            } else {
                throw new MatchError(null);
            }
            Either either2 = either;
            either = null;
            Object var6_4 = null;
            Tuple2 tuple2 = new Tuple2((Object)partition, (Object)either2);
            return tuple2;
        });
        return new Tuple2((Object)leaderIsrAndControllerEpochs.$plus$plus((IterableOnce)exceptionsForPartitionsWithNoLeaderAndIsrInZk), (Object)var12_12);
    }

    private Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> getTopicPartitionStatesFromZk(Seq<TopicPartition> partitions) {
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple2((Object)partitions.iterator().map((Function1 & Serializable)x$12 -> {
                Left left;
                if (package$.MODULE$.Left() == null) {
                    throw null;
                }
                Left left2 = left = new Left((Object)e);
                left = null;
                Left $minus$greater$extension_y = left2;
                return new Tuple2(x$12, (Object)$minus$greater$extension_y);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Seq$.MODULE$.empty());
        }
        Seq<GetDataResponse> getDataResponses = seq;
        Buffer partitionsWithNoLeaderAndIsrInZk = (Buffer)Buffer$.MODULE$.empty();
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable)getDataResponse -> {
            ZkReplicaStateMachine.$anonfun$getTopicPartitionStatesFromZk$2(this, partitionsWithNoLeaderAndIsrInZk, result, getDataResponse);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)partitionsWithNoLeaderAndIsrInZk);
    }

    private void logSuccessfulTransition(StateChangeLogger logger, int replicaId, TopicPartition partition, ReplicaState currState, ReplicaState targetState) {
        logger.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Changed state of replica ").append(replicaId).append(" for partition ").append(partition).append(" from ").append(currState).append(" to ").append(targetState).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void logInvalidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        void mkString_sep;
        ReplicaState currState = this.controllerContext.replicaState(replica);
        scala.collection.immutable.Set<ReplicaState> set = targetState.validPreviousStates();
        String string = ",";
        if (set == null) {
            throw null;
        }
        string = null;
        IllegalStateException e = new IllegalStateException(new StringBuilder(0).append(new StringBuilder(27).append("Replica ").append(replica).append(" should be in the ").append(set.mkString("", (String)mkString_sep, "")).append(" ").toString()).append(new StringBuilder(55).append("states before moving to ").append(targetState).append(" state. Instead it is in ").append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(replica, currState, targetState, e);
    }

    private void logFailedStateChange(PartitionAndReplica replica, ReplicaState currState, ReplicaState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(54).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" initiated state change of replica ").append(replica.replica()).append(" ").toString()).append(new StringBuilder(31).append("for partition ").append(replica.topicPartition()).append(" from ").append(currState).append(" to ").append(targetState).append(" failed").toString()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$handleStateChanges$2(ZkReplicaStateMachine $this, ReplicaState targetState$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int replicaId = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            $this.doHandleStateChanges(replicaId, (Seq<PartitionAndReplica>)replicas, targetState$1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$3(ZkReplicaStateMachine $this, int replicaId$1, boolean traceEnabled$1, StateChangeLogger stateLogger$1, PartitionAndReplica replica) {
        TopicPartition partition = replica.topicPartition();
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        Option option = $this.controllerContext.partitionLeadershipInfo().get((Object)partition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
            if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId$1) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Replica ").append(replicaId$1).append(" for partition ").append(partition).append(" cannot be moved to NewReplica state as it is being requested to become leader").toString());
                $this.logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, exception);
                return;
            }
            $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId$1}))), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(replica.topicPartition()), true);
            if (traceEnabled$1) {
                $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, NewReplica$.MODULE$);
            }
            $this.controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (traceEnabled$1) {
                $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, NewReplica$.MODULE$);
            }
            $this.controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$doHandleStateChanges$4(ZkReplicaStateMachine $this, int replicaId$1, boolean traceEnabled$1, StateChangeLogger stateLogger$1, PartitionAndReplica replica) {
        TopicPartition partition = replica.topicPartition();
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (NewReplica$.MODULE$.equals(currentState)) {
            ReplicaAssignment assignment = $this.controllerContext.partitionFullReplicaAssignment(partition);
            if (!assignment.replicas().contains((Object)replicaId$1)) {
                void $colon$plus_elem;
                Integer n;
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Adding replica (").append(replicaId$1).append(") that is not part of the assignment ").append(assignment).toString());
                Seq<Object> seq = assignment.replicas();
                Integer n2 = n = Integer.valueOf(replicaId$1);
                n = null;
                Integer n3 = n2;
                if (seq == null) {
                    throw null;
                }
                n3 = null;
                ReplicaAssignment newAssignment = assignment.copy((Seq<Object>)((Seq)seq.appended((Object)$colon$plus_elem)), assignment.copy$default$2(), assignment.copy$default$3());
                $this.controllerContext.updatePartitionFullReplicaAssignment(partition, newAssignment);
            }
        } else {
            Option option = $this.controllerContext.partitionLeadershipInfo().get((Object)partition);
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId$1}))), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), false);
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
        }
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, OnlineReplica$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, OnlineReplica$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$7(ZkReplicaStateMachine $this, PartitionAndReplica replica) {
        return $this.controllerContext.partitionLeadershipInfo().contains((Object)replica.topicPartition());
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$9(ZkReplicaStateMachine $this, StateChangeLogger stateLogger$1, int replicaId$1, boolean traceEnabled$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)x0$1._2();
            stateLogger$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(91).append("Partition ").append(partition).append(" state changed to ").append(leaderIsrAndControllerEpoch).append(" after removing replica ").append(replicaId$1).append(" from the ISR as part of transition to ").append(OfflineReplica$.MODULE$).toString());
            if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
                Seq recipients = (Seq)$this.controllerContext.partitionReplicaAssignment(partition).filterNot((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 == replicaId$1);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)recipients, partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), false);
            }
            PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$1);
            ReplicaState currentState = $this.controllerContext.replicaState(replica);
            if (traceEnabled$1) {
                $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, OfflineReplica$.MODULE$);
            }
            $this.controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$doHandleStateChanges$12(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        void apply_elems;
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, OfflineReplica$.MODULE$);
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{replica.topicPartition()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.controllerBrokerRequestBatch.addUpdateMetadataRequestForBrokers((Seq<Object>)$this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)));
        $this.controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$13(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionStarted$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionStarted$.MODULE$);
        $this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId$1}))), replica.topicPartition(), true);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$14(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionIneligible$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$15(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionSuccessful$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionSuccessful$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$16(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        ReplicaAssignment newAssignedReplicas = $this.controllerContext.partitionFullReplicaAssignment(replica.topicPartition()).removeReplica(replica.replica());
        $this.controllerContext.updatePartitionFullReplicaAssignment(replica.topicPartition(), newAssignedReplicas);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, NonExistentReplica$.MODULE$);
        }
        $this.controllerContext.removeReplicaState(replica);
    }

    public static final /* synthetic */ void $anonfun$removeReplicasFromIsr$1(ZkReplicaStateMachine $this, int replicaId$2, ObjectRef results$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Left) {
                Exception e = (Exception)((Left)either).value();
                PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$2);
                ReplicaState currentState = $this.controllerContext.replicaState(replica);
                $this.logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, e);
                return;
            }
        }
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Right) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Right)either).value();
                results$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)results$1.elem).$plus(new Tuple2((Object)partition, (Object)leaderIsrAndEpoch));
                return;
            }
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$2(int replicaId$3, LeaderAndIsr leaderAndIsr) {
        return leaderAndIsr.isr().contains((Object)replicaId$3);
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$3() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$1(int replicaId$3, Tuple2 x0$1) {
        Either either;
        if (x0$1 != null) {
            Either result = (Either)x0$1._2();
            if (result == null) {
                throw null;
            }
            if (result instanceof Right) {
                Object map_b = ((Right)result).value();
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)map_b;
                either = new Right((Object)ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$2(replicaId$3, leaderAndIsr));
            } else {
                either = result;
            }
        } else {
            throw new MatchError(null);
        }
        Either either2 = either;
        either = null;
        Object var5_3 = null;
        Either getOrElse_this = either2;
        Object object = getOrElse_this instanceof Right ? ((Right)getOrElse_this).value() : Boolean.valueOf(false);
        Object object2 = object;
        Object var6_6 = null;
        object = null;
        boolean bl = BoxesRunTime.unboxToBoolean((Object)object2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$6(int replicaId$3, int x$10) {
        return x$10 != replicaId$3;
    }

    public static final /* synthetic */ Tuple2 $anonfun$doRemoveReplicasFromIsr$5(int replicaId$3, TopicPartition partition$3, LeaderAndIsr leaderAndIsr) {
        List<Object> list;
        int newLeader = replicaId$3 == leaderAndIsr.leader() ? LeaderAndIsr$.MODULE$.NoLeader() : leaderAndIsr.leader();
        List<Object> list2 = leaderAndIsr.isr();
        if (list2 == null) {
            throw null;
        }
        if (SeqOps.size$(list2) == 1) {
            list = leaderAndIsr.isr();
        } else {
            Object var8_22;
            Nil$ nil$;
            Object var13_11;
            Object var12_10;
            List list3;
            Object var21_19;
            Object var20_18;
            Object var19_17;
            Object var18_16;
            Object var17_15;
            Object var16_14;
            Object var15_13;
            Object var14_12;
            Nil$ nil$2;
            List list4 = leaderAndIsr.isr();
            if (list4 == null) {
                throw null;
            }
            List filter_this = list4;
            boolean filter_filterCommon_isFlipped = false;
            List filter_filterCommon_noneIn$1_l = filter_this;
            while (true) {
                if (filter_filterCommon_noneIn$1_l.isEmpty()) {
                    nil$2 = Nil$.MODULE$;
                    break;
                }
                Object filter_filterCommon_noneIn$1_h = filter_filterCommon_noneIn$1_l.head();
                List filter_filterCommon_noneIn$1_t = (List)filter_filterCommon_noneIn$1_l.tail();
                int n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_h);
                if (ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$6(replicaId$3, n) != filter_filterCommon_isFlipped) {
                    List list5;
                    block14: {
                        List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next;
                        List filter_filterCommon_noneIn$1_allIn$1_remaining = filter_filterCommon_noneIn$1_t;
                        while (true) {
                            if (filter_filterCommon_noneIn$1_allIn$1_remaining.isEmpty()) {
                                list5 = filter_filterCommon_noneIn$1_l;
                                break block14;
                            }
                            Object filter_filterCommon_noneIn$1_allIn$1_x = filter_filterCommon_noneIn$1_allIn$1_remaining.head();
                            n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_allIn$1_x);
                            if (ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$6(replicaId$3, n) == filter_filterCommon_isFlipped) break;
                            filter_filterCommon_noneIn$1_allIn$1_remaining = (List)filter_filterCommon_noneIn$1_allIn$1_remaining.tail();
                        }
                        .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead = new .colon.colon(filter_filterCommon_noneIn$1_l.head(), (List)Nil$.MODULE$);
                        .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead;
                        for (List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterCommon_noneIn$1_l.tail(); filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess != filter_filterCommon_noneIn$1_allIn$1_remaining; filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.tail()) {
                            .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.head(), (List)Nil$.MODULE$);
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                        }
                        List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_remaining.tail();
                        while (!filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.isEmpty()) {
                            Object filter_filterCommon_noneIn$1_allIn$1_partialFill$1_head = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.head();
                            n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_head);
                            if (ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$6(replicaId$3, n) != filter_filterCommon_isFlipped) {
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                                continue;
                            }
                            while (filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy != filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next) {
                                .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.head(), (List)Nil$.MODULE$);
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.tail();
                            }
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                        }
                        if (!filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.isEmpty()) {
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy);
                        }
                        list5 = var14_12;
                        var14_12 = null;
                        var15_13 = null;
                        var16_14 = null;
                        var17_15 = null;
                        var18_16 = null;
                        var19_17 = null;
                        var20_18 = null;
                        var21_19 = null;
                    }
                    list3 = list5;
                    nil$2 = list3;
                    var12_10 = null;
                    var13_11 = null;
                    var14_12 = null;
                    var15_13 = null;
                    var16_14 = null;
                    var17_15 = null;
                    var18_16 = null;
                    var19_17 = null;
                    var20_18 = null;
                    var21_19 = null;
                    list3 = null;
                    break;
                }
                filter_filterCommon_noneIn$1_l = filter_filterCommon_noneIn$1_t;
            }
            Nil$ nil$3 = nil$ = nil$2;
            Object var9_6 = null;
            Object var10_8 = null;
            Object var11_9 = null;
            var12_10 = null;
            var13_11 = null;
            var14_12 = null;
            var15_13 = null;
            var16_14 = null;
            var17_15 = null;
            var18_16 = null;
            var19_17 = null;
            var20_18 = null;
            var21_19 = null;
            list3 = null;
            nil$ = null;
            Nil$ filter_filterCommon_result = nil$3;
            Statics.releaseFence();
            list = var8_22;
            Object var6_4 = null;
            var8_22 = null;
        }
        List<Object> adjustedIsr = list;
        LeaderAndIsr $minus$greater$extension_y = leaderAndIsr.newLeaderAndIsr(newLeader, adjustedIsr);
        return new Tuple2((Object)partition$3, (Object)$minus$greater$extension_y);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LeaderIsrAndControllerEpoch $anonfun$doRemoveReplicasFromIsr$9(ZkReplicaStateMachine $this, TopicPartition partition$4, LeaderAndIsr leaderAndIsr) {
        void var3_3;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
        $this.controllerContext.partitionLeadershipInfo().put((Object)partition$4, (Object)leaderIsrAndControllerEpoch);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$getTopicPartitionStatesFromZk$2(ZkReplicaStateMachine $this, Buffer partitionsWithNoLeaderAndIsrInZk$1, scala.collection.mutable.Map result$1, GetDataResponse getDataResponse) {
        void $plus$eq_elem;
        Tuple2 tuple2;
        void apply_value;
        Left left;
        TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
        KeeperException.Code code = getDataResponse.resultCode();
        KeeperException.Code code2 = KeeperException.Code.OK;
        if (!(code != null ? !code.equals(code2) : code2 != null)) {
            Option<LeaderIsrAndControllerEpoch> option = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
            if (None$.MODULE$.equals(option)) {
                if (partitionsWithNoLeaderAndIsrInZk$1 == null) {
                    throw null;
                }
                partitionsWithNoLeaderAndIsrInZk$1.addOne((Object)partition);
                return;
            }
            if (option instanceof Some) {
                void $plus$eq_elem2;
                Tuple2 tuple22;
                void apply_value2;
                Right right;
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                    void $plus$eq_elem3;
                    Tuple2 tuple23;
                    Left left2;
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(96).append("Leader and isr path written by another controller. This probably ").append(new StringBuilder(73).append("means the current controller with epoch ").append($this.controllerContext.epoch()).append(" went through a soft failure and ").toString()).append(new StringBuilder(53).append("another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(". Aborting ").toString()).append("state change by this controller").toString());
                    if (package$.MODULE$.Left() == null) {
                        throw null;
                    }
                    Left left3 = left2 = new Left((Object)exception);
                    left2 = null;
                    Left $minus$greater$extension_y = left3;
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)partition, (Object)$minus$greater$extension_y);
                    Object var10_10 = null;
                    tuple23 = null;
                    Tuple2 tuple25 = tuple24;
                    if (result$1 == null) {
                        throw null;
                    }
                    result$1.addOne((Object)$plus$eq_elem3);
                    return;
                }
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                if (package$.MODULE$.Right() == null) {
                    throw null;
                }
                Right right2 = right = new Right((Object)apply_value2);
                leaderAndIsr = null;
                right = null;
                Right $minus$greater$extension_y = right2;
                Tuple2 tuple26 = tuple22 = new Tuple2((Object)partition, (Object)$minus$greater$extension_y);
                Object var13_15 = null;
                tuple22 = null;
                Tuple2 tuple27 = tuple26;
                if (result$1 == null) {
                    throw null;
                }
                result$1.addOne((Object)$plus$eq_elem2);
                return;
            }
            throw new MatchError(option);
        }
        KeeperException.Code code3 = getDataResponse.resultCode();
        KeeperException.Code code4 = KeeperException.Code.NONODE;
        if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
            if (partitionsWithNoLeaderAndIsrInZk$1 == null) {
                throw null;
            }
            partitionsWithNoLeaderAndIsrInZk$1.addOne((Object)partition);
            return;
        }
        Object object = getDataResponse.resultException().get();
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        Left left4 = left = new Left((Object)apply_value);
        object = null;
        left = null;
        Left $minus$greater$extension_y = left4;
        Tuple2 tuple28 = tuple2 = new Tuple2((Object)partition, (Object)$minus$greater$extension_y);
        Object var16_21 = null;
        tuple2 = null;
        Tuple2 tuple29 = tuple28;
        if (result$1 == null) {
            throw null;
        }
        result$1.addOne((Object)$plus$eq_elem);
    }

    public ZkReplicaStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(36).append("[ReplicaStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }

    public static final /* synthetic */ Object $anonfun$doRemoveReplicasFromIsr$2$adapted(int replicaId$3, LeaderAndIsr leaderAndIsr) {
        return BoxesRunTime.boxToBoolean((boolean)ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$2(replicaId$3, leaderAndIsr));
    }
}

