/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_1_IV0$;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_3_IV0$;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupTopicPartition;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.Stable$;
import kafka.utils.Json$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class GroupMetadataManager$ {
    public static final GroupMetadataManager$ MODULE$;
    private static final String MetricsGroup;
    private static final String LoadTimeSensor;
    private static final short CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    private static final short CURRENT_GROUP_KEY_SCHEMA_VERSION;
    private static final Schema OFFSET_COMMIT_KEY_SCHEMA;
    private static final BoundField OFFSET_KEY_GROUP_FIELD;
    private static final BoundField OFFSET_KEY_TOPIC_FIELD;
    private static final BoundField OFFSET_KEY_PARTITION_FIELD;
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0;
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V0;
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V0;
    private static final BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1;
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V1;
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V1;
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    private static final BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V2;
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V2;
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V2;
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    private static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V3;
    private static final BoundField OFFSET_VALUE_OFFSET_FIELD_V3;
    private static final BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    private static final BoundField OFFSET_VALUE_METADATA_FIELD_V3;
    private static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    private static final Schema GROUP_METADATA_KEY_SCHEMA;
    private static final BoundField GROUP_KEY_GROUP_FIELD;
    private static final String MEMBER_ID_KEY;
    private static final String GROUP_INSTANCE_ID_KEY;
    private static final String CLIENT_ID_KEY;
    private static final String CLIENT_HOST_KEY;
    private static final String REBALANCE_TIMEOUT_KEY;
    private static final String SESSION_TIMEOUT_KEY;
    private static final String SUBSCRIPTION_KEY;
    private static final String ASSIGNMENT_KEY;
    private static final Schema MEMBER_METADATA_V0;
    private static final Schema MEMBER_METADATA_V1;
    private static final Schema MEMBER_METADATA_V2;
    private static final Schema MEMBER_METADATA_V3;
    private static final String PROTOCOL_TYPE_KEY;
    private static final String GENERATION_KEY;
    private static final String PROTOCOL_KEY;
    private static final String LEADER_KEY;
    private static final String CURRENT_STATE_TIMESTAMP_KEY;
    private static final String MEMBERS_KEY;
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V0;
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V1;
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V2;
    private static final Schema GROUP_METADATA_VALUE_SCHEMA_V3;
    private static final Map<Object, Schema> MESSAGE_TYPE_SCHEMAS;
    private static final Map<Object, Schema> OFFSET_VALUE_SCHEMAS;
    private static final Map<Object, Schema> GROUP_VALUE_SCHEMAS;
    private static final Schema CURRENT_OFFSET_KEY_SCHEMA;
    private static final Schema CURRENT_GROUP_KEY_SCHEMA;
    private static final int CURRENT_GROUP_METADATA_VALUE_SCHEMA_VERSION;

    /*
     * WARNING - void declaration
     */
    static {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_y9;
        MODULE$ = new GroupMetadataManager$();
        MetricsGroup = "group-coordinator-metrics";
        LoadTimeSensor = "GroupPartitionLoadTime";
        CURRENT_OFFSET_KEY_SCHEMA_VERSION = (short)1;
        CURRENT_GROUP_KEY_SCHEMA_VERSION = (short)2;
        OFFSET_COMMIT_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING), new Field("topic", (Type)Type.STRING), new Field("partition", (Type)Type.INT32)});
        OFFSET_KEY_GROUP_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("group");
        OFFSET_KEY_TOPIC_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("topic");
        OFFSET_KEY_PARTITION_FIELD = MODULE$.OFFSET_COMMIT_KEY_SCHEMA().get("partition");
        OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("timestamp", (Type)Type.INT64)});
        OFFSET_VALUE_OFFSET_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
        OFFSET_VALUE_METADATA_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
        OFFSET_VALUE_TIMESTAMP_FIELD_V0 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
        OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64), new Field("expire_timestamp", (Type)Type.INT64)});
        OFFSET_VALUE_OFFSET_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("offset");
        OFFSET_VALUE_METADATA_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("metadata");
        OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("commit_timestamp");
        OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("expire_timestamp");
        OFFSET_COMMIT_VALUE_SCHEMA_V2 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64)});
        OFFSET_VALUE_OFFSET_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("offset");
        OFFSET_VALUE_METADATA_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("metadata");
        OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("commit_timestamp");
        OFFSET_COMMIT_VALUE_SCHEMA_V3 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("leader_epoch", (Type)Type.INT32), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64)});
        OFFSET_VALUE_OFFSET_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("offset");
        OFFSET_VALUE_LEADER_EPOCH_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("leader_epoch");
        OFFSET_VALUE_METADATA_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("metadata");
        OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("commit_timestamp");
        GROUP_METADATA_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING)});
        GROUP_KEY_GROUP_FIELD = MODULE$.GROUP_METADATA_KEY_SCHEMA().get("group");
        MEMBER_ID_KEY = "member_id";
        GROUP_INSTANCE_ID_KEY = "group_instance_id";
        CLIENT_ID_KEY = "client_id";
        CLIENT_HOST_KEY = "client_host";
        REBALANCE_TIMEOUT_KEY = "rebalance_timeout";
        SESSION_TIMEOUT_KEY = "session_timeout";
        SUBSCRIPTION_KEY = "subscription";
        ASSIGNMENT_KEY = "assignment";
        MEMBER_METADATA_V0 = new Schema(new Field[]{new Field(MODULE$.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(MODULE$.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        MEMBER_METADATA_V1 = new Schema(new Field[]{new Field(MODULE$.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(MODULE$.REBALANCE_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        MEMBER_METADATA_V2 = MODULE$.MEMBER_METADATA_V1();
        MEMBER_METADATA_V3 = new Schema(new Field[]{new Field(MODULE$.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.GROUP_INSTANCE_ID_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(MODULE$.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(MODULE$.REBALANCE_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(MODULE$.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(MODULE$.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        PROTOCOL_TYPE_KEY = "protocol_type";
        GENERATION_KEY = "generation";
        PROTOCOL_KEY = "protocol";
        LEADER_KEY = "leader";
        CURRENT_STATE_TIMESTAMP_KEY = "current_state_timestamp";
        MEMBERS_KEY = "members";
        GROUP_METADATA_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field(MODULE$.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(MODULE$.GENERATION_KEY(), (Type)Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.MEMBERS_KEY(), (Type)new ArrayOf((Type)MODULE$.MEMBER_METADATA_V0()))});
        GROUP_METADATA_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field(MODULE$.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(MODULE$.GENERATION_KEY(), (Type)Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.MEMBERS_KEY(), (Type)new ArrayOf((Type)MODULE$.MEMBER_METADATA_V1()))});
        GROUP_METADATA_VALUE_SCHEMA_V2 = new Schema(new Field[]{new Field(MODULE$.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(MODULE$.GENERATION_KEY(), (Type)Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.CURRENT_STATE_TIMESTAMP_KEY(), (Type)Type.INT64), new Field(MODULE$.MEMBERS_KEY(), (Type)new ArrayOf((Type)MODULE$.MEMBER_METADATA_V2()))});
        GROUP_METADATA_VALUE_SCHEMA_V3 = new Schema(new Field[]{new Field(MODULE$.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(MODULE$.GENERATION_KEY(), (Type)Type.INT32), new Field(MODULE$.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(MODULE$.CURRENT_STATE_TIMESTAMP_KEY(), (Type)Type.INT64), new Field(MODULE$.MEMBERS_KEY(), (Type)new ArrayOf((Type)MODULE$.MEMBER_METADATA_V3()))});
        Object[] objectArray = new Tuple2[3];
        Schema $minus$greater$extension_y10 = MODULE$.OFFSET_COMMIT_KEY_SCHEMA();
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)0);
        Object var0_1 = null;
        Object var1 = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)$minus$greater$extension_y10);
        Schema $minus$greater$extension_y11 = MODULE$.OFFSET_COMMIT_KEY_SCHEMA();
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)1);
        Object var2_3 = null;
        Object var3_2 = null;
        objectArray[1] = new Tuple2($minus$greater$extension_$this2, (Object)$minus$greater$extension_y11);
        Schema schema = MODULE$.GROUP_METADATA_KEY_SCHEMA();
        Object $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc((Object)2);
        Object var4_5 = null;
        schema = null;
        objectArray[2] = new Tuple2($minus$greater$extension_$this3, (Object)$minus$greater$extension_y9);
        MESSAGE_TYPE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[4];
        Schema schema2 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V0();
        Object $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc((Object)0);
        Object var6_7 = null;
        schema2 = null;
        objectArray2[0] = new Tuple2($minus$greater$extension_$this4, (Object)$minus$greater$extension_y8);
        Schema schema3 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V1();
        Object $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc((Object)1);
        Object var8_9 = null;
        schema3 = null;
        objectArray2[1] = new Tuple2($minus$greater$extension_$this5, (Object)$minus$greater$extension_y7);
        Schema schema4 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V2();
        Object $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc((Object)2);
        Object var10_11 = null;
        schema4 = null;
        objectArray2[2] = new Tuple2($minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        Schema schema5 = MODULE$.OFFSET_COMMIT_VALUE_SCHEMA_V3();
        Object $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc((Object)3);
        Object var12_13 = null;
        schema5 = null;
        objectArray2[3] = new Tuple2($minus$greater$extension_$this7, (Object)$minus$greater$extension_y5);
        OFFSET_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Object[] objectArray3 = new Tuple2[4];
        Schema schema6 = MODULE$.GROUP_METADATA_VALUE_SCHEMA_V0();
        Object $minus$greater$extension_$this8 = Predef$.MODULE$.ArrowAssoc((Object)0);
        Object var14_15 = null;
        schema6 = null;
        objectArray3[0] = new Tuple2($minus$greater$extension_$this8, (Object)$minus$greater$extension_y4);
        Schema schema7 = MODULE$.GROUP_METADATA_VALUE_SCHEMA_V1();
        Object $minus$greater$extension_$this9 = Predef$.MODULE$.ArrowAssoc((Object)1);
        Object var16_17 = null;
        schema7 = null;
        objectArray3[1] = new Tuple2($minus$greater$extension_$this9, (Object)$minus$greater$extension_y3);
        Schema schema8 = MODULE$.GROUP_METADATA_VALUE_SCHEMA_V2();
        Object $minus$greater$extension_$this10 = Predef$.MODULE$.ArrowAssoc((Object)2);
        Object var18_19 = null;
        schema8 = null;
        objectArray3[2] = new Tuple2($minus$greater$extension_$this10, (Object)$minus$greater$extension_y2);
        Schema schema9 = MODULE$.GROUP_METADATA_VALUE_SCHEMA_V3();
        Object $minus$greater$extension_$this11 = Predef$.MODULE$.ArrowAssoc((Object)3);
        Object var20_21 = null;
        schema9 = null;
        objectArray3[3] = new Tuple2($minus$greater$extension_$this11, (Object)$minus$greater$extension_y);
        GROUP_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        CURRENT_OFFSET_KEY_SCHEMA = MODULE$.schemaForKey(MODULE$.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        CURRENT_GROUP_KEY_SCHEMA = MODULE$.schemaForKey(MODULE$.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        CURRENT_GROUP_METADATA_VALUE_SCHEMA_VERSION = BoxesRunTime.unboxToInt((Object)MODULE$.GROUP_VALUE_SCHEMAS().keySet().max((Ordering)Ordering.Int$.MODULE$));
    }

    public String MetricsGroup() {
        return MetricsGroup;
    }

    public String LoadTimeSensor() {
        return LoadTimeSensor;
    }

    private short CURRENT_OFFSET_KEY_SCHEMA_VERSION() {
        return CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    }

    private short CURRENT_GROUP_KEY_SCHEMA_VERSION() {
        return CURRENT_GROUP_KEY_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA() {
        return OFFSET_COMMIT_KEY_SCHEMA;
    }

    private BoundField OFFSET_KEY_GROUP_FIELD() {
        return OFFSET_KEY_GROUP_FIELD;
    }

    private BoundField OFFSET_KEY_TOPIC_FIELD() {
        return OFFSET_KEY_TOPIC_FIELD;
    }

    private BoundField OFFSET_KEY_PARTITION_FIELD() {
        return OFFSET_KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V0() {
        return OFFSET_VALUE_OFFSET_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V0() {
        return OFFSET_VALUE_METADATA_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0() {
        return OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V1() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V1;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V1() {
        return OFFSET_VALUE_OFFSET_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V1() {
        return OFFSET_VALUE_METADATA_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1() {
        return OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V2() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V2;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V2() {
        return OFFSET_VALUE_OFFSET_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V2() {
        return OFFSET_VALUE_METADATA_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V3() {
        return OFFSET_COMMIT_VALUE_SCHEMA_V3;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V3() {
        return OFFSET_VALUE_OFFSET_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3() {
        return OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V3() {
        return OFFSET_VALUE_METADATA_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3() {
        return OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    }

    private Schema GROUP_METADATA_KEY_SCHEMA() {
        return GROUP_METADATA_KEY_SCHEMA;
    }

    private BoundField GROUP_KEY_GROUP_FIELD() {
        return GROUP_KEY_GROUP_FIELD;
    }

    private String MEMBER_ID_KEY() {
        return MEMBER_ID_KEY;
    }

    private String GROUP_INSTANCE_ID_KEY() {
        return GROUP_INSTANCE_ID_KEY;
    }

    private String CLIENT_ID_KEY() {
        return CLIENT_ID_KEY;
    }

    private String CLIENT_HOST_KEY() {
        return CLIENT_HOST_KEY;
    }

    private String REBALANCE_TIMEOUT_KEY() {
        return REBALANCE_TIMEOUT_KEY;
    }

    private String SESSION_TIMEOUT_KEY() {
        return SESSION_TIMEOUT_KEY;
    }

    private String SUBSCRIPTION_KEY() {
        return SUBSCRIPTION_KEY;
    }

    private String ASSIGNMENT_KEY() {
        return ASSIGNMENT_KEY;
    }

    private Schema MEMBER_METADATA_V0() {
        return MEMBER_METADATA_V0;
    }

    private Schema MEMBER_METADATA_V1() {
        return MEMBER_METADATA_V1;
    }

    private Schema MEMBER_METADATA_V2() {
        return MEMBER_METADATA_V2;
    }

    private Schema MEMBER_METADATA_V3() {
        return MEMBER_METADATA_V3;
    }

    private String PROTOCOL_TYPE_KEY() {
        return PROTOCOL_TYPE_KEY;
    }

    private String GENERATION_KEY() {
        return GENERATION_KEY;
    }

    private String PROTOCOL_KEY() {
        return PROTOCOL_KEY;
    }

    private String LEADER_KEY() {
        return LEADER_KEY;
    }

    private String CURRENT_STATE_TIMESTAMP_KEY() {
        return CURRENT_STATE_TIMESTAMP_KEY;
    }

    private String MEMBERS_KEY() {
        return MEMBERS_KEY;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V0() {
        return GROUP_METADATA_VALUE_SCHEMA_V0;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V1() {
        return GROUP_METADATA_VALUE_SCHEMA_V1;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V2() {
        return GROUP_METADATA_VALUE_SCHEMA_V2;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V3() {
        return GROUP_METADATA_VALUE_SCHEMA_V3;
    }

    private Map<Object, Schema> MESSAGE_TYPE_SCHEMAS() {
        return MESSAGE_TYPE_SCHEMAS;
    }

    private Map<Object, Schema> OFFSET_VALUE_SCHEMAS() {
        return OFFSET_VALUE_SCHEMAS;
    }

    private Map<Object, Schema> GROUP_VALUE_SCHEMAS() {
        return GROUP_VALUE_SCHEMAS;
    }

    private Schema CURRENT_OFFSET_KEY_SCHEMA() {
        return CURRENT_OFFSET_KEY_SCHEMA;
    }

    private Schema CURRENT_GROUP_KEY_SCHEMA() {
        return CURRENT_GROUP_KEY_SCHEMA;
    }

    private int CURRENT_GROUP_METADATA_VALUE_SCHEMA_VERSION() {
        return CURRENT_GROUP_METADATA_VALUE_SCHEMA_VERSION;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForKey(int version) {
        void var3_3;
        Option schemaOpt = this.MESSAGE_TYPE_SCHEMAS().get((Object)version);
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(35).append("Unknown message key schema version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForOffsetValue(int version) {
        void var3_3;
        Option schemaOpt = this.OFFSET_VALUE_SCHEMAS().get((Object)version);
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(30).append("Unknown offset schema version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForGroupValue(int version) {
        void var3_3;
        Option schemaOpt = this.GROUP_VALUE_SCHEMAS().get((Object)version);
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(31).append("Unknown group metadata version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    public byte[] offsetCommitKey(String group, TopicPartition topicPartition) {
        Struct key = new Struct(this.CURRENT_OFFSET_KEY_SCHEMA());
        key.set(this.OFFSET_KEY_GROUP_FIELD(), (Object)group);
        key.set(this.OFFSET_KEY_TOPIC_FIELD(), (Object)topicPartition.topic());
        key.set(this.OFFSET_KEY_PARTITION_FIELD(), (Object)topicPartition.partition());
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataKey(String group) {
        Struct key = new Struct(this.CURRENT_GROUP_KEY_SCHEMA());
        key.set(this.GROUP_KEY_GROUP_FIELD(), (Object)group);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    /*
     * Unable to fully structure code
     */
    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata, ApiVersion apiVersion) {
        if (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$)) ** GOTO lbl-1000
        v0 = offsetAndMetadata.expireTimestamp();
        if (v0 == null) {
            throw null;
        }
        if (v0.isDefined()) lbl-1000:
        // 2 sources

        {
            value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V1());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V1(), (Object)offsetAndMetadata.offset());
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V1(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1(), (Object)offsetAndMetadata.commitTimestamp());
            v1 = this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1();
            v2 = offsetAndMetadata.expireTimestamp();
            if (v2 == null) {
                throw null;
            }
            getOrElse_this = v2;
            if (getOrElse_this.isEmpty()) {
                v3 = var10_5 = Long.valueOf(-1L);
                var10_5 = null;
                var9_6 = v3;
            } else {
                var9_6 = getOrElse_this.get();
            }
            v4 = var9_6;
            var8_4 = null;
            var9_6 = null;
            value.set(v1, v4);
            v5 = 1;
            v6 = var3_3;
        } else if (apiVersion.$less(KAFKA_2_1_IV1$.MODULE$)) {
            value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V2());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V2(), (Object)offsetAndMetadata.offset());
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V2(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2(), (Object)offsetAndMetadata.commitTimestamp());
            v5 = 2;
            v6 = value;
        } else {
            value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V3());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V3(), (Object)offsetAndMetadata.offset());
            value.set(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3(), (Object)offsetAndMetadata.leaderEpoch().orElse(-1));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V3(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3(), (Object)offsetAndMetadata.commitTimestamp());
            v5 = 3;
            v6 = value;
        }
        var11_9 = v6;
        version = v5;
        byteBuffer = ByteBuffer.allocate(2 + var11_9.sizeOf());
        byteBuffer.putShort((short)var6_10);
        var11_9.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, ApiVersion apiVersion) {
        Nil$ nil$;
        void var5_5;
        void orNull_ev;
        void var6_6;
        Object object;
        Tuple2 tuple2 = apiVersion.$less(KAFKA_0_10_1_IV0$.MODULE$) ? new Tuple2((Object)((short)0), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V0())) : (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$) ? new Tuple2((Object)((short)1), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V1())) : (apiVersion.$less(KAFKA_2_3_IV0$.MODULE$) ? new Tuple2((Object)((short)2), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V2())) : new Tuple2((Object)((short)3), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V3()))));
        short version = BoxesRunTime.unboxToShort((Object)tuple2._1());
        Struct value = (Struct)tuple2._2();
        String string = this.PROTOCOL_TYPE_KEY();
        Option<String> option = groupMetadata.protocolType();
        if (option == null) {
            throw null;
        }
        Option<String> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            String string2;
            String string3 = string2 = "";
            string2 = null;
            object = string3;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var9_7 = null;
        object = null;
        var6_6.set(string, object2);
        var6_6.set(this.GENERATION_KEY(), (Object)groupMetadata.generationId());
        Option<String> option2 = groupMetadata.protocolName();
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (option2 == null) {
            throw null;
        }
        Option<String> orNull_this = option2;
        Object object3 = orNull_this.isEmpty() ? orNull_ev.apply(null) : orNull_this.get();
        Object object4 = object3;
        Object var11_11 = null;
        eq2 = null;
        object3 = null;
        var6_6.set(this.PROTOCOL_KEY(), object4);
        var6_6.set(this.LEADER_KEY(), (Object)groupMetadata.leaderOrNull());
        if (var5_5 >= 2) {
            var6_6.set(this.CURRENT_STATE_TIMESTAMP_KEY(), (Object)groupMetadata.currentStateTimestampOrDefault());
        }
        List<MemberMetadata> list = groupMetadata.allMemberMetadata();
        if (list == null) {
            throw null;
        }
        List<MemberMetadata> map_this = list;
        if (map_this == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            MemberMetadata memberMetadata = (MemberMetadata)map_this.head();
            .colon.colon map_t = map_h = new .colon.colon((Object)GroupMetadataManager$.$anonfun$groupMetadataValue$2((Struct)var6_6, (short)var5_5, groupMetadata, assignment, memberMetadata), (List)Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                memberMetadata = (MemberMetadata)map_rest.head();
                .colon.colon map_nx = new .colon.colon((Object)GroupMetadataManager$.$anonfun$groupMetadataValue$2((Struct)var6_6, (short)var5_5, groupMetadata, assignment, memberMetadata), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = map_h;
        }
        Nil$ nil$2 = nil$;
        Object var14_13 = null;
        Object var15_16 = null;
        Object var16_17 = null;
        Object var17_18 = null;
        Object var18_19 = null;
        nil$ = null;
        Nil$ memberArray = nil$2;
        var6_6.set(this.MEMBERS_KEY(), memberArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + var6_6.sizeOf());
        byteBuffer.putShort((short)var5_5);
        var6_6.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Struct key = this.schemaForKey(version).read(buffer);
        if (version <= this.CURRENT_OFFSET_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.OFFSET_KEY_GROUP_FIELD());
            String topic = (String)key.get(this.OFFSET_KEY_TOPIC_FIELD());
            int partition = BoxesRunTime.unboxToInt((Object)key.get(this.OFFSET_KEY_PARTITION_FIELD()));
            return new OffsetKey(version, new GroupTopicPartition(group, new TopicPartition(topic, partition)));
        }
        if (version == this.CURRENT_GROUP_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.GROUP_KEY_GROUP_FIELD());
            return new GroupMetadataKey(version, group);
        }
        throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        Struct value = this.schemaForOffsetValue(version).read(buffer);
        if (version == 0) {
            long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V0()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V0());
            long timestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_TIMESTAMP_FIELD_V0()));
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp);
        }
        if (version == 1) {
            long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V1()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V1());
            long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1()));
            long expireTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1()));
            if (expireTimestamp == -1L) {
                return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp);
            }
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp, expireTimestamp);
        }
        if (version == 2) {
            long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V2()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V2());
            long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2()));
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp);
        }
        if (version == 3) {
            long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V3()));
            int leaderEpoch = BoxesRunTime.unboxToInt((Object)value.get(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V3());
            long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3()));
            Optional<Integer> leaderEpochOpt = leaderEpoch < 0 ? Optional.empty() : Optional.of(leaderEpoch);
            return new OffsetAndMetadata(offset, leaderEpochOpt, metadata, commitTimestamp, (Option<Object>)None$.MODULE$);
        }
        throw new IllegalStateException(new StringBuilder(32).append("Unknown offset message version: ").append(version).toString());
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer, Time time) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        Struct value = this.schemaForGroupValue(version).read(buffer);
        if (version >= 0 && version <= this.CURRENT_GROUP_METADATA_VALUE_SCHEMA_VERSION()) {
            Object var16_16;
            Long timestamp;
            Product initialState;
            int generationId = BoxesRunTime.unboxToInt((Object)value.get(this.GENERATION_KEY()));
            String protocolType = (String)value.get(this.PROTOCOL_TYPE_KEY());
            String protocol = (String)value.get(this.PROTOCOL_KEY());
            String leaderId = (String)value.get(this.LEADER_KEY());
            Object[] memberMetadataArray = value.getArray(this.MEMBERS_KEY());
            boolean bl = memberMetadataArray.length == 0;
            Product product = initialState = bl ? Empty$.MODULE$ : Stable$.MODULE$;
            None$ currentStateTimestamp = version >= 2 && value.hasField(this.CURRENT_STATE_TIMESTAMP_KEY()) ? (BoxesRunTime.equalsNumObject((Number)(timestamp = value.getLong(this.CURRENT_STATE_TIMESTAMP_KEY())), (Object)-1) ? None$.MODULE$ : new Some((Object)BoxesRunTime.unboxToLong((Object)timestamp))) : None$.MODULE$;
            int n = memberMetadataArray.length;
            MemberMetadata[] map$extension_ys = new MemberMetadata[n];
            if (n > 0) {
                for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                    MemberMetadata array_update_value;
                    Object object = memberMetadataArray[map$extension_i];
                    map$extension_ys[map$extension_i] = array_update_value = GroupMetadataManager$.$anonfun$readGroupMessageValue$1(version, groupId, protocolType, protocol, object);
                    Object var20_19 = null;
                }
            }
            void v1 = var16_16;
            var16_16 = null;
            void members = v1;
            return GroupMetadata$.MODULE$.loadGroup(groupId, (GroupState)initialState, generationId, protocolType, protocol, leaderId, (Option<Object>)currentStateTimestamp, (Iterable<MemberMetadata>)Predef$.MODULE$.wrapRefArray((Object[])members), time);
        }
        throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        Tuple2<Option<String>, Option<String>> tuple2;
        if (!record.hasKey()) {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
        }
        BaseKey baseKey = this.readMessageKey(record.key());
        if (baseKey instanceof OffsetKey) {
            OffsetKey offsetKey = (OffsetKey)baseKey;
            tuple2 = this.parseOffsets(offsetKey, record.value());
        } else if (baseKey instanceof GroupMetadataKey) {
            GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
            tuple2 = this.parseGroupMetadata(groupMetadataKey, record.value());
        } else {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
        }
        return tuple2;
    }

    private Tuple2<Option<String>, Option<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
        String groupId = offsetKey.key().group();
        TopicPartition topicPartition = offsetKey.key().topicPartition();
        String keyString = new StringBuilder(32).append("offset_commit::group=").append(groupId).append(",partition=").append(topicPartition).toString();
        OffsetAndMetadata offset = this.readOffsetMessageValue(payload);
        String valueString = offset == null ? "<DELETE>" : (offset.metadata().isEmpty() ? new StringBuilder(7).append("offset=").append(offset.offset()).toString() : new StringBuilder(17).append("offset=").append(offset.offset()).append(",metadata=").append(offset.metadata()).toString());
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Option<String>, Option<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
        String string;
        String groupId = groupMetadataKey.key();
        String keyString = new StringBuilder(22).append("group_metadata::group=").append(groupId).toString();
        GroupMetadata group = this.readGroupMessageValue(groupId, payload, Time.SYSTEM);
        if (group == null) {
            string = "<DELETE>";
        } else {
            String string2;
            void $minus$greater$extension_y;
            Integer n;
            void $minus$greater$extension_y2;
            void orNull_ev;
            String string3;
            void mkString_end;
            void mkString_sep;
            void mkString_start;
            String string4;
            Nil$ nil$;
            Object object;
            Option<String> option = group.protocolType();
            if (option == null) {
                throw null;
            }
            Option<String> getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string5;
                String string6 = string5 = "";
                string5 = null;
                object = string6;
            } else {
                object = getOrElse_this.get();
            }
            Object object2 = object;
            Object var9_6 = null;
            object = null;
            String protocolType = (String)object2;
            List<MemberMetadata> list = group.allMemberMetadata();
            if (list == null) {
                throw null;
            }
            List<MemberMetadata> map_this = list;
            if (map_this == Nil$.MODULE$) {
                nil$ = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                MemberMetadata memberMetadata = (MemberMetadata)map_this.head();
                .colon.colon map_t = map_h = new .colon.colon((Object)GroupMetadataManager$.$anonfun$parseGroupMetadata$2(protocolType, memberMetadata), (List)Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    memberMetadata = (MemberMetadata)map_rest.head();
                    .colon.colon map_nx = new .colon.colon((Object)GroupMetadataManager$.$anonfun$parseGroupMetadata$2(protocolType, memberMetadata), (List)Nil$.MODULE$);
                    map_t.next_$eq((List)map_nx);
                    map_t = map_nx;
                }
                Statics.releaseFence();
                nil$ = map_h;
            }
            Nil$ nil$2 = nil$;
            Object var25_10 = null;
            Object var26_13 = null;
            Object var27_14 = null;
            Object var28_15 = null;
            Object var29_16 = null;
            nil$ = null;
            String string7 = "}";
            String string8 = ",";
            String string9 = "{";
            Nil$ mkString_this = nil$2;
            String string10 = string4 = IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end);
            Object var20_20 = null;
            string9 = null;
            string8 = null;
            string7 = null;
            string4 = null;
            String assignment = string10;
            Object[] objectArray = new Tuple2[4];
            String string11 = string3 = "protocolType";
            string3 = null;
            String $minus$greater$extension_$this = string11;
            Object var11_24 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)protocolType);
            Option<String> option2 = group.protocolName();
            .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
            if (option2 == null) {
                throw null;
            }
            Option<String> orNull_this = option2;
            Object object3 = orNull_this.isEmpty() ? orNull_ev.apply(null) : orNull_this.get();
            Object object4 = object3;
            Object var12_26 = null;
            eq2 = null;
            object3 = null;
            Object object5 = object4;
            String $minus$greater$extension_$this2 = "protocol";
            Object var15_29 = null;
            object5 = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            Integer n2 = n = Integer.valueOf(group.generationId());
            n = null;
            Integer n3 = n2;
            String $minus$greater$extension_$this3 = "generationId";
            Object var17_32 = null;
            n3 = null;
            objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
            String string12 = string2 = "assignment";
            string2 = null;
            String $minus$greater$extension_$this4 = string12;
            Object var19_34 = null;
            objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)assignment);
            string = Json$.MODULE$.encodeAsString(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava());
        }
        String valueString = string;
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    private String hex(byte[] bytes) {
        boolean bl = bytes.length == 0;
        if (bl) {
            return "";
        }
        return StringOps$.MODULE$.format$extension("%X", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
    }

    public static final /* synthetic */ long $anonfun$offsetCommitValue$1() {
        return -1L;
    }

    public static final /* synthetic */ String $anonfun$groupMetadataValue$1() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Struct $anonfun$groupMetadataValue$2(Struct value$1, short version$1, GroupMetadata groupMetadata$1, Map assignment$1, MemberMetadata memberMetadata) {
        void orNull_ev;
        Struct memberStruct = value$1.instance(MODULE$.MEMBERS_KEY());
        memberStruct.set(MODULE$.MEMBER_ID_KEY(), (Object)memberMetadata.memberId());
        memberStruct.set(MODULE$.CLIENT_ID_KEY(), (Object)memberMetadata.clientId());
        memberStruct.set(MODULE$.CLIENT_HOST_KEY(), (Object)memberMetadata.clientHost());
        memberStruct.set(MODULE$.SESSION_TIMEOUT_KEY(), (Object)memberMetadata.sessionTimeoutMs());
        if (version$1 > 0) {
            memberStruct.set(MODULE$.REBALANCE_TIMEOUT_KEY(), (Object)memberMetadata.rebalanceTimeoutMs());
        }
        if (version$1 >= 3) {
            void orNull_ev2;
            Option<String> option = memberMetadata.groupInstanceId();
            .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
            if (option == null) {
                throw null;
            }
            Option<String> orNull_this = option;
            Object object = orNull_this.isEmpty() ? orNull_ev2.apply(null) : orNull_this.get();
            Object object2 = object;
            Object var9_7 = null;
            eq2 = null;
            object = null;
            memberStruct.set(MODULE$.GROUP_INSTANCE_ID_KEY(), object2);
        }
        Option<String> option = groupMetadata$1.protocolName();
        .eq.colon.eq eq3 = $less$colon$less$.MODULE$.refl();
        if (option == null) {
            throw null;
        }
        Option<String> orNull_this = option;
        Object object = orNull_this.isEmpty() ? orNull_ev.apply(null) : orNull_this.get();
        Object object3 = object;
        Object var12_10 = null;
        eq3 = null;
        object = null;
        String protocol = (String)object3;
        if (protocol == null) {
            throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol");
        }
        byte[] metadata = memberMetadata.metadata(protocol);
        memberStruct.set(MODULE$.SUBSCRIPTION_KEY(), (Object)ByteBuffer.wrap(metadata));
        byte[] memberAssignment = (byte[])assignment$1.apply((Object)memberMetadata.memberId());
        Predef$.MODULE$.assert(memberAssignment != null);
        memberStruct.set(MODULE$.ASSIGNMENT_KEY(), (Object)ByteBuffer.wrap(memberAssignment));
        return memberStruct;
    }

    public static final /* synthetic */ MemberMetadata $anonfun$readGroupMessageValue$1(short version$2, String groupId$7, String protocolType$1, String protocol$1, Object memberMetadataObj) {
        Struct memberMetadata = (Struct)memberMetadataObj;
        String memberId = (String)memberMetadata.get(MODULE$.MEMBER_ID_KEY());
        None$ groupInstanceId = version$2 >= 3 ? new Some((Object)((String)memberMetadata.get(MODULE$.GROUP_INSTANCE_ID_KEY()))) : None$.MODULE$;
        String clientId = (String)memberMetadata.get(MODULE$.CLIENT_ID_KEY());
        String clientHost = (String)memberMetadata.get(MODULE$.CLIENT_HOST_KEY());
        int sessionTimeout = BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.SESSION_TIMEOUT_KEY()));
        int rebalanceTimeout = version$2 == 0 ? sessionTimeout : BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.REBALANCE_TIMEOUT_KEY()));
        byte[] subscription = Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.SUBSCRIPTION_KEY())));
        MemberMetadata member = new MemberMetadata(memberId, groupId$7, (Option<String>)groupInstanceId, clientId, clientHost, rebalanceTimeout, sessionTimeout, protocolType$1, (List<Tuple2<String, byte[]>>)new .colon.colon((Object)new Tuple2((Object)protocol$1, (Object)subscription), (List)Nil$.MODULE$));
        member.assignment_$eq(Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.ASSIGNMENT_KEY()))));
        return member;
    }

    public static final /* synthetic */ String $anonfun$parseGroupMetadata$1() {
        return "";
    }

    public static final /* synthetic */ byte[] $anonfun$parseGroupMetadata$3(ByteBuffer x$1) {
        return Utils.toArray((ByteBuffer)x$1);
    }

    public static final /* synthetic */ String $anonfun$parseGroupMetadata$5() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$parseGroupMetadata$2(String protocolType$2, MemberMetadata member) {
        String string = protocolType$2;
        String string2 = "consumer";
        if (string != null && string.equals(string2)) {
            Object object;
            ConsumerPartitionAssignor.Assignment partitionAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()));
            Option option = Option$.MODULE$.apply((Object)partitionAssignment.userData());
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)Utils.toArray((ByteBuffer)((ByteBuffer)map_this.get())));
            None$ none$ = object2;
            Object var5_4 = null;
            object2 = null;
            None$ map_this2 = none$;
            Object object3 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)GroupMetadataManager$.MODULE$.hex((byte[])map_this2.get()));
            None$ none$2 = object3;
            Object var7_6 = null;
            object3 = null;
            None$ getOrElse_this = none$2;
            if (getOrElse_this.isEmpty()) {
                String string3;
                String string4 = string3 = "";
                string3 = null;
                object = string4;
            } else {
                object = getOrElse_this.get();
            }
            Object object4 = object;
            Object var9_8 = null;
            object = null;
            String userData = (String)object4;
            if (userData.isEmpty()) {
                return new StringBuilder(1).append(member.memberId()).append("=").append(partitionAssignment.partitions()).toString();
            }
            return new StringBuilder(2).append(member.memberId()).append("=").append(partitionAssignment.partitions()).append(":").append(userData).toString();
        }
        return new StringBuilder(1).append(member.memberId()).append("=").append(MODULE$.hex(member.assignment())).toString();
    }

    private GroupMetadataManager$() {
    }
}

