/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.raft.KafkaNetworkChannel$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.apache.kafka.raft.RaftUtil;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u001dt!\u0002\u0014(\u0011\u0003ac!\u0002\u0018(\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004B\u0002\u001d\u0002\t\u00039\u0013\b\u0003\u0004P\u0003\u0011\u0005q\u0005\u0015\u0005\u0007\u0011\u0006!\ta\n4\t\r\u0015\fA\u0011A\u0014j\r\u0011qs\u0005\u00017\t\u0015\u0005\u0005qA!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\u000e\u001d\u0011\t\u0011)A\u0005\u0003\u001fA!\"a\u0007\b\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t\u0019d\u0002B\u0001B\u0003%\u0011Q\u0007\u0005\u000b\u0003w9!\u0011!Q\u0001\n\u0005U\u0002B\u0002\u001c\b\t\u0003\ti$\u0002\u0004\u0002L\u001d\u0001\u0011Q\n\u0005\n\u00033:!\u0019!C\u0005\u00037B\u0001\"!\u001d\bA\u0003%\u0011Q\f\u0005\n\u0003g:!\u0019!C\u0005\u0003kB\u0001\"!%\bA\u0003%\u0011q\u000f\u0005\n\u0003';!\u0019!C\u0005\u0003+C\u0001\"!*\bA\u0003%\u0011q\u0013\u0005\n\u0003O;!\u0019!C\u0005\u0003SC\u0001\"a/\bA\u0003%\u00111\u0016\u0005\n\u0003{;!\u0019!C\u0005\u0003\u007fC\u0001\"a4\bA\u0003%\u0011\u0011\u0019\u0005\b\u0003#<A\u0011IAj\u0011\u001d\t)n\u0002C\u0005\u0003/Dq!a9\b\t\u0003\n)\u000fC\u0004\u0002l\u001e!I!!<\t\u000f\u0005Mx\u0001\"\u0001\u0002v\"9\u00111`\u0004\u0005\u0002\u0005u\bb\u0002B\u0003\u000f\u0011%!q\u0001\u0005\b\u0005?9A\u0011\u0002B\u0011\u0011\u001d\u0011yc\u0002C!\u0005cAqA!\u000e\b\t\u0003\u00129\u0004C\u0004\u0003:\u001d!\tEa\u000f\t\u000f\tEs\u0001\"\u0001\u0003T!9!QM\u0004\u0005B\t]\u0012aE&bM.\fg*\u001a;x_J\\7\t[1o]\u0016d'B\u0001\u0015*\u0003\u0011\u0011\u0018M\u001a;\u000b\u0003)\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002.\u00035\tqEA\nLC\u001a\\\u0017MT3uo>\u00148n\u00115b]:,Gn\u0005\u0002\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0017\u0002\u001b\t,\u0018\u000e\u001c3SKN\u0004xN\\:f)\tQt\t\u0005\u0002<\u000b6\tAH\u0003\u0002>}\u0005A!/Z9vKN$8O\u0003\u0002@\u0001\u000611m\\7n_:T!AK!\u000b\u0005\t\u001b\u0015AB1qC\u000eDWMC\u0001E\u0003\ry'oZ\u0005\u0003\rr\u0012\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\t\u000b!\u001b\u0001\u0019A%\u0002\u0019I,7\u000f]8og\u0016$\u0015\r^1\u0011\u0005)kU\"A&\u000b\u00051s\u0014\u0001\u00039s_R|7m\u001c7\n\u00059[%AC!qS6+7o]1hK\u0006a!-^5mIJ+\u0017/^3tiR\u0011\u0011\u000b\u001a\u0019\u0003%n\u00032a\u0015,Z\u001d\tYD+\u0003\u0002Vy\u0005y\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH/\u0003\u0002X1\n9!)^5mI\u0016\u0014(BA+=!\tQ6\f\u0004\u0001\u0005\u0013q#\u0011\u0011!A\u0001\u0006\u0003i&aA0%cE\u0011a,\u0019\t\u0003c}K!\u0001\u0019\u001a\u0003\u000f9{G\u000f[5oOB\u00111HY\u0005\u0003Gr\u0012q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\u0006K\u0012\u0001\r!S\u0001\fe\u0016\fX/Z:u\t\u0006$\u0018\r\u0006\u0002JO\")\u0001.\u0002a\u0001u\u0005A!/Z:q_:\u001cX\r\u0006\u0002JU\")1N\u0002a\u0001C\u00069!/Z9vKN$8\u0003B\u0004nkj\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\t1\fgn\u001a\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0004PE*,7\r\u001e\t\u0003mbl\u0011a\u001e\u0006\u0003Q\u0001K!!_<\u0003\u001d9+Go^8sW\u000eC\u0017M\u001c8fYB\u00111P`\u0007\u0002y*\u0011Q0K\u0001\u0006kRLGn]\u0005\u0003\u007fr\u0014q\u0001T8hO&tw-\u0001\u0003uS6,\u0007\u0003BA\u0003\u0003\u0013i!!a\u0002\u000b\u0005ut\u0014\u0002BA\u0006\u0003\u000f\u0011A\u0001V5nK\u000611\r\\5f]R\u0004B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+\u0001\u0015aB2mS\u0016tGo]\u0005\u0005\u00033\t\u0019BA\u0006LC\u001a\\\u0017m\u00117jK:$\u0018\u0001C2mS\u0016tG/\u00133\u0011\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tI\u0003E\u0002\u0002$Ij!!!\n\u000b\u0007\u0005\u001d2&\u0001\u0004=e>|GOP\u0005\u0004\u0003W\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,I\naB]3uef\u0014\u0015mY6pM\u001al5\u000fE\u00022\u0003oI1!!\u000f3\u0005\rIe\u000e^\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN$B\"a\u0010\u0002B\u0005\r\u0013QIA$\u0003\u0013\u0002\"!L\u0004\t\u000f\u0005\u0005Q\u00021\u0001\u0002\u0004!9\u0011QB\u0007A\u0002\u0005=\u0001bBA\u000e\u001b\u0001\u0007\u0011Q\u0004\u0005\b\u0003gi\u0001\u0019AA\u001b\u0011\u001d\tY$\u0004a\u0001\u0003k\u0011qBU3ta>t7/\u001a%b]\u0012dWM\u001d\t\u0007c\u0005=#(a\u0015\n\u0007\u0005E#GA\u0005Gk:\u001cG/[8ocA\u0019\u0011'!\u0016\n\u0007\u0005]#G\u0001\u0003V]&$\u0018\u0001F2peJ,G.\u0019;j_:LEmQ8v]R,'/\u0006\u0002\u0002^A!\u0011qLA7\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014AB1u_6L7M\u0003\u0003\u0002h\u0005%\u0014AC2p]\u000e,(O]3oi*\u0019\u00111N9\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003_\n\tGA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0016G>\u0014(/\u001a7bi&|g.\u00133D_VtG/\u001a:!\u00039\u0001XM\u001c3j]\u001eLeNY8v]\u0012,\"!a\u001e\u0011\u0011\u0005e\u00141QAD\u0003\u001bk!!a\u001f\u000b\t\u0005u\u0014qP\u0001\b[V$\u0018M\u00197f\u0015\r\t\tIM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAC\u0003w\u00121!T1q!\r\t\u0014\u0011R\u0005\u0004\u0003\u0017\u0013$\u0001\u0002'p]\u001e\u00042!a$\u000f\u001b\u00059\u0011a\u00049f]\u0012LgnZ%oE>,h\u000e\u001a\u0011\u0002\u0017UtG-\u001a7jm\u0016\u0014X\rZ\u000b\u0003\u0003/\u0003b!!'\u0002\u001c\u0006}UBAA3\u0013\u0011\ti*!\u001a\u0003%\u0005\u0013(/Y=CY>\u001c7.\u001b8h#V,W/\u001a\t\u0004m\u0006\u0005\u0016bAARo\nY!+\u00194u\u001b\u0016\u001c8/Y4f\u00031)h\u000eZ3mSZ,'/\u001a3!\u0003=\u0001XM\u001c3j]\u001e|U\u000f\u001e2pk:$WCAAV!\u0019\tI*a'\u0002.B!\u0011qVA[\u001d\r1\u0018\u0011W\u0005\u0004\u0003g;\u0018a\u0003*bMR\u0014V-];fgRLA!a.\u0002:\nAq*\u001e;c_VtGMC\u0002\u00024^\f\u0001\u0003]3oI&twmT;uE>,h\u000e\u001a\u0011\u0002\u0013\u0015tG\r]8j]R\u001cXCAAa!!\tI(a1\u00026\u0005\u001d\u0017\u0002BAc\u0003w\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002J\u0006-W\"\u0001 \n\u0007\u00055gH\u0001\u0003O_\u0012,\u0017AC3oIB|\u0017N\u001c;tA\u0005\u0001b.Z<D_J\u0014X\r\\1uS>t\u0017\n\u001a\u000b\u0003\u0003k\t!CY;jY\u0012\u001cE.[3oiJ+\u0017/^3tiR!\u0011\u0011\\Ap!\u0011\t\t\"a7\n\t\u0005u\u00171\u0003\u0002\u000e\u00072LWM\u001c;SKF,Xm\u001d;\t\u000f\u0005\u0005(\u00041\u0001\u0002.\u0006\u0019!/Z9\u0002\tM,g\u000e\u001a\u000b\u0005\u0003'\n9\u000fC\u0004\u0002jn\u0001\r!a(\u0002\u000f5,7o]1hK\u0006!2/\u001a8e\u001fV$(m\\;oIJ+\u0017/^3tiN$B!a\u0015\u0002p\"9\u0011\u0011\u001f\u000fA\u0002\u0005\u001d\u0015!D2veJ,g\u000e\u001e+j[\u0016l5/A\thKR\u001cuN\u001c8fGRLwN\\%oM>$B!a2\u0002x\"9\u0011\u0011`\u000fA\u0002\u0005U\u0012A\u00028pI\u0016LE-\u0001\bbY2\u001cuN\u001c8fGRLwN\\:\u0015\u0005\u0005}\bCBA\u0010\u0005\u0003\t9-\u0003\u0003\u0003\u0004\u0005E\"aA*fi\u0006A\"-^5mI&s'm\\;oIJ\u000bg\r\u001e*fgB|gn]3\u0015\t\t%!q\u0003\t\u0005\u0005\u0017\u0011\tBD\u0002w\u0005\u001bI1Aa\u0004x\u00031\u0011\u0016M\u001a;SKN\u0004xN\\:f\u0013\u0011\u0011\u0019B!\u0006\u0003\u000f%s'm\\;oI*\u0019!qB<\t\r!|\u0002\u0019\u0001B\r!\u0011\t\tBa\u0007\n\t\tu\u00111\u0003\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0003Q\u0001x\u000e\u001c7J]\n|WO\u001c3SKN\u0004xN\\:fgR!!1\u0005B\u0016!\u0019\u0011)Ca\n\u0002 6\u0011\u0011\u0011N\u0005\u0005\u0005S\tIG\u0001\u0003MSN$\bb\u0002B\u0017A\u0001\u0007\u0011qQ\u0001\ni&lWm\\;u\u001bN\fqA]3dK&4X\r\u0006\u0003\u0003$\tM\u0002b\u0002B\u0017C\u0001\u0007\u0011qQ\u0001\u0007o\u0006\\W-\u001e9\u0015\u0005\u0005M\u0013AD;qI\u0006$X-\u00128ea>Lg\u000e\u001e\u000b\u0007\u0003'\u0012iD!\u0011\t\u000f\t}2\u00051\u0001\u00026\u0005\u0011\u0011\u000e\u001a\u0005\b\u0005\u0007\u001a\u0003\u0019\u0001B#\u0003\u001d\tG\r\u001a:fgN\u0004BAa\u0012\u0003N5\u0011!\u0011\n\u0006\u0004\u0005\u0017\n\u0018a\u00018fi&!!q\nB%\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o]\u0001\u0013a>\u001cH/\u00138c_VtGMU3rk\u0016\u001cH\u000f\u0006\u0005\u0002T\tU#q\fB1\u0011\u001d\u00119\u0006\na\u0001\u00053\na\u0001[3bI\u0016\u0014\bcA\u001e\u0003\\%\u0019!Q\f\u001f\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u0015YG\u00051\u0001b\u0011\u001d\u0011\u0019\u0007\na\u0001\u0003\u001b\u000b!c\u001c8SKN\u0004xN\\:f%\u0016\u001cW-\u001b<fI\u0006)1\r\\8tK\u0002")
public class KafkaNetworkChannel
implements NetworkChannel,
Logging {
    private final Time time;
    private final KafkaClient client;
    private final String clientId;
    private final int retryBackoffMs;
    private final int requestTimeoutMs;
    private final AtomicInteger correlationIdCounter;
    private final Map<Object, Function1<AbstractResponse, BoxedUnit>> pendingInbound;
    private final ArrayBlockingQueue<RaftMessage> undelivered;
    private final ArrayBlockingQueue<RaftRequest.Outbound> pendingOutbound;
    private final HashMap<Object, Node> endpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicInteger correlationIdCounter() {
        return this.correlationIdCounter;
    }

    private Map<Object, Function1<AbstractResponse, BoxedUnit>> pendingInbound() {
        return this.pendingInbound;
    }

    private ArrayBlockingQueue<RaftMessage> undelivered() {
        return this.undelivered;
    }

    private ArrayBlockingQueue<RaftRequest.Outbound> pendingOutbound() {
        return this.pendingOutbound;
    }

    private HashMap<Object, Node> endpoints() {
        return this.endpoints;
    }

    public int newCorrelationId() {
        return this.correlationIdCounter().getAndIncrement();
    }

    private ClientRequest buildClientRequest(RaftRequest.Outbound req) {
        String destination = ((Object)req.destinationId()).toString();
        AbstractRequest.Builder<? extends AbstractRequest> request = KafkaNetworkChannel$.MODULE$.buildRequest(req.data());
        int correlationId = req.correlationId();
        long createdTimeMs = req.createdTimeMs();
        return new ClientRequest(destination, request, correlationId, this.clientId, createdTimeMs, true, this.requestTimeoutMs, null);
    }

    public void send(RaftMessage message) {
        if (message instanceof RaftRequest.Outbound) {
            RaftRequest.Outbound outbound = (RaftRequest.Outbound)message;
            if (!this.pendingOutbound().offer(outbound)) {
                throw new KafkaException("Pending outbound queue is full");
            }
        } else {
            if (message instanceof RaftResponse.Outbound) {
                RaftResponse.Outbound outbound = (RaftResponse.Outbound)message;
                Option option = this.pendingInbound().remove((Object)outbound.correlationId());
                if (option == null) {
                    throw null;
                }
                Option foreach_this = option;
                if (!foreach_this.isEmpty()) {
                    Function1 function1 = (Function1)foreach_this.get();
                    function1.apply((Object)KafkaNetworkChannel$.MODULE$.buildResponse(outbound.data()));
                }
                return;
            }
            throw new IllegalArgumentException(new StringBuilder(23).append("Unhandled message type ").append(message).toString());
        }
    }

    private void sendOutboundRequests(long currentTimeMs) {
        while (!this.pendingOutbound().isEmpty()) {
            RaftRequest.Outbound request = this.pendingOutbound().peek();
            Option option = this.endpoints().get((Object)request.destinationId());
            if (option instanceof Some) {
                Node node = (Node)((Some)option).value();
                if (this.client.connectionFailed(node)) {
                    this.pendingOutbound().poll();
                    ApiMessage disconnectResponse = RaftUtil.errorResponse((ApiKeys)ApiKeys.forId((int)request.data().apiKey()), (Errors)Errors.BROKER_NOT_AVAILABLE);
                    if (!this.undelivered().offer((RaftMessage)new RaftResponse.Inbound(request.correlationId(), disconnectResponse, request.destinationId()))) {
                        throw new KafkaException("Undelivered queue is full");
                    }
                    this.client.ready(node, currentTimeMs);
                    continue;
                }
                if (this.client.ready(node, currentTimeMs)) {
                    this.pendingOutbound().poll();
                    ClientRequest clientRequest = this.buildClientRequest(request);
                    this.client.send(clientRequest, currentTimeMs);
                    continue;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.pendingOutbound().poll();
                ApiMessage responseData = RaftUtil.errorResponse((ApiKeys)ApiKeys.forId((int)request.data().apiKey()), (Errors)Errors.BROKER_NOT_AVAILABLE);
                RaftResponse.Inbound response = new RaftResponse.Inbound(request.correlationId(), responseData, request.destinationId());
                if (this.undelivered().offer((RaftMessage)response)) continue;
                throw new KafkaException("Undelivered queue is full");
            }
            throw new MatchError((Object)option);
        }
    }

    public Node getConnectionInfo(int nodeId) {
        if (!this.endpoints().contains((Object)nodeId)) {
            return null;
        }
        return (Node)this.endpoints().apply((Object)nodeId);
    }

    public Set<Node> allConnections() {
        return this.endpoints().values().toSet();
    }

    private RaftResponse.Inbound buildInboundRaftResponse(ClientResponse response) {
        RequestHeader header = response.requestHeader();
        ApiMessage data = response.authenticationException() != null ? RaftUtil.errorResponse((ApiKeys)header.apiKey(), (Errors)Errors.CLUSTER_AUTHORIZATION_FAILED) : (response.wasDisconnected() ? RaftUtil.errorResponse((ApiKeys)header.apiKey(), (Errors)Errors.BROKER_NOT_AVAILABLE) : KafkaNetworkChannel$.MODULE$.responseData(response.responseBody()));
        return new RaftResponse.Inbound(header.correlationId(), data, Integer.parseInt(response.destination()));
    }

    private List<RaftMessage> pollInboundResponses(long timeoutMs) {
        long pollTimeoutMs = !this.undelivered().isEmpty() ? 0L : (!this.pendingOutbound().isEmpty() ? (long)this.retryBackoffMs : timeoutMs);
        List responses = this.client.poll(pollTimeoutMs, this.time.milliseconds());
        ArrayList<RaftMessage> messages = new ArrayList<RaftMessage>();
        AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)responses).asScala().foreach((Function1 & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)messages.add(this.buildInboundRaftResponse(response))));
        this.undelivered().drainTo(messages);
        return messages;
    }

    public List<RaftMessage> receive(long timeoutMs) {
        this.sendOutboundRequests(this.time.milliseconds());
        return this.pollInboundResponses(timeoutMs);
    }

    public void wakeup() {
        this.client.wakeup();
    }

    public void updateEndpoint(int id, InetSocketAddress address) {
        Node node = new Node(id, address.getHostString(), address.getPort());
        this.endpoints().put((Object)id, (Object)node);
    }

    public void postInboundRequest(RequestHeader header, AbstractRequest request, Function1<AbstractResponse, BoxedUnit> onResponseReceived) {
        ApiMessage data = KafkaNetworkChannel$.MODULE$.requestData(request);
        int correlationId = header.correlationId();
        RaftRequest.Inbound req = new RaftRequest.Inbound(correlationId, data, this.time.milliseconds());
        this.pendingInbound().put((Object)correlationId, onResponseReceived);
        if (!this.undelivered().offer((RaftMessage)req)) {
            throw new KafkaException("Undelivered queue is full");
        }
        this.wakeup();
    }

    public void close() {
        this.client.close();
    }

    public KafkaNetworkChannel(Time time, KafkaClient client, String clientId, int retryBackoffMs, int requestTimeoutMs) {
        this.time = time;
        this.client = client;
        this.clientId = clientId;
        this.retryBackoffMs = retryBackoffMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.correlationIdCounter = new AtomicInteger(0);
        this.pendingInbound = (Map)Map$.MODULE$.empty();
        this.undelivered = new ArrayBlockingQueue(10);
        this.pendingOutbound = new ArrayBlockingQueue(10);
        this.endpoints = new HashMap();
    }

    public static final /* synthetic */ Object $anonfun$send$1$adapted(RaftResponse.Outbound x3$1, Function1 onResponseReceived) {
        onResponseReceived.apply((Object)KafkaNetworkChannel$.MODULE$.buildResponse(x3$1.data()));
        return BoxedUnit.UNIT;
    }
}

