/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest;
import kafka.log.LogConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0011Ua\u0001B-[\u0001}CQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001a\u0001\u0005\u0002!4qa\u001f\u0001\u0011\u0002\u0007\u0005A\u0010\u0003\u0004\u0002.\r!\t\u0001\u001b\u0005\n\u0003_\u0019\u0001\u0019!C\u0001\u0003cA\u0011\"!\u000f\u0004\u0001\u0004%\t!a\u000f\t\u000f\u0005\u00053\u0001\"\u0011\u0002D!9\u00111O\u0002\u0005B\u0005U\u0004BBAU\u0007\u0011\u0005\u0003\u000eC\u0004\u0002B\r!\t%a+\u0007\u0013\u0005E\u0006\u0001%A\u0002\u0002\u0005M\u0006BBA\u0017\u0017\u0011\u0005\u0001\u000eC\u0005\u0002<.\u0001\r\u0011\"\u0001\u0002>\"I\u0011QY\u0006A\u0002\u0013\u0005\u0011q\u0019\u0005\b\u0003\u0017\\A\u0011IAg\u0011\u001d\t\u0019h\u0003C!\u0003+Da!!+\f\t\u0003B\u0007bBAf\u0017\u0011\u0005\u0013Q\u001d\u0005\b\u0003W\u0004A\u0011BAw\u0011\u0019\t\u0019\u0010\u0001C\u0001Q\"1!q\u0001\u0001\u0005\u0002!DaA!\u0006\u0001\t\u0003A\u0007B\u0002B\r\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0003\u001e\u0001!\t\u0001\u001b\u0005\u0007\u0005C\u0001A\u0011\u00015\t\r\t\u0015\u0002\u0001\"\u0001i\u0011\u0019\u0011I\u0003\u0001C\u0001Q\"1!Q\u0006\u0001\u0005\u0002!DaA!\r\u0001\t\u0003A\u0007B\u0002B\u001b\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0003:\u0001!\t\u0001\u001b\u0005\u0007\u0005{\u0001A\u0011\u00015\t\r\t\u0005\u0003\u0001\"\u0001i\u0011\u0019\u0011)\u0005\u0001C\u0001Q\"1!\u0011\n\u0001\u0005\u0002!DaA!\u0014\u0001\t\u0003A\u0007B\u0002B)\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0003V\u0001!\t\u0001\u001b\u0005\u0007\u00053\u0002A\u0011\u00015\t\r\tu\u0003\u0001\"\u0001i\u0011\u0019\u0011\t\u0007\u0001C\u0001Q\"9!Q\r\u0001\u0005\n\t\u001d\u0004B\u0002B@\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0003\u0004\u0002!\t\u0001\u001b\u0005\u0007\u0005\u000f\u0003A\u0011\u00015\t\r\t-\u0005\u0001\"\u0001i\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CaAa&\u0001\t\u0003A\u0007b\u0002BN\u0001\u0011%!Q\u0014\u0005\u0007\u0005G\u0003A\u0011\u00015\t\r\t\u001d\u0006\u0001\"\u0001i\u0011\u0019\u0011Y\u000b\u0001C\u0001Q\"1!q\u0016\u0001\u0005\u0002!DaAa-\u0001\t\u0003A\u0007B\u0002B\\\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0003<\u0002!\t\u0001\u001b\u0005\u0007\u0005\u007f\u0003A\u0011\u00015\t\r\t\r\u0007\u0001\"\u0001i\u0011\u0019\u00119\r\u0001C\u0001Q\"1!1\u001a\u0001\u0005\u0002!DaAa4\u0001\t\u0003A\u0007B\u0002Bj\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0003X\u0002!\t\u0001\u001b\u0005\u0007\u00057\u0004A\u0011\u00015\t\r\t}\u0007\u0001\"\u0001i\u0011\u0019\u0011\u0019\u000f\u0001C\u0001Q\"1!q\u001d\u0001\u0005\u0002!DaAa;\u0001\t\u0003A\u0007B\u0002Bx\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0003t\u0002!\t\u0001\u001b\u0005\u0007\u0005o\u0004A\u0011\u00015\t\r\tm\b\u0001\"\u0001i\u0011\u0019\u0011y\u0010\u0001C\u0001Q\"111\u0001\u0001\u0005\u0002!Daaa\u0002\u0001\t\u0003A\u0007BBB\u0006\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0004\u0010\u0001!\t\u0001\u001b\u0005\u0007\u0007'\u0001A\u0011\u00015\t\u000f\r]\u0001\u0001\"\u0001\u0004\u001a!91q\u0004\u0001\u0005\u0002\r\u0005\u0002bBB6\u0001\u0011\u00051Q\u000e\u0005\b\u0007\u001f\u0003A\u0011ABI\u0011\u001d\u0019\u0019\u000b\u0001C\u0001\u0007KCqaa,\u0001\t\u0003\u0019\t\fC\u0004\u0004Z\u0002!Iaa7\t\u000f\rU\b\u0001\"\u0003\u0004x\"1AQ\u0002\u0001\u0005\u0002!Da\u0001\"\u0005\u0001\t\u0003A'!\u0006)mC&tG/\u001a=u\u0007>t7/^7feR+7\u000f\u001e\u0006\u00037r\u000b1!\u00199j\u0015\u0005i\u0016!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0004\"!\u00192\u000e\u0003iK!a\u0019.\u0003!\t\u000b7/Z\"p]N,X.\u001a:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001g!\t\t\u0007!A\u0006uKN$\b*Z1eKJ\u001cH#A5\u0011\u0005)lW\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005A\u0004\"!]=\u000e\u0003IT!aW:\u000b\u0005Q,\u0018a\u00026va&$XM\u001d\u0006\u0003m^\fQA[;oSRT\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>s\u0005\u0011!Vm\u001d;\u0003\u001dM+'/[1mSj,'/S7qYN!1!`A\u0006!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005\u0019y%M[3diB1\u0011QBA\u000f\u0003Ci!!a\u0004\u000b\t\u0005E\u00111C\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\u0005U\u0011qC\u0001\u0007G>lWn\u001c8\u000b\u0007u\u000bIBC\u0002\u0002\u001c]\fa!\u00199bG\",\u0017\u0002BA\u0010\u0003\u001f\u0011!bU3sS\u0006d\u0017N_3s!\u0015Q\u00171EA\u0014\u0013\r\t)c\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004U\u0006%\u0012bAA\u0016W\n!!)\u001f;f\u0003\u0019!\u0013N\\5uI\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u0005\u0005M\u0002\u0003BA\u0007\u0003kIA!a\u000e\u0002\u0010\t\u0019\")\u001f;f\u0003J\u0014\u0018-_*fe&\fG.\u001b>fe\u0006q1/\u001a:jC2L'0\u001a:`I\u0015\fHcA5\u0002>!I\u0011q\b\u0004\u0002\u0002\u0003\u0007\u00111G\u0001\u0004q\u0012\n\u0014!C:fe&\fG.\u001b>f)!\t\t#!\u0012\u0002`\u0005=\u0004bBA$\u000f\u0001\u0007\u0011\u0011J\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003\u0017\nIF\u0004\u0003\u0002N\u0005U\u0003cAA(W6\u0011\u0011\u0011\u000b\u0006\u0004\u0003'r\u0016A\u0002\u001fs_>$h(C\u0002\u0002X-\fa\u0001\u0015:fI\u00164\u0017\u0002BA.\u0003;\u0012aa\u0015;sS:<'bAA,W\"9\u0011\u0011M\u0004A\u0002\u0005\r\u0014a\u00025fC\u0012,'o\u001d\t\u0005\u0003K\nY'\u0004\u0002\u0002h)!\u0011\u0011NA\n\u0003\u0019AW-\u00193fe&!\u0011QNA4\u0005\u001dAU-\u00193feNDq!!\u001d\b\u0001\u0004\t\t#\u0001\u0003eCR\f\u0017!C2p]\u001aLw-\u001e:f)\u0015I\u0017qOAP\u0011\u001d\tI\b\u0003a\u0001\u0003w\nqaY8oM&<7\u000f\r\u0003\u0002~\u00055\u0005\u0003CA@\u0003\u000b\u000bI%!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u0007\tA!\u001e;jY&!\u0011qQAA\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0017\u000bi\t\u0004\u0001\u0005\u0019\u0005=\u0015qOA\u0001\u0002\u0003\u0015\t!!%\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0014\u0006e\u0005c\u00016\u0002\u0016&\u0019\u0011qS6\u0003\u000f9{G\u000f[5oOB\u0019!.a'\n\u0007\u0005u5NA\u0002B]fDq!!)\t\u0001\u0004\t\u0019+A\u0003jg.+\u0017\u0010E\u0002k\u0003KK1!a*l\u0005\u001d\u0011un\u001c7fC:\fQa\u00197pg\u0016$b!!\t\u0002.\u0006=\u0006bBA$\u0015\u0001\u0007\u0011\u0011\n\u0005\b\u0003cR\u0001\u0019AA\u0011\u0005A!Um]3sS\u0006d\u0017N_3s\u00136\u0004Hn\u0005\u0003\f{\u0006U\u0006CBA\u0007\u0003o\u000b\t#\u0003\u0003\u0002:\u0006=!\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001\u00043fg\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAA`!\u0011\ti!!1\n\t\u0005\r\u0017q\u0002\u0002\u0016\u0005f$X-\u0011:sCf$Um]3sS\u0006d\u0017N_3s\u0003A!Wm]3sS\u0006d\u0017N_3s?\u0012*\u0017\u000fF\u0002j\u0003\u0013D\u0011\"a\u0010\u000f\u0003\u0003\u0005\r!a0\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\t\u0003C\ty-!5\u0002T\"9\u0011qI\bA\u0002\u0005%\u0003bBA1\u001f\u0001\u0007\u00111\r\u0005\b\u0003cz\u0001\u0019AA\u0011)\u0015I\u0017q[Ar\u0011\u001d\tI\b\u0005a\u0001\u00033\u0004D!a7\u0002`BA\u0011qPAC\u0003\u0013\ni\u000e\u0005\u0003\u0002\f\u0006}G\u0001DAq\u0003/\f\t\u0011!A\u0003\u0002\u0005E%aA0%e!9\u0011\u0011\u0015\tA\u0002\u0005\rFCBA\u0011\u0003O\fI\u000fC\u0004\u0002HI\u0001\r!!\u0013\t\u000f\u0005E$\u00031\u0001\u0002\"\u0005yB/Z:u\u0011\u0016\fG-\u001a:t'\u0016\u0014\u0018.\u00197ju\u0016$Um]3sS\u0006d\u0017N_3\u0015\u000b%\fy/!=\t\u000f\u0005=2\u00031\u0001\u0002\f!9\u00111X\nA\u0002\u0005U\u0016!\n;fgR$U\r\u001d:fG\u0006$X\r\u001a)pY2\u0014En\\2lg\u001a{'/Q:tS\u001etW.\u001a8uQ\t!\u0002\u000fK\u0004\u0015\u0003s\fyPa\u0001\u0011\u0007)\fY0C\u0002\u0002~.\u0014!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\u0011\t!A\u0011q_2d\u0007\u0006R;sCRLwN\\\u0015!SN\u0004C\u000f[3!e\u0016\u0004H.Y2f[\u0016tG/\t\u0002\u0003\u0006\u0005\u0019!G\f\u0019\u0002SQ,7\u000f\u001e%fC\u0012,'o]#yi\u0016tG-\u001a3TKJL\u0017\r\\5{KJ$Um]3sS\u0006d\u0017N_3sQ\t)\u0002\u000fK\u0004\u0016\u0003s\u0014iA!\u0005\"\u0005\t=\u0011AQ*fe&\fG.\u001b>fe\u0002rwn\u001e\u0011j]\u000edW\u000fZ3tA\u0005\u0004C-\u001a4bk2$\b%\\3uQ>$\u0007\u0005\u001e5bi\u0002\u0002(o\u001c<jI\u0016\u001c\b\u0005\u001e5fA!,\u0017\rZ3sg\u0006\u0012!1C\u0001\u0004e9\n\u0014!\t;fgRDU-\u00193feN\u001cVM]5bY&TXM\u001d#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bF\u0001\fq\u0003I!Xm\u001d;NCb\u0004v\u000e\u001c7SK\u000e|'\u000fZ:)\u0005]\u0001\u0018!\u0006;fgRl\u0015\r\u001f)pY2Le\u000e^3sm\u0006dWj\u001d\u0015\u00031A\fa\u0005^3ti6\u000b\u0007\u0010U8mY&sG/\u001a:wC2l5\u000fR3mCfLeNU3w_\u000e\fG/[8oQ\tI\u0002/\u0001\u0014uKN$X*\u0019=Q_2d\u0017J\u001c;feZ\fG.T:EK2\f\u00170\u00138BgNLwM\\7f]RD#A\u00079\u0002+Q,7\u000f^!vi>\u001cu.\\7ji>s7\t\\8tK\"\u00121\u0004]\u0001!i\u0016\u001cH/Q;u_\u000e{W.\\5u\u001f:\u001cEn\\:f\u0003\u001a$XM],bW\u0016,\b\u000f\u000b\u0002\u001da\u0006\u0019B/Z:u\u0003V$xn\u00144gg\u0016$(+Z:fi\"\u0012Q\u0004]\u0001\u0015i\u0016\u001cHo\u0012:pkB\u001cuN\\:v[B$\u0018n\u001c8)\u0005y\u0001\u0018a\u0006;fgR\u0004\u0016\r\u001e;fe:\u001cVOY:de&\u0004H/[8oQ\ty\u0002/A\u0011uKN$8+\u001e2tKF,XM\u001c;QCR$XM\u001d8Tk\n\u001c8M]5qi&|g\u000e\u000b\u0002!a\u0006IB/Z:u!\u0006$H/\u001a:o+:\u001cXOY:de&\u0004H/[8oQ\t\t\u0003/\u0001\nuKN$8i\\7nSRlU\r^1eCR\f\u0007F\u0001\u0012q\u0003=!Xm\u001d;Bgft7mQ8n[&$\bFA\u0012q\u0003}!Xm\u001d;FqB\fg\u000eZ5oOR{\u0007/[2Tk\n\u001c8M]5qi&|gn\u001d\u0015\u0003IA\fq\u0004^3tiNC'/\u001b8lS:<Gk\u001c9jGN+(m]2sSB$\u0018n\u001c8tQ\t)\u0003/A\tuKN$\b+\u0019:uSRLwN\\:G_JD#A\n9\u00027Q,7\u000f\u001e)beRLG/[8og\u001a{'/Q;u_\u000e\u0013X-\u0019;fQ\t9\u0003/A\u000fuKN$\b+\u0019:uSRLwN\\:G_JLeN^1mS\u0012$v\u000e]5dQ\tA\u0003/\u0001\u0005uKN$8+Z3lQ\tI\u0003/\u0001\ftK:$7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3t)\u0015I'\u0011\u000eB:\u0011\u001d\u0011YG\u000ba\u0001\u0005[\n!B\\;n%\u0016\u001cwN\u001d3t!\rQ'qN\u0005\u0004\u0005cZ'aA%oi\"9!Q\u000f\u0016A\u0002\t]\u0014A\u0001;q!\u0011\u0011IHa\u001f\u000e\u0005\u0005M\u0011\u0002\u0002B?\u0003'\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u000buKN$\bk\\:ji&|g.\u00118e\u0007>lW.\u001b;)\u0005-\u0002\u0018a\u0007;fgR\u0004\u0016M\u001d;ji&|g\u000eU1vg\u0016\fe\u000e\u001a*fgVlW\r\u000b\u0002-a\u00061B/Z:u\r\u0016$8\r[%om\u0006d\u0017\u000eZ(gMN,G\u000f\u000b\u0002.a\u00061C/Z:u\r\u0016$8\r\u001b*fG>\u0014H\rT1sO\u0016\u0014H\u000b[1o\r\u0016$8\r['bq\nKH/Z:)\u00059\u0002\u0018\u0001E2iK\u000e\\G*\u0019:hKJ+7m\u001c:e)\rI'1\u0013\u0005\b\u0005+{\u0003\u0019\u0001B7\u0003I\u0001(o\u001c3vG\u0016\u0014(+Z2pe\u0012\u001c\u0016N_3\u0002]Q,7\u000f\u001e$fi\u000eD\u0007j\u001c8pkJ\u001ch)\u001a;dQNK'0Z%g\u0019\u0006\u0014x-\u001a*fG>\u0014HMT8u\r&\u00148\u000f\u001e\u0015\u0003aA\f!f\u00195fG.4U\r^2i\u0011>tw.\u001e:t'&TX-\u00134MCJ<WMU3d_J$gj\u001c;GSJ\u001cH\u000fF\u0002j\u0005?CqA!)2\u0001\u0004\u0011i'A\fmCJ<W\r\u0015:pIV\u001cWM\u001d*fG>\u0014HmU5{K\u0006YD/Z:u\r\u0016$8\r\u001b%p]>,(o]'bqB\u000b'\u000f^5uS>tg)\u001a;dQ\nKH/Z:JM2\u000b'oZ3SK\u000e|'\u000f\u001a(pi\u001aK'o\u001d;)\u0005I\u0002\u0018a\f;fgR4U\r^2i%\u0016\u001cwN\u001d3MCJ<WM\u001d+iC:l\u0015\r\u001f)beRLG/[8o\r\u0016$8\r\u001b\"zi\u0016\u001c\bFA\u001aq\u0003%\"Xm\u001d;M_^l\u0015\r\u001f$fi\u000eD7+\u001b>f\r>\u0014(+Z9vKN$\u0018I\u001c3QCJ$\u0018\u000e^5p]\"\u0012A\u0007]\u0001\u0019i\u0016\u001cHOU8v]\u0012\u0014vNY5o\u0003N\u001c\u0018n\u001a8nK:$\bFA\u001bq\u0003\u0015\"Xm\u001d;Nk2$\u0018nQ8ogVlWM\u001d*pk:$'k\u001c2j]\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u00027a\u0006\tC/Z:u\u001bVdG/[\"p]N,X.\u001a:Ti&\u001c7._!tg&<g.\\3oi\"\u0012q\u0007]\u0001#i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u0014H)\u001a4bk2$\u0018i]:jO:lWM\u001c;)\u0005a\u0002\u0018\u0001\f;fgRlU\u000f\u001c;j\u0007>t7/^7feN+7o]5p]RKW.Z8vi>s7\u000b^8q!>dG.\u001b8hQ\tI\u0004/\u0001\u0014uKN$X*\u001e7uS\u000e{gn];nKJ\u001cVm]:j_:$\u0016.\\3pkR|en\u00117pg\u0016D#A\u000f9\u0002!Q,7\u000f^%oi\u0016\u00148-\u001a9u_J\u001c\bFA\u001eq\u0003]!Xm\u001d;BkR|7i\\7nSRLe\u000e^3sG\u0016\u0004H\u000f\u000b\u0002=a\u0006\tC/Z:u\u0013:$XM]2faR|'o],ji\"<&o\u001c8h\u0017\u0016Lh+\u00197vK\"\u0012Q\b]\u0001\"i\u0016\u001cHoQ8ogVlW-T3tg\u0006<Wm],ji\"\u001c%/Z1uKRKW.\u001a\u0015\u0003}A\fA\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u0015\u0003\u007fA\fa\u0002^3ti2K7\u000f\u001e+pa&\u001c7\u000f\u000b\u0002Aa\u0006\u0019B/Z:u\u001f\u001a47/\u001a;t\r>\u0014H+[7fg\"\u0012\u0011\t]\u0001\u001ci\u0016\u001cH/R1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r^:)\u0005\t\u0003\u0018\u0001\u0006;fgR,fn];cg\u000e\u0014\u0018NY3U_BL7\r\u000b\u0002Da\u0006)C/Z:u!\u0006,8/Z*uCR,gj\u001c;Qe\u0016\u001cXM\u001d<fI\nK(+\u001a2bY\u0006t7-\u001a\u0015\u0003\tB\f!\u0004^3ti\u000e{W.\\5u'B,7-\u001b4jK\u0012|eMZ:fiND#!\u00129\u00023Q,7\u000f^!vi>\u001cu.\\7ji>s'+\u001a2bY\u0006t7-\u001a\u0015\u0003\rB\fq\u0006^3tiB+'\u000fU1si&$\u0018n\u001c8MK\u0006$W*\u001a;sS\u000e\u001c8\t\\3b]V\u0003x+\u001b;i'V\u00147o\u0019:jE\u0016D#a\u00129\u0002]Q,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Y4NKR\u0014\u0018nY:DY\u0016\fg.\u00169XSRD7+\u001e2tGJL'-\u001a\u0015\u0003\u0011B\fA\u0006^3tiB+'\u000fU1si&$\u0018n\u001c8MK\u0006$W*\u001a;sS\u000e\u001c8\t\\3b]V\u0003x+\u001b;i\u0003N\u001c\u0018n\u001a8)\u0005%\u0003\u0018a\u000b;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0006<W*\u001a;sS\u000e\u001c8\t\\3b]V\u0003x+\u001b;i\u0003N\u001c\u0018n\u001a8)\u0005)\u0003\u0018a\u000b;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0006<W*\u001a;sS\u000e\u001cx\u000b[3o%\u0016\fGmQ8n[&$H/\u001a3)\u0005-\u0003\u0018A\n;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0016\fGmV5uQ6\u000b\u0007\u0010U8mYJ+7m\u001c:eg\"\u0012A\n]\u0001&i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:d\u0015mZ,ji\"l\u0015\r\u001f)pY2\u0014VmY8sIND#!\u00149\u0002]Q,7\u000f^)v_R\fW*\u001a;sS\u000e\u001chj\u001c;De\u0016\fG/\u001a3JM:{\u0017+^8uCN\u001cuN\u001c4jOV\u0014X\r\u001a\u0015\u0003\u001dB\f!E];o\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;UKN$HcA5\u0004\u001c!91QD(A\u0002\u0005\r\u0016!D2m_N,7i\u001c8tk6,'/\u0001\ntk\n\u001c8M]5cK\u000e{gn];nKJ\u001cHCBB\u0012\u0007\u007f\u0019)\u0006\u0005\u0004\u0004&\r=21G\u0007\u0003\u0007OQAa!\u000b\u0004,\u00059Q.\u001e;bE2,'bAB\u0017W\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\rE2q\u0005\u0002\u0007\u0005V4g-\u001a:\u0011\t\rU2qG\u0007\u0002\u0001%!1\u0011HB\u001e\u0005a\u0019uN\\:v[\u0016\u0014\u0018i]:jO:lWM\u001c;Q_2dWM]\u0005\u0004\u0007{Q&\u0001F!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s)\u0016\u001cH\u000fC\u0004\u0004BA\u0003\raa\u0011\u0002\u001b\r|gn];nKJ<%o\\;q!\u0019\u0019)ca\f\u0004FAA1qIB)\u0003C\t\t#\u0004\u0002\u0004J)!11JB'\u0003!\u0019wN\\:v[\u0016\u0014(\u0002BB(\u0003/\tqa\u00197jK:$8/\u0003\u0003\u0004T\r%#!D&bM.\f7i\u001c8tk6,'\u000fC\u0004\u0004XA\u0003\ra!\u0017\u0002#Q|\u0007/[2t)>\u001cVOY:de&\u0014W\r\u0005\u0004\u0004\\\r\u0015\u0014\u0011\n\b\u0005\u0007;\u001a\tG\u0004\u0003\u0002P\r}\u0013\"\u00017\n\u0007\r\r4.A\u0004qC\u000e\\\u0017mZ3\n\t\r\u001d4\u0011\u000e\u0002\u0005\u0019&\u001cHOC\u0002\u0004d-\f\u0011d\u0019:fCR,Gk\u001c9jG\u0006sGmU3oIJ+7m\u001c:egRQ1qNB;\u0007\u0007\u001b9ia#\u0011\r\u0005-3\u0011\u000fB<\u0013\u0011\u0019\u0019(!\u0018\u0003\u0007M+G\u000fC\u0004\u0004xE\u0003\ra!\u001f\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002ba\u001f\u0004\u0000\u0005\u0005\u0012\u0011E\u0007\u0003\u0007{RAaa\u001e\u0004N%!1\u0011QB?\u00055Y\u0015MZ6b!J|G-^2fe\"91QQ)A\u0002\u0005%\u0013!\u0003;pa&\u001cg*Y7f\u0011\u001d\u0019I)\u0015a\u0001\u0005[\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bbBBG#\u0002\u0007!QN\u0001\u0014e\u0016\u001cwN\u001d3t!\u0016\u0014\b+\u0019:uSRLwN\\\u0001(GJ,\u0017\r^3D_:\u001cX/\\3s\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0004\u0014\u000ee5QTBP!\u001dQ7QSB\"\u0007GI1aa&l\u0005\u0019!V\u000f\u001d7fe!911\u0014*A\u0002\t5\u0014!D2p]N,X.\u001a:D_VtG\u000fC\u0004\u0004XI\u0003\ra!\u0017\t\u000f\r\u0005&\u000b1\u0001\u0004p\u0005i1/\u001e2tGJL\u0007\u000f^5p]N\fAg\u00195b]\u001e,7i\u001c8tk6,'o\u0012:pkB\u001cVOY:de&\u0004H/[8o\u0003:$g+\u00197jI\u0006$X-Q:tS\u001etW.\u001a8u)\u001dI7qUBV\u0007[Cqa!+T\u0001\u0004\u0019\u0019#A\bd_:\u001cX/\\3s!>dG.\u001a:t\u0011\u001d\u00199f\u0015a\u0001\u00073Bqa!)T\u0001\u0004\u0019y'A\u0018dQ\u0006tw-Z\"p]N,X.\u001a:Tk\n\u001c8M]5qi&|g.\u00118e-\u0006d\u0017\u000eZ1uK\u0006\u001b8/[4o[\u0016tG/\u0006\u0004\u00044\u000e}6Q\u0019\u000b\nS\u000eU6\u0011ZBf\u0007\u001fDqaa\u0013U\u0001\u0004\u00199\f\u0005\u0005\u0004H\re6QXBb\u0013\u0011\u0019Yl!\u0013\u0003\u0011\r{gn];nKJ\u0004B!a#\u0004@\u001291\u0011\u0019+C\u0002\u0005E%!A&\u0011\t\u0005-5Q\u0019\u0003\b\u0007\u000f$&\u0019AAI\u0005\u00051\u0006bBB,)\u0002\u00071\u0011\f\u0005\b\u0007\u001b$\u0006\u0019AB8\u0003I)\u0007\u0010]3di\u0016$\u0017i]:jO:lWM\u001c;\t\u000f\rEG\u000b1\u0001\u0004T\u0006\t\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\u0011\t\r\u001d3Q[\u0005\u0005\u0007/\u001cIEA\rD_:\u001cX/\\3s%\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\u0018\u0001F1xC&$hj\u001c8F[B$\u0018PU3d_J$7/\u0006\u0004\u0004^\u000e\u001d81\u001e\u000b\u0007\u0007?\u001cio!=\u0011\u0011\r\u001d3\u0011]Bs\u0007SLAaa9\u0004J\ty1i\u001c8tk6,'OU3d_J$7\u000f\u0005\u0003\u0002\f\u000e\u001dHaBBa+\n\u0007\u0011\u0011\u0013\t\u0005\u0003\u0017\u001bY\u000fB\u0004\u0004HV\u0013\r!!%\t\u000f\r-S\u000b1\u0001\u0004pBA1qIB]\u0007K\u001cI\u000fC\u0004\u0004tV\u0003\rAa\u001e\u0002\u0013A\f'\u000f^5uS>t\u0017aD1xC&$\u0018i]:jO:lWM\u001c;\u0015\u000b%\u001cI\u0010b\u0003\t\u000f\r-c\u000b1\u0001\u0004|B21Q C\u0001\t\u000f\u0001\u0002ba\u0012\u0004:\u000e}HQ\u0001\t\u0005\u0003\u0017#\t\u0001\u0002\u0007\u0005\u0004\re\u0018\u0011!A\u0001\u0006\u0003\t\tJA\u0002`IM\u0002B!a#\u0005\b\u0011aA\u0011BB}\u0003\u0003\u0005\tQ!\u0001\u0002\u0012\n\u0019q\f\n\u001b\t\u000f\r5g\u000b1\u0001\u0004p\u0005aB/Z:u\u0007>t7/^7j]\u001e<\u0016\u000e\u001e5Ok2dwI]8va&#\u0007FA,q\u0003u!Xm\u001d;D_:\u001cX/\\5oO^KG\u000f[#naRLxI]8va&#\u0007F\u0001-q\u0001")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testHeaders() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Header header = ((ConsumerRecord)records.apply(i)).headers().lastHeader("headerKey");
            Assertions.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3()).send(record);
        KafkaConsumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
    }

    @Test
    public void testDeprecatedPollBlocksForAssignment() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        consumer.poll(0L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(consumer.assignment()).asScala());
    }

    @Test
    public void testHeadersExtendedSerializerDeserializer() {
        ExtendedSerializer<byte[]> extendedSerializer = new ExtendedSerializer<byte[]>(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return SerializerImpl.serialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                SerializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                SerializerImpl.close$(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return SerializerImpl.serialize$(this, topic, data);
            }

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                SerializerImpl.$init$(this);
            }
        };
        ExtendedDeserializer<byte[]> extendedDeserializer = new ExtendedDeserializer<byte[]>(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                DeserializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                DeserializerImpl.close$(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, data);
            }

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                DeserializerImpl.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize((Serializer<byte[]>)extendedSerializer, (Deserializer<byte[]>)extendedDeserializer);
    }

    @Test
    public void testHeadersSerializerDeserializer() {
        SerializerImpl extendedSerializer = new SerializerImpl(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return SerializerImpl.serialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                SerializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                SerializerImpl.close$(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return SerializerImpl.serialize$(this, topic, data);
            }

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                SerializerImpl.$init$(this);
            }
        };
        DeserializerImpl extendedDeserializer = new DeserializerImpl(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                DeserializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                DeserializerImpl.close$(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, data);
            }

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                DeserializerImpl.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        int x$6 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, x$6, startingTimestamp, x$7, x$8, maxPollRecords);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(2000));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        Thread.sleep(3000L);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((int)2, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
    }

    @Test
    public void testMaxPollIntervalMsDelayInRevocation() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this, committedPosition, consumer, commitCompleted){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final LongRef committedPosition$1;
            private final KafkaConsumer consumer$1;
            private final BooleanRef commitCompleted$1;

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (!partitions.isEmpty() && partitions.contains(this.$outer.tp())) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.committedPosition$1 = committedPosition$1;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"otherTopic"}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((long)0L, (long)committedPosition.elem);
        Assertions.assertTrue((boolean)commitCompleted.elem);
    }

    @Test
    public void testMaxPollIntervalMsDelayInAssignment() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        this.ensureNoRebalance((Consumer<?, ?>)consumer, listener);
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.wakeup();
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @Test
    public void testGroupConsumption() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 10, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1), this.sendRecords$default$4());
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1), this.sendRecords$default$4());
        assignment = (scala.collection.immutable.Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0), this.sendRecords$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0), this.sendRecords$default$4());
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        assignment = (scala.collection.immutable.Set)assignment.$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        assignment = (scala.collection.immutable.Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, Optional.of(Predef$.MODULE$.int2Integer(15)), "foo");
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assertions.assertEquals((Object)syncMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)asyncMetadata)}))));
        Assertions.assertEquals((Object)asyncMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)nullMetadata)}))).asJava());
        Assertions.assertEquals((Object)nullMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @Test
    public void testAsyncCommit() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        AbstractConsumerTest.CountConsumerCommitCallback callback = new AbstractConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)callback));
        long pollUntilTrue_waitTimeMs = 10000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (PlaintextConsumerTest.$anonfun$testAsyncCommit$2(callback, count)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to observe commit callback before timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)None$.MODULE$, callback.lastError());
        Assertions.assertEquals((int)count, (int)callback.successCount());
        Assertions.assertEquals((Object)new OffsetAndMetadata((long)count), consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4());
        scala.collection.immutable.Set expandedAssignment = (scala.collection.immutable.Set)initialAssignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expandedAssignment);
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4());
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        scala.collection.immutable.Set shrunkenAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)shrunkenAssignment);
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        this.createTopic("part-test", numParts, 1, this.createTopic$default$4());
        java.util.List parts = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("part-test");
        Assertions.assertNotNull((Object)parts);
        Assertions.assertEquals((int)2, (int)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.partitionsFor("non-exist-topic");
        Assertions.assertFalse((boolean)consumer.partitionsFor("non-exist-topic").isEmpty());
    }

    @Test
    public void testPartitionsForInvalidTopic() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(InvalidTopicException.class, () -> consumer.partitionsFor(";3# ads,{234"));
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()));
        long x$4 = startingTimestamp;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, x$5, x$4, x$6, x$7, x$8);
        consumer.seek(this.tp(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp2()));
        TopicPartition x$12 = this.tp2();
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, x$13, x$14, x$15, x$12, x$16);
        consumer.seek(this.tp2(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        int x$19 = (int)mid;
        int x$20 = (int)mid;
        TopicPartition x$22 = this.tp2();
        TimestampType x$23 = this.consumeAndVerifyRecords$default$6();
        int x$24 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, x$19, x$20, mid, x$23, x$22, x$24);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", Integer.toString(Integer.MAX_VALUE));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, producerProps);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes())));
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertNull(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))).asJava()).get(topicPartition));
        Assertions.assertThrows(IllegalStateException.class, () -> consumer.position(topicPartition));
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()), (String)"position() on a partition that we are subscribed to should reset the offset");
        consumer.commitSync();
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        Assertions.assertEquals((long)5L, (long)consumer.position(this.tp()), (String)"After consuming 5 records, position should be 5");
        consumer.commitSync();
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset(), (String)"Committed offset should be returned");
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        KafkaConsumer otherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        otherConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)otherConsumer, 1, 5, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)partitions);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)partitions);
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(100L)).isEmpty());
        consumer.resume((Collection)partitions);
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 5, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp(), this.sendRecords$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer.poll(Duration.ofMillis(15000L)));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        java.util.Map outOfRangePartitions = ((OffsetOutOfRangeException)Assertions.assertThrows(OffsetOutOfRangeException.class, () -> consumer.poll(Duration.ofMillis(20000L)))).offsetOutOfRangePartitions();
        Assertions.assertNotNull((Object)outOfRangePartitions);
        Assertions.assertEquals((int)1, (int)outOfRangePartitions.size());
        Assertions.assertEquals((long)outOfRangePos, (Long)((Long)outOfRangePartitions.get(this.tp())));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(20000));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        scala.collection.immutable.Seq topics = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}));
        topics.foreach((Function1 & Serializable)topicName -> this.createTopic((String)topicName, partitionCount, this.brokerCount(), this.createTopic$default$4()));
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)topics.flatMap((Function1 & Serializable)topic -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1 & Serializable)x$1 -> PlaintextConsumerTest.$anonfun$testLowMaxFetchSizeForRequestAndPartition$3(topic, BoxesRunTime.unboxToInt((Object)x$1))));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)partitions.toSet());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Seq producerRecords = (scala.collection.immutable.Seq)partitions.flatMap((Function1 & Serializable)x$2 -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, partitionCount, (TopicPartition)x$2, this.sendRecords$default$4()));
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((IterableOnceOps)producerRecords.map((Function1 & Serializable)record -> new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp()))).toSet();
        scala.collection.immutable.Set actual = ((IterableOnceOps)consumerRecords.map((Function1 & Serializable)record -> new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp())))).toSet();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        void var7_7;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        try {
            void var6_6;
            this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var7_7, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)var6_6, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var7_7, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))), (scala.collection.immutable.Set<TopicPartition>)subscriptions, "roundrobin-group");
        }
        finally {
            var7_7.foreach((Function1 & Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerStickyAssignment() {
        void var6_6;
        void var7_7;
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var7_7, partitions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
        scala.collection.immutable.Map prePartition2PollerId = PlaintextConsumerTest.reverse$1(((IterableOnceOps)var7_7.map((Function1 & Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)var6_6, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var7_7, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), partitions, "sticky-group");
        scala.collection.immutable.Map postPartition2PollerId = PlaintextConsumerTest.reverse$1(((IterableOnceOps)var7_7.map((Function1 & Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((Set)postPartition2PollerId.keySet());
        IntRef changes = IntRef.create((int)0);
        keys.foreach((Function1 & Serializable)key -> {
            PlaintextConsumerTest.$anonfun$testMultiConsumerStickyAssignment$5(prePartition2PollerId, postPartition2PollerId, changes, key);
            return BoxedUnit.UNIT;
        });
        var7_7.foreach((Function1 & Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)rand, (int)changes.elem, (String)"Expected only two topic partitions that have switched to other consumers.");
    }

    @Test
    public void testMultiConsumerDefaultAssignment() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.addConsumersToGroupAndWaitForGroupAssignment$default$6());
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2}))), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString()))).foreach((Function1 & Serializable)x$9 -> (RecordMetadata)x$9.get());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        Assertions.assertThrows(Throwable.class, () -> testProducer.send(null), () -> "Should not allow sending a null record");
        Assertions.assertEquals((int)1, (int)MockProducerInterceptor.ON_ERROR_COUNT.intValue(), (String)"Interceptor should be notified about exception");
        Assertions.assertEquals((int)0, (int)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue(), (String)"Interceptor should not receive metadata with an exception when record is null");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(i).toString(), (Object)new String((String)record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(i).append(appendStr).toString().toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
        });
        int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 1), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        this.sendAndAwaitAsyncCommit(testConsumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata(5L))}))));
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 2), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        int numRecords = 100;
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString()))).foreach((Function1 & Serializable)x$10 -> (RecordMetadata)x$10.get());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)"value will not be modified".getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ConsumerRecord record = (ConsumerRecord)this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3()).head();
        Assertions.assertEquals((Object)"value will not be modified", (Object)new String((byte[])record.value()));
    }

    @Test
    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        TopicPartition x$11 = this.tp2();
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, x$13, x$14, x$15, x$11, x$16);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps);
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1, this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1}))).asJava());
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, 0, startTime, TimestampType.LOG_APPEND_TIME, tp1, x$8);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, 0, startTime, TimestampType.LOG_APPEND_TIME, tp2, x$16);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        java.util.Map topics = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).listTopics();
        Assertions.assertNotNull((Object)topics);
        Assertions.assertEquals((int)5, (int)topics.size());
        Assertions.assertEquals((int)5, (int)topics.keySet().size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic1)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic2)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testOffsetsForTimes() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, props);
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(IllegalArgumentException.class, () -> consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition(topic1, 0), Predef$.MODULE$.long2Long(-1L))));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).foreach((Function1 & Serializable)topic -> {
            PlaintextConsumerTest.$anonfun$testOffsetsForTimes$2(this, numParts, producer, timestampsToSearch, i, topic);
            return BoxedUnit.UNIT;
        });
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        OffsetAndTimestamp timestampTopic1P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0));
        Assertions.assertEquals((long)0L, (long)timestampTopic1P0.offset());
        Assertions.assertEquals((long)0L, (long)timestampTopic1P0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P0.leaderEpoch());
        OffsetAndTimestamp timestampTopic1P1 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1));
        Assertions.assertEquals((long)20L, (long)timestampTopic1P1.offset());
        Assertions.assertEquals((long)20L, (long)timestampTopic1P1.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P1.leaderEpoch());
        Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic2, 0)), (String)"null should be returned when message format is 0.9.0");
        Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic2, 1)), (String)"null should be returned when message format is 0.9.0");
        OffsetAndTimestamp timestampTopic3P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0));
        Assertions.assertEquals((long)80L, (long)timestampTopic3P0.offset());
        Assertions.assertEquals((long)80L, (long)timestampTopic3P0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic3P0.leaderEpoch());
        Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic3, 1)));
    }

    @Test
    public void testEarliestOrLatestOffsets() {
        String topic0 = "topicWithNewMessageFormat";
        String topic1 = "topicWithOldMessageFormat";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.createTopicAndSendRecords(producer, topic0, 2, 100);
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, 1, 1, props);
        this.sendRecords(producer, 100, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        TopicPartition t0p0 = new TopicPartition(topic0, 0);
        TopicPartition t0p1 = new TopicPartition(topic0, 1);
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        java.util.Set partitions = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{t0p0, t0p1, t1p0}))).asJava();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t0p0)));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t0p1)));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t1p0)));
        java.util.Map latests = consumer.endOffsets((Collection)partitions);
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t0p0)));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t0p1)));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t1p0)));
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic2"}))).asJava());
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 0, 5, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 7, this.tp2(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).asJava());
        long pos1 = consumer.position(this.tp());
        long pos2 = consumer.position(this.tp2());
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertNull(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2()));
        Assertions.assertEquals((long)pos1, (long)consumer.position(this.tp()));
        Assertions.assertEquals((long)pos2, (long)consumer.position(this.tp2()));
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)new OffsetAndMetadata(7L))}))));
        Assertions.assertEquals((long)7L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, consumer){
            private final KafkaConsumer consumer$7;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer$7.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer$7 = consumer$7;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), rebalanceListener);
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newAssignment);
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLead0);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead0.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLead);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assertions.assertNull(consumer.metrics().get(new MetricName(new StringBuilder(12).append(this.tp().toString()).append(".records-lag").toString(), "consumer-fetch-manager-metrics", "", tags)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsWhenReadCommitted() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Assertions.assertNotNull((Object)((Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags))));
    }

    @Test
    public void testPerPartitionLeadWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)maxPollRecords, (double)BoxesRunTime.unboxToDouble((Object)lead.metricValue()), (String)new StringBuilder(19).append("The lead should be ").append(maxPollRecords).toString());
    }

    @Test
    public void testPerPartitionLagWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)(numMessages - records.count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(numMessages - records.count()).toString());
    }

    @Test
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured() {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seek(this.tp(), 0L);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        this.servers().foreach((Function1 & Serializable)x$11 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$11, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$12 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$12, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$13 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$13, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$14 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$14, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$15 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$15, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$16 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$16, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$17 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$17, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$18 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$18, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)broker -> {
            PlaintextConsumerTest.assertNoExemptRequestMetric$1(broker);
            return BoxedUnit.UNIT;
        });
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), this.subscribeConsumerAndStartPolling$default$3()));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), this.subscribeConsumerAndStartPolling$default$3()));
        KafkaConsumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), this.subscribeConsumerAndStartPolling$default$3());
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        consumerPollers.$minus$eq((Object)timeoutPoller);
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, (Option<String>)new Some((Object)new StringBuilder(68).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.SetHasAsJava((Set)subscriptions).asJava()).append(" after one consumer left").toString()), 3L * this.groupMaxSessionTimeoutMs());
        consumerPollers.foreach((Function1 & Serializable)poller -> {
            poller.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1 & Serializable)consumer -> (Buffer)consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, topicsToSubscribe, this.subscribeConsumerAndStartPolling$default$3())));
        return var3_3;
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(KafkaProducer<byte[], byte[]> producer, String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.brokerCount(), this.createTopic$default$4());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            TopicPartition tp = new TopicPartition(topicName, partition);
            this.sendRecords(producer, recordsPerPartition, tp, this.sendRecords$default$4());
            parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)parts$1.elem).$plus((Object)tp);
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assertions.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1 & Serializable)x$19 -> PlaintextConsumerTest.$anonfun$createConsumerGroupAndWaitForAssignment$1(this, consumerGroup, BoxesRunTime.unboxToInt((Object)x$19)));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1 & Serializable)poller -> {
            poller.subscribe((List<String>)topicsToSubscribe);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 1000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!consumerPollers.forall((Function1 & Serializable)poller -> BoxesRunTime.boxToBoolean((boolean)poller.isSubscribeRequestProcessed()))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$changeConsumerGroupSubscriptionAndValidateAssignment$4(subscriptions));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        this.validateGroupAssignment(consumerPollers, subscriptions, (Option<String>)new Some((Object)new StringBuilder(74).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.SetHasAsJava(subscriptions).asJava()).append(" after we changed subscription").toString()), this.validateGroupAssignment$default$4());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> expectedAssignment, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topicsToSubscribe).asJava(), rebalanceListener);
        this.awaitAssignment(consumer, expectedAssignment);
    }

    private <K, V> ConsumerRecords<K, V> awaitNonEmptyRecords(Consumer<K, V> consumer, TopicPartition partition) {
        Object object = new Object();
        try {
            ConsumerRecords consumerRecords;
            long l = 15000L;
            long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
            long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$1(partition, object, consumerRecords = consumer.poll(Duration.ofMillis(100L)))) {
                if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + l) {
                    Assertions.fail((String)PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$2(partition));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pollRecordsUntilTrue_waitUntilTrue_pause));
            }
            throw new IllegalStateException("Should have timed out before reaching here");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ConsumerRecords)ex.value();
            }
            throw ex;
        }
    }

    private void awaitAssignment(Consumer<?, ?> consumer, scala.collection.immutable.Set<TopicPartition> expectedAssignment) {
        long l = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (PlaintextConsumerTest.$anonfun$awaitAssignment$1(consumer, expectedAssignment)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + l) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$awaitAssignment$2(expectedAssignment, consumer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    @Test
    public void testConsumingWithNullGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testConsumingWithNullGroupId$1(this, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Failed to create topic");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k3".getBytes(), (Object)"v3".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        List x$2 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        KafkaConsumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("client.id", "consumer2");
        List x$6 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$7 = this.createConsumer$default$1();
        ByteArrayDeserializer x$8 = this.createConsumer$default$2();
        KafkaConsumer consumer2 = this.createConsumer(x$7, x$8, consumer2Config, (List<String>)x$6);
        Properties consumer3Config = new Properties(this.consumerConfig());
        consumer3Config.put("client.id", "consumer3");
        List x$10 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$11 = this.createConsumer$default$1();
        ByteArrayDeserializer x$12 = this.createConsumer$default$2();
        KafkaConsumer consumer3 = this.createConsumer(x$11, x$12, consumer3Config, (List<String>)x$10);
        consumer1.assign(Arrays.asList(tp));
        consumer2.assign(Arrays.asList(tp));
        consumer3.assign(Arrays.asList(tp));
        consumer3.seek(tp, 1L);
        int numRecords1 = consumer1.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer2.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()));
        int numRecords2 = consumer2.poll(Duration.ofMillis(5000L)).count();
        int numRecords3 = consumer3.poll(Duration.ofMillis(5000L)).count();
        consumer1.unsubscribe();
        consumer2.unsubscribe();
        consumer3.unsubscribe();
        consumer1.close();
        consumer2.close();
        consumer3.close();
        Assertions.assertEquals((int)3, (int)numRecords1, (String)"Expected consumer1 to consume from earliest offset");
        Assertions.assertEquals((int)0, (int)numRecords2, (String)"Expected consumer2 to consume from latest offset");
        Assertions.assertEquals((int)2, (int)numRecords3, (String)"Expected consumer3 to consume from offset 1");
    }

    @Test
    public void testConsumingWithEmptyGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testConsumingWithEmptyGroupId$1(this, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Failed to create topic");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("group.id", "");
        consumer1Config.put("client.id", "consumer1");
        consumer1Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer1 = this.createConsumer(x$2, x$3, consumer1Config, x$4);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("group.id", "");
        consumer2Config.put("client.id", "consumer2");
        consumer2Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        KafkaConsumer consumer2 = this.createConsumer(x$6, x$7, consumer2Config, x$8);
        consumer1.assign(Arrays.asList(tp));
        consumer2.assign(Arrays.asList(tp));
        ConsumerRecords records1 = consumer1.poll(Duration.ofMillis(5000L));
        consumer1.commitSync();
        ConsumerRecords records2 = consumer2.poll(Duration.ofMillis(5000L));
        consumer2.commitSync();
        consumer1.close();
        consumer2.close();
        Assertions.assertTrue((records1.count() == 1 && ((ConsumerRecord)CollectionConverters$.MODULE$.ListHasAsScala(records1.records(tp)).asScala().head()).offset() == 0L ? 1 : 0) != 0, (String)"Expected consumer1 to consume one message from offset 0");
        Assertions.assertTrue((records2.count() == 1 && ((ConsumerRecord)CollectionConverters$.MODULE$.ListHasAsScala(records2.records(tp)).asScala().head()).offset() == 1L ? 1 : 0) != 0, (String)"Expected consumer2 to consume one message from offset 1, which is the committed offset of consumer1");
    }

    public static final /* synthetic */ boolean $anonfun$testAsyncCommit$2(AbstractConsumerTest.CountConsumerCommitCallback callback$1, int count$1) {
        return callback$1.successCount() >= count$1 || callback$1.lastError().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAsyncCommit$3() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ TopicPartition $anonfun$testLowMaxFetchSizeForRequestAndPartition$3(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    private static final scala.collection.immutable.Map reverse$1(scala.collection.immutable.Map m) {
        return ((IterableOnceOps)((IterableOps)m.values().toSet().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)v -> new Tuple2(v, ((IterableOps)m.keys().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> ((SetOps)m.apply((Object)BoxesRunTime.boxToLong((long)x$5))).contains(v))).head()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$testMultiConsumerStickyAssignment$5(scala.collection.immutable.Map prePartition2PollerId$1, scala.collection.immutable.Map postPartition2PollerId$1, IntRef changes$1, TopicPartition key) {
        Option preVal = prePartition2PollerId$1.get((Object)key);
        Option postVal = postPartition2PollerId$1.get((Object)key);
        if (preVal.nonEmpty() && postVal.nonEmpty()) {
            if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                ++changes$1.elem;
                return;
            }
        } else {
            ++changes$1.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$testOffsetsForTimes$2(PlaintextConsumerTest $this, int numParts$1, KafkaProducer producer$3, HashMap timestampsToSearch$1, IntRef i$1, String topic) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numParts$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)part -> {
            TopicPartition tp = new TopicPartition(topic, part);
            $this.sendRecords((KafkaProducer<byte[], byte[]>)producer$3, 100, tp, 0L);
            timestampsToSearch$1.put(tp, Predef$.MODULE$.long2Long((long)(i$1.elem * 20)));
            ++i$1.elem;
        });
    }

    private static final void assertNoMetric$1(KafkaServer broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    private static final void assertNoExemptRequestMetric$1(KafkaServer broker) {
        MetricName metricName = broker.metrics().metricName("exempt-request-time", "Request", "");
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    public static final /* synthetic */ Buffer $anonfun$createConsumerGroupAndWaitForAssignment$1(PlaintextConsumerTest $this, Buffer consumerGroup$1, int x$19) {
        return (Buffer)consumerGroup$1.$plus$eq($this.createConsumer($this.createConsumer$default$1(), $this.createConsumer$default$2(), $this.createConsumer$default$3(), $this.createConsumer$default$4()));
    }

    public static final /* synthetic */ String $anonfun$changeConsumerGroupSubscriptionAndValidateAssignment$4(scala.collection.immutable.Set subscriptions$1) {
        return new StringBuilder(72).append("Failed to call subscribe on all consumers in the group for subscription ").append(subscriptions$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitNonEmptyRecords$1(TopicPartition partition$1, Object nonLocalReturnKey1$1, ConsumerRecords polledRecords) {
        if (CollectionConverters$.MODULE$.ListHasAsScala(polledRecords.records(partition$1)).asScala().nonEmpty()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)polledRecords);
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$awaitNonEmptyRecords$2(TopicPartition partition$1) {
        return new StringBuilder(68).append("Consumer did not consume any messages for partition ").append(partition$1).append(" before timeout.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitAssignment$1(Consumer consumer$8, scala.collection.immutable.Set expectedAssignment$1) {
        java.util.Set set = consumer$8.assignment();
        java.util.Set set2 = CollectionConverters$.MODULE$.SetHasAsJava((Set)expectedAssignment$1).asJava();
        return !(set != null ? !((Object)set).equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$awaitAssignment$2(scala.collection.immutable.Set expectedAssignment$1, Consumer consumer$8) {
        return new StringBuilder(0).append(new StringBuilder(47).append("Timed out while awaiting expected assignment ").append(expectedAssignment$1).append(". ").toString()).append(new StringBuilder(26).append("The current assignment is ").append(consumer$8.assignment()).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumingWithNullGroupId$1(PlaintextConsumerTest $this, String topic$3) {
        return $this.zkClient().topicExists(topic$3);
    }

    public static final /* synthetic */ String $anonfun$testConsumingWithNullGroupId$2() {
        return "Failed to create topic";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumingWithEmptyGroupId$1(PlaintextConsumerTest $this, String topic$4) {
        return $this.zkClient().topicExists(topic$4);
    }

    public static final /* synthetic */ String $anonfun$testConsumingWithEmptyGroupId$2() {
        return "Failed to create topic";
    }

    public static final /* synthetic */ Object $anonfun$awaitNonEmptyRecords$1$adapted(TopicPartition partition$1, Object nonLocalReturnKey1$1, ConsumerRecords polledRecords) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$1(partition$1, nonLocalReturnKey1$1, polledRecords));
    }

    public interface DeserializerImpl
    extends Deserializer<byte[]> {
        public ByteArrayDeserializer deserializer();

        public void deserializer_$eq(ByteArrayDeserializer var1);

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.deserialize(topic, headers, data);
        }

        default public byte[] deserialize(String topic, Headers headers, byte[] data) {
            Header header = headers.lastHeader("content-type");
            Assertions.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
            return this.deserializer().deserialize(topic, data);
        }

        public static /* synthetic */ void configure$(DeserializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.deserializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(DeserializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.deserializer().close();
        }

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, byte[] data) {
            return $this.deserialize(topic, data);
        }

        default public byte[] deserialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer();

        public static void $init$(DeserializerImpl $this) {
            $this.deserializer_$eq(new ByteArrayDeserializer());
        }
    }

    public interface SerializerImpl
    extends Serializer<byte[]> {
        public ByteArraySerializer serializer();

        public void serializer_$eq(ByteArraySerializer var1);

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.serialize(topic, headers, data);
        }

        default public byte[] serialize(String topic, Headers headers, byte[] data) {
            headers.add("content-type", "application/octet-stream".getBytes());
            return this.serializer().serialize(topic, data);
        }

        public static /* synthetic */ void configure$(SerializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.serializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(SerializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.serializer().close();
        }

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, byte[] data) {
            return $this.serialize(topic, data);
        }

        default public byte[] serialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer();

        public static void $init$(SerializerImpl $this) {
            $this.serializer_$eq(new ByteArraySerializer());
        }
    }
}

